# NOTICE_START
# Licensed Materials - Property of IBM
# "Restricted Materials of IBM" -- 5746-SM2
# (C) Copyright IBM Corp. 2007, 2008 All Rights Reserved.
# US Government Users Restricted Rights - Use, duplication or disclosure
# restricted by GSA ADP Schedule Contract with IBM Corp.
# NOTICE_END

package powervm_lx86_scripts::L10N::zh_tw;
use encoding 'utf8';
use base 'powervm_lx86_scripts::L10N';

our %Lexicon =
  (
    _AUTO => 1,

    "New user account ('[_1]') found in [_2]." =>
    "在 [_2] 中找到新的使用者帳號 ([_1])。",

    "Aliased user id ('[_1]') found in [_2]." =>
    "在 [_2] 中找到其他名稱的使用者 ID ([_1])。",

    "New group ('[_1]') found in [_2]." =>
    "在 [_2] 中找到新的群組 ([_1])。",

    "Aliased group id ('[_1]') found in [_2]." =>
    "在 [_2] 中找到其他名稱的群組 ID ([_1])。",

    "You must be root to run this script." =>
    "必須是 root 才可執行此 Script。",

    "Failed to get current set of mount entries." =>
    "無法取得現行裝載項目集。",

    "The powervm-lx86-daemon is not running. Please start the powervm-lx86-daemon." =>
    "powervm-lx86-daemon 未執行。請啟動 powervm-lx86-daemon。",

    "Unrecognised option 'WORLD_CHECK_OR_SYNC=[_1]'." =>
    "無法辨識的選項 WORLD_CHECK_OR_SYNC=[_1]。 ",

    "Directory [_1] does not exist." =>
    "目錄 [_1] 不存在。", 

    "Cannot open \"[_1]\": [_2]." =>
    "無法開啟 \"[_1]\"：[_2]。",

    "Cannot open \"[_1]\" for reading: [_2]." =>
    "無法開啟 \"[_1]\" 來讀取：[_2]。",
    
    "Cannot open \"[_1]\" for writing: [_2]." =>
    "無法開啟 \"[_1]\" 來寫入：[_2]。", 

    "(Unable to run command '[_1] /usr/bin/id [_2]')" =>
    "(無法執行指令 [_1] /usr/bin/id [_2])",

    "_EMAIL_DISABLE" => "(此郵件是由 Cron Script [_1] 所產生，透過設定\n配置參數 WORLD_CHECK_OR_SYNC=none in /etc/opt/powervm-lx86/config) 即可取消。\n",

    "_NEW_USER_EMAIL" => "已在 x86 World 密碼檔 ([_1]) 中找到新的使用者帳號，\nPower 密碼檔不會出現該密碼檔。在 [_2] 中所找到的相關密碼項目\n會在此顯示：\n\n[_3]\n 欄位分別代表使用者帳號、密碼、使用者 ID、主要群組、\n ID、註解、起始目錄以及預設 Shell。此外，\n轉換指令 '/usr/bin/id [_4]' 的輸出會顯示在下方，\n\n 其中 [_5]\n 的第二個欄位會顯示主要的群組，第三個欄位會顯示 [_6] 使用者所屬\n群組的完整清單，其中包括\n主群組及增補群組。\n\n將來若要停止接收此郵件，您可以有兩種選項：第一個選項\n是新增使用者 [_7] 至位於\n/etc/opt/powervm-lx86/user_ignore 中的使用者空白清單。在此狀況下，您無須新增使用者至\n Power 端，以後將會忽略此使用者。第二個選項是自行新增使用者\n至 Power 端。執行方法為 (非必要\n但最完整) 是在原生的 Power Shell 中執行下列指令：\n\n /usr/sbin/useradd -m -d <home directory> [_8]\n\n若要完整抄寫 x86 World 設定，您必須確認\n [_9] 為成員的所有群組存在於 Power 端，\n然後再設定使用者 [_10] 的主要及增補群組。\n\n",

    "_NEW_GROUP_EMAIL" => "已在 x86 World 群組檔 ([_1]) 中找到新的群組帳號，\nPower 群組檔不會出現該密碼檔。在 [_2] 中所找到的相關密碼項目\n會在此顯示：\n\n [_3]\n 欄位分別代表群組帳號、密碼、群組 ID 以及屬於此群組\n成員的使用者。\n\n將來若要停止接收此郵件，您可以有兩種選項：第一個選項\n是新增群組 [_4] 至位於 \n/etc/opt/powervm-lx86/group_ignore 中的群組空白清單。在此狀況下，您無須新增使用者至\n Power 端，以後將會忽略此使用者。第二個選項是自行新增群組\n至 Power 端。執行的方法為 (非必要\n但最完整) 是在原生的 Power Shell 中執行下列指令：\n\n /usr/sbin/groupadd [_5]\n\n",

    "_NEW_UID_ALIAS_EMAIL" => "在 x86 World 密碼檔 ([_1]) 中所找到的使用者帳號，\n與 Power 密碼檔  (/etc/passwd) 中找到的帳號分享相同的使用者 ID ([_2])。\n在 x86 World 檔案 ([_3]) 中找到的相關密碼項目會在此顯示：\n\n [_4]\n 及 Power 檔 (/etc/passwd) 中找到的相關密碼項目會在此顯示：\n\n[_5]\n 欄位分別代表使用者帳號、密碼、使用者 ID、主要群組 ID、\n註解、起始目錄以及預設 Shell。\n\n雖然不太可能，這可能代表重大的安全風險，因為\n對應至使用者 ID [_6] 的 ID 是匿名的。\n\n將來若要停止接收此郵件，您可以有兩種選項：若您認為\n沒有安全風險，那麼您就可以新增使用者 ID [_7] 至位於 /etc/opt/powervm-lx86/uid_ignore 中的空白清單\n檔案。否則，建議您變更 x86 World 中\n [_8] 的使用者 ID 來修改問題。因為可能有 PowerVM Lx86 處理程式正在以使用者 [_9] 的身分執行，修改前\n您「必須」先關閉 PowerVM Lx86，方法是執行以下指令：\n\n/etc/init.d/powervm-lx86 stop。\n\n接下來\n，您需要為使用者 [_10] 選擇新的唯一使用者 ID，以確保此使用者 ID\n 未存在於 x86 World 或 Power 密碼檔。\n變更使用者 [_11] 的使用者 ID 最簡單的方法就是手動編輯 x86 World\n 密碼檔並更新使用者 ID。最後，您必須更新 x86 World 中使用者 [_12] 擁有的所有檔案擁有權。\n更新 x86 World 中檔案的擁有權有數個方法，\n這裡提供一個可讓您執行的簡單指令\n：\n\n/bin/chown --from=[_13] -R <new user id> [_14]\n\n注意：此階段所造成的任何錯誤可能會破壞您的 x86 World 及\n電力系統。\n\n您應可使用下列指令來重新啟動 PowerVM Lx86：\n\n/etc/init.d/powervm-lx86 start\n\n",

    "_NEW_GID_ALIAS_EMAIL" => "在 x86 World 群組檔 ([_1]) 中所找到的群組帳號，\n與 Power 群組檔  (/etc/group) 中找到的帳號分享相同的群組 ID ([_2])。\n在 x86 World 檔案 ([_3]) 中找到的相關密碼項目會在此顯示：\n\n [_4]\n 及 Power 檔 (/etc/group) 中找到的相關群組項目會在此顯示：\n\n[_5]\n 欄位分別代表群組帳號、密碼、群組 ID\n 及身為此群組成員的使用者。\n\n雖然不太可能，這可能代表重大的安全風險，因為\n對應至群組 ID [_6] 的 ID 是匿名的。\n\n將來若要停止接收此郵件，您可以有兩種選項：若您認為\n沒有安全風險，那麼您就可以新增使用者 ID [_7] 至位於 /etc/opt/powervm-lx86/uid_ignore 中的空白清單\n檔案。否則，建議您變更 x86 World 中\n [_8] 的群組 ID 來修改問題。不過，因為目前可能有 PowerVM Lx86 處理程式正在以使用者 [_9] 的身分執行，修改前\n您「必須」先關閉 PowerVM Lx86，方法是執行以下指令：\n\n/etc/init.d/powervm-lx86 stop。\n\n接下來\n，您需要為使用者 [_10] 選擇新的唯一使用者 ID，以確保此使用者 ID\n 不存在於 x86 World 或 Power 群組檔。\n變更群組 [_11] 的群組 ID 最簡單的方法就是手動編輯 x86 World\n 群組檔並更新使用者 ID。最後，您必須更新 x86 World 中使用者 [_12] 擁有的所有檔案擁有權。\n更新 x86 World 中檔案的擁有權有數個方法，\n這裡提供一個可讓您執行的簡單指令\n：\n\n/bin/chown --from=[_13] -R <new group id> [_14]\n\n注意：此階段所造成的任何錯誤可能會破壞您的 x8your World 及\n電力系統。\n\n您應可使用下列指令來重新啟動 PowerVM Lx86：\n\n/etc/init.d/powervm-lx86 start\n\n
",
  );

1;
