# NOTICE_START
# Licensed Materials - Property of IBM
# "Restricted Materials of IBM" -- 5746-SM2
# (C) Copyright IBM Corp. 2007, 2008 All Rights Reserved.
# US Government Users Restricted Rights - Use, duplication or disclosure
# restricted by GSA ADP Schedule Contract with IBM Corp.
# NOTICE_END

package powervm_lx86_scripts::L10N::zh;
use encoding 'utf8';
use base 'powervm_lx86_scripts::L10N';

our %Lexicon =
  (
    _AUTO => 1,

    "New user account ('[_1]') found in [_2]." =>
    "在 [_2] 中找到新的用户帐户（“[_1]”）。",

    "Aliased user id ('[_1]') found in [_2]." =>
    "在 [_2] 中找到具有别名的用户标识（“[_1]”）。",

    "New group ('[_1]') found in [_2]." =>
    "在 [_2] 中找到新组（“[_1]”）。",

    "Aliased group id ('[_1]') found in [_2]." =>
    "在 [_2] 中找到具有别名的组标识（“[_1]”）。",

    "You must be root to run this script." =>
    "必须是 root 用户才能运行此脚本。",

    "Failed to get current set of mount entries." =>
    "未能获取当前的一组安装条目。",

    "The powervm-lx86-daemon is not running. Please start the powervm-lx86-daemon." =>
    "powervm-lx86-daemon 未在运行。请启动 powervm-lx86-daemon。",

    "Unrecognised option 'WORLD_CHECK_OR_SYNC=[_1]'." =>
    "未识别选项“WORLD_CHECK_OR_SYNC=[_1]”。",

    "Directory [_1] does not exist." =>
    "目录 [_1] 不存在。", 

    "Cannot open \"[_1]\": [_2]." =>
    "无法打开“[_1]”：[_2]。",

    "Cannot open \"[_1]\" for reading: [_2]." =>
    "无法打开“[_1]”以便读取：[_2]。", 
    
    "Cannot open \"[_1]\" for writing: [_2]." =>
    "无法打开“[_1]”以便写入：[_2]。", 

    "(Unable to run command '[_1] /usr/bin/id [_2]')" =>
    "（无法运行命令“[_1] /usr/bin/id [_2]”）",

    "_EMAIL_DISABLE" => "（此邮件由 cron 脚本 [_1] 生成，可\n通过在 /etc/opt/powervm-lx86/config 中设置配置变量 WORLD_CHECK_OR_SYNC=none 来禁用）\n",

    "_NEW_USER_EMAIL" => "已在 x86 World 密码文件（[_1]）中找到新的用户帐户，\n它不出现在 Power 密码文件中。在\n[_2] 中找到的相关密码条目显示如下：\n\n  [_3]\n其中，各字段分别表示用户帐户、密码、用户标识、主组\n标识、注释、主目录和缺省 shell 程序。另外，\n已转换命令“/usr/bin/id [_4]”的输出如下所示：\n\n  [_5]\n其中，第二个字段显示主组，第三个字段显示\n用户 [_6] 所属的组的完整列表，包括\n主组和辅助组。\n\n为了防止将来接收到此电子邮件，有两个操作可供选择。第一个\n操作是将用户 [_7] 添加至 \n/etc/opt/powervm-lx86/user_ignore 中的用户白名单文件。在此情况下，不需要将该用户添加至 \nPower 端，并且以后此用户将被忽略。第二个操作是\n您自己将该用户添加在 Power 端。执行此操作（但不一定最完整）\n的方法之一是在本机 Power shell 中执行以下命令：\n\n  /usr/sbin/useradd -m -d <home directory> [_8]\n\n要完整地复制 x86 World 设置，将必须确保\n用户 [_9] 所属的所有组都存在于 Power 端上，然后\n相应地设置用户 [_10] 的主组和辅助组。\n\n",

    "_NEW_GROUP_EMAIL" => "已在 x86 World 组文件（[_1]）中找到新的组帐户，\n它不出现在 Power 组文件中。在\n[_2] 中找到的相关组条目显示如下：\n\n  [_3]\n其中，各字段分别表示组帐户、密码、组标识和\n作为此组成员的用户。\n\n为了防止将来接收到此电子邮件，有两个操作可供选择。第一个\n操作是将组 [_4] 添加至 \n/etc/opt/powervm-lx86/group_ignore 中的组白名单文件。在此情况下，不需要将该组添加至 \nPower 端，并且以后此组将被忽略。第二个操作是\n您自己将该组添加在 Power 端上。执行此操作（但不一定最完整）\n的方法之一是在本机 Power shell 中执行以下命令：\n\n  /usr/sbin/groupadd [_5]\n\n",

    "_NEW_UID_ALIAS_EMAIL" => "已在 x86 World 密码文件（[_1]）中找到与\nPower 密码文件中（/etc/passwd）的帐户共享同一用户标识（[_2]）的用户帐户。\nx在86 World 文件（[_3]）中找到的相关密码条目显示如下：\n\n  [_4]\n另外，在Power 文件（/etc/passwd）中找到的相关密码条目显示如下：\n\n  [_5]\n其中，各字段分别表示用户帐户、密码、用户标识、主组标识、\n注释、主目录和缺省 shell 程序。\n\n虽然极不可能，但是，这可表示严重的安全性风险，因为\n与用户标识 [_6] 相应的标识易混淆。\n\n为了防止将来接收到此电子邮件，有两个操作可供选择。如果认为\n没有涉及安全性风险，那么可将用户标识 [_7] 添加至\n/etc/opt/powervm-lx86/uid_ignore 中的白名单文件。否则，建议通过在\nx86 World 中更改 [_8] 的用户标识来更正该问题。但是，在执行此操作之前，\n必须首先通过运行以下命令来关闭 PowerVM Lx86：\n\n  /etc/init.d/powervm-lx86 stop\n\n因为当前可能存在以用户 [_9] 身份运行的 PowerVM Lx86 进程。然后，\n需要为用户 [_10] 选择新的唯一用户标识，从而确保此用户\n标识尚未存在于 x86 World 或 Power 密码文件中。更改\n用户 [_11] 的用户标识的最简单方法是手工编辑 x86 World 密码\n文件，从而相应地更新该用户标识。最后，必须更新\nx86 World 中归用户标识 [_12] 所有的全部文件的所有权。有几种方法来\n更新 x86 World 中文件的所有权，有一个可\n运行的简单命令如下：\n\n  /bin/chown --from=[_13] -R <new user id> [_14]\n\n注意：此阶段出现的任何错误都可能损坏 x86 World 和\nPower 系统。\n\n然后，应该能够通过以下命令重新启动 PowerVM Lx86：\n\n  /etc/init.d/powervm-lx86 start\n\n",

    "_NEW_GID_ALIAS_EMAIL" => "已在 x86 World 组文件（[_1]）中找到与\nPower 组文件（/etc/group）中的帐户共享同一组标识（[_2]）的组帐户。\nx在86 World 文件（[_3]）中找到的相关组条目显示如下：\n\n  [_4]\n另外，在Power 文件（/etc/group）中找到的相关组条目显示如下：\n\n  [_5]\n其中，各字段分别表示组帐户、密码、组标识\n和作为此组的成员的用户。\n\n虽然极不可能，但是这可表示严重的安全性风险，因为\n与组标识 [_6] 相应的标识易混淆。\n\n为了防止将来接收到此电子邮件，有两个操作可供选择。如果认为\n没有涉及安全性风险，那么可将组标识 [_7] 添加至\n/etc/opt/powervm-lx86/gid_ignore 中的白名单文件。否则，建议通过在\nx86 World 中更改 [_8] 的组标识来更正该问题。但是，在执行此操作之前，\n必须首先通过运行以下命令来关闭 PowerVM Lx86：\n\n  /etc/init.d/powervm-lx86 stop\n\n因为当前可能存在以组 [_9] 身份运行的 PowerVM Lx86 进程。然后，\n需要为组 [_10] 选择新的唯一组标识，从而确保此组\n标识尚未存在于 x86 World 或 Power 组文件中。更改\n组 [_11] 的组标识的最简单方法是手工编辑 x86 World 组\n文件，从而相应地更新该组标识。最后，必须更新\nx86 World 中归组标识 [_12] 所有的全部文件的所有权。有几种方法来\n更新 x86 World 中文件的所有权，但是，可\n运行的一个简单命令如下：\n\n  /bin/chown --from=:[_13] -R :<new group id> [_14]\n\n注意：此阶段出现的任何错误都可能损坏 x86 World 和\nPower 系统。\n\n然后，应该能够通过以下命令重新启动 PowerVM Lx86：\n\n  /etc/init.d/powervm-lx86 start\n\n",
  );

1;
