# NOTICE_START
# Licensed Materials - Property of IBM
# "Restricted Materials of IBM" -- 5746-SM2
# (C) Copyright IBM Corp. 2007, 2008 All Rights Reserved.
# US Government Users Restricted Rights - Use, duplication or disclosure
# restricted by GSA ADP Schedule Contract with IBM Corp.
# NOTICE_END

package powervm_lx86_scripts::L10N::pt;
use encoding 'utf8';
use base 'powervm_lx86_scripts::L10N';

our %Lexicon =
  (
    _AUTO => 1,

    "New user account ('[_1]') found in [_2]." =>
    "Nova conta de usuário ('[_1]') localizada em [_2].",

    "Aliased user id ('[_1]') found in [_2]." =>
    "ID de usuário com alias ('[_1]') localizado em [_2].",

    "New group ('[_1]') found in [_2]." =>
    "Novo grupo ('[_1]') localizado em [_2].",

    "Aliased group id ('[_1]') found in [_2]." =>
    "ID de grupo com alias ('[_1]') localizado em [_2].",

    "You must be root to run this script." =>
    "É necessário ser raiz para executar este script",

    "Failed to get current set of mount entries." =>
    "Falha ao obter o conjunto atual de entradas de montagem.",

    "The powervm-lx86-daemon is not running. Please start the powervm-lx86-daemon." =>
    "O powervm-lx86-daemon não está em execução. Inicie o powervm-lx86-daemon.",

    "Unrecognised option 'WORLD_CHECK_OR_SYNC=[_1]'." =>
    "Opção 'WORLD_CHECK_OR_SYNC=[_1]' não reconhecida",

    "Directory [_1] does not exist." =>
    "Diretório [_1] não existe.", 

    "Cannot open \"[_1]\": [_2]." =>
    "Não é possível abrir \"[_1]\": [_2].",

    "Cannot open \"[_1]\" for reading: [_2]." =>
    "Não é possível abrir \"[_1]\" para leitura: [_2].", 
    
    "Cannot open \"[_1]\" for writing: [_2]." =>
    "Não é possível abrir \"[_1]\" para gravação: [_2].", 

    "(Unable to run command '[_1] /usr/bin/id [_2]')" =>
    "(Não é possível executar o comando '[_1] /usr/bin/id [_2]')",

    "_EMAIL_DISABLE" => "(Esse correio foi gerado pelo script cron [_1] epode\nser desativado definindo a variável de configuração WORLD_CHECK_OR_SYNC=none em /etc/opt/powervm-lx86/config)\n",

    "_NEW_USER_EMAIL" => "Uma nova conta de usuário foi localizada no arquivo de senha do x86 World ([_1])\nque não está presente no arquivo de senha do Power. A entrada de senha relevante localizada\nem [_2] é mostrada aqui:\n\n  [_3]\nem que os campos representam a conta do usuário, a senha, o id do usuário, o grupo primário\no id, o comentário, o diretório inicial e o shell padrão, respectivamente. Além disso, a saída do comando\nconvertido '/usr/bin/id [_4]' é mostrada abaixo\n\n  [_5]\nem que o segundo campo mostra o grupo primário e o terceiro campo mostra\na lista completa de grupos aos quais o usuário [_6] pertence, incluindo os\ngrupos primário e suplementar.\n\nPara parar o recebimento desse e-mail no futuro, você tem duas opções. A primeira\nopção é incluir o usuário [_7] no arquivo whitelist do usuário localizado em\n/etc/opt/powervm-lx86/user_ignore. Nesse caso, não é necessário incluir o usuário no\nlado do Power e esse usuário será ignorado no futuro. A segunda opção é você mesmo incluir\no usuário no lado do Power. Uma maneira de fazer isso (mas não necessariamente\na mais completa) é executar o seguinte comando em um shell nativo do Power:\n\n  /usr/sbin/useradd -m -d <diretório inicial> [_8]\n\nPara replicar a configuração do x86 World completamente, você precisará assegurar que todos os\ngrupos nos quais o usuário [_9] é um membro existem no lado do Power e, então,\nconfigurar os grupos primário e suplementar para o usuário [_10] de acordo.\n\n",

    "_NEW_GROUP_EMAIL" => "Uma nova conta de grupo foi localizada no arquivo de grupo do x86 World ([_1])\nque não está presente no arquivo de grupo do Power. A entrada de grupo relevante localizada\nem [_2] é mostrada aqui:\n\n  [_3]\nem que os campos representam a conta do grupo, a senha, o id do grupo e os usuários que\nsão membros desse grupo, respectivamente.\n\nPara parar o recebimento desse e-mail no futuro, você tem duas opções. A primeira\nopção é incluir o grupo [_4] no arquivo whitelist do grupo localizado em\n/etc/opt/powervm-lx86/group_ignore. Nesse caso, não é necessário incluir o grupo no lado do\nPower e esse grupo será ignorado no futuro. A segunda opção é você mesmo incluir\no grupo no lado do Power. Uma maneira de fazer isso (mas não necessariamente\na mais completa) é executar o seguinte comando em um shell nativo do Power:\n\n  /usr/sbin/groupadd [_5]\n\n",

    "_NEW_UID_ALIAS_EMAIL" => "Uma conta do usuário foi localizada no arquivo de senha do x86 World ([_1]) que compartilha\no mesmo id do usuário ([_2]) com uma conta localizada no arquivo de senha do Power (/etc/passwd). A entrada de senha\nrelevante localizada no arquivo do x86 World ([_3]) é mostrada aqui:\n\n  [_4]\ne a entrada de senha relevante localizada no arquivo do Power (/etc/passwd) é mostrada aqui:\n\n  [_5]\nem que os campos representam a conta do usuário, a senha, o id do usuário, o grupo primário\no id, o comentário, o diretório inicial e o shell padrão, respectivamente.\n\nEmbora altamente improvável, isso poderá representar um risco sério de segurança, porque a\nidentidade correspondente ao id do usuário [_6] é ambígua.\n\nPara parar de receber esse e-mail no futuro, você tem duas opções. Se você acreditar que\nnão há nenhum risco de segurança envolvido, então, poderá  incluir o id do usuário [_7] no arquivo whitelist\nlocalizado em /etc/opt/powervm-lx86/uid_ignore. Caso contrário, é recomendado que você retifique o\nproblema alterando o id do usuário de [_8] no x86 World. No entanto, antes de fazer isso\nvocê DEVE primeiro encerrar o PowerVM Lx86 executando o comando:\n\n  /etc/init.d/powervm-lx86 stop\n\nporque pode haver muitos processos do PowerVM Lx86 atualmente em execução como o usuário [_9]. Em seguida,\nvocê precisa escolher um id do usuário novo e exclusivo para o usuário [_10], assegurando que esse\nid do usuário ainda não exista nos arquivos de senha do x86 World ou do Power. A forma mais simples\nde alterar o id do usuário [_11] é editar manualmente o arquivo de senha do x86 World,\natualizando o id do usuário de forma adequada. Finalmente, você deve atualizar a propriedade de\ntodos os arquivos no x86 World pertencentes ao id do usuário [_12]. Existem várias maneiras de\n atualizar a propriedade nos arquivos no x86 World, no entanto, aqui está um comando simples\nque você pode executar:\n\n  /bin/chown --from=[_13] -R <novo id do usuário> [_14]\n\nCUIDADO: Qualquer engano cometido nesse estágio poderá danificar o x86 world e o\n         sistema de energia.\n\nVocê deve então poder reiniciar o PowerVM Lx86 com o seguinte comando\n\n  /etc/init.d/powervm-lx86 start\n\n",

    "_NEW_GID_ALIAS_EMAIL" => "Uma conta do grupo foi localizada no arquivo de grupo do x86 World ([_1]) que compartilha\no mesmo id do grupo ([_2]) com uma conta localizada no arquivo de grupo do Power (/etc/group). A entrada de grupo\nrelevante localizada no arquivo do x86 World ([_3]) é mostrada aqui:\n\n  [_4]\ne a entrada de grupo relevante localizada no arquivo do Power (/etc/group) é mostrada aqui:\n\n  [_5]\nem que os campos representam a conta do grupo, a senha, o id do grupo e usuários que\nsão membros desse grupo, respectivamente.\n\nEmbora altamente improvável, isso poderá representar um risco sério de segurança, porque a\nidentidade correspondente ao id do grupo [_6] é ambígua.\n\nPara parar de receber esse e-mail no futuro, você tem duas opções. Se você acreditar que\nnão há nenhum risco de segurança envolvido, então, poderá  incluir o id do grupo [_7] no arquivo whitelist\nlocalizado em /etc/opt/powervm-lx86/gid_ignore. Caso contrário, é recomendado que você retifique o\nproblema alterando o id do grupo de [_8] no x86 World. No entanto, antes de fazer isso\nvocê DEVE primeiro encerrar o PowerVM Lx86 executando o comando:\n\n  /etc/init.d/powervm-lx86 stop\n\nporque pode haver muitos processos do PowerVM Lx86 atualmente em execução como o grupo [_9]. Em seguida,\nvocê precisa escolher um id do grupo novo e exclusivo para o grupo [_10], assegurando que esse\nid do grupo ainda não exista nos arquivos de grupo do x86 World ou do Power. A forma mais simples\nde alterar o id do grupo [_11] é editar manualmente o arquivo de grupo do x86 World,\natualizando o id do grupo de forma adequada. Finalmente, você deve atualizar a propriedade de\ntodos os arquivos no x86 World pertencentes ao id do grupo [_12]. Existem várias maneiras de\nde atualizar a propriedade nos arquivos no x86 World, no entanto, aqui está um comando simples\nque você pode executar:\n\n /bin/chown --from=:[_13] -R :<novo id do grupo > [_14]\n\nCUIDADO: Qualquer engano cometido nesse estágio poderá danificar o x86 world e o\n         sistema de energia.\n\nVocê deve então poder reiniciar o PowerVM Lx86 com o seguinte comando\n\n  /etc/init.d/powervm-lx86 start\n\n",
  );

1;
