# NOTICE_START
# Licensed Materials - Property of IBM
# "Restricted Materials of IBM" -- 5746-SM2
# (C) Copyright IBM Corp. 2007, 2008 All Rights Reserved.
# US Government Users Restricted Rights - Use, duplication or disclosure
# restricted by GSA ADP Schedule Contract with IBM Corp.
# NOTICE_END

package powervm_lx86_scripts::L10N::ko;
use encoding 'utf8';
use base 'powervm_lx86_scripts::L10N';

our %Lexicon =
  (
    _AUTO => 1,

    "New user account ('[_1]') found in [_2]." =>
    "[_2]에서 새 사용자 계정('[_1]')이 발견되었습니다. ",

    "Aliased user id ('[_1]') found in [_2]." =>
    "[_2]에서 별명 지정된 사용자 ID('[_1]')가 발견되었습니다. ",

    "New group ('[_1]') found in [_2]." =>
    "[_2]에서 새 그룹('[_1]')이 발견되었습니다. ",

    "Aliased group id ('[_1]') found in [_2]." =>
    "[_2]에서 별명 지정된 그룹 ID('[_1]')가 발견되었습니다. ",

    "You must be root to run this script." =>
    "이 스크립트를 실행하려면 루트여야 합니다.",

    "Failed to get current set of mount entries." =>
    "현재 마운트 항목 세트를 가져오는 데 실패했습니다.",

    "The powervm-lx86-daemon is not running. Please start the powervm-lx86-daemon." =>
    "powervm-lx86-daemon이 실행 중이지 않습니다. powervm-lx86-daemon을 시작하십시오.",

    "Unrecognised option 'WORLD_CHECK_OR_SYNC=[_1]'." =>
    "알 수 없는 옵션 'WORLD_CHECK_OR_SYNC=[_1]'.",

    "Directory [_1] does not exist." =>
    "[_1] 디렉토리가 없습니다.", 

    "Cannot open \"[_1]\": [_2]." =>
    "\"[_1]\"을(를) 열 수 없음: [_2].",

    "Cannot open \"[_1]\" for reading: [_2]." =>
    "읽기 위해 \"[_1]\"을(를) 열 수 없음: [_2].", 
    
    "Cannot open \"[_1]\" for writing: [_2]." =>
    "쓰기 위해 \"[_1]\"을(를) 열 수 없음: [_2].", 

    "(Unable to run command '[_1] /usr/bin/id [_2]')" =>
    "(명령 '[_1] /usr/bin/id [_2]'을(를) 실행할 수 없음)",

    "_EMAIL_DISABLE" => "(이 메일은 cron script [_1]에 의해 생성되었으며\n /etc/opt/powervm-lx86/config에 구성 변수  WORLD_CHECK_OR_SYNC=none을 설정하여 표시할 수 있습니다.)\n ",

    "_NEW_USER_EMAIL" => "x86 World 암호 파일([_1])에서 Power 암호 파일에 존재하지 않는\n새 사용자 계정이 발견되었습니다. [_2]에서 발견된 관련 암호 항목은\n다음과 같습니다.\n\n  [_3]\n여기서 필드는 각각 사용자 계정, 암호, 사용자 ID, 기본 그룹 ID,\n주석, 홈 디렉토리 및 기본 쉘을 나타냅니다. 또한 변환된 명령\n'/usr/bin/id [_4]'의 출력은 아래와 같습니다.\n\n  [_5]\n여기서 두 번째 필드는 기본 그룹을 표시하고 세 번째 필드는\n기본 그룹과 보조 그룹을 포함하여 사용자 [_6]이(가) 속한\n그룹의 전체 목록을 표시합니다.\n\n이 전자 우편을 수신하지 않으려면 두 가지 방법을 사용할 수 있습니다. 첫 번째 옵션은\n사용자 [_7]을(를) /etc/opt/powervm-lx86/user_ignore에 있는\nwhitelist 파일에 추가하는 것입니다. 이 경우 사용자를 Power 측에 추가할 필요가 없으며\n이 사용자는 앞으로 무시됩니다. 두 번째 옵션은 Power 측에서 사용자를\n직접 추가하는 것입니다. 이렇게 하는 한 가지 방법은(가장 완전한 방법은 아닐 수 있음)\n고유 Power 쉘에서 다음 명령을 실행하는 것입니다.\n\n/usr/sbin/useradd-m -d <home directory> [_8]\n\nx86 World 설정을 완전히 복제하려면 사용자 [_9]이(가) 속한 모든 그룹이\nPOWER 측에 존재하는지 확인한 다음, 사용자 [_10]에 따라 기본 및 보조 그룹을 \n모두 설정해야 합니다.\n\n",

    "_NEW_GROUP_EMAIL" => "Power 그룹 파일에 없는 새 그룹 계정이 x86 World 그룹 파일([_1])에서\n발견되었습니다. [_2]에서 발견된 관련 그룹 항목은\n다음과 같습니다.\n\n  [_3]\n여기서 필드는 각각 그룹 계정, 암호, 그룹 ID 및 이 그룹에 속한\n사용자를 나타냅니다.\n\n이 전자 우편을 수신하지 않는 방법에는 두 가지가 있습니다. \n첫 번째 옵션은 그룹 [_4]을(를) /etc/opt/powervm-lx86/group_ignore에\n있는 그룹 whitelist 파일에 추가하는 것입니다. 이 경우 그룹을 Power 측에 추가할 필요가 없으며\n앞으로 이 그룹은 무시됩니다. 두 번째 옵션은 Power 측에서 그룹을 직접\n추가하는 것입니다. 이렇게 하는 한 가지 방법은(가장 완전한 방법은 아닐 수 있음\n고유 Power 쉘에서 다음 명령을 실행하는 것입니다.\n\n  /usr/sbin/groupadd [_5]\n\n",

    "_NEW_UID_ALIAS_EMAIL" => "Power 암호 파일(/etc/passwd)에서 발견된 계정과 같은 사용자 ID([_2])를 공유하는\n사용자 계정이 x86 World 암호 파일([_1])에서 발견되었습니다.\nx86 World 파일([_3])에서 발견된 관련 암호 항목은 다음과 같습니다.\n\n  [_4]\nPower 파일(/etc/passwd)에서 발견된 관련 암호 항목은 다음과 같습니다.\n\n  [_5]\n여기서 필드는 각각 사용자 계정, 암호, 사용자 ID, 기본 그룹 ID,\n홈 디렉토리 및 기본 쉘을 나타냅니다. \n\n매우 드문 경우지만 이러한 경우, 사용자 ID [_6]에 해당하는 ID가 모호하기 때문에\n심각한 보안 위험을 나타낼 수 있습니다.\n\n이 전자 우편을 수신하지 않는 방법에는 두 가지가 있습니다. 보안 위험이\n없다고 생각되는 경우, /etc/opt/powervm-lx86/uid_ignore의 whitelist 파일에\n사용자 ID [_7]을(를) 추가할 수 있습니다. 그렇지 않은 경우에는\nx86 World에서 [_8]의 사용자 ID를 변경하여 문제점을\n해결할 것을 권장합니다. 하지만 이렇게 하기 전에\n먼저 다음 명령을 실행하여 PowerVM Lx86를 종료해야 합니다.\n\n  /etc/init.d/powervm-lx86 stop\n\n사용자 [_9](으)로 실행 중인 여러 PowerVM Lx86 프로세스가 있을 수 있기 때문입니다. 다음으로는\n 사용자 [_10]에 대한 고유 사용자 ID를 새로 선택해야 합니다. 이 사용자 ID는\n x86 World나 Power 암호 파일에 없어야 합니다. 사용자 [_11]의\n 사용자 ID를 변경하는 가장 간단한 방법은 x86 World 암호 파일을 직접 편집하여\n 사용자 ID를 적절하게 갱신하는 것입니다. 마지막으로, 사용자 ID [_12]가 소유한 x86 World의\n 모든 파일의 소유권을 갱신해야 합니다. x86 World에서 파일\n 소유권을 갱신하는 방법에는 몇 가지가 있지만 다음과 같은 간단한\n 명령을 실행할 수 있습니다.\n\n  /bin/chown --from=[_13] -R <new user id> [_14]\n\n주의: 이 단계에서 실수하면 x86 World 및 Power 시스템\n 모두가 손상될 수 있습니다.\n\n다음 명령을 사용하여 PowerVM Lx86를 다시 시작할 수 있어야 합니다.\n\n  /etc/init.d/powervm-lx86 start\n\n",

    "_NEW_GID_ALIAS_EMAIL" => "Power 그룹 파일(/etc/group)에서 발견된 계정과 같은 그룹 ID([_2])를 공유하는\n 그룹 계정이 x86 World 그룹 파일([_1])에서 발견되었습니다. \nx86 World 파일([_3])에서 발견된 관련 그룹 항목은 다음과 같습니다. \n\n  [_4]\nPower 파일(/etc/group)에서 발견된 관련 그룹 항목은 다음과 같습니다. \n\n  [_5]\n여기서 필드는 각각 그룹 계정, 암호, 그룹 ID 및 이 그룹의 구성원인\n 사용자를 나타냅니다. \n\n매우 드문 경우지만 이러한 경우, 그룹 ID [_6]에 해당하는 ID가 모호하기 때문에\n 심각한 보안 위험을 나타낼 수 있습니다. \n\n이 전자 우편을 수신하지 않는 방법에는 두 가지가 있습니다. 보안 위험이\n 없다고 생각되는 경우 /etc/opt/powervm-lx86/gid_ignore의 whitelist 파일에 그룹 ID [_7]을\n 추가할 수 있습니다. 그렇지 않은 경우에는 x86 World에서 [_8]의 그룹 ID를 변경하여\n 문제를 해결할 것을 권장합니다.  하지만 이렇게 하기 전에\n 먼저 다음 명령을 실행하여 PowerVM Lx86를 종료해야 합니다. \n\n  /etc/init.d/powervm-lx86 stop\n\n그룹 [_9](으)로 실행 중인 여러 PowerVM Lx86 프로세스가 있을 수 있기 때문입니다. \n다음으로는 그룹 [_10]에 대한 고유 그룹 ID를 새로 선택해야 합니다. 이 그룹 ID는\n x86 World나 Power 그룹 파일에 없어야 합니다. 그룹 [_11]의\n 그룹 ID를 변경하는 가장 간단한 방법은 x86 World 그룹 파일을 직접 편집하여\n그룹 ID를 적절하게 갱신하는 것입니다. 마지막으로, 그룹 ID [_12]이(가) 소유한 x86 World의\n모든 파일의 소유권을 갱신해야 합니다. x86 World에서 파일\n소유권을 갱신하는 방법에는 몇 가지가 있지만 다음 명령으로 간단히\n실행할 수 있습니다.\n\n  /bin/chown --from=:[_13] -R :<new group id> [_14]\n\n주의: 이 단계에서 실수하면 x86 World 및 Power 시스템\n 모두가 손상될 수 있습니다.\n\n다음명령을 사용하여 PowerVM Lx86를 다시 시작할 수 있어야 합니다.\n\n  /etc/init.d/powervm-lx86 start\n\n",
  );

1;
