# NOTICE_START
# Licensed Materials - Property of IBM
# "Restricted Materials of IBM" -- 5746-SM2
# (C) Copyright IBM Corp. 2007, 2008 All Rights Reserved.
# US Government Users Restricted Rights - Use, duplication or disclosure
# restricted by GSA ADP Schedule Contract with IBM Corp.
# NOTICE_END

package powervm_lx86_scripts::L10N::ja;
use encoding 'utf8';
use base 'powervm_lx86_scripts::L10N';

our %Lexicon =
  (
    _AUTO => 1,

    "New user account ('[_1]') found in [_2]." =>
    "新規ユーザー・アカウント ('[_1]') が [_2] で検出されました。",

    "Aliased user id ('[_1]') found in [_2]." =>
    "別名ユーザー ID ('[_1]') が [_2] で検出されました。",

    "New group ('[_1]') found in [_2]." =>
    "新規グループ ('[_1]') が [_2] で検出されました。",

    "Aliased group id ('[_1]') found in [_2]." =>
    "別名グループ ID ('[_1]') が [_2] で検出されました。",

    "You must be root to run this script." =>
    "このスクリプトを実行するには、ルートでなければなりません。",

    "Failed to get current set of mount entries." =>
    "現行セットのマウント項目を取得できませんでした。",

    "The powervm-lx86-daemon is not running. Please start the powervm-lx86-daemon." =>
    "powervm-lx86-daemon が実行されていません。powervm-lx86-daemon を開始してください。",

    "Unrecognised option 'WORLD_CHECK_OR_SYNC=[_1]'." =>
    "認識されていないオプション 'WORLD_CHECK_OR_SYNC=[_1]'。",

    "Directory [_1] does not exist." =>
    "ディレクトリー [_1] は存在しません。", 

    "Cannot open \"[_1]\": [_2]." =>
    "\"[_1]\": [_2] をオープンできません。.",

    "Cannot open \"[_1]\" for reading: [_2]." =>
    "\"[_1]\" をオープンして読み取ることができません: [_2]。", 
    
    "Cannot open \"[_1]\" for writing: [_2]." =>
    "\"[_1]\" をオープンして書き込むことができません: [_2]。", 

    "(Unable to run command '[_1] /usr/bin/id [_2]')" =>
    "(コマンド '[_1] /usr/bin/id [_2]' を実行できません)",

    "_EMAIL_DISABLE" => "(このメールはクーロン・スクリプト [_1] によって作成されました。/etc/opt/powervm-lx86/config 内の構成変数 WORLD_CHECK_OR_SYNC=none を設定することで\n無効にすることができます\n",

    "_NEW_USER_EMAIL" => "POWER パスワード・ファイルに入っていない\n新しいユーザー・アカウントが x86 World パスワード・ファイル ([_1]) で検出されました。[_2] で検出された\n関連パスワード項目は、以下のものです。\n\n[_3]\nここで、各フィールドは、ユーザー・アカウント、パスワード、ユーザー ID、1 次グループ \nID、コメント、ホーム・ディレクトリー、およびデフォルトのシェルをそれぞれ表します。また、\n変換されたコマンド '/usr/bin/id [_4]' の出力も、以下に示します。\n\n[_5]\nここで、2 番目のフィールドは 1 次グループを示し、3 番目のフィールドは、\n基本グループおよび補足グループを含め、ユーザー [_6] が属しているグループの\n完全リストを示します。\n\nこの E メールの受信を今後停止するためには、2 つのオプションがあります。1 つ目の\nオプションは、ユーザー [_7] を、\n/etc/opt/powervm-lx86/user_ignore 内のユーザー・ホワイトリスト・ファイルに追加する方法です。この場合、ユーザーを\n POWER 側に追加する必要はなく、このユーザーは、今後は無視されます。2 つ目のオプションは、\nユーザーをご自分で POWER 側に追加する方法です。この方法の 1 つ (ただし、必ずしも\n完ぺきな方法ではありません) は、ネイティブ POWER シェルで以下のコマンドを実行することです。\n\n/usr/sbin/useradd -m -d <home directory> [_8]\n\nx86 World セットアップを完全に複製するためには、ユーザー [_9] がメンバーになっているすべての\nグループが POWER 側に存在していることを確認してから、ユーザー [_10] の基本グループおよび補足グループの両方を適宜\n設定する必要があります。\n\n",

    "_NEW_GROUP_EMAIL" => "POWER グループ・ファイルに入っていない\n新しいグループ・アカウントが x86 World グループ・ファイル ([_1]) で検出されました。[_2] で\n検出された関連グループ項目は、以下のものです。\n\n  [_3]\nここで、各フィールドは、グループ・アカウント、パスワード、グループ ID、およびこのグループのメンバーである\nユーザーをそれぞれ表します。\n\nこの E メールの受信を今後停止するためには、2 つのオプションがあります。1 つ目の\nオプションは、グループ [_4] を、\n<filepath>/etc/opt/powervm-lx86/group_ignore</filepath> 内のグループ・ホワイトリスト・ファイルに追加する方法です。この場合、グループを\n POWER 側に追加する必要はなく、このグループは、今後は無視されます。 2 つ目のオプションは、\nグループをご自分で POWER 側に追加する方法です。この方法の 1 つ (ただし、必ずしも\n完ぺきな方法ではありません) は、ネイティブ POWER シェルで以下のコマンドを実行することです。\n\n/usr/sbin/groupadd [_5]\n\n",

    "_NEW_UID_ALIAS_EMAIL" => "POWER パスワード・ファイル (/etc/passwd) で検出されたアカウントと\n同じユーザー ID ([_2]) を共用するユーザー・アカウントが x86 World パスワード・ファイル ([_1]) で検出されました。x86 World ファイル [_3] で検出された\n関連パスワード項目がここに示されます。\n\n[_4]\n と、POWER ファイル (/etc/passwd) で検出された関連パスワード項目がここに示されます。\n\n[_5]\n ここで、各フィールドは、ユーザー・アカウント、パスワード、ユーザー ID、1 次グループ\n ID、コメント、ホーム・ディレクトリー、およびデフォルトのシェルをそれぞれ表します。\n\n可能性はかなり低いですが、これが重大なセキュリティー・リスクを表す場合があります。ユーザー ID [_6] に相当する\n ID は未確定であるためです。\n\nこの E メールの受信を今後停止するためには、2 つのオプションがあります。セキュリティー・リスクが関与しないと\n考えられる場合は、ユーザー ID [_7] を、/etc/opt/powervm-lx86/uid_ignore 内にあるホワイトリスト・\nファイルに追加できます。そうでない場合は、x86 World 内の [_8] というユーザー ID を変更して、\n問題を解決することをお勧めします。ただし、この変更を行う前に、\nまず、次のコマンドを実行して、PowerVM Lx86 をシャットダウンする「必要があります」。\n\n/etc/init.d/powervm-lx86 stop\n\n現在、PowerVM Lx86 プロセスがユーザー [_9] として実行されている場合があるためです。次に、\n新しい固有のユーザー ID をユーザー [_10] 用に選択し、このユーザー\n ID が x86 World または POWER パスワード・ファイルのどちらかにまだ存在していないことを確認する必要があります。ユーザー [_11] のユーザー ID を変更する、\n最も簡単な方法は、x86 World パスワード・\nファイルを手動で編集して、ユーザー ID を適宜更新することです。最後に、ユーザー ID [_12] が所有する、x86 World 内の\nすべてのファイルの所有権を更新する必要があります。x86 World 内のファイルの所有権を\n更新する方法は複数ありますが、実行可能な\n 1 つの単純なコマンドは、次のものです。\n\n /bin/chown --from=[_13] -R <new user id> [_14]\n\n注意: この段階で間違いがあると、ご使用の x86 World と\n POWER システムの両方を損傷する可能性があります。\n\nその場合、以下のコマンドで PowerVM Lx86 を再始動できます。\n\n  /etc/init.d/powervm-lx86 start\n\n",

    "_NEW_GID_ALIAS_EMAIL" => "POWER グループ・ファイル (/etc/group) で検出されたアカウントと同じグループ ID ([_2]) を共用する\nグループ・アカウントが x86 World グループ・ファイル ([_1]) で検出されました。x86 World ファイル [_3] で検出された\n関連グループ項目がここに示されます。\n\n[_4]\n と、POWER ファイル (/etc/group) で検出された関連グループ項目がここに示されます。\n\n[_5]\n で、各フィールドは、グループ・アカウント、パスワード、グループ ID、およびこのグループの\nメンバーであるユーザーをそれぞれ表します。\n\n可能性はかなり低いですが、これが重大なセキュリティー・リスクを表す場合があります。グループ ID [_6] に相当する\n ID は未確定であるためです。\n\nこの E メールの受信を今後停止するためには、2 つのオプションがあります。セキュリティー・リスクが関与しないと\n考えられる場合は、グループ ID [_7] を、/etc/opt/powervm-lx86/gid_ignore 内にあるホワイトリスト・\nファイルに追加できます。そうでない場合は、x86 World 内の [_8] というグループ ID を変更して、\n問題を解決することをお勧めします。ただし、この変更を行う前に、\nまず、次のコマンドを実行して、 PowerVM Lx86 をシャットダウンする「必要があります」。\n\n/etc/init.d/powervm-lx86 stop\n\n現在、PowerVM Lx86 プロセスがグループ [_9] として実行されている場合があるためです。次に、\n新しい固有のグループ\n ID をグループ [_10] 用に選択し、このグループ ID が x86 World または POWER グループ・ファイルのどちらかにまだ存在していないことを確認する必要があります。
グループ [_11] のグループ ID を変更する、\n最も簡単な方法は、x86 World グループ・\nファイルを手動で編集して、グループ ID を適宜更新することです。最後に、グループ ID [_12] が所有する、x86 World 内の\nすべてのファイルの所有権を更新する必要があります。x86 World 内のファイルの所有権を\n更新する方法は複数ありますが、実行可能な\n 1 つの単純なコマンドは、次のものです。\n\n /bin/chown --from=:[_13] -R :<new group id> [_14]\n\n注意: この段階で間違いがあると、ご使用の x86 World と\n POWER システムの両方を損傷する可能性があります。\n\nその場合、以下のコマンドで PowerVM Lx86 を再始動できます。 \n\n  /etc/init.d/powervm-lx86 start\n\n",
  );

1;
