# NOTICE_START
# Licensed Materials - Property of IBM
# "Restricted Materials of IBM" -- 5746-SM2
# (C) Copyright IBM Corp. 2007, 2008 All Rights Reserved.
# US Government Users Restricted Rights - Use, duplication or disclosure
# restricted by GSA ADP Schedule Contract with IBM Corp.
# NOTICE_END

package powervm_lx86_scripts::L10N::es;
use encoding 'utf8';
use base 'powervm_lx86_scripts::L10N';

our %Lexicon =
  (
    _AUTO => 1,

    "New user account ('[_1]') found in [_2]." =>
    "Se ha encontrado una cuenta de usuario nueva ('[_1]') en [_2].",

    "Aliased user id ('[_1]') found in [_2]." =>
    "Se ha encontrado un ID de usuario con alias ('[_1]') en [_2].",

    "New group ('[_1]') found in [_2]." =>
    "Se ha encontrado un grupo nuevo ('[_1]') en [_2].",

    "Aliased group id ('[_1]') found in [_2]." =>
    "Se ha encontrado un ID de grupo con alias ('[_1]') en [_2].",

    "You must be root to run this script." =>
    "Debe ser root para ejecutar este script.",

    "Failed to get current set of mount entries." =>
    "No se ha podido obtener el conjunto actual de entradas de montaje.",

    "The powervm-lx86-daemon is not running. Please start the powervm-lx86-daemon." =>
    "El powervm-lx86-daemon no está en ejecución. Inicie el powervm-lx86-daemon.",

    "Unrecognised option 'WORLD_CHECK_OR_SYNC=[_1]'." =>
    "Opción no reconocida 'WORLD_CHECK_OR_SYNC=[_1]'.",

    "Directory [_1] does not exist." =>
    "El directorio [_1] no existe.", 

    "Cannot open \"[_1]\": [_2]." =>
    "No se puede abrir \"[_1]\": [_2].",

    "Cannot open \"[_1]\" for reading: [_2]." =>
    "No se puede abrir \"[_1]\" para lectura: [_2].", 
    
    "Cannot open \"[_1]\" for writing: [_2]." =>
    "No se puede abrir \"[_1]\" para escritura: [_2].", 

    "(Unable to run command '[_1] /usr/bin/id [_2]')" =>
    "(No se puede ejecutar el mandato '[_1] /usr/bin/id [_2]')",

    "_EMAIL_DISABLE" => "(Este correo ha sido generado por el script cron [_1] y se puede\ninhabilitar estableciendo la variable de configuración WORLD_CHECK_OR_SYNC=none en /etc/opt/powervm-lx86/config)\n",

    "_NEW_USER_EMAIL" => "En el archivo de contraseñas de x86 World ([_1]) se ha encontrado una nueva cuenta de usuario\nque no está presente en el archivo de contraseñas de Power. La entrada de contraseña relevante encontrada\nen [_2] es la siguiente:\n\n  [_3]\ndonde los campos representan la cuenta de usuario, la contraseña, el ID de usuario, el ID de grupo\nprimario, el comentario, el directorio inicial y la shell predeterminada, respectivamente. Además, la salida del\nmandato traducido '/usr/bin/id [_4]' es la siguiente\n\n  [_5]\ndonde el segundo campo muestra el grupo primario y el tercer campo muestra\nla lista de todos los grupos a los que pertenece el usuario [_6], incluidos el\ngrupo primario y los suplementarios.\n\nPara dejar de recibir este correo electrónico en el futuro, tiene dos opciones. La primera\nes añadir el usuario [_7] al archivo whitelist de usuario situado en\n/etc/opt/powervm-lx86/user_ignore. En este caso, no hace falta que añada el usuario a la\ncara Power, y este usuario se ignorará en el futuro. La segunda opción es añadir\nusted mismo el usuario en la cara Power. Una manera de hacerlo (pero no necesariamente\nla más completa) es ejecutar el siguiente mandato en una shell Power nativa:\n\n  /usr/sbin/useradd -m -d <directorio inicial> [_8]\n\nPara replicar completamente la instalación de x86 World, deberá asegurarse de que\ntodos los grupos a los que pertenece el usuario [_9] existen en la cara Power y luego\nestablecer el grupo primario y los suplementarios para el usuario [_10] de acuerdo con ello\n\n",

    "_NEW_GROUP_EMAIL" => "En el archivo de grupos de x86 World ([_1]) se ha encontrado una nueva cuenta de grupo\nque no está presente en el archivo de grupos de Power. La entrada de grupo relevante encontrada\nen [_2] es la siguiente:\n\n  [_3]\ndonde los campos representan la cuenta de grupo, la contraseña, el ID del grupo y los usuarios\nmiembros de este grupo, respectivamente.\n\nPara dejar de recibir este correo electrónico en el futuro, tiene dos opciones. La primera\nes añadir el grupo [_4] al archivo whitelist de grupo situado en\n/etc/opt/powervm-lx86/group_ignore. En este caso, no hace falta que añada el grupo a la\ncara Power, y este grupo se ignorará en el futuro. La segunda opción es añadir\nusted mismo el grupo a la cara Power. Una manera de hacerlo (pero no necesariamente\nla más completa) es ejecutar el siguiente mandato en una shell Power nativa:\n\n  /usr/sbin/groupadd [_5]\n\n",

    "_NEW_UID_ALIAS_EMAIL" => "En el archivo de contraseñas de x86 World ([_1]) se ha encontrado una cuenta de usuario que comparte\nel mismo ID de usuario ([_2]) con una cuenta del archivo de contraseñas de Power (/etc/passwd). La\nentrada de contraseña relevante encontrada en el archivo de x86 World ([_3]) es la siguiente:\n\n  [_4]\ny la entrada de contraseña relevante encontrada en el archivo de Power (/etc/passwd) es la siguiente:\n\n  [_5]\ndonde los campos representan la cuenta de usuario, la contraseña, el ID de usuario, el ID de grupo\nprimario, el comentario, el directorio inicial y la shell predeterminada, respectivamente.\n\nAunque es muy improbable, esto puede representar un grave riesgo para la seguridad, dado que la\nidentidad correspondiente al ID de usuario [_6] es ambigua.\n\nPara dejar de recibir este correo electrónico en el futuro, tiene dos opciones. Si piensa\nque no hay implicado ningún riesgo para la seguridad, puede añadir el ID de usuario [_7] al archivo whitelist\nsituado en /etc/opt/powervm-lx86/uid_ignore. En caso contrario, le recomendamos que corrija el\nproblema cambiando el ID de usuario de [_8], en x86 World. Sin embargo, antes de hacerlo,\nprimero DEBE concluir PowerVM Lx86 ejecutando el mandato:\n\n  /etc/init.d/powervm-lx86 stop\n\nporque en este momento puede haber procesos de PowerVM Lx86 que se estén ejecutando como usuario [_9]. Luego,\ndebe elegir un nuevo ID de usuario exclusivo para el usuario [_10], asegurándose\nde que este ID de usuario no exista ya en el archivo de contraseñas de x86 World ni en el de Power. La manera más sencilla\nde cambiar el ID del usuario [_11] es editar manualmente el archivo de contraseñas de\nx86 World, actualizando debidamente el ID de usuario. Por último, debe actualizar la propiedad de\ntodos los archivos de x86 World que sean propiedad del ID de usuario [_12]. Hay varias maneras de\nactualizar la propiedad de los archivos de x86 World, pero se puede hacer ejecutando\nun simple mandato:\n\n  /bin/chown --from=[_13] -R <id de usuario nuevo> [_14]\n\nPRECAUCIÓN: los posibles errores
que se cometan en esta etapa podrían dañar el sistema x86 World y\nel sistema Power.\n\nLuego, debe poder reiniciar PowerVM Lx86 con el mandato\n\n  /etc/init.d/powervm-lx86 start\n\n",

    "_NEW_GID_ALIAS_EMAIL" => "En el archivo de grupos de x86 World ([_1]) se ha encontrado una cuenta de grupo que comparte\nel mismo ID de grupo ([_2]) con una cuenta existente en el archivo de grupos de Power (/etc/group). La\nentrada de grupo relevante encontrada en el archivo de x86 World ([_3]) es la siguiente:\n\n  [_4]\ny la entrada de grupo relevante encontrada en el archivo de Power (/etc/group) es la siguiente:\n\n  [_5]\ndonde los campos representan la cuenta de grupo, la contraseña, el ID de grupo y los usuarios\nmiembros de este grupo, respectivamente.\n\nAunque es muy improbable, esto puede representar un grave riesgo para la seguridad, dado que la\nidentidad correspondiente al ID de grupo [_6] es ambigua.\n\nPara dejar de recibir este correo electrónico en el futuro, tiene dos opciones. Si piensa\nque no hay implicado ningún riesgo para la seguridad, puede añadir el ID de grupo [_7] al archivo whitelist\nsituado en /etc/opt/powervm-lx86/gid_ignore. En caso contrario, le recomendamos que corrija el\nproblema cambiando el ID de grupo de [_8] en x86 World. Sin embargo, antes de hacerlo,\nprimero debe concluir PowerVM Lx86, ejecutando el mandato:\n\n  /etc/init.d/powervm-lx86 stop\n\nporque en este momento puede haber procesos de PowerVM Lx86 que se estén ejecutando como grupo [_9]. Luego,\ndebe elegir un nuevo ID de grupo exclusivo para el grupo [_10], asegurándose de que este ID de\ngrupo no exista ya en el archivo de grupo de x86 World ni en el de Power. La manera más sencilla\nde cambiar el ID del grupo [_11] es editar manualmente el archivo de grupos de x86 World,\nactualizando debidamente el ID de grupo. Por último, debe actualizar la propiedad de todos\nlos archivos de x86 World que sean propiedad del ID de grupo [_12]. Hay varias maneras de\nactualizar la propiedad de los archivos de x86 World, pero se puede hacer ejecutando\nun simple mandato:\n\n /bin/chown --from=:[_13] -R :<id de grupo nuevo> [_14]\n\nPRECAUCIÓN: los posibles errores que se cometan en esta etapa podrían dañar el sistema x86 World y\nel sistema Power.\n\nLuego, debe poder reiniciar PowerVM Lx86 con el mandato\n\n  /etc/init.d/powervm-lx86 start\n\n",
  );

1;
