# NOTICE_START
# Licensed Materials - Property of IBM
# "Restricted Materials of IBM" -- 5746-SM2
# (C) Copyright IBM Corp. 2007, 2008 All Rights Reserved.
# US Government Users Restricted Rights - Use, duplication or disclosure
# restricted by GSA ADP Schedule Contract with IBM Corp.
# NOTICE_END

package powervm_lx86_scripts::L10N::en_gb;
use encoding 'utf8';
use base 'powervm_lx86_scripts::L10N';

our %Lexicon =
  (
   _AUTO => 1,

    "_EMAIL_DISABLE" => "(This mail was generated by the cron script [_1] and can\nbe disabled by setting the configuration variable WORLD_CHECK_OR_SYNC=none in /etc/opt/powervm-lx86/config)\n",

    "_NEW_USER_EMAIL" => "A new user account has been found in the x86 World password file ([_1])\nthat is not present in the Power password file. The relevant password entry found\nin [_2] is shown here:\n\n  [_3]\nwhere the fields represent the user account, password, user id, primary group\nid, comment, home directory and default shell, respectively. Also, the output of the\ntranslated command '/usr/bin/id [_4]' is shown below\n\n  [_5]\nwhere the second field shows the primary group and the third field shows\nthe full list of groups to which user [_6] belongs, including the\nprimary and supplementary groups.\n\nIn order to stop receiving this email in future you have two options. The first\noption is to add the user [_7] to the user whitelist file found in\n/etc/opt/powervm-lx86/user_ignore. In this case you don't need to add the user to the\nPower side and this user will be ignored in future. The second option is to add\nthe user on the Power side yourself. One way of doing this (but not necessarily\nthe most complete) is to execute the following command in a native Power shell:\n\n  /usr/sbin/useradd -m -d <home directory> [_8]\n\nTo replicate the x86 World setup completely you will have to ensure that all the\ngroups to which user [_9] is a member exist on the Power side and then\nset both the primary and supplementary groups for the user [_10] accordingly.\n\n",

    "_NEW_GROUP_EMAIL" => "A new group account has been found in the x86 World group file ([_1])\nthat is not present in the Power group file. The relevant group entry found\nin [_2] is shown here:\n\n  [_3]\nwhere the fields represent the group account, password, group id, and users that\nare members of this group, respectively.\n\nIn order to stop receiving this email in future you have two options. The first\noption is to add the group [_4] to the group whitelist file found in\n/etc/opt/powervm-lx86/group_ignore. In this case you don't need to add the group to the\nPower side and this group will be ignored in future. The second option is to add\nthe group on the Power side yourself. One way of doing this (but not necessarily\nthe most complete) is to execute the following command in a native Power shell:\n\n  /usr/sbin/groupadd [_5]\n\n",

    "_NEW_UID_ALIAS_EMAIL" => "A user account has been found in the x86 World password file ([_1]) that shares\nthe same user id ([_2]) with an account found in the Power password file (/etc/passwd). The\nrelevant password entry found in the x86 World file ([_3]) is shown here:\n\n  [_4]\nand the relevant password entry found in the Power file (/etc/passwd) is shown here:\n\n  [_5]\nwhere the fields represent the user account, password, user id, primary group\nid, comment, home directory and default shell, respectively.\n\nAlthough highly unlikely, this could represent a serious security risk, since the\nidentity corresponding to user id [_6] is ambiguous.\n\nIn order to stop receiving this email in future you have two options. If you believe\nthere to be no security risk involved then you can add the user id [_7] to the whitelist\nfile found in /etc/opt/powervm-lx86/uid_ignore. Otherwise, it is recommended that you rectify the\nproblem by changing the user id of [_8] in the x86 World. However, before doing so\nyou MUST first shut down PowerVM Lx86 by running the command:\n\n  /etc/init.d/powervm-lx86 stop\n\nsince there may currently be PowerVM Lx86 processes running as user [_9]. Next,\nyou need to choose a new, unique user id for user [_10], ensuring that this user\nid does not already exist in either the x86 World or Power password files. The simplest way\nto change the user id of user [_11] is to manually edit the x86 World password\nfile, updating the user id accordingly. Finally, you must update the ownership of\nall files in the x86 World that are owned by user id [_12]. There are several ways to\nupdate the ownership on files in the x86 World, however here is one simple command\nyou can run:\n\n  /bin/chown --from=[_13] -R <new user id> [_14]\n\nCAUTION: Any mistakes made at this stage could damage both your x86 world and your\n         power system.\n\nYou should then be able to restart PowerVM Lx86 with the following command\n\n  /etc/init.d/powervm-lx86 start\n\n",

    "_NEW_GID_ALIAS_EMAIL" => "A group account has been found in the x86 World group file ([_1]) that shares\nthe same group id ([_2]) with an account found in the Power group file (/etc/group). The\nrelevant group entry found in the x86 World file ([_3]) is shown here:\n\n  [_4]\nand the relevant group entry found in the Power file (/etc/group) is shown here:\n\n  [_5]\nwhere the fields represent the group account, password, group id, and users that\nare members of this group, respectively.\n\nAlthough highly unlikely, this could represent a serious security risk, since the\nidentity corresponding to group id [_6] is ambiguous.\n\nIn order to stop receiving this email in future you have two options. If you believe\nthere to be no security risk involved then you can add the group id [_7] to the whitelist\nfile found in /etc/opt/powervm-lx86/gid_ignore Otherwise, it is recommended that you rectify the\nproblem by changing the group id of [_8] in the x86 World. However, before doing so\nyou MUST first shut down PowerVM Lx86 by running the command:\n\n  /etc/init.d/powervm-lx86 stop\n\nsince there may currently be PowerVM Lx86 processes running as group [_9]. Next,\nyou need to choose a new, unique group id for group [_10], ensuring that this group\nid does not already exist in either the x86 World or Power group files. The simplest way\nto change the group id of group [_11] is to manually edit the x86 World group\nfile, updating the group id accordingly. Finally, you must update the ownership of\nall files in the x86 World that are owned by group id [_12]. There are several ways to\nupdate the ownership on files in the x86 World, however here is one simple command\nyou can run:\n\n  /bin/chown --from=:[_13] -R :<new group id> [_14]\n\nCAUTION: Any mistakes made at this stage could damage both your x86 world and your\n         power system.\n\nYou should then be able to restart PowerVM Lx86 with the following command\n\n  /etc/init.d/powervm-lx86 start\n\n",
  );

1;
