# NOTICE_START
# Licensed Materials - Property of IBM
# "Restricted Materials of IBM" -- 5746-SM2
# (C) Copyright IBM Corp. 2007, 2008 All Rights Reserved.
# US Government Users Restricted Rights - Use, duplication or disclosure
# restricted by GSA ADP Schedule Contract with IBM Corp.
# NOTICE_END

package powervm_lx86_scripts::L10N::de;
use encoding 'utf8';
use base 'powervm_lx86_scripts::L10N';

our %Lexicon =
  (
    _AUTO => 1,

    "New user account ('[_1]') found in [_2]." =>
    "Neues Benutzerkonto ('[_1]') in [_2] gefunden.",

    "Aliased user id ('[_1]') found in [_2]." =>
    "In [_2] wurde der neue Aliasname der Benutzer-ID ('[_1]') gefunden.",

    "New group ('[_1]') found in [_2]." =>
    "In [_2] wurde die neue Gruppe ('[_1]') gefunden. ",

    "Aliased group id ('[_1]') found in [_2]." =>
    "In [_2] wurde der neue Aliasname der Gruppen-ID ('[_1]') gefunden. ",

    "You must be root to run this script." =>
    "Dieses Script kann nur von Root ausgeführt werden.",

    "Failed to get current set of mount entries." =>
    "Die aktuelle Gruppe von Mount-Einträgen konnte nicht abgerufen werden.",

    "The powervm-lx86-daemon is not running. Please start the powervm-lx86-daemon." =>
    "powervm-lx86-daemon ist nicht aktiv. Starten Sie powervm-lx86-daemon.",

    "Unrecognised option 'WORLD_CHECK_OR_SYNC=[_1]'." =>
    "Die Option 'WORLD_CHECK_OR_SYNC=[_1]' wurde nicht erkannt.",

    "Directory [_1] does not exist." =>
    "Das Verzeichnis [_1] ist nicht vorhanden.", 

    "Cannot open \"[_1]\": [_2]." =>
    "Öffnen von \"[_1]\" nicht möglich: [_2].",

    "Cannot open \"[_1]\" for reading: [_2]." =>
    "Nicht möglich \"[_1]\" zum Lesen zu öffnen: [_2].", 
    
    "Cannot open \"[_1]\" for writing: [_2]." =>
    "Nicht möglich \"[_1]\" zum Schreiben zu öffnen: [_2].", 

    "(Unable to run command '[_1] /usr/bin/id [_2]')" =>
    "(Befehl '[_1] /usr/bin/id [_2]' konnte nicht ausgeführt werden.)",

    "_EMAIL_DISABLE" => "(Diese E-Mail wurde vom cron-Script [_1] generiert und kann inaktiviert\nwerden, indem Sie die Einstellung der Umgebungsvariable von WORLD_CHECK_OR_SYNC=none in /etc/opt/powervm-lx86/config ändern.)\n",

    "_NEW_USER_EMAIL" => "In der x86-World-Kennwortdatei ([_1]) wurde ein neues Benutzerkonto gefunden,\ndas nicht in der Power-Kennwortdatei vorhanden ist. Der entsprechende Kennworteintrag, der\nin [_2] gefunden wurde, wird hier angezeigt:\n\n  [_3]\nZu den Feldern gehören Benutzerkonto, Kennwort, Benutzer-ID, primäre Gruppen-ID,\nKommentar, Ausgangsverzeichnis bzw. Standard-Shell. Die Ausgabe des \nübersetzten Befehls '/usr/bin/id [_4]' wird außerdem unten angezeigt.\n\n  [_5]\nHier wird im zweiten Feld die primäre Gruppe (primary group) und im dritten Feld wird die\nvollständige Liste der Gruppen angezeigt, der Benutzer [_6] angehört, einschließlich\nprimäre und ergänzende Gruppen.\n\nWenn Sie diese E-Mail in Zukunft nicht mehr empfangen möchten, gibt es zwei Optionen. Die erste Option\nbesteht darin, den Benutzer [_7] der Benutzer-Whitelist-Datei in\n/etc/opt/powervm-lx86/user_ignore hinzuzufügen. In diesem Fall müssen Sie den Benutzer nicht \nPower-seitig hinzufügen, und der Benutzer wird in Zukunft ignoriert. Die zweite Option besteht darin,\nden Benutzer selbst Power-seitig hinzuzufügen. Sie können hierfür (wenngleich dies nicht der vollständigste Weg ist)\nden folgenden Befehl in einer nativen Power-Shell ausführen: \n\n  /usr/sbin/useradd -m -d <Ausgangsverzeichnis> [_8]\n\nWenn Sie die x86-World-Konfiguration vollständig replizieren möchten, müssen Sie sicherstellen,\ndass Gruppen, die Benutzer [_9] als Mitglied enthalten, Power-seitig vorhanden sind, und\nanschließend die primären und ergänzenden Gruppen für den Benutzer [_10] entsprechend konfigurieren.\n\n",

    "_NEW_GROUP_EMAIL" => "In der x86-World-Gruppendatei ([_1]) wurde ein neues Gruppenkonto gefunden,\ndas nicht in der Power-Gruppendatei vorhanden ist. Der entsprechende Gruppeneintrag, der\nin [_2] gefunden wurde, wird hier angezeigt:\n\n  [_3]\nZu den Feldern gehören Gruppenkonto, Kennwort, Gruppen-ID bzw. Benutzer,\ndie Mitglieder dieser Gruppe sind.\n\nWenn Sie diese E-Mail in Zukunft nicht mehr empfangen möchten, gibt es zwei Optionen. Die erste\nOption besteht darin, die Gruppe [_4] der Gruppen-Whitelist-Datei in\n/etc/opt/powervm-lx86/group_ignore hinzuzufügen. In diesem Fall müssen Sie die Gruppe nicht\nPower-seitig hinzufügen, und diese Gruppe wird in  Zukunft ignoriert. Die zweite Option besteht darin,\ndie Gruppe selbst Power-seitig hinzuzufügen. Sie können hierfür (wenngleich dies nicht der vollständigste Weg ist)\nden folgenden Befehl in einer nativen Power-Shell ausführen:\n\n  /usr/sbin/groupadd [_5]\n\n",

    "_NEW_UID_ALIAS_EMAIL" => "In der x86-World-Kennwortdatei ([_1]) wurde ein Benutzerkonto gefunden,\n
das dieselbe Benutzer-ID ([_2]) verwendet wie ein Konto in der Power-Kennwortdatei (/etc/passwd). Der\n
entsprechende Kennworteintrag aus der x86-World-Datei ([_3]) sieht folgendermaßen aus:\n\n  [_4]\n
Der entsprechenden Kennworteintrag aus der Power-Datei (/etc/passwd) sieht folgendermaßen aus:\n\n  [_5]\n
Zu den Fehldern gehören Konto, Kennwort, Benutzer-ID, primäre Gruppen-ID,\nKommentar, Ausgangsverzeichnis bzw.
Standard-Shell.\n\nDies könnte möglicherweise ein ernsthaftes Sicherheitsrisiko darstellen,\nda die der Benutzer-ID
[_6] entsprechende Identität zweideutig ist.\n\nWenn Sie diese E-Mail zukünftig nicht mehr empfangen möchten, haben
Sie zwei Möglichkeiten. Wenn Ihrer Meinung nach kein\nSicherheitsrisiko vorliegt, können Sie die Benutzer-ID [_7] der\nWhitelist-Datei in /etc/opt/powervm-lx86/uid_ignore hinzufügen. Andernfalls wird empfohlen, dass Sie das Problem beheben, indem\nSie die Benutzer-ID von [_8] in x86 World ändern. Sie müssen\njedoch vorher unbedingt
PowerVM Lx86 herunterfahren. Setzen Sie hierzu folgenden Befehl ab:\n\n  /etc/init.d/powervm-lx86 stop\n\nDies ist erforderlich, da zurzeit möglicherweise PowerVM Lx86-Prozesse unter Benutzer [_9] ausgeführt werden.\nSie müssen anschließend eine neue, eindeutige Benutzer-ID für Benutzer [_10] bestimmen und sicherstellen,\ndass diese Benutzer-ID nicht bereits in den
Kennwortdateien von x86 World und Power vorhanden ist.\nDie einfachste Methode besteht darin, die Benutzer-ID von Benutzer [_11] manuell in der der x86-World-Kennwortdatei\nzu ändern, und die Benutzer-ID
entsprechend zu aktualisieren. Abschließend müssen Sie den Eigner\naller Dateien in x86 World ändern, die von der Benutzer-ID [_12] verwendet werden. Sie können\nden Eigner von
Dateien in x86 World ändern, indem Sie den folgenden einfachen\nBefehl ausführen:\n\n  /bin/chown --from=[_13] -R <neue_Benutzer-ID> [_14]\n\nVorischt: Jeder Fehler, den Sie zu diesem Zeitpunkt machen,
kann sowohl Ihr x86-World- und Ihre \n         Power-System beschädigen.\n\nSie sollten anschließend PowerVM Lx86 mit dem folgenden Befehl erneut starten:\n\n  /etc/init.d/powervm-lx86 start\n\n",

    "_NEW_GID_ALIAS_EMAIL" => "In der x86-World-Gruppendatei ([_1]) wurde ein Gruppenkonto gefunden,\ndas dieselbe Gruppe-ID ([_2]) verwendet wie ein Konto in der Power-Gruppendatei (/etc/group). Der\nentsprechende Gruppeneintrag in der x86-World-Datei ([_3]) sieht folgendermaßen aus:\n\n  [_4]\nDer entsprechende Gruppeneintrag in der Power-Datei (/etc/group) sieht folgendermaßen aus:\n\n  [_5]\nZu den Feldern gehören Gruppenkonto, Kennwort, Gruppen-ID bzw. Benutzer, die\nMitglieder dieser Gruppe sind.\n\nDies könnte möglicherweise ein ernsthaftes Sicherheitsrisiko darstellen,\nda die der
Gruppen-ID [_6] entsprechende Identität zweideutig ist.\n\nWenn Sie diese E-Mail zukünftig nicht mehr empfangen möchten, haben Sie zwei Möglichkeiten. Wenn Ihrer Meinung nach kein\nSicherheitsrisiko vorliegt, können Sie
die Gruppen-ID [_7] der Whitelist-Datei\nin /etc/opt/powervm-lx86/gid_ignore hinzufügen. Andernfalls wird empfohlen, dass Sie das Problem beheben, indem\nSie die Gruppen-iD von [_8] in x86 World ändern. Sie müssen\njedoch vorher unbedingt PowerVM Lx86 herunterfahren. Setzen Sie hierzu den folgenden Befehl ab:\n\n  /etc/init.d/powervm-lx86 stop\n\nDies ist erforderlich, da zurzeit möglicherweise PowerVM Lx86-Prozesse unter Gruppe [_9] ausgeführt werden.\nSie müssen anschließend eine neue, eindeutige Gruppen-ID für Gruppe [_10] bestimmen und sicherstellen, dass\ndiese Gruppen-ID nicht bereits in den Gruppendateien von x86 World oder Power vorhanden ist. Die einfachste Methode besteht darin,\ndie Gruppen-ID der Gruppe [_11] manuell in der x86-World-Gruppendatei\nzu ändern, und die Gruppen-ID entsprechend zu aktualisieren. Abschließend müssen Sie den Eigner\naller Dateien in x86 World ändern, die von der Gruppen-ID [_12] verwendet werden. Sie können\nden Eigner von Dateien in x86 World ändern, indem Sie den folgenden einfachen\nBefehl ausführen:\n\n  /bin/chown --from=:[_13] -R :<neue_Gruppen-ID> [_14]\n\nVorsicht: Jeder Fehler, den Sie zu diesem Zeitpunkt machen, kann sowohl Ihr x86-World- und Ihr\n         Power-System beschädigen.\n\nSie sollten anschließend PowerVM Lx86 mit dem folgenden Befehl erneut starten:\n\n  /etc/init.d/powervm-lx86 start\n\n",
  );

1;
