# Copyright 1999-2014 Gentoo Foundation
# Distributed under the terms of the GNU General Public License v2
# $Header: /var/cvsroot/gentoo-x86/media-libs/libsdl/libsdl-1.2.15-r4.ebuild,v 1.12 2014/05/15 16:15:03 ulm Exp $

EAPI=5
inherit autotools flag-o-matic multilib toolchain-funcs eutils

DESCRIPTION="Simple Direct Media Layer SPU libraries"
HOMEPAGE="http://www.libsdl.org/"
SRC_URI="http://www.libsdl.org/release/SDL-1.2.15.tar.gz"

LICENSE="LGPL-2.1"
SLOT="0"
KEYWORDS="ppc64"
# WARNING:
# If you turn on the custom-cflags use flag in USE and something breaks,
# you pick up the pieces.  Be prepared for bug reports to be marked INVALID.
IUSE="static-libs"

RDEPEND="	sys-devel/crossdev
		cross-spu-elf/gcc"
S=${WORKDIR}/SDL-1.2.15

src_prepare() {
	epatch \
		"${FILESDIR}"/${P}-makefile.patch
}

src_configure() {
	ewarn "SDL SPU libs will not emerge properly without a SPU toolchain"
	ewarn "Run the following command and emerge again:"
	ewarn "  crossdev -t spu --ov-output /usr/spu-elf-gcc/portage"
}

src_install() {
	pushd src/video/ps3/spulibs || die
	emake DESTDIR="${D}" install
	if use static-libs ; then
		emake DESTDIR="${D}" install-static
	fi
	popd || die
}
