/*************************************************************************/
/*                                                                       */
/* Licensed Materials - Property of IBM                                  */
/*                                                                       */
/*                                                                       */
/* (C) Copyright IBM Corp. 2011                                          */
/* All Rights Reserved                                                   */
/*                                                                       */
/* US Government Users Restricted Rights - Use, duplication or           */
/* disclosure restricted by GSA ADP Schedule Contract with IBM Corp.     */
/*                                                                       */
/*************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#ifdef __APPLE__
#include <OpenCL/opencl.h>
#include <stdint.h>
#else
#include <CL/opencl.h>
#endif
#include "clu.h"

////////////////////////////////////////////////////////////////////////////////

int main(int argc, char *argv[])
{
  int i, j;
  cl_uint num_platforms, num_devices;
  cl_platform_id *platform_ids;
  cl_device_id *device_ids;
  clu_t clu;

  /* Get the number of platforms */
  CLU_CHECK_ERROR("clGetPlatformIDs", clGetPlatformIDs(0, NULL, &num_platforms));
  if (num_platforms) {

    if ((platform_ids = (cl_platform_id *)malloc(num_platforms * sizeof(cl_platform_id))) == NULL) {
      CLU_EXIT_ERROR("Unsucessful allocation of a %d entry platform id array.\n", num_platforms);
    }
    CLU_CHECK_ERROR("clGetPlatformIDs", clGetPlatformIDs(num_platforms, platform_ids, NULL));

    /* For each platform */
    for (i=0; i<num_platforms; i++) {
      clu = cluInit(platform_ids[i]);

      /* Print the platform info */
      printf("*******************************************************************\n");
      printf(" PLATFORM %d\n", i);
      printf("*******************************************************************\n");
      cluPrintPlatformInfo (clu);

      /* Get the number of devices in this platform */
      CLU_CHECK_ERROR("clGetDeviceIDs", clGetDeviceIDs(platform_ids[i], CL_DEVICE_TYPE_ALL, 0, NULL, &num_devices));
      if (num_devices) {
	if ((device_ids = (cl_device_id *)malloc(num_devices * sizeof(cl_device_id))) == NULL) {
	  CLU_EXIT_ERROR("Unsucessful allocation of a %d entry device id array.\n", num_devices);
	}
	CLU_CHECK_ERROR("clGetDeviceIDs", clGetDeviceIDs(platform_ids[i], CL_DEVICE_TYPE_ALL, num_devices, device_ids, NULL));
	
	/* For each device */
	for (j=0; j<num_devices; j++) {

	  /* Print the device info */
	  printf("**************\n");
	  printf(" DEVICE %d\n", j);
	  printf("**************\n");
	  cluPrintDeviceInfo (device_ids[j]);
	}
	free(device_ids);
      }
      printf("\n");
      cluDestroy (clu);
    }
    free(platform_ids);
  }
  return 0;
}

