/*************************************************************************/
/*                                                                       */
/* Licensed Materials - Property of IBM                                  */
/*                                                                       */
/*                                                                       */
/*                                                                       */
/* (C) Copyright IBM Corp. 2009                                          */
/* All Rights Reserved                                                   */
/*                                                                       */
/* US Government Users Restricted Rights - Use, duplication or           */
/* disclosure restricted by GSA ADP Schedule Contract with IBM Corp.     */
/*                                                                       */
/*************************************************************************/

/*************************************************************************/
/*                                                                       */
/* This sample is an OpenCL Perlin Noise generator, which is based on    */
/* Ken Perlin's Improved Noise implementation found at                   */
/* http://mrl.nyu.edu/~perlin/noise/. See readme.perlin_noise.txt for    */
/* more information.                                                     */
/*                                                                       */
/*************************************************************************/

#ifndef PERLIN_HOST_H_
#define PERLIN_HOST_H_

#include <sys/types.h>

int compute_host_and_verify(int iterations, uint * output_device, int rowstride,
                            int img_height, int img_width, int verify, 
			    float device_mpix, int verbose);

#endif /* PERLIN_HOST_H_ */
