/*************************************************************************/
/*                                                                       */
/* Licensed Materials - Property of IBM                                  */
/*                                                                       */
/* (C) Copyright IBM Corp. 2009, 2010                                    */
/* All Rights Reserved                                                   */
/*                                                                       */
/* US Government Users Restricted Rights - Use, duplication or           */
/* disclosure restricted by GSA ADP Schedule Contract with IBM Corp.     */
/*                                                                       */
/* Inspired by Caltech's Java Applet Fluid Solver at                     */
/* www.multires.caltech.edu/teaching/demos/java/FluidSolver.java         */
/*                                                                       */
/* References:  Visual Simulation of Smoke                               */
/*              R. Fedkiw, J. Stam, H. W. Jensen                         */
/*              SIGGRAPH 2001 Annual Proceedings                         */
/*                                                                       */
/*************************************************************************/


#ifndef __solver_h__
#define __solver_h__	1

struct fluid_solver {
  int n, size;
  float decay;

  float dt;
  float visc;
  float diff;
  unsigned int *imgAccel;

  cl_mem d, dOld;
  cl_mem u, uOld;
  cl_mem v, vOld;
  cl_mem curl;
  cl_mem zero;
  cl_mem temp;
  cl_mem imgData;
};

struct fluid_solver_host {
  int n, size;
  float decay;

  float dt;
  float visc;
  float diff;

  float *dh, *uh, *vh;
  float *dOldh, *uOldh, *vOldh;
  float *curlh;
  float *temph;
  unsigned int *imgDatah;
};


#define _VEC_SIZE	 	4	
#define _PAD			4

#define DEFAULT_IMG_SIZE	512		/* default image size */
#define _DT			(0.2f)
#define _DECAY			0.03f
#define INIT_SIZE               10

#define Ih(_i, _j) 	((_i) + (n + (2 * _PAD)) * (_j))
#define Imh(_i, _j)   	(((_j)-_PAD) * (img_size) + ((_i)-_PAD))

extern int use_async_wg_copy;

extern size_t local_wg_size_add_source[2];	/*  local size for calc with pad */
extern size_t local_wg_size[2];                 /*  local size for calc without pad */
extern int profiling;                           /*  whether profiling is enabled */
extern int verbose;				/*  whether verbose output is enabled */

extern cl_command_queue commands;               /*  compute command queue */
extern cl_kernel set_boundary_kernel;	
extern cl_kernel advect_kernel;	
extern cl_kernel add_source_kernel;	
extern cl_kernel add_source_dual_kernel;	
extern cl_kernel linear_solver_kernel;	
extern cl_kernel project_part1_kernel;	
extern cl_kernel project_part2_kernel;	
extern cl_kernel pack_image_kernel;	

extern int img_size;

/*****************************************************************************/
extern void cleanup_buffers (struct fluid_solver* s);
extern void run_sim (clu_t clu, struct fluid_solver *s, int num_frames);
extern void setup (struct fluid_solver *s, cl_context context, int n, float dt);

extern void run_sim_host (struct fluid_solver_host *s, int num_frames);
extern void setup_host (struct fluid_solver_host *s, int n, float dt);
extern void cleanup_buffers_host (struct fluid_solver_host* s);

#endif /* __solver_h__ */
