/*************************************************************************/
/*                                                                       */
/* Licensed Materials - Property of IBM                                  */
/*                                                                       */
/*                                                                       */
/*                                                                       */
/* (C) Copyright IBM Corp. 2010                                          */
/* All Rights Reserved                                                   */
/*                                                                       */
/* US Government Users Restricted Rights - Use, duplication or           */
/* disclosure restricted by GSA ADP Schedule Contract with IBM Corp.     */
/*                                                                       */
/*************************************************************************/
#ifndef _VIEWER_H_
#define _VIEWER_H_

/*************************************************************************
 * Generic Viewer Interfaces
 *------------------------------------------------------------------------
 */
#include <GL/gl.h>
#include <GL/glut.h>

#ifdef _cplusplus
extern "C" {
#endif

/* Viewer Provided Functions */
extern void initViewer (const char *name, int width, int height, int pixel_size, GLenum format, GLenum type, int quality);
extern void viewerMainLoop();

/* Application Provided Functions */
extern void *next_frame(int **size);
extern void  keyboard_action (unsigned char key, int x, int y);
extern void  mouse_action (int button, int state, int x, int y);
extern void  mouse_motion (int x, int y);

#ifdef _cplusplus
}
#endif

#ifdef REMOTE_VIEWER

/*************************************************************************
 * Remote Viewer Messages 
 *------------------------------------------------------------------------
 */
#include <stdint.h>

enum remote_viewer_msgs { VIEWER_MSG_MOUSE_ACTION = 1, VIEWER_MSG_MOUSE_MOTION, VIEWER_MSG_KEYBOARD_ACTION, VIEWER_MSG_FRAME_ACK };

#define VIEWER_MAX_NAME_LEN			64	/* including termination character */
#define VIEWER_IMAGE_BYTE_ORDER  		0x00010203
#define VIEWER_IMAGE_BYTE_ORDER_REVERSED	0x03020100

typedef struct _viewer_init_info_t {
  char	   name[VIEWER_MAX_NAME_LEN];	/* name to be displayed by the viewer */
  uint32_t byte_order;			/* used to identify if byte swapping is required */
  uint32_t width;			/* image width, in pixels */
  uint32_t height;			/* image height, in pixels */
  uint32_t pixel_size;			/* pixel size in bytes */
  uint32_t format;			/* image format */
  uint32_t type;			/* image type */
  uint32_t quality;			/* quality of encoded images */
} viewer_init_info_t;

typedef struct _viewer_mouse_action_t {
  uint32_t button;			/* either GLUT_LEFT_BUTTON, GLUT_MIDDLE_BUTTON, or GLUT_RIGHT_BUTTON */
  uint32_t state;			/* either GLUT_UP or GLUT_DOWN */
  uint32_t x;				/* horizontal mouse position */
  uint32_t y;				/* vertical mouse position */
} viewer_mouse_action_t;

typedef struct _viewer_keyboard_action_t {
  uint32_t key;				/* ascii key generated by the key pressed */
  uint32_t x;				/* horizontal mouse position */
  uint32_t y;				/* vertical mouse position */
} viewer_keyboard_action_t;

typedef struct _viewer_mouse_motion_t {
  uint32_t x;				/* horizontal mouse position */
  uint32_t y;				/* vertical mouse position */
} viewer_mouse_motion_t;

#endif /* REMOTE_VIEWER */
#endif /*  _VIEWER_H_ */
