/*************************************************************************/
/*                                                                       */
/* Licensed Materials - Property of IBM                                  */
/*                                                                       */
/*                                                                       */
/*                                                                       */
/* (C) Copyright IBM Corp. 2010                                          */
/* All Rights Reserved                                                   */
/*                                                                       */
/* US Government Users Restricted Rights - Use, duplication or           */
/* disclosure restricted by GSA ADP Schedule Contract with IBM Corp.     */
/*                                                                       */
/*************************************************************************/

#ifndef _NETWORK_UTILS_H_
#define _NETWORK_UTILS_H_	1

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <errno.h>
#include <unistd.h>
#include <fcntl.h>

#ifdef _cplusplus
extern "C" {
#endif

int client_network_init (const char* host, int port);
int server_network_init(int port);

size_t block_recv_with_timeout ( int stream, void *buffer, size_t n, double timeout);
size_t block_recv ( int stream, void *buffer, size_t n);
size_t block_send ( int stream, void *buffer, size_t n);

#endif /* _NETWORK_UTILS_H_ */

#ifdef _cplusplus
}
#endif
