/*************************************************************************/
/*                                                                       */
/* Licensed Materials - Property of IBM                                  */
/*                                                                       */
/* (C) Copyright IBM Corp. 2009, 2010                                    */
/* All Rights Reserved                                                   */
/*                                                                       */
/* US Government Users Restricted Rights - Use, duplication or           */
/* disclosure restricted by GSA ADP Schedule Contract with IBM Corp.     */
/*                                                                       */
/*************************************************************************/

#include <stdio.h>
#include <sys/time.h>

static struct timeval time_start, time_interval;

/* 
 * ===  FUNCTION  ======================================================================
 *         Name:  startclock
 *  Description:  Start the clock running, or reset it if it's already running.
 * =====================================================================================
 */
void __attribute__((constructor))
startclock (void)
{
  if (gettimeofday(&time_start, NULL)) {
    perror("Problem starting clock");
  }
  time_interval = time_start;
}

/* 
 * ===  FUNCTION  ======================================================================
 *         Name:  stopclock
 *  Description:  Stop the clock. Return the delta time, in seconds, 
 *                since the last "startclock".
 * =====================================================================================
 */
float stopclock (void)
{
  struct timeval time_stop;
  float seconds;

  if (gettimeofday(&time_stop, NULL)) {
    perror("Problem stopping clock");
  }
  seconds = ((time_stop.tv_sec  - time_start.tv_sec)  + 
	     (time_stop.tv_usec - time_start.tv_usec) * 0.000001f);
		   
  return seconds;
}

/* 
 * ===  FUNCTION  ======================================================================
 *         Name:  intervalclock
 *  Description:  Return the delta time, in seconds, since the last "startclock" or
 *                "intervalclock", which ever was called last.
 * =====================================================================================
 */
float intervalclock (void)
{
  struct timeval time_now;
  float seconds;

  if (gettimeofday(&time_now, NULL)) {
    perror("Problem reading clock");
  }
  seconds = ((time_now.tv_sec  - time_interval.tv_sec)  + 
	     (time_now.tv_usec - time_interval.tv_usec) * 0.000001f);
  time_interval = time_now;

  return seconds;
}

