/*************************************************************************/
/*                                                                       */
/* Licensed Materials - Property of IBM                                  */
/*                                                                       */
/*                                                                       */
/* (C) Copyright IBM Corp. 2009                                          */
/* All Rights Reserved                                                   */
/*                                                                       */
/* US Government Users Restricted Rights - Use, duplication or           */
/* disclosure restricted by GSA ADP Schedule Contract with IBM Corp.     */
/*                                                                       */
/*************************************************************************/

#ifndef _BSOP_H_
#define _BSOP_H_ 1

#define AUTO_KERNEL_TYPE                  0

#define RANGE_LOAD_STORE                  1
#define RANGE_ASYNC_WORKGROUP_COPY        2
#define TASK_LOAD_STORE                   3
#define TASK_DOUBLE_BUFFER                4
#define TASK_SINGLE_BUFFER                5

#define AUTO_VECTOR_WIDTH                 -1
#define AUTO_NTASKS                       -1

#define NONE_BUFFER                       1
#define USE_BUFFER                        2
#define ALLOC_BUFFER                      3
#define COPY_BUFFER                       4
#define ALLOC_COPY_BUFFER                 5

#define DEFAULT_CODE_SELECTOR             AUTO_KERNEL_TYPE
#define DEFAULT_VECTOR_WIDTH              AUTO_VECTOR_WIDTH
#define DEFAULT_ARRAY_SIZE                524288 //2^19
#define DEFAULT_COPY_SIZE                 8192 //8K
#define DEFAULT_NTASKS                    AUTO_NTASKS
#define DEFAULT_VERBOSE_FLAG              0
#define DEFAULT_LOCAL_WORK_GROUP_SIZE     64
#define DEFAULT_DEVICE_TYPE               CL_DEVICE_TYPE_DEFAULT
#define DEFAULT_VERIFY_FLAG               1
#define DEFAULT_DOUBLE_FLAG		  0
#define DEFAULT_NUMA_FLAG                 0
#define DEFAULT_FASTMATH_FLAG             0
#define DEFAULT_BUFFER_SELECTOR 	  ALLOC_BUFFER

#define DEFAULT_CODE_SELECTOR_CPU         RANGE_LOAD_STORE
#define DEFAULT_CODE_SELECTOR_GPU         RANGE_ASYNC_WORKGROUP_COPY
#define DEFAULT_CODE_SELECTOR_ACCELERATOR TASK_DOUBLE_BUFFER

#endif
