/*************************************************************************/
/*                                                                       */
/* Licensed Materials - Property of IBM                                  */
/*                                                                       */
/* (C) Copyright IBM Corp. 2009                                          */
/* All Rights Reserved                                                   */
/*                                                                       */
/* US Government Users Restricted Rights - Use, duplication or           */
/* disclosure restricted by GSA ADP Schedule Contract with IBM Corp.     */
/*                                                                       */
/*************************************************************************/

#ifndef __CL_KERNEL_DEF_H__
#define __CL_KERNEL_DEF_H__

// Kernel binary version value for Binary compatibility
#define __CL_KERNEL_BINARY_VERSION 1

/* __IMAGE_SUPPORT__ is used to determine if the OpenCL device supports images.  This is an
 * integer constant of 1 if images are supported and is undefined otherwise. Also refer to
 * CL_DEVICE_IMAGE_SUPPORT specified in table 4.3.
 */
#undef __IMAGE_SUPPORT__ 

/*
The __EMBEDDED_PROFILE__ macro is added to the language (refer to section 6.9).
It will be the integer constant 1 for OpenCL devices that implement the embedded
profile and is undefined otherwise.
*/
#define __EMBEDDED_PROFILE__  1

#define __CL_MAX_WORK_DIM_SIZE 3

extern unsigned int __g_work_dim;
extern unsigned int __g_group_id[__CL_MAX_WORK_DIM_SIZE];
extern unsigned int __g_global_size[__CL_MAX_WORK_DIM_SIZE];
extern unsigned int __g_group_size[__CL_MAX_WORK_DIM_SIZE];
extern unsigned int __g_group_sub_id[__CL_MAX_WORK_DIM_SIZE-1][__CL_MAX_WORK_DIM_SIZE-1];
extern unsigned int __g_global_offset[__CL_MAX_WORK_DIM_SIZE];
extern unsigned int __g_unit_id;

#endif /* __CL_KERNEL_DEF_H__ */
