/*************************************************************************/
/*                                                                       */
/* Licensed Materials - Property of IBM                                  */
/*                                                                       */
/* (C) Copyright IBM Corp. 2009                                          */
/* All Rights Reserved                                                   */
/*                                                                       */
/* US Government Users Restricted Rights - Use, duplication or           */
/* disclosure restricted by GSA ADP Schedule Contract with IBM Corp.     */
/*                                                                       */
/*************************************************************************/

#ifndef __CL_KERNEL_DEF_H__
#define __CL_KERNEL_DEF_H__

// Kernel binary version value for Binary compatibility
#define __CL_KERNEL_BINARY_VERSION 1

/* __IMAGE_SUPPORT__ is used to determine if the OpenCL device supports images.  This is an
 * integer constant of 1 if images are supported and is undefined otherwise. Also refer to
 * CL_DEVICE_IMAGE_SUPPORT specified in table 4.3.
 */
#undef __IMAGE_SUPPORT__ 

#define __CL_MAX_WORK_DIM_SIZE 3

// we define a structure of our data needs
typedef struct __g_data_struct {
  unsigned int _work_dim;
  unsigned int _group_id[__CL_MAX_WORK_DIM_SIZE];
  unsigned int _global_size[__CL_MAX_WORK_DIM_SIZE];
  unsigned int _group_size[__CL_MAX_WORK_DIM_SIZE];
  unsigned int _group_sub_id[__CL_MAX_WORK_DIM_SIZE-1][__CL_MAX_WORK_DIM_SIZE-1];
  unsigned int _global_offset[__CL_MAX_WORK_DIM_SIZE];
  unsigned int _unit_id;
  unsigned int _pad[14];
} __g_data_t;
// and only have 1 __thread extern, so only 1 _get_tls call..
extern __thread __g_data_t __g_data;

// and do this so that we don't have to change the functions
#define __g_work_dim       __g_data._work_dim
#define __g_group_id       __g_data._group_id
#define __g_global_size    __g_data._global_size
#define __g_group_size     __g_data._group_size
#define __g_group_sub_id   __g_data._group_sub_id
#define __g_global_offset  __g_data._global_offset
#define __g_unit_id        __g_data._unit_id

#endif /* __CL_KERNEL_DEF_H__ */
