/*************************************************************************/
/*                                                                       */
/* Licensed Materials - Property of IBM                                  */
/*                                                                       */
/* (C) Copyright IBM Corp. 2009, 2011                                    */
/* All Rights Reserved                                                   */
/*                                                                       */
/* US Government Users Restricted Rights - Use, duplication or           */
/* disclosure restricted by GSA ADP Schedule Contract with IBM Corp.     */
/*                                                                       */
/*************************************************************************/

#ifndef __CL_KERNEL_BUILTIN_H__
#define __CL_KERNEL_BUILTIN_H__
#include "CL/device/cl_kernel_def_CPU.h"
static inline int2 __isinf_int2 (float2 x) __attribute__ ((pure, simd));
static inline int3 __isinf_int3 (float3 x) __attribute__ ((pure, simd));
static inline int4 __isinf_int4 (float4 x) __attribute__ ((pure, simd));
static inline int8 __isinf_int8 (float8 x) __attribute__ ((pure, simd));
static inline int16 __isinf_int16 (float16 x) __attribute__ ((pure, simd));
static inline int __isinf_int (float x) __attribute__ ((pure, simd));
static inline int2 __signbit_int2 (float2 x) __attribute__ ((pure, simd));
static inline int3 __signbit_int3 (float3 x) __attribute__ ((pure, simd));
static inline int4 __signbit_int4 (float4 x) __attribute__ ((pure, simd));
static inline int8 __signbit_int8 (float8 x) __attribute__ ((pure, simd));
static inline int16 __signbit_int16 (float16 x) __attribute__ ((pure, simd));
static inline int __signbit_int (float x) __attribute__ ((pure, simd));
static inline int2 __isnan_int2 (float2 x) __attribute__ ((pure, simd));
static inline int3 __isnan_int3 (float3 x) __attribute__ ((pure, simd));
static inline int4 __isnan_int4 (float4 x) __attribute__ ((pure, simd));
static inline int8 __isnan_int8 (float8 x) __attribute__ ((pure, simd));
static inline int16 __isnan_int16 (float16 x) __attribute__ ((pure, simd));
static inline int __isnan_int (float x) __attribute__ ((pure, simd));
static inline int2 __isfinite_int2 (float2 x) __attribute__ ((pure, simd));
static inline int3 __isfinite_int3 (float3 x) __attribute__ ((pure, simd));
static inline int4 __isfinite_int4 (float4 x) __attribute__ ((pure, simd));
static inline int8 __isfinite_int8 (float8 x) __attribute__ ((pure, simd));
static inline int16 __isfinite_int16 (float16 x) __attribute__ ((pure, simd));
static inline int __isfinite_int (float x) __attribute__ ((pure, simd));
static inline int2 __isnormal_int2 (float2 x) __attribute__ ((pure, simd));
static inline int3 __isnormal_int3 (float3 x) __attribute__ ((pure, simd));
static inline int4 __isnormal_int4 (float4 x) __attribute__ ((pure, simd));
static inline int8 __isnormal_int8 (float8 x) __attribute__ ((pure, simd));
static inline int16 __isnormal_int16 (float16 x) __attribute__ ((pure, simd));
static inline int __isnormal_int (float x) __attribute__ ((pure, simd));
static inline int2 __isequal_int2 (float2 x, float2 y) __attribute__ ((pure, simd));
static inline int3 __isequal_int3 (float3 x, float3 y) __attribute__ ((pure, simd));
static inline int4 __isequal_int4 (float4 x, float4 y) __attribute__ ((pure, simd));
static inline int8 __isequal_int8 (float8 x, float8 y) __attribute__ ((pure, simd));
static inline int16 __isequal_int16 (float16 x, float16 y) __attribute__ ((pure, simd));
static inline int __isequal_int (float x, float y) __attribute__ ((pure, simd));
static inline int2 __isnotequal_int2 (float2 x, float2 y) __attribute__ ((pure, simd));
static inline int3 __isnotequal_int3 (float3 x, float3 y) __attribute__ ((pure, simd));
static inline int4 __isnotequal_int4 (float4 x, float4 y) __attribute__ ((pure, simd));
static inline int8 __isnotequal_int8 (float8 x, float8 y) __attribute__ ((pure, simd));
static inline int16 __isnotequal_int16 (float16 x, float16 y) __attribute__ ((pure, simd));
static inline int __isnotequal_int (float x, float y) __attribute__ ((pure, simd));
static inline int2 __isgreater_int2 (float2 x, float2 y) __attribute__ ((pure, simd));
static inline int3 __isgreater_int3 (float3 x, float3 y) __attribute__ ((pure, simd));
static inline int4 __isgreater_int4 (float4 x, float4 y) __attribute__ ((pure, simd));
static inline int8 __isgreater_int8 (float8 x, float8 y) __attribute__ ((pure, simd));
static inline int16 __isgreater_int16 (float16 x, float16 y) __attribute__ ((pure, simd));
static inline int __isgreater_int (float x, float y) __attribute__ ((pure, simd));
static inline int2 __isgreaterequal_int2 (float2 x, float2 y) __attribute__ ((pure, simd));
static inline int3 __isgreaterequal_int3 (float3 x, float3 y) __attribute__ ((pure, simd));
static inline int4 __isgreaterequal_int4 (float4 x, float4 y) __attribute__ ((pure, simd));
static inline int8 __isgreaterequal_int8 (float8 x, float8 y) __attribute__ ((pure, simd));
static inline int16 __isgreaterequal_int16 (float16 x, float16 y) __attribute__ ((pure, simd));
static inline int __isgreaterequal_int (float x, float y) __attribute__ ((pure, simd));
static inline int2 __isless_int2 (float2 x, float2 y) __attribute__ ((pure, simd));
static inline int3 __isless_int3 (float3 x, float3 y) __attribute__ ((pure, simd));
static inline int4 __isless_int4 (float4 x, float4 y) __attribute__ ((pure, simd));
static inline int8 __isless_int8 (float8 x, float8 y) __attribute__ ((pure, simd));
static inline int16 __isless_int16 (float16 x, float16 y) __attribute__ ((pure, simd));
static inline int __isless_int (float x, float y) __attribute__ ((pure, simd));
static inline int2 __islessequal_int2 (float2 x, float2 y) __attribute__ ((pure, simd));
static inline int3 __islessequal_int3 (float3 x, float3 y) __attribute__ ((pure, simd));
static inline int4 __islessequal_int4 (float4 x, float4 y) __attribute__ ((pure, simd));
static inline int8 __islessequal_int8 (float8 x, float8 y) __attribute__ ((pure, simd));
static inline int16 __islessequal_int16 (float16 x, float16 y) __attribute__ ((pure, simd));
static inline int __islessequal_int (float x, float y) __attribute__ ((pure, simd));
static inline int2 __islessgreater_int2 (float2 x, float2 y) __attribute__ ((pure, simd));
static inline int3 __islessgreater_int3 (float3 x, float3 y) __attribute__ ((pure, simd));
static inline int4 __islessgreater_int4 (float4 x, float4 y) __attribute__ ((pure, simd));
static inline int8 __islessgreater_int8 (float8 x, float8 y) __attribute__ ((pure, simd));
static inline int16 __islessgreater_int16 (float16 x, float16 y) __attribute__ ((pure, simd));
static inline int __islessgreater_int (float x, float y) __attribute__ ((pure, simd));
static inline int2 __isordered_int2 (float2 x, float2 y) __attribute__ ((pure, simd));
static inline int3 __isordered_int3 (float3 x, float3 y) __attribute__ ((pure, simd));
static inline int4 __isordered_int4 (float4 x, float4 y) __attribute__ ((pure, simd));
static inline int8 __isordered_int8 (float8 x, float8 y) __attribute__ ((pure, simd));
static inline int16 __isordered_int16 (float16 x, float16 y) __attribute__ ((pure, simd));
static inline int __isordered_int (float x, float y) __attribute__ ((pure, simd));
static inline int2 __isunordered_int2 (float2 x, float2 y) __attribute__ ((pure, simd));
static inline int3 __isunordered_int3 (float3 x, float3 y) __attribute__ ((pure, simd));
static inline int4 __isunordered_int4 (float4 x, float4 y) __attribute__ ((pure, simd));
static inline int8 __isunordered_int8 (float8 x, float8 y) __attribute__ ((pure, simd));
static inline int16 __isunordered_int16 (float16 x, float16 y) __attribute__ ((pure, simd));
static inline int __isunordered_int (float x, float y) __attribute__ ((pure, simd));
static inline float4 __pow_float4(float4 x, float4 y) __attribute__ ((pure, simd));
static inline float __pow_float(float x, float y) __attribute__ ((pure, simd));
static inline float2 __pow_float2(float2 x, float2 y) __attribute__ ((pure, simd));
static inline float3 __pow_float3(float3 x, float3 y) __attribute__ ((pure, simd));
static inline float8 __pow_float8(float8 x, float8 y) __attribute__ ((pure, simd));
static inline float16 __pow_float16(float16 x, float16 y) __attribute__ ((pure, simd));
static inline float4 __powr_float4(float4 x, float4 y) __attribute__ ((pure, simd));
static inline float __powr_float(float x, float y) __attribute__ ((pure, simd));
static inline float2 __powr_float2(float2 x, float2 y) __attribute__ ((pure, simd));
static inline float3 __powr_float3(float3 x, float3 y) __attribute__ ((pure, simd));
static inline float8 __powr_float8(float8 x, float8 y) __attribute__ ((pure, simd));
static inline float16 __powr_float16(float16 x, float16 y) __attribute__ ((pure, simd));
static inline float4 __native_powr_float4(float4 x, float4 y) __attribute__ ((pure, simd));
static inline float __native_powr_float(float x, float y) __attribute__ ((pure, simd));
static inline float2 __native_powr_float2(float2 x, float2 y) __attribute__ ((pure, simd));
static inline float3 __native_powr_float3(float3 x, float3 y) __attribute__ ((pure, simd));
static inline float8 __native_powr_float8(float8 x, float8 y) __attribute__ ((pure, simd));
static inline float16 __native_powr_float16(float16 x, float16 y) __attribute__ ((pure, simd));
static inline float __erf_float(float x) __attribute__ ((pure, simd));
static inline float4 __erf_float4(float4 x) __attribute__ ((pure, simd));
static inline float2 __erf_float2(float2 x) __attribute__ ((pure, simd));
static inline float3 __erf_float3(float3 x) __attribute__ ((pure, simd));
static inline float8 __erf_float8(float8 x) __attribute__ ((pure, simd));
static inline float16 __erf_float16(float16 x) __attribute__ ((pure, simd));
static inline float __expm1_float(float x) __attribute__ ((pure, simd));
static inline float4 __expm1_float4(float4 x) __attribute__ ((pure, simd));
static inline float2 __expm1_float2(float2 x) __attribute__ ((pure, simd));
static inline float3 __expm1_float3(float3 x) __attribute__ ((pure, simd));
static inline float8 __expm1_float8(float8 x) __attribute__ ((pure, simd));
static inline float16 __expm1_float16(float16 x) __attribute__ ((pure, simd));
static inline float4 __native_exp2_float4(float4 x) __attribute__ ((pure, simd));
static inline float __native_exp2_float(float x) __attribute__ ((pure, simd));
static inline float2 __native_exp2_float2(float2 x) __attribute__ ((pure, simd));
static inline float3 __native_exp2_float3(float3 x) __attribute__ ((pure, simd));
static inline float8 __native_exp2_float8(float8 x) __attribute__ ((pure, simd));
static inline float16 __native_exp2_float16(float16 x) __attribute__ ((pure, simd));
static inline float __exp2_float(float x) __attribute__ ((pure, simd));
static inline float4 __exp2_float4(float4 x) __attribute__ ((pure, simd));
static inline float2 __exp2_float2(float2 x) __attribute__ ((pure, simd));
static inline float3 __exp2_float3(float3 x) __attribute__ ((pure, simd));
static inline float8 __exp2_float8(float8 x) __attribute__ ((pure, simd));
static inline float16 __exp2_float16(float16 x) __attribute__ ((pure, simd));
static inline float4 __native_exp10_float4(float4 x) __attribute__ ((pure, simd));
static inline float __native_exp10_float(float x) __attribute__ ((pure, simd));
static inline float2 __native_exp10_float2(float2 x) __attribute__ ((pure, simd));
static inline float3 __native_exp10_float3(float3 x) __attribute__ ((pure, simd));
static inline float8 __native_exp10_float8(float8 x) __attribute__ ((pure, simd));
static inline float16 __native_exp10_float16(float16 x) __attribute__ ((pure, simd));
static inline float __exp10_float(float x) __attribute__ ((pure, simd));
static inline float4 __exp10_float4(float4 x) __attribute__ ((pure, simd));
static inline float2 __exp10_float2(float2 x) __attribute__ ((pure, simd));
static inline float3 __exp10_float3(float3 x) __attribute__ ((pure, simd));
static inline float8 __exp10_float8(float8 x) __attribute__ ((pure, simd));
static inline float16 __exp10_float16(float16 x) __attribute__ ((pure, simd));
static inline float4 __native_log2_float4(float4 x) __attribute__ ((pure, simd));
static inline float __native_log2_float(float x) __attribute__ ((pure, simd));
static inline float2 __native_log2_float2(float2 x) __attribute__ ((pure, simd));
static inline float3 __native_log2_float3(float3 x) __attribute__ ((pure, simd));
static inline float8 __native_log2_float8(float8 x) __attribute__ ((pure, simd));
static inline float16 __native_log2_float16(float16 x) __attribute__ ((pure, simd));
static inline float __log2_float(float x) __attribute__ ((pure, simd));
static inline float4 __log2_float4(float4 x) __attribute__ ((pure, simd));
static inline float2 __log2_float2(float2 x) __attribute__ ((pure, simd));
static inline float3 __log2_float3(float3 x) __attribute__ ((pure, simd));
static inline float8 __log2_float8(float8 x) __attribute__ ((pure, simd));
static inline float16 __log2_float16(float16 x) __attribute__ ((pure, simd));
static inline float4 __native_log10_float4(float4 x) __attribute__ ((pure, simd));
static inline float __native_log10_float(float x) __attribute__ ((pure, simd));
static inline float2 __native_log10_float2(float2 x) __attribute__ ((pure, simd));
static inline float3 __native_log10_float3(float3 x) __attribute__ ((pure, simd));
static inline float8 __native_log10_float8(float8 x) __attribute__ ((pure, simd));
static inline float16 __native_log10_float16(float16 x) __attribute__ ((pure, simd));
static inline float __log10_float(float x) __attribute__ ((pure, simd));
static inline float4 __log10_float4(float4 x) __attribute__ ((pure, simd));
static inline float2 __log10_float2(float2 x) __attribute__ ((pure, simd));
static inline float3 __log10_float3(float3 x) __attribute__ ((pure, simd));
static inline float8 __log10_float8(float8 x) __attribute__ ((pure, simd));
static inline float16 __log10_float16(float16 x) __attribute__ ((pure, simd));
static inline float4 __log1p_float4(float4 x) __attribute__ ((pure, simd));
static inline float __log1p_float(float x) __attribute__ ((pure, simd));
static inline float2 __log1p_float2(float2 x) __attribute__ ((pure, simd));
static inline float3 __log1p_float3(float3 x) __attribute__ ((pure, simd));
static inline float8 __log1p_float8(float8 x) __attribute__ ((pure, simd));
static inline float16 __log1p_float16(float16 x) __attribute__ ((pure, simd));
static inline float4 __div_approx_float4(float4 x, float4 y) __attribute__ ((pure, simd));
static inline float8 __div_approx_float8(float8 x, float8 y) __attribute__ ((pure, simd));
static inline float16 __div_approx_float16(float16 x, float16 y) __attribute__ ((pure, simd));
static inline float __div_approx_float(float x, float y) __attribute__ ((pure, simd));
static inline float2 __div_approx_float2(float2 x, float2 y) __attribute__ ((pure, simd));
static inline float4 __pown_float4(float4 x, int4 y) __attribute__ ((pure, simd));
static inline float __pown_float(float x, int y) __attribute__ ((pure, simd));
static inline float2 __pown_float2(float2 x, int2 y) __attribute__ ((pure, simd));
static inline float3 __pown_float3(float3 x, int3 y) __attribute__ ((pure, simd));
static inline float8 __pown_float8(float8 x, int8 y) __attribute__ ((pure, simd));
static inline float16 __pown_float16(float16 x, int16 y) __attribute__ ((pure, simd));
static inline float4 __rootn_float4(float4 x, int4 y) __attribute__ ((pure, simd));
static inline float __rootn_float(float x, int y) __attribute__ ((pure, simd));
static inline float2 __rootn_float2(float2 x, int2 y) __attribute__ ((pure, simd));
static inline float3 __rootn_float3(float3 x, int3 y) __attribute__ ((pure, simd));
static inline float8 __rootn_float8(float8 x, int8 y) __attribute__ ((pure, simd));
static inline float16 __rootn_float16(float16 x, int16 y) __attribute__ ((pure, simd));
static inline float4 __acosh_float4(float4 x) __attribute__ ((pure, simd));
static inline float __acosh_float(float x) __attribute__ ((pure, simd));
static inline float2 __acosh_float2(float2 x) __attribute__ ((pure, simd));
static inline float8 __acosh_float8(float8 x) __attribute__ ((pure, simd));
static inline float16 __acosh_float16(float16 x) __attribute__ ((pure, simd));
static inline float3 __acosh_float3(float3 x) __attribute__ ((pure, simd));
static inline float __asinh_float(float x) __attribute__ ((pure, simd));
static inline float4 __asinh_float4(float4 x) __attribute__ ((pure, simd));
static inline float2 __asinh_float2(float2 x) __attribute__ ((pure, simd));
static inline float3 __asinh_float3(float3 x) __attribute__ ((pure, simd));
static inline float8 __asinh_float8(float8 x) __attribute__ ((pure, simd));
static inline float16 __asinh_float16(float16 x) __attribute__ ((pure, simd));
static inline float4 __atanh_float4(float4 x) __attribute__ ((pure, simd));
static inline float2 __atanh_float2(float2 x) __attribute__ ((pure, simd));
static inline float8 __atanh_float8(float8 x) __attribute__ ((pure, simd));
static inline float16 __atanh_float16(float16 x) __attribute__ ((pure, simd));
static inline float3 __atanh_float3(float3 x) __attribute__ ((pure, simd));
static inline float4 __lgamma_float4(float4 in) __attribute__ ((pure, simd));
static inline float __lgamma_float(float in) __attribute__ ((pure, simd));
static inline float2 __lgamma_float2(float2 in) __attribute__ ((pure, simd));
static inline float3 __lgamma_float3(float3 in) __attribute__ ((pure, simd));
static inline float8 __lgamma_float8(float8 in) __attribute__ ((pure, simd));
static inline float16 __lgamma_float16(float16 in) __attribute__ ((pure, simd));
static inline float4 __lgamma_r_float4(float4 in, int4 *signp) __attribute__ ((pure, simd));
static inline float __lgamma_r_float(float in, int *signp) __attribute__ ((pure, simd));
static inline float2 __lgamma_r_float2(float2 in, int2 *signp) __attribute__ ((pure, simd));
static inline float3 __lgamma_r_float3(float3 in, int3 *signp) __attribute__ ((pure, simd));
static inline float8 __lgamma_r_float8(float8 in, int8 *signp) __attribute__ ((pure, simd));
static inline float16 __lgamma_r_float16(float16 in, int16 *signp) __attribute__ ((pure, simd));
static inline float4 __lgamma_r_float4_global(float4 in, __global int4 *signp) __attribute__ ((pure, simd));
static inline float __lgamma_r_float_global(float in, __global int *signp) __attribute__ ((pure, simd));
static inline float2 __lgamma_r_float2_global(float2 in, __global int2 *signp) __attribute__ ((pure, simd));
static inline float3 __lgamma_r_float3_global(float3 in, __global int3 *signp) __attribute__ ((pure, simd));
static inline float8 __lgamma_r_float8_global(float8 in, __global int8 *signp) __attribute__ ((pure, simd));
static inline float16 __lgamma_r_float16_global(float16 in, __global int16 *signp) __attribute__ ((pure, simd));
static inline int __mul24_int(int x, int y) __attribute__ ((pure, simd));
static inline int2 __mul24_int2(int2 x, int2 y) __attribute__ ((pure, simd));
static inline int3 __mul24_int3(int3 x, int3 y) __attribute__ ((pure, simd));
static inline int4 __mul24_int4(int4 x, int4 y) __attribute__ ((pure, simd));
static inline int8 __mul24_int8(int8 x, int8 y) __attribute__ ((pure, simd));
static inline int16 __mul24_int16(int16 x, int16 y) __attribute__ ((pure, simd));
static inline uint __mul24_uint(uint x, uint y) __attribute__ ((pure, simd));
static inline uint2 __mul24_uint2(uint2 x, uint2 y) __attribute__ ((pure, simd));
static inline uint3 __mul24_uint3(uint3 x, uint3 y) __attribute__ ((pure, simd));
static inline uint4 __mul24_uint4(uint4 x, uint4 y) __attribute__ ((pure, simd));
static inline uint8 __mul24_uint8(uint8 x, uint8 y) __attribute__ ((pure, simd));
static inline uint16 __mul24_uint16(uint16 x, uint16 y) __attribute__ ((pure, simd));
static inline int __mad24_int(int x, int y, int z)  __attribute__ ((pure, simd));
static inline int2 __mad24_int2(int2 x, int2 y, int2 z)  __attribute__ ((pure, simd));
static inline int3 __mad24_int3(int3 x, int3 y, int3 z)  __attribute__ ((pure, simd));
static inline int4 __mad24_int4(int4 x, int4 y, int4 z)  __attribute__ ((pure, simd));
static inline int8 __mad24_int8(int8 x, int8 y, int8 z)  __attribute__ ((pure, simd));
static inline int16 __mad24_int16(int16 x, int16 y, int16 z)  __attribute__ ((pure, simd));
static inline uint __mad24_uint(uint x, uint y, uint z) __attribute__ ((pure, simd));
static inline uint2 __mad24_uint2(uint2 x, uint2 y, uint2 z) __attribute__ ((pure, simd));
static inline uint3 __mad24_uint3(uint3 x, uint3 y, uint3 z) __attribute__ ((pure, simd));
static inline uint4 __mad24_uint4(uint4 x, uint4 y, uint4 z) __attribute__ ((pure, simd));
static inline uint8 __mad24_uint8(uint8 x, uint8 y, uint8 z) __attribute__ ((pure, simd));
static inline uint16 __mad24_uint16(uint16 x, uint16 y, uint16 z) __attribute__ ((pure, simd));
static inline float2 __cos_float2(float2 in) __attribute__ ((pure, simd));
static inline float3 __cos_float3(float3 in) __attribute__ ((pure, simd));
static inline float4 __cos_float4(float4 in) __attribute__ ((pure, simd));
static inline float8 __cos_float8(float8 in) __attribute__ ((pure, simd));
static inline float16 __cos_float16(float16 in) __attribute__ ((pure, simd));
static inline float __cos_float(float in) __attribute__ ((pure, simd));
static inline float2 __cospi_float2(float2 in) __attribute__ ((pure, simd));
static inline float4 __cospi_float4(float4 in) __attribute__ ((pure, simd));
static inline float8 __cospi_float8(float8 in) __attribute__ ((pure, simd));
static inline float16 __cospi_float16(float16 in) __attribute__ ((pure, simd));
static inline float __cospi_float(float in) __attribute__ ((pure, simd));
static inline float3 __cospi_float3(float3 in) __attribute__ ((pure, simd));
static inline float2 __native_cos_float2(float2 in) __attribute__ ((pure, simd));
static inline float4 __native_cos_float4(float4 in) __attribute__ ((pure, simd));
static inline float8 __native_cos_float8(float8 in) __attribute__ ((pure, simd));
static inline float16 __native_cos_float16(float16 in) __attribute__ ((pure, simd));
static inline float __native_cos_float(float in) __attribute__ ((pure, simd));
static inline float3 __native_cos_float3(float3 in) __attribute__ ((pure, simd));
static inline float2 __sin_float2(float2 in) __attribute__ ((pure, simd));
static inline float3 __sin_float3(float3 in) __attribute__ ((pure, simd));
static inline float4 __sin_float4(float4 in) __attribute__ ((pure, simd));
static inline float8 __sin_float8(float8 in) __attribute__ ((pure, simd));
static inline float16 __sin_float16(float16 in) __attribute__ ((pure, simd));
static inline float __sin_float(float in) __attribute__ ((pure, simd));
static inline float2 __sinpi_float2(float2 in) __attribute__ ((pure, simd));
static inline float4 __sinpi_float4(float4 in) __attribute__ ((pure, simd));
static inline float8 __sinpi_float8(float8 in) __attribute__ ((pure, simd));
static inline float16 __sinpi_float16(float16 in) __attribute__ ((pure, simd));
static inline float __sinpi_float(float in) __attribute__ ((pure, simd));
static inline float3 __sinpi_float3(float3 x) __attribute__ ((pure, simd));
static inline float2 __sincos_float2(float2 in, float2 *cosval) __attribute__ ((pure, simd));
static inline float3 __sincos_float3(float3 in, float3 *cosval) __attribute__ ((pure, simd));
static inline float4 __sincos_float4(float4 in, float4 *cosval) __attribute__ ((pure, simd));
static inline float8 __sincos_float8(float8 in, float8 *cosval) __attribute__ ((pure, simd));
static inline float16 __sincos_float16(float16 in, float16 *cosval) __attribute__ ((pure, simd));
static inline float2 __sincos_float2_global(float2 in, __global float2 *cosval) __attribute__ ((pure, simd));
static inline float3 __sincos_float3_global(float3 in, __global float3 *cosval) __attribute__ ((pure, simd));
static inline float4 __sincos_float4_global(float4 in, __global float4 *cosval) __attribute__ ((pure, simd));
static inline float8 __sincos_float8_global(float8 in, __global float8 *cosval) __attribute__ ((pure, simd));
static inline float16 __sincos_float16_global(float16 in, __global float16 *cosval) __attribute__ ((pure, simd));
static inline float __sincos_float(float in, float *cosval) __attribute__ ((pure, simd));
static inline float __sincos_float_global(float in, __global float *cosval) __attribute__ ((pure, simd));
static inline float2 __native_sin_float2(float2 in) __attribute__ ((pure, simd));
static inline float4 __native_sin_float4(float4 in) __attribute__ ((pure, simd));
static inline float8 __native_sin_float8(float8 in) __attribute__ ((pure, simd));
static inline float16 __native_sin_float16(float16 in) __attribute__ ((pure, simd));
static inline float __native_sin_float(float in) __attribute__ ((pure, simd));
static inline float3 __native_sin_float3(float3 x) __attribute__ ((pure, simd));
static inline float __degrees_float (float radians)  __attribute__ ((pure, simd));
static inline float2 __degrees_float2 (float2 radians)  __attribute__ ((pure, simd));
static inline float3 __degrees_float3 (float3 radians)  __attribute__ ((pure, simd));
static inline float4 __degrees_float4 (float4 radians)  __attribute__ ((pure, simd));
static inline float8 __degrees_float8 (float8 radians)  __attribute__ ((pure, simd));
static inline float16 __degrees_float16 (float16 radians)  __attribute__ ((pure, simd));
static inline float __radians_float (float degrees)  __attribute__ ((pure, simd));
static inline float2 __radians_float2 (float2 degrees)  __attribute__ ((pure, simd));
static inline float3 __radians_float3 (float3 degrees)  __attribute__ ((pure, simd));
static inline float4 __radians_float4 (float4 degrees)  __attribute__ ((pure, simd));
static inline float8 __radians_float8 (float8 degrees)  __attribute__ ((pure, simd));
static inline float16 __radians_float16 (float16 degrees)  __attribute__ ((pure, simd));
static inline float2 __mix_float_float2 (float2 x, float2 y, float a)  __attribute__ ((pure, simd));
static inline float2 __mix_float2 (float2 x, float2 y, float2 a)  __attribute__ ((pure, simd));
static inline float3 __mix_float_float3 (float3 x, float3 y, float a)  __attribute__ ((pure, simd));
static inline float3 __mix_float3 (float3 x, float3 y, float3 a)  __attribute__ ((pure, simd));
static inline float4 __mix_float_float4 (float4 x, float4 y, float a)  __attribute__ ((pure, simd));
static inline float4 __mix_float4 (float4 x, float4 y, float4 a)  __attribute__ ((pure, simd));
static inline float8 __mix_float_float8 (float8 x, float8 y, float a)  __attribute__ ((pure, simd));
static inline float8 __mix_float8 (float8 x, float8 y, float8 a)  __attribute__ ((pure, simd));
static inline float16 __mix_float_float16 (float16 x, float16 y, float a)  __attribute__ ((pure, simd));
static inline float16 __mix_float16 (float16 x, float16 y, float16 a)  __attribute__ ((pure, simd));
static inline float __mix_float (float x, float y, float a)  __attribute__ ((pure, simd));
static inline float2 __step_float2 (float2 edge, float2 x)  __attribute__ ((pure, simd));
static inline float2 __step_float_float2 (float edge, float2 x)  __attribute__ ((pure, simd));
static inline float3 __step_float3 (float3 edge, float3 x)  __attribute__ ((pure, simd));
static inline float3 __step_float_float3 (float edge, float3 x)  __attribute__ ((pure, simd));
static inline float4 __step_float4 (float4 edge, float4 x)  __attribute__ ((pure, simd));
static inline float4 __step_float_float4 (float edge, float4 x)  __attribute__ ((pure, simd));
static inline float8 __step_float8 (float8 edge, float8 x)  __attribute__ ((pure, simd));
static inline float8 __step_float_float8 (float edge, float8 x)  __attribute__ ((pure, simd));
static inline float16 __step_float16 (float16 edge, float16 x)  __attribute__ ((pure, simd));
static inline float16 __step_float_float16 (float edge, float16 x)  __attribute__ ((pure, simd));
static inline float __step_float (float edge, float x)  __attribute__ ((pure, simd));
static inline float2 __smoothstep_float2 (float2 edge0, float2 edge1, float2 x)  __attribute__ ((pure, simd));
static inline float2 __smoothstep_float_float2 (float edge0, float edge1, float2 x)  __attribute__ ((pure, simd));
static inline float3 __smoothstep_float3 (float3 edge0, float3 edge1, float3 x)  __attribute__ ((pure, simd));
static inline float3 __smoothstep_float_float3 (float edge0, float edge1, float3 x)  __attribute__ ((pure, simd));
static inline float4 __smoothstep_float4 (float4 edge0, float4 edge1, float4 x)  __attribute__ ((pure, simd));
static inline float4 __smoothstep_float_float4 (float edge0, float edge1, float4 x)  __attribute__ ((pure, simd));
static inline float8 __smoothstep_float8 (float8 edge0, float8 edge1, float8 x)  __attribute__ ((pure, simd));
static inline float8 __smoothstep_float_float8 (float edge0, float edge1, float8 x)  __attribute__ ((pure, simd));
static inline float16 __smoothstep_float16 (float16 edge0, float16 edge1, float16 x)  __attribute__ ((pure, simd));
static inline float16 __smoothstep_float_float16 (float edge0, float edge1, float16 x)  __attribute__ ((pure, simd));
static inline float __smoothstep_float (float edge0, float edge1, float x)  __attribute__ ((pure, simd));
static inline float2 __tan_float2(float2 in) __attribute__ ((pure, simd));
static inline float3 __tan_float3(float3 in) __attribute__ ((pure, simd));
static inline float4 __tan_float4(float4 in) __attribute__ ((pure, simd));
static inline float8 __tan_float8(float8 in) __attribute__ ((pure, simd));
static inline float16 __tan_float16(float16 in) __attribute__ ((pure, simd));
static inline float __tan_float(float in) __attribute__ ((pure, simd));
static inline float2 __tanpi_float2(float2 in) __attribute__ ((pure, simd));
static inline float4 __tanpi_float4(float4 in) __attribute__ ((pure, simd));
static inline float8 __tanpi_float8(float8 in) __attribute__ ((pure, simd));
static inline float16 __tanpi_float16(float16 in) __attribute__ ((pure, simd));
static inline float __tanpi_float(float in) __attribute__ ((pure, simd));
static inline float3 __tanpi_float3(float3 x) __attribute__ ((pure, simd));
static inline float2 __native_tan_float2(float2 in) __attribute__ ((pure, simd));
static inline float3 __native_tan_float3(float3 in) __attribute__ ((pure, simd));
static inline float4 __native_tan_float4(float4 in) __attribute__ ((pure, simd));
static inline float8 __native_tan_float8(float8 in) __attribute__ ((pure, simd));
static inline float16 __native_tan_float16(float16 in) __attribute__ ((pure, simd));
static inline float __native_tan_float(float in) __attribute__ ((pure, simd));
static inline float __nan_float(uint nancode) __attribute__ ((pure, simd));
static inline float2 __nan_float2(uint2 nancode) __attribute__ ((pure, simd));
static inline float3 __nan_float3(uint3 nancode) __attribute__ ((pure, simd));
static inline float4 __nan_float4(uint4 nancode) __attribute__ ((pure, simd));
static inline float8 __nan_float8(uint8 nancode) __attribute__ ((pure, simd));
static inline float16 __nan_float16(uint16 nancode) __attribute__ ((pure, simd));
static inline float2 __cosh_float2(float2 x) __attribute__ ((pure, simd));
static inline float4 __cosh_float4(float4 x) __attribute__ ((pure, simd));
static inline float8 __cosh_float8(float8 x) __attribute__ ((pure, simd));
static inline float16 __cosh_float16(float16 x) __attribute__ ((pure, simd));
static inline float __cosh_float(float x) __attribute__ ((pure, simd));
static inline float3 __cosh_float3(float3 x) __attribute__ ((pure, simd));
static inline float2 __sinh_float2(float2 x) __attribute__ ((pure, simd));
static inline float4 __sinh_float4(float4 x) __attribute__ ((pure, simd));
static inline float8 __sinh_float8(float8 x) __attribute__ ((pure, simd));
static inline float16 __sinh_float16(float16 x) __attribute__ ((pure, simd));
static inline float __sinh_float(float x) __attribute__ ((pure, simd));
static inline float3 __sinh_float3(float3 x) __attribute__ ((pure, simd));
static inline float2 __tanh_float2(float2 x) __attribute__ ((pure, simd));
static inline float4 __tanh_float4(float4 x) __attribute__ ((pure, simd));
static inline float8 __tanh_float8(float8 x) __attribute__ ((pure, simd));
static inline float16 __tanh_float16(float16 x) __attribute__ ((pure, simd));
static inline float __tanh_float(float x) __attribute__ ((pure, simd));
static inline float3 __tanh_float3(float3 x) __attribute__ ((pure, simd));
static inline float2 __cbrt_float2(float2 x) __attribute__ ((pure, simd));
static inline float4 __cbrt_float4(float4 x) __attribute__ ((pure, simd));
static inline float8 __cbrt_float8(float8 x) __attribute__ ((pure, simd));
static inline float16 __cbrt_float16(float16 x) __attribute__ ((pure, simd));
static inline float __cbrt_float(float x) __attribute__ ((pure, simd));
static inline float3 __cbrt_float3(float3 x) __attribute__ ((pure, simd));
static inline float2 __acos_float2(float2 in) __attribute__ ((pure, simd));
static inline float4 __acos_float4(float4 in) __attribute__ ((pure, simd));
static inline float8 __acos_float8(float8 in) __attribute__ ((pure, simd));
static inline float16 __acos_float16(float16 in) __attribute__ ((pure, simd));
static inline float __acos_float (float in) __attribute__ ((pure, simd));
static inline float3 __acos_float3(float3 x) __attribute__ ((pure, simd));
static inline float2 __acospi_float2(float2 in) __attribute__ ((pure, simd));
static inline float4 __acospi_float4(float4 in) __attribute__ ((pure, simd));
static inline float8 __acospi_float8(float8 in) __attribute__ ((pure, simd));
static inline float16 __acospi_float16(float16 in) __attribute__ ((pure, simd));
static inline float __acospi_float(float in) __attribute__ ((pure, simd));
static inline float3 __acospi_float3(float3 x) __attribute__ ((pure, simd));
static inline float2 __asin_float2(float2 in) __attribute__ ((pure, simd));
static inline float4 __asin_float4(float4 in) __attribute__ ((pure, simd));
static inline float8 __asin_float8(float8 in) __attribute__ ((pure, simd));
static inline float16 __asin_float16(float16 in) __attribute__ ((pure, simd));
static inline float __asin_float(float in) __attribute__ ((pure, simd));
static inline float3 __asin_float3(float3 x) __attribute__ ((pure, simd));
static inline float2 __asinpi_float2(float2 in) __attribute__ ((pure, simd));
static inline float4 __asinpi_float4(float4 in) __attribute__ ((pure, simd));
static inline float8 __asinpi_float8(float8 in) __attribute__ ((pure, simd));
static inline float16 __asinpi_float16(float16 in) __attribute__ ((pure, simd));
static inline float __asinpi_float(float in) __attribute__ ((pure, simd));
static inline float3 __asinpi_float3(float3 x) __attribute__ ((pure, simd));
static inline float2 __logb_float2(float2 x) __attribute__ ((pure, simd));
static inline float4 __logb_float4(float4 x) __attribute__ ((pure, simd));
static inline float8 __logb_float8(float8 x) __attribute__ ((pure, simd));
static inline float16 __logb_float16(float16 x) __attribute__ ((pure, simd));
static inline float __logb_float(float x) __attribute__ ((pure, simd));
static inline float3 __logb_float3(float3 x) __attribute__ ((pure, simd));
static inline int2 __ilogb_float2(float2 x) __attribute__ ((pure, simd));
static inline int4 __ilogb_float4(float4 x) __attribute__ ((pure, simd));
static inline int8 __ilogb_float8(float8 x) __attribute__ ((pure, simd));
static inline int16 __ilogb_float16(float16 x) __attribute__ ((pure, simd));
static inline int __ilogb_float(float x) __attribute__ ((pure, simd));
static inline int3 __ilogb_float3(float3 in) __attribute__ ((pure, simd));
static inline float2 __ldexp_float2 (float2 x, int2 exponent) __attribute__ ((pure, simd));
static inline float2 __ldexp_int_float2 (float2 x, int exponent) __attribute__ ((pure, simd));
static inline float4 __ldexp_float4 (float4 x, int4 exponent) __attribute__ ((pure, simd));
static inline float4 __ldexp_int_float4 (float4 x, int exponent) __attribute__ ((pure, simd));
static inline float8 __ldexp_float8 (float8 x, int8 exponent) __attribute__ ((pure, simd));
static inline float8 __ldexp_int_float8 (float8 x, int exponent) __attribute__ ((pure, simd));
static inline float16 __ldexp_float16 (float16 x, int16 exponent) __attribute__ ((pure, simd));
static inline float16 __ldexp_int_float16 (float16 x, int exponent) __attribute__ ((pure, simd));
static inline float __ldexp_float (float x, int exponent) __attribute__ ((pure, simd));
static inline float3 __ldexp_float3 (float3 x, int3 exponent) __attribute__ ((pure, simd));
static inline float3 __ldexp_int_float3 (float3 x, int exponent) __attribute__ ((pure, simd));
static inline float2 __frexp_float2 (float2 x, int2 *pexp) __attribute__ ((pure, simd));
static inline float3 __frexp_float3 (float3 x, int3 *pexp) __attribute__ ((pure, simd));
static inline float4 __frexp_float4 (float4 x, int4 *pexp) __attribute__ ((pure, simd));
static inline float8 __frexp_float8 (float8 x, int8 *pexp) __attribute__ ((pure, simd));
static inline float16 __frexp_float16 (float16 x, int16 *pexp) __attribute__ ((pure, simd));
static inline float2 __frexp_float2_global (float2 x, __global int2 *pexp) __attribute__ ((pure, simd));
static inline float3 __frexp_float3_global (float3 x, __global int3 *pexp) __attribute__ ((pure, simd));
static inline float4 __frexp_float4_global (float4 x, __global int4 *pexp) __attribute__ ((pure, simd));
static inline float8 __frexp_float8_global (float8 x, __global int8 *pexp) __attribute__ ((pure, simd));
static inline float16 __frexp_float16_global (float16 x, __global int16 *pexp) __attribute__ ((pure, simd));
static inline float __frexp_float (float x, int *pexp) __attribute__ ((pure, simd));
static inline float __frexp_float_global (float x, __global int *pexp) __attribute__ ((pure, simd));
static inline float2 __ceil_float2(float2 x) __attribute__ ((pure, simd));
static inline float4 __ceil_float4(float4 x) __attribute__ ((pure, simd));
static inline float8 __ceil_float8(float8 x) __attribute__ ((pure, simd));
static inline float16 __ceil_float16(float16 x) __attribute__ ((pure, simd));
static inline float __ceil_float (float x) __attribute__ ((pure, simd));
static inline float3 __ceil_float3(float3 x) __attribute__ ((pure, simd));
static inline float2 __fract_float2 (float2 x, float2 *iptr)  __attribute__ ((pure, simd));
static inline float3 __fract_float3 (float3 x, float3 *iptr)  __attribute__ ((pure, simd));
static inline float4 __fract_float4 (float4 x, float4 *iptr)  __attribute__ ((pure, simd));
static inline float8 __fract_float8 (float8 x, float8 *iptr)  __attribute__ ((pure, simd));
static inline float16 __fract_float16 (float16 x, float16 *iptr)  __attribute__ ((pure, simd));
static inline float2 __fract_float2_global (float2 x, __global float2 *iptr)  __attribute__ ((pure, simd));
static inline float3 __fract_float3_global (float3 x, __global float3 *iptr)  __attribute__ ((pure, simd));
static inline float4 __fract_float4_global (float4 x, __global float4 *iptr)  __attribute__ ((pure, simd));
static inline float8 __fract_float8_global (float8 x, __global float8 *iptr)  __attribute__ ((pure, simd));
static inline float16 __fract_float16_global (float16 x, __global float16 *iptr)  __attribute__ ((pure, simd));
static inline float __fract_float (float x, float *iptr)  __attribute__ ((pure, simd));
static inline float __fract_float_global (float x, __global float *iptr)  __attribute__ ((pure, simd));
static inline float2 __round_float2(float2 x) __attribute__ ((pure, simd));
static inline float4 __round_float4(float4 x) __attribute__ ((pure, simd));
static inline float8 __round_float8(float8 x) __attribute__ ((pure, simd));
static inline float16 __round_float16(float16 x) __attribute__ ((pure, simd));
static inline float __round_float (float x) __attribute__ ((pure, simd));
static inline float3 __round_float3(float3 x) __attribute__ ((pure, simd));
static inline float2 __nextafter_float2(float2 x, float2 y) __attribute__ ((pure, simd));
static inline float4 __nextafter_float4(float4 x, float4 y) __attribute__ ((pure, simd));
static inline float8 __nextafter_float8(float8 x, float8 y) __attribute__ ((pure, simd));
static inline float16 __nextafter_float16(float16 x, float16 y) __attribute__ ((pure, simd));
static inline float __nextafter_float(float x, float y) __attribute__ ((pure, simd));
static inline float3 __nextafter_float3(float3 x, float3 y) __attribute__ ((pure, simd));
static inline float2 __half_divide_float2 (float2 x,float2 y)  __attribute__ ((pure, simd));
static inline float4 __half_divide_float4 (float4 x,float4 y)  __attribute__ ((pure, simd));
static inline float8 __half_divide_float8 (float8 x,float8 y)  __attribute__ ((pure, simd));
static inline float16 __half_divide_float16 (float16 x,float16 y)  __attribute__ ((pure, simd));
static inline float __half_divide_float (float x, float y) __attribute__ ((pure, simd));
static inline float3 __half_divide_float3(float3 x, float3 y) __attribute__ ((pure, simd));
static inline float2 __half_recip_float2 (float2 x) __attribute__ ((pure, simd));
static inline float3 __half_recip_float3 (float3 x) __attribute__ ((pure, simd));
static inline float4 __half_recip_float4 (float4 x) __attribute__ ((pure, simd));
static inline float8 __half_recip_float8 (float8 x) __attribute__ ((pure, simd));
static inline float16 __half_recip_float16 (float16 x) __attribute__ ((pure, simd));
static inline float __half_recip_float (float x) __attribute__ ((pure, simd));
static inline float __fast_distance_float(float p0, float p1)  __attribute__ ((pure, simd));
static inline float __fast_distance_float2(float2 p0, float2 p1)  __attribute__ ((pure, simd));
static inline float __fast_distance_float3(float3 p0, float3 p1)  __attribute__ ((pure, simd));
static inline float __fast_distance_float4(float4 p0, float4 p1)  __attribute__ ((pure, simd));
static inline float __distance_float(float p0, float p1)  __attribute__ ((pure, simd));
static inline float __distance_float2(float2 p0, float2 p1)  __attribute__ ((pure, simd));
static inline float __distance_float3(float3 p0, float3 p1)  __attribute__ ((pure, simd));
static inline float __distance_float4(float4 p0, float4 p1)  __attribute__ ((pure, simd));
static inline float4 __cross_float4(float4 p0, float4 p1)  __attribute__ ((pure, simd));
static inline float3 __cross_float3(float3 p0, float3 p1)  __attribute__ ((pure, simd));
static inline float __dot_float4(float4 p0, float4 p1)  __attribute__ ((pure, simd));
static inline float __dot_float3(float3 p0, float3 p1)  __attribute__ ((pure, simd));
static inline float __dot_float2(float2 p0, float2 p1)  __attribute__ ((pure, simd));
static inline float __dot_float(float p0, float p1)  __attribute__ ((pure, simd));
static inline float __length_float(float p)  __attribute__ ((pure, simd));
static inline float __length_float2(float2 p)  __attribute__ ((pure, simd));
static inline float __length_float3(float3 p)  __attribute__ ((pure, simd));
static inline float __length_float4(float4 p)  __attribute__ ((pure, simd));
static inline float __normalize_float(float p)  __attribute__ ((pure, simd));
static inline float2 __normalize_float2(float2 p)  __attribute__ ((pure, simd));
static inline float3 __normalize_float3(float3 p)  __attribute__ ((pure, simd));
static inline float4 __normalize_float4(float4 p)  __attribute__ ((pure, simd));
static inline float __fast_length_float(float p)  __attribute__ ((pure, simd));
static inline float __fast_length_float2(float2 p)  __attribute__ ((pure, simd));
static inline float __fast_length_float3(float3 p)  __attribute__ ((pure, simd));
static inline float __fast_length_float4(float4 p)  __attribute__ ((pure, simd));
static inline float __fast_normalize_float(float p)  __attribute__ ((pure, simd));
static inline float2 __fast_normalize_float2(float2 p)  __attribute__ ((pure, simd));
static inline float3 __fast_normalize_float3(float3 p)  __attribute__ ((pure, simd));
static inline float4 __fast_normalize_float4(float4 p)  __attribute__ ((pure, simd));
static inline float2 __sign_float2 (float2 x)  __attribute__ ((pure, simd));
static inline float3 __sign_float3 (float3 x)  __attribute__ ((pure, simd));
static inline float4 __sign_float4 (float4 x)  __attribute__ ((pure, simd));
static inline float8 __sign_float8 (float8 x)  __attribute__ ((pure, simd));
static inline float16 __sign_float16 (float16 x)  __attribute__ ((pure, simd));
static inline float __sign_float (float x) __attribute__ ((pure, simd));
static inline float2 __rint_float2(float2 x) __attribute__ ((pure, simd));
static inline float4 __rint_float4(float4 x) __attribute__ ((pure, simd));
static inline float8 __rint_float8(float8 x) __attribute__ ((pure, simd));
static inline float16 __rint_float16(float16 x) __attribute__ ((pure, simd));
static inline float __rint_float (float x) __attribute__ ((pure, simd));
static inline float3 __rint_float3(float3 x) __attribute__ ((pure, simd));
static inline float2 __modf_float2 (float2 x, float2 *iptr)  __attribute__ ((pure, simd));
static inline float3 __modf_float3 (float3 x, float3 *iptr)  __attribute__ ((pure, simd));
static inline float4 __modf_float4 (float4 x, float4 *iptr)  __attribute__ ((pure, simd));
static inline float8 __modf_float8 (float8 x, float8 *iptr)  __attribute__ ((pure, simd));
static inline float16 __modf_float16 (float16 x, float16 *iptr)  __attribute__ ((pure, simd));
static inline float2 __modf_float2_global (float2 x, __global float2 *iptr)  __attribute__ ((pure, simd));
static inline float3 __modf_float3_global (float3 x, __global float3 *iptr)  __attribute__ ((pure, simd));
static inline float4 __modf_float4_global (float4 x, __global float4 *iptr)  __attribute__ ((pure, simd));
static inline float8 __modf_float8_global (float8 x, __global float8 *iptr)  __attribute__ ((pure, simd));
static inline float16 __modf_float16_global (float16 x, __global float16 *iptr)  __attribute__ ((pure, simd));
static inline float __modf_float (float x, float *iptr)  __attribute__ ((pure, simd));
static inline float __modf_float_global (float x, __global float *iptr)  __attribute__ ((pure, simd));
static inline float2 __trunc_float2(float2 x) __attribute__ ((pure, simd));
static inline float4 __trunc_float4(float4 x) __attribute__ ((pure, simd));
static inline float8 __trunc_float8(float8 x) __attribute__ ((pure, simd));
static inline float16 __trunc_float16(float16 x) __attribute__ ((pure, simd));
static inline float __trunc_float (float x) __attribute__ ((pure, simd));
static inline float3 __trunc_float3(float3 x) __attribute__ ((pure, simd));
static inline float2 __fdim_float2(float2 x, float2 y) __attribute__ ((pure, simd));
static inline float4 __fdim_float4(float4 x, float4 y) __attribute__ ((pure, simd));
static inline float8 __fdim_float8(float8 x, float8 y) __attribute__ ((pure, simd));
static inline float16 __fdim_float16(float16 x, float16 y) __attribute__ ((pure, simd));
static inline float __fdim_float(float x, float y) __attribute__ ((pure, simd));
static inline float3 __fdim_float3(float3 x, float3 y) __attribute__ ((pure, simd));
static inline float2 __hypot_float2 (float2 x, float2 y)  __attribute__ ((pure, simd));
static inline float4 __hypot_float4 (float4 x, float4 y)  __attribute__ ((pure, simd));
static inline float8 __hypot_float8 (float8 x, float8 y)  __attribute__ ((pure, simd));
static inline float16 __hypot_float16 (float16 x, float16 y)  __attribute__ ((pure, simd));
static inline float __hypot_float (float x, float y) __attribute__ ((pure, simd));
static inline float3 __hypot_float3(float3 x, float3 y) __attribute__ ((pure, simd));
static inline float2 __atan2_float2(float2 y, float2 x) __attribute__ ((pure, simd));
static inline float4 __atan2_float4(float4 y, float4 x) __attribute__ ((pure, simd));
static inline float8 __atan2_float8(float8 y, float8 x) __attribute__ ((pure, simd));
static inline float16 __atan2_float16(float16 y, float16 x) __attribute__ ((pure, simd));
static inline float __atan2_float(float y, float x) __attribute__ ((pure, simd));
static inline float3 __atan2_float3(float3 y, float3 x) __attribute__ ((pure, simd));
static inline float2 __atan2pi_float2(float2 y, float2 x) __attribute__ ((pure, simd));
static inline float4 __atan2pi_float4(float4 y, float4 x) __attribute__ ((pure, simd));
static inline float8 __atan2pi_float8(float8 y, float8 x) __attribute__ ((pure, simd));
static inline float16 __atan2pi_float16(float16 y, float16 x) __attribute__ ((pure, simd));
static inline float __atan2pi_float(float y, float x) __attribute__ ((pure, simd));
static inline float3 __atan2pi_float3(float3 y, float3 x) __attribute__ ((pure, simd));
static inline float2 __atan_float2(float2 x) __attribute__ ((pure, simd));
static inline float4 __atan_float4(float4 x) __attribute__ ((pure, simd));
static inline float8 __atan_float8(float8 x) __attribute__ ((pure, simd));
static inline float16 __atan_float16(float16 x) __attribute__ ((pure, simd));
static inline float __atan_float(float x) __attribute__ ((pure, simd));
static inline float3 __atan_float3(float3 x) __attribute__ ((pure, simd));
static inline float2 __atanpi_float2(float2 x) __attribute__ ((pure, simd));
static inline float4 __atanpi_float4(float4 x) __attribute__ ((pure, simd));
static inline float8 __atanpi_float8(float8 x) __attribute__ ((pure, simd));
static inline float16 __atanpi_float16(float16 x) __attribute__ ((pure, simd));
static inline float __atanpi_float(float x) __attribute__ ((pure, simd));
static inline float3 __atanpi_float3(float3 x) __attribute__ ((pure, simd));
static inline float2 __erfc_float2(float2 x) __attribute__ ((pure, simd));
static inline float4 __erfc_float4(float4 x) __attribute__ ((pure, simd));
static inline float8 __erfc_float8(float8 x) __attribute__ ((pure, simd));
static inline float16 __erfc_float16(float16 x) __attribute__ ((pure, simd));
static inline float __erfc_float(float x) __attribute__ ((pure, simd));
static inline float3 __erfc_float3(float3 x) __attribute__ ((pure, simd));
static inline float __native_divide_float (float x,float y)  __attribute__ ((pure, simd));
static inline float2 __native_divide_float2 (float2 x,float2 y)  __attribute__ ((pure, simd));
static inline float3 __native_divide_float3 (float3 x,float3 y)  __attribute__ ((pure, simd));
static inline float4 __native_divide_float4 (float4 x,float4 y)  __attribute__ ((pure, simd));
static inline float8 __native_divide_float8 (float8 x,float8 y)  __attribute__ ((pure, simd));
static inline float16 __native_divide_float16 (float16 x,float16 y)  __attribute__ ((pure, simd));
static inline float2 __fmod_float2(float2 x, float2 y) __attribute__ ((pure, simd));
static inline float3 __fmod_float3(float3 x, float3 y) __attribute__ ((pure, simd));
static inline float4 __fmod_float4(float4 x, float4 y) __attribute__ ((pure, simd));
static inline float8 __fmod_float8(float8 x, float8 y) __attribute__ ((pure, simd));
static inline float16 __fmod_float16(float16 x, float16 y) __attribute__ ((pure, simd));
static inline float __fmod_float(float x, float y) __attribute__ ((pure, simd));
static inline float2 __remainder_float2(float2 x, float2 y) __attribute__ ((pure, simd));
static inline float3 __remainder_float3(float3 x, float3 y) __attribute__ ((pure, simd));
static inline float4 __remainder_float4(float4 x, float4 y) __attribute__ ((pure, simd));
static inline float8 __remainder_float8(float8 x, float8 y) __attribute__ ((pure, simd));
static inline float16 __remainder_float16(float16 x, float16 y) __attribute__ ((pure, simd));
static inline float __remainder_float(float x, float y) __attribute__ ((pure, simd));
static inline float2 __remquo_float2(float2 x, float2 y, int2 *quo) __attribute__ ((pure, simd));
static inline float3 __remquo_float3(float3 x, float3 y, int3 *quo) __attribute__ ((pure, simd));
static inline float4 __remquo_float4(float4 x, float4 y, int4 *quo) __attribute__ ((pure, simd));
static inline float8 __remquo_float8(float8 x, float8 y, int8 *quo) __attribute__ ((pure, simd));
static inline float16 __remquo_float16(float16 x, float16 y, int16 *quo) __attribute__ ((pure, simd));
static inline float2 __remquo_float2_global(float2 x, float2 y, __global int2 *quo) __attribute__ ((pure, simd));
static inline float3 __remquo_float3_global(float3 x, float3 y, __global int3 *quo) __attribute__ ((pure, simd));
static inline float4 __remquo_float4_global(float4 x, float4 y, __global int4 *quo) __attribute__ ((pure, simd));
static inline float8 __remquo_float8_global(float8 x, float8 y, __global int8 *quo) __attribute__ ((pure, simd));
static inline float16 __remquo_float16_global(float16 x, float16 y, __global int16 *quo) __attribute__ ((pure, simd));
static inline float __remquo_float(float x, float y, int *quo) __attribute__ ((pure, simd));
static inline float __remquo_float_global(float x, float y, __global int *quo) __attribute__ ((pure, simd));
static inline uchar2 __abs_uchar2(uchar2 x) __attribute__ ((pure, simd));
static inline uchar2 __abs_char2(char2 x) __attribute__ ((pure, simd));
static inline ushort2 __abs_ushort2(ushort2 x) __attribute__ ((pure, simd));
static inline ushort2 __abs_short2(short2 x) __attribute__ ((pure, simd));
static inline uint2 __abs_uint2(uint2 x) __attribute__ ((pure, simd));
static inline uint2 __abs_int2(int2 x) __attribute__ ((pure, simd));
static inline ulong2 __abs_ulong2(ulong2 x) __attribute__ ((pure, simd));
static inline ulong2 __abs_long2(long2 x) __attribute__ ((pure, simd));
static inline uchar3 __abs_uchar3(uchar3 x) __attribute__ ((pure, simd));
static inline uchar3 __abs_char3(char3 x) __attribute__ ((pure, simd));
static inline ushort3 __abs_ushort3(ushort3 x) __attribute__ ((pure, simd));
static inline ushort3 __abs_short3(short3 x) __attribute__ ((pure, simd));
static inline uint3 __abs_uint3(uint3 x) __attribute__ ((pure, simd));
static inline uint3 __abs_int3(int3 x) __attribute__ ((pure, simd));
static inline ulong3 __abs_ulong3(ulong3 x) __attribute__ ((pure, simd));
static inline ulong3 __abs_long3(long3 x) __attribute__ ((pure, simd));
static inline uchar4 __abs_uchar4(uchar4 x) __attribute__ ((pure, simd));
static inline uchar4 __abs_char4(char4 x) __attribute__ ((pure, simd));
static inline ushort4 __abs_ushort4(ushort4 x) __attribute__ ((pure, simd));
static inline ushort4 __abs_short4(short4 x) __attribute__ ((pure, simd));
static inline uint4 __abs_uint4(uint4 x) __attribute__ ((pure, simd));
static inline uint4 __abs_int4(int4 x) __attribute__ ((pure, simd));
static inline ulong4 __abs_ulong4(ulong4 x) __attribute__ ((pure, simd));
static inline ulong4 __abs_long4(long4 x) __attribute__ ((pure, simd));
static inline uchar8 __abs_uchar8(uchar8 x) __attribute__ ((pure, simd));
static inline uchar8 __abs_char8(char8 x) __attribute__ ((pure, simd));
static inline ushort8 __abs_ushort8(ushort8 x) __attribute__ ((pure, simd));
static inline ushort8 __abs_short8(short8 x) __attribute__ ((pure, simd));
static inline uint8 __abs_uint8(uint8 x) __attribute__ ((pure, simd));
static inline uint8 __abs_int8(int8 x) __attribute__ ((pure, simd));
static inline ulong8 __abs_ulong8(ulong8 x) __attribute__ ((pure, simd));
static inline ulong8 __abs_long8(long8 x) __attribute__ ((pure, simd));
static inline uchar16 __abs_uchar16(uchar16 x) __attribute__ ((pure, simd));
static inline uchar16 __abs_char16(char16 x) __attribute__ ((pure, simd));
static inline ushort16 __abs_ushort16(ushort16 x) __attribute__ ((pure, simd));
static inline ushort16 __abs_short16(short16 x) __attribute__ ((pure, simd));
static inline uint16 __abs_uint16(uint16 x) __attribute__ ((pure, simd));
static inline uint16 __abs_int16(int16 x) __attribute__ ((pure, simd));
static inline ulong16 __abs_ulong16(ulong16 x) __attribute__ ((pure, simd));
static inline ulong16 __abs_long16(long16 x) __attribute__ ((pure, simd));
static inline uchar __abs_uchar(uchar x) __attribute__ ((pure, simd));
static inline uchar __abs_char(char x) __attribute__ ((pure, simd));
static inline ushort __abs_ushort(ushort x) __attribute__ ((pure, simd));
static inline ushort __abs_short(short x) __attribute__ ((pure, simd));
static inline uint __abs_uint(uint x) __attribute__ ((pure, simd));
static inline uint __abs_int(int x) __attribute__ ((pure, simd));
static inline ulong __abs_ulong(ulong x) __attribute__ ((pure, simd));
static inline ulong __abs_long(long x) __attribute__ ((pure, simd));
static inline uchar2 __abs_diff_uchar2(uchar2 x, uchar2 y) __attribute__ ((pure, simd));
static inline uchar3 __abs_diff_uchar3(uchar3 x, uchar3 y) __attribute__ ((pure, simd));
static inline uchar4 __abs_diff_uchar4(uchar4 x, uchar4 y) __attribute__ ((pure, simd));
static inline uchar8 __abs_diff_uchar8(uchar8 x, uchar8 y) __attribute__ ((pure, simd));
static inline uchar16 __abs_diff_uchar16(uchar16 x, uchar16 y) __attribute__ ((pure, simd));
static inline uchar2 __abs_diff_char2(char2 x, char2 y) __attribute__ ((pure, simd));
static inline ushort2 __abs_diff_ushort2(ushort2 x, ushort2 y) __attribute__ ((pure, simd));
static inline ushort2 __abs_diff_short2(short2 x, short2 y) __attribute__ ((pure, simd));
static inline uint2 __abs_diff_uint2(uint2 x, uint2 y) __attribute__ ((pure, simd));
static inline uint2 __abs_diff_int2(int2 x, int2 y) __attribute__ ((pure, simd));
static inline ulong2 __abs_diff_ulong2(ulong2 x, ulong2 y) __attribute__ ((pure, simd));
static inline ulong2 __abs_diff_long2(long2 x, long2 y) __attribute__ ((pure, simd));
static inline uchar3 __abs_diff_char3(char3 x, char3 y) __attribute__ ((pure, simd));
static inline ushort3 __abs_diff_ushort3(ushort3 x, ushort3 y) __attribute__ ((pure, simd));
static inline ushort3 __abs_diff_short3(short3 x, short3 y) __attribute__ ((pure, simd));
static inline uint3 __abs_diff_uint3(uint3 x, uint3 y) __attribute__ ((pure, simd));
static inline uint3 __abs_diff_int3(int3 x, int3 y) __attribute__ ((pure, simd));
static inline ulong3 __abs_diff_ulong3(ulong3 x, ulong3 y) __attribute__ ((pure, simd));
static inline ulong3 __abs_diff_long3(long3 x, long3 y) __attribute__ ((pure, simd));
static inline uchar4 __abs_diff_char4(char4 x, char4 y) __attribute__ ((pure, simd));
static inline ushort4 __abs_diff_ushort4(ushort4 x, ushort4 y) __attribute__ ((pure, simd));
static inline ushort4 __abs_diff_short4(short4 x, short4 y) __attribute__ ((pure, simd));
static inline uint4 __abs_diff_uint4(uint4 x, uint4 y) __attribute__ ((pure, simd));
static inline uint4 __abs_diff_int4(int4 x, int4 y) __attribute__ ((pure, simd));
static inline ulong4 __abs_diff_ulong4(ulong4 x, ulong4 y) __attribute__ ((pure, simd));
static inline ulong4 __abs_diff_long4(long4 x, long4 y) __attribute__ ((pure, simd));
static inline uchar8 __abs_diff_char8(char8 x, char8 y) __attribute__ ((pure, simd));
static inline ushort8 __abs_diff_ushort8(ushort8 x, ushort8 y) __attribute__ ((pure, simd));
static inline ushort8 __abs_diff_short8(short8 x, short8 y) __attribute__ ((pure, simd));
static inline uint8 __abs_diff_uint8(uint8 x, uint8 y) __attribute__ ((pure, simd));
static inline uint8 __abs_diff_int8(int8 x, int8 y) __attribute__ ((pure, simd));
static inline ulong8 __abs_diff_ulong8(ulong8 x, ulong8 y) __attribute__ ((pure, simd));
static inline ulong8 __abs_diff_long8(long8 x, long8 y) __attribute__ ((pure, simd));
static inline uchar16 __abs_diff_char16(char16 x, char16 y) __attribute__ ((pure, simd));
static inline ushort16 __abs_diff_ushort16(ushort16 x, ushort16 y) __attribute__ ((pure, simd));
static inline ushort16 __abs_diff_short16(short16 x, short16 y) __attribute__ ((pure, simd));
static inline uint16 __abs_diff_uint16(uint16 x, uint16 y) __attribute__ ((pure, simd));
static inline uint16 __abs_diff_int16(int16 x, int16 y) __attribute__ ((pure, simd));
static inline ulong16 __abs_diff_ulong16(ulong16 x, ulong16 y) __attribute__ ((pure, simd));
static inline ulong16 __abs_diff_long16(long16 x, long16 y) __attribute__ ((pure, simd));
static inline uchar __abs_diff_uchar(uchar x, uchar y) __attribute__ ((pure, simd));
static inline uchar __abs_diff_char(char x, char y) __attribute__ ((pure, simd));
static inline ushort __abs_diff_ushort(ushort x, ushort y) __attribute__ ((pure, simd));
static inline ushort __abs_diff_short(short x, short y) __attribute__ ((pure, simd));
static inline uint __abs_diff_uint(uint x, uint y) __attribute__ ((pure, simd));
static inline uint __abs_diff_int(int x, int y) __attribute__ ((pure, simd));
static inline ulong __abs_diff_ulong(ulong x, ulong y) __attribute__ ((pure, simd));
static inline ulong __abs_diff_long(long x, long y) __attribute__ ((pure, simd));
static inline char __hadd_char(char x, char y) __attribute__ ((pure, simd));
static inline char2 __hadd_char2(char2 x, char2 y) __attribute__ ((pure, simd));
static inline char3 __hadd_char3(char3 x, char3 y) __attribute__ ((pure, simd));
static inline char4 __hadd_char4(char4 x, char4 y) __attribute__ ((pure, simd));
static inline char8 __hadd_char8(char8 x, char8 y) __attribute__ ((pure, simd));
static inline char16 __hadd_char16(char16 x, char16 y) __attribute__ ((pure, simd));
static inline uchar __hadd_uchar(uchar x, uchar y) __attribute__ ((pure, simd));
static inline uchar2 __hadd_uchar2(uchar2 x, uchar2 y) __attribute__ ((pure, simd));
static inline uchar3 __hadd_uchar3(uchar3 x, uchar3 y) __attribute__ ((pure, simd));
static inline uchar4 __hadd_uchar4(uchar4 x, uchar4 y) __attribute__ ((pure, simd));
static inline uchar8 __hadd_uchar8(uchar8 x, uchar8 y) __attribute__ ((pure, simd));
static inline uchar16 __hadd_uchar16(uchar16 x, uchar16 y) __attribute__ ((pure, simd));
static inline short __hadd_short(short x, short y) __attribute__ ((pure, simd));
static inline short2 __hadd_short2(short2 x, short2 y) __attribute__ ((pure, simd));
static inline short3 __hadd_short3(short3 x, short3 y) __attribute__ ((pure, simd));
static inline short4 __hadd_short4(short4 x, short4 y) __attribute__ ((pure, simd));
static inline short8 __hadd_short8(short8 x, short8 y) __attribute__ ((pure, simd));
static inline short16 __hadd_short16(short16 x, short16 y) __attribute__ ((pure, simd));
static inline ushort __hadd_ushort(ushort x, ushort y) __attribute__ ((pure, simd));
static inline ushort2 __hadd_ushort2(ushort2 x, ushort2 y) __attribute__ ((pure, simd));
static inline ushort3 __hadd_ushort3(ushort3 x, ushort3 y) __attribute__ ((pure, simd));
static inline ushort4 __hadd_ushort4(ushort4 x, ushort4 y) __attribute__ ((pure, simd));
static inline ushort8 __hadd_ushort8(ushort8 x, ushort8 y) __attribute__ ((pure, simd));
static inline ushort16 __hadd_ushort16(ushort16 x, ushort16 y) __attribute__ ((pure, simd));
static inline int __hadd_int(int x, int y) __attribute__ ((pure, simd));
static inline int2 __hadd_int2(int2 x, int2 y) __attribute__ ((pure, simd));
static inline int3 __hadd_int3(int3 x, int3 y) __attribute__ ((pure, simd));
static inline int4 __hadd_int4(int4 x, int4 y) __attribute__ ((pure, simd));
static inline int8 __hadd_int8(int8 x, int8 y) __attribute__ ((pure, simd));
static inline int16 __hadd_int16(int16 x, int16 y) __attribute__ ((pure, simd));
static inline uint __hadd_uint(uint x, uint y) __attribute__ ((pure, simd));
static inline uint2 __hadd_uint2(uint2 x, uint2 y) __attribute__ ((pure, simd));
static inline uint3 __hadd_uint3(uint3 x, uint3 y) __attribute__ ((pure, simd));
static inline uint4 __hadd_uint4(uint4 x, uint4 y) __attribute__ ((pure, simd));
static inline uint8 __hadd_uint8(uint8 x, uint8 y) __attribute__ ((pure, simd));
static inline uint16 __hadd_uint16(uint16 x, uint16 y) __attribute__ ((pure, simd));
static inline long __hadd_long(long x, long y) __attribute__ ((pure, simd));
static inline long2 __hadd_long2(long2 x, long2 y) __attribute__ ((pure, simd));
static inline long3 __hadd_long3(long3 x, long3 y) __attribute__ ((pure, simd));
static inline long4 __hadd_long4(long4 x, long4 y) __attribute__ ((pure, simd));
static inline long8 __hadd_long8(long8 x, long8 y) __attribute__ ((pure, simd));
static inline long16 __hadd_long16(long16 x, long16 y) __attribute__ ((pure, simd));
static inline ulong __hadd_ulong(ulong x, ulong y) __attribute__ ((pure, simd));
static inline ulong2 __hadd_ulong2(ulong2 x, ulong2 y) __attribute__ ((pure, simd));
static inline ulong3 __hadd_ulong3(ulong3 x, ulong3 y) __attribute__ ((pure, simd));
static inline ulong4 __hadd_ulong4(ulong4 x, ulong4 y) __attribute__ ((pure, simd));
static inline ulong8 __hadd_ulong8(ulong8 x, ulong8 y) __attribute__ ((pure, simd));
static inline ulong16 __hadd_ulong16(ulong16 x, ulong16 y) __attribute__ ((pure, simd));
static inline char2 __rhadd_char2(char2 x, char2 y) __attribute__ ((pure, simd));
static inline uchar2 __rhadd_uchar2(uchar2 x, uchar2 y) __attribute__ ((pure, simd));
static inline char3 __rhadd_char3(char3 x, char3 y) __attribute__ ((pure, simd));
static inline uchar3 __rhadd_uchar3(uchar3 x, uchar3 y) __attribute__ ((pure, simd));
static inline char4 __rhadd_char4(char4 x, char4 y) __attribute__ ((pure, simd));
static inline uchar4 __rhadd_uchar4(uchar4 x, uchar4 y) __attribute__ ((pure, simd));
static inline char8 __rhadd_char8(char8 x, char8 y) __attribute__ ((pure, simd));
static inline uchar8 __rhadd_uchar8(uchar8 x, uchar8 y) __attribute__ ((pure, simd));
static inline char16 __rhadd_char16(char16 x, char16 y) __attribute__ ((pure, simd));
static inline uchar16 __rhadd_uchar16(uchar16 x, uchar16 y) __attribute__ ((pure, simd));
static inline short2 __rhadd_short2(short2 x, short2 y) __attribute__ ((pure, simd));
static inline ushort2 __rhadd_ushort2(ushort2 x, ushort2 y) __attribute__ ((pure, simd));
static inline short3 __rhadd_short3(short3 x, short3 y) __attribute__ ((pure, simd));
static inline ushort3 __rhadd_ushort3(ushort3 x, ushort3 y) __attribute__ ((pure, simd));
static inline short4 __rhadd_short4(short4 x, short4 y) __attribute__ ((pure, simd));
static inline ushort4 __rhadd_ushort4(ushort4 x, ushort4 y) __attribute__ ((pure, simd));
static inline short8 __rhadd_short8(short8 x, short8 y) __attribute__ ((pure, simd));
static inline ushort8 __rhadd_ushort8(ushort8 x, ushort8 y) __attribute__ ((pure, simd));
static inline short16 __rhadd_short16(short16 x, short16 y) __attribute__ ((pure, simd));
static inline ushort16 __rhadd_ushort16(ushort16 x, ushort16 y) __attribute__ ((pure, simd));
static inline int2 __rhadd_int2(int2 x, int2 y) __attribute__ ((pure, simd));
static inline uint2 __rhadd_uint2(uint2 x, uint2 y) __attribute__ ((pure, simd));
static inline int3 __rhadd_int3(int3 x, int3 y) __attribute__ ((pure, simd));
static inline uint3 __rhadd_uint3(uint3 x, uint3 y) __attribute__ ((pure, simd));
static inline int4 __rhadd_int4(int4 x, int4 y) __attribute__ ((pure, simd));
static inline uint4 __rhadd_uint4(uint4 x, uint4 y) __attribute__ ((pure, simd));
static inline int8 __rhadd_int8(int8 x, int8 y) __attribute__ ((pure, simd));
static inline uint8 __rhadd_uint8(uint8 x, uint8 y) __attribute__ ((pure, simd));
static inline int16 __rhadd_int16(int16 x, int16 y) __attribute__ ((pure, simd));
static inline uint16 __rhadd_uint16(uint16 x, uint16 y) __attribute__ ((pure, simd));
static inline char __rhadd_char(char x, char y) __attribute__ ((pure, simd));
static inline uchar __rhadd_uchar(uchar x, uchar y) __attribute__ ((pure, simd));
static inline short __rhadd_short(short x, short y) __attribute__ ((pure, simd));
static inline ushort __rhadd_ushort(ushort x, ushort y) __attribute__ ((pure, simd));
static inline int __rhadd_int(int x, int y)  __attribute__ ((pure, simd));
static inline uint __rhadd_uint(uint x, uint y) __attribute__ ((pure, simd));
static inline long __rhadd_long(long x, long y) __attribute__ ((pure, simd));
static inline ulong __rhadd_ulong(ulong x, ulong y) __attribute__ ((pure, simd));
static inline long2 __rhadd_long2(long2 x, long2 y) __attribute__ ((pure, simd));
static inline ulong2 __rhadd_ulong2(ulong2 x, ulong2 y) __attribute__ ((pure, simd));
static inline long3 __rhadd_long3(long3 x, long3 y) __attribute__ ((pure, simd));
static inline ulong3 __rhadd_ulong3(ulong3 x, ulong3 y) __attribute__ ((pure, simd));
static inline long4 __rhadd_long4(long4 x, long4 y) __attribute__ ((pure, simd));
static inline ulong4 __rhadd_ulong4(ulong4 x, ulong4 y) __attribute__ ((pure, simd));
static inline long8 __rhadd_long8(long8 x, long8 y) __attribute__ ((pure, simd));
static inline ulong8 __rhadd_ulong8(ulong8 x, ulong8 y) __attribute__ ((pure, simd));
static inline long16 __rhadd_long16(long16 x, long16 y) __attribute__ ((pure, simd));
static inline ulong16 __rhadd_ulong16(ulong16 x, ulong16 y) __attribute__ ((pure, simd));
static inline char2 __add_sat_char2(char2 x, char2 y) __attribute__ ((pure, simd));
static inline uchar2 __add_sat_uchar2(uchar2 x, uchar2 y) __attribute__ ((pure, simd));
static inline char3 __add_sat_char3(char3 x, char3 y) __attribute__ ((pure, simd));
static inline uchar3 __add_sat_uchar3(uchar3 x, uchar3 y) __attribute__ ((pure, simd));
static inline char4 __add_sat_char4(char4 x, char4 y) __attribute__ ((pure, simd));
static inline uchar4 __add_sat_uchar4(uchar4 x, uchar4 y) __attribute__ ((pure, simd));
static inline char8 __add_sat_char8(char8 x, char8 y) __attribute__ ((pure, simd));
static inline uchar8 __add_sat_uchar8(uchar8 x, uchar8 y) __attribute__ ((pure, simd));
static inline char16 __add_sat_char16(char16 x, char16 y) __attribute__ ((pure, simd));
static inline uchar16 __add_sat_uchar16(uchar16 x, uchar16 y) __attribute__ ((pure, simd));
static inline short2 __add_sat_short2(short2 x, short2 y) __attribute__ ((pure, simd));
static inline ushort2 __add_sat_ushort2(ushort2 x, ushort2 y) __attribute__ ((pure, simd));
static inline short3 __add_sat_short3(short3 x, short3 y) __attribute__ ((pure, simd));
static inline ushort3 __add_sat_ushort3(ushort3 x, ushort3 y) __attribute__ ((pure, simd));
static inline short4 __add_sat_short4(short4 x, short4 y) __attribute__ ((pure, simd));
static inline ushort4 __add_sat_ushort4(ushort4 x, ushort4 y) __attribute__ ((pure, simd));
static inline short8 __add_sat_short8(short8 x, short8 y) __attribute__ ((pure, simd));
static inline ushort8 __add_sat_ushort8(ushort8 x, ushort8 y) __attribute__ ((pure, simd));
static inline short16 __add_sat_short16(short16 x, short16 y) __attribute__ ((pure, simd));
static inline ushort16 __add_sat_ushort16(ushort16 x, ushort16 y) __attribute__ ((pure, simd));
static inline int2 __add_sat_int2(int2 x, int2 y) __attribute__ ((pure, simd));
static inline uint2 __add_sat_uint2(uint2 x, uint2 y) __attribute__ ((pure, simd));
static inline int3 __add_sat_int3(int3 x, int3 y) __attribute__ ((pure, simd));
static inline uint3 __add_sat_uint3(uint3 x, uint3 y) __attribute__ ((pure, simd));
static inline int4 __add_sat_int4(int4 x, int4 y) __attribute__ ((pure, simd));
static inline uint4 __add_sat_uint4(uint4 x, uint4 y) __attribute__ ((pure, simd));
static inline int8 __add_sat_int8(int8 x, int8 y) __attribute__ ((pure, simd));
static inline uint8 __add_sat_uint8(uint8 x, uint8 y) __attribute__ ((pure, simd));
static inline int16 __add_sat_int16(int16 x, int16 y) __attribute__ ((pure, simd));
static inline uint16 __add_sat_uint16(uint16 x, uint16 y) __attribute__ ((pure, simd));
static inline uchar __add_sat_uchar(uchar x, uchar y) __attribute__ ((pure, simd));
static inline ushort __add_sat_ushort(ushort x, ushort y) __attribute__ ((pure, simd));
static inline uint __add_sat_uint(uint x, uint y) __attribute__ ((pure, simd));
static inline char __add_sat_char(char x, char y) __attribute__ ((pure, simd));
static inline short __add_sat_short(short x, short y) __attribute__ ((pure, simd));
static inline int __add_sat_int(int x, int y) __attribute__ ((pure, simd));
static inline long2 __add_sat_long2(long2 x, long2 y) __attribute__ ((pure, simd));
static inline ulong2 __add_sat_ulong2(ulong2 x, ulong2 y) __attribute__ ((pure, simd));
static inline long3 __add_sat_long3(long3 x, long3 y) __attribute__ ((pure, simd));
static inline ulong3 __add_sat_ulong3(ulong3 x, ulong3 y) __attribute__ ((pure, simd));
static inline long4 __add_sat_long4(long4 x, long4 y) __attribute__ ((pure, simd));
static inline ulong4 __add_sat_ulong4(ulong4 x, ulong4 y) __attribute__ ((pure, simd));
static inline long8 __add_sat_long8(long8 x, long8 y) __attribute__ ((pure, simd));
static inline ulong8 __add_sat_ulong8(ulong8 x, ulong8 y) __attribute__ ((pure, simd));
static inline long16 __add_sat_long16(long16 x, long16 y) __attribute__ ((pure, simd));
static inline ulong16 __add_sat_ulong16(ulong16 x, ulong16 y) __attribute__ ((pure, simd));
static inline ulong __add_sat_ulong(ulong x, ulong y) __attribute__ ((pure, simd));
static inline long __add_sat_long(long x, long y) __attribute__ ((pure, simd));
static inline char2 __sub_sat_char2(char2 x, char2 y) __attribute__ ((pure, simd));
static inline uchar2 __sub_sat_uchar2(uchar2 x, uchar2 y) __attribute__ ((pure, simd));
static inline char3 __sub_sat_char3(char3 x, char3 y) __attribute__ ((pure, simd));
static inline uchar3 __sub_sat_uchar3(uchar3 x, uchar3 y) __attribute__ ((pure, simd));
static inline char4 __sub_sat_char4(char4 x, char4 y) __attribute__ ((pure, simd));
static inline uchar4 __sub_sat_uchar4(uchar4 x, uchar4 y) __attribute__ ((pure, simd));
static inline char8 __sub_sat_char8(char8 x, char8 y) __attribute__ ((pure, simd));
static inline uchar8 __sub_sat_uchar8(uchar8 x, uchar8 y) __attribute__ ((pure, simd));
static inline char16 __sub_sat_char16(char16 x, char16 y) __attribute__ ((pure, simd));
static inline uchar16 __sub_sat_uchar16(uchar16 x, uchar16 y) __attribute__ ((pure, simd));
static inline short2 __sub_sat_short2(short2 x, short2 y) __attribute__ ((pure, simd));
static inline ushort2 __sub_sat_ushort2(ushort2 x, ushort2 y) __attribute__ ((pure, simd));
static inline short3 __sub_sat_short3(short3 x, short3 y) __attribute__ ((pure, simd));
static inline ushort3 __sub_sat_ushort3(ushort3 x, ushort3 y) __attribute__ ((pure, simd));
static inline short4 __sub_sat_short4(short4 x, short4 y) __attribute__ ((pure, simd));
static inline ushort4 __sub_sat_ushort4(ushort4 x, ushort4 y) __attribute__ ((pure, simd));
static inline short8 __sub_sat_short8(short8 x, short8 y) __attribute__ ((pure, simd));
static inline ushort8 __sub_sat_ushort8(ushort8 x, ushort8 y) __attribute__ ((pure, simd));
static inline short16 __sub_sat_short16(short16 x, short16 y) __attribute__ ((pure, simd));
static inline ushort16 __sub_sat_ushort16(ushort16 x, ushort16 y) __attribute__ ((pure, simd));
static inline int2 __sub_sat_int2(int2 x, int2 y) __attribute__ ((pure, simd));
static inline uint2 __sub_sat_uint2(uint2 x, uint2 y) __attribute__ ((pure, simd));
static inline int3 __sub_sat_int3(int3 x, int3 y) __attribute__ ((pure, simd));
static inline uint3 __sub_sat_uint3(uint3 x, uint3 y) __attribute__ ((pure, simd));
static inline int4 __sub_sat_int4(int4 x, int4 y) __attribute__ ((pure, simd));
static inline uint4 __sub_sat_uint4(uint4 x, uint4 y) __attribute__ ((pure, simd));
static inline int8 __sub_sat_int8(int8 x, int8 y) __attribute__ ((pure, simd));
static inline uint8 __sub_sat_uint8(uint8 x, uint8 y) __attribute__ ((pure, simd));
static inline int16 __sub_sat_int16(int16 x, int16 y) __attribute__ ((pure, simd));
static inline uint16 __sub_sat_uint16(uint16 x, uint16 y) __attribute__ ((pure, simd));
static inline long2 __sub_sat_long2(long2 x, long2 y) __attribute__ ((pure, simd));
static inline ulong2 __sub_sat_ulong2(ulong2 x, ulong2 y) __attribute__ ((pure, simd));
static inline long3 __sub_sat_long3(long3 x, long3 y) __attribute__ ((pure, simd));
static inline ulong3 __sub_sat_ulong3(ulong3 x, ulong3 y) __attribute__ ((pure, simd));
static inline long4 __sub_sat_long4(long4 x, long4 y) __attribute__ ((pure, simd));
static inline ulong4 __sub_sat_ulong4(ulong4 x, ulong4 y) __attribute__ ((pure, simd));
static inline long8 __sub_sat_long8(long8 x, long8 y) __attribute__ ((pure, simd));
static inline ulong8 __sub_sat_ulong8(ulong8 x, ulong8 y) __attribute__ ((pure, simd));
static inline long16 __sub_sat_long16(long16 x, long16 y) __attribute__ ((pure, simd));
static inline ulong16 __sub_sat_ulong16(ulong16 x, ulong16 y) __attribute__ ((pure, simd));
static inline uchar __sub_sat_uchar(uchar x, uchar y) __attribute__ ((pure, simd));
static inline ushort __sub_sat_ushort(ushort x, ushort y) __attribute__ ((pure, simd));
static inline uint __sub_sat_uint(uint x, uint y) __attribute__ ((pure, simd));
static inline ulong __sub_sat_ulong(ulong x, ulong y) __attribute__ ((pure, simd));
static inline char __sub_sat_char(char x, char y) __attribute__ ((pure, simd));
static inline short __sub_sat_short(short x, short y) __attribute__ ((pure, simd));
static inline int __sub_sat_int(int x, int y) __attribute__ ((pure, simd));
static inline long __sub_sat_long(long x, long y) __attribute__ ((pure, simd));
static inline float2 __tgamma_float2(float2 x) __attribute__ ((pure, simd));
static inline float4 __tgamma_float4(float4 x) __attribute__ ((pure, simd));
static inline float8 __tgamma_float8(float8 x) __attribute__ ((pure, simd));
static inline float16 __tgamma_float16(float16 x) __attribute__ ((pure, simd));
static inline float __tgamma_float(float x) __attribute__ ((pure, simd));
static inline float3 __tgamma_float3(float3 x) __attribute__ ((pure, simd));
static inline char __mad_hi_char(char a, char b, char c) __attribute__ ((pure, simd));
static inline uchar __mad_hi_uchar(uchar a, uchar b, uchar c) __attribute__ ((pure, simd));
static inline short __mad_hi_short(short a, short b, short c) __attribute__ ((pure, simd));
static inline ushort __mad_hi_ushort(ushort a, ushort b, ushort c) __attribute__ ((pure, simd));
static inline int __mad_hi_int(int a, int b, int c) __attribute__ ((pure, simd));
static inline uint __mad_hi_uint(uint a, uint b, uint c) __attribute__ ((pure, simd));
static inline long __mad_hi_long(long a, long b, long c) __attribute__ ((pure, simd));
static inline ulong __mad_hi_ulong(ulong a, ulong b, ulong c) __attribute__ ((pure, simd));
static inline char2 __mad_hi_char2(char2 a, char2 b, char2 c) __attribute__ ((pure, simd));
static inline uchar2 __mad_hi_uchar2(uchar2 a, uchar2 b, uchar2 c) __attribute__ ((pure, simd));
static inline short2 __mad_hi_short2(short2 a, short2 b, short2 c) __attribute__ ((pure, simd));
static inline ushort2 __mad_hi_ushort2(ushort2 a, ushort2 b, ushort2 c) __attribute__ ((pure, simd));
static inline int2 __mad_hi_int2(int2 a, int2 b, int2 c) __attribute__ ((pure, simd));
static inline uint2 __mad_hi_uint2(uint2 a, uint2 b, uint2 c) __attribute__ ((pure, simd));
static inline long2 __mad_hi_long2(long2 a, long2 b, long2 c) __attribute__ ((pure, simd));
static inline ulong2 __mad_hi_ulong2(ulong2 a, ulong2 b, ulong2 c) __attribute__ ((pure, simd));
static inline char3 __mad_hi_char3(char3 a, char3 b, char3 c) __attribute__ ((pure, simd));
static inline uchar3 __mad_hi_uchar3(uchar3 a, uchar3 b, uchar3 c) __attribute__ ((pure, simd));
static inline short3 __mad_hi_short3(short3 a, short3 b, short3 c) __attribute__ ((pure, simd));
static inline ushort3 __mad_hi_ushort3(ushort3 a, ushort3 b, ushort3 c) __attribute__ ((pure, simd));
static inline int3 __mad_hi_int3(int3 a, int3 b, int3 c) __attribute__ ((pure, simd));
static inline uint3 __mad_hi_uint3(uint3 a, uint3 b, uint3 c) __attribute__ ((pure, simd));
static inline long3 __mad_hi_long3(long3 a, long3 b, long3 c) __attribute__ ((pure, simd));
static inline ulong3 __mad_hi_ulong3(ulong3 a, ulong3 b, ulong3 c) __attribute__ ((pure, simd));
static inline char4 __mad_hi_char4(char4 a, char4 b, char4 c) __attribute__ ((pure, simd));
static inline uchar4 __mad_hi_uchar4(uchar4 a, uchar4 b, uchar4 c) __attribute__ ((pure, simd));
static inline short4 __mad_hi_short4(short4 a, short4 b, short4 c) __attribute__ ((pure, simd));
static inline ushort4 __mad_hi_ushort4(ushort4 a, ushort4 b, ushort4 c) __attribute__ ((pure, simd));
static inline int4 __mad_hi_int4(int4 a, int4 b, int4 c) __attribute__ ((pure, simd));
static inline uint4 __mad_hi_uint4(uint4 a, uint4 b, uint4 c) __attribute__ ((pure, simd));
static inline long4 __mad_hi_long4(long4 a, long4 b, long4 c) __attribute__ ((pure, simd));
static inline ulong4 __mad_hi_ulong4(ulong4 a, ulong4 b, ulong4 c) __attribute__ ((pure, simd));
static inline char8 __mad_hi_char8(char8 a, char8 b, char8 c) __attribute__ ((pure, simd));
static inline uchar8 __mad_hi_uchar8(uchar8 a, uchar8 b, uchar8 c) __attribute__ ((pure, simd));
static inline short8 __mad_hi_short8(short8 a, short8 b, short8 c) __attribute__ ((pure, simd));
static inline ushort8 __mad_hi_ushort8(ushort8 a, ushort8 b, ushort8 c) __attribute__ ((pure, simd));
static inline int8 __mad_hi_int8(int8 a, int8 b, int8 c) __attribute__ ((pure, simd));
static inline uint8 __mad_hi_uint8(uint8 a, uint8 b, uint8 c) __attribute__ ((pure, simd));
static inline long8 __mad_hi_long8(long8 a, long8 b, long8 c) __attribute__ ((pure, simd));
static inline ulong8 __mad_hi_ulong8(ulong8 a, ulong8 b, ulong8 c) __attribute__ ((pure, simd));
static inline char16 __mad_hi_char16(char16 a, char16 b, char16 c) __attribute__ ((pure, simd));
static inline uchar16 __mad_hi_uchar16(uchar16 a, uchar16 b, uchar16 c) __attribute__ ((pure, simd));
static inline short16 __mad_hi_short16(short16 a, short16 b, short16 c) __attribute__ ((pure, simd));
static inline ushort16 __mad_hi_ushort16(ushort16 a, ushort16 b, ushort16 c) __attribute__ ((pure, simd));
static inline int16 __mad_hi_int16(int16 a, int16 b, int16 c) __attribute__ ((pure, simd));
static inline uint16 __mad_hi_uint16(uint16 a, uint16 b, uint16 c) __attribute__ ((pure, simd));
static inline long16 __mad_hi_long16(long16 a, long16 b, long16 c) __attribute__ ((pure, simd));
static inline ulong16 __mad_hi_ulong16(ulong16 a, ulong16 b, ulong16 c) __attribute__ ((pure, simd));
static inline char __mul_hi_char(char x, char y) __attribute__ ((pure, simd));
static inline uchar __mul_hi_uchar(uchar x, uchar y) __attribute__ ((pure, simd));
static inline short __mul_hi_short(short x, short y) __attribute__ ((pure, simd));
static inline ushort __mul_hi_ushort(ushort x, ushort y) __attribute__ ((pure, simd));
static inline char2 __mul_hi_char2(char2 x, char2 y) __attribute__ ((pure, simd));
static inline uchar2 __mul_hi_uchar2(uchar2 x, uchar2 y) __attribute__ ((pure, simd));
static inline short2 __mul_hi_short2(short2 x, short2 y) __attribute__ ((pure, simd));
static inline ushort2 __mul_hi_ushort2(ushort2 x, ushort2 y) __attribute__ ((pure, simd));
static inline char3 __mul_hi_char3(char3 x, char3 y) __attribute__ ((pure, simd));
static inline uchar3 __mul_hi_uchar3(uchar3 x, uchar3 y) __attribute__ ((pure, simd));
static inline short3 __mul_hi_short3(short3 x, short3 y) __attribute__ ((pure, simd));
static inline ushort3 __mul_hi_ushort3(ushort3 x, ushort3 y) __attribute__ ((pure, simd));
static inline char4 __mul_hi_char4(char4 x, char4 y) __attribute__ ((pure, simd));
static inline uchar4 __mul_hi_uchar4(uchar4 x, uchar4 y) __attribute__ ((pure, simd));
static inline short4 __mul_hi_short4(short4 x, short4 y) __attribute__ ((pure, simd));
static inline ushort4 __mul_hi_ushort4(ushort4 x, ushort4 y) __attribute__ ((pure, simd));
static inline char8 __mul_hi_char8(char8 x, char8 y) __attribute__ ((pure, simd));
static inline uchar8 __mul_hi_uchar8(uchar8 x, uchar8 y) __attribute__ ((pure, simd));
static inline short8 __mul_hi_short8(short8 x, short8 y) __attribute__ ((pure, simd));
static inline ushort8 __mul_hi_ushort8(ushort8 x, ushort8 y) __attribute__ ((pure, simd));
static inline char16 __mul_hi_char16(char16 x, char16 y) __attribute__ ((pure, simd));
static inline uchar16 __mul_hi_uchar16(uchar16 x, uchar16 y) __attribute__ ((pure, simd));
static inline short16 __mul_hi_short16(short16 x, short16 y) __attribute__ ((pure, simd));
static inline ushort16 __mul_hi_ushort16(ushort16 x, ushort16 y) __attribute__ ((pure, simd));
static inline int __mul_hi_int(int x, int y) __attribute__ ((pure, simd));
static inline uint __mul_hi_uint(uint x, uint y) __attribute__ ((pure, simd));
static inline int2 __mul_hi_int2(int2 x, int2 y) __attribute__ ((pure, simd));
static inline uint2 __mul_hi_uint2(uint2 x, uint2 y) __attribute__ ((pure, simd));
static inline int3 __mul_hi_int3(int3 x, int3 y) __attribute__ ((pure, simd));
static inline uint3 __mul_hi_uint3(uint3 x, uint3 y) __attribute__ ((pure, simd));
static inline int4 __mul_hi_int4(int4 x, int4 y) __attribute__ ((pure, simd));
static inline uint4 __mul_hi_uint4(uint4 x, uint4 y) __attribute__ ((pure, simd));
static inline int8 __mul_hi_int8(int8 x, int8 y) __attribute__ ((pure, simd));
static inline uint8 __mul_hi_uint8(uint8 x, uint8 y) __attribute__ ((pure, simd));
static inline int16 __mul_hi_int16(int16 x, int16 y) __attribute__ ((pure, simd));
static inline uint16 __mul_hi_uint16(uint16 x, uint16 y) __attribute__ ((pure, simd));
static inline ulong2 __mul_hi_ulong2(ulong2 x, ulong2 y) __attribute__ ((pure, simd));
static inline long2 __mul_hi_long2(long2 sx, long2 sy) __attribute__ ((pure, simd));
static inline ulong4 __mul_hi_ulong4(ulong4 x, ulong4 y) __attribute__ ((pure, simd));
static inline long4 __mul_hi_long4(long4 sx, long4 sy) __attribute__ ((pure, simd));
static inline ulong8 __mul_hi_ulong8(ulong8 x, ulong8 y) __attribute__ ((pure, simd));
static inline long8 __mul_hi_long8(long8 sx, long8 sy) __attribute__ ((pure, simd));
static inline ulong16 __mul_hi_ulong16(ulong16 x, ulong16 y) __attribute__ ((pure, simd));
static inline long16 __mul_hi_long16(long16 sx, long16 sy) __attribute__ ((pure, simd));
static inline long __mul_hi_long(long x, long y) __attribute__ ((pure, simd));
static inline ulong __mul_hi_ulong(ulong x, ulong y) __attribute__ ((pure, simd));
static inline long3 __mul_hi_long3(long3 sx, long3 sy) __attribute__ ((pure, simd));
static inline ulong3 __mul_hi_ulong3(ulong3 sx, ulong3 sy) __attribute__ ((pure, simd));
static inline uchar __mad_sat_uchar(uchar a, uchar b, uchar c) __attribute__ ((pure, simd));
static inline uchar2 __mad_sat_uchar2(uchar2 a, uchar2 b, uchar2 c) __attribute__ ((pure, simd));
static inline uchar3 __mad_sat_uchar3(uchar3 a, uchar3 b, uchar3 c) __attribute__ ((pure, simd));
static inline uchar4 __mad_sat_uchar4(uchar4 a, uchar4 b, uchar4 c) __attribute__ ((pure, simd));
static inline uchar8 __mad_sat_uchar8(uchar8 a, uchar8 b, uchar8 c) __attribute__ ((pure, simd));
static inline uchar16 __mad_sat_uchar16(uchar16 a, uchar16 b, uchar16 c) __attribute__ ((pure, simd));
static inline char __mad_sat_char(char a, char b, char c) __attribute__ ((pure, simd));
static inline char8 __mad_sat_char8(char8 a, char8 b, char8 c) __attribute__ ((pure, simd));
static inline char16 __mad_sat_char16(char16 a, char16 b, char16 c) __attribute__ ((pure, simd));
static inline char2 __mad_sat_char2(char2 a, char2 b, char2 c) __attribute__ ((pure, simd));
static inline char3 __mad_sat_char3(char3 a, char3 b, char3 c) __attribute__ ((pure, simd));
static inline char4 __mad_sat_char4(char4 a, char4 b, char4 c) __attribute__ ((pure, simd));
static inline ushort __mad_sat_ushort(ushort a, ushort b, ushort c) __attribute__ ((pure, simd));
static inline short __mad_sat_short(short a, short b, short c) __attribute__ ((pure, simd));
static inline ushort2 __mad_sat_ushort2(ushort2 a, ushort2 b, ushort2 c) __attribute__ ((pure, simd));
static inline short2 __mad_sat_short2(short2 a, short2 b, short2 c) __attribute__ ((pure, simd));
static inline ushort3 __mad_sat_ushort3(ushort3 a, ushort3 b, ushort3 c) __attribute__ ((pure, simd));
static inline short3 __mad_sat_short3(short3 a, short3 b, short3 c) __attribute__ ((pure, simd));
static inline ushort4 __mad_sat_ushort4(ushort4 a, ushort4 b, ushort4 c) __attribute__ ((pure, simd));
static inline short4 __mad_sat_short4(short4 a, short4 b, short4 c) __attribute__ ((pure, simd));
static inline ushort8 __mad_sat_ushort8(ushort8 a, ushort8 b, ushort8 c) __attribute__ ((pure, simd));
static inline short8 __mad_sat_short8(short8 a, short8 b, short8 c) __attribute__ ((pure, simd));
static inline ushort16 __mad_sat_ushort16(ushort16 a, ushort16 b, ushort16 c) __attribute__ ((pure, simd));
static inline short16 __mad_sat_short16(short16 a, short16 b, short16 c) __attribute__ ((pure, simd));
static inline int2 __mad_sat_int2(int2 a, int2 b, int2 c) __attribute__ ((pure, simd));
static inline uint2 __mad_sat_uint2(uint2 a, uint2 b, uint2 c) __attribute__ ((pure, simd));
static inline ulong2 __mad_sat_ulong2(ulong2 a, ulong2 b, ulong2 c) __attribute__ ((pure, simd));
static inline long2 __mad_sat_long2(long2 a, long2 b, long2 c) __attribute__ ((pure, simd));
static inline int4 __mad_sat_int4(int4 a, int4 b, int4 c) __attribute__ ((pure, simd));
static inline uint4 __mad_sat_uint4(uint4 a, uint4 b, uint4 c) __attribute__ ((pure, simd));
static inline ulong4 __mad_sat_ulong4(ulong4 a, ulong4 b, ulong4 c) __attribute__ ((pure, simd));
static inline long4 __mad_sat_long4(long4 a, long4 b, long4 c) __attribute__ ((pure, simd));
static inline int8 __mad_sat_int8(int8 a, int8 b, int8 c) __attribute__ ((pure, simd));
static inline uint8 __mad_sat_uint8(uint8 a, uint8 b, uint8 c) __attribute__ ((pure, simd));
static inline ulong8 __mad_sat_ulong8(ulong8 a, ulong8 b, ulong8 c) __attribute__ ((pure, simd));
static inline long8 __mad_sat_long8(long8 a, long8 b, long8 c) __attribute__ ((pure, simd));
static inline int16 __mad_sat_int16(int16 a, int16 b, int16 c) __attribute__ ((pure, simd));
static inline uint16 __mad_sat_uint16(uint16 a, uint16 b, uint16 c) __attribute__ ((pure, simd));
static inline ulong16 __mad_sat_ulong16(ulong16 a, ulong16 b, ulong16 c) __attribute__ ((pure, simd));
static inline long16 __mad_sat_long16(long16 a, long16 b, long16 c) __attribute__ ((pure, simd));
static inline uint __mad_sat_uint(uint a, uint b, uint c) __attribute__ ((pure, simd));
static inline int __mad_sat_int(int a, int b, int c) __attribute__ ((pure, simd));
static inline long __mad_sat_long(long a, long b, long c) __attribute__ ((pure, simd));
static inline ulong __mad_sat_ulong(ulong a, ulong b, ulong c) __attribute__ ((pure, simd));
static inline int3 __mad_sat_int3(int3 a, int3 b, int3 c) __attribute__ ((pure, simd));
static inline uint3 __mad_sat_uint3(uint3 a, uint3 b, uint3 c) __attribute__ ((pure, simd));
static inline long3 __mad_sat_long3(long3 a, long3 b, long3 c) __attribute__ ((pure, simd));
static inline ulong3 __mad_sat_ulong3(ulong3 a, ulong3 b, ulong3 c) __attribute__ ((pure, simd));
static inline short __upsample_short (char hi, uchar lo) __attribute__ ((pure, simd));
static inline short2 __upsample_short2(char2 hi, uchar2 lo) __attribute__ ((pure, simd));
static inline short4 __upsample_short4(char4 hi, uchar4 lo) __attribute__ ((pure, simd));
static inline short8 __upsample_short8(char8 hi, uchar8 lo) __attribute__ ((pure, simd));
static inline short __upsample_ushort (uchar hi, uchar lo) __attribute__ ((pure, simd));
static inline ushort2 __upsample_ushort2(uchar2 hi, uchar2 lo) __attribute__ ((pure, simd));
static inline ushort4 __upsample_ushort4(uchar4 hi, uchar4 lo) __attribute__ ((pure, simd));
static inline ushort8 __upsample_ushort8(uchar8 hi, uchar8 lo) __attribute__ ((pure, simd));
static inline int __upsample_int(short hi, ushort lo) __attribute__ ((pure, simd));
static inline int2 __upsample_int2(short2 hi, ushort2 lo) __attribute__ ((pure, simd));
static inline int4 __upsample_int4(short4 hi, ushort4 lo) __attribute__ ((pure, simd));
static inline int8 __upsample_int8(short8 hi, ushort8 lo) __attribute__ ((pure, simd));
static inline uint __upsample_uint(ushort hi, ushort lo) __attribute__ ((pure, simd));
static inline uint2 __upsample_uint2(ushort2 hi, ushort2 lo) __attribute__ ((pure, simd));
static inline uint4 __upsample_uint4(ushort4 hi, ushort4 lo) __attribute__ ((pure, simd));
static inline uint8 __upsample_uint8(ushort8 hi, ushort8 lo) __attribute__ ((pure, simd));
static inline long __upsample_long(int hi, uint lo) __attribute__ ((pure, simd));
static inline long2 __upsample_long2(int2 hi, uint2 lo) __attribute__ ((pure, simd));
static inline long4 __upsample_long4(int4 hi, uint4 lo) __attribute__ ((pure, simd));
static inline long8 __upsample_long8(int8 hi, uint8 lo) __attribute__ ((pure, simd));
static inline ulong __upsample_ulong(uint hi, uint lo) __attribute__ ((pure, simd));
static inline ulong2 __upsample_ulong2(uint2 hi, uint2 lo) __attribute__ ((pure, simd));
static inline ulong4 __upsample_ulong4(uint4 hi, uint4 lo) __attribute__ ((pure, simd));
static inline ulong8 __upsample_ulong8(uint8 hi, uint8 lo) __attribute__ ((pure, simd));
static inline short16 __upsample_short16(char16 hi, uchar16 lo) __attribute__ ((pure, simd));
static inline ushort16 __upsample_ushort16(uchar16 hi, uchar16 lo) __attribute__ ((pure, simd));
static inline int16 __upsample_int16(short16 hi, ushort16 lo) __attribute__ ((pure, simd));
static inline uint16 __upsample_uint16(ushort16 hi, ushort16 lo) __attribute__ ((pure, simd));
static inline long16 __upsample_long16(int16 hi, uint16 lo) __attribute__ ((pure, simd));
static inline ulong16 __upsample_ulong16(uint16 hi, uint16 lo) __attribute__ ((pure, simd));
static inline short3 __upsample_short3(char3 hi, uchar3 lo) __attribute__ ((pure, simd));
static inline ushort3 __upsample_ushort3(uchar3 hi, uchar3 lo) __attribute__ ((pure, simd));
static inline int3 __upsample_int3(short3 hi, ushort3 lo) __attribute__ ((pure, simd));
static inline uint3 __upsample_uint3(ushort3 hi, ushort3 lo) __attribute__ ((pure, simd));
static inline long3 __upsample_long3(int3 hi, uint3 lo) __attribute__ ((pure, simd));
static inline ulong3 __upsample_ulong3(uint3 hi, uint3 lo) __attribute__ ((pure, simd));
static inline float2 __clamp_float2 (float2 x, float2 minval, float2 maxval)  __attribute__ ((pure, simd));
static inline float2 __clamp_float_float2 (float2 x, float minval, float maxval)  __attribute__ ((pure, simd));
static inline char2 __clamp_char2 (char2 x, char2 minval, char2 maxval) __attribute__ ((pure, simd));
static inline uchar2 __clamp_uchar2 (uchar2 x, uchar2 minval, uchar2 maxval) __attribute__ ((pure, simd));
static inline short2 __clamp_short2 (short2 x, short2 minval, short2 maxval) __attribute__ ((pure, simd));
static inline ushort2 __clamp_ushort2 (ushort2 x, ushort2 minval, ushort2 maxval) __attribute__ ((pure, simd));
static inline int2 __clamp_int2 (int2 x, int2 minval, int2 maxval) __attribute__ ((pure, simd));
static inline uint2 __clamp_uint2 (uint2 x, uint2 minval, uint2 maxval) __attribute__ ((pure, simd));
static inline long2 __clamp_long2 (long2 x, long2 minval, long2 maxval) __attribute__ ((pure, simd));
static inline ulong2 __clamp_ulong2 (ulong2 x, ulong2 minval, ulong2 maxval) __attribute__ ((pure, simd));
static inline char2 __clamp_char_char2 (char2 x, char minval, char maxval) __attribute__ ((pure, simd));
static inline uchar2 __clamp_uchar_uchar2 (uchar2 x, uchar minval, uchar maxval) __attribute__ ((pure, simd));
static inline short2 __clamp_short_short2 (short2 x, short minval, short maxval) __attribute__ ((pure, simd));
static inline ushort2 __clamp_ushort_ushort2 (ushort2 x, ushort minval, ushort maxval) __attribute__ ((pure, simd));
static inline int2 __clamp_int_int2 (int2 x, int minval, int maxval) __attribute__ ((pure, simd));
static inline uint2 __clamp_uint_uint2 (uint2 x, uint minval, uint maxval) __attribute__ ((pure, simd));
static inline long2 __clamp_long_long2 (long2 x, long minval, long maxval) __attribute__ ((pure, simd));
static inline ulong2 __clamp_ulong_ulong2 (ulong2 x, ulong minval, ulong maxval) __attribute__ ((pure, simd));
static inline float3 __clamp_float3 (float3 x, float3 minval, float3 maxval)  __attribute__ ((pure, simd));
static inline float3 __clamp_float_float3 (float3 x, float minval, float maxval)  __attribute__ ((pure, simd));
static inline char3 __clamp_char3 (char3 x, char3 minval, char3 maxval) __attribute__ ((pure, simd));
static inline uchar3 __clamp_uchar3 (uchar3 x, uchar3 minval, uchar3 maxval) __attribute__ ((pure, simd));
static inline short3 __clamp_short3 (short3 x, short3 minval, short3 maxval) __attribute__ ((pure, simd));
static inline ushort3 __clamp_ushort3 (ushort3 x, ushort3 minval, ushort3 maxval) __attribute__ ((pure, simd));
static inline int3 __clamp_int3 (int3 x, int3 minval, int3 maxval) __attribute__ ((pure, simd));
static inline uint3 __clamp_uint3 (uint3 x, uint3 minval, uint3 maxval) __attribute__ ((pure, simd));
static inline long3 __clamp_long3 (long3 x, long3 minval, long3 maxval) __attribute__ ((pure, simd));
static inline ulong3 __clamp_ulong3 (ulong3 x, ulong3 minval, ulong3 maxval) __attribute__ ((pure, simd));
static inline char3 __clamp_char_char3 (char3 x, char minval, char maxval) __attribute__ ((pure, simd));
static inline uchar3 __clamp_uchar_uchar3 (uchar3 x, uchar minval, uchar maxval) __attribute__ ((pure, simd));
static inline short3 __clamp_short_short3 (short3 x, short minval, short maxval) __attribute__ ((pure, simd));
static inline ushort3 __clamp_ushort_ushort3 (ushort3 x, ushort minval, ushort maxval) __attribute__ ((pure, simd));
static inline int3 __clamp_int_int3 (int3 x, int minval, int maxval) __attribute__ ((pure, simd));
static inline uint3 __clamp_uint_uint3 (uint3 x, uint minval, uint maxval) __attribute__ ((pure, simd));
static inline long3 __clamp_long_long3 (long3 x, long minval, long maxval) __attribute__ ((pure, simd));
static inline ulong3 __clamp_ulong_ulong3 (ulong3 x, ulong minval, ulong maxval) __attribute__ ((pure, simd));
static inline float4 __clamp_float4 (float4 x, float4 minval, float4 maxval)  __attribute__ ((pure, simd));
static inline float4 __clamp_float_float4 (float4 x, float minval, float maxval)  __attribute__ ((pure, simd));
static inline char4 __clamp_char4 (char4 x, char4 minval, char4 maxval) __attribute__ ((pure, simd));
static inline uchar4 __clamp_uchar4 (uchar4 x, uchar4 minval, uchar4 maxval) __attribute__ ((pure, simd));
static inline short4 __clamp_short4 (short4 x, short4 minval, short4 maxval) __attribute__ ((pure, simd));
static inline ushort4 __clamp_ushort4 (ushort4 x, ushort4 minval, ushort4 maxval) __attribute__ ((pure, simd));
static inline int4 __clamp_int4 (int4 x, int4 minval, int4 maxval) __attribute__ ((pure, simd));
static inline uint4 __clamp_uint4 (uint4 x, uint4 minval, uint4 maxval) __attribute__ ((pure, simd));
static inline long4 __clamp_long4 (long4 x, long4 minval, long4 maxval) __attribute__ ((pure, simd));
static inline ulong4 __clamp_ulong4 (ulong4 x, ulong4 minval, ulong4 maxval) __attribute__ ((pure, simd));
static inline char4 __clamp_char_char4 (char4 x, char minval, char maxval) __attribute__ ((pure, simd));
static inline uchar4 __clamp_uchar_uchar4 (uchar4 x, uchar minval, uchar maxval) __attribute__ ((pure, simd));
static inline short4 __clamp_short_short4 (short4 x, short minval, short maxval) __attribute__ ((pure, simd));
static inline ushort4 __clamp_ushort_ushort4 (ushort4 x, ushort minval, ushort maxval) __attribute__ ((pure, simd));
static inline int4 __clamp_int_int4 (int4 x, int minval, int maxval) __attribute__ ((pure, simd));
static inline uint4 __clamp_uint_uint4 (uint4 x, uint minval, uint maxval) __attribute__ ((pure, simd));
static inline long4 __clamp_long_long4 (long4 x, long minval, long maxval) __attribute__ ((pure, simd));
static inline ulong4 __clamp_ulong_ulong4 (ulong4 x, ulong minval, ulong maxval) __attribute__ ((pure, simd));
static inline float8 __clamp_float8 (float8 x, float8 minval, float8 maxval)  __attribute__ ((pure, simd));
static inline float8 __clamp_float_float8 (float8 x, float minval, float maxval)  __attribute__ ((pure, simd));
static inline char8 __clamp_char8 (char8 x, char8 minval, char8 maxval) __attribute__ ((pure, simd));
static inline uchar8 __clamp_uchar8 (uchar8 x, uchar8 minval, uchar8 maxval) __attribute__ ((pure, simd));
static inline short8 __clamp_short8 (short8 x, short8 minval, short8 maxval) __attribute__ ((pure, simd));
static inline ushort8 __clamp_ushort8 (ushort8 x, ushort8 minval, ushort8 maxval) __attribute__ ((pure, simd));
static inline int8 __clamp_int8 (int8 x, int8 minval, int8 maxval) __attribute__ ((pure, simd));
static inline uint8 __clamp_uint8 (uint8 x, uint8 minval, uint8 maxval) __attribute__ ((pure, simd));
static inline long8 __clamp_long8 (long8 x, long8 minval, long8 maxval) __attribute__ ((pure, simd));
static inline ulong8 __clamp_ulong8 (ulong8 x, ulong8 minval, ulong8 maxval) __attribute__ ((pure, simd));
static inline char8 __clamp_char_char8 (char8 x, char minval, char maxval) __attribute__ ((pure, simd));
static inline uchar8 __clamp_uchar_uchar8 (uchar8 x, uchar minval, uchar maxval) __attribute__ ((pure, simd));
static inline short8 __clamp_short_short8 (short8 x, short minval, short maxval) __attribute__ ((pure, simd));
static inline ushort8 __clamp_ushort_ushort8 (ushort8 x, ushort minval, ushort maxval) __attribute__ ((pure, simd));
static inline int8 __clamp_int_int8 (int8 x, int minval, int maxval) __attribute__ ((pure, simd));
static inline uint8 __clamp_uint_uint8 (uint8 x, uint minval, uint maxval) __attribute__ ((pure, simd));
static inline long8 __clamp_long_long8 (long8 x, long minval, long maxval) __attribute__ ((pure, simd));
static inline ulong8 __clamp_ulong_ulong8 (ulong8 x, ulong minval, ulong maxval) __attribute__ ((pure, simd));
static inline float16 __clamp_float16 (float16 x, float16 minval, float16 maxval)  __attribute__ ((pure, simd));
static inline float16 __clamp_float_float16 (float16 x, float minval, float maxval)  __attribute__ ((pure, simd));
static inline char16 __clamp_char16 (char16 x, char16 minval, char16 maxval) __attribute__ ((pure, simd));
static inline uchar16 __clamp_uchar16 (uchar16 x, uchar16 minval, uchar16 maxval) __attribute__ ((pure, simd));
static inline short16 __clamp_short16 (short16 x, short16 minval, short16 maxval) __attribute__ ((pure, simd));
static inline ushort16 __clamp_ushort16 (ushort16 x, ushort16 minval, ushort16 maxval) __attribute__ ((pure, simd));
static inline int16 __clamp_int16 (int16 x, int16 minval, int16 maxval) __attribute__ ((pure, simd));
static inline uint16 __clamp_uint16 (uint16 x, uint16 minval, uint16 maxval) __attribute__ ((pure, simd));
static inline long16 __clamp_long16 (long16 x, long16 minval, long16 maxval) __attribute__ ((pure, simd));
static inline ulong16 __clamp_ulong16 (ulong16 x, ulong16 minval, ulong16 maxval) __attribute__ ((pure, simd));
static inline char16 __clamp_char_char16 (char16 x, char minval, char maxval) __attribute__ ((pure, simd));
static inline uchar16 __clamp_uchar_uchar16 (uchar16 x, uchar minval, uchar maxval) __attribute__ ((pure, simd));
static inline short16 __clamp_short_short16 (short16 x, short minval, short maxval) __attribute__ ((pure, simd));
static inline ushort16 __clamp_ushort_ushort16 (ushort16 x, ushort minval, ushort maxval) __attribute__ ((pure, simd));
static inline int16 __clamp_int_int16 (int16 x, int minval, int maxval) __attribute__ ((pure, simd));
static inline uint16 __clamp_uint_uint16 (uint16 x, uint minval, uint maxval) __attribute__ ((pure, simd));
static inline long16 __clamp_long_long16 (long16 x, long minval, long maxval) __attribute__ ((pure, simd));
static inline ulong16 __clamp_ulong_ulong16 (ulong16 x, ulong minval, ulong maxval) __attribute__ ((pure, simd));
static inline uchar __clamp_uchar(uchar x, uchar minval, uchar maxval) __attribute__ ((pure, simd));
static inline char __clamp_char(char x, char minval, char maxval) __attribute__ ((pure, simd));
static inline ushort __clamp_ushort(ushort x, ushort minval, ushort maxval) __attribute__ ((pure, simd));
static inline short __clamp_short(short x, short minval, short maxval) __attribute__ ((pure, simd));
static inline uint __clamp_uint(uint x, uint minval, uint maxval) __attribute__ ((pure, simd));
static inline int __clamp_int(int x, int minval, int maxval) __attribute__ ((pure, simd));
static inline ulong __clamp_ulong(ulong x, ulong minval, ulong maxval) __attribute__ ((pure, simd));
static inline long __clamp_long(long x, long minval, long maxval) __attribute__ ((pure, simd));
static inline float __clamp_float (float x, float minval, float maxval)  __attribute__ ((pure, simd));
static inline float4 __native_exp_float4(float4 x) __attribute__ ((pure, simd));
static inline float __native_exp_float(float x) __attribute__ ((pure, simd));
static inline float2 __native_exp_float2(float2 x) __attribute__ ((pure, simd));
static inline float3 __native_exp_float3(float3 x) __attribute__ ((pure, simd));
static inline float8 __native_exp_float8(float8 x) __attribute__ ((pure, simd));
static inline float16 __native_exp_float16(float16 x) __attribute__ ((pure, simd));
static inline float __exp_float(float x) __attribute__ ((pure, simd));
static inline float4 __exp_float4(float4 x) __attribute__ ((pure, simd));
static inline float2 __exp_float2(float2 x) __attribute__ ((pure, simd));
static inline float3 __exp_float3(float3 x) __attribute__ ((pure, simd));
static inline float8 __exp_float8(float8 x) __attribute__ ((pure, simd));
static inline float16 __exp_float16(float16 x) __attribute__ ((pure, simd));
static inline float4 __native_log_float4(float4 x) __attribute__ ((pure, simd));
static inline float __native_log_float(float x) __attribute__ ((pure, simd));
static inline float2 __native_log_float2(float2 x) __attribute__ ((pure, simd));
static inline float3 __native_log_float3(float3 x) __attribute__ ((pure, simd));
static inline float8 __native_log_float8(float8 x) __attribute__ ((pure, simd));
static inline float16 __native_log_float16(float16 x) __attribute__ ((pure, simd));
static inline float __log_float(float x) __attribute__ ((pure, simd));
static inline float4 __log_float4(float4 x) __attribute__ ((pure, simd));
static inline float2 __log_float2(float2 x) __attribute__ ((pure, simd));
static inline float3 __log_float3(float3 x) __attribute__ ((pure, simd));
static inline float8 __log_float8(float8 x) __attribute__ ((pure, simd));
static inline float16 __log_float16(float16 x) __attribute__ ((pure, simd));
static inline float2 __floor_float2(float2 x) __attribute__ ((pure, simd));
static inline float4 __floor_float4(float4 x) __attribute__ ((pure, simd));
static inline float8 __floor_float8(float8 x) __attribute__ ((pure, simd));
static inline float16 __floor_float16(float16 x) __attribute__ ((pure, simd));
static inline float __floor_float (float x) __attribute__ ((pure, simd));
static inline float3 __floor_float3(float3 x) __attribute__ ((pure, simd));
static inline float2 __fmin_float2(float2 x, float2 y) __attribute__ ((pure, simd));
static inline float2 __fmin_float_float2 (float2 x, float y)  __attribute__ ((pure, simd));
static inline float3 __fmin_float3(float3 x, float3 y) __attribute__ ((pure, simd));
static inline float3 __fmin_float_float3 (float3 x, float y)  __attribute__ ((pure, simd));
static inline float4 __fmin_float4(float4 x, float4 y) __attribute__ ((pure, simd));
static inline float4 __fmin_float_float4 (float4 x, float y)  __attribute__ ((pure, simd));
static inline float8 __fmin_float8(float8 x, float8 y) __attribute__ ((pure, simd));
static inline float8 __fmin_float_float8 (float8 x, float y)  __attribute__ ((pure, simd));
static inline float16 __fmin_float16(float16 x, float16 y) __attribute__ ((pure, simd));
static inline float16 __fmin_float_float16 (float16 x, float y)  __attribute__ ((pure, simd));
static inline float __fmin_float(float x, float y) __attribute__ ((pure, simd));
static inline float2 __fmax_float2(float2 x, float2 y) __attribute__ ((pure, simd));
static inline float2 __fmax_float_float2 (float2 x, float y)  __attribute__ ((pure, simd));
static inline float3 __fmax_float3(float3 x, float3 y) __attribute__ ((pure, simd));
static inline float3 __fmax_float_float3 (float3 x, float y)  __attribute__ ((pure, simd));
static inline float4 __fmax_float4(float4 x, float4 y) __attribute__ ((pure, simd));
static inline float4 __fmax_float_float4 (float4 x, float y)  __attribute__ ((pure, simd));
static inline float8 __fmax_float8(float8 x, float8 y) __attribute__ ((pure, simd));
static inline float8 __fmax_float_float8 (float8 x, float y)  __attribute__ ((pure, simd));
static inline float16 __fmax_float16(float16 x, float16 y) __attribute__ ((pure, simd));
static inline float16 __fmax_float_float16 (float16 x, float y)  __attribute__ ((pure, simd));
static inline float __fmax_float(float x, float y) __attribute__ ((pure, simd));
static inline float2 __maxmag_float2 (float2 x, float2 y)  __attribute__ ((pure, simd));
static inline float4 __maxmag_float4 (float4 x, float4 y)  __attribute__ ((pure, simd));
static inline float8 __maxmag_float8 (float8 x, float8 y)  __attribute__ ((pure, simd));
static inline float16 __maxmag_float16 (float16 x, float16 y)  __attribute__ ((pure, simd));
static inline float __maxmag_float (float x, float y)  __attribute__ ((pure, simd));
static inline float3 __maxmag_float3(float3 x, float3 y) __attribute__ ((pure, simd));
static inline float2 __minmag_float2 (float2 x, float2 y)  __attribute__ ((pure, simd));
static inline float4 __minmag_float4 (float4 x, float4 y)  __attribute__ ((pure, simd));
static inline float8 __minmag_float8 (float8 x, float8 y)  __attribute__ ((pure, simd));
static inline float16 __minmag_float16 (float16 x, float16 y)  __attribute__ ((pure, simd));
static inline float __minmag_float (float x, float y)  __attribute__ ((pure, simd));
static inline float3 __minmag_float3(float3 x, float3 y) __attribute__ ((pure, simd));
static inline float __range_reduce_pi_over_4_float(float in, int *poctant) __attribute__ ((pure, simd));
static inline float2 __range_reduce_pi_over_4_float2(float2 in, int2 *poctant) __attribute__ ((pure, simd));
static inline float3 __range_reduce_pi_over_4_float3(float3 in, int3 *poctant) __attribute__ ((pure, simd));
static inline float4 __range_reduce_pi_over_4_float4(float4 in, int4 *poctant) __attribute__ ((pure, simd));
static inline float8 __range_reduce_pi_over_4_float8(float8 in, int8 *poctant) __attribute__ ((pure, simd));
static inline float16 __range_reduce_pi_over_4_float16(float16 in, int16 *poctant) __attribute__ ((pure, simd));
static inline float __sqrt_approx_float(float x) __attribute__ ((pure, simd));
static inline float2 __sqrt_approx_float2(float2 x) __attribute__ ((pure, simd));
static inline float4 __sqrt_approx_float4(float4 x) __attribute__ ((pure, simd));
static inline float8 __sqrt_approx_float8(float8 x) __attribute__ ((pure, simd));
static inline float16 __sqrt_approx_float16(float16 x) __attribute__ ((pure, simd));
static inline float4 __sqrt_0_approx_float4(float4 x) __attribute__ ((pure, simd));
static inline float8 __sqrt_0_approx_float8(float8 x) __attribute__ ((pure, simd));
static inline float16 __sqrt_0_approx_float16(float16 x) __attribute__ ((pure, simd));
static inline float __sqrt_0_approx_float(float x) __attribute__ ((pure, simd));
static inline float2 __sqrt_0_approx_float2(float2 x) __attribute__ ((pure, simd));
static inline float4 __sqrt_float4 (float4 in) __attribute__ ((pure, simd));
static inline float4 __sqrt_float4 (float4 in) __attribute__ ((pure, simd));
static inline float3 __sqrt_float3(float3 x) __attribute__ ((pure, simd));
static inline float8 __sqrt_float8(float8 in) __attribute__ ((pure, simd));
static inline float16 __sqrt_float16(float16 in) __attribute__ ((pure, simd));
static inline float __sqrt_float (float in) __attribute__ ((pure, simd));
static inline float2 __sqrt_float2 (float2 in) __attribute__ ((pure, simd));
static inline float3 __native_sqrt_float3 (float3 x) __attribute__ ((pure, simd));
static inline float4 __native_sqrt_float4 (float4 x) __attribute__ ((pure, simd));
static inline float8 __native_sqrt_float8 (float8 x) __attribute__ ((pure, simd));
static inline float16 __native_sqrt_float16 (float16 x) __attribute__ ((pure, simd));
static inline float __native_sqrt_float (float x) __attribute__ ((pure, simd));
static inline float2 __native_sqrt_float2 (float2 x) __attribute__ ((pure, simd));
static inline float3 __rsqrt_float3 (float3 x) __attribute__ ((pure, simd));
static inline float4 __rsqrt_float4 (float4 x) __attribute__ ((pure, simd));
static inline float8 __rsqrt_float8 (float8 x) __attribute__ ((pure, simd));
static inline float16 __rsqrt_float16 (float16 x) __attribute__ ((pure, simd));
static inline float __rsqrt_float (float x) __attribute__ ((pure, simd));
static inline float2 __rsqrt_float2 (float2 x) __attribute__ ((pure, simd));
static inline float __native_rsqrt_float (float x) __attribute__ ((pure, simd));
static inline float3 __native_rsqrt_float3 (float3 x) __attribute__ ((pure, simd));
static inline float4 __native_rsqrt_float4 (float4 x) __attribute__ ((pure, simd));
static inline float8 __native_rsqrt_float8 (float8 x) __attribute__ ((pure, simd));
static inline float16 __native_rsqrt_float16 (float16 x) __attribute__ ((pure, simd));
static inline float2 __native_rsqrt_float2 (float2 x) __attribute__ ((pure, simd));
static inline float4 __recip_approx_float4(float4 x) __attribute__ ((pure, simd));
static inline float8 __recip_approx_float8(float8 x) __attribute__ ((pure, simd));
static inline float16 __recip_approx_float16(float16 x) __attribute__ ((pure, simd));
static inline float __recip_approx_float(float x) __attribute__ ((pure, simd));
static inline float2 __recip_approx_float2(float2 x) __attribute__ ((pure, simd));
static inline float __native_recip_float(float x) __attribute__ ((pure, simd));
static inline float4 __native_recip_float4(float4 x) __attribute__ ((pure, simd));
static inline float8 __native_recip_float8(float8 x) __attribute__ ((pure, simd));
static inline float16 __native_recip_float16(float16 x) __attribute__ ((pure, simd));
static inline float2 __native_recip_float2 (float2 x) __attribute__ ((pure, simd));
static inline float3 __native_recip_float3(float3 x) __attribute__ ((pure, simd));
static inline void wait_group_events (int num_events __attribute__((unused)), event_t *event_list __attribute__((unused)))  __attribute__ ((pure, simd));
static inline event_t __async_work_group_copy_get_char (__local char *dst, const __global char *src, size_t num_elements, event_t event)  __attribute__ ((pure, simd));
static inline event_t __async_work_group_copy_get_short (__local short *dst, const __global short *src, size_t num_elements, event_t event)  __attribute__ ((pure, simd));
static inline event_t __async_work_group_copy_get_int (__local int *dst, const __global int *src, size_t num_elements, event_t event)  __attribute__ ((pure, simd));
static inline event_t __async_work_group_copy_get_long (__local long *dst, const __global long *src, size_t num_elements, event_t event)  __attribute__ ((pure, simd));
static inline event_t __async_work_group_copy_get_long2 (__local long2 *dst, const __global long2 *src, size_t num_elements, event_t event)  __attribute__ ((pure, simd));
static inline event_t __async_work_group_copy_get_long4 (__local long4 *dst, const __global long4 *src, size_t num_elements, event_t event)  __attribute__ ((pure, simd));
static inline event_t __async_work_group_copy_get_long8 (__local long8 *dst, const __global long8 *src, size_t num_elements, event_t event)  __attribute__ ((pure, simd));
static inline event_t __async_work_group_copy_get_long16 (__local long16 *dst, const __global long16 *src, size_t num_elements, event_t event)  __attribute__ ((pure, simd));
static inline event_t __async_work_group_copy_put_char (__global char *dst, const __local char *src, size_t num_elements, event_t event)  __attribute__ ((pure, simd));
static inline event_t __async_work_group_copy_put_short (__global short *dst, const __local short *src, size_t num_elements, event_t event)  __attribute__ ((pure, simd));
static inline event_t __async_work_group_copy_put_int (__global int *dst, const __local int *src, size_t num_elements, event_t event)  __attribute__ ((pure, simd));
static inline event_t __async_work_group_copy_put_long (__global long *dst, const __local long *src, size_t num_elements, event_t event)  __attribute__ ((pure, simd));
static inline event_t __async_work_group_copy_put_long2 (__global long2 *dst, const __local long2 *src, size_t num_elements, event_t event)  __attribute__ ((pure, simd));
static inline event_t __async_work_group_copy_put_long4 (__global long4 *dst, const __local long4 *src, size_t num_elements, event_t event)  __attribute__ ((pure, simd));
static inline event_t __async_work_group_copy_put_long8 (__global long8 *dst, const __local long8 *src, size_t num_elements, event_t event)  __attribute__ ((pure, simd));
static inline event_t __async_work_group_copy_put_long16 (__global long16 *dst, const __local long16 *src, size_t num_elements, event_t event)  __attribute__ ((pure, simd));
static inline void __prefetch_char (const __global char *p, size_t num_elements)  __attribute__ ((pure, simd));
static inline void __prefetch_short (const __global short *p, size_t num_elements)  __attribute__ ((pure, simd));
static inline void __prefetch_int (const __global int *p, size_t num_elements)  __attribute__ ((pure, simd));
static inline void __prefetch_long (const __global long *p, size_t num_elements)  __attribute__ ((pure, simd));
static inline void __prefetch_long2 (const __global long2 *p, size_t num_elements)  __attribute__ ((pure, simd));
static inline void __prefetch_long4 (const __global long4 *p, size_t num_elements)  __attribute__ ((pure, simd));
static inline void __prefetch_long8 (const __global long8 *p, size_t num_elements)  __attribute__ ((pure, simd));
static inline void __prefetch_long16 (const __global long16 *p, size_t num_elements)  __attribute__ ((pure, simd));
static inline event_t __async_work_group_strided_copy_get_char (__local char *dst, const __global char *src, size_t num_elements, size_t stride, event_t event)  __attribute__ ((pure, simd));
static inline event_t __async_work_group_strided_copy_get_short (__local short *dst, const __global short *src, size_t num_elements, size_t stride, event_t event)  __attribute__ ((pure, simd));
static inline event_t __async_work_group_strided_copy_get_int (__local int *dst, const __global int *src, size_t num_elements, size_t stride, event_t event)  __attribute__ ((pure, simd));
static inline event_t __async_work_group_strided_copy_get_long (__local long *dst, const __global long *src, size_t num_elements, size_t stride, event_t event)  __attribute__ ((pure, simd));
static inline event_t __async_work_group_strided_copy_get_long2 (__local long2 *dst, const __global long2 *src, size_t num_elements, size_t stride, event_t event)  __attribute__ ((pure, simd));
static inline event_t __async_work_group_strided_copy_get_long4 (__local long4 *dst, const __global long4 *src, size_t num_elements, size_t stride, event_t event)  __attribute__ ((pure, simd));
static inline event_t __async_work_group_strided_copy_get_long8 (__local long8 *dst, const __global long8 *src, size_t num_elements, size_t stride, event_t event)  __attribute__ ((pure, simd));
static inline event_t __async_work_group_strided_copy_get_long16 (__local long16 *dst, const __global long16 *src, size_t num_elements, size_t stride, event_t event)  __attribute__ ((pure, simd));
static inline event_t __async_work_group_strided_copy_put_char (__global char *dst, const __local char *src, size_t num_elements, size_t stride, event_t event)  __attribute__ ((pure, simd));
static inline event_t __async_work_group_strided_copy_put_short (__global short *dst, const __local short *src, size_t num_elements, size_t stride, event_t event)  __attribute__ ((pure, simd));
static inline event_t __async_work_group_strided_copy_put_int (__global int *dst, const __local int *src, size_t num_elements, size_t stride, event_t event)  __attribute__ ((pure, simd));
static inline event_t __async_work_group_strided_copy_put_long (__global long *dst, const __local long *src, size_t num_elements, size_t stride, event_t event)  __attribute__ ((pure, simd));
static inline event_t __async_work_group_strided_copy_put_long2 (__global long2 *dst, const __local long2 *src, size_t num_elements, size_t stride, event_t event)  __attribute__ ((pure, simd));
static inline event_t __async_work_group_strided_copy_put_long4 (__global long4 *dst, const __local long4 *src, size_t num_elements, size_t stride, event_t event)  __attribute__ ((pure, simd));
static inline event_t __async_work_group_strided_copy_put_long8 (__global long8 *dst, const __local long8 *src, size_t num_elements, size_t stride, event_t event)  __attribute__ ((pure, simd));
static inline event_t __async_work_group_strided_copy_put_long16 (__global long16 *dst, const __local long16 *src, size_t num_elements, size_t stride, event_t event)  __attribute__ ((pure, simd));
static inline int __atom_add_int(volatile __global int *p, int val) __attribute__ ((pure, simd));
static inline long __atom_add_long(volatile __global long *p, long val) __attribute__ ((pure, simd));
static inline long __atom_add_long_local(volatile __local long *p, long val) __attribute__ ((pure, simd));
static inline int __atom_add_int_local(volatile __local int *p, int val) __attribute__ ((pure, simd));
static inline int __atom_and_int(volatile __global int *p, int val) __attribute__ ((pure, simd));
static inline long __atom_and_long(volatile __global long *p, long val) __attribute__ ((pure, simd));
static inline long __atom_and_long_local(volatile __local long *p, long val) __attribute__ ((pure, simd));
static inline int __atom_and_int_local(volatile __local int *p, int val) __attribute__ ((pure, simd));
static inline int __atom_cmpxchg_int(volatile __global int *p, int cmp, int val) __attribute__ ((pure, simd));
static inline long __atom_cmpxchg_long(volatile __global long *p, long cmp, long val) __attribute__ ((pure, simd));
static inline long __atom_cmpxchg_long_local(volatile __local long *p, long cmp, long val) __attribute__ ((pure, simd));
static inline int __atom_cmpxchg_int_local(volatile __local int *p, int cmp, int val) __attribute__ ((pure, simd));
static inline int __atom_dec_int(volatile __global int *p) __attribute__ ((pure, simd));
static inline long __atom_dec_long(volatile __global long *p) __attribute__ ((pure, simd));
static inline long __atom_dec_long_local(volatile __local long *p) __attribute__ ((pure, simd));
static inline int __atom_dec_int_local(volatile __local int *p) __attribute__ ((pure, simd));
static inline int __atom_inc_int(volatile __global int *p) __attribute__ ((pure, simd));
static inline long __atom_inc_long(volatile __global long *p) __attribute__ ((pure, simd));
static inline long __atom_inc_long_local(volatile __local long *p) __attribute__ ((pure, simd));
static inline int __atom_inc_int_local(volatile __local int *p) __attribute__ ((pure, simd));
static inline int __atom_max_int(volatile __global int *p, int val) __attribute__ ((pure, simd));
static inline uint __atom_max_uint(volatile __global uint *p, uint val) __attribute__ ((pure, simd));
static inline long __atom_max_long(volatile __global long *p, long val) __attribute__ ((pure, simd));
static inline ulong __atom_max_ulong(volatile __global ulong *p, ulong val) __attribute__ ((pure, simd));
static inline long __atom_max_long_local(volatile __local long *p, long val) __attribute__ ((pure, simd));
static inline ulong __atom_max_ulong_local(volatile __local ulong *p, ulong val) __attribute__ ((pure, simd));
static inline int __atom_max_int_local(volatile __local int *p, int val) __attribute__ ((pure, simd));
static inline uint __atom_max_uint_local(volatile __local uint *p, uint val) __attribute__ ((pure, simd));
static inline int __atom_min_int(volatile __global int *p, int val) __attribute__ ((pure, simd));
static inline uint __atom_min_uint(volatile __global uint *p, uint val) __attribute__ ((pure, simd));
static inline long __atom_min_long(volatile __global long *p, long val) __attribute__ ((pure, simd));
static inline ulong __atom_min_ulong(volatile __global ulong *p, ulong val) __attribute__ ((pure, simd));
static inline long __atom_min_long_local(volatile __local long *p, long val) __attribute__ ((pure, simd));
static inline ulong __atom_min_ulong_local(volatile __local ulong *p, ulong val) __attribute__ ((pure, simd));
static inline int __atom_min_int_local(volatile __local int *p, int val) __attribute__ ((pure, simd));
static inline uint __atom_min_uint_local(volatile __local uint *p, uint val) __attribute__ ((pure, simd));
static inline int __atom_or_int(volatile __global int *p, int val) __attribute__ ((pure, simd));
static inline long __atom_or_long(volatile __global long *p, long val) __attribute__ ((pure, simd));
static inline long __atom_or_long_local(volatile __local long *p, long val) __attribute__ ((pure, simd));
static inline int __atom_or_int_local(volatile __local int *p, int val) __attribute__ ((pure, simd));
static inline int __atom_sub_int(volatile __global int *p, int val) __attribute__ ((pure, simd));
static inline long __atom_sub_long(volatile __global long *p, long val) __attribute__ ((pure, simd));
static inline long __atom_sub_long_local(volatile __local long *p, long val) __attribute__ ((pure, simd));
static inline int __atom_sub_int_local(volatile __local int *p, int val) __attribute__ ((pure, simd));
static inline int __atom_xchg_int(volatile __global int *p, int val) __attribute__ ((pure, simd));
static inline float __atom_xchg_float(volatile __global float *p, float val) __attribute__ ((pure, simd));
static inline long __atom_xchg_long(volatile __global long *p, long val) __attribute__ ((pure, simd));
static inline long __atom_xchg_long_local(volatile __local long *p, long val) __attribute__ ((pure, simd));
static inline int __atom_xchg_int_local(volatile __local int *p, int val) __attribute__ ((pure, simd));
static inline float __atom_xchg_float_local(volatile __local float *p, float val) __attribute__ ((pure, simd));
static inline int __atom_xor_int(volatile __global int *p, int val) __attribute__ ((pure, simd));
static inline long __atom_xor_long(volatile __global long *p, long val) __attribute__ ((pure, simd));
static inline long __atom_xor_long_local(volatile __local long *p, long val) __attribute__ ((pure, simd));
static inline int __atom_xor_int_local(volatile __local int *p, int val) __attribute__ ((pure, simd));
static inline void __cl_calc_group_id_1D(const unsigned int count) __attribute__ ((pure, simd));
static inline void __cl_calc_group_id_2D(const unsigned int count) __attribute__ ((pure, simd));
static inline void __cl_calc_group_id_3D(const unsigned int count) __attribute__ ((pure, simd));
static inline void __cl_increment_group_id_1D() __attribute__ ((pure, simd));
static inline void __cl_increment_group_id_2D() __attribute__ ((pure, simd));
static inline void __cl_increment_group_id_3D() __attribute__ ((pure, simd));
static inline uint get_work_dim() __attribute__ ((pure, simd));
static inline size_t get_global_offset(uint dimindx) __attribute__ ((pure, simd));
static inline size_t get_global_size(uint dimindx) __attribute__ ((pure, simd));
static inline size_t get_global_id(uint dimindx) __attribute__ ((pure, simd));
static inline size_t get_local_size(uint dimindx) __attribute__ ((pure, simd));
static inline size_t get_local_id(uint dimindx __attribute__ ((unused))) __attribute__ ((pure, simd));
static inline size_t get_num_groups(uint dimindx) __attribute__ ((pure, simd));
static inline size_t get_group_id(uint dimindx) __attribute__ ((pure, simd));
static inline uint get_unit_id() __attribute__ ((pure, simd));
#ifdef _ARCH_PWR7
static inline long2 __isinf_long2 (double2 x) __attribute__ ((pure, simd));
static inline long3 __isinf_long3 (double3 x) __attribute__ ((pure, simd));
static inline long4 __isinf_long4 (double4 x) __attribute__ ((pure, simd));
static inline long8 __isinf_long8 (double8 x) __attribute__ ((pure, simd));
static inline long16 __isinf_long16 (double16 x) __attribute__ ((pure, simd));
static inline int __isinf_long (double x) __attribute__ ((pure, simd));
static inline long2 __signbit_long2 (double2 x) __attribute__ ((pure, simd));
static inline long4 __signbit_long4(double4 x) __attribute__ ((pure, simd));
static inline long3 __signbit_long3(double3 x) __attribute__ ((pure, simd));
static inline long8 __signbit_long8(double8 x) __attribute__ ((pure, simd));
static inline long16 __signbit_long16(double16 x) __attribute__ ((pure, simd));
static inline int __signbit_long (double x) __attribute__ ((pure, simd));
static inline long2 __isnan_long2 (double2 x) __attribute__ ((pure, simd));
static inline long3 __isnan_long3 (double3 x) __attribute__ ((pure, simd));
static inline long4 __isnan_long4 (double4 x) __attribute__ ((pure, simd));
static inline long8 __isnan_long8 (double8 x) __attribute__ ((pure, simd));
static inline long16 __isnan_long16 (double16 x) __attribute__ ((pure, simd));
static inline int __isnan_long(double x) __attribute__ ((pure, simd));
static inline long2 __isfinite_long2 (double2 x) __attribute__ ((pure, simd));
static inline long3 __isfinite_long3 (double3 x) __attribute__ ((pure, simd));
static inline long4 __isfinite_long4 (double4 x) __attribute__ ((pure, simd));
static inline long8 __isfinite_long8 (double8 x) __attribute__ ((pure, simd));
static inline long16 __isfinite_long16 (double16 x) __attribute__ ((pure, simd));
static inline int __isfinite_long(double x) __attribute__ ((pure, simd));
static inline long2 __isnormal_long2 (double2 x) __attribute__ ((pure, simd));
static inline long3 __isnormal_long3 (double3 x) __attribute__ ((pure, simd));
static inline long4 __isnormal_long4 (double4 x) __attribute__ ((pure, simd));
static inline long8 __isnormal_long8 (double8 x) __attribute__ ((pure, simd));
static inline long16 __isnormal_long16 (double16 x) __attribute__ ((pure, simd));
static inline int __isnormal_long (double x) __attribute__ ((pure, simd));
static inline long2 __isequal_long2 (double2 x, double2 y) __attribute__ ((pure, simd));
static inline long3 __isequal_long3 (double3 x, double3 y) __attribute__ ((pure, simd));
static inline long4 __isequal_long4 (double4 x, double4 y) __attribute__ ((pure, simd));
static inline long8 __isequal_long8 (double8 x, double8 y) __attribute__ ((pure, simd));
static inline long16 __isequal_long16 (double16 x, double16 y) __attribute__ ((pure, simd));
static inline int __isequal_long (double x, double y) __attribute__ ((pure, simd));
static inline long2 __isnotequal_long2 (double2 x, double2 y) __attribute__ ((pure, simd));
static inline long3 __isnotequal_long3 (double3 x, double3 y) __attribute__ ((pure, simd));
static inline long4 __isnotequal_long4 (double4 x, double4 y) __attribute__ ((pure, simd));
static inline long8 __isnotequal_long8 (double8 x, double8 y) __attribute__ ((pure, simd));
static inline long16 __isnotequal_long16 (double16 x, double16 y) __attribute__ ((pure, simd));
static inline int __isnotequal_long (double x, double y) __attribute__ ((pure, simd));
static inline long2 __isgreater_long2 (double2 x, double2 y) __attribute__ ((pure, simd));
static inline long3 __isgreater_long3 (double3 x, double3 y) __attribute__ ((pure, simd));
static inline long4 __isgreater_long4 (double4 x, double4 y) __attribute__ ((pure, simd));
static inline long8 __isgreater_long8 (double8 x, double8 y) __attribute__ ((pure, simd));
static inline long16 __isgreater_long16 (double16 x, double16 y) __attribute__ ((pure, simd));
static inline int __isgreater_long (double x, double y) __attribute__ ((pure, simd));
static inline long2 __isgreaterequal_long2 (double2 x, double2 y) __attribute__ ((pure, simd));
static inline long3 __isgreaterequal_long3 (double3 x, double3 y) __attribute__ ((pure, simd));
static inline long4 __isgreaterequal_long4 (double4 x, double4 y) __attribute__ ((pure, simd));
static inline long8 __isgreaterequal_long8 (double8 x, double8 y) __attribute__ ((pure, simd));
static inline long16 __isgreaterequal_long16 (double16 x, double16 y) __attribute__ ((pure, simd));
static inline int __isgreaterequal_long (double x, double y) __attribute__ ((pure, simd));
static inline long2 __isless_long2 (double2 x, double2 y) __attribute__ ((pure, simd));
static inline long3 __isless_long3 (double3 x, double3 y) __attribute__ ((pure, simd));
static inline long4 __isless_long4 (double4 x, double4 y) __attribute__ ((pure, simd));
static inline long8 __isless_long8 (double8 x, double8 y) __attribute__ ((pure, simd));
static inline long16 __isless_long16 (double16 x, double16 y) __attribute__ ((pure, simd));
static inline int __isless_long (double x, double y) __attribute__ ((pure, simd));
static inline long2 __islessequal_long2 (double2 x, double2 y) __attribute__ ((pure, simd));
static inline long3 __islessequal_long3 (double3 x, double3 y) __attribute__ ((pure, simd));
static inline long4 __islessequal_long4 (double4 x, double4 y) __attribute__ ((pure, simd));
static inline long8 __islessequal_long8 (double8 x, double8 y) __attribute__ ((pure, simd));
static inline long16 __islessequal_long16 (double16 x, double16 y) __attribute__ ((pure, simd));
static inline int __islessequal_long (double x, double y) __attribute__ ((pure, simd));
static inline long2 __islessgreater_long2 (double2 x, double2 y) __attribute__ ((pure, simd));
static inline long3 __islessgreater_long3 (double3 x, double3 y) __attribute__ ((pure, simd));
static inline long4 __islessgreater_long4 (double4 x, double4 y) __attribute__ ((pure, simd));
static inline long8 __islessgreater_long8 (double8 x, double8 y) __attribute__ ((pure, simd));
static inline long16 __islessgreater_long16 (double16 x, double16 y) __attribute__ ((pure, simd));
static inline int __islessgreater_long (double x, double y) __attribute__ ((pure, simd));
static inline long2 __isordered_long2 (double2 x, double2 y) __attribute__ ((pure, simd));
static inline long3 __isordered_long3 (double3 x, double3 y) __attribute__ ((pure, simd));
static inline long4 __isordered_long4 (double4 x, double4 y) __attribute__ ((pure, simd));
static inline long8 __isordered_long8 (double8 x, double8 y) __attribute__ ((pure, simd));
static inline long16 __isordered_long16 (double16 x, double16 y) __attribute__ ((pure, simd));
static inline int __isordered_long (double x, double y) __attribute__ ((pure, simd));
static inline long2 __isunordered_long2 (double2 x, double2 y) __attribute__ ((pure, simd));
static inline long3 __isunordered_long3 (double3 x, double3 y) __attribute__ ((pure, simd));
static inline long4 __isunordered_long4 (double4 x, double4 y) __attribute__ ((pure, simd));
static inline long8 __isunordered_long8 (double8 x, double8 y) __attribute__ ((pure, simd));
static inline long16 __isunordered_long16 (double16 x, double16 y) __attribute__ ((pure, simd));
static inline int __isunordered_long (double x, double y) __attribute__ ((pure, simd));
static inline double2 __pow_double2(double2 x, double2 y) __attribute__ ((pure, simd));
static inline double __pow_double(double x, double y) __attribute__ ((pure, simd));
static inline double4 __pow_double4(double4 x, double4 y) __attribute__ ((pure, simd));
static inline double3 __pow_double3(double3 x, double3 y) __attribute__ ((pure, simd));
static inline double8 __pow_double8(double8 x, double8 y) __attribute__ ((pure, simd));
static inline double16 __pow_double16(double16 x, double16 y) __attribute__ ((pure, simd));
static inline double2 __powr_double2(double2 x, double2 y) __attribute__ ((pure, simd));
static inline double __powr_double(double x, double y) __attribute__ ((pure, simd));
static inline double4 __powr_double4(double4 x, double4 y) __attribute__ ((pure, simd));
static inline double3 __powr_double3(double3 x, double3 y) __attribute__ ((pure, simd));
static inline double8 __powr_double8(double8 x, double8 y) __attribute__ ((pure, simd));
static inline double16 __powr_double16(double16 x, double16 y) __attribute__ ((pure, simd));
static inline double2 __erf_double2(double2 x) __attribute__ ((pure, simd));
static inline double __erf_double(double x) __attribute__ ((pure, simd));
static inline double4 __erf_double4(double4 in) __attribute__ ((pure, simd));
static inline double8 __erf_double8(double8 in) __attribute__ ((pure, simd));
static inline double16 __erf_double16(double16 in) __attribute__ ((pure, simd));
static inline double3 __erf_double3(double3 x) __attribute__ ((pure, simd));
static inline double4 __expm1_double4(double4 in) __attribute__ ((pure, simd));
static inline double8 __expm1_double8(double8 in) __attribute__ ((pure, simd));
static inline double16 __expm1_double16(double16 in) __attribute__ ((pure, simd));
static inline double3 __expm1_double3(double3 x) __attribute__ ((pure, simd));
static inline double __exp2_double(double in) __attribute__ ((pure, simd));
static inline double2 __exp2_double2(double2 in) __attribute__ ((pure, simd));
static inline double4 __exp2_double4(double4 in) __attribute__ ((pure, simd));
static inline double8 __exp2_double8(double8 in) __attribute__ ((pure, simd));
static inline double16 __exp2_double16(double16 in) __attribute__ ((pure, simd));
static inline double3 __exp2_double3(double3 x) __attribute__ ((pure, simd));
static inline double __exp10_double(double in) __attribute__ ((pure, simd));
static inline double2 __exp10_double2(double2 in) __attribute__ ((pure, simd));
static inline double4 __exp10_double4(double4 in) __attribute__ ((pure, simd));
static inline double8 __exp10_double8(double8 in) __attribute__ ((pure, simd));
static inline double16 __exp10_double16(double16 in) __attribute__ ((pure, simd));
static inline double3 __exp10_double3(double3 x) __attribute__ ((pure, simd));
static inline double2 __log2_double2(double2 x) __attribute__ ((pure, simd));
static inline double __log2_double(double x) __attribute__ ((pure, simd));
static inline double4 __log2_double4(double4 in) __attribute__ ((pure, simd));
static inline double3 __log2_double3(double3 x) __attribute__ ((pure, simd));
static inline double8 __log2_double8(double8 in) __attribute__ ((pure, simd));
static inline double16 __log2_double16(double16 in) __attribute__ ((pure, simd));
static inline double2 __log10_double2(double2 x) __attribute__ ((pure, simd));
static inline double __log10_double(double x) __attribute__ ((pure, simd));
static inline double4 __log10_double4(double4 in) __attribute__ ((pure, simd));
static inline double3 __log10_double3(double3 x) __attribute__ ((pure, simd));
static inline double8 __log10_double8(double8 in) __attribute__ ((pure, simd));
static inline double16 __log10_double16(double16 in) __attribute__ ((pure, simd));
static inline double2 __log1p_double2(double2 x) __attribute__ ((pure, simd));
static inline double __log1p_double(double x) __attribute__ ((pure, simd));
static inline double4 __log1p_double4(double4 in) __attribute__ ((pure, simd));
static inline double3 __log1p_double3(double3 x) __attribute__ ((pure, simd));
static inline double8 __log1p_double8(double8 in) __attribute__ ((pure, simd));
static inline double16 __log1p_double16(double16 in) __attribute__ ((pure, simd));
static inline double2 __pown_double2(double2 x, int2 y) __attribute__ ((pure, simd));
static inline double __pown_double(double x, int y) __attribute__ ((pure, simd));
static inline double4 __pown_double4(double4 x, int4 y) __attribute__ ((pure, simd));
static inline double3 __pown_double3(double3 x, int3 y) __attribute__ ((pure, simd));
static inline double8 __pown_double8(double8 x, int8 y) __attribute__ ((pure, simd));
static inline double16 __pown_double16(double16 x, int16 y) __attribute__ ((pure, simd));
static inline double2 __rootn_double2(double2 x, int2 y) __attribute__ ((pure, simd));
static inline double __rootn_double(double x, int y) __attribute__ ((pure, simd));
static inline double4 __rootn_double4(double4 x, int4 y) __attribute__ ((pure, simd));
static inline double3 __rootn_double3(double3 x, int3 y) __attribute__ ((pure, simd));
static inline double8 __rootn_double8(double8 x, int8 y) __attribute__ ((pure, simd));
static inline double16 __rootn_double16(double16 x, int16 y) __attribute__ ((pure, simd));
static inline double2 __acosh_double2(double2 x) __attribute__ ((pure, simd));
static inline double4 __acosh_double4(double4 in) __attribute__ ((pure, simd));
static inline double8 __acosh_double8(double8 in) __attribute__ ((pure, simd));
static inline double16 __acosh_double16(double16 in) __attribute__ ((pure, simd));
static inline double3 __acosh_double3(double3 in) __attribute__ ((pure, simd));
static inline double __acosh_double(double x) __attribute__ ((pure, simd));
static inline double2 __asinh_double2(double2 x) __attribute__ ((pure, simd));
static inline double4 __asinh_double4(double4 in) __attribute__ ((pure, simd));
static inline double3 __asinh_double3(double3 in) __attribute__ ((pure, simd));
static inline double8 __asinh_double8(double8 in) __attribute__ ((pure, simd));
static inline double16 __asinh_double16(double16 in) __attribute__ ((pure, simd));
static inline double __asinh_double(double x) __attribute__ ((pure, simd));
static inline double2 __atanh_double2(double2 x) __attribute__ ((pure, simd));
static inline double4 __atanh_double4(double4 in) __attribute__ ((pure, simd));
static inline double8 __atanh_double8(double8 in) __attribute__ ((pure, simd));
static inline double16 __atanh_double16(double16 in) __attribute__ ((pure, simd));
static inline double3 __atanh_double3(double3 x) __attribute__ ((pure, simd));
static inline double __atanh_double(double x) __attribute__ ((pure, simd));
static inline double __lgamma_double(double x) __attribute__ ((pure, simd));
static inline double2 __lgamma_double2(double2 x) __attribute__ ((pure, simd));
static inline double3 __lgamma_double3(double3 in) __attribute__ ((pure, simd));
static inline double4 __lgamma_double4(double4 in) __attribute__ ((pure, simd));
static inline double8 __lgamma_double8(double8 in) __attribute__ ((pure, simd));
static inline double16 __lgamma_double16(double16 in) __attribute__ ((pure, simd));
static inline double __lgamma_r_double(double x, int *signp) __attribute__ ((pure, simd));
static inline double2 __lgamma_r_double2(double2 x, int2 *signp) __attribute__ ((pure, simd));
static inline double3 __lgamma_r_double3(double3 in, int3 *signp) __attribute__ ((pure, simd));
static inline double4 __lgamma_r_double4(double4 in, int4 *signp) __attribute__ ((pure, simd));
static inline double8 __lgamma_r_double8(double8 in, int8 *signp) __attribute__ ((pure, simd));
static inline double16 __lgamma_r_double16(double16 in, int16 *signp) __attribute__ ((pure, simd));
static inline double __lgamma_r_double_global(double x, __global int *signp) __attribute__ ((pure, simd));
static inline double2 __lgamma_r_double2_global(double2 x, __global int2 *signp) __attribute__ ((pure, simd));
static inline double3 __lgamma_r_double3_global(double3 in, __global int3 *signp) __attribute__ ((pure, simd));
static inline double4 __lgamma_r_double4_global(double4 in, __global int4 *signp) __attribute__ ((pure, simd));
static inline double8 __lgamma_r_double8_global(double8 in, __global int8 *signp) __attribute__ ((pure, simd));
static inline double16 __lgamma_r_double16_global(double16 in, __global int16 *signp) __attribute__ ((pure, simd));
static inline double2 __cos_double2(double2 in) __attribute__ ((pure, simd));
static inline double3 __cos_double3(double3 in) __attribute__ ((pure, simd));
static inline double4 __cos_double4(double4 in) __attribute__ ((pure, simd));
static inline double8 __cos_double8(double8 in) __attribute__ ((pure, simd));
static inline double16 __cos_double16(double16 in) __attribute__ ((pure, simd));
static inline double __cos_double(double in) __attribute__ ((pure, simd));
static inline double2 __cospi_double2(double2 in) __attribute__ ((pure, simd));
static inline double4 __cospi_double4(double4 in) __attribute__ ((pure, simd));
static inline double8 __cospi_double8(double8 in) __attribute__ ((pure, simd));
static inline double16 __cospi_double16(double16 in) __attribute__ ((pure, simd));
static inline double __cospi_double(double in) __attribute__ ((pure, simd));
static inline double3 __cospi_double3(double3 in) __attribute__ ((pure, simd));
static inline double2 __sin_double2(double2 in) __attribute__ ((pure, simd));
static inline double3 __sin_double3(double3 in) __attribute__ ((pure, simd));
static inline double4 __sin_double4(double4 in) __attribute__ ((pure, simd));
static inline double8 __sin_double8(double8 in) __attribute__ ((pure, simd));
static inline double16 __sin_double16(double16 in) __attribute__ ((pure, simd));
static inline double __sin_double(double in) __attribute__ ((pure, simd));
static inline double2 __sinpi_double2(double2 in) __attribute__ ((pure, simd));
static inline double4 __sinpi_double4(double4 in) __attribute__ ((pure, simd));
static inline double8 __sinpi_double8(double8 in) __attribute__ ((pure, simd));
static inline double16 __sinpi_double16(double16 in) __attribute__ ((pure, simd));
static inline double __sinpi_double(double in) __attribute__ ((pure, simd));
static inline double3 __sinpi_double3(double3 x) __attribute__ ((pure, simd));
static inline double2 __sincos_double2(double2 in, double2 *cosval) __attribute__ ((pure, simd));
static inline double3 __sincos_double3(double3 in, double3 *cosval) __attribute__ ((pure, simd));
static inline double4 __sincos_double4(double4 in, double4 *cosval) __attribute__ ((pure, simd));
static inline double8 __sincos_double8(double8 in, double8 *cosval) __attribute__ ((pure, simd));
static inline double16 __sincos_double16(double16 in, double16 *cosval) __attribute__ ((pure, simd));
static inline double2 __sincos_double2_global(double2 in, __global double2 *cosval) __attribute__ ((pure, simd));
static inline double3 __sincos_double3_global(double3 in, __global double3 *cosval) __attribute__ ((pure, simd));
static inline double4 __sincos_double4_global(double4 in, __global double4 *cosval) __attribute__ ((pure, simd));
static inline double8 __sincos_double8_global(double8 in, __global double8 *cosval) __attribute__ ((pure, simd));
static inline double16 __sincos_double16_global(double16 in, __global double16 *cosval) __attribute__ ((pure, simd));
static inline double __sincos_double(double in, double *cosval) __attribute__ ((pure, simd));
static inline double __sincos_double_global(double in, __global double *cosval) __attribute__ ((pure, simd));
static inline double __degrees_double (double radians)  __attribute__ ((pure, simd));
static inline double2 __degrees_double2 (double2 radians)  __attribute__ ((pure, simd));
static inline double3 __degrees_double3 (double3 radians)  __attribute__ ((pure, simd));
static inline double4 __degrees_double4 (double4 radians)  __attribute__ ((pure, simd));
static inline double8 __degrees_double8 (double8 radians)  __attribute__ ((pure, simd));
static inline double16 __degrees_double16 (double16 radians)  __attribute__ ((pure, simd));
static inline double __radians_double (double degrees)  __attribute__ ((pure, simd));
static inline double2 __radians_double2 (double2 degrees)  __attribute__ ((pure, simd));
static inline double3 __radians_double3 (double3 degrees)  __attribute__ ((pure, simd));
static inline double4 __radians_double4 (double4 degrees)  __attribute__ ((pure, simd));
static inline double8 __radians_double8 (double8 degrees)  __attribute__ ((pure, simd));
static inline double16 __radians_double16 (double16 degrees)  __attribute__ ((pure, simd));
static inline double __mix_double_double (double x, double y, double a)  __attribute__ ((pure, simd));
static inline double __mix_double (double x, double y, double a)  __attribute__ ((pure, simd));
static inline double2 __mix_double_double2 (double2 x, double2 y, double a)  __attribute__ ((pure, simd));
static inline double2 __mix_double2 (double2 x, double2 y, double2 a)  __attribute__ ((pure, simd));
static inline double3 __mix_double_double3 (double3 x, double3 y, double a)  __attribute__ ((pure, simd));
static inline double3 __mix_double3 (double3 x, double3 y, double3 a)  __attribute__ ((pure, simd));
static inline double4 __mix_double_double4 (double4 x, double4 y, double a)  __attribute__ ((pure, simd));
static inline double4 __mix_double4 (double4 x, double4 y, double4 a)  __attribute__ ((pure, simd));
static inline double8 __mix_double_double8 (double8 x, double8 y, double a)  __attribute__ ((pure, simd));
static inline double8 __mix_double8 (double8 x, double8 y, double8 a)  __attribute__ ((pure, simd));
static inline double16 __mix_double_double16 (double16 x, double16 y, double a)  __attribute__ ((pure, simd));
static inline double16 __mix_double16 (double16 x, double16 y, double16 a)  __attribute__ ((pure, simd));
static inline double2 __step_double2 (double2 edge, double2 x)  __attribute__ ((pure, simd));
static inline double2 __step_double_double2 (double edge, double2 x)  __attribute__ ((pure, simd));
static inline double3 __step_double3 (double3 edge, double3 x)  __attribute__ ((pure, simd));
static inline double3 __step_double_double3 (double edge, double3 x)  __attribute__ ((pure, simd));
static inline double4 __step_double4 (double4 edge, double4 x)  __attribute__ ((pure, simd));
static inline double4 __step_double_double4 (double edge, double4 x)  __attribute__ ((pure, simd));
static inline double8 __step_double8 (double8 edge, double8 x)  __attribute__ ((pure, simd));
static inline double8 __step_double_double8 (double edge, double8 x)  __attribute__ ((pure, simd));
static inline double16 __step_double16 (double16 edge, double16 x)  __attribute__ ((pure, simd));
static inline double16 __step_double_double16 (double edge, double16 x)  __attribute__ ((pure, simd));
static inline double __step_double (double edge, double x)  __attribute__ ((pure, simd));
static inline double __smoothstep_double (double edge0, double edge1, double x)  __attribute__ ((pure, simd));
static inline double __smoothstep_double_double (double edge0, double edge1, double x)  __attribute__ ((pure, simd));
static inline double2 __smoothstep_double2 (double2 edge0, double2 edge1, double2 x)  __attribute__ ((pure, simd));
static inline double2 __smoothstep_double_double2 (double edge0, double edge1, double2 x)  __attribute__ ((pure, simd));
static inline double3 __smoothstep_double3 (double3 edge0, double3 edge1, double3 x)  __attribute__ ((pure, simd));
static inline double3 __smoothstep_double_double3 (double edge0, double edge1, double3 x)  __attribute__ ((pure, simd));
static inline double4 __smoothstep_double4 (double4 edge0, double4 edge1, double4 x)  __attribute__ ((pure, simd));
static inline double4 __smoothstep_double_double4 (double edge0, double edge1, double4 x)  __attribute__ ((pure, simd));
static inline double8 __smoothstep_double8 (double8 edge0, double8 edge1, double8 x)  __attribute__ ((pure, simd));
static inline double8 __smoothstep_double_double8 (double edge0, double edge1, double8 x)  __attribute__ ((pure, simd));
static inline double16 __smoothstep_double16 (double16 edge0, double16 edge1, double16 x)  __attribute__ ((pure, simd));
static inline double16 __smoothstep_double_double16 (double edge0, double edge1, double16 x)  __attribute__ ((pure, simd));
static inline double2 __tan_double2(double2 in) __attribute__ ((pure, simd));
static inline double3 __tan_double3(double3 in) __attribute__ ((pure, simd));
static inline double4 __tan_double4(double4 in) __attribute__ ((pure, simd));
static inline double8 __tan_double8(double8 in) __attribute__ ((pure, simd));
static inline double16 __tan_double16(double16 in) __attribute__ ((pure, simd));
static inline double __tan_double(double in) __attribute__ ((pure, simd));
static inline double2 __tanpi_double2(double2 in) __attribute__ ((pure, simd));
static inline double4 __tanpi_double4(double4 in) __attribute__ ((pure, simd));
static inline double8 __tanpi_double8(double8 in) __attribute__ ((pure, simd));
static inline double16 __tanpi_double16(double16 in) __attribute__ ((pure, simd));
static inline double __tanpi_double(double in) __attribute__ ((pure, simd));
static inline double3 __tanpi_double3(double3 x) __attribute__ ((pure, simd));
static inline double __nan_double(ulong nancode) __attribute__ ((pure, simd));
static inline double2 __nan_double2(ulong2 nancode) __attribute__ ((pure, simd));
static inline double3 __nan_double3(ulong3 nancode) __attribute__ ((pure, simd));
static inline double4 __nan_double4(ulong4 nancode) __attribute__ ((pure, simd));
static inline double8 __nan_double8(ulong8 nancode) __attribute__ ((pure, simd));
static inline double16 __nan_double16(ulong16 nancode) __attribute__ ((pure, simd));
static inline double __cosh_double(double in) __attribute__ ((pure, simd));
static inline double2 __cosh_double2(double2 in) __attribute__ ((pure, simd));
static inline double4 __cosh_double4(double4 in) __attribute__ ((pure, simd));
static inline double3 __cosh_double3(double3 in) __attribute__ ((pure, simd));
static inline double8 __cosh_double8(double8 in) __attribute__ ((pure, simd));
static inline double16 __cosh_double16(double16 in) __attribute__ ((pure, simd));
static inline double __sinh_double(double in) __attribute__ ((pure, simd));
static inline double2 __sinh_double2(double2 in) __attribute__ ((pure, simd));
static inline double4 __sinh_double4(double4 in) __attribute__ ((pure, simd));
static inline double3 __sinh_double3(double3 in) __attribute__ ((pure, simd));
static inline double8 __sinh_double8(double8 in) __attribute__ ((pure, simd));
static inline double16 __sinh_double16(double16 in) __attribute__ ((pure, simd));
static inline double __tanh_double(double in) __attribute__ ((pure, simd));
static inline double2 __tanh_double2(double2 in) __attribute__ ((pure, simd));
static inline double4 __tanh_double4(double4 in) __attribute__ ((pure, simd));
static inline double3 __tanh_double3(double3 in) __attribute__ ((pure, simd));
static inline double8 __tanh_double8(double8 in) __attribute__ ((pure, simd));
static inline double16 __tanh_double16(double16 in) __attribute__ ((pure, simd));
static inline double2 __cbrt_double2(double2 x) __attribute__ ((pure, simd));
static inline double __cbrt_double(double x) __attribute__ ((pure, simd));
static inline double4 __cbrt_double4(double4 in) __attribute__ ((pure, simd));
static inline double8 __cbrt_double8(double8 in) __attribute__ ((pure, simd));
static inline double16 __cbrt_double16(double16 in) __attribute__ ((pure, simd));
static inline double3 __cbrt_double3(double3 x) __attribute__ ((pure, simd));
static inline double2 __acos_double2(double2 x) __attribute__ ((pure, simd));
static inline double __acos_double(double x) __attribute__ ((pure, simd));
static inline double4 __acos_double4(double4 in) __attribute__ ((pure, simd));
static inline double8 __acos_double8(double8 in) __attribute__ ((pure, simd));
static inline double16 __acos_double16(double16 in) __attribute__ ((pure, simd));
static inline double3 __acos_double3(double3 in) __attribute__ ((pure, simd));
static inline double2 __acospi_double2(double2 x) __attribute__ ((pure, simd));
static inline double __acospi_double(double x) __attribute__ ((pure, simd));
static inline double4 __acospi_double4(double4 in) __attribute__ ((pure, simd));
static inline double8 __acospi_double8(double8 in) __attribute__ ((pure, simd));
static inline double16 __acospi_double16(double16 in) __attribute__ ((pure, simd));
static inline double3 __acospi_double3(double3 in) __attribute__ ((pure, simd));
static inline double2 __asin_double2(double2 x) __attribute__ ((pure, simd));
static inline double __asin_double(double x) __attribute__ ((pure, simd));
static inline double4 __asin_double4(double4 in) __attribute__ ((pure, simd));
static inline double8 __asin_double8(double8 in) __attribute__ ((pure, simd));
static inline double16 __asin_double16(double16 in) __attribute__ ((pure, simd));
static inline double3 __asin_double3(double3 in) __attribute__ ((pure, simd));
static inline double2 __asinpi_double2(double2 x) __attribute__ ((pure, simd));
static inline double __asinpi_double(double x) __attribute__ ((pure, simd));
static inline double4 __asinpi_double4(double4 in) __attribute__ ((pure, simd));
static inline double8 __asinpi_double8(double8 in) __attribute__ ((pure, simd));
static inline double16 __asinpi_double16(double16 in) __attribute__ ((pure, simd));
static inline double3 __asinpi_double3(double3 in) __attribute__ ((pure, simd));
static inline double2 __logb_double2(double2 x) __attribute__ ((pure, simd));
static inline double __logb_double(double x) __attribute__ ((pure, simd));
static inline double4 __logb_double4(double4 in) __attribute__ ((pure, simd));
static inline double8 __logb_double8(double8 in) __attribute__ ((pure, simd));
static inline double16 __logb_double16(double16 in) __attribute__ ((pure, simd));
static inline double3 __logb_double3(double3 x) __attribute__ ((pure, simd));
static inline int2 __ilogb_double2(double2 x) __attribute__ ((pure, simd));
static inline int __ilogb_double(double x) __attribute__ ((pure, simd));
static inline int4 __ilogb_double4(double4 in) __attribute__ ((pure, simd));
static inline int8 __ilogb_double8(double8 in) __attribute__ ((pure, simd));
static inline int16 __ilogb_double16(double16 in) __attribute__ ((pure, simd));
static inline int3 __ilogb_double3(double3 in) __attribute__ ((pure, simd));
static inline double2 __ldexp_int_double2(double2 x, int n) __attribute__ ((pure, simd));
static inline double2 __ldexp_double2(double2 x, int2 n) __attribute__ ((pure, simd));
static inline double __ldexp_double(double x, int n) __attribute__ ((pure, simd));
static inline double4 __ldexp_double4(double4 x, int4 n) __attribute__ ((pure, simd));
static inline double8 __ldexp_double8(double8 x, int8 n) __attribute__ ((pure, simd));
static inline double16 __ldexp_double16(double16 x, int16 n) __attribute__ ((pure, simd));
static inline double4 __ldexp_int_double4(double4 x, int n) __attribute__ ((pure, simd));
static inline double8 __ldexp_int_double8(double8 x, int n) __attribute__ ((pure, simd));
static inline double16 __ldexp_int_double16(double16 x, int n) __attribute__ ((pure, simd));
static inline double3 __ldexp_double3 (double3 x, int3 exponent) __attribute__ ((pure, simd));
static inline double3 __ldexp_int_double3 (double3 x, int exponent) __attribute__ ((pure, simd));
static inline double2 __frexp_double2(double2 x, int2 *pexp) __attribute__ ((pure, simd));
static inline double __frexp_double(double x, int *pexp) __attribute__ ((pure, simd));
static inline double3 __frexp_double3(double3 x, int3 *pexp) __attribute__ ((pure, simd));
static inline double4 __frexp_double4(double4 x, int4 *pexp) __attribute__ ((pure, simd));
static inline double8 __frexp_double8(double8 x, int8 *pexp) __attribute__ ((pure, simd));
static inline double16 __frexp_double16(double16 x, int16 *pexp) __attribute__ ((pure, simd));
static inline double2 __frexp_double2_global(double2 x, __global int2 *pexp) __attribute__ ((pure, simd));
static inline double __frexp_double_global(double x, __global int *pexp) __attribute__ ((pure, simd));
static inline double3 __frexp_double3_global(double3 x, __global int3 *pexp) __attribute__ ((pure, simd));
static inline double4 __frexp_double4_global(double4 x, __global int4 *pexp) __attribute__ ((pure, simd));
static inline double8 __frexp_double8_global(double8 x, __global int8 *pexp) __attribute__ ((pure, simd));
static inline double16 __frexp_double16_global(double16 x, __global int16 *pexp) __attribute__ ((pure, simd));
static inline double2 __ceil_double2 (double2 x) __attribute__ ((pure, simd));
static inline double __ceil_double (double x) __attribute__ ((pure, simd));
static inline double4 __ceil_double4(double4 x) __attribute__ ((pure, simd));
static inline double8 __ceil_double8(double8 x) __attribute__ ((pure, simd));
static inline double16 __ceil_double16(double16 x) __attribute__ ((pure, simd));
static inline double3 __ceil_double3(double3 x) __attribute__ ((pure, simd));
static inline double2 __fract_double2 (double2 x, double2 *iptr)  __attribute__ ((pure, simd));
static inline double3 __fract_double3 (double3 x, double3 *iptr)  __attribute__ ((pure, simd));
static inline double4 __fract_double4 (double4 x, double4 *iptr)  __attribute__ ((pure, simd));
static inline double8 __fract_double8 (double8 x, double8 *iptr)  __attribute__ ((pure, simd));
static inline double16 __fract_double16 (double16 x, double16 *iptr)  __attribute__ ((pure, simd));
static inline double2 __fract_double2_global (double2 x, __global double2 *iptr)  __attribute__ ((pure, simd));
static inline double3 __fract_double3_global (double3 x, __global double3 *iptr)  __attribute__ ((pure, simd));
static inline double4 __fract_double4_global (double4 x, __global double4 *iptr)  __attribute__ ((pure, simd));
static inline double8 __fract_double8_global (double8 x, __global double8 *iptr)  __attribute__ ((pure, simd));
static inline double16 __fract_double16_global (double16 x, __global double16 *iptr)  __attribute__ ((pure, simd));
static inline double __fract_double (double x, double *iptr)  __attribute__ ((pure, simd));
static inline double __fract_double_global (double x, __global double *iptr)  __attribute__ ((pure, simd));
static inline double2 __round_double2 (double2 x) __attribute__ ((pure, simd));
static inline double __round_double (double x) __attribute__ ((pure, simd));
static inline double4 __round_double4(double4 x) __attribute__ ((pure, simd));
static inline double3 __round_double3(double3 x) __attribute__ ((pure, simd));
static inline double8 __round_double8(double8 x) __attribute__ ((pure, simd));
static inline double16 __round_double16(double16 x) __attribute__ ((pure, simd));
static inline double2 __nextafter_double2(double2 x, double2 y) __attribute__ ((pure, simd));
static inline double4 __nextafter_double4(double4 x, double4 y) __attribute__ ((pure, simd));
static inline double8 __nextafter_double8(double8 x, double8 y) __attribute__ ((pure, simd));
static inline double16 __nextafter_double16(double16 x, double16 y) __attribute__ ((pure, simd));
static inline double __nextafter_double(double x, double y) __attribute__ ((pure, simd));
static inline double3 __nextafter_double3(double3 x, double3 y) __attribute__ ((pure, simd));
static inline double __distance_double(double p0, double p1)  __attribute__ ((pure, simd));
static inline double __distance_double2(double2 p0, double2 p1)  __attribute__ ((pure, simd));
static inline double __distance_double3(double3 p0, double3 p1)  __attribute__ ((pure, simd));
static inline double __distance_double4(double4 p0, double4 p1)  __attribute__ ((pure, simd));
static inline double4 __cross_double4(double4 p0, double4 p1)  __attribute__ ((pure, simd));
static inline double3 __cross_double3(double3 p0, double3 p1)  __attribute__ ((pure, simd));
static inline double __dot_double4(double4 p0, double4 p1)  __attribute__ ((pure, simd));
static inline double __dot_double3(double3 p0, double3 p1)  __attribute__ ((pure, simd));
static inline double __dot_double2(double2 p0, double2 p1)  __attribute__ ((pure, simd));
static inline double __dot_double(double p0, double p1)  __attribute__ ((pure, simd));
static inline double __length_double(double p)  __attribute__ ((pure, simd));
static inline double __length_double2(double2 p)  __attribute__ ((pure, simd));
static inline double __length_double3(double3 p)  __attribute__ ((pure, simd));
static inline double __length_double4(double4 p)  __attribute__ ((pure, simd));
static inline double __normalize_double(double p)  __attribute__ ((pure, simd));
static inline double2 __normalize_double2(double2 p)  __attribute__ ((pure, simd));
static inline double3 __normalize_double3(double3 p)  __attribute__ ((pure, simd));
static inline double4 __normalize_double4(double4 p)  __attribute__ ((pure, simd));
static inline double2 __sign_double2 (double2 x)  __attribute__ ((pure, simd));
static inline double3 __sign_double3 (double3 x)  __attribute__ ((pure, simd));
static inline double4 __sign_double4 (double4 x)  __attribute__ ((pure, simd));
static inline double8 __sign_double8 (double8 x)  __attribute__ ((pure, simd));
static inline double16 __sign_double16 (double16 x)  __attribute__ ((pure, simd));
static inline double __sign_double (double x) __attribute__ ((pure, simd));
static inline double2 __rint_double2 (double2 x) __attribute__ ((pure, simd));
static inline double __rint_double (double x) __attribute__ ((pure, simd));
static inline double4 __rint_double4(double4 x) __attribute__ ((pure, simd));
static inline double3 __rint_double3(double3 x) __attribute__ ((pure, simd));
static inline double8 __rint_double8(double8 x) __attribute__ ((pure, simd));
static inline double16 __rint_double16(double16 x) __attribute__ ((pure, simd));
static inline double2 __modf_double2(double2 x, double2 *iptr) __attribute__ ((pure, simd));
static inline double3 __modf_double3(double3 x, double3 *iptr) __attribute__ ((pure, simd));
static inline double4 __modf_double4(double4 x, double4 *iptr) __attribute__ ((pure, simd));
static inline double8 __modf_double8(double8 x, double8 *iptr) __attribute__ ((pure, simd));
static inline double16 __modf_double16(double16 x, double16 *iptr) __attribute__ ((pure, simd));
static inline double2 __modf_double2_global(double2 x, __global double2 *iptr) __attribute__ ((pure, simd));
static inline double3 __modf_double3_global(double3 x, __global double3 *iptr) __attribute__ ((pure, simd));
static inline double4 __modf_double4_global(double4 x, __global double4 *iptr) __attribute__ ((pure, simd));
static inline double8 __modf_double8_global(double8 x, __global double8 *iptr) __attribute__ ((pure, simd));
static inline double16 __modf_double16_global(double16 x, __global double16 *iptr) __attribute__ ((pure, simd));
static inline double __modf_double (double x, double *iptr)  __attribute__ ((pure, simd));
static inline double __modf_double_global (double x, __global double *iptr)  __attribute__ ((pure, simd));
static inline double2 __trunc_double2 (double2 x) __attribute__ ((pure, simd));
static inline double __trunc_double (double x) __attribute__ ((pure, simd));
static inline double4 __trunc_double4(double4 x) __attribute__ ((pure, simd));
static inline double3 __trunc_double3(double3 x) __attribute__ ((pure, simd));
static inline double8 __trunc_double8(double8 x) __attribute__ ((pure, simd));
static inline double16 __trunc_double16(double16 x) __attribute__ ((pure, simd));
static inline double2 __fdim_double2(double2 x, double2 y) __attribute__ ((pure, simd));
static inline double4 __fdim_double4(double4 x, double4 y) __attribute__ ((pure, simd));
static inline double8 __fdim_double8(double8 x, double8 y) __attribute__ ((pure, simd));
static inline double16 __fdim_double16(double16 x, double16 y) __attribute__ ((pure, simd));
static inline double __fdim_double(double x, double y) __attribute__ ((pure, simd));
static inline double3 __fdim_double3(double3 x, double3 y) __attribute__ ((pure, simd));
static inline double2 __hypot_double2 (double2 x, double2 y)  __attribute__ ((pure, simd));
static inline double4 __hypot_double4 (double4 x, double4 y)  __attribute__ ((pure, simd));
static inline double8 __hypot_double8 (double8 x, double8 y)  __attribute__ ((pure, simd));
static inline double16 __hypot_double16 (double16 x, double16 y)  __attribute__ ((pure, simd));
static inline double __hypot_double (double x, double y) __attribute__ ((pure, simd));
static inline double3 __hypot_double3(double3 x, double3 y) __attribute__ ((pure, simd));
static inline double2 __atan2_double2(double2 y, double2 x) __attribute__ ((pure, simd));
static inline double4 __atan2_double4(double4 y, double4 x) __attribute__ ((pure, simd));
static inline double8 __atan2_double8(double8 y, double8 x) __attribute__ ((pure, simd));
static inline double16 __atan2_double16(double16 y, double16 x) __attribute__ ((pure, simd));
static inline double __atan2_double(double y, double x) __attribute__ ((pure, simd));
static inline double3 __atan2_double3(double3 y, double3 x) __attribute__ ((pure, simd));
static inline double2 __atan2pi_double2(double2 y, double2 x) __attribute__ ((pure, simd));
static inline double4 __atan2pi_double4(double4 y, double4 x) __attribute__ ((pure, simd));
static inline double8 __atan2pi_double8(double8 y, double8 x) __attribute__ ((pure, simd));
static inline double16 __atan2pi_double16(double16 y, double16 x) __attribute__ ((pure, simd));
static inline double __atan2pi_double(double y, double x) __attribute__ ((pure, simd));
static inline double3 __atan2pi_double3(double3 y, double3 x) __attribute__ ((pure, simd));
static inline double2 __atan_double2(double2 x) __attribute__ ((pure, simd));
static inline double __atan_double(double x) __attribute__ ((pure, simd));
static inline double4 __atan_double4(double4 in) __attribute__ ((pure, simd));
static inline double8 __atan_double8(double8 in) __attribute__ ((pure, simd));
static inline double16 __atan_double16(double16 in) __attribute__ ((pure, simd));
static inline double3 __atan_double3(double3 x) __attribute__ ((pure, simd));
static inline double2 __atanpi_double2(double2 x) __attribute__ ((pure, simd));
static inline double __atanpi_double(double x) __attribute__ ((pure, simd));
static inline double4 __atanpi_double4(double4 in) __attribute__ ((pure, simd));
static inline double8 __atanpi_double8(double8 in) __attribute__ ((pure, simd));
static inline double16 __atanpi_double16(double16 in) __attribute__ ((pure, simd));
static inline double3 __atanpi_double3(double3 in) __attribute__ ((pure, simd));
static inline double2 __erfc_double2(double2 x) __attribute__ ((pure, simd));
static inline double __erfc_double(double x) __attribute__ ((pure, simd));
static inline double4 __erfc_double4(double4 in) __attribute__ ((pure, simd));
static inline double8 __erfc_double8(double8 in) __attribute__ ((pure, simd));
static inline double16 __erfc_double16(double16 in) __attribute__ ((pure, simd));
static inline double3 __erfc_double3(double3 x) __attribute__ ((pure, simd));
static inline double2 __fmod_double2(double2 x, double2 y) __attribute__ ((pure, simd));
static inline double3 __fmod_double3(double3 x, double3 y) __attribute__ ((pure, simd));
static inline double4 __fmod_double4(double4 x, double4 y) __attribute__ ((pure, simd));
static inline double8 __fmod_double8(double8 x, double8 y) __attribute__ ((pure, simd));
static inline double16 __fmod_double16(double16 x, double16 y) __attribute__ ((pure, simd));
static inline double __fmod_double(double x, double y) __attribute__ ((pure, simd));
static inline double2 __remainder_double2(double2 x, double2 y) __attribute__ ((pure, simd));
static inline double3 __remainder_double3(double3 x, double3 y) __attribute__ ((pure, simd));
static inline double4 __remainder_double4(double4 x, double4 y) __attribute__ ((pure, simd));
static inline double8 __remainder_double8(double8 x, double8 y) __attribute__ ((pure, simd));
static inline double16 __remainder_double16(double16 x, double16 y) __attribute__ ((pure, simd));
static inline double __remainder_double(double x, double y) __attribute__ ((pure, simd));
static inline double2 __remquo_double2(double2 x, double2 y, int2 *quo) __attribute__ ((pure, simd));
static inline double3 __remquo_double3(double3 x, double3 y, int3 *quo) __attribute__ ((pure, simd));
static inline double4 __remquo_double4(double4 x, double4 y, int4 *quo) __attribute__ ((pure, simd));
static inline double8 __remquo_double8(double8 x, double8 y, int8 *quo) __attribute__ ((pure, simd));
static inline double16 __remquo_double16(double16 x, double16 y, int16 *quo) __attribute__ ((pure, simd));
static inline double2 __remquo_double2_global(double2 x, double2 y, __global int2 *quo) __attribute__ ((pure, simd));
static inline double3 __remquo_double3_global(double3 x, double3 y, __global int3 *quo) __attribute__ ((pure, simd));
static inline double4 __remquo_double4_global(double4 x, double4 y, __global int4 *quo) __attribute__ ((pure, simd));
static inline double8 __remquo_double8_global(double8 x, double8 y, __global int8 *quo) __attribute__ ((pure, simd));
static inline double16 __remquo_double16_global(double16 x, double16 y, __global int16 *quo) __attribute__ ((pure, simd));
static inline double __remquo_double(double x, double y, int *quo) __attribute__ ((pure, simd));
static inline double __remquo_double_global(double x, double y, __global int *quo) __attribute__ ((pure, simd));
static inline double2 __tgamma_double2(double2 x) __attribute__ ((pure, simd));
static inline double __tgamma_double(double x) __attribute__ ((pure, simd));
static inline double4 __tgamma_double4(double4 in) __attribute__ ((pure, simd));
static inline double3 __tgamma_double3(double3 x) __attribute__ ((pure, simd));
static inline double8 __tgamma_double8(double8 in) __attribute__ ((pure, simd));
static inline double16 __tgamma_double16(double16 in) __attribute__ ((pure, simd));
static inline double2 __clamp_double2 (double2 x, double2 minval, double2 maxval)  __attribute__ ((pure, simd));
static inline double2 __clamp_double_double2 (double2 x, double minval, double maxval)  __attribute__ ((pure, simd));
static inline double3 __clamp_double3 (double3 x, double3 minval, double3 maxval)  __attribute__ ((pure, simd));
static inline double3 __clamp_double_double3 (double3 x, double minval, double maxval)  __attribute__ ((pure, simd));
static inline double4 __clamp_double4 (double4 x, double4 minval, double4 maxval)  __attribute__ ((pure, simd));
static inline double4 __clamp_double_double4 (double4 x, double minval, double maxval)  __attribute__ ((pure, simd));
static inline double8 __clamp_double8 (double8 x, double8 minval, double8 maxval)  __attribute__ ((pure, simd));
static inline double8 __clamp_double_double8 (double8 x, double minval, double maxval)  __attribute__ ((pure, simd));
static inline double16 __clamp_double16 (double16 x, double16 minval, double16 maxval)  __attribute__ ((pure, simd));
static inline double16 __clamp_double_double16 (double16 x, double minval, double maxval)  __attribute__ ((pure, simd));
static inline double __clamp_double (double x, double minval, double maxval)  __attribute__ ((pure, simd));
static inline double __exp_double(double in) __attribute__ ((pure, simd));
static inline double2 __exp_double2(double2 in) __attribute__ ((pure, simd));
static inline double4 __exp_double4(double4 in) __attribute__ ((pure, simd));
static inline double8 __exp_double8(double8 in) __attribute__ ((pure, simd));
static inline double16 __exp_double16(double16 in) __attribute__ ((pure, simd));
static inline double3 __exp_double3(double3 x) __attribute__ ((pure, simd));
static inline double2 __log_kernel_double2(double2 x) __attribute__ ((pure, simd));
static inline double2 __log_double2(double2 x) __attribute__ ((pure, simd));
static inline double __log_kernel_double(double x) __attribute__ ((pure, simd));
static inline double __log_double(double x) __attribute__ ((pure, simd));
static inline double4 __log_double4(double4 in) __attribute__ ((pure, simd));
static inline double3 __log_double3(double3 x) __attribute__ ((pure, simd));
static inline double8 __log_double8(double8 in) __attribute__ ((pure, simd));
static inline double16 __log_double16(double16 in) __attribute__ ((pure, simd));
static inline double2 __floor_double2 (double2 x) __attribute__ ((pure, simd));
static inline double __floor_double (double x) __attribute__ ((pure, simd));
static inline double4 __floor_double4(double4 x) __attribute__ ((pure, simd));
static inline double8 __floor_double8(double8 x) __attribute__ ((pure, simd));
static inline double16 __floor_double16(double16 x) __attribute__ ((pure, simd));
static inline double3 __floor_double3(double3 x) __attribute__ ((pure, simd));
static inline double2 __fmin_double2(double2 x, double2 y) __attribute__ ((pure, simd));
static inline double3 __fmin_double3(double3 x, double3 y) __attribute__ ((pure, simd));
static inline double4 __fmin_double4(double4 x, double4 y) __attribute__ ((pure, simd));
static inline double8 __fmin_double8(double8 x, double8 y) __attribute__ ((pure, simd));
static inline double16 __fmin_double16(double16 x, double16 y) __attribute__ ((pure, simd));
static inline double2 __fmin_double_double2(double2 x, double y) __attribute__ ((pure, simd));
static inline double3 __fmin_double_double3(double3 x, double y) __attribute__ ((pure, simd));
static inline double4 __fmin_double_double4(double4 x, double y) __attribute__ ((pure, simd));
static inline double8 __fmin_double_double8(double8 x, double y) __attribute__ ((pure, simd));
static inline double16 __fmin_double_double16(double16 x, double y) __attribute__ ((pure, simd));
static inline double __fmin_double(double x, double y) __attribute__ ((pure, simd));
static inline double2 __fmax_double2(double2 x, double2 y) __attribute__ ((pure, simd));
static inline double3 __fmax_double3(double3 x, double3 y) __attribute__ ((pure, simd));
static inline double4 __fmax_double4(double4 x, double4 y) __attribute__ ((pure, simd));
static inline double8 __fmax_double8(double8 x, double8 y) __attribute__ ((pure, simd));
static inline double16 __fmax_double16(double16 x, double16 y) __attribute__ ((pure, simd));
static inline double2 __fmax_double_double2(double2 x, double y) __attribute__ ((pure, simd));
static inline double3 __fmax_double_double3(double3 x, double y) __attribute__ ((pure, simd));
static inline double4 __fmax_double_double4(double4 x, double y) __attribute__ ((pure, simd));
static inline double8 __fmax_double_double8(double8 x, double y) __attribute__ ((pure, simd));
static inline double16 __fmax_double_double16(double16 x, double y) __attribute__ ((pure, simd));
static inline double __fmax_double(double x, double y) __attribute__ ((pure, simd));
static inline double2 __maxmag_double2 (double2 x, double2 y)  __attribute__ ((pure, simd));
static inline double4 __maxmag_double4 (double4 x, double4 y)  __attribute__ ((pure, simd));
static inline double8 __maxmag_double8 (double8 x, double8 y)  __attribute__ ((pure, simd));
static inline double16 __maxmag_double16 (double16 x, double16 y)  __attribute__ ((pure, simd));
static inline double __maxmag_double (double x, double y)  __attribute__ ((pure, simd));
static inline double3 __maxmag_double3(double3 x, double3 y) __attribute__ ((pure, simd));
static inline double2 __minmag_double2 (double2 x, double2 y)  __attribute__ ((pure, simd));
static inline double4 __minmag_double4 (double4 x, double4 y)  __attribute__ ((pure, simd));
static inline double8 __minmag_double8 (double8 x, double8 y)  __attribute__ ((pure, simd));
static inline double16 __minmag_double16 (double16 x, double16 y)  __attribute__ ((pure, simd));
static inline double __minmag_double (double x, double y)  __attribute__ ((pure, simd));
static inline double3 __minmag_double3(double3 x, double3 y) __attribute__ ((pure, simd));
static inline double __range_reduce_pi_over_4_double(double in, long *poctant) __attribute__ ((pure, simd));
static inline double2 __range_reduce_pi_over_4_double2(double2 in, long2 *poctant) __attribute__ ((pure, simd));
static inline double3 __range_reduce_pi_over_4_double3(double3 in, long3 *poctant) __attribute__ ((pure, simd));
static inline double4 __range_reduce_pi_over_4_double4(double4 in, long4 *poctant) __attribute__ ((pure, simd));
static inline double8 __range_reduce_pi_over_4_double8(double8 in, long8 *poctant) __attribute__ ((pure, simd));
static inline double16 __range_reduce_pi_over_4_double16(double16 in, long16 *poctant) __attribute__ ((pure, simd));
static inline double2 __sqrt_double2 (double2 in) __attribute__ ((pure, simd));
static inline double __sqrt_double(double x) __attribute__ ((pure, simd));
static inline double4 __sqrt_double4(double4 in) __attribute__ ((pure, simd));
static inline double3 __sqrt_double3(double3 x) __attribute__ ((pure, simd));
static inline double8 __sqrt_double8(double8 in) __attribute__ ((pure, simd));
static inline double16 __sqrt_double16(double16 in) __attribute__ ((pure, simd));
static inline double2 __rsqrt_0_approx_double2(double2 dx) __attribute__ ((pure, simd));
static inline double2 __rsqrt_double2(double2 x) __attribute__ ((pure, simd));
static inline double __rsqrt_double(double x) __attribute__ ((pure, simd));
static inline double2 __rsqrt_double2(double2 x) __attribute__ ((pure, simd));
static inline double __rsqrt_double(double x) __attribute__ ((pure, simd));
static inline double3 __rsqrt_double3(double3 x) __attribute__ ((pure, simd));
static inline double4 __rsqrt_double4(double4 in) __attribute__ ((pure, simd));
static inline double8 __rsqrt_double8(double8 in) __attribute__ ((pure, simd));
static inline double16 __rsqrt_double16(double16 in) __attribute__ ((pure, simd));
#endif
#include "CL/device/internal/cl_kernel_builtin_inline_CPU.h"
#endif 
