/**********************************************************************/
/*                                                                    */
/*   Licensed Materials - Property of IBM.                            */
/*   IBM XL C for OpenCL, V0.3 (technology preview)                   */
/*   Copyright IBM Corp. 2009.                                        */
/*   All Rights Reserved.                                             */
/*   US Government Users Restricted Rights -                          */
/*   Use, duplication or disclosure restricted by                     */
/*   GSA ADP Schedule Contract with IBM Corp.                         */
/*                                                                    */
/**********************************************************************/

#ifndef __IBM_VACPP_xl_gentype_h
#define __IBM_VACPP_xl_gentype_h 1

typedef unsigned char uchar;
typedef unsigned short ushort;
typedef unsigned int uint;
typedef unsigned long ulong;
#define event_t unsigned int
#define cl_mem_fence_flags unsigned int

/* Miscellaneous Built-ins */
#pragma tg_funcdef(__fre, __fre_tg, float, float)
#pragma tg_funcdef(__fre, __fre_tg, float2, float2)
#pragma tg_funcdef(__fre, __fre_tg, float3, float3)
#pragma tg_funcdef(__fre, __fre_tg, float4, float4)
#pragma tg_funcdef(__fre, __fre_tg, float8, float8)
#pragma tg_funcdef(__fre, __fre_tg, float16, float16)
#pragma tg_funcdef(__fre, __fre_tg, double, double)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(__fre, __fre_tg, double2, double2)
#pragma tg_funcdef(__fre, __fre_tg, double3, double3)
#pragma tg_funcdef(__fre, __fre_tg, double4, double4)
#pragma tg_funcdef(__fre, __fre_tg, double8, double8)
#pragma tg_funcdef(__fre, __fre_tg, double16, double16)
 #endif
#undef __fre
#define __fre(__a) __tg_builtin_gentype("__fre",__a)

#pragma tg_funcdef(__frsqrte, __frsqrte_tg, float, float)
#pragma tg_funcdef(__frsqrte, __frsqrte_tg, float2, float2)
#pragma tg_funcdef(__frsqrte, __frsqrte_tg, float3, float3)
#pragma tg_funcdef(__frsqrte, __frsqrte_tg, float4, float4)
#pragma tg_funcdef(__frsqrte, __frsqrte_tg, float8, float8)
#pragma tg_funcdef(__frsqrte, __frsqrte_tg, float16, float16)
#pragma tg_funcdef(__frsqrte, __frsqrte_tg, double, double)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(__frsqrte, __frsqrte_tg, double2, double2)
#pragma tg_funcdef(__frsqrte, __frsqrte_tg, double3, double3)
#pragma tg_funcdef(__frsqrte, __frsqrte_tg, double4, double4)
#pragma tg_funcdef(__frsqrte, __frsqrte_tg, double8, double8)
#pragma tg_funcdef(__frsqrte, __frsqrte_tg, double16, double16)
 #endif
#undef __frsqrte
#define __frsqrte(__a) __tg_builtin_gentype("__frsqrte",__a)

/* new shuffle */
#pragma tg_funcdef(shuffle, shuffle_tg, char2,  char2,  uchar2)
#pragma tg_funcdef(shuffle, shuffle_tg, char2,  char3,  uchar2)
#pragma tg_funcdef(shuffle, shuffle_tg, char2,  char4,  uchar2)
#pragma tg_funcdef(shuffle, shuffle_tg, char2,  char8,  uchar2)
#pragma tg_funcdef(shuffle, shuffle_tg, char2,  char16, uchar2)

#pragma tg_funcdef(shuffle, shuffle_tg, char3,  char2,  uchar3)
#pragma tg_funcdef(shuffle, shuffle_tg, char3,  char3,  uchar3)
#pragma tg_funcdef(shuffle, shuffle_tg, char3,  char4,  uchar3)
#pragma tg_funcdef(shuffle, shuffle_tg, char3,  char8,  uchar3)
#pragma tg_funcdef(shuffle, shuffle_tg, char3,  char16, uchar3)

#pragma tg_funcdef(shuffle, shuffle_tg, char4,  char2,  uchar4)
#pragma tg_funcdef(shuffle, shuffle_tg, char4,  char3,  uchar4)
#pragma tg_funcdef(shuffle, shuffle_tg, char4,  char4,  uchar4)
#pragma tg_funcdef(shuffle, shuffle_tg, char4,  char8,  uchar4)
#pragma tg_funcdef(shuffle, shuffle_tg, char4,  char16, uchar4)

#pragma tg_funcdef(shuffle, shuffle_tg, char8,  char2,  uchar8)
#pragma tg_funcdef(shuffle, shuffle_tg, char8,  char3,  uchar8)
#pragma tg_funcdef(shuffle, shuffle_tg, char8,  char4,  uchar8)
#pragma tg_funcdef(shuffle, shuffle_tg, char8,  char8,  uchar8)
#pragma tg_funcdef(shuffle, shuffle_tg, char8,  char16, uchar8)

#pragma tg_funcdef(shuffle, shuffle_tg, char16, char2,  uchar16)
#pragma tg_funcdef(shuffle, shuffle_tg, char16, char3,  uchar16)
#pragma tg_funcdef(shuffle, shuffle_tg, char16, char4,  uchar16)
#pragma tg_funcdef(shuffle, shuffle_tg, char16, char8,  uchar16)
#pragma tg_funcdef(shuffle, shuffle_tg, char16, char16, uchar16)


#pragma tg_funcdef(shuffle, shuffle_tg, uchar2,  uchar2,  uchar2)
#pragma tg_funcdef(shuffle, shuffle_tg, uchar2,  uchar3,  uchar2)
#pragma tg_funcdef(shuffle, shuffle_tg, uchar2,  uchar4,  uchar2)
#pragma tg_funcdef(shuffle, shuffle_tg, uchar2,  uchar8,  uchar2)
#pragma tg_funcdef(shuffle, shuffle_tg, uchar2,  uchar16, uchar2)

#pragma tg_funcdef(shuffle, shuffle_tg, uchar3,  uchar2,  uchar3)
#pragma tg_funcdef(shuffle, shuffle_tg, uchar3,  uchar3,  uchar3)
#pragma tg_funcdef(shuffle, shuffle_tg, uchar3,  uchar4,  uchar3)
#pragma tg_funcdef(shuffle, shuffle_tg, uchar3,  uchar8,  uchar3)
#pragma tg_funcdef(shuffle, shuffle_tg, uchar3,  uchar16, uchar3)

#pragma tg_funcdef(shuffle, shuffle_tg, uchar4,  uchar2,  uchar4)
#pragma tg_funcdef(shuffle, shuffle_tg, uchar4,  uchar3,  uchar4)
#pragma tg_funcdef(shuffle, shuffle_tg, uchar4,  uchar4,  uchar4)
#pragma tg_funcdef(shuffle, shuffle_tg, uchar4,  uchar8,  uchar4)
#pragma tg_funcdef(shuffle, shuffle_tg, uchar4,  uchar16, uchar4)

#pragma tg_funcdef(shuffle, shuffle_tg, uchar8,  uchar2,  uchar8)
#pragma tg_funcdef(shuffle, shuffle_tg, uchar8,  uchar3,  uchar8)
#pragma tg_funcdef(shuffle, shuffle_tg, uchar8,  uchar4,  uchar8)
#pragma tg_funcdef(shuffle, shuffle_tg, uchar8,  uchar8,  uchar8)
#pragma tg_funcdef(shuffle, shuffle_tg, uchar8,  uchar16, uchar8)

#pragma tg_funcdef(shuffle, shuffle_tg, uchar16, uchar2,  uchar16)
#pragma tg_funcdef(shuffle, shuffle_tg, uchar16, uchar3,  uchar16)
#pragma tg_funcdef(shuffle, shuffle_tg, uchar16, uchar4,  uchar16)
#pragma tg_funcdef(shuffle, shuffle_tg, uchar16, uchar8,  uchar16)
#pragma tg_funcdef(shuffle, shuffle_tg, uchar16, uchar16, uchar16)


#pragma tg_funcdef(shuffle, shuffle_tg, short2,  short2,  ushort2)
#pragma tg_funcdef(shuffle, shuffle_tg, short2,  short3,  ushort2)
#pragma tg_funcdef(shuffle, shuffle_tg, short2,  short4,  ushort2)
#pragma tg_funcdef(shuffle, shuffle_tg, short2,  short8,  ushort2)
#pragma tg_funcdef(shuffle, shuffle_tg, short2,  short16, ushort2)

#pragma tg_funcdef(shuffle, shuffle_tg, short3,  short2,  ushort3)
#pragma tg_funcdef(shuffle, shuffle_tg, short3,  short3,  ushort3)
#pragma tg_funcdef(shuffle, shuffle_tg, short3,  short4,  ushort3)
#pragma tg_funcdef(shuffle, shuffle_tg, short3,  short8,  ushort3)
#pragma tg_funcdef(shuffle, shuffle_tg, short3,  short16, ushort3)

#pragma tg_funcdef(shuffle, shuffle_tg, short4,  short2,  ushort4)
#pragma tg_funcdef(shuffle, shuffle_tg, short4,  short3,  ushort4)
#pragma tg_funcdef(shuffle, shuffle_tg, short4,  short4,  ushort4)
#pragma tg_funcdef(shuffle, shuffle_tg, short4,  short8,  ushort4)
#pragma tg_funcdef(shuffle, shuffle_tg, short4,  short16, ushort4)

#pragma tg_funcdef(shuffle, shuffle_tg, short8,  short2,  ushort8)
#pragma tg_funcdef(shuffle, shuffle_tg, short8,  short3,  ushort8)
#pragma tg_funcdef(shuffle, shuffle_tg, short8,  short4,  ushort8)
#pragma tg_funcdef(shuffle, shuffle_tg, short8,  short8,  ushort8)
#pragma tg_funcdef(shuffle, shuffle_tg, short8,  short16, ushort8)

#pragma tg_funcdef(shuffle, shuffle_tg, short16, short2,  ushort16)
#pragma tg_funcdef(shuffle, shuffle_tg, short16, short3,  ushort16)
#pragma tg_funcdef(shuffle, shuffle_tg, short16, short4,  ushort16)
#pragma tg_funcdef(shuffle, shuffle_tg, short16, short8,  ushort16)
#pragma tg_funcdef(shuffle, shuffle_tg, short16, short16, ushort16)


#pragma tg_funcdef(shuffle, shuffle_tg, ushort2,  ushort2,  ushort2)
#pragma tg_funcdef(shuffle, shuffle_tg, ushort2,  ushort3,  ushort2)
#pragma tg_funcdef(shuffle, shuffle_tg, ushort2,  ushort4,  ushort2)
#pragma tg_funcdef(shuffle, shuffle_tg, ushort2,  ushort8,  ushort2)
#pragma tg_funcdef(shuffle, shuffle_tg, ushort2,  ushort16, ushort2)

#pragma tg_funcdef(shuffle, shuffle_tg, ushort3,  ushort2,  ushort3)
#pragma tg_funcdef(shuffle, shuffle_tg, ushort3,  ushort3,  ushort3)
#pragma tg_funcdef(shuffle, shuffle_tg, ushort3,  ushort4,  ushort3)
#pragma tg_funcdef(shuffle, shuffle_tg, ushort3,  ushort8,  ushort3)
#pragma tg_funcdef(shuffle, shuffle_tg, ushort3,  ushort16, ushort3)

#pragma tg_funcdef(shuffle, shuffle_tg, ushort4,  ushort2,  ushort4)
#pragma tg_funcdef(shuffle, shuffle_tg, ushort4,  ushort3,  ushort4)
#pragma tg_funcdef(shuffle, shuffle_tg, ushort4,  ushort4,  ushort4)
#pragma tg_funcdef(shuffle, shuffle_tg, ushort4,  ushort8,  ushort4)
#pragma tg_funcdef(shuffle, shuffle_tg, ushort4,  ushort16, ushort4)

#pragma tg_funcdef(shuffle, shuffle_tg, ushort8,  ushort2,  ushort8)
#pragma tg_funcdef(shuffle, shuffle_tg, ushort8,  ushort3,  ushort8)
#pragma tg_funcdef(shuffle, shuffle_tg, ushort8,  ushort4,  ushort8)
#pragma tg_funcdef(shuffle, shuffle_tg, ushort8,  ushort8,  ushort8)
#pragma tg_funcdef(shuffle, shuffle_tg, ushort8,  ushort16, ushort8)

#pragma tg_funcdef(shuffle, shuffle_tg, ushort16, ushort2,  ushort16)
#pragma tg_funcdef(shuffle, shuffle_tg, ushort16, ushort3,  ushort16)
#pragma tg_funcdef(shuffle, shuffle_tg, ushort16, ushort4,  ushort16)
#pragma tg_funcdef(shuffle, shuffle_tg, ushort16, ushort8,  ushort16)
#pragma tg_funcdef(shuffle, shuffle_tg, ushort16, ushort16, ushort16)


#pragma tg_funcdef(shuffle, shuffle_tg, int2,  int2,  uint2)
#pragma tg_funcdef(shuffle, shuffle_tg, int2,  int3,  uint2)
#pragma tg_funcdef(shuffle, shuffle_tg, int2,  int4,  uint2)
#pragma tg_funcdef(shuffle, shuffle_tg, int2,  int8,  uint2)
#pragma tg_funcdef(shuffle, shuffle_tg, int2,  int16, uint2)

#pragma tg_funcdef(shuffle, shuffle_tg, int3,  int2,  uint3)
#pragma tg_funcdef(shuffle, shuffle_tg, int3,  int3,  uint3)
#pragma tg_funcdef(shuffle, shuffle_tg, int3,  int4,  uint3)
#pragma tg_funcdef(shuffle, shuffle_tg, int3,  int8,  uint3)
#pragma tg_funcdef(shuffle, shuffle_tg, int3,  int16, uint3)

#pragma tg_funcdef(shuffle, shuffle_tg, int4,  int2,  uint4)
#pragma tg_funcdef(shuffle, shuffle_tg, int4,  int3,  uint4)
#pragma tg_funcdef(shuffle, shuffle_tg, int4,  int4,  uint4)
#pragma tg_funcdef(shuffle, shuffle_tg, int4,  int8,  uint4)
#pragma tg_funcdef(shuffle, shuffle_tg, int4,  int16, uint4)

#pragma tg_funcdef(shuffle, shuffle_tg, int8,  int2,  uint8)
#pragma tg_funcdef(shuffle, shuffle_tg, int8,  int3,  uint8)
#pragma tg_funcdef(shuffle, shuffle_tg, int8,  int4,  uint8)
#pragma tg_funcdef(shuffle, shuffle_tg, int8,  int8,  uint8)
#pragma tg_funcdef(shuffle, shuffle_tg, int8,  int16, uint8)

#pragma tg_funcdef(shuffle, shuffle_tg, int16, int2,  uint16)
#pragma tg_funcdef(shuffle, shuffle_tg, int16, int3,  uint16)
#pragma tg_funcdef(shuffle, shuffle_tg, int16, int4,  uint16)
#pragma tg_funcdef(shuffle, shuffle_tg, int16, int8,  uint16)
#pragma tg_funcdef(shuffle, shuffle_tg, int16, int16, uint16)


#pragma tg_funcdef(shuffle, shuffle_tg, uint2,  uint2,  uint2)
#pragma tg_funcdef(shuffle, shuffle_tg, uint2,  uint3,  uint2)
#pragma tg_funcdef(shuffle, shuffle_tg, uint2,  uint4,  uint2)
#pragma tg_funcdef(shuffle, shuffle_tg, uint2,  uint8,  uint2)
#pragma tg_funcdef(shuffle, shuffle_tg, uint2,  uint16, uint2)

#pragma tg_funcdef(shuffle, shuffle_tg, uint3,  uint2,  uint3)
#pragma tg_funcdef(shuffle, shuffle_tg, uint3,  uint3,  uint3)
#pragma tg_funcdef(shuffle, shuffle_tg, uint3,  uint4,  uint3)
#pragma tg_funcdef(shuffle, shuffle_tg, uint3,  uint8,  uint3)
#pragma tg_funcdef(shuffle, shuffle_tg, uint3,  uint16, uint3)

#pragma tg_funcdef(shuffle, shuffle_tg, uint4,  uint2,  uint4)
#pragma tg_funcdef(shuffle, shuffle_tg, uint4,  uint3,  uint4)
#pragma tg_funcdef(shuffle, shuffle_tg, uint4,  uint4,  uint4)
#pragma tg_funcdef(shuffle, shuffle_tg, uint4,  uint8,  uint4)
#pragma tg_funcdef(shuffle, shuffle_tg, uint4,  uint16, uint4)

#pragma tg_funcdef(shuffle, shuffle_tg, uint8,  uint2,  uint8)
#pragma tg_funcdef(shuffle, shuffle_tg, uint8,  uint3,  uint8)
#pragma tg_funcdef(shuffle, shuffle_tg, uint8,  uint4,  uint8)
#pragma tg_funcdef(shuffle, shuffle_tg, uint8,  uint8,  uint8)
#pragma tg_funcdef(shuffle, shuffle_tg, uint8,  uint16, uint8)

#pragma tg_funcdef(shuffle, shuffle_tg, uint16, uint2,  uint16)
#pragma tg_funcdef(shuffle, shuffle_tg, uint16, uint3,  uint16)
#pragma tg_funcdef(shuffle, shuffle_tg, uint16, uint4,  uint16)
#pragma tg_funcdef(shuffle, shuffle_tg, uint16, uint8,  uint16)
#pragma tg_funcdef(shuffle, shuffle_tg, uint16, uint16, uint16)


#pragma tg_funcdef(shuffle, shuffle_tg, long2,  long2,  ulong2)
#pragma tg_funcdef(shuffle, shuffle_tg, long2,  long3,  ulong2)
#pragma tg_funcdef(shuffle, shuffle_tg, long2,  long4,  ulong2)
#pragma tg_funcdef(shuffle, shuffle_tg, long2,  long8,  ulong2)
#pragma tg_funcdef(shuffle, shuffle_tg, long2,  long16, ulong2)

#pragma tg_funcdef(shuffle, shuffle_tg, long3,  long2,  ulong3)
#pragma tg_funcdef(shuffle, shuffle_tg, long3,  long3,  ulong3)
#pragma tg_funcdef(shuffle, shuffle_tg, long3,  long4,  ulong3)
#pragma tg_funcdef(shuffle, shuffle_tg, long3,  long8,  ulong3)
#pragma tg_funcdef(shuffle, shuffle_tg, long3,  long16, ulong3)

#pragma tg_funcdef(shuffle, shuffle_tg, long4,  long2,  ulong4)
#pragma tg_funcdef(shuffle, shuffle_tg, long4,  long3,  ulong4)
#pragma tg_funcdef(shuffle, shuffle_tg, long4,  long4,  ulong4)
#pragma tg_funcdef(shuffle, shuffle_tg, long4,  long8,  ulong4)
#pragma tg_funcdef(shuffle, shuffle_tg, long4,  long16, ulong4)

#pragma tg_funcdef(shuffle, shuffle_tg, long8,  long2,  ulong8)
#pragma tg_funcdef(shuffle, shuffle_tg, long8,  long3,  ulong8)
#pragma tg_funcdef(shuffle, shuffle_tg, long8,  long4,  ulong8)
#pragma tg_funcdef(shuffle, shuffle_tg, long8,  long8,  ulong8)
#pragma tg_funcdef(shuffle, shuffle_tg, long8,  long16, ulong8)

#pragma tg_funcdef(shuffle, shuffle_tg, long16, long2,  ulong16)
#pragma tg_funcdef(shuffle, shuffle_tg, long16, long3,  ulong16)
#pragma tg_funcdef(shuffle, shuffle_tg, long16, long4,  ulong16)
#pragma tg_funcdef(shuffle, shuffle_tg, long16, long8,  ulong16)
#pragma tg_funcdef(shuffle, shuffle_tg, long16, long16, ulong16)


#pragma tg_funcdef(shuffle, shuffle_tg, ulong2,  ulong2,  ulong2)
#pragma tg_funcdef(shuffle, shuffle_tg, ulong2,  ulong3,  ulong2)
#pragma tg_funcdef(shuffle, shuffle_tg, ulong2,  ulong4,  ulong2)
#pragma tg_funcdef(shuffle, shuffle_tg, ulong2,  ulong8,  ulong2)
#pragma tg_funcdef(shuffle, shuffle_tg, ulong2,  ulong16, ulong2)

#pragma tg_funcdef(shuffle, shuffle_tg, ulong3,  ulong2,  ulong3)
#pragma tg_funcdef(shuffle, shuffle_tg, ulong3,  ulong3,  ulong3)
#pragma tg_funcdef(shuffle, shuffle_tg, ulong3,  ulong4,  ulong3)
#pragma tg_funcdef(shuffle, shuffle_tg, ulong3,  ulong8,  ulong3)
#pragma tg_funcdef(shuffle, shuffle_tg, ulong3,  ulong16, ulong3)

#pragma tg_funcdef(shuffle, shuffle_tg, ulong4,  ulong2,  ulong4)
#pragma tg_funcdef(shuffle, shuffle_tg, ulong4,  ulong3,  ulong4)
#pragma tg_funcdef(shuffle, shuffle_tg, ulong4,  ulong4,  ulong4)
#pragma tg_funcdef(shuffle, shuffle_tg, ulong4,  ulong8,  ulong4)
#pragma tg_funcdef(shuffle, shuffle_tg, ulong4,  ulong16, ulong4)

#pragma tg_funcdef(shuffle, shuffle_tg, ulong8,  ulong2,  ulong8)
#pragma tg_funcdef(shuffle, shuffle_tg, ulong8,  ulong3,  ulong8)
#pragma tg_funcdef(shuffle, shuffle_tg, ulong8,  ulong4,  ulong8)
#pragma tg_funcdef(shuffle, shuffle_tg, ulong8,  ulong8,  ulong8)
#pragma tg_funcdef(shuffle, shuffle_tg, ulong8,  ulong16, ulong8)

#pragma tg_funcdef(shuffle, shuffle_tg, ulong16, ulong2,  ulong16)
#pragma tg_funcdef(shuffle, shuffle_tg, ulong16, ulong3,  ulong16)
#pragma tg_funcdef(shuffle, shuffle_tg, ulong16, ulong4,  ulong16)
#pragma tg_funcdef(shuffle, shuffle_tg, ulong16, ulong8,  ulong16)
#pragma tg_funcdef(shuffle, shuffle_tg, ulong16, ulong16, ulong16)


#pragma tg_funcdef(shuffle, shuffle_tg, float2,  float2,  uint2)
#pragma tg_funcdef(shuffle, shuffle_tg, float2,  float3,  uint2)
#pragma tg_funcdef(shuffle, shuffle_tg, float2,  float4,  uint2)
#pragma tg_funcdef(shuffle, shuffle_tg, float2,  float8,  uint2)
#pragma tg_funcdef(shuffle, shuffle_tg, float2,  float16, uint2)

#pragma tg_funcdef(shuffle, shuffle_tg, float3,  float2,  uint3)
#pragma tg_funcdef(shuffle, shuffle_tg, float3,  float3,  uint3)
#pragma tg_funcdef(shuffle, shuffle_tg, float3,  float4,  uint3)
#pragma tg_funcdef(shuffle, shuffle_tg, float3,  float8,  uint3)
#pragma tg_funcdef(shuffle, shuffle_tg, float3,  float16, uint3)

#pragma tg_funcdef(shuffle, shuffle_tg, float4,  float2,  uint4)
#pragma tg_funcdef(shuffle, shuffle_tg, float4,  float3,  uint4)
#pragma tg_funcdef(shuffle, shuffle_tg, float4,  float4,  uint4)
#pragma tg_funcdef(shuffle, shuffle_tg, float4,  float8,  uint4)
#pragma tg_funcdef(shuffle, shuffle_tg, float4,  float16, uint4)

#pragma tg_funcdef(shuffle, shuffle_tg, float8,  float2,  uint8)
#pragma tg_funcdef(shuffle, shuffle_tg, float8,  float3,  uint8)
#pragma tg_funcdef(shuffle, shuffle_tg, float8,  float4,  uint8)
#pragma tg_funcdef(shuffle, shuffle_tg, float8,  float8,  uint8)
#pragma tg_funcdef(shuffle, shuffle_tg, float8,  float16, uint8)

#pragma tg_funcdef(shuffle, shuffle_tg, float16, float2,  uint16)
#pragma tg_funcdef(shuffle, shuffle_tg, float16, float3,  uint16)
#pragma tg_funcdef(shuffle, shuffle_tg, float16, float4,  uint16)
#pragma tg_funcdef(shuffle, shuffle_tg, float16, float8,  uint16)
#pragma tg_funcdef(shuffle, shuffle_tg, float16, float16, uint16)

 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(shuffle, shuffle_tg, double2,  double2,  ulong2)
#pragma tg_funcdef(shuffle, shuffle_tg, double2,  double3,  ulong2)
#pragma tg_funcdef(shuffle, shuffle_tg, double2,  double4,  ulong2)
#pragma tg_funcdef(shuffle, shuffle_tg, double2,  double8,  ulong2)
#pragma tg_funcdef(shuffle, shuffle_tg, double2,  double16, ulong2)

#pragma tg_funcdef(shuffle, shuffle_tg, double3,  double2,  ulong3)
#pragma tg_funcdef(shuffle, shuffle_tg, double3,  double3,  ulong3)
#pragma tg_funcdef(shuffle, shuffle_tg, double3,  double4,  ulong3)
#pragma tg_funcdef(shuffle, shuffle_tg, double3,  double8,  ulong3)
#pragma tg_funcdef(shuffle, shuffle_tg, double3,  double16, ulong3)

#pragma tg_funcdef(shuffle, shuffle_tg, double4,  double2,  ulong4)
#pragma tg_funcdef(shuffle, shuffle_tg, double4,  double3,  ulong4)
#pragma tg_funcdef(shuffle, shuffle_tg, double4,  double4,  ulong4)
#pragma tg_funcdef(shuffle, shuffle_tg, double4,  double8,  ulong4)
#pragma tg_funcdef(shuffle, shuffle_tg, double4,  double16, ulong4)

#pragma tg_funcdef(shuffle, shuffle_tg, double8,  double2,  ulong8)
#pragma tg_funcdef(shuffle, shuffle_tg, double8,  double3,  ulong8)
#pragma tg_funcdef(shuffle, shuffle_tg, double8,  double4,  ulong8)
#pragma tg_funcdef(shuffle, shuffle_tg, double8,  double8,  ulong8)
#pragma tg_funcdef(shuffle, shuffle_tg, double8,  double16, ulong8)

#pragma tg_funcdef(shuffle, shuffle_tg, double16, double2,  ulong16)
#pragma tg_funcdef(shuffle, shuffle_tg, double16, double3,  ulong16)
#pragma tg_funcdef(shuffle, shuffle_tg, double16, double4,  ulong16)
#pragma tg_funcdef(shuffle, shuffle_tg, double16, double8,  ulong16)
#pragma tg_funcdef(shuffle, shuffle_tg, double16, double16, ulong16)
 #endif

#undef shuffle
#define shuffle(__a,__b) __tg_builtin_gentype("shuffle",__a,__b)

/* shuffle2 */
#pragma tg_funcdef(shuffle2, shuffle2_tg, char2,  char2,  char2,  uchar2)
#pragma tg_funcdef(shuffle2, shuffle2_tg, char3,  char2,  char2,  uchar3)
#pragma tg_funcdef(shuffle2, shuffle2_tg, char4,  char2,  char2,  uchar4)
#pragma tg_funcdef(shuffle2, shuffle2_tg, char8,  char2,  char2,  uchar8)
#pragma tg_funcdef(shuffle2, shuffle2_tg, char16, char2,  char2,  uchar16)

#pragma tg_funcdef(shuffle2, shuffle2_tg, char2,  char3,  char3,  uchar2)
#pragma tg_funcdef(shuffle2, shuffle2_tg, char3,  char3,  char3,  uchar3)
#pragma tg_funcdef(shuffle2, shuffle2_tg, char4,  char3,  char3,  uchar4)
#pragma tg_funcdef(shuffle2, shuffle2_tg, char8,  char3,  char3,  uchar8)
#pragma tg_funcdef(shuffle2, shuffle2_tg, char16, char3,  char3,  uchar16)

#pragma tg_funcdef(shuffle2, shuffle2_tg, char2,  char4,  char4,  uchar2)
#pragma tg_funcdef(shuffle2, shuffle2_tg, char3,  char4,  char4,  uchar3)
#pragma tg_funcdef(shuffle2, shuffle2_tg, char4,  char4,  char4,  uchar4)
#pragma tg_funcdef(shuffle2, shuffle2_tg, char8,  char4,  char4,  uchar8)
#pragma tg_funcdef(shuffle2, shuffle2_tg, char16, char4,  char4,  uchar16)

#pragma tg_funcdef(shuffle2, shuffle2_tg, char2,  char8,  char8,  uchar2)
#pragma tg_funcdef(shuffle2, shuffle2_tg, char3,  char8,  char8,  uchar3)
#pragma tg_funcdef(shuffle2, shuffle2_tg, char4,  char8,  char8,  uchar4)
#pragma tg_funcdef(shuffle2, shuffle2_tg, char8,  char8,  char8,  uchar8)
#pragma tg_funcdef(shuffle2, shuffle2_tg, char16, char8,  char8,  uchar16)

#pragma tg_funcdef(shuffle2, shuffle2_tg, char2,  char16, char16, uchar2)
#pragma tg_funcdef(shuffle2, shuffle2_tg, char3,  char16, char16, uchar3)
#pragma tg_funcdef(shuffle2, shuffle2_tg, char4,  char16, char16, uchar4)
#pragma tg_funcdef(shuffle2, shuffle2_tg, char8,  char16, char16, uchar8)
#pragma tg_funcdef(shuffle2, shuffle2_tg, char16, char16, char16, uchar16)


#pragma tg_funcdef(shuffle2, shuffle2_tg, uchar2,  uchar2,  uchar2,  uchar2)
#pragma tg_funcdef(shuffle2, shuffle2_tg, uchar3,  uchar2,  uchar2,  uchar3)
#pragma tg_funcdef(shuffle2, shuffle2_tg, uchar4,  uchar2,  uchar2,  uchar4)
#pragma tg_funcdef(shuffle2, shuffle2_tg, uchar8,  uchar2,  uchar2,  uchar8)
#pragma tg_funcdef(shuffle2, shuffle2_tg, uchar16, uchar2,  uchar2,  uchar16)

#pragma tg_funcdef(shuffle2, shuffle2_tg, uchar2,  uchar3,  uchar3,  uchar2)
#pragma tg_funcdef(shuffle2, shuffle2_tg, uchar3,  uchar3,  uchar3,  uchar3)
#pragma tg_funcdef(shuffle2, shuffle2_tg, uchar4,  uchar3,  uchar3,  uchar4)
#pragma tg_funcdef(shuffle2, shuffle2_tg, uchar8,  uchar3,  uchar3,  uchar8)
#pragma tg_funcdef(shuffle2, shuffle2_tg, uchar16, uchar3,  uchar3,  uchar16)

#pragma tg_funcdef(shuffle2, shuffle2_tg, uchar2,  uchar4,  uchar4,  uchar2)
#pragma tg_funcdef(shuffle2, shuffle2_tg, uchar3,  uchar4,  uchar4,  uchar3)
#pragma tg_funcdef(shuffle2, shuffle2_tg, uchar4,  uchar4,  uchar4,  uchar4)
#pragma tg_funcdef(shuffle2, shuffle2_tg, uchar8,  uchar4,  uchar4,  uchar8)
#pragma tg_funcdef(shuffle2, shuffle2_tg, uchar16, uchar4,  uchar4,  uchar16)

#pragma tg_funcdef(shuffle2, shuffle2_tg, uchar2,  uchar8,  uchar8,  uchar2)
#pragma tg_funcdef(shuffle2, shuffle2_tg, uchar3,  uchar8,  uchar8,  uchar3)
#pragma tg_funcdef(shuffle2, shuffle2_tg, uchar4,  uchar8,  uchar8,  uchar4)
#pragma tg_funcdef(shuffle2, shuffle2_tg, uchar8,  uchar8,  uchar8,  uchar8)
#pragma tg_funcdef(shuffle2, shuffle2_tg, uchar16, uchar8,  uchar8,  uchar16)

#pragma tg_funcdef(shuffle2, shuffle2_tg, uchar2,  uchar16, uchar16, uchar2)
#pragma tg_funcdef(shuffle2, shuffle2_tg, uchar3,  uchar16, uchar16, uchar3)
#pragma tg_funcdef(shuffle2, shuffle2_tg, uchar4,  uchar16, uchar16, uchar4)
#pragma tg_funcdef(shuffle2, shuffle2_tg, uchar8,  uchar16, uchar16, uchar8)
#pragma tg_funcdef(shuffle2, shuffle2_tg, uchar16, uchar16, uchar16, uchar16)


#pragma tg_funcdef(shuffle2, shuffle2_tg, short2,  short2,  short2,  ushort2)
#pragma tg_funcdef(shuffle2, shuffle2_tg, short3,  short2,  short2,  ushort3)
#pragma tg_funcdef(shuffle2, shuffle2_tg, short4,  short2,  short2,  ushort4)
#pragma tg_funcdef(shuffle2, shuffle2_tg, short8,  short2,  short2,  ushort8)
#pragma tg_funcdef(shuffle2, shuffle2_tg, short16, short2,  short2,  ushort16)

#pragma tg_funcdef(shuffle2, shuffle2_tg, short2,  short3,  short3,  ushort2)
#pragma tg_funcdef(shuffle2, shuffle2_tg, short3,  short3,  short3,  ushort3)
#pragma tg_funcdef(shuffle2, shuffle2_tg, short4,  short3,  short3,  ushort4)
#pragma tg_funcdef(shuffle2, shuffle2_tg, short8,  short3,  short3,  ushort8)
#pragma tg_funcdef(shuffle2, shuffle2_tg, short16, short3,  short3,  ushort16)

#pragma tg_funcdef(shuffle2, shuffle2_tg, short2,  short4,  short4,  ushort2)
#pragma tg_funcdef(shuffle2, shuffle2_tg, short3,  short4,  short4,  ushort3)
#pragma tg_funcdef(shuffle2, shuffle2_tg, short4,  short4,  short4,  ushort4)
#pragma tg_funcdef(shuffle2, shuffle2_tg, short8,  short4,  short4,  ushort8)
#pragma tg_funcdef(shuffle2, shuffle2_tg, short16, short4,  short4,  ushort16)

#pragma tg_funcdef(shuffle2, shuffle2_tg, short2,  short8,  short8,  ushort2)
#pragma tg_funcdef(shuffle2, shuffle2_tg, short3,  short8,  short8,  ushort3)
#pragma tg_funcdef(shuffle2, shuffle2_tg, short4,  short8,  short8,  ushort4)
#pragma tg_funcdef(shuffle2, shuffle2_tg, short8,  short8,  short8,  ushort8)
#pragma tg_funcdef(shuffle2, shuffle2_tg, short16, short8,  short8,  ushort16)

#pragma tg_funcdef(shuffle2, shuffle2_tg, short2,  short16, short16, ushort2)
#pragma tg_funcdef(shuffle2, shuffle2_tg, short3,  short16, short16, ushort3)
#pragma tg_funcdef(shuffle2, shuffle2_tg, short4,  short16, short16, ushort4)
#pragma tg_funcdef(shuffle2, shuffle2_tg, short8,  short16, short16, ushort8)
#pragma tg_funcdef(shuffle2, shuffle2_tg, short16, short16, short16, ushort16)


#pragma tg_funcdef(shuffle2, shuffle2_tg, ushort2,  ushort2,  ushort2,  ushort2)
#pragma tg_funcdef(shuffle2, shuffle2_tg, ushort3,  ushort2,  ushort2,  ushort3)
#pragma tg_funcdef(shuffle2, shuffle2_tg, ushort4,  ushort2,  ushort2,  ushort4)
#pragma tg_funcdef(shuffle2, shuffle2_tg, ushort8,  ushort2,  ushort2,  ushort8)
#pragma tg_funcdef(shuffle2, shuffle2_tg, ushort16, ushort2,  ushort2,  ushort16)

#pragma tg_funcdef(shuffle2, shuffle2_tg, ushort2,  ushort3,  ushort3,  ushort2)
#pragma tg_funcdef(shuffle2, shuffle2_tg, ushort3,  ushort3,  ushort3,  ushort3)
#pragma tg_funcdef(shuffle2, shuffle2_tg, ushort4,  ushort3,  ushort3,  ushort4)
#pragma tg_funcdef(shuffle2, shuffle2_tg, ushort8,  ushort3,  ushort3,  ushort8)
#pragma tg_funcdef(shuffle2, shuffle2_tg, ushort16, ushort3,  ushort3,  ushort16)

#pragma tg_funcdef(shuffle2, shuffle2_tg, ushort2,  ushort4,  ushort4,  ushort2)
#pragma tg_funcdef(shuffle2, shuffle2_tg, ushort3,  ushort4,  ushort4,  ushort3)
#pragma tg_funcdef(shuffle2, shuffle2_tg, ushort4,  ushort4,  ushort4,  ushort4)
#pragma tg_funcdef(shuffle2, shuffle2_tg, ushort8,  ushort4,  ushort4,  ushort8)
#pragma tg_funcdef(shuffle2, shuffle2_tg, ushort16, ushort4,  ushort4,  ushort16)

#pragma tg_funcdef(shuffle2, shuffle2_tg, ushort2,  ushort8,  ushort8,  ushort2)
#pragma tg_funcdef(shuffle2, shuffle2_tg, ushort3,  ushort8,  ushort8,  ushort3)
#pragma tg_funcdef(shuffle2, shuffle2_tg, ushort4,  ushort8,  ushort8,  ushort4)
#pragma tg_funcdef(shuffle2, shuffle2_tg, ushort8,  ushort8,  ushort8,  ushort8)
#pragma tg_funcdef(shuffle2, shuffle2_tg, ushort16, ushort8,  ushort8,  ushort16)

#pragma tg_funcdef(shuffle2, shuffle2_tg, ushort2,  ushort16, ushort16, ushort2)
#pragma tg_funcdef(shuffle2, shuffle2_tg, ushort3,  ushort16, ushort16, ushort3)
#pragma tg_funcdef(shuffle2, shuffle2_tg, ushort4,  ushort16, ushort16, ushort4)
#pragma tg_funcdef(shuffle2, shuffle2_tg, ushort8,  ushort16, ushort16, ushort8)
#pragma tg_funcdef(shuffle2, shuffle2_tg, ushort16, ushort16, ushort16, ushort16)


#pragma tg_funcdef(shuffle2, shuffle2_tg, int2,  int2,  int2,  uint2)
#pragma tg_funcdef(shuffle2, shuffle2_tg, int3,  int2,  int2,  uint3)
#pragma tg_funcdef(shuffle2, shuffle2_tg, int4,  int2,  int2,  uint4)
#pragma tg_funcdef(shuffle2, shuffle2_tg, int8,  int2,  int2,  uint8)
#pragma tg_funcdef(shuffle2, shuffle2_tg, int16, int2,  int2,  uint16)

#pragma tg_funcdef(shuffle2, shuffle2_tg, int2,  int3,  int3,  uint2)
#pragma tg_funcdef(shuffle2, shuffle2_tg, int3,  int3,  int3,  uint3)
#pragma tg_funcdef(shuffle2, shuffle2_tg, int4,  int3,  int3,  uint4)
#pragma tg_funcdef(shuffle2, shuffle2_tg, int8,  int3,  int3,  uint8)
#pragma tg_funcdef(shuffle2, shuffle2_tg, int16, int3,  int3,  uint16)

#pragma tg_funcdef(shuffle2, shuffle2_tg, int2,  int4,  int4,  uint2)
#pragma tg_funcdef(shuffle2, shuffle2_tg, int3,  int4,  int4,  uint3)
#pragma tg_funcdef(shuffle2, shuffle2_tg, int4,  int4,  int4,  uint4)
#pragma tg_funcdef(shuffle2, shuffle2_tg, int8,  int4,  int4,  uint8)
#pragma tg_funcdef(shuffle2, shuffle2_tg, int16, int4,  int4,  uint16)

#pragma tg_funcdef(shuffle2, shuffle2_tg, int2,  int8,  int8,  uint2)
#pragma tg_funcdef(shuffle2, shuffle2_tg, int3,  int8,  int8,  uint3)
#pragma tg_funcdef(shuffle2, shuffle2_tg, int4,  int8,  int8,  uint4)
#pragma tg_funcdef(shuffle2, shuffle2_tg, int8,  int8,  int8,  uint8)
#pragma tg_funcdef(shuffle2, shuffle2_tg, int16, int8,  int8,  uint16)

#pragma tg_funcdef(shuffle2, shuffle2_tg, int2,  int16, int16, uint2)
#pragma tg_funcdef(shuffle2, shuffle2_tg, int3,  int16, int16, uint3)
#pragma tg_funcdef(shuffle2, shuffle2_tg, int4,  int16, int16, uint4)
#pragma tg_funcdef(shuffle2, shuffle2_tg, int8,  int16, int16, uint8)
#pragma tg_funcdef(shuffle2, shuffle2_tg, int16, int16, int16, uint16)


#pragma tg_funcdef(shuffle2, shuffle2_tg, uint2,  uint2,  uint2,  uint2)
#pragma tg_funcdef(shuffle2, shuffle2_tg, uint3,  uint2,  uint2,  uint3)
#pragma tg_funcdef(shuffle2, shuffle2_tg, uint4,  uint2,  uint2,  uint4)
#pragma tg_funcdef(shuffle2, shuffle2_tg, uint8,  uint2,  uint2,  uint8)
#pragma tg_funcdef(shuffle2, shuffle2_tg, uint16, uint2,  uint2,  uint16)

#pragma tg_funcdef(shuffle2, shuffle2_tg, uint2,  uint3,  uint3,  uint2)
#pragma tg_funcdef(shuffle2, shuffle2_tg, uint3,  uint3,  uint3,  uint3)
#pragma tg_funcdef(shuffle2, shuffle2_tg, uint4,  uint3,  uint3,  uint4)
#pragma tg_funcdef(shuffle2, shuffle2_tg, uint8,  uint3,  uint3,  uint8)
#pragma tg_funcdef(shuffle2, shuffle2_tg, uint16, uint3,  uint3,  uint16)

#pragma tg_funcdef(shuffle2, shuffle2_tg, uint2,  uint4,  uint4,  uint2)
#pragma tg_funcdef(shuffle2, shuffle2_tg, uint3,  uint4,  uint4,  uint3)
#pragma tg_funcdef(shuffle2, shuffle2_tg, uint4,  uint4,  uint4,  uint4)
#pragma tg_funcdef(shuffle2, shuffle2_tg, uint8,  uint4,  uint4,  uint8)
#pragma tg_funcdef(shuffle2, shuffle2_tg, uint16, uint4,  uint4,  uint16)

#pragma tg_funcdef(shuffle2, shuffle2_tg, uint2,  uint8,  uint8,  uint2)
#pragma tg_funcdef(shuffle2, shuffle2_tg, uint3,  uint8,  uint8,  uint3)
#pragma tg_funcdef(shuffle2, shuffle2_tg, uint4,  uint8,  uint8,  uint4)
#pragma tg_funcdef(shuffle2, shuffle2_tg, uint8,  uint8,  uint8,  uint8)
#pragma tg_funcdef(shuffle2, shuffle2_tg, uint16, uint8,  uint8,  uint16)

#pragma tg_funcdef(shuffle2, shuffle2_tg, uint2,  uint16, uint16, uint2)
#pragma tg_funcdef(shuffle2, shuffle2_tg, uint3,  uint16, uint16, uint3)
#pragma tg_funcdef(shuffle2, shuffle2_tg, uint4,  uint16, uint16, uint4)
#pragma tg_funcdef(shuffle2, shuffle2_tg, uint8,  uint16, uint16, uint8)
#pragma tg_funcdef(shuffle2, shuffle2_tg, uint16, uint16, uint16, uint16)


#pragma tg_funcdef(shuffle2, shuffle2_tg, long2,  long2,  long2,  ulong2)
#pragma tg_funcdef(shuffle2, shuffle2_tg, long3,  long2,  long2,  ulong3)
#pragma tg_funcdef(shuffle2, shuffle2_tg, long4,  long2,  long2,  ulong4)
#pragma tg_funcdef(shuffle2, shuffle2_tg, long8,  long2,  long2,  ulong8)
#pragma tg_funcdef(shuffle2, shuffle2_tg, long16, long2,  long2,  ulong16)

#pragma tg_funcdef(shuffle2, shuffle2_tg, long2,  long3,  long3,  ulong2)
#pragma tg_funcdef(shuffle2, shuffle2_tg, long3,  long3,  long3,  ulong3)
#pragma tg_funcdef(shuffle2, shuffle2_tg, long4,  long3,  long3,  ulong4)
#pragma tg_funcdef(shuffle2, shuffle2_tg, long8,  long3,  long3,  ulong8)
#pragma tg_funcdef(shuffle2, shuffle2_tg, long16, long3,  long3,  ulong16)

#pragma tg_funcdef(shuffle2, shuffle2_tg, long2,  long4,  long4,  ulong2)
#pragma tg_funcdef(shuffle2, shuffle2_tg, long3,  long4,  long4,  ulong3)
#pragma tg_funcdef(shuffle2, shuffle2_tg, long4,  long4,  long4,  ulong4)
#pragma tg_funcdef(shuffle2, shuffle2_tg, long8,  long4,  long4,  ulong8)
#pragma tg_funcdef(shuffle2, shuffle2_tg, long16, long4,  long4,  ulong16)

#pragma tg_funcdef(shuffle2, shuffle2_tg, long2,  long8,  long8,  ulong2)
#pragma tg_funcdef(shuffle2, shuffle2_tg, long3,  long8,  long8,  ulong3)
#pragma tg_funcdef(shuffle2, shuffle2_tg, long4,  long8,  long8,  ulong4)
#pragma tg_funcdef(shuffle2, shuffle2_tg, long8,  long8,  long8,  ulong8)
#pragma tg_funcdef(shuffle2, shuffle2_tg, long16, long8,  long8,  ulong16)

#pragma tg_funcdef(shuffle2, shuffle2_tg, long2,  long16, long16, ulong2)
#pragma tg_funcdef(shuffle2, shuffle2_tg, long3,  long16, long16, ulong3)
#pragma tg_funcdef(shuffle2, shuffle2_tg, long4,  long16, long16, ulong4)
#pragma tg_funcdef(shuffle2, shuffle2_tg, long8,  long16, long16, ulong8)
#pragma tg_funcdef(shuffle2, shuffle2_tg, long16, long16, long16, ulong16)


#pragma tg_funcdef(shuffle2, shuffle2_tg, ulong2,  ulong2,  ulong2,  ulong2)
#pragma tg_funcdef(shuffle2, shuffle2_tg, ulong3,  ulong2,  ulong2,  ulong3)
#pragma tg_funcdef(shuffle2, shuffle2_tg, ulong4,  ulong2,  ulong2,  ulong4)
#pragma tg_funcdef(shuffle2, shuffle2_tg, ulong8,  ulong2,  ulong2,  ulong8)
#pragma tg_funcdef(shuffle2, shuffle2_tg, ulong16, ulong2,  ulong2,  ulong16)

#pragma tg_funcdef(shuffle2, shuffle2_tg, ulong2,  ulong3,  ulong3,  ulong2)
#pragma tg_funcdef(shuffle2, shuffle2_tg, ulong3,  ulong3,  ulong3,  ulong3)
#pragma tg_funcdef(shuffle2, shuffle2_tg, ulong4,  ulong3,  ulong3,  ulong4)
#pragma tg_funcdef(shuffle2, shuffle2_tg, ulong8,  ulong3,  ulong3,  ulong8)
#pragma tg_funcdef(shuffle2, shuffle2_tg, ulong16, ulong3,  ulong3,  ulong16)

#pragma tg_funcdef(shuffle2, shuffle2_tg, ulong2,  ulong4,  ulong4,  ulong2)
#pragma tg_funcdef(shuffle2, shuffle2_tg, ulong3,  ulong4,  ulong4,  ulong3)
#pragma tg_funcdef(shuffle2, shuffle2_tg, ulong4,  ulong4,  ulong4,  ulong4)
#pragma tg_funcdef(shuffle2, shuffle2_tg, ulong8,  ulong4,  ulong4,  ulong8)
#pragma tg_funcdef(shuffle2, shuffle2_tg, ulong16, ulong4,  ulong4,  ulong16)

#pragma tg_funcdef(shuffle2, shuffle2_tg, ulong2,  ulong8,  ulong8,  ulong2)
#pragma tg_funcdef(shuffle2, shuffle2_tg, ulong3,  ulong8,  ulong8,  ulong3)
#pragma tg_funcdef(shuffle2, shuffle2_tg, ulong4,  ulong8,  ulong8,  ulong4)
#pragma tg_funcdef(shuffle2, shuffle2_tg, ulong8,  ulong8,  ulong8,  ulong8)
#pragma tg_funcdef(shuffle2, shuffle2_tg, ulong16, ulong8,  ulong8,  ulong16)

#pragma tg_funcdef(shuffle2, shuffle2_tg, ulong2,  ulong16, ulong16, ulong2)
#pragma tg_funcdef(shuffle2, shuffle2_tg, ulong3,  ulong16, ulong16, ulong3)
#pragma tg_funcdef(shuffle2, shuffle2_tg, ulong4,  ulong16, ulong16, ulong4)
#pragma tg_funcdef(shuffle2, shuffle2_tg, ulong8,  ulong16, ulong16, ulong8)
#pragma tg_funcdef(shuffle2, shuffle2_tg, ulong16, ulong16, ulong16, ulong16)


#pragma tg_funcdef(shuffle2, shuffle2_tg, float2,  float2,  float2,  uint2)
#pragma tg_funcdef(shuffle2, shuffle2_tg, float3,  float2,  float2,  uint3)
#pragma tg_funcdef(shuffle2, shuffle2_tg, float4,  float2,  float2,  uint4)
#pragma tg_funcdef(shuffle2, shuffle2_tg, float8,  float2,  float2,  uint8)
#pragma tg_funcdef(shuffle2, shuffle2_tg, float16, float2,  float2,  uint16)

#pragma tg_funcdef(shuffle2, shuffle2_tg, float2,  float3,  float3,  uint2)
#pragma tg_funcdef(shuffle2, shuffle2_tg, float3,  float3,  float3,  uint3)
#pragma tg_funcdef(shuffle2, shuffle2_tg, float4,  float3,  float3,  uint4)
#pragma tg_funcdef(shuffle2, shuffle2_tg, float8,  float3,  float3,  uint8)
#pragma tg_funcdef(shuffle2, shuffle2_tg, float16, float3,  float3,  uint16)

#pragma tg_funcdef(shuffle2, shuffle2_tg, float2,  float4,  float4,  uint2)
#pragma tg_funcdef(shuffle2, shuffle2_tg, float3,  float4,  float4,  uint3)
#pragma tg_funcdef(shuffle2, shuffle2_tg, float4,  float4,  float4,  uint4)
#pragma tg_funcdef(shuffle2, shuffle2_tg, float8,  float4,  float4,  uint8)
#pragma tg_funcdef(shuffle2, shuffle2_tg, float16, float4,  float4,  uint16)

#pragma tg_funcdef(shuffle2, shuffle2_tg, float2,  float8,  float8,  uint2)
#pragma tg_funcdef(shuffle2, shuffle2_tg, float3,  float8,  float8,  uint3)
#pragma tg_funcdef(shuffle2, shuffle2_tg, float4,  float8,  float8,  uint4)
#pragma tg_funcdef(shuffle2, shuffle2_tg, float8,  float8,  float8,  uint8)
#pragma tg_funcdef(shuffle2, shuffle2_tg, float16, float8,  float8,  uint16)

#pragma tg_funcdef(shuffle2, shuffle2_tg, float2,  float16, float16, uint2)
#pragma tg_funcdef(shuffle2, shuffle2_tg, float3,  float16, float16, uint3)
#pragma tg_funcdef(shuffle2, shuffle2_tg, float4,  float16, float16, uint4)
#pragma tg_funcdef(shuffle2, shuffle2_tg, float8,  float16, float16, uint8)
#pragma tg_funcdef(shuffle2, shuffle2_tg, float16, float16, float16, uint16)

 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(shuffle2, shuffle2_tg, double2,  double2,  double2,  ulong2)
#pragma tg_funcdef(shuffle2, shuffle2_tg, double3,  double2,  double2,  ulong3)
#pragma tg_funcdef(shuffle2, shuffle2_tg, double4,  double2,  double2,  ulong4)
#pragma tg_funcdef(shuffle2, shuffle2_tg, double8,  double2,  double2,  ulong8)
#pragma tg_funcdef(shuffle2, shuffle2_tg, double16, double2,  double2,  ulong16)

#pragma tg_funcdef(shuffle2, shuffle2_tg, double2,  double3,  double3,  ulong2)
#pragma tg_funcdef(shuffle2, shuffle2_tg, double3,  double3,  double3,  ulong3)
#pragma tg_funcdef(shuffle2, shuffle2_tg, double4,  double3,  double3,  ulong4)
#pragma tg_funcdef(shuffle2, shuffle2_tg, double8,  double3,  double3,  ulong8)
#pragma tg_funcdef(shuffle2, shuffle2_tg, double16, double3,  double3,  ulong16)

#pragma tg_funcdef(shuffle2, shuffle2_tg, double2,  double4,  double4,  ulong2)
#pragma tg_funcdef(shuffle2, shuffle2_tg, double3,  double4,  double4,  ulong3)
#pragma tg_funcdef(shuffle2, shuffle2_tg, double4,  double4,  double4,  ulong4)
#pragma tg_funcdef(shuffle2, shuffle2_tg, double8,  double4,  double4,  ulong8)
#pragma tg_funcdef(shuffle2, shuffle2_tg, double16, double4,  double4,  ulong16)

#pragma tg_funcdef(shuffle2, shuffle2_tg, double2,  double8,  double8,  ulong2)
#pragma tg_funcdef(shuffle2, shuffle2_tg, double3,  double8,  double8,  ulong3)
#pragma tg_funcdef(shuffle2, shuffle2_tg, double4,  double8,  double8,  ulong4)
#pragma tg_funcdef(shuffle2, shuffle2_tg, double8,  double8,  double8,  ulong8)
#pragma tg_funcdef(shuffle2, shuffle2_tg, double16, double8,  double8,  ulong16)

#pragma tg_funcdef(shuffle2, shuffle2_tg, double2,  double16, double16, ulong2)
#pragma tg_funcdef(shuffle2, shuffle2_tg, double3,  double16, double16, ulong3)
#pragma tg_funcdef(shuffle2, shuffle2_tg, double4,  double16, double16, ulong4)
#pragma tg_funcdef(shuffle2, shuffle2_tg, double8,  double16, double16, ulong8)
#pragma tg_funcdef(shuffle2, shuffle2_tg, double16, double16, double16, ulong16)
 #endif

#undef shuffle2
#define shuffle2(__a,__b,__c) __tg_builtin_gentype("shuffle2",__a,__b,__c)

/* 6.2.3 Explicit Conversions */

/* convert_charN<_sat><_roundingMode> */

#pragma tg_funcdef(convert_char, convert_tg, char, char,   int, int)
#pragma tg_funcdef(convert_char, convert_tg, char, uchar,  int, int)
#pragma tg_funcdef(convert_char, convert_tg, char, short,  int, int)
#pragma tg_funcdef(convert_char, convert_tg, char, ushort, int, int)
#pragma tg_funcdef(convert_char, convert_tg, char, int,    int, int)
#pragma tg_funcdef(convert_char, convert_tg, char, uint,   int, int)
#pragma tg_funcdef(convert_char, convert_tg, char, long,   int, int)
#pragma tg_funcdef(convert_char, convert_tg, char, ulong,  int, int)
#pragma tg_funcdef(convert_char, convert_tg, char, float,  int, int)
#pragma tg_funcdef(convert_char, convert_tg, char, double, int, int)
#undef convert_char
#undef convert_char_rte
#undef convert_char_rtz
#undef convert_char_rtp
#undef convert_char_rtn
#undef convert_char_sat
#undef convert_char_sat_rte
#undef convert_char_sat_rtz
#undef convert_char_sat_rtp
#undef convert_char_sat_rtn
#define convert_char(__a)         __tg_builtin_gentype("convert_char",__a,0,0)
#define convert_char_rte(__a)     __tg_builtin_gentype("convert_char",__a,0,1)
#define convert_char_rtz(__a)     __tg_builtin_gentype("convert_char",__a,0,2)
#define convert_char_rtp(__a)     __tg_builtin_gentype("convert_char",__a,0,3)
#define convert_char_rtn(__a)     __tg_builtin_gentype("convert_char",__a,0,4)
#define convert_char_sat(__a)     __tg_builtin_gentype("convert_char",__a,1,0)
#define convert_char_sat_rte(__a) __tg_builtin_gentype("convert_char",__a,1,1)
#define convert_char_sat_rtz(__a) __tg_builtin_gentype("convert_char",__a,1,2)
#define convert_char_sat_rtp(__a) __tg_builtin_gentype("convert_char",__a,1,3)
#define convert_char_sat_rtn(__a) __tg_builtin_gentype("convert_char",__a,1,4)

#pragma tg_funcdef(convert_char2, convert_tg, char2, char2,   int, int)
#pragma tg_funcdef(convert_char2, convert_tg, char2, uchar2,  int, int)
#pragma tg_funcdef(convert_char2, convert_tg, char2, short2,  int, int)
#pragma tg_funcdef(convert_char2, convert_tg, char2, ushort2, int, int)
#pragma tg_funcdef(convert_char2, convert_tg, char2, int2,    int, int)
#pragma tg_funcdef(convert_char2, convert_tg, char2, uint2,   int, int)
#pragma tg_funcdef(convert_char2, convert_tg, char2, long2,   int, int)
#pragma tg_funcdef(convert_char2, convert_tg, char2, ulong2,  int, int)
#pragma tg_funcdef(convert_char2, convert_tg, char2, float2,  int, int)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(convert_char2, convert_tg, char2, double2, int, int)
 #endif
#undef convert_char2
#undef convert_char2_rte
#undef convert_char2_rtz
#undef convert_char2_rtp
#undef convert_char2_rtn
#undef convert_char2_sat
#undef convert_char2_sat_rte
#undef convert_char2_sat_rtz
#undef convert_char2_sat_rtp
#undef convert_char2_sat_rtn
#define convert_char2(__a)         __tg_builtin_gentype("convert_char2",__a,0,0)
#define convert_char2_rte(__a)     __tg_builtin_gentype("convert_char2",__a,0,1)
#define convert_char2_rtz(__a)     __tg_builtin_gentype("convert_char2",__a,0,2)
#define convert_char2_rtp(__a)     __tg_builtin_gentype("convert_char2",__a,0,3)
#define convert_char2_rtn(__a)     __tg_builtin_gentype("convert_char2",__a,0,4)
#define convert_char2_sat(__a)     __tg_builtin_gentype("convert_char2",__a,1,0)
#define convert_char2_sat_rte(__a) __tg_builtin_gentype("convert_char2",__a,1,1)
#define convert_char2_sat_rtz(__a) __tg_builtin_gentype("convert_char2",__a,1,2)
#define convert_char2_sat_rtp(__a) __tg_builtin_gentype("convert_char2",__a,1,3)
#define convert_char2_sat_rtn(__a) __tg_builtin_gentype("convert_char2",__a,1,4)

#pragma tg_funcdef(convert_char3, convert_tg, char3, char3,   int, int)
#pragma tg_funcdef(convert_char3, convert_tg, char3, uchar3,  int, int)
#pragma tg_funcdef(convert_char3, convert_tg, char3, short3,  int, int)
#pragma tg_funcdef(convert_char3, convert_tg, char3, ushort3, int, int)
#pragma tg_funcdef(convert_char3, convert_tg, char3, int3,    int, int)
#pragma tg_funcdef(convert_char3, convert_tg, char3, uint3,   int, int)
#pragma tg_funcdef(convert_char3, convert_tg, char3, long3,   int, int)
#pragma tg_funcdef(convert_char3, convert_tg, char3, ulong3,  int, int)
#pragma tg_funcdef(convert_char3, convert_tg, char3, float3,  int, int)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(convert_char3, convert_tg, char3, double3, int, int)
 #endif
#undef convert_char3
#undef convert_char3_rte
#undef convert_char3_rtz
#undef convert_char3_rtp
#undef convert_char3_rtn
#undef convert_char3_sat
#undef convert_char3_sat_rte
#undef convert_char3_sat_rtz
#undef convert_char3_sat_rtp
#undef convert_char3_sat_rtn
#define convert_char3(__a)         __tg_builtin_gentype("convert_char3",__a,0,0)
#define convert_char3_rte(__a)     __tg_builtin_gentype("convert_char3",__a,0,1)
#define convert_char3_rtz(__a)     __tg_builtin_gentype("convert_char3",__a,0,2)
#define convert_char3_rtp(__a)     __tg_builtin_gentype("convert_char3",__a,0,3)
#define convert_char3_rtn(__a)     __tg_builtin_gentype("convert_char3",__a,0,4)
#define convert_char3_sat(__a)     __tg_builtin_gentype("convert_char3",__a,1,0)
#define convert_char3_sat_rte(__a) __tg_builtin_gentype("convert_char3",__a,1,1)
#define convert_char3_sat_rtz(__a) __tg_builtin_gentype("convert_char3",__a,1,2)
#define convert_char3_sat_rtp(__a) __tg_builtin_gentype("convert_char3",__a,1,3)
#define convert_char3_sat_rtn(__a) __tg_builtin_gentype("convert_char3",__a,1,4)

#pragma tg_funcdef(convert_char4, convert_tg, char4, char4,   int, int)
#pragma tg_funcdef(convert_char4, convert_tg, char4, uchar4,  int, int)
#pragma tg_funcdef(convert_char4, convert_tg, char4, short4,  int, int)
#pragma tg_funcdef(convert_char4, convert_tg, char4, ushort4, int, int)
#pragma tg_funcdef(convert_char4, convert_tg, char4, int4,    int, int)
#pragma tg_funcdef(convert_char4, convert_tg, char4, uint4,   int, int)
#pragma tg_funcdef(convert_char4, convert_tg, char4, long4,   int, int)
#pragma tg_funcdef(convert_char4, convert_tg, char4, ulong4,  int, int)
#pragma tg_funcdef(convert_char4, convert_tg, char4, float4,  int, int)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(convert_char4, convert_tg, char4, double4, int, int)
 #endif
#undef convert_char4
#undef convert_char4_rte
#undef convert_char4_rtz
#undef convert_char4_rtp
#undef convert_char4_rtn
#undef convert_char4_sat
#undef convert_char4_sat_rte
#undef convert_char4_sat_rtz
#undef convert_char4_sat_rtp
#undef convert_char4_sat_rtn
#define convert_char4(__a)         __tg_builtin_gentype("convert_char4",__a,0,0)
#define convert_char4_rte(__a)     __tg_builtin_gentype("convert_char4",__a,0,1)
#define convert_char4_rtz(__a)     __tg_builtin_gentype("convert_char4",__a,0,2)
#define convert_char4_rtp(__a)     __tg_builtin_gentype("convert_char4",__a,0,3)
#define convert_char4_rtn(__a)     __tg_builtin_gentype("convert_char4",__a,0,4)
#define convert_char4_sat(__a)     __tg_builtin_gentype("convert_char4",__a,1,0)
#define convert_char4_sat_rte(__a) __tg_builtin_gentype("convert_char4",__a,1,1)
#define convert_char4_sat_rtz(__a) __tg_builtin_gentype("convert_char4",__a,1,2)
#define convert_char4_sat_rtp(__a) __tg_builtin_gentype("convert_char4",__a,1,3)
#define convert_char4_sat_rtn(__a) __tg_builtin_gentype("convert_char4",__a,1,4)

#pragma tg_funcdef(convert_char8, convert_tg, char8, char8,   int, int)
#pragma tg_funcdef(convert_char8, convert_tg, char8, uchar8,  int, int)
#pragma tg_funcdef(convert_char8, convert_tg, char8, short8,  int, int)
#pragma tg_funcdef(convert_char8, convert_tg, char8, ushort8, int, int)
#pragma tg_funcdef(convert_char8, convert_tg, char8, int8,    int, int)
#pragma tg_funcdef(convert_char8, convert_tg, char8, uint8,   int, int)
#pragma tg_funcdef(convert_char8, convert_tg, char8, long8,   int, int)
#pragma tg_funcdef(convert_char8, convert_tg, char8, ulong8,  int, int)
#pragma tg_funcdef(convert_char8, convert_tg, char8, float8,  int, int)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(convert_char8, convert_tg, char8, double8, int, int)
 #endif
#undef convert_char8
#undef convert_char8_rte
#undef convert_char8_rtz
#undef convert_char8_rtp
#undef convert_char8_rtn
#undef convert_char8_sat
#undef convert_char8_sat_rte
#undef convert_char8_sat_rtz
#undef convert_char8_sat_rtp
#undef convert_char8_sat_rtn
#define convert_char8(__a)         __tg_builtin_gentype("convert_char8",__a,0,0)
#define convert_char8_rte(__a)     __tg_builtin_gentype("convert_char8",__a,0,1)
#define convert_char8_rtz(__a)     __tg_builtin_gentype("convert_char8",__a,0,2)
#define convert_char8_rtp(__a)     __tg_builtin_gentype("convert_char8",__a,0,3)
#define convert_char8_rtn(__a)     __tg_builtin_gentype("convert_char8",__a,0,4)
#define convert_char8_sat(__a)     __tg_builtin_gentype("convert_char8",__a,1,0)
#define convert_char8_sat_rte(__a) __tg_builtin_gentype("convert_char8",__a,1,1)
#define convert_char8_sat_rtz(__a) __tg_builtin_gentype("convert_char8",__a,1,2)
#define convert_char8_sat_rtp(__a) __tg_builtin_gentype("convert_char8",__a,1,3)
#define convert_char8_sat_rtn(__a) __tg_builtin_gentype("convert_char8",__a,1,4)

#pragma tg_funcdef(convert_char16, convert_tg, char16, char16,   int, int)
#pragma tg_funcdef(convert_char16, convert_tg, char16, uchar16,  int, int)
#pragma tg_funcdef(convert_char16, convert_tg, char16, short16,  int, int)
#pragma tg_funcdef(convert_char16, convert_tg, char16, ushort16, int, int)
#pragma tg_funcdef(convert_char16, convert_tg, char16, int16,    int, int)
#pragma tg_funcdef(convert_char16, convert_tg, char16, uint16,   int, int)
#pragma tg_funcdef(convert_char16, convert_tg, char16, long16,   int, int)
#pragma tg_funcdef(convert_char16, convert_tg, char16, ulong16,  int, int)
#pragma tg_funcdef(convert_char16, convert_tg, char16, float16,  int, int)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(convert_char16, convert_tg, char16, double16, int, int)
 #endif
#undef convert_char16
#undef convert_char16_rte
#undef convert_char16_rtz
#undef convert_char16_rtp
#undef convert_char16_rtn
#undef convert_char16_sat
#undef convert_char16_sat_rte
#undef convert_char16_sat_rtz
#undef convert_char16_sat_rtp
#undef convert_char16_sat_rtn
#define convert_char16(__a)         __tg_builtin_gentype("convert_char16",__a,0,0)
#define convert_char16_rte(__a)     __tg_builtin_gentype("convert_char16",__a,0,1)
#define convert_char16_rtz(__a)     __tg_builtin_gentype("convert_char16",__a,0,2)
#define convert_char16_rtp(__a)     __tg_builtin_gentype("convert_char16",__a,0,3)
#define convert_char16_rtn(__a)     __tg_builtin_gentype("convert_char16",__a,0,4)
#define convert_char16_sat(__a)     __tg_builtin_gentype("convert_char16",__a,1,0)
#define convert_char16_sat_rte(__a) __tg_builtin_gentype("convert_char16",__a,1,1)
#define convert_char16_sat_rtz(__a) __tg_builtin_gentype("convert_char16",__a,1,2)
#define convert_char16_sat_rtp(__a) __tg_builtin_gentype("convert_char16",__a,1,3)
#define convert_char16_sat_rtn(__a) __tg_builtin_gentype("convert_char16",__a,1,4)

/* convert_ucharN<_sat><_roundingMode> */

#pragma tg_funcdef(convert_uchar, convert_tg, uchar, char,   int, int)
#pragma tg_funcdef(convert_uchar, convert_tg, uchar, uchar,  int, int)
#pragma tg_funcdef(convert_uchar, convert_tg, uchar, short,  int, int)
#pragma tg_funcdef(convert_uchar, convert_tg, uchar, ushort, int, int)
#pragma tg_funcdef(convert_uchar, convert_tg, uchar, int,    int, int)
#pragma tg_funcdef(convert_uchar, convert_tg, uchar, uint,   int, int)
#pragma tg_funcdef(convert_uchar, convert_tg, uchar, long,   int, int)
#pragma tg_funcdef(convert_uchar, convert_tg, uchar, ulong,  int, int)
#pragma tg_funcdef(convert_uchar, convert_tg, uchar, float,  int, int)
#pragma tg_funcdef(convert_uchar, convert_tg, uchar, double, int, int)
#undef convert_uchar
#undef convert_uchar_rte
#undef convert_uchar_rtz
#undef convert_uchar_rtp
#undef convert_uchar_rtn
#undef convert_uchar_sat
#undef convert_uchar_sat_rte
#undef convert_uchar_sat_rtz
#undef convert_uchar_sat_rtp
#undef convert_uchar_sat_rtn
#define convert_uchar(__a)         __tg_builtin_gentype("convert_uchar",__a,0,0)
#define convert_uchar_rte(__a)     __tg_builtin_gentype("convert_uchar",__a,0,1)
#define convert_uchar_rtz(__a)     __tg_builtin_gentype("convert_uchar",__a,0,2)
#define convert_uchar_rtp(__a)     __tg_builtin_gentype("convert_uchar",__a,0,3)
#define convert_uchar_rtn(__a)     __tg_builtin_gentype("convert_uchar",__a,0,4)
#define convert_uchar_sat(__a)     __tg_builtin_gentype("convert_uchar",__a,1,0)
#define convert_uchar_sat_rte(__a) __tg_builtin_gentype("convert_uchar",__a,1,1)
#define convert_uchar_sat_rtz(__a) __tg_builtin_gentype("convert_uchar",__a,1,2)
#define convert_uchar_sat_rtp(__a) __tg_builtin_gentype("convert_uchar",__a,1,3)
#define convert_uchar_sat_rtn(__a) __tg_builtin_gentype("convert_uchar",__a,1,4)

#pragma tg_funcdef(convert_uchar2, convert_tg, uchar2, char2,   int, int)
#pragma tg_funcdef(convert_uchar2, convert_tg, uchar2, uchar2,  int, int)
#pragma tg_funcdef(convert_uchar2, convert_tg, uchar2, short2,  int, int)
#pragma tg_funcdef(convert_uchar2, convert_tg, uchar2, ushort2, int, int)
#pragma tg_funcdef(convert_uchar2, convert_tg, uchar2, int2,    int, int)
#pragma tg_funcdef(convert_uchar2, convert_tg, uchar2, uint2,   int, int)
#pragma tg_funcdef(convert_uchar2, convert_tg, uchar2, long2,   int, int)
#pragma tg_funcdef(convert_uchar2, convert_tg, uchar2, ulong2,  int, int)
#pragma tg_funcdef(convert_uchar2, convert_tg, uchar2, float2,  int, int)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(convert_uchar2, convert_tg, uchar2, double2, int, int)
 #endif
#undef convert_uchar2
#undef convert_uchar2_rte
#undef convert_uchar2_rtz
#undef convert_uchar2_rtp
#undef convert_uchar2_rtn
#undef convert_uchar2_sat
#undef convert_uchar2_sat_rte
#undef convert_uchar2_sat_rtz
#undef convert_uchar2_sat_rtp
#undef convert_uchar2_sat_rtn
#define convert_uchar2(__a)         __tg_builtin_gentype("convert_uchar2",__a,0,0)
#define convert_uchar2_rte(__a)     __tg_builtin_gentype("convert_uchar2",__a,0,1)
#define convert_uchar2_rtz(__a)     __tg_builtin_gentype("convert_uchar2",__a,0,2)
#define convert_uchar2_rtp(__a)     __tg_builtin_gentype("convert_uchar2",__a,0,3)
#define convert_uchar2_rtn(__a)     __tg_builtin_gentype("convert_uchar2",__a,0,4)
#define convert_uchar2_sat(__a)     __tg_builtin_gentype("convert_uchar2",__a,1,0)
#define convert_uchar2_sat_rte(__a) __tg_builtin_gentype("convert_uchar2",__a,1,1)
#define convert_uchar2_sat_rtz(__a) __tg_builtin_gentype("convert_uchar2",__a,1,2)
#define convert_uchar2_sat_rtp(__a) __tg_builtin_gentype("convert_uchar2",__a,1,3)
#define convert_uchar2_sat_rtn(__a) __tg_builtin_gentype("convert_uchar2",__a,1,4)

#pragma tg_funcdef(convert_uchar3, convert_tg, uchar3, char3,   int, int)
#pragma tg_funcdef(convert_uchar3, convert_tg, uchar3, uchar3,  int, int)
#pragma tg_funcdef(convert_uchar3, convert_tg, uchar3, short3,  int, int)
#pragma tg_funcdef(convert_uchar3, convert_tg, uchar3, ushort3, int, int)
#pragma tg_funcdef(convert_uchar3, convert_tg, uchar3, int3,    int, int)
#pragma tg_funcdef(convert_uchar3, convert_tg, uchar3, uint3,   int, int)
#pragma tg_funcdef(convert_uchar3, convert_tg, uchar3, long3,   int, int)
#pragma tg_funcdef(convert_uchar3, convert_tg, uchar3, ulong3,  int, int)
#pragma tg_funcdef(convert_uchar3, convert_tg, uchar3, float3,  int, int)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(convert_uchar3, convert_tg, uchar3, double3, int, int)
 #endif
#undef convert_uchar3
#undef convert_uchar3_rte
#undef convert_uchar3_rtz
#undef convert_uchar3_rtp
#undef convert_uchar3_rtn
#undef convert_uchar3_sat
#undef convert_uchar3_sat_rte
#undef convert_uchar3_sat_rtz
#undef convert_uchar3_sat_rtp
#undef convert_uchar3_sat_rtn
#define convert_uchar3(__a)         __tg_builtin_gentype("convert_uchar3",__a,0,0)
#define convert_uchar3_rte(__a)     __tg_builtin_gentype("convert_uchar3",__a,0,1)
#define convert_uchar3_rtz(__a)     __tg_builtin_gentype("convert_uchar3",__a,0,2)
#define convert_uchar3_rtp(__a)     __tg_builtin_gentype("convert_uchar3",__a,0,3)
#define convert_uchar3_rtn(__a)     __tg_builtin_gentype("convert_uchar3",__a,0,4)
#define convert_uchar3_sat(__a)     __tg_builtin_gentype("convert_uchar3",__a,1,0)
#define convert_uchar3_sat_rte(__a) __tg_builtin_gentype("convert_uchar3",__a,1,1)
#define convert_uchar3_sat_rtz(__a) __tg_builtin_gentype("convert_uchar3",__a,1,2)
#define convert_uchar3_sat_rtp(__a) __tg_builtin_gentype("convert_uchar3",__a,1,3)
#define convert_uchar3_sat_rtn(__a) __tg_builtin_gentype("convert_uchar3",__a,1,4)

#pragma tg_funcdef(convert_uchar4, convert_tg, uchar4, char4,   int, int)
#pragma tg_funcdef(convert_uchar4, convert_tg, uchar4, uchar4,  int, int)
#pragma tg_funcdef(convert_uchar4, convert_tg, uchar4, short4,  int, int)
#pragma tg_funcdef(convert_uchar4, convert_tg, uchar4, ushort4, int, int)
#pragma tg_funcdef(convert_uchar4, convert_tg, uchar4, int4,    int, int)
#pragma tg_funcdef(convert_uchar4, convert_tg, uchar4, uint4,   int, int)
#pragma tg_funcdef(convert_uchar4, convert_tg, uchar4, long4,   int, int)
#pragma tg_funcdef(convert_uchar4, convert_tg, uchar4, ulong4,  int, int)
#pragma tg_funcdef(convert_uchar4, convert_tg, uchar4, float4,  int, int)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(convert_uchar4, convert_tg, uchar4, double4, int, int)
 #endif
#undef convert_uchar4
#undef convert_uchar4_rte
#undef convert_uchar4_rtz
#undef convert_uchar4_rtp
#undef convert_uchar4_rtn
#undef convert_uchar4_sat
#undef convert_uchar4_sat_rte
#undef convert_uchar4_sat_rtz
#undef convert_uchar4_sat_rtp
#undef convert_uchar4_sat_rtn
#define convert_uchar4(__a)         __tg_builtin_gentype("convert_uchar4",__a,0,0)
#define convert_uchar4_rte(__a)     __tg_builtin_gentype("convert_uchar4",__a,0,1)
#define convert_uchar4_rtz(__a)     __tg_builtin_gentype("convert_uchar4",__a,0,2)
#define convert_uchar4_rtp(__a)     __tg_builtin_gentype("convert_uchar4",__a,0,3)
#define convert_uchar4_rtn(__a)     __tg_builtin_gentype("convert_uchar4",__a,0,4)
#define convert_uchar4_sat(__a)     __tg_builtin_gentype("convert_uchar4",__a,1,0)
#define convert_uchar4_sat_rte(__a) __tg_builtin_gentype("convert_uchar4",__a,1,1)
#define convert_uchar4_sat_rtz(__a) __tg_builtin_gentype("convert_uchar4",__a,1,2)
#define convert_uchar4_sat_rtp(__a) __tg_builtin_gentype("convert_uchar4",__a,1,3)
#define convert_uchar4_sat_rtn(__a) __tg_builtin_gentype("convert_uchar4",__a,1,4)

#pragma tg_funcdef(convert_uchar8, convert_tg, uchar8, char8,   int, int)
#pragma tg_funcdef(convert_uchar8, convert_tg, uchar8, uchar8,  int, int)
#pragma tg_funcdef(convert_uchar8, convert_tg, uchar8, short8,  int, int)
#pragma tg_funcdef(convert_uchar8, convert_tg, uchar8, ushort8, int, int)
#pragma tg_funcdef(convert_uchar8, convert_tg, uchar8, int8,    int, int)
#pragma tg_funcdef(convert_uchar8, convert_tg, uchar8, uint8,   int, int)
#pragma tg_funcdef(convert_uchar8, convert_tg, uchar8, long8,   int, int)
#pragma tg_funcdef(convert_uchar8, convert_tg, uchar8, ulong8,  int, int)
#pragma tg_funcdef(convert_uchar8, convert_tg, uchar8, float8,  int, int)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(convert_uchar8, convert_tg, uchar8, double8, int, int)
 #endif
#undef convert_uchar8
#undef convert_uchar8_rte
#undef convert_uchar8_rtz
#undef convert_uchar8_rtp
#undef convert_uchar8_rtn
#undef convert_uchar8_sat
#undef convert_uchar8_sat_rte
#undef convert_uchar8_sat_rtz
#undef convert_uchar8_sat_rtp
#undef convert_uchar8_sat_rtn
#define convert_uchar8(__a)         __tg_builtin_gentype("convert_uchar8",__a,0,0)
#define convert_uchar8_rte(__a)     __tg_builtin_gentype("convert_uchar8",__a,0,1)
#define convert_uchar8_rtz(__a)     __tg_builtin_gentype("convert_uchar8",__a,0,2)
#define convert_uchar8_rtp(__a)     __tg_builtin_gentype("convert_uchar8",__a,0,3)
#define convert_uchar8_rtn(__a)     __tg_builtin_gentype("convert_uchar8",__a,0,4)
#define convert_uchar8_sat(__a)     __tg_builtin_gentype("convert_uchar8",__a,1,0)
#define convert_uchar8_sat_rte(__a) __tg_builtin_gentype("convert_uchar8",__a,1,1)
#define convert_uchar8_sat_rtz(__a) __tg_builtin_gentype("convert_uchar8",__a,1,2)
#define convert_uchar8_sat_rtp(__a) __tg_builtin_gentype("convert_uchar8",__a,1,3)
#define convert_uchar8_sat_rtn(__a) __tg_builtin_gentype("convert_uchar8",__a,1,4)

#pragma tg_funcdef(convert_uchar16, convert_tg, uchar16, char16,   int, int)
#pragma tg_funcdef(convert_uchar16, convert_tg, uchar16, uchar16,  int, int)
#pragma tg_funcdef(convert_uchar16, convert_tg, uchar16, short16,  int, int)
#pragma tg_funcdef(convert_uchar16, convert_tg, uchar16, ushort16, int, int)
#pragma tg_funcdef(convert_uchar16, convert_tg, uchar16, int16,    int, int)
#pragma tg_funcdef(convert_uchar16, convert_tg, uchar16, uint16,   int, int)
#pragma tg_funcdef(convert_uchar16, convert_tg, uchar16, long16,   int, int)
#pragma tg_funcdef(convert_uchar16, convert_tg, uchar16, ulong16,  int, int)
#pragma tg_funcdef(convert_uchar16, convert_tg, uchar16, float16,  int, int)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(convert_uchar16, convert_tg, uchar16, double16, int, int)
 #endif
#undef convert_uchar16
#undef convert_uchar16_rte
#undef convert_uchar16_rtz
#undef convert_uchar16_rtp
#undef convert_uchar16_rtn
#undef convert_uchar16_sat
#undef convert_uchar16_sat_rte
#undef convert_uchar16_sat_rtz
#undef convert_uchar16_sat_rtp
#undef convert_uchar16_sat_rtn
#define convert_uchar16(__a)         __tg_builtin_gentype("convert_uchar16",__a,0,0)
#define convert_uchar16_rte(__a)     __tg_builtin_gentype("convert_uchar16",__a,0,1)
#define convert_uchar16_rtz(__a)     __tg_builtin_gentype("convert_uchar16",__a,0,2)
#define convert_uchar16_rtp(__a)     __tg_builtin_gentype("convert_uchar16",__a,0,3)
#define convert_uchar16_rtn(__a)     __tg_builtin_gentype("convert_uchar16",__a,0,4)
#define convert_uchar16_sat(__a)     __tg_builtin_gentype("convert_uchar16",__a,1,0)
#define convert_uchar16_sat_rte(__a) __tg_builtin_gentype("convert_uchar16",__a,1,1)
#define convert_uchar16_sat_rtz(__a) __tg_builtin_gentype("convert_uchar16",__a,1,2)
#define convert_uchar16_sat_rtp(__a) __tg_builtin_gentype("convert_uchar16",__a,1,3)
#define convert_uchar16_sat_rtn(__a) __tg_builtin_gentype("convert_uchar16",__a,1,4)

/* convert_shortN<_sat><_roundingMode> */

#pragma tg_funcdef(convert_short, convert_tg, short, char,   int, int)
#pragma tg_funcdef(convert_short, convert_tg, short, uchar,  int, int)
#pragma tg_funcdef(convert_short, convert_tg, short, short,  int, int)
#pragma tg_funcdef(convert_short, convert_tg, short, ushort, int, int)
#pragma tg_funcdef(convert_short, convert_tg, short, int,    int, int)
#pragma tg_funcdef(convert_short, convert_tg, short, uint,   int, int)
#pragma tg_funcdef(convert_short, convert_tg, short, long,   int, int)
#pragma tg_funcdef(convert_short, convert_tg, short, ulong,  int, int)
#pragma tg_funcdef(convert_short, convert_tg, short, float,  int, int)
#pragma tg_funcdef(convert_short, convert_tg, short, double, int, int)
#undef convert_short
#undef convert_short_rte
#undef convert_short_rtz
#undef convert_short_rtp
#undef convert_short_rtn
#undef convert_short_sat
#undef convert_short_sat_rte
#undef convert_short_sat_rtz
#undef convert_short_sat_rtp
#undef convert_short_sat_rtn
#define convert_short(__a)         __tg_builtin_gentype("convert_short",__a,0,0)
#define convert_short_rte(__a)     __tg_builtin_gentype("convert_short",__a,0,1)
#define convert_short_rtz(__a)     __tg_builtin_gentype("convert_short",__a,0,2)
#define convert_short_rtp(__a)     __tg_builtin_gentype("convert_short",__a,0,3)
#define convert_short_rtn(__a)     __tg_builtin_gentype("convert_short",__a,0,4)
#define convert_short_sat(__a)     __tg_builtin_gentype("convert_short",__a,1,0)
#define convert_short_sat_rte(__a) __tg_builtin_gentype("convert_short",__a,1,1)
#define convert_short_sat_rtz(__a) __tg_builtin_gentype("convert_short",__a,1,2)
#define convert_short_sat_rtp(__a) __tg_builtin_gentype("convert_short",__a,1,3)
#define convert_short_sat_rtn(__a) __tg_builtin_gentype("convert_short",__a,1,4)

#pragma tg_funcdef(convert_short2, convert_tg, short2, char2,   int, int)
#pragma tg_funcdef(convert_short2, convert_tg, short2, uchar2,  int, int)
#pragma tg_funcdef(convert_short2, convert_tg, short2, short2,  int, int)
#pragma tg_funcdef(convert_short2, convert_tg, short2, ushort2, int, int)
#pragma tg_funcdef(convert_short2, convert_tg, short2, int2,    int, int)
#pragma tg_funcdef(convert_short2, convert_tg, short2, uint2,   int, int)
#pragma tg_funcdef(convert_short2, convert_tg, short2, long2,   int, int)
#pragma tg_funcdef(convert_short2, convert_tg, short2, ulong2,  int, int)
#pragma tg_funcdef(convert_short2, convert_tg, short2, float2,  int, int)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(convert_short2, convert_tg, short2, double2, int, int)
 #endif
#undef convert_short2
#undef convert_short2_rte
#undef convert_short2_rtz
#undef convert_short2_rtp
#undef convert_short2_rtn
#undef convert_short2_sat
#undef convert_short2_sat_rte
#undef convert_short2_sat_rtz
#undef convert_short2_sat_rtp
#undef convert_short2_sat_rtn
#define convert_short2(__a)         __tg_builtin_gentype("convert_short2",__a,0,0)
#define convert_short2_rte(__a)     __tg_builtin_gentype("convert_short2",__a,0,1)
#define convert_short2_rtz(__a)     __tg_builtin_gentype("convert_short2",__a,0,2)
#define convert_short2_rtp(__a)     __tg_builtin_gentype("convert_short2",__a,0,3)
#define convert_short2_rtn(__a)     __tg_builtin_gentype("convert_short2",__a,0,4)
#define convert_short2_sat(__a)     __tg_builtin_gentype("convert_short2",__a,1,0)
#define convert_short2_sat_rte(__a) __tg_builtin_gentype("convert_short2",__a,1,1)
#define convert_short2_sat_rtz(__a) __tg_builtin_gentype("convert_short2",__a,1,2)
#define convert_short2_sat_rtp(__a) __tg_builtin_gentype("convert_short2",__a,1,3)
#define convert_short2_sat_rtn(__a) __tg_builtin_gentype("convert_short2",__a,1,4)

#pragma tg_funcdef(convert_short3, convert_tg, short3, char3,   int, int)
#pragma tg_funcdef(convert_short3, convert_tg, short3, uchar3,  int, int)
#pragma tg_funcdef(convert_short3, convert_tg, short3, short3,  int, int)
#pragma tg_funcdef(convert_short3, convert_tg, short3, ushort3, int, int)
#pragma tg_funcdef(convert_short3, convert_tg, short3, int3,    int, int)
#pragma tg_funcdef(convert_short3, convert_tg, short3, uint3,   int, int)
#pragma tg_funcdef(convert_short3, convert_tg, short3, long3,   int, int)
#pragma tg_funcdef(convert_short3, convert_tg, short3, ulong3,  int, int)
#pragma tg_funcdef(convert_short3, convert_tg, short3, float3,  int, int)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(convert_short3, convert_tg, short3, double3, int, int)
 #endif
#undef convert_short3
#undef convert_short3_rte
#undef convert_short3_rtz
#undef convert_short3_rtp
#undef convert_short3_rtn
#undef convert_short3_sat
#undef convert_short3_sat_rte
#undef convert_short3_sat_rtz
#undef convert_short3_sat_rtp
#undef convert_short3_sat_rtn
#define convert_short3(__a)         __tg_builtin_gentype("convert_short3",__a,0,0)
#define convert_short3_rte(__a)     __tg_builtin_gentype("convert_short3",__a,0,1)
#define convert_short3_rtz(__a)     __tg_builtin_gentype("convert_short3",__a,0,2)
#define convert_short3_rtp(__a)     __tg_builtin_gentype("convert_short3",__a,0,3)
#define convert_short3_rtn(__a)     __tg_builtin_gentype("convert_short3",__a,0,4)
#define convert_short3_sat(__a)     __tg_builtin_gentype("convert_short3",__a,1,0)
#define convert_short3_sat_rte(__a) __tg_builtin_gentype("convert_short3",__a,1,1)
#define convert_short3_sat_rtz(__a) __tg_builtin_gentype("convert_short3",__a,1,2)
#define convert_short3_sat_rtp(__a) __tg_builtin_gentype("convert_short3",__a,1,3)
#define convert_short3_sat_rtn(__a) __tg_builtin_gentype("convert_short3",__a,1,4)

#pragma tg_funcdef(convert_short4, convert_tg, short4, char4,   int, int)
#pragma tg_funcdef(convert_short4, convert_tg, short4, uchar4,  int, int)
#pragma tg_funcdef(convert_short4, convert_tg, short4, short4,  int, int)
#pragma tg_funcdef(convert_short4, convert_tg, short4, ushort4, int, int)
#pragma tg_funcdef(convert_short4, convert_tg, short4, int4,    int, int)
#pragma tg_funcdef(convert_short4, convert_tg, short4, uint4,   int, int)
#pragma tg_funcdef(convert_short4, convert_tg, short4, long4,   int, int)
#pragma tg_funcdef(convert_short4, convert_tg, short4, ulong4,  int, int)
#pragma tg_funcdef(convert_short4, convert_tg, short4, float4,  int, int)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(convert_short4, convert_tg, short4, double4, int, int)
 #endif
#undef convert_short4
#undef convert_short4_rte
#undef convert_short4_rtz
#undef convert_short4_rtp
#undef convert_short4_rtn
#undef convert_short4_sat
#undef convert_short4_sat_rte
#undef convert_short4_sat_rtz
#undef convert_short4_sat_rtp
#undef convert_short4_sat_rtn
#define convert_short4(__a)         __tg_builtin_gentype("convert_short4",__a,0,0)
#define convert_short4_rte(__a)     __tg_builtin_gentype("convert_short4",__a,0,1)
#define convert_short4_rtz(__a)     __tg_builtin_gentype("convert_short4",__a,0,2)
#define convert_short4_rtp(__a)     __tg_builtin_gentype("convert_short4",__a,0,3)
#define convert_short4_rtn(__a)     __tg_builtin_gentype("convert_short4",__a,0,4)
#define convert_short4_sat(__a)     __tg_builtin_gentype("convert_short4",__a,1,0)
#define convert_short4_sat_rte(__a) __tg_builtin_gentype("convert_short4",__a,1,1)
#define convert_short4_sat_rtz(__a) __tg_builtin_gentype("convert_short4",__a,1,2)
#define convert_short4_sat_rtp(__a) __tg_builtin_gentype("convert_short4",__a,1,3)
#define convert_short4_sat_rtn(__a) __tg_builtin_gentype("convert_short4",__a,1,4)

#pragma tg_funcdef(convert_short8, convert_tg, short8, char8,   int, int)
#pragma tg_funcdef(convert_short8, convert_tg, short8, uchar8,  int, int)
#pragma tg_funcdef(convert_short8, convert_tg, short8, short8,  int, int)
#pragma tg_funcdef(convert_short8, convert_tg, short8, ushort8, int, int)
#pragma tg_funcdef(convert_short8, convert_tg, short8, int8,    int, int)
#pragma tg_funcdef(convert_short8, convert_tg, short8, uint8,   int, int)
#pragma tg_funcdef(convert_short8, convert_tg, short8, long8,   int, int)
#pragma tg_funcdef(convert_short8, convert_tg, short8, ulong8,  int, int)
#pragma tg_funcdef(convert_short8, convert_tg, short8, float8,  int, int)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(convert_short8, convert_tg, short8, double8, int, int)
 #endif
#undef convert_short8
#undef convert_short8_rte
#undef convert_short8_rtz
#undef convert_short8_rtp
#undef convert_short8_rtn
#undef convert_short8_sat
#undef convert_short8_sat_rte
#undef convert_short8_sat_rtz
#undef convert_short8_sat_rtp
#undef convert_short8_sat_rtn
#define convert_short8(__a)         __tg_builtin_gentype("convert_short8",__a,0,0)
#define convert_short8_rte(__a)     __tg_builtin_gentype("convert_short8",__a,0,1)
#define convert_short8_rtz(__a)     __tg_builtin_gentype("convert_short8",__a,0,2)
#define convert_short8_rtp(__a)     __tg_builtin_gentype("convert_short8",__a,0,3)
#define convert_short8_rtn(__a)     __tg_builtin_gentype("convert_short8",__a,0,4)
#define convert_short8_sat(__a)     __tg_builtin_gentype("convert_short8",__a,1,0)
#define convert_short8_sat_rte(__a) __tg_builtin_gentype("convert_short8",__a,1,1)
#define convert_short8_sat_rtz(__a) __tg_builtin_gentype("convert_short8",__a,1,2)
#define convert_short8_sat_rtp(__a) __tg_builtin_gentype("convert_short8",__a,1,3)
#define convert_short8_sat_rtn(__a) __tg_builtin_gentype("convert_short8",__a,1,4)

#pragma tg_funcdef(convert_short16, convert_tg, short16, char16,   int, int)
#pragma tg_funcdef(convert_short16, convert_tg, short16, uchar16,  int, int)
#pragma tg_funcdef(convert_short16, convert_tg, short16, short16,  int, int)
#pragma tg_funcdef(convert_short16, convert_tg, short16, ushort16, int, int)
#pragma tg_funcdef(convert_short16, convert_tg, short16, int16,    int, int)
#pragma tg_funcdef(convert_short16, convert_tg, short16, uint16,   int, int)
#pragma tg_funcdef(convert_short16, convert_tg, short16, long16,   int, int)
#pragma tg_funcdef(convert_short16, convert_tg, short16, ulong16,  int, int)
#pragma tg_funcdef(convert_short16, convert_tg, short16, float16,  int, int)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(convert_short16, convert_tg, short16, double16, int, int)
 #endif
#undef convert_short16
#undef convert_short16_rte
#undef convert_short16_rtz
#undef convert_short16_rtp
#undef convert_short16_rtn
#undef convert_short16_sat
#undef convert_short16_sat_rte
#undef convert_short16_sat_rtz
#undef convert_short16_sat_rtp
#undef convert_short16_sat_rtn
#define convert_short16(__a)         __tg_builtin_gentype("convert_short16",__a,0,0)
#define convert_short16_rte(__a)     __tg_builtin_gentype("convert_short16",__a,0,1)
#define convert_short16_rtz(__a)     __tg_builtin_gentype("convert_short16",__a,0,2)
#define convert_short16_rtp(__a)     __tg_builtin_gentype("convert_short16",__a,0,3)
#define convert_short16_rtn(__a)     __tg_builtin_gentype("convert_short16",__a,0,4)
#define convert_short16_sat(__a)     __tg_builtin_gentype("convert_short16",__a,1,0)
#define convert_short16_sat_rte(__a) __tg_builtin_gentype("convert_short16",__a,1,1)
#define convert_short16_sat_rtz(__a) __tg_builtin_gentype("convert_short16",__a,1,2)
#define convert_short16_sat_rtp(__a) __tg_builtin_gentype("convert_short16",__a,1,3)
#define convert_short16_sat_rtn(__a) __tg_builtin_gentype("convert_short16",__a,1,4)

/* convert_ushortN<_sat><_roundingMode> */

#pragma tg_funcdef(convert_ushort, convert_tg, ushort, char,   int, int)
#pragma tg_funcdef(convert_ushort, convert_tg, ushort, uchar,  int, int)
#pragma tg_funcdef(convert_ushort, convert_tg, ushort, short,  int, int)
#pragma tg_funcdef(convert_ushort, convert_tg, ushort, ushort, int, int)
#pragma tg_funcdef(convert_ushort, convert_tg, ushort, int,    int, int)
#pragma tg_funcdef(convert_ushort, convert_tg, ushort, uint,   int, int)
#pragma tg_funcdef(convert_ushort, convert_tg, ushort, long,   int, int)
#pragma tg_funcdef(convert_ushort, convert_tg, ushort, ulong,  int, int)
#pragma tg_funcdef(convert_ushort, convert_tg, ushort, float,  int, int)
#pragma tg_funcdef(convert_ushort, convert_tg, ushort, double, int, int)
#undef convert_ushort
#undef convert_ushort_rte
#undef convert_ushort_rtz
#undef convert_ushort_rtp
#undef convert_ushort_rtn
#undef convert_ushort_sat
#undef convert_ushort_sat_rte
#undef convert_ushort_sat_rtz
#undef convert_ushort_sat_rtp
#undef convert_ushort_sat_rtn
#define convert_ushort(__a)         __tg_builtin_gentype("convert_ushort",__a,0,0)
#define convert_ushort_rte(__a)     __tg_builtin_gentype("convert_ushort",__a,0,1)
#define convert_ushort_rtz(__a)     __tg_builtin_gentype("convert_ushort",__a,0,2)
#define convert_ushort_rtp(__a)     __tg_builtin_gentype("convert_ushort",__a,0,3)
#define convert_ushort_rtn(__a)     __tg_builtin_gentype("convert_ushort",__a,0,4)
#define convert_ushort_sat(__a)     __tg_builtin_gentype("convert_ushort",__a,1,0)
#define convert_ushort_sat_rte(__a) __tg_builtin_gentype("convert_ushort",__a,1,1)
#define convert_ushort_sat_rtz(__a) __tg_builtin_gentype("convert_ushort",__a,1,2)
#define convert_ushort_sat_rtp(__a) __tg_builtin_gentype("convert_ushort",__a,1,3)
#define convert_ushort_sat_rtn(__a) __tg_builtin_gentype("convert_ushort",__a,1,4)

#pragma tg_funcdef(convert_ushort2, convert_tg, ushort2, char2,   int, int)
#pragma tg_funcdef(convert_ushort2, convert_tg, ushort2, uchar2,  int, int)
#pragma tg_funcdef(convert_ushort2, convert_tg, ushort2, short2,  int, int)
#pragma tg_funcdef(convert_ushort2, convert_tg, ushort2, ushort2, int, int)
#pragma tg_funcdef(convert_ushort2, convert_tg, ushort2, int2,    int, int)
#pragma tg_funcdef(convert_ushort2, convert_tg, ushort2, uint2,   int, int)
#pragma tg_funcdef(convert_ushort2, convert_tg, ushort2, long2,   int, int)
#pragma tg_funcdef(convert_ushort2, convert_tg, ushort2, ulong2,  int, int)
#pragma tg_funcdef(convert_ushort2, convert_tg, ushort2, float2,  int, int)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(convert_ushort2, convert_tg, ushort2, double2, int, int)
 #endif
#undef convert_ushort2
#undef convert_ushort2_rte
#undef convert_ushort2_rtz
#undef convert_ushort2_rtp
#undef convert_ushort2_rtn
#undef convert_ushort2_sat
#undef convert_ushort2_sat_rte
#undef convert_ushort2_sat_rtz
#undef convert_ushort2_sat_rtp
#undef convert_ushort2_sat_rtn
#define convert_ushort2(__a)         __tg_builtin_gentype("convert_ushort2",__a,0,0)
#define convert_ushort2_rte(__a)     __tg_builtin_gentype("convert_ushort2",__a,0,1)
#define convert_ushort2_rtz(__a)     __tg_builtin_gentype("convert_ushort2",__a,0,2)
#define convert_ushort2_rtp(__a)     __tg_builtin_gentype("convert_ushort2",__a,0,3)
#define convert_ushort2_rtn(__a)     __tg_builtin_gentype("convert_ushort2",__a,0,4)
#define convert_ushort2_sat(__a)     __tg_builtin_gentype("convert_ushort2",__a,1,0)
#define convert_ushort2_sat_rte(__a) __tg_builtin_gentype("convert_ushort2",__a,1,1)
#define convert_ushort2_sat_rtz(__a) __tg_builtin_gentype("convert_ushort2",__a,1,2)
#define convert_ushort2_sat_rtp(__a) __tg_builtin_gentype("convert_ushort2",__a,1,3)
#define convert_ushort2_sat_rtn(__a) __tg_builtin_gentype("convert_ushort2",__a,1,4)

#pragma tg_funcdef(convert_ushort3, convert_tg, ushort3, char3,   int, int)
#pragma tg_funcdef(convert_ushort3, convert_tg, ushort3, uchar3,  int, int)
#pragma tg_funcdef(convert_ushort3, convert_tg, ushort3, short3,  int, int)
#pragma tg_funcdef(convert_ushort3, convert_tg, ushort3, ushort3, int, int)
#pragma tg_funcdef(convert_ushort3, convert_tg, ushort3, int3,    int, int)
#pragma tg_funcdef(convert_ushort3, convert_tg, ushort3, uint3,   int, int)
#pragma tg_funcdef(convert_ushort3, convert_tg, ushort3, long3,   int, int)
#pragma tg_funcdef(convert_ushort3, convert_tg, ushort3, ulong3,  int, int)
#pragma tg_funcdef(convert_ushort3, convert_tg, ushort3, float3,  int, int)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(convert_ushort3, convert_tg, ushort3, double3, int, int)
 #endif
#undef convert_ushort3
#undef convert_ushort3_rte
#undef convert_ushort3_rtz
#undef convert_ushort3_rtp
#undef convert_ushort3_rtn
#undef convert_ushort3_sat
#undef convert_ushort3_sat_rte
#undef convert_ushort3_sat_rtz
#undef convert_ushort3_sat_rtp
#undef convert_ushort3_sat_rtn
#define convert_ushort3(__a)         __tg_builtin_gentype("convert_ushort3",__a,0,0)
#define convert_ushort3_rte(__a)     __tg_builtin_gentype("convert_ushort3",__a,0,1)
#define convert_ushort3_rtz(__a)     __tg_builtin_gentype("convert_ushort3",__a,0,2)
#define convert_ushort3_rtp(__a)     __tg_builtin_gentype("convert_ushort3",__a,0,3)
#define convert_ushort3_rtn(__a)     __tg_builtin_gentype("convert_ushort3",__a,0,4)
#define convert_ushort3_sat(__a)     __tg_builtin_gentype("convert_ushort3",__a,1,0)
#define convert_ushort3_sat_rte(__a) __tg_builtin_gentype("convert_ushort3",__a,1,1)
#define convert_ushort3_sat_rtz(__a) __tg_builtin_gentype("convert_ushort3",__a,1,2)
#define convert_ushort3_sat_rtp(__a) __tg_builtin_gentype("convert_ushort3",__a,1,3)
#define convert_ushort3_sat_rtn(__a) __tg_builtin_gentype("convert_ushort3",__a,1,4)

#pragma tg_funcdef(convert_ushort4, convert_tg, ushort4, char4,   int, int)
#pragma tg_funcdef(convert_ushort4, convert_tg, ushort4, uchar4,  int, int)
#pragma tg_funcdef(convert_ushort4, convert_tg, ushort4, short4,  int, int)
#pragma tg_funcdef(convert_ushort4, convert_tg, ushort4, ushort4, int, int)
#pragma tg_funcdef(convert_ushort4, convert_tg, ushort4, int4,    int, int)
#pragma tg_funcdef(convert_ushort4, convert_tg, ushort4, uint4,   int, int)
#pragma tg_funcdef(convert_ushort4, convert_tg, ushort4, long4,   int, int)
#pragma tg_funcdef(convert_ushort4, convert_tg, ushort4, ulong4,  int, int)
#pragma tg_funcdef(convert_ushort4, convert_tg, ushort4, float4,  int, int)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(convert_ushort4, convert_tg, ushort4, double4, int, int)
 #endif
#undef convert_ushort4
#undef convert_ushort4_rte
#undef convert_ushort4_rtz
#undef convert_ushort4_rtp
#undef convert_ushort4_rtn
#undef convert_ushort4_sat
#undef convert_ushort4_sat_rte
#undef convert_ushort4_sat_rtz
#undef convert_ushort4_sat_rtp
#undef convert_ushort4_sat_rtn
#define convert_ushort4(__a)         __tg_builtin_gentype("convert_ushort4",__a,0,0)
#define convert_ushort4_rte(__a)     __tg_builtin_gentype("convert_ushort4",__a,0,1)
#define convert_ushort4_rtz(__a)     __tg_builtin_gentype("convert_ushort4",__a,0,2)
#define convert_ushort4_rtp(__a)     __tg_builtin_gentype("convert_ushort4",__a,0,3)
#define convert_ushort4_rtn(__a)     __tg_builtin_gentype("convert_ushort4",__a,0,4)
#define convert_ushort4_sat(__a)     __tg_builtin_gentype("convert_ushort4",__a,1,0)
#define convert_ushort4_sat_rte(__a) __tg_builtin_gentype("convert_ushort4",__a,1,1)
#define convert_ushort4_sat_rtz(__a) __tg_builtin_gentype("convert_ushort4",__a,1,2)
#define convert_ushort4_sat_rtp(__a) __tg_builtin_gentype("convert_ushort4",__a,1,3)
#define convert_ushort4_sat_rtn(__a) __tg_builtin_gentype("convert_ushort4",__a,1,4)

#pragma tg_funcdef(convert_ushort8, convert_tg, ushort8, char8,   int, int)
#pragma tg_funcdef(convert_ushort8, convert_tg, ushort8, uchar8,  int, int)
#pragma tg_funcdef(convert_ushort8, convert_tg, ushort8, short8,  int, int)
#pragma tg_funcdef(convert_ushort8, convert_tg, ushort8, ushort8, int, int)
#pragma tg_funcdef(convert_ushort8, convert_tg, ushort8, int8,    int, int)
#pragma tg_funcdef(convert_ushort8, convert_tg, ushort8, uint8,   int, int)
#pragma tg_funcdef(convert_ushort8, convert_tg, ushort8, long8,   int, int)
#pragma tg_funcdef(convert_ushort8, convert_tg, ushort8, ulong8,  int, int)
#pragma tg_funcdef(convert_ushort8, convert_tg, ushort8, float8,  int, int)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(convert_ushort8, convert_tg, ushort8, double8, int, int)
 #endif
#undef convert_ushort8
#undef convert_ushort8_rte
#undef convert_ushort8_rtz
#undef convert_ushort8_rtp
#undef convert_ushort8_rtn
#undef convert_ushort8_sat
#undef convert_ushort8_sat_rte
#undef convert_ushort8_sat_rtz
#undef convert_ushort8_sat_rtp
#undef convert_ushort8_sat_rtn
#define convert_ushort8(__a)         __tg_builtin_gentype("convert_ushort8",__a,0,0)
#define convert_ushort8_rte(__a)     __tg_builtin_gentype("convert_ushort8",__a,0,1)
#define convert_ushort8_rtz(__a)     __tg_builtin_gentype("convert_ushort8",__a,0,2)
#define convert_ushort8_rtp(__a)     __tg_builtin_gentype("convert_ushort8",__a,0,3)
#define convert_ushort8_rtn(__a)     __tg_builtin_gentype("convert_ushort8",__a,0,4)
#define convert_ushort8_sat(__a)     __tg_builtin_gentype("convert_ushort8",__a,1,0)
#define convert_ushort8_sat_rte(__a) __tg_builtin_gentype("convert_ushort8",__a,1,1)
#define convert_ushort8_sat_rtz(__a) __tg_builtin_gentype("convert_ushort8",__a,1,2)
#define convert_ushort8_sat_rtp(__a) __tg_builtin_gentype("convert_ushort8",__a,1,3)
#define convert_ushort8_sat_rtn(__a) __tg_builtin_gentype("convert_ushort8",__a,1,4)

#pragma tg_funcdef(convert_ushort16, convert_tg, ushort16, char16,   int, int)
#pragma tg_funcdef(convert_ushort16, convert_tg, ushort16, uchar16,  int, int)
#pragma tg_funcdef(convert_ushort16, convert_tg, ushort16, short16,  int, int)
#pragma tg_funcdef(convert_ushort16, convert_tg, ushort16, ushort16, int, int)
#pragma tg_funcdef(convert_ushort16, convert_tg, ushort16, int16,    int, int)
#pragma tg_funcdef(convert_ushort16, convert_tg, ushort16, uint16,   int, int)
#pragma tg_funcdef(convert_ushort16, convert_tg, ushort16, long16,   int, int)
#pragma tg_funcdef(convert_ushort16, convert_tg, ushort16, ulong16,  int, int)
#pragma tg_funcdef(convert_ushort16, convert_tg, ushort16, float16,  int, int)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(convert_ushort16, convert_tg, ushort16, double16, int, int)
 #endif
#undef convert_ushort16
#undef convert_ushort16_rte
#undef convert_ushort16_rtz
#undef convert_ushort16_rtp
#undef convert_ushort16_rtn
#undef convert_ushort16_sat
#undef convert_ushort16_sat_rte
#undef convert_ushort16_sat_rtz
#undef convert_ushort16_sat_rtp
#undef convert_ushort16_sat_rtn
#define convert_ushort16(__a)         __tg_builtin_gentype("convert_ushort16",__a,0,0)
#define convert_ushort16_rte(__a)     __tg_builtin_gentype("convert_ushort16",__a,0,1)
#define convert_ushort16_rtz(__a)     __tg_builtin_gentype("convert_ushort16",__a,0,2)
#define convert_ushort16_rtp(__a)     __tg_builtin_gentype("convert_ushort16",__a,0,3)
#define convert_ushort16_rtn(__a)     __tg_builtin_gentype("convert_ushort16",__a,0,4)
#define convert_ushort16_sat(__a)     __tg_builtin_gentype("convert_ushort16",__a,1,0)
#define convert_ushort16_sat_rte(__a) __tg_builtin_gentype("convert_ushort16",__a,1,1)
#define convert_ushort16_sat_rtz(__a) __tg_builtin_gentype("convert_ushort16",__a,1,2)
#define convert_ushort16_sat_rtp(__a) __tg_builtin_gentype("convert_ushort16",__a,1,3)
#define convert_ushort16_sat_rtn(__a) __tg_builtin_gentype("convert_ushort16",__a,1,4)

/* convert_intN<_sat><_roundingMode> */

#pragma tg_funcdef(convert_int, convert_tg, int, char,   int, int)
#pragma tg_funcdef(convert_int, convert_tg, int, uchar,  int, int)
#pragma tg_funcdef(convert_int, convert_tg, int, short,  int, int)
#pragma tg_funcdef(convert_int, convert_tg, int, ushort, int, int)
#pragma tg_funcdef(convert_int, convert_tg, int, int,    int, int)
#pragma tg_funcdef(convert_int, convert_tg, int, uint,   int, int)
#pragma tg_funcdef(convert_int, convert_tg, int, long,   int, int)
#pragma tg_funcdef(convert_int, convert_tg, int, ulong,  int, int)
#pragma tg_funcdef(convert_int, convert_tg, int, float,  int, int)
#pragma tg_funcdef(convert_int, convert_tg, int, double, int, int)
#undef convert_int
#undef convert_int_rte
#undef convert_int_rtz
#undef convert_int_rtp
#undef convert_int_rtn
#undef convert_int_sat
#undef convert_int_sat_rte
#undef convert_int_sat_rtz
#undef convert_int_sat_rtp
#undef convert_int_sat_rtn
#define convert_int(__a)         __tg_builtin_gentype("convert_int",__a,0,0)
#define convert_int_rte(__a)     __tg_builtin_gentype("convert_int",__a,0,1)
#define convert_int_rtz(__a)     __tg_builtin_gentype("convert_int",__a,0,2)
#define convert_int_rtp(__a)     __tg_builtin_gentype("convert_int",__a,0,3)
#define convert_int_rtn(__a)     __tg_builtin_gentype("convert_int",__a,0,4)
#define convert_int_sat(__a)     __tg_builtin_gentype("convert_int",__a,1,0)
#define convert_int_sat_rte(__a) __tg_builtin_gentype("convert_int",__a,1,1)
#define convert_int_sat_rtz(__a) __tg_builtin_gentype("convert_int",__a,1,2)
#define convert_int_sat_rtp(__a) __tg_builtin_gentype("convert_int",__a,1,3)
#define convert_int_sat_rtn(__a) __tg_builtin_gentype("convert_int",__a,1,4)

#pragma tg_funcdef(convert_int2, convert_tg, int2, char2,   int, int)
#pragma tg_funcdef(convert_int2, convert_tg, int2, uchar2,  int, int)
#pragma tg_funcdef(convert_int2, convert_tg, int2, short2,  int, int)
#pragma tg_funcdef(convert_int2, convert_tg, int2, ushort2, int, int)
#pragma tg_funcdef(convert_int2, convert_tg, int2, int2,    int, int)
#pragma tg_funcdef(convert_int2, convert_tg, int2, uint2,   int, int)
#pragma tg_funcdef(convert_int2, convert_tg, int2, long2,   int, int)
#pragma tg_funcdef(convert_int2, convert_tg, int2, ulong2,  int, int)
#pragma tg_funcdef(convert_int2, convert_tg, int2, float2,  int, int)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(convert_int2, convert_tg, int2, double2, int, int)
 #endif
#undef convert_int2
#undef convert_int2_rte
#undef convert_int2_rtz
#undef convert_int2_rtp
#undef convert_int2_rtn
#undef convert_int2_sat
#undef convert_int2_sat_rte
#undef convert_int2_sat_rtz
#undef convert_int2_sat_rtp
#undef convert_int2_sat_rtn
#define convert_int2(__a)         __tg_builtin_gentype("convert_int2",__a,0,0)
#define convert_int2_rte(__a)     __tg_builtin_gentype("convert_int2",__a,0,1)
#define convert_int2_rtz(__a)     __tg_builtin_gentype("convert_int2",__a,0,2)
#define convert_int2_rtp(__a)     __tg_builtin_gentype("convert_int2",__a,0,3)
#define convert_int2_rtn(__a)     __tg_builtin_gentype("convert_int2",__a,0,4)
#define convert_int2_sat(__a)     __tg_builtin_gentype("convert_int2",__a,1,0)
#define convert_int2_sat_rte(__a) __tg_builtin_gentype("convert_int2",__a,1,1)
#define convert_int2_sat_rtz(__a) __tg_builtin_gentype("convert_int2",__a,1,2)
#define convert_int2_sat_rtp(__a) __tg_builtin_gentype("convert_int2",__a,1,3)
#define convert_int2_sat_rtn(__a) __tg_builtin_gentype("convert_int2",__a,1,4)

#pragma tg_funcdef(convert_int3, convert_tg, int3, char3,   int, int)
#pragma tg_funcdef(convert_int3, convert_tg, int3, uchar3,  int, int)
#pragma tg_funcdef(convert_int3, convert_tg, int3, short3,  int, int)
#pragma tg_funcdef(convert_int3, convert_tg, int3, ushort3, int, int)
#pragma tg_funcdef(convert_int3, convert_tg, int3, int3,    int, int)
#pragma tg_funcdef(convert_int3, convert_tg, int3, uint3,   int, int)
#pragma tg_funcdef(convert_int3, convert_tg, int3, long3,   int, int)
#pragma tg_funcdef(convert_int3, convert_tg, int3, ulong3,  int, int)
#pragma tg_funcdef(convert_int3, convert_tg, int3, float3,  int, int)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(convert_int3, convert_tg, int3, double3, int, int)
 #endif
#undef convert_int3
#undef convert_int3_rte
#undef convert_int3_rtz
#undef convert_int3_rtp
#undef convert_int3_rtn
#undef convert_int3_sat
#undef convert_int3_sat_rte
#undef convert_int3_sat_rtz
#undef convert_int3_sat_rtp
#undef convert_int3_sat_rtn
#define convert_int3(__a)         __tg_builtin_gentype("convert_int3",__a,0,0)
#define convert_int3_rte(__a)     __tg_builtin_gentype("convert_int3",__a,0,1)
#define convert_int3_rtz(__a)     __tg_builtin_gentype("convert_int3",__a,0,2)
#define convert_int3_rtp(__a)     __tg_builtin_gentype("convert_int3",__a,0,3)
#define convert_int3_rtn(__a)     __tg_builtin_gentype("convert_int3",__a,0,4)
#define convert_int3_sat(__a)     __tg_builtin_gentype("convert_int3",__a,1,0)
#define convert_int3_sat_rte(__a) __tg_builtin_gentype("convert_int3",__a,1,1)
#define convert_int3_sat_rtz(__a) __tg_builtin_gentype("convert_int3",__a,1,2)
#define convert_int3_sat_rtp(__a) __tg_builtin_gentype("convert_int3",__a,1,3)
#define convert_int3_sat_rtn(__a) __tg_builtin_gentype("convert_int3",__a,1,4)

#pragma tg_funcdef(convert_int4, convert_tg, int4, char4,   int, int)
#pragma tg_funcdef(convert_int4, convert_tg, int4, uchar4,  int, int)
#pragma tg_funcdef(convert_int4, convert_tg, int4, short4,  int, int)
#pragma tg_funcdef(convert_int4, convert_tg, int4, ushort4, int, int)
#pragma tg_funcdef(convert_int4, convert_tg, int4, int4,    int, int)
#pragma tg_funcdef(convert_int4, convert_tg, int4, uint4,   int, int)
#pragma tg_funcdef(convert_int4, convert_tg, int4, long4,   int, int)
#pragma tg_funcdef(convert_int4, convert_tg, int4, ulong4,  int, int)
#pragma tg_funcdef(convert_int4, convert_tg, int4, float4,  int, int)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(convert_int4, convert_tg, int4, double4, int, int)
 #endif
#undef convert_int4
#undef convert_int4_rte
#undef convert_int4_rtz
#undef convert_int4_rtp
#undef convert_int4_rtn
#undef convert_int4_sat
#undef convert_int4_sat_rte
#undef convert_int4_sat_rtz
#undef convert_int4_sat_rtp
#undef convert_int4_sat_rtn
#define convert_int4(__a)         __tg_builtin_gentype("convert_int4",__a,0,0)
#define convert_int4_rte(__a)     __tg_builtin_gentype("convert_int4",__a,0,1)
#define convert_int4_rtz(__a)     __tg_builtin_gentype("convert_int4",__a,0,2)
#define convert_int4_rtp(__a)     __tg_builtin_gentype("convert_int4",__a,0,3)
#define convert_int4_rtn(__a)     __tg_builtin_gentype("convert_int4",__a,0,4)
#define convert_int4_sat(__a)     __tg_builtin_gentype("convert_int4",__a,1,0)
#define convert_int4_sat_rte(__a) __tg_builtin_gentype("convert_int4",__a,1,1)
#define convert_int4_sat_rtz(__a) __tg_builtin_gentype("convert_int4",__a,1,2)
#define convert_int4_sat_rtp(__a) __tg_builtin_gentype("convert_int4",__a,1,3)
#define convert_int4_sat_rtn(__a) __tg_builtin_gentype("convert_int4",__a,1,4)

#pragma tg_funcdef(convert_int8, convert_tg, int8, char8,   int, int)
#pragma tg_funcdef(convert_int8, convert_tg, int8, uchar8,  int, int)
#pragma tg_funcdef(convert_int8, convert_tg, int8, short8,  int, int)
#pragma tg_funcdef(convert_int8, convert_tg, int8, ushort8, int, int)
#pragma tg_funcdef(convert_int8, convert_tg, int8, int8,    int, int)
#pragma tg_funcdef(convert_int8, convert_tg, int8, uint8,   int, int)
#pragma tg_funcdef(convert_int8, convert_tg, int8, long8,   int, int)
#pragma tg_funcdef(convert_int8, convert_tg, int8, ulong8,  int, int)
#pragma tg_funcdef(convert_int8, convert_tg, int8, float8,  int, int)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(convert_int8, convert_tg, int8, double8, int, int)
 #endif
#undef convert_int8
#undef convert_int8_rte
#undef convert_int8_rtz
#undef convert_int8_rtp
#undef convert_int8_rtn
#undef convert_int8_sat
#undef convert_int8_sat_rte
#undef convert_int8_sat_rtz
#undef convert_int8_sat_rtp
#undef convert_int8_sat_rtn
#define convert_int8(__a)         __tg_builtin_gentype("convert_int8",__a,0,0)
#define convert_int8_rte(__a)     __tg_builtin_gentype("convert_int8",__a,0,1)
#define convert_int8_rtz(__a)     __tg_builtin_gentype("convert_int8",__a,0,2)
#define convert_int8_rtp(__a)     __tg_builtin_gentype("convert_int8",__a,0,3)
#define convert_int8_rtn(__a)     __tg_builtin_gentype("convert_int8",__a,0,4)
#define convert_int8_sat(__a)     __tg_builtin_gentype("convert_int8",__a,1,0)
#define convert_int8_sat_rte(__a) __tg_builtin_gentype("convert_int8",__a,1,1)
#define convert_int8_sat_rtz(__a) __tg_builtin_gentype("convert_int8",__a,1,2)
#define convert_int8_sat_rtp(__a) __tg_builtin_gentype("convert_int8",__a,1,3)
#define convert_int8_sat_rtn(__a) __tg_builtin_gentype("convert_int8",__a,1,4)

#pragma tg_funcdef(convert_int16, convert_tg, int16, char16,   int, int)
#pragma tg_funcdef(convert_int16, convert_tg, int16, uchar16,  int, int)
#pragma tg_funcdef(convert_int16, convert_tg, int16, short16,  int, int)
#pragma tg_funcdef(convert_int16, convert_tg, int16, ushort16, int, int)
#pragma tg_funcdef(convert_int16, convert_tg, int16, int16,    int, int)
#pragma tg_funcdef(convert_int16, convert_tg, int16, uint16,   int, int)
#pragma tg_funcdef(convert_int16, convert_tg, int16, long16,   int, int)
#pragma tg_funcdef(convert_int16, convert_tg, int16, ulong16,  int, int)
#pragma tg_funcdef(convert_int16, convert_tg, int16, float16,  int, int)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(convert_int16, convert_tg, int16, double16, int, int)
 #endif
#undef convert_int16
#undef convert_int16_rte
#undef convert_int16_rtz
#undef convert_int16_rtp
#undef convert_int16_rtn
#undef convert_int16_sat
#undef convert_int16_sat_rte
#undef convert_int16_sat_rtz
#undef convert_int16_sat_rtp
#undef convert_int16_sat_rtn
#define convert_int16(__a)         __tg_builtin_gentype("convert_int16",__a,0,0)
#define convert_int16_rte(__a)     __tg_builtin_gentype("convert_int16",__a,0,1)
#define convert_int16_rtz(__a)     __tg_builtin_gentype("convert_int16",__a,0,2)
#define convert_int16_rtp(__a)     __tg_builtin_gentype("convert_int16",__a,0,3)
#define convert_int16_rtn(__a)     __tg_builtin_gentype("convert_int16",__a,0,4)
#define convert_int16_sat(__a)     __tg_builtin_gentype("convert_int16",__a,1,0)
#define convert_int16_sat_rte(__a) __tg_builtin_gentype("convert_int16",__a,1,1)
#define convert_int16_sat_rtz(__a) __tg_builtin_gentype("convert_int16",__a,1,2)
#define convert_int16_sat_rtp(__a) __tg_builtin_gentype("convert_int16",__a,1,3)
#define convert_int16_sat_rtn(__a) __tg_builtin_gentype("convert_int16",__a,1,4)

/* convert_uintN<_sat><_roundingMode> */

#pragma tg_funcdef(convert_uint, convert_tg, uint, char,   int, int)
#pragma tg_funcdef(convert_uint, convert_tg, uint, uchar,  int, int)
#pragma tg_funcdef(convert_uint, convert_tg, uint, short,  int, int)
#pragma tg_funcdef(convert_uint, convert_tg, uint, ushort, int, int)
#pragma tg_funcdef(convert_uint, convert_tg, uint, int,    int, int)
#pragma tg_funcdef(convert_uint, convert_tg, uint, uint,   int, int)
#pragma tg_funcdef(convert_uint, convert_tg, uint, long,   int, int)
#pragma tg_funcdef(convert_uint, convert_tg, uint, ulong,  int, int)
#pragma tg_funcdef(convert_uint, convert_tg, uint, float,  int, int)
#pragma tg_funcdef(convert_uint, convert_tg, uint, double, int, int)
#undef convert_uint
#undef convert_uint_rte
#undef convert_uint_rtz
#undef convert_uint_rtp
#undef convert_uint_rtn
#undef convert_uint_sat
#undef convert_uint_sat_rte
#undef convert_uint_sat_rtz
#undef convert_uint_sat_rtp
#undef convert_uint_sat_rtn
#define convert_uint(__a)         __tg_builtin_gentype("convert_uint",__a,0,0)
#define convert_uint_rte(__a)     __tg_builtin_gentype("convert_uint",__a,0,1)
#define convert_uint_rtz(__a)     __tg_builtin_gentype("convert_uint",__a,0,2)
#define convert_uint_rtp(__a)     __tg_builtin_gentype("convert_uint",__a,0,3)
#define convert_uint_rtn(__a)     __tg_builtin_gentype("convert_uint",__a,0,4)
#define convert_uint_sat(__a)     __tg_builtin_gentype("convert_uint",__a,1,0)
#define convert_uint_sat_rte(__a) __tg_builtin_gentype("convert_uint",__a,1,1)
#define convert_uint_sat_rtz(__a) __tg_builtin_gentype("convert_uint",__a,1,2)
#define convert_uint_sat_rtp(__a) __tg_builtin_gentype("convert_uint",__a,1,3)
#define convert_uint_sat_rtn(__a) __tg_builtin_gentype("convert_uint",__a,1,4)

#pragma tg_funcdef(convert_uint2, convert_tg, uint2, char2,   int, int)
#pragma tg_funcdef(convert_uint2, convert_tg, uint2, uchar2,  int, int)
#pragma tg_funcdef(convert_uint2, convert_tg, uint2, short2,  int, int)
#pragma tg_funcdef(convert_uint2, convert_tg, uint2, ushort2, int, int)
#pragma tg_funcdef(convert_uint2, convert_tg, uint2, int2,    int, int)
#pragma tg_funcdef(convert_uint2, convert_tg, uint2, uint2,   int, int)
#pragma tg_funcdef(convert_uint2, convert_tg, uint2, long2,   int, int)
#pragma tg_funcdef(convert_uint2, convert_tg, uint2, ulong2,  int, int)
#pragma tg_funcdef(convert_uint2, convert_tg, uint2, float2,  int, int)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(convert_uint2, convert_tg, uint2, double2, int, int)
 #endif
#undef convert_uint2
#undef convert_uint2_rte
#undef convert_uint2_rtz
#undef convert_uint2_rtp
#undef convert_uint2_rtn
#undef convert_uint2_sat
#undef convert_uint2_sat_rte
#undef convert_uint2_sat_rtz
#undef convert_uint2_sat_rtp
#undef convert_uint2_sat_rtn
#define convert_uint2(__a)         __tg_builtin_gentype("convert_uint2",__a,0,0)
#define convert_uint2_rte(__a)     __tg_builtin_gentype("convert_uint2",__a,0,1)
#define convert_uint2_rtz(__a)     __tg_builtin_gentype("convert_uint2",__a,0,2)
#define convert_uint2_rtp(__a)     __tg_builtin_gentype("convert_uint2",__a,0,3)
#define convert_uint2_rtn(__a)     __tg_builtin_gentype("convert_uint2",__a,0,4)
#define convert_uint2_sat(__a)     __tg_builtin_gentype("convert_uint2",__a,1,0)
#define convert_uint2_sat_rte(__a) __tg_builtin_gentype("convert_uint2",__a,1,1)
#define convert_uint2_sat_rtz(__a) __tg_builtin_gentype("convert_uint2",__a,1,2)
#define convert_uint2_sat_rtp(__a) __tg_builtin_gentype("convert_uint2",__a,1,3)
#define convert_uint2_sat_rtn(__a) __tg_builtin_gentype("convert_uint2",__a,1,4)

#pragma tg_funcdef(convert_uint3, convert_tg, uint3, char3,   int, int)
#pragma tg_funcdef(convert_uint3, convert_tg, uint3, uchar3,  int, int)
#pragma tg_funcdef(convert_uint3, convert_tg, uint3, short3,  int, int)
#pragma tg_funcdef(convert_uint3, convert_tg, uint3, ushort3, int, int)
#pragma tg_funcdef(convert_uint3, convert_tg, uint3, int3,    int, int)
#pragma tg_funcdef(convert_uint3, convert_tg, uint3, uint3,   int, int)
#pragma tg_funcdef(convert_uint3, convert_tg, uint3, long3,   int, int)
#pragma tg_funcdef(convert_uint3, convert_tg, uint3, ulong3,  int, int)
#pragma tg_funcdef(convert_uint3, convert_tg, uint3, float3,  int, int)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(convert_uint3, convert_tg, uint3, double3, int, int)
 #endif
#undef convert_uint3
#undef convert_uint3_rte
#undef convert_uint3_rtz
#undef convert_uint3_rtp
#undef convert_uint3_rtn
#undef convert_uint3_sat
#undef convert_uint3_sat_rte
#undef convert_uint3_sat_rtz
#undef convert_uint3_sat_rtp
#undef convert_uint3_sat_rtn
#define convert_uint3(__a)         __tg_builtin_gentype("convert_uint3",__a,0,0)
#define convert_uint3_rte(__a)     __tg_builtin_gentype("convert_uint3",__a,0,1)
#define convert_uint3_rtz(__a)     __tg_builtin_gentype("convert_uint3",__a,0,2)
#define convert_uint3_rtp(__a)     __tg_builtin_gentype("convert_uint3",__a,0,3)
#define convert_uint3_rtn(__a)     __tg_builtin_gentype("convert_uint3",__a,0,4)
#define convert_uint3_sat(__a)     __tg_builtin_gentype("convert_uint3",__a,1,0)
#define convert_uint3_sat_rte(__a) __tg_builtin_gentype("convert_uint3",__a,1,1)
#define convert_uint3_sat_rtz(__a) __tg_builtin_gentype("convert_uint3",__a,1,2)
#define convert_uint3_sat_rtp(__a) __tg_builtin_gentype("convert_uint3",__a,1,3)
#define convert_uint3_sat_rtn(__a) __tg_builtin_gentype("convert_uint3",__a,1,4)

#pragma tg_funcdef(convert_uint4, convert_tg, uint4, char4,   int, int)
#pragma tg_funcdef(convert_uint4, convert_tg, uint4, uchar4,  int, int)
#pragma tg_funcdef(convert_uint4, convert_tg, uint4, short4,  int, int)
#pragma tg_funcdef(convert_uint4, convert_tg, uint4, ushort4, int, int)
#pragma tg_funcdef(convert_uint4, convert_tg, uint4, int4,    int, int)
#pragma tg_funcdef(convert_uint4, convert_tg, uint4, uint4,   int, int)
#pragma tg_funcdef(convert_uint4, convert_tg, uint4, long4,   int, int)
#pragma tg_funcdef(convert_uint4, convert_tg, uint4, ulong4,  int, int)
#pragma tg_funcdef(convert_uint4, convert_tg, uint4, float4,  int, int)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(convert_uint4, convert_tg, uint4, double4, int, int)
 #endif
#undef convert_uint4
#undef convert_uint4_rte
#undef convert_uint4_rtz
#undef convert_uint4_rtp
#undef convert_uint4_rtn
#undef convert_uint4_sat
#undef convert_uint4_sat_rte
#undef convert_uint4_sat_rtz
#undef convert_uint4_sat_rtp
#undef convert_uint4_sat_rtn
#define convert_uint4(__a)         __tg_builtin_gentype("convert_uint4",__a,0,0)
#define convert_uint4_rte(__a)     __tg_builtin_gentype("convert_uint4",__a,0,1)
#define convert_uint4_rtz(__a)     __tg_builtin_gentype("convert_uint4",__a,0,2)
#define convert_uint4_rtp(__a)     __tg_builtin_gentype("convert_uint4",__a,0,3)
#define convert_uint4_rtn(__a)     __tg_builtin_gentype("convert_uint4",__a,0,4)
#define convert_uint4_sat(__a)     __tg_builtin_gentype("convert_uint4",__a,1,0)
#define convert_uint4_sat_rte(__a) __tg_builtin_gentype("convert_uint4",__a,1,1)
#define convert_uint4_sat_rtz(__a) __tg_builtin_gentype("convert_uint4",__a,1,2)
#define convert_uint4_sat_rtp(__a) __tg_builtin_gentype("convert_uint4",__a,1,3)
#define convert_uint4_sat_rtn(__a) __tg_builtin_gentype("convert_uint4",__a,1,4)

#pragma tg_funcdef(convert_uint8, convert_tg, uint8, char8,   int, int)
#pragma tg_funcdef(convert_uint8, convert_tg, uint8, uchar8,  int, int)
#pragma tg_funcdef(convert_uint8, convert_tg, uint8, short8,  int, int)
#pragma tg_funcdef(convert_uint8, convert_tg, uint8, ushort8, int, int)
#pragma tg_funcdef(convert_uint8, convert_tg, uint8, int8,    int, int)
#pragma tg_funcdef(convert_uint8, convert_tg, uint8, uint8,   int, int)
#pragma tg_funcdef(convert_uint8, convert_tg, uint8, long8,   int, int)
#pragma tg_funcdef(convert_uint8, convert_tg, uint8, ulong8,  int, int)
#pragma tg_funcdef(convert_uint8, convert_tg, uint8, float8,  int, int)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(convert_uint8, convert_tg, uint8, double8, int, int)
 #endif
#undef convert_uint8
#undef convert_uint8_rte
#undef convert_uint8_rtz
#undef convert_uint8_rtp
#undef convert_uint8_rtn
#undef convert_uint8_sat
#undef convert_uint8_sat_rte
#undef convert_uint8_sat_rtz
#undef convert_uint8_sat_rtp
#undef convert_uint8_sat_rtn
#define convert_uint8(__a)         __tg_builtin_gentype("convert_uint8",__a,0,0)
#define convert_uint8_rte(__a)     __tg_builtin_gentype("convert_uint8",__a,0,1)
#define convert_uint8_rtz(__a)     __tg_builtin_gentype("convert_uint8",__a,0,2)
#define convert_uint8_rtp(__a)     __tg_builtin_gentype("convert_uint8",__a,0,3)
#define convert_uint8_rtn(__a)     __tg_builtin_gentype("convert_uint8",__a,0,4)
#define convert_uint8_sat(__a)     __tg_builtin_gentype("convert_uint8",__a,1,0)
#define convert_uint8_sat_rte(__a) __tg_builtin_gentype("convert_uint8",__a,1,1)
#define convert_uint8_sat_rtz(__a) __tg_builtin_gentype("convert_uint8",__a,1,2)
#define convert_uint8_sat_rtp(__a) __tg_builtin_gentype("convert_uint8",__a,1,3)
#define convert_uint8_sat_rtn(__a) __tg_builtin_gentype("convert_uint8",__a,1,4)

#pragma tg_funcdef(convert_uint16, convert_tg, uint16, char16,   int, int)
#pragma tg_funcdef(convert_uint16, convert_tg, uint16, uchar16,  int, int)
#pragma tg_funcdef(convert_uint16, convert_tg, uint16, short16,  int, int)
#pragma tg_funcdef(convert_uint16, convert_tg, uint16, ushort16, int, int)
#pragma tg_funcdef(convert_uint16, convert_tg, uint16, int16,    int, int)
#pragma tg_funcdef(convert_uint16, convert_tg, uint16, uint16,   int, int)
#pragma tg_funcdef(convert_uint16, convert_tg, uint16, long16,   int, int)
#pragma tg_funcdef(convert_uint16, convert_tg, uint16, ulong16,  int, int)
#pragma tg_funcdef(convert_uint16, convert_tg, uint16, float16,  int, int)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(convert_uint16, convert_tg, uint16, double16, int, int)
 #endif
#undef convert_uint16
#undef convert_uint16_rte
#undef convert_uint16_rtz
#undef convert_uint16_rtp
#undef convert_uint16_rtn
#undef convert_uint16_sat
#undef convert_uint16_sat_rte
#undef convert_uint16_sat_rtz
#undef convert_uint16_sat_rtp
#undef convert_uint16_sat_rtn
#define convert_uint16(__a)         __tg_builtin_gentype("convert_uint16",__a,0,0)
#define convert_uint16_rte(__a)     __tg_builtin_gentype("convert_uint16",__a,0,1)
#define convert_uint16_rtz(__a)     __tg_builtin_gentype("convert_uint16",__a,0,2)
#define convert_uint16_rtp(__a)     __tg_builtin_gentype("convert_uint16",__a,0,3)
#define convert_uint16_rtn(__a)     __tg_builtin_gentype("convert_uint16",__a,0,4)
#define convert_uint16_sat(__a)     __tg_builtin_gentype("convert_uint16",__a,1,0)
#define convert_uint16_sat_rte(__a) __tg_builtin_gentype("convert_uint16",__a,1,1)
#define convert_uint16_sat_rtz(__a) __tg_builtin_gentype("convert_uint16",__a,1,2)
#define convert_uint16_sat_rtp(__a) __tg_builtin_gentype("convert_uint16",__a,1,3)
#define convert_uint16_sat_rtn(__a) __tg_builtin_gentype("convert_uint16",__a,1,4)

/* convert_longN<_sat><_roundingMode> */

#pragma tg_funcdef(convert_long, convert_tg, long, char,   int, int)
#pragma tg_funcdef(convert_long, convert_tg, long, uchar,  int, int)
#pragma tg_funcdef(convert_long, convert_tg, long, short,  int, int)
#pragma tg_funcdef(convert_long, convert_tg, long, ushort, int, int)
#pragma tg_funcdef(convert_long, convert_tg, long, int,    int, int)
#pragma tg_funcdef(convert_long, convert_tg, long, uint,   int, int)
#pragma tg_funcdef(convert_long, convert_tg, long, long,   int, int)
#pragma tg_funcdef(convert_long, convert_tg, long, ulong,  int, int)
#pragma tg_funcdef(convert_long, convert_tg, long, float,  int, int)
#pragma tg_funcdef(convert_long, convert_tg, long, double, int, int)
#undef convert_long
#undef convert_long_rte
#undef convert_long_rtz
#undef convert_long_rtp
#undef convert_long_rtn
#undef convert_long_sat
#undef convert_long_sat_rte
#undef convert_long_sat_rtz
#undef convert_long_sat_rtp
#undef convert_long_sat_rtn
#define convert_long(__a)         __tg_builtin_gentype("convert_long",__a,0,0)
#define convert_long_rte(__a)     __tg_builtin_gentype("convert_long",__a,0,1)
#define convert_long_rtz(__a)     __tg_builtin_gentype("convert_long",__a,0,2)
#define convert_long_rtp(__a)     __tg_builtin_gentype("convert_long",__a,0,3)
#define convert_long_rtn(__a)     __tg_builtin_gentype("convert_long",__a,0,4)
#define convert_long_sat(__a)     __tg_builtin_gentype("convert_long",__a,1,0)
#define convert_long_sat_rte(__a) __tg_builtin_gentype("convert_long",__a,1,1)
#define convert_long_sat_rtz(__a) __tg_builtin_gentype("convert_long",__a,1,2)
#define convert_long_sat_rtp(__a) __tg_builtin_gentype("convert_long",__a,1,3)
#define convert_long_sat_rtn(__a) __tg_builtin_gentype("convert_long",__a,1,4)

#pragma tg_funcdef(convert_long2, convert_tg, long2, char2,   int, int)
#pragma tg_funcdef(convert_long2, convert_tg, long2, uchar2,  int, int)
#pragma tg_funcdef(convert_long2, convert_tg, long2, short2,  int, int)
#pragma tg_funcdef(convert_long2, convert_tg, long2, ushort2, int, int)
#pragma tg_funcdef(convert_long2, convert_tg, long2, int2,    int, int)
#pragma tg_funcdef(convert_long2, convert_tg, long2, uint2,   int, int)
#pragma tg_funcdef(convert_long2, convert_tg, long2, long2,   int, int)
#pragma tg_funcdef(convert_long2, convert_tg, long2, ulong2,  int, int)
#pragma tg_funcdef(convert_long2, convert_tg, long2, float2,  int, int)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(convert_long2, convert_tg, long2, double2, int, int)
 #endif
#undef convert_long2
#undef convert_long2_rte
#undef convert_long2_rtz
#undef convert_long2_rtp
#undef convert_long2_rtn
#undef convert_long2_sat
#undef convert_long2_sat_rte
#undef convert_long2_sat_rtz
#undef convert_long2_sat_rtp
#undef convert_long2_sat_rtn
#define convert_long2(__a)         __tg_builtin_gentype("convert_long2",__a,0,0)
#define convert_long2_rte(__a)     __tg_builtin_gentype("convert_long2",__a,0,1)
#define convert_long2_rtz(__a)     __tg_builtin_gentype("convert_long2",__a,0,2)
#define convert_long2_rtp(__a)     __tg_builtin_gentype("convert_long2",__a,0,3)
#define convert_long2_rtn(__a)     __tg_builtin_gentype("convert_long2",__a,0,4)
#define convert_long2_sat(__a)     __tg_builtin_gentype("convert_long2",__a,1,0)
#define convert_long2_sat_rte(__a) __tg_builtin_gentype("convert_long2",__a,1,1)
#define convert_long2_sat_rtz(__a) __tg_builtin_gentype("convert_long2",__a,1,2)
#define convert_long2_sat_rtp(__a) __tg_builtin_gentype("convert_long2",__a,1,3)
#define convert_long2_sat_rtn(__a) __tg_builtin_gentype("convert_long2",__a,1,4)

#pragma tg_funcdef(convert_long3, convert_tg, long3, char3,   int, int)
#pragma tg_funcdef(convert_long3, convert_tg, long3, uchar3,  int, int)
#pragma tg_funcdef(convert_long3, convert_tg, long3, short3,  int, int)
#pragma tg_funcdef(convert_long3, convert_tg, long3, ushort3, int, int)
#pragma tg_funcdef(convert_long3, convert_tg, long3, int3,    int, int)
#pragma tg_funcdef(convert_long3, convert_tg, long3, uint3,   int, int)
#pragma tg_funcdef(convert_long3, convert_tg, long3, long3,   int, int)
#pragma tg_funcdef(convert_long3, convert_tg, long3, ulong3,  int, int)
#pragma tg_funcdef(convert_long3, convert_tg, long3, float3,  int, int)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(convert_long3, convert_tg, long3, double3, int, int)
 #endif
#undef convert_long3
#undef convert_long3_rte
#undef convert_long3_rtz
#undef convert_long3_rtp
#undef convert_long3_rtn
#undef convert_long3_sat
#undef convert_long3_sat_rte
#undef convert_long3_sat_rtz
#undef convert_long3_sat_rtp
#undef convert_long3_sat_rtn
#define convert_long3(__a)         __tg_builtin_gentype("convert_long3",__a,0,0)
#define convert_long3_rte(__a)     __tg_builtin_gentype("convert_long3",__a,0,1)
#define convert_long3_rtz(__a)     __tg_builtin_gentype("convert_long3",__a,0,2)
#define convert_long3_rtp(__a)     __tg_builtin_gentype("convert_long3",__a,0,3)
#define convert_long3_rtn(__a)     __tg_builtin_gentype("convert_long3",__a,0,4)
#define convert_long3_sat(__a)     __tg_builtin_gentype("convert_long3",__a,1,0)
#define convert_long3_sat_rte(__a) __tg_builtin_gentype("convert_long3",__a,1,1)
#define convert_long3_sat_rtz(__a) __tg_builtin_gentype("convert_long3",__a,1,2)
#define convert_long3_sat_rtp(__a) __tg_builtin_gentype("convert_long3",__a,1,3)
#define convert_long3_sat_rtn(__a) __tg_builtin_gentype("convert_long3",__a,1,4)

#pragma tg_funcdef(convert_long4, convert_tg, long4, char4,   int, int)
#pragma tg_funcdef(convert_long4, convert_tg, long4, uchar4,  int, int)
#pragma tg_funcdef(convert_long4, convert_tg, long4, short4,  int, int)
#pragma tg_funcdef(convert_long4, convert_tg, long4, ushort4, int, int)
#pragma tg_funcdef(convert_long4, convert_tg, long4, int4,    int, int)
#pragma tg_funcdef(convert_long4, convert_tg, long4, uint4,   int, int)
#pragma tg_funcdef(convert_long4, convert_tg, long4, long4,   int, int)
#pragma tg_funcdef(convert_long4, convert_tg, long4, ulong4,  int, int)
#pragma tg_funcdef(convert_long4, convert_tg, long4, float4,  int, int)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(convert_long4, convert_tg, long4, double4, int, int)
 #endif
#undef convert_long4
#undef convert_long4_rte
#undef convert_long4_rtz
#undef convert_long4_rtp
#undef convert_long4_rtn
#undef convert_long4_sat
#undef convert_long4_sat_rte
#undef convert_long4_sat_rtz
#undef convert_long4_sat_rtp
#undef convert_long4_sat_rtn
#define convert_long4(__a)         __tg_builtin_gentype("convert_long4",__a,0,0)
#define convert_long4_rte(__a)     __tg_builtin_gentype("convert_long4",__a,0,1)
#define convert_long4_rtz(__a)     __tg_builtin_gentype("convert_long4",__a,0,2)
#define convert_long4_rtp(__a)     __tg_builtin_gentype("convert_long4",__a,0,3)
#define convert_long4_rtn(__a)     __tg_builtin_gentype("convert_long4",__a,0,4)
#define convert_long4_sat(__a)     __tg_builtin_gentype("convert_long4",__a,1,0)
#define convert_long4_sat_rte(__a) __tg_builtin_gentype("convert_long4",__a,1,1)
#define convert_long4_sat_rtz(__a) __tg_builtin_gentype("convert_long4",__a,1,2)
#define convert_long4_sat_rtp(__a) __tg_builtin_gentype("convert_long4",__a,1,3)
#define convert_long4_sat_rtn(__a) __tg_builtin_gentype("convert_long4",__a,1,4)

#pragma tg_funcdef(convert_long8, convert_tg, long8, char8,   int, int)
#pragma tg_funcdef(convert_long8, convert_tg, long8, uchar8,  int, int)
#pragma tg_funcdef(convert_long8, convert_tg, long8, short8,  int, int)
#pragma tg_funcdef(convert_long8, convert_tg, long8, ushort8, int, int)
#pragma tg_funcdef(convert_long8, convert_tg, long8, int8,    int, int)
#pragma tg_funcdef(convert_long8, convert_tg, long8, uint8,   int, int)
#pragma tg_funcdef(convert_long8, convert_tg, long8, long8,   int, int)
#pragma tg_funcdef(convert_long8, convert_tg, long8, ulong8,  int, int)
#pragma tg_funcdef(convert_long8, convert_tg, long8, float8,  int, int)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(convert_long8, convert_tg, long8, double8, int, int)
 #endif
#undef convert_long8
#undef convert_long8_rte
#undef convert_long8_rtz
#undef convert_long8_rtp
#undef convert_long8_rtn
#undef convert_long8_sat
#undef convert_long8_sat_rte
#undef convert_long8_sat_rtz
#undef convert_long8_sat_rtp
#undef convert_long8_sat_rtn
#define convert_long8(__a)         __tg_builtin_gentype("convert_long8",__a,0,0)
#define convert_long8_rte(__a)     __tg_builtin_gentype("convert_long8",__a,0,1)
#define convert_long8_rtz(__a)     __tg_builtin_gentype("convert_long8",__a,0,2)
#define convert_long8_rtp(__a)     __tg_builtin_gentype("convert_long8",__a,0,3)
#define convert_long8_rtn(__a)     __tg_builtin_gentype("convert_long8",__a,0,4)
#define convert_long8_sat(__a)     __tg_builtin_gentype("convert_long8",__a,1,0)
#define convert_long8_sat_rte(__a) __tg_builtin_gentype("convert_long8",__a,1,1)
#define convert_long8_sat_rtz(__a) __tg_builtin_gentype("convert_long8",__a,1,2)
#define convert_long8_sat_rtp(__a) __tg_builtin_gentype("convert_long8",__a,1,3)
#define convert_long8_sat_rtn(__a) __tg_builtin_gentype("convert_long8",__a,1,4)

#pragma tg_funcdef(convert_long16, convert_tg, long16, char16,   int, int)
#pragma tg_funcdef(convert_long16, convert_tg, long16, uchar16,  int, int)
#pragma tg_funcdef(convert_long16, convert_tg, long16, short16,  int, int)
#pragma tg_funcdef(convert_long16, convert_tg, long16, ushort16, int, int)
#pragma tg_funcdef(convert_long16, convert_tg, long16, int16,    int, int)
#pragma tg_funcdef(convert_long16, convert_tg, long16, uint16,   int, int)
#pragma tg_funcdef(convert_long16, convert_tg, long16, long16,   int, int)
#pragma tg_funcdef(convert_long16, convert_tg, long16, ulong16,  int, int)
#pragma tg_funcdef(convert_long16, convert_tg, long16, float16,  int, int)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(convert_long16, convert_tg, long16, double16, int, int)
 #endif
#undef convert_long16
#undef convert_long16_rte
#undef convert_long16_rtz
#undef convert_long16_rtp
#undef convert_long16_rtn
#undef convert_long16_sat
#undef convert_long16_sat_rte
#undef convert_long16_sat_rtz
#undef convert_long16_sat_rtp
#undef convert_long16_sat_rtn
#define convert_long16(__a)         __tg_builtin_gentype("convert_long16",__a,0,0)
#define convert_long16_rte(__a)     __tg_builtin_gentype("convert_long16",__a,0,1)
#define convert_long16_rtz(__a)     __tg_builtin_gentype("convert_long16",__a,0,2)
#define convert_long16_rtp(__a)     __tg_builtin_gentype("convert_long16",__a,0,3)
#define convert_long16_rtn(__a)     __tg_builtin_gentype("convert_long16",__a,0,4)
#define convert_long16_sat(__a)     __tg_builtin_gentype("convert_long16",__a,1,0)
#define convert_long16_sat_rte(__a) __tg_builtin_gentype("convert_long16",__a,1,1)
#define convert_long16_sat_rtz(__a) __tg_builtin_gentype("convert_long16",__a,1,2)
#define convert_long16_sat_rtp(__a) __tg_builtin_gentype("convert_long16",__a,1,3)
#define convert_long16_sat_rtn(__a) __tg_builtin_gentype("convert_long16",__a,1,4)

/* convert_ulongN<_sat><_roundingMode> */

#pragma tg_funcdef(convert_ulong, convert_tg, ulong, char,   int, int)
#pragma tg_funcdef(convert_ulong, convert_tg, ulong, uchar,  int, int)
#pragma tg_funcdef(convert_ulong, convert_tg, ulong, short,  int, int)
#pragma tg_funcdef(convert_ulong, convert_tg, ulong, ushort, int, int)
#pragma tg_funcdef(convert_ulong, convert_tg, ulong, int,    int, int)
#pragma tg_funcdef(convert_ulong, convert_tg, ulong, uint,   int, int)
#pragma tg_funcdef(convert_ulong, convert_tg, ulong, long,   int, int)
#pragma tg_funcdef(convert_ulong, convert_tg, ulong, ulong,  int, int)
#pragma tg_funcdef(convert_ulong, convert_tg, ulong, float,  int, int)
#pragma tg_funcdef(convert_ulong, convert_tg, ulong, double, int, int)
#undef convert_ulong
#undef convert_ulong_rte
#undef convert_ulong_rtz
#undef convert_ulong_rtp
#undef convert_ulong_rtn
#undef convert_ulong_sat
#undef convert_ulong_sat_rte
#undef convert_ulong_sat_rtz
#undef convert_ulong_sat_rtp
#undef convert_ulong_sat_rtn
#define convert_ulong(__a)         __tg_builtin_gentype("convert_ulong",__a,0,0)
#define convert_ulong_rte(__a)     __tg_builtin_gentype("convert_ulong",__a,0,1)
#define convert_ulong_rtz(__a)     __tg_builtin_gentype("convert_ulong",__a,0,2)
#define convert_ulong_rtp(__a)     __tg_builtin_gentype("convert_ulong",__a,0,3)
#define convert_ulong_rtn(__a)     __tg_builtin_gentype("convert_ulong",__a,0,4)
#define convert_ulong_sat(__a)     __tg_builtin_gentype("convert_ulong",__a,1,0)
#define convert_ulong_sat_rte(__a) __tg_builtin_gentype("convert_ulong",__a,1,1)
#define convert_ulong_sat_rtz(__a) __tg_builtin_gentype("convert_ulong",__a,1,2)
#define convert_ulong_sat_rtp(__a) __tg_builtin_gentype("convert_ulong",__a,1,3)
#define convert_ulong_sat_rtn(__a) __tg_builtin_gentype("convert_ulong",__a,1,4)

#pragma tg_funcdef(convert_ulong2, convert_tg, ulong2, char2,   int, int)
#pragma tg_funcdef(convert_ulong2, convert_tg, ulong2, uchar2,  int, int)
#pragma tg_funcdef(convert_ulong2, convert_tg, ulong2, short2,  int, int)
#pragma tg_funcdef(convert_ulong2, convert_tg, ulong2, ushort2, int, int)
#pragma tg_funcdef(convert_ulong2, convert_tg, ulong2, int2,    int, int)
#pragma tg_funcdef(convert_ulong2, convert_tg, ulong2, uint2,   int, int)
#pragma tg_funcdef(convert_ulong2, convert_tg, ulong2, long2,   int, int)
#pragma tg_funcdef(convert_ulong2, convert_tg, ulong2, ulong2,  int, int)
#pragma tg_funcdef(convert_ulong2, convert_tg, ulong2, float2,  int, int)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(convert_ulong2, convert_tg, ulong2, double2, int, int)
 #endif
#undef convert_ulong2
#undef convert_ulong2_rte
#undef convert_ulong2_rtz
#undef convert_ulong2_rtp
#undef convert_ulong2_rtn
#undef convert_ulong2_sat
#undef convert_ulong2_sat_rte
#undef convert_ulong2_sat_rtz
#undef convert_ulong2_sat_rtp
#undef convert_ulong2_sat_rtn
#define convert_ulong2(__a)         __tg_builtin_gentype("convert_ulong2",__a,0,0)
#define convert_ulong2_rte(__a)     __tg_builtin_gentype("convert_ulong2",__a,0,1)
#define convert_ulong2_rtz(__a)     __tg_builtin_gentype("convert_ulong2",__a,0,2)
#define convert_ulong2_rtp(__a)     __tg_builtin_gentype("convert_ulong2",__a,0,3)
#define convert_ulong2_rtn(__a)     __tg_builtin_gentype("convert_ulong2",__a,0,4)
#define convert_ulong2_sat(__a)     __tg_builtin_gentype("convert_ulong2",__a,1,0)
#define convert_ulong2_sat_rte(__a) __tg_builtin_gentype("convert_ulong2",__a,1,1)
#define convert_ulong2_sat_rtz(__a) __tg_builtin_gentype("convert_ulong2",__a,1,2)
#define convert_ulong2_sat_rtp(__a) __tg_builtin_gentype("convert_ulong2",__a,1,3)
#define convert_ulong2_sat_rtn(__a) __tg_builtin_gentype("convert_ulong2",__a,1,4)

#pragma tg_funcdef(convert_ulong3, convert_tg, ulong3, char3,   int, int)
#pragma tg_funcdef(convert_ulong3, convert_tg, ulong3, uchar3,  int, int)
#pragma tg_funcdef(convert_ulong3, convert_tg, ulong3, short3,  int, int)
#pragma tg_funcdef(convert_ulong3, convert_tg, ulong3, ushort3, int, int)
#pragma tg_funcdef(convert_ulong3, convert_tg, ulong3, int3,    int, int)
#pragma tg_funcdef(convert_ulong3, convert_tg, ulong3, uint3,   int, int)
#pragma tg_funcdef(convert_ulong3, convert_tg, ulong3, long3,   int, int)
#pragma tg_funcdef(convert_ulong3, convert_tg, ulong3, ulong3,  int, int)
#pragma tg_funcdef(convert_ulong3, convert_tg, ulong3, float3,  int, int)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(convert_ulong3, convert_tg, ulong3, double3, int, int)
 #endif
#undef convert_ulong3
#undef convert_ulong3_rte
#undef convert_ulong3_rtz
#undef convert_ulong3_rtp
#undef convert_ulong3_rtn
#undef convert_ulong3_sat
#undef convert_ulong3_sat_rte
#undef convert_ulong3_sat_rtz
#undef convert_ulong3_sat_rtp
#undef convert_ulong3_sat_rtn
#define convert_ulong3(__a)         __tg_builtin_gentype("convert_ulong3",__a,0,0)
#define convert_ulong3_rte(__a)     __tg_builtin_gentype("convert_ulong3",__a,0,1)
#define convert_ulong3_rtz(__a)     __tg_builtin_gentype("convert_ulong3",__a,0,2)
#define convert_ulong3_rtp(__a)     __tg_builtin_gentype("convert_ulong3",__a,0,3)
#define convert_ulong3_rtn(__a)     __tg_builtin_gentype("convert_ulong3",__a,0,4)
#define convert_ulong3_sat(__a)     __tg_builtin_gentype("convert_ulong3",__a,1,0)
#define convert_ulong3_sat_rte(__a) __tg_builtin_gentype("convert_ulong3",__a,1,1)
#define convert_ulong3_sat_rtz(__a) __tg_builtin_gentype("convert_ulong3",__a,1,2)
#define convert_ulong3_sat_rtp(__a) __tg_builtin_gentype("convert_ulong3",__a,1,3)
#define convert_ulong3_sat_rtn(__a) __tg_builtin_gentype("convert_ulong3",__a,1,4)

#pragma tg_funcdef(convert_ulong4, convert_tg, ulong4, char4,   int, int)
#pragma tg_funcdef(convert_ulong4, convert_tg, ulong4, uchar4,  int, int)
#pragma tg_funcdef(convert_ulong4, convert_tg, ulong4, short4,  int, int)
#pragma tg_funcdef(convert_ulong4, convert_tg, ulong4, ushort4, int, int)
#pragma tg_funcdef(convert_ulong4, convert_tg, ulong4, int4,    int, int)
#pragma tg_funcdef(convert_ulong4, convert_tg, ulong4, uint4,   int, int)
#pragma tg_funcdef(convert_ulong4, convert_tg, ulong4, long4,   int, int)
#pragma tg_funcdef(convert_ulong4, convert_tg, ulong4, ulong4,  int, int)
#pragma tg_funcdef(convert_ulong4, convert_tg, ulong4, float4,  int, int)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(convert_ulong4, convert_tg, ulong4, double4, int, int)
 #endif
#undef convert_ulong4
#undef convert_ulong4_rte
#undef convert_ulong4_rtz
#undef convert_ulong4_rtp
#undef convert_ulong4_rtn
#undef convert_ulong4_sat
#undef convert_ulong4_sat_rte
#undef convert_ulong4_sat_rtz
#undef convert_ulong4_sat_rtp
#undef convert_ulong4_sat_rtn
#define convert_ulong4(__a)         __tg_builtin_gentype("convert_ulong4",__a,0,0)
#define convert_ulong4_rte(__a)     __tg_builtin_gentype("convert_ulong4",__a,0,1)
#define convert_ulong4_rtz(__a)     __tg_builtin_gentype("convert_ulong4",__a,0,2)
#define convert_ulong4_rtp(__a)     __tg_builtin_gentype("convert_ulong4",__a,0,3)
#define convert_ulong4_rtn(__a)     __tg_builtin_gentype("convert_ulong4",__a,0,4)
#define convert_ulong4_sat(__a)     __tg_builtin_gentype("convert_ulong4",__a,1,0)
#define convert_ulong4_sat_rte(__a) __tg_builtin_gentype("convert_ulong4",__a,1,1)
#define convert_ulong4_sat_rtz(__a) __tg_builtin_gentype("convert_ulong4",__a,1,2)
#define convert_ulong4_sat_rtp(__a) __tg_builtin_gentype("convert_ulong4",__a,1,3)
#define convert_ulong4_sat_rtn(__a) __tg_builtin_gentype("convert_ulong4",__a,1,4)

#pragma tg_funcdef(convert_ulong8, convert_tg, ulong8, char8,   int, int)
#pragma tg_funcdef(convert_ulong8, convert_tg, ulong8, uchar8,  int, int)
#pragma tg_funcdef(convert_ulong8, convert_tg, ulong8, short8,  int, int)
#pragma tg_funcdef(convert_ulong8, convert_tg, ulong8, ushort8, int, int)
#pragma tg_funcdef(convert_ulong8, convert_tg, ulong8, int8,    int, int)
#pragma tg_funcdef(convert_ulong8, convert_tg, ulong8, uint8,   int, int)
#pragma tg_funcdef(convert_ulong8, convert_tg, ulong8, long8,   int, int)
#pragma tg_funcdef(convert_ulong8, convert_tg, ulong8, ulong8,  int, int)
#pragma tg_funcdef(convert_ulong8, convert_tg, ulong8, float8,  int, int)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(convert_ulong8, convert_tg, ulong8, double8, int, int)
 #endif
#undef convert_ulong8
#undef convert_ulong8_rte
#undef convert_ulong8_rtz
#undef convert_ulong8_rtp
#undef convert_ulong8_rtn
#undef convert_ulong8_sat
#undef convert_ulong8_sat_rte
#undef convert_ulong8_sat_rtz
#undef convert_ulong8_sat_rtp
#undef convert_ulong8_sat_rtn
#define convert_ulong8(__a)         __tg_builtin_gentype("convert_ulong8",__a,0,0)
#define convert_ulong8_rte(__a)     __tg_builtin_gentype("convert_ulong8",__a,0,1)
#define convert_ulong8_rtz(__a)     __tg_builtin_gentype("convert_ulong8",__a,0,2)
#define convert_ulong8_rtp(__a)     __tg_builtin_gentype("convert_ulong8",__a,0,3)
#define convert_ulong8_rtn(__a)     __tg_builtin_gentype("convert_ulong8",__a,0,4)
#define convert_ulong8_sat(__a)     __tg_builtin_gentype("convert_ulong8",__a,1,0)
#define convert_ulong8_sat_rte(__a) __tg_builtin_gentype("convert_ulong8",__a,1,1)
#define convert_ulong8_sat_rtz(__a) __tg_builtin_gentype("convert_ulong8",__a,1,2)
#define convert_ulong8_sat_rtp(__a) __tg_builtin_gentype("convert_ulong8",__a,1,3)
#define convert_ulong8_sat_rtn(__a) __tg_builtin_gentype("convert_ulong8",__a,1,4)

#pragma tg_funcdef(convert_ulong16, convert_tg, ulong16, char16,   int, int)
#pragma tg_funcdef(convert_ulong16, convert_tg, ulong16, uchar16,  int, int)
#pragma tg_funcdef(convert_ulong16, convert_tg, ulong16, short16,  int, int)
#pragma tg_funcdef(convert_ulong16, convert_tg, ulong16, ushort16, int, int)
#pragma tg_funcdef(convert_ulong16, convert_tg, ulong16, int16,    int, int)
#pragma tg_funcdef(convert_ulong16, convert_tg, ulong16, uint16,   int, int)
#pragma tg_funcdef(convert_ulong16, convert_tg, ulong16, long16,   int, int)
#pragma tg_funcdef(convert_ulong16, convert_tg, ulong16, ulong16,  int, int)
#pragma tg_funcdef(convert_ulong16, convert_tg, ulong16, float16,  int, int)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(convert_ulong16, convert_tg, ulong16, double16, int, int)
 #endif
#undef convert_ulong16
#undef convert_ulong16_rte
#undef convert_ulong16_rtz
#undef convert_ulong16_rtp
#undef convert_ulong16_rtn
#undef convert_ulong16_sat
#undef convert_ulong16_sat_rte
#undef convert_ulong16_sat_rtz
#undef convert_ulong16_sat_rtp
#undef convert_ulong16_sat_rtn
#define convert_ulong16(__a)         __tg_builtin_gentype("convert_ulong16",__a,0,0)
#define convert_ulong16_rte(__a)     __tg_builtin_gentype("convert_ulong16",__a,0,1)
#define convert_ulong16_rtz(__a)     __tg_builtin_gentype("convert_ulong16",__a,0,2)
#define convert_ulong16_rtp(__a)     __tg_builtin_gentype("convert_ulong16",__a,0,3)
#define convert_ulong16_rtn(__a)     __tg_builtin_gentype("convert_ulong16",__a,0,4)
#define convert_ulong16_sat(__a)     __tg_builtin_gentype("convert_ulong16",__a,1,0)
#define convert_ulong16_sat_rte(__a) __tg_builtin_gentype("convert_ulong16",__a,1,1)
#define convert_ulong16_sat_rtz(__a) __tg_builtin_gentype("convert_ulong16",__a,1,2)
#define convert_ulong16_sat_rtp(__a) __tg_builtin_gentype("convert_ulong16",__a,1,3)
#define convert_ulong16_sat_rtn(__a) __tg_builtin_gentype("convert_ulong16",__a,1,4)

/* convert_floatN<_roundingMode>*/

#pragma tg_funcdef(convert_float, convert_tg, float, char,   int, int)
#pragma tg_funcdef(convert_float, convert_tg, float, uchar,  int, int)
#pragma tg_funcdef(convert_float, convert_tg, float, short,  int, int)
#pragma tg_funcdef(convert_float, convert_tg, float, ushort, int, int)
#pragma tg_funcdef(convert_float, convert_tg, float, int,    int, int)
#pragma tg_funcdef(convert_float, convert_tg, float, uint,   int, int)
#pragma tg_funcdef(convert_float, convert_tg, float, long,   int, int)
#pragma tg_funcdef(convert_float, convert_tg, float, ulong,  int, int)
#pragma tg_funcdef(convert_float, convert_tg, float, float,  int, int)
#pragma tg_funcdef(convert_float, convert_tg, float, double, int, int)
#undef convert_float
#undef convert_float_rte
#undef convert_float_rtz
#undef convert_float_rtp
#undef convert_float_rtn
#define convert_float(__a)     __tg_builtin_gentype("convert_float",__a,0,0)
#define convert_float_rte(__a) __tg_builtin_gentype("convert_float",__a,0,1)
#define convert_float_rtz(__a) __tg_builtin_gentype("convert_float",__a,0,2)
#define convert_float_rtp(__a) __tg_builtin_gentype("convert_float",__a,0,3)
#define convert_float_rtn(__a) __tg_builtin_gentype("convert_float",__a,0,4)

#pragma tg_funcdef(convert_float2, convert_tg, float2, char2,   int, int)
#pragma tg_funcdef(convert_float2, convert_tg, float2, uchar2,  int, int)
#pragma tg_funcdef(convert_float2, convert_tg, float2, short2,  int, int)
#pragma tg_funcdef(convert_float2, convert_tg, float2, ushort2, int, int)
#pragma tg_funcdef(convert_float2, convert_tg, float2, int2,    int, int)
#pragma tg_funcdef(convert_float2, convert_tg, float2, uint2,   int, int)
#pragma tg_funcdef(convert_float2, convert_tg, float2, long2,   int, int)
#pragma tg_funcdef(convert_float2, convert_tg, float2, ulong2,  int, int)
#pragma tg_funcdef(convert_float2, convert_tg, float2, float2,  int, int)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(convert_float2, convert_tg, float2, double2, int, int)
 #endif
#undef convert_float2
#undef convert_float2_rte
#undef convert_float2_rtz
#undef convert_float2_rtp
#undef convert_float2_rtn
#define convert_float2(__a)     __tg_builtin_gentype("convert_float2",__a,0,0)
#define convert_float2_rte(__a) __tg_builtin_gentype("convert_float2",__a,0,1)
#define convert_float2_rtz(__a) __tg_builtin_gentype("convert_float2",__a,0,2)
#define convert_float2_rtp(__a) __tg_builtin_gentype("convert_float2",__a,0,3)
#define convert_float2_rtn(__a) __tg_builtin_gentype("convert_float2",__a,0,4)

#pragma tg_funcdef(convert_float3, convert_tg, float3, char3,   int, int)
#pragma tg_funcdef(convert_float3, convert_tg, float3, uchar3,  int, int)
#pragma tg_funcdef(convert_float3, convert_tg, float3, short3,  int, int)
#pragma tg_funcdef(convert_float3, convert_tg, float3, ushort3, int, int)
#pragma tg_funcdef(convert_float3, convert_tg, float3, int3,    int, int)
#pragma tg_funcdef(convert_float3, convert_tg, float3, uint3,   int, int)
#pragma tg_funcdef(convert_float3, convert_tg, float3, long3,   int, int)
#pragma tg_funcdef(convert_float3, convert_tg, float3, ulong3,  int, int)
#pragma tg_funcdef(convert_float3, convert_tg, float3, float3,  int, int)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(convert_float3, convert_tg, float3, double3, int, int)
 #endif
#undef convert_float3
#undef convert_float3_rte
#undef convert_float3_rtz
#undef convert_float3_rtp
#undef convert_float3_rtn
#define convert_float3(__a)     __tg_builtin_gentype("convert_float3",__a,0,0)
#define convert_float3_rte(__a) __tg_builtin_gentype("convert_float3",__a,0,1)
#define convert_float3_rtz(__a) __tg_builtin_gentype("convert_float3",__a,0,2)
#define convert_float3_rtp(__a) __tg_builtin_gentype("convert_float3",__a,0,3)
#define convert_float3_rtn(__a) __tg_builtin_gentype("convert_float3",__a,0,4)

#pragma tg_funcdef(convert_float4, convert_tg, float4, char4,   int, int)
#pragma tg_funcdef(convert_float4, convert_tg, float4, uchar4,  int, int)
#pragma tg_funcdef(convert_float4, convert_tg, float4, short4,  int, int)
#pragma tg_funcdef(convert_float4, convert_tg, float4, ushort4, int, int)
#pragma tg_funcdef(convert_float4, convert_tg, float4, int4,    int, int)
#pragma tg_funcdef(convert_float4, convert_tg, float4, uint4,   int, int)
#pragma tg_funcdef(convert_float4, convert_tg, float4, long4,   int, int)
#pragma tg_funcdef(convert_float4, convert_tg, float4, ulong4,  int, int)
#pragma tg_funcdef(convert_float4, convert_tg, float4, float4,  int, int)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(convert_float4, convert_tg, float4, double4, int, int)
 #endif
#undef convert_float4
#undef convert_float4_rte
#undef convert_float4_rtz
#undef convert_float4_rtp
#undef convert_float4_rtn
#define convert_float4(__a)     __tg_builtin_gentype("convert_float4",__a,0,0)
#define convert_float4_rte(__a) __tg_builtin_gentype("convert_float4",__a,0,1)
#define convert_float4_rtz(__a) __tg_builtin_gentype("convert_float4",__a,0,2)
#define convert_float4_rtp(__a) __tg_builtin_gentype("convert_float4",__a,0,3)
#define convert_float4_rtn(__a) __tg_builtin_gentype("convert_float4",__a,0,4)

#pragma tg_funcdef(convert_float8, convert_tg, float8, char8,   int, int)
#pragma tg_funcdef(convert_float8, convert_tg, float8, uchar8,  int, int)
#pragma tg_funcdef(convert_float8, convert_tg, float8, short8,  int, int)
#pragma tg_funcdef(convert_float8, convert_tg, float8, ushort8, int, int)
#pragma tg_funcdef(convert_float8, convert_tg, float8, int8,    int, int)
#pragma tg_funcdef(convert_float8, convert_tg, float8, uint8,   int, int)
#pragma tg_funcdef(convert_float8, convert_tg, float8, long8,   int, int)
#pragma tg_funcdef(convert_float8, convert_tg, float8, ulong8,  int, int)
#pragma tg_funcdef(convert_float8, convert_tg, float8, float8,  int, int)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(convert_float8, convert_tg, float8, double8, int, int)
 #endif
#undef convert_float8
#undef convert_float8_rte
#undef convert_float8_rtz
#undef convert_float8_rtp
#undef convert_float8_rtn
#define convert_float8(__a)     __tg_builtin_gentype("convert_float8",__a,0,0)
#define convert_float8_rte(__a) __tg_builtin_gentype("convert_float8",__a,0,1)
#define convert_float8_rtz(__a) __tg_builtin_gentype("convert_float8",__a,0,2)
#define convert_float8_rtp(__a) __tg_builtin_gentype("convert_float8",__a,0,3)
#define convert_float8_rtn(__a) __tg_builtin_gentype("convert_float8",__a,0,4)

#pragma tg_funcdef(convert_float16, convert_tg, float16, char16,   int, int)
#pragma tg_funcdef(convert_float16, convert_tg, float16, uchar16,  int, int)
#pragma tg_funcdef(convert_float16, convert_tg, float16, short16,  int, int)
#pragma tg_funcdef(convert_float16, convert_tg, float16, ushort16, int, int)
#pragma tg_funcdef(convert_float16, convert_tg, float16, int16,    int, int)
#pragma tg_funcdef(convert_float16, convert_tg, float16, uint16,   int, int)
#pragma tg_funcdef(convert_float16, convert_tg, float16, long16,   int, int)
#pragma tg_funcdef(convert_float16, convert_tg, float16, ulong16,  int, int)
#pragma tg_funcdef(convert_float16, convert_tg, float16, float16,  int, int)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(convert_float16, convert_tg, float16, double16, int, int)
 #endif
#undef convert_float16
#undef convert_float16_rte
#undef convert_float16_rtz
#undef convert_float16_rtp
#undef convert_float16_rtn
#define convert_float16(__a)     __tg_builtin_gentype("convert_float16",__a,0,0)
#define convert_float16_rte(__a) __tg_builtin_gentype("convert_float16",__a,0,1)
#define convert_float16_rtz(__a) __tg_builtin_gentype("convert_float16",__a,0,2)
#define convert_float16_rtp(__a) __tg_builtin_gentype("convert_float16",__a,0,3)
#define convert_float16_rtn(__a) __tg_builtin_gentype("convert_float16",__a,0,4)

/* convert_doubleN<_roundingMode> */

#pragma tg_funcdef(convert_double, convert_tg, double, char,   int, int)
#pragma tg_funcdef(convert_double, convert_tg, double, uchar,  int, int)
#pragma tg_funcdef(convert_double, convert_tg, double, short,  int, int)
#pragma tg_funcdef(convert_double, convert_tg, double, ushort, int, int)
#pragma tg_funcdef(convert_double, convert_tg, double, int,    int, int)
#pragma tg_funcdef(convert_double, convert_tg, double, uint,   int, int)
#pragma tg_funcdef(convert_double, convert_tg, double, long,   int, int)
#pragma tg_funcdef(convert_double, convert_tg, double, ulong,  int, int)
#pragma tg_funcdef(convert_double, convert_tg, double, float,  int, int)
#pragma tg_funcdef(convert_double, convert_tg, double, double, int, int)
#undef convert_double
#undef convert_double_rte
#undef convert_double_rtz
#undef convert_double_rtp
#undef convert_double_rtn
#define convert_double(__a)     __tg_builtin_gentype("convert_double",__a,0,0)
#define convert_double_rte(__a) __tg_builtin_gentype("convert_double",__a,0,1)
#define convert_double_rtz(__a) __tg_builtin_gentype("convert_double",__a,0,2)
#define convert_double_rtp(__a) __tg_builtin_gentype("convert_double",__a,0,3)
#define convert_double_rtn(__a) __tg_builtin_gentype("convert_double",__a,0,4)

 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(convert_double2, convert_tg, double2, char2,   int, int)
#pragma tg_funcdef(convert_double2, convert_tg, double2, uchar2,  int, int)
#pragma tg_funcdef(convert_double2, convert_tg, double2, short2,  int, int)
#pragma tg_funcdef(convert_double2, convert_tg, double2, ushort2, int, int)
#pragma tg_funcdef(convert_double2, convert_tg, double2, int2,    int, int)
#pragma tg_funcdef(convert_double2, convert_tg, double2, uint2,   int, int)
#pragma tg_funcdef(convert_double2, convert_tg, double2, long2,   int, int)
#pragma tg_funcdef(convert_double2, convert_tg, double2, ulong2,  int, int)
#pragma tg_funcdef(convert_double2, convert_tg, double2, float2,  int, int)
#pragma tg_funcdef(convert_double2, convert_tg, double2, double2, int, int)
#undef convert_double2
#undef convert_double2_rte
#undef convert_double2_rtz
#undef convert_double2_rtp
#undef convert_double2_rtn
#define convert_double2(__a)     __tg_builtin_gentype("convert_double2",__a,0,0)
#define convert_double2_rte(__a) __tg_builtin_gentype("convert_double2",__a,0,1)
#define convert_double2_rtz(__a) __tg_builtin_gentype("convert_double2",__a,0,2)
#define convert_double2_rtp(__a) __tg_builtin_gentype("convert_double2",__a,0,3)
#define convert_double2_rtn(__a) __tg_builtin_gentype("convert_double2",__a,0,4)

#pragma tg_funcdef(convert_double3, convert_tg, double3, char3,   int, int)
#pragma tg_funcdef(convert_double3, convert_tg, double3, uchar3,  int, int)
#pragma tg_funcdef(convert_double3, convert_tg, double3, short3,  int, int)
#pragma tg_funcdef(convert_double3, convert_tg, double3, ushort3, int, int)
#pragma tg_funcdef(convert_double3, convert_tg, double3, int3,    int, int)
#pragma tg_funcdef(convert_double3, convert_tg, double3, uint3,   int, int)
#pragma tg_funcdef(convert_double3, convert_tg, double3, long3,   int, int)
#pragma tg_funcdef(convert_double3, convert_tg, double3, ulong3,  int, int)
#pragma tg_funcdef(convert_double3, convert_tg, double3, float3,  int, int)
#pragma tg_funcdef(convert_double3, convert_tg, double3, double3, int, int)
#undef convert_double3
#undef convert_double3_rte
#undef convert_double3_rtz
#undef convert_double3_rtp
#undef convert_double3_rtn
#define convert_double3(__a)     __tg_builtin_gentype("convert_double3",__a,0,0)
#define convert_double3_rte(__a) __tg_builtin_gentype("convert_double3",__a,0,1)
#define convert_double3_rtz(__a) __tg_builtin_gentype("convert_double3",__a,0,2)
#define convert_double3_rtp(__a) __tg_builtin_gentype("convert_double3",__a,0,3)
#define convert_double3_rtn(__a) __tg_builtin_gentype("convert_double3",__a,0,4)

#pragma tg_funcdef(convert_double4, convert_tg, double4, char4,   int, int)
#pragma tg_funcdef(convert_double4, convert_tg, double4, uchar4,  int, int)
#pragma tg_funcdef(convert_double4, convert_tg, double4, short4,  int, int)
#pragma tg_funcdef(convert_double4, convert_tg, double4, ushort4, int, int)
#pragma tg_funcdef(convert_double4, convert_tg, double4, int4,    int, int)
#pragma tg_funcdef(convert_double4, convert_tg, double4, uint4,   int, int)
#pragma tg_funcdef(convert_double4, convert_tg, double4, long4,   int, int)
#pragma tg_funcdef(convert_double4, convert_tg, double4, ulong4,  int, int)
#pragma tg_funcdef(convert_double4, convert_tg, double4, float4,  int, int)
#pragma tg_funcdef(convert_double4, convert_tg, double4, double4, int, int)
#undef convert_double4
#undef convert_double4_rte
#undef convert_double4_rtz
#undef convert_double4_rtp
#undef convert_double4_rtn
#define convert_double4(__a)     __tg_builtin_gentype("convert_double4",__a,0,0)
#define convert_double4_rte(__a) __tg_builtin_gentype("convert_double4",__a,0,1)
#define convert_double4_rtz(__a) __tg_builtin_gentype("convert_double4",__a,0,2)
#define convert_double4_rtp(__a) __tg_builtin_gentype("convert_double4",__a,0,3)
#define convert_double4_rtn(__a) __tg_builtin_gentype("convert_double4",__a,0,4)

#pragma tg_funcdef(convert_double8, convert_tg, double8, char8,   int, int)
#pragma tg_funcdef(convert_double8, convert_tg, double8, uchar8,  int, int)
#pragma tg_funcdef(convert_double8, convert_tg, double8, short8,  int, int)
#pragma tg_funcdef(convert_double8, convert_tg, double8, ushort8, int, int)
#pragma tg_funcdef(convert_double8, convert_tg, double8, int8,    int, int)
#pragma tg_funcdef(convert_double8, convert_tg, double8, uint8,   int, int)
#pragma tg_funcdef(convert_double8, convert_tg, double8, long8,   int, int)
#pragma tg_funcdef(convert_double8, convert_tg, double8, ulong8,  int, int)
#pragma tg_funcdef(convert_double8, convert_tg, double8, float8,  int, int)
#pragma tg_funcdef(convert_double8, convert_tg, double8, double8, int, int)
#undef convert_double8
#undef convert_double8_rte
#undef convert_double8_rtz
#undef convert_double8_rtp
#undef convert_double8_rtn
#define convert_double8(__a)     __tg_builtin_gentype("convert_double8",__a,0,0)
#define convert_double8_rte(__a) __tg_builtin_gentype("convert_double8",__a,0,1)
#define convert_double8_rtz(__a) __tg_builtin_gentype("convert_double8",__a,0,2)
#define convert_double8_rtp(__a) __tg_builtin_gentype("convert_double8",__a,0,3)
#define convert_double8_rtn(__a) __tg_builtin_gentype("convert_double8",__a,0,4)

#pragma tg_funcdef(convert_double16, convert_tg, double16, char16,   int, int)
#pragma tg_funcdef(convert_double16, convert_tg, double16, uchar16,  int, int)
#pragma tg_funcdef(convert_double16, convert_tg, double16, short16,  int, int)
#pragma tg_funcdef(convert_double16, convert_tg, double16, ushort16, int, int)
#pragma tg_funcdef(convert_double16, convert_tg, double16, int16,    int, int)
#pragma tg_funcdef(convert_double16, convert_tg, double16, uint16,   int, int)
#pragma tg_funcdef(convert_double16, convert_tg, double16, long16,   int, int)
#pragma tg_funcdef(convert_double16, convert_tg, double16, ulong16,  int, int)
#pragma tg_funcdef(convert_double16, convert_tg, double16, float16,  int, int)
#pragma tg_funcdef(convert_double16, convert_tg, double16, double16, int, int)
#undef convert_double16
#undef convert_double16_rte
#undef convert_double16_rtz
#undef convert_double16_rtp
#undef convert_double16_rtn
#define convert_double16(__a)     __tg_builtin_gentype("convert_double16",__a,0,0)
#define convert_double16_rte(__a) __tg_builtin_gentype("convert_double16",__a,0,1)
#define convert_double16_rtz(__a) __tg_builtin_gentype("convert_double16",__a,0,2)
#define convert_double16_rtp(__a) __tg_builtin_gentype("convert_double16",__a,0,3)
#define convert_double16_rtn(__a) __tg_builtin_gentype("convert_double16",__a,0,4)
 #endif

/* 6.2.4 Reinterpreting Data As Another Type */

/* as_charN */
#pragma tg_funcdef(as_char, as_char_tg, char, uchar)
#pragma tg_funcdef(as_char, as_char_tg, char, char)
#undef as_char
#define as_char(__a) __tg_builtin_gentype("as_char",__a)

#pragma tg_funcdef(as_char2, as_char_tg, char2, uchar2)
#pragma tg_funcdef(as_char2, as_char_tg, char2, char2)
#pragma tg_funcdef(as_char2, as_char_tg, char2, ushort)
#pragma tg_funcdef(as_char2, as_char_tg, char2, short)
#undef as_char2
#define as_char2(__a) __tg_builtin_gentype("as_char2",__a)

#pragma tg_funcdef(as_char3, as_char_tg, char3, uchar3)
#pragma tg_funcdef(as_char3, as_char_tg, char3, char3)
#pragma tg_funcdef(as_char3, as_char_tg, char3, uchar4)
#pragma tg_funcdef(as_char3, as_char_tg, char3, char4)
#pragma tg_funcdef(as_char3, as_char_tg, char3, ushort2)
#pragma tg_funcdef(as_char3, as_char_tg, char3, short2)
#pragma tg_funcdef(as_char3, as_char_tg, char3, uint)
#pragma tg_funcdef(as_char3, as_char_tg, char3, int)
#pragma tg_funcdef(as_char3, as_char_tg, char3, float)
#undef as_char3
#define as_char3(__a) __tg_builtin_gentype("as_char3",__a)

#pragma tg_funcdef(as_char4, as_char_tg, char4, uchar3)
#pragma tg_funcdef(as_char4, as_char_tg, char4, char3)
#pragma tg_funcdef(as_char4, as_char_tg, char4, uchar4)
#pragma tg_funcdef(as_char4, as_char_tg, char4, char4)
#pragma tg_funcdef(as_char4, as_char_tg, char4, ushort2)
#pragma tg_funcdef(as_char4, as_char_tg, char4, short2)
#pragma tg_funcdef(as_char4, as_char_tg, char4, uint)
#pragma tg_funcdef(as_char4, as_char_tg, char4, int)
#pragma tg_funcdef(as_char4, as_char_tg, char4, float)
#undef as_char4
#define as_char4(__a) __tg_builtin_gentype("as_char4",__a)

#pragma tg_funcdef(as_char8, as_char_tg, char8, uchar8)
#pragma tg_funcdef(as_char8, as_char_tg, char8, char8)
#pragma tg_funcdef(as_char8, as_char_tg, char8, ushort3)
#pragma tg_funcdef(as_char8, as_char_tg, char8, short3)
#pragma tg_funcdef(as_char8, as_char_tg, char8, ushort4)
#pragma tg_funcdef(as_char8, as_char_tg, char8, short4)
#pragma tg_funcdef(as_char8, as_char_tg, char8, uint2)
#pragma tg_funcdef(as_char8, as_char_tg, char8, int2)
#pragma tg_funcdef(as_char8, as_char_tg, char8, ulong)
#pragma tg_funcdef(as_char8, as_char_tg, char8, long)
#pragma tg_funcdef(as_char8, as_char_tg, char8, float2)
#pragma tg_funcdef(as_char8, as_char_tg, char8, double)
#undef as_char8
#define as_char8(__a) __tg_builtin_gentype("as_char8",__a)

#pragma tg_funcdef(as_char16, as_char_tg, char16, uchar16)
#pragma tg_funcdef(as_char16, as_char_tg, char16, char16)
#pragma tg_funcdef(as_char16, as_char_tg, char16, ushort8)
#pragma tg_funcdef(as_char16, as_char_tg, char16, short8)
#pragma tg_funcdef(as_char16, as_char_tg, char16, uint3)
#pragma tg_funcdef(as_char16, as_char_tg, char16, int3)
#pragma tg_funcdef(as_char16, as_char_tg, char16, uint4)
#pragma tg_funcdef(as_char16, as_char_tg, char16, int4)
#pragma tg_funcdef(as_char16, as_char_tg, char16, ulong2)
#pragma tg_funcdef(as_char16, as_char_tg, char16, long2)
#pragma tg_funcdef(as_char16, as_char_tg, char16, float3)
#pragma tg_funcdef(as_char16, as_char_tg, char16, float4)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(as_char16, as_char_tg, char16, double2)
 #endif
#undef as_char16
#define as_char16(__a) __tg_builtin_gentype("as_char16",__a)

/* as_ucharN */
#pragma tg_funcdef(as_uchar, as_uchar_tg, uchar, uchar)
#pragma tg_funcdef(as_uchar, as_uchar_tg, uchar, char)
#undef as_uchar
#define as_uchar(__a) __tg_builtin_gentype("as_uchar",__a)

#pragma tg_funcdef(as_uchar2, as_uchar_tg, uchar2, uchar2)
#pragma tg_funcdef(as_uchar2, as_uchar_tg, uchar2, char2)
#pragma tg_funcdef(as_uchar2, as_uchar_tg, uchar2, ushort)
#pragma tg_funcdef(as_uchar2, as_uchar_tg, uchar2, short)
#undef as_uchar2
#define as_uchar2(__a) __tg_builtin_gentype("as_uchar2",__a)

#pragma tg_funcdef(as_uchar3, as_uchar_tg, uchar3, uchar3)
#pragma tg_funcdef(as_uchar3, as_uchar_tg, uchar3, char3)
#pragma tg_funcdef(as_uchar3, as_uchar_tg, uchar3, uchar4)
#pragma tg_funcdef(as_uchar3, as_uchar_tg, uchar3, char4)
#pragma tg_funcdef(as_uchar3, as_uchar_tg, uchar3, ushort2)
#pragma tg_funcdef(as_uchar3, as_uchar_tg, uchar3, short2)
#pragma tg_funcdef(as_uchar3, as_uchar_tg, uchar3, uint)
#pragma tg_funcdef(as_uchar3, as_uchar_tg, uchar3, int)
#pragma tg_funcdef(as_uchar3, as_uchar_tg, uchar3, float)
#undef as_uchar3
#define as_uchar3(__a) __tg_builtin_gentype("as_uchar3",__a)

#pragma tg_funcdef(as_uchar4, as_uchar_tg, uchar4, uchar3)
#pragma tg_funcdef(as_uchar4, as_uchar_tg, uchar4, char3)
#pragma tg_funcdef(as_uchar4, as_uchar_tg, uchar4, uchar4)
#pragma tg_funcdef(as_uchar4, as_uchar_tg, uchar4, char4)
#pragma tg_funcdef(as_uchar4, as_uchar_tg, uchar4, ushort2)
#pragma tg_funcdef(as_uchar4, as_uchar_tg, uchar4, short2)
#pragma tg_funcdef(as_uchar4, as_uchar_tg, uchar4, uint)
#pragma tg_funcdef(as_uchar4, as_uchar_tg, uchar4, int)
#pragma tg_funcdef(as_uchar4, as_uchar_tg, uchar4, float)
#undef as_uchar4
#define as_uchar4(__a) __tg_builtin_gentype("as_uchar4",__a)

#pragma tg_funcdef(as_uchar8, as_uchar_tg, uchar8, uchar8)
#pragma tg_funcdef(as_uchar8, as_uchar_tg, uchar8, char8)
#pragma tg_funcdef(as_uchar8, as_uchar_tg, uchar8, ushort3)
#pragma tg_funcdef(as_uchar8, as_uchar_tg, uchar8, short3)
#pragma tg_funcdef(as_uchar8, as_uchar_tg, uchar8, ushort4)
#pragma tg_funcdef(as_uchar8, as_uchar_tg, uchar8, short4)
#pragma tg_funcdef(as_uchar8, as_uchar_tg, uchar8, uint2)
#pragma tg_funcdef(as_uchar8, as_uchar_tg, uchar8, int2)
#pragma tg_funcdef(as_uchar8, as_uchar_tg, uchar8, ulong)
#pragma tg_funcdef(as_uchar8, as_uchar_tg, uchar8, long)
#pragma tg_funcdef(as_uchar8, as_uchar_tg, uchar8, float2)
#pragma tg_funcdef(as_uchar8, as_uchar_tg, uchar8, double)
#undef as_uchar8
#define as_uchar8(__a) __tg_builtin_gentype("as_uchar8",__a)

#pragma tg_funcdef(as_uchar16, as_uchar_tg, uchar16, uchar16)
#pragma tg_funcdef(as_uchar16, as_uchar_tg, uchar16, char16)
#pragma tg_funcdef(as_uchar16, as_uchar_tg, uchar16, ushort8)
#pragma tg_funcdef(as_uchar16, as_uchar_tg, uchar16, short8)
#pragma tg_funcdef(as_uchar16, as_uchar_tg, uchar16, uint3)
#pragma tg_funcdef(as_uchar16, as_uchar_tg, uchar16, int3)
#pragma tg_funcdef(as_uchar16, as_uchar_tg, uchar16, uint4)
#pragma tg_funcdef(as_uchar16, as_uchar_tg, uchar16, int4)
#pragma tg_funcdef(as_uchar16, as_uchar_tg, uchar16, ulong2)
#pragma tg_funcdef(as_uchar16, as_uchar_tg, uchar16, long2)
#pragma tg_funcdef(as_uchar16, as_uchar_tg, uchar16, float3)
#pragma tg_funcdef(as_uchar16, as_uchar_tg, uchar16, float4)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(as_uchar16, as_uchar_tg, uchar16, double2)
 #endif
#undef as_uchar16
#define as_uchar16(__a) __tg_builtin_gentype("as_uchar16",__a)

/* as_shortN */
#pragma tg_funcdef(as_short, as_short_tg, short, uchar2)
#pragma tg_funcdef(as_short, as_short_tg, short, char2)
#pragma tg_funcdef(as_short, as_short_tg, short, ushort)
#pragma tg_funcdef(as_short, as_short_tg, short, short)
#undef as_short
#define as_short(__a) __tg_builtin_gentype("as_short",__a)

#pragma tg_funcdef(as_short2, as_short_tg, short2, uchar3)
#pragma tg_funcdef(as_short2, as_short_tg, short2, char3)
#pragma tg_funcdef(as_short2, as_short_tg, short2, uchar4)
#pragma tg_funcdef(as_short2, as_short_tg, short2, char4)
#pragma tg_funcdef(as_short2, as_short_tg, short2, ushort2)
#pragma tg_funcdef(as_short2, as_short_tg, short2, short2)
#pragma tg_funcdef(as_short2, as_short_tg, short2, uint)
#pragma tg_funcdef(as_short2, as_short_tg, short2, int)
#pragma tg_funcdef(as_short2, as_short_tg, short2, float)
#undef as_short2
#define as_short2(__a) __tg_builtin_gentype("as_short2",__a)

#pragma tg_funcdef(as_short3, as_short_tg, short3, uchar8)
#pragma tg_funcdef(as_short3, as_short_tg, short3, char8)
#pragma tg_funcdef(as_short3, as_short_tg, short3, ushort3)
#pragma tg_funcdef(as_short3, as_short_tg, short3, short3)
#pragma tg_funcdef(as_short3, as_short_tg, short3, ushort4)
#pragma tg_funcdef(as_short3, as_short_tg, short3, short4)
#pragma tg_funcdef(as_short3, as_short_tg, short3, uint2)
#pragma tg_funcdef(as_short3, as_short_tg, short3, int2)
#pragma tg_funcdef(as_short3, as_short_tg, short3, ulong)
#pragma tg_funcdef(as_short3, as_short_tg, short3, long)
#pragma tg_funcdef(as_short3, as_short_tg, short3, float2)
#pragma tg_funcdef(as_short3, as_short_tg, short3, double)
#undef as_short3
#define as_short3(__a) __tg_builtin_gentype("as_short3",__a)

#pragma tg_funcdef(as_short4, as_short_tg, short4, uchar8)
#pragma tg_funcdef(as_short4, as_short_tg, short4, char8)
#pragma tg_funcdef(as_short4, as_short_tg, short4, ushort3)
#pragma tg_funcdef(as_short4, as_short_tg, short4, short3)
#pragma tg_funcdef(as_short4, as_short_tg, short4, ushort4)
#pragma tg_funcdef(as_short4, as_short_tg, short4, short4)
#pragma tg_funcdef(as_short4, as_short_tg, short4, uint2)
#pragma tg_funcdef(as_short4, as_short_tg, short4, int2)
#pragma tg_funcdef(as_short4, as_short_tg, short4, ulong)
#pragma tg_funcdef(as_short4, as_short_tg, short4, long)
#pragma tg_funcdef(as_short4, as_short_tg, short4, float2)
#pragma tg_funcdef(as_short4, as_short_tg, short4, double)
#undef as_short4
#define as_short4(__a) __tg_builtin_gentype("as_short4",__a)

#pragma tg_funcdef(as_short8, as_short_tg, short8, uchar16)
#pragma tg_funcdef(as_short8, as_short_tg, short8, char16)
#pragma tg_funcdef(as_short8, as_short_tg, short8, ushort8)
#pragma tg_funcdef(as_short8, as_short_tg, short8, short8)
#pragma tg_funcdef(as_short8, as_short_tg, short8, uint3)
#pragma tg_funcdef(as_short8, as_short_tg, short8, int3)
#pragma tg_funcdef(as_short8, as_short_tg, short8, uint4)
#pragma tg_funcdef(as_short8, as_short_tg, short8, int4)
#pragma tg_funcdef(as_short8, as_short_tg, short8, ulong2)
#pragma tg_funcdef(as_short8, as_short_tg, short8, long2)
#pragma tg_funcdef(as_short8, as_short_tg, short8, float3)
#pragma tg_funcdef(as_short8, as_short_tg, short8, float4)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(as_short8, as_short_tg, short8, double2)
 #endif
#undef as_short8
#define as_short8(__a) __tg_builtin_gentype("as_short8",__a)

#pragma tg_funcdef(as_short16, as_short_tg, short16, ushort16)
#pragma tg_funcdef(as_short16, as_short_tg, short16, short16)
#pragma tg_funcdef(as_short16, as_short_tg, short16, uint8)
#pragma tg_funcdef(as_short16, as_short_tg, short16, int8)
#pragma tg_funcdef(as_short16, as_short_tg, short16, ulong3)
#pragma tg_funcdef(as_short16, as_short_tg, short16, long3)
#pragma tg_funcdef(as_short16, as_short_tg, short16, ulong4)
#pragma tg_funcdef(as_short16, as_short_tg, short16, long4)
#pragma tg_funcdef(as_short16, as_short_tg, short16, float8)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(as_short16, as_short_tg, short16, double3)
#pragma tg_funcdef(as_short16, as_short_tg, short16, double4)
 #endif
#undef as_short16
#define as_short16(__a) __tg_builtin_gentype("as_short16",__a)

/* as_ushortN */
#pragma tg_funcdef(as_ushort, as_ushort_tg, ushort, uchar2)
#pragma tg_funcdef(as_ushort, as_ushort_tg, ushort, char2)
#pragma tg_funcdef(as_ushort, as_ushort_tg, ushort, ushort)
#pragma tg_funcdef(as_ushort, as_ushort_tg, ushort, short)
#undef as_ushort
#define as_ushort(__a) __tg_builtin_gentype("as_ushort",__a)

#pragma tg_funcdef(as_ushort2, as_ushort_tg, ushort2, uchar3)
#pragma tg_funcdef(as_ushort2, as_ushort_tg, ushort2, char3)
#pragma tg_funcdef(as_ushort2, as_ushort_tg, ushort2, uchar4)
#pragma tg_funcdef(as_ushort2, as_ushort_tg, ushort2, char4)
#pragma tg_funcdef(as_ushort2, as_ushort_tg, ushort2, ushort2)
#pragma tg_funcdef(as_ushort2, as_ushort_tg, ushort2, short2)
#pragma tg_funcdef(as_ushort2, as_ushort_tg, ushort2, uint)
#pragma tg_funcdef(as_ushort2, as_ushort_tg, ushort2, int)
#pragma tg_funcdef(as_ushort2, as_ushort_tg, ushort2, float)
#undef as_ushort2
#define as_ushort2(__a) __tg_builtin_gentype("as_ushort2",__a)

#pragma tg_funcdef(as_ushort3, as_ushort_tg, ushort3, uchar8)
#pragma tg_funcdef(as_ushort3, as_ushort_tg, ushort3, char8)
#pragma tg_funcdef(as_ushort3, as_ushort_tg, ushort3, ushort3)
#pragma tg_funcdef(as_ushort3, as_ushort_tg, ushort3, short3)
#pragma tg_funcdef(as_ushort3, as_ushort_tg, ushort3, ushort4)
#pragma tg_funcdef(as_ushort3, as_ushort_tg, ushort3, short4)
#pragma tg_funcdef(as_ushort3, as_ushort_tg, ushort3, uint2)
#pragma tg_funcdef(as_ushort3, as_ushort_tg, ushort3, int2)
#pragma tg_funcdef(as_ushort3, as_ushort_tg, ushort3, ulong)
#pragma tg_funcdef(as_ushort3, as_ushort_tg, ushort3, long)
#pragma tg_funcdef(as_ushort3, as_ushort_tg, ushort3, float2)
#pragma tg_funcdef(as_ushort3, as_ushort_tg, ushort3, double)
#undef as_ushort3
#define as_ushort3(__a) __tg_builtin_gentype("as_ushort3",__a)

#pragma tg_funcdef(as_ushort4, as_ushort_tg, ushort4, uchar8)
#pragma tg_funcdef(as_ushort4, as_ushort_tg, ushort4, char8)
#pragma tg_funcdef(as_ushort4, as_ushort_tg, ushort4, ushort3)
#pragma tg_funcdef(as_ushort4, as_ushort_tg, ushort4, short3)
#pragma tg_funcdef(as_ushort4, as_ushort_tg, ushort4, ushort4)
#pragma tg_funcdef(as_ushort4, as_ushort_tg, ushort4, short4)
#pragma tg_funcdef(as_ushort4, as_ushort_tg, ushort4, uint2)
#pragma tg_funcdef(as_ushort4, as_ushort_tg, ushort4, int2)
#pragma tg_funcdef(as_ushort4, as_ushort_tg, ushort4, ulong)
#pragma tg_funcdef(as_ushort4, as_ushort_tg, ushort4, long)
#pragma tg_funcdef(as_ushort4, as_ushort_tg, ushort4, float2)
#pragma tg_funcdef(as_ushort4, as_ushort_tg, ushort4, double)
#undef as_ushort4
#define as_ushort4(__a) __tg_builtin_gentype("as_ushort4",__a)

#pragma tg_funcdef(as_ushort8, as_ushort_tg, ushort8, uchar16)
#pragma tg_funcdef(as_ushort8, as_ushort_tg, ushort8, char16)
#pragma tg_funcdef(as_ushort8, as_ushort_tg, ushort8, ushort8)
#pragma tg_funcdef(as_ushort8, as_ushort_tg, ushort8, short8)
#pragma tg_funcdef(as_ushort8, as_ushort_tg, ushort8, uint3)
#pragma tg_funcdef(as_ushort8, as_ushort_tg, ushort8, int3)
#pragma tg_funcdef(as_ushort8, as_ushort_tg, ushort8, uint4)
#pragma tg_funcdef(as_ushort8, as_ushort_tg, ushort8, int4)
#pragma tg_funcdef(as_ushort8, as_ushort_tg, ushort8, ulong2)
#pragma tg_funcdef(as_ushort8, as_ushort_tg, ushort8, long2)
#pragma tg_funcdef(as_ushort8, as_ushort_tg, ushort8, float3)
#pragma tg_funcdef(as_ushort8, as_ushort_tg, ushort8, float4)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(as_ushort8, as_ushort_tg, ushort8, double2)
 #endif
#undef as_ushort8
#define as_ushort8(__a) __tg_builtin_gentype("as_ushort8",__a)

#pragma tg_funcdef(as_ushort16, as_ushort_tg, ushort16, ushort16)
#pragma tg_funcdef(as_ushort16, as_ushort_tg, ushort16, short16)
#pragma tg_funcdef(as_ushort16, as_ushort_tg, ushort16, uint8)
#pragma tg_funcdef(as_ushort16, as_ushort_tg, ushort16, int8)
#pragma tg_funcdef(as_ushort16, as_ushort_tg, ushort16, ulong3)
#pragma tg_funcdef(as_ushort16, as_ushort_tg, ushort16, long3)
#pragma tg_funcdef(as_ushort16, as_ushort_tg, ushort16, ulong4)
#pragma tg_funcdef(as_ushort16, as_ushort_tg, ushort16, long4)
#pragma tg_funcdef(as_ushort16, as_ushort_tg, ushort16, float8)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(as_ushort16, as_ushort_tg, ushort16, double3)
#pragma tg_funcdef(as_ushort16, as_ushort_tg, ushort16, double4)
 #endif
#undef as_ushort16
#define as_ushort16(__a) __tg_builtin_gentype("as_ushort16",__a)

/* as_intN */
#pragma tg_funcdef(as_int, as_int_tg, int, uchar3)
#pragma tg_funcdef(as_int, as_int_tg, int, char3)
#pragma tg_funcdef(as_int, as_int_tg, int, uchar4)
#pragma tg_funcdef(as_int, as_int_tg, int, char4)
#pragma tg_funcdef(as_int, as_int_tg, int, ushort2)
#pragma tg_funcdef(as_int, as_int_tg, int, short2)
#pragma tg_funcdef(as_int, as_int_tg, int, uint)
#pragma tg_funcdef(as_int, as_int_tg, int, int)
#pragma tg_funcdef(as_int, as_int_tg, int, float)
#undef as_int
#define as_int(__a) __tg_builtin_gentype("as_int",__a)

#pragma tg_funcdef(as_int2, as_int_tg, int2, uchar8)
#pragma tg_funcdef(as_int2, as_int_tg, int2, char8)
#pragma tg_funcdef(as_int2, as_int_tg, int2, ushort3)
#pragma tg_funcdef(as_int2, as_int_tg, int2, short3)
#pragma tg_funcdef(as_int2, as_int_tg, int2, ushort4)
#pragma tg_funcdef(as_int2, as_int_tg, int2, short4)
#pragma tg_funcdef(as_int2, as_int_tg, int2, uint2)
#pragma tg_funcdef(as_int2, as_int_tg, int2, int2)
#pragma tg_funcdef(as_int2, as_int_tg, int2, ulong)
#pragma tg_funcdef(as_int2, as_int_tg, int2, long)
#pragma tg_funcdef(as_int2, as_int_tg, int2, float2)
#pragma tg_funcdef(as_int2, as_int_tg, int2, double)
#undef as_int2
#define as_int2(__a) __tg_builtin_gentype("as_int2",__a)

#pragma tg_funcdef(as_int3, as_int_tg, int3, uchar16)
#pragma tg_funcdef(as_int3, as_int_tg, int3, char16)
#pragma tg_funcdef(as_int3, as_int_tg, int3, ushort8)
#pragma tg_funcdef(as_int3, as_int_tg, int3, short8)
#pragma tg_funcdef(as_int3, as_int_tg, int3, uint3)
#pragma tg_funcdef(as_int3, as_int_tg, int3, int3)
#pragma tg_funcdef(as_int3, as_int_tg, int3, uint4)
#pragma tg_funcdef(as_int3, as_int_tg, int3, int4)
#pragma tg_funcdef(as_int3, as_int_tg, int3, ulong2)
#pragma tg_funcdef(as_int3, as_int_tg, int3, long2)
#pragma tg_funcdef(as_int3, as_int_tg, int3, float3)
#pragma tg_funcdef(as_int3, as_int_tg, int3, float4)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(as_int3, as_int_tg, int3, double2)
 #endif
#undef as_int3
#define as_int3(__a) __tg_builtin_gentype("as_int3",__a)

#pragma tg_funcdef(as_int4, as_int_tg, int4, uchar16)
#pragma tg_funcdef(as_int4, as_int_tg, int4, char16)
#pragma tg_funcdef(as_int4, as_int_tg, int4, ushort8)
#pragma tg_funcdef(as_int4, as_int_tg, int4, short8)
#pragma tg_funcdef(as_int4, as_int_tg, int4, uint3)
#pragma tg_funcdef(as_int4, as_int_tg, int4, int3)
#pragma tg_funcdef(as_int4, as_int_tg, int4, uint4)
#pragma tg_funcdef(as_int4, as_int_tg, int4, int4)
#pragma tg_funcdef(as_int4, as_int_tg, int4, ulong2)
#pragma tg_funcdef(as_int4, as_int_tg, int4, long2)
#pragma tg_funcdef(as_int4, as_int_tg, int4, float3)
#pragma tg_funcdef(as_int4, as_int_tg, int4, float4)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(as_int4, as_int_tg, int4, double2)
 #endif
#undef as_int4
#define as_int4(__a) __tg_builtin_gentype("as_int4",__a)

#pragma tg_funcdef(as_int8, as_int_tg, int8, ushort16)
#pragma tg_funcdef(as_int8, as_int_tg, int8, short16)
#pragma tg_funcdef(as_int8, as_int_tg, int8, uint8)
#pragma tg_funcdef(as_int8, as_int_tg, int8, int8)
#pragma tg_funcdef(as_int8, as_int_tg, int8, ulong3)
#pragma tg_funcdef(as_int8, as_int_tg, int8, long3)
#pragma tg_funcdef(as_int8, as_int_tg, int8, ulong4)
#pragma tg_funcdef(as_int8, as_int_tg, int8, long4)
#pragma tg_funcdef(as_int8, as_int_tg, int8, float8)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(as_int8, as_int_tg, int8, double3)
#pragma tg_funcdef(as_int8, as_int_tg, int8, double4)
 #endif
#undef as_int8
#define as_int8(__a) __tg_builtin_gentype("as_int8",__a)

#pragma tg_funcdef(as_int16, as_int_tg, int16, uint16)
#pragma tg_funcdef(as_int16, as_int_tg, int16, int16)
#pragma tg_funcdef(as_int16, as_int_tg, int16, ulong8)
#pragma tg_funcdef(as_int16, as_int_tg, int16, long8)
#pragma tg_funcdef(as_int16, as_int_tg, int16, float16)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(as_int16, as_int_tg, int16, double8)
 #endif
#undef as_int16
#define as_int16(__a) __tg_builtin_gentype("as_int16",__a)

/* as_uintN */
#pragma tg_funcdef(as_uint, as_uint_tg, uint, uchar3)
#pragma tg_funcdef(as_uint, as_uint_tg, uint, char3)
#pragma tg_funcdef(as_uint, as_uint_tg, uint, uchar4)
#pragma tg_funcdef(as_uint, as_uint_tg, uint, char4)
#pragma tg_funcdef(as_uint, as_uint_tg, uint, ushort2)
#pragma tg_funcdef(as_uint, as_uint_tg, uint, short2)
#pragma tg_funcdef(as_uint, as_uint_tg, uint, uint)
#pragma tg_funcdef(as_uint, as_uint_tg, uint, int)
#pragma tg_funcdef(as_uint, as_uint_tg, uint, float)
#undef as_uint
#define as_uint(__a) __tg_builtin_gentype("as_uint",__a)

#pragma tg_funcdef(as_uint2, as_uint_tg, uint2, uchar8)
#pragma tg_funcdef(as_uint2, as_uint_tg, uint2, char8)
#pragma tg_funcdef(as_uint2, as_uint_tg, uint2, ushort3)
#pragma tg_funcdef(as_uint2, as_uint_tg, uint2, short3)
#pragma tg_funcdef(as_uint2, as_uint_tg, uint2, ushort4)
#pragma tg_funcdef(as_uint2, as_uint_tg, uint2, short4)
#pragma tg_funcdef(as_uint2, as_uint_tg, uint2, uint2)
#pragma tg_funcdef(as_uint2, as_uint_tg, uint2, int2)
#pragma tg_funcdef(as_uint2, as_uint_tg, uint2, ulong)
#pragma tg_funcdef(as_uint2, as_uint_tg, uint2, long)
#pragma tg_funcdef(as_uint2, as_uint_tg, uint2, float2)
#pragma tg_funcdef(as_uint2, as_uint_tg, uint2, double)
#undef as_uint2
#define as_uint2(__a) __tg_builtin_gentype("as_uint2",__a)

#pragma tg_funcdef(as_uint3, as_uint_tg, uint3, uchar16)
#pragma tg_funcdef(as_uint3, as_uint_tg, uint3, char16)
#pragma tg_funcdef(as_uint3, as_uint_tg, uint3, ushort8)
#pragma tg_funcdef(as_uint3, as_uint_tg, uint3, short8)
#pragma tg_funcdef(as_uint3, as_uint_tg, uint3, uint3)
#pragma tg_funcdef(as_uint3, as_uint_tg, uint3, int3)
#pragma tg_funcdef(as_uint3, as_uint_tg, uint3, uint4)
#pragma tg_funcdef(as_uint3, as_uint_tg, uint3, int4)
#pragma tg_funcdef(as_uint3, as_uint_tg, uint3, ulong2)
#pragma tg_funcdef(as_uint3, as_uint_tg, uint3, long2)
#pragma tg_funcdef(as_uint3, as_uint_tg, uint3, float3)
#pragma tg_funcdef(as_uint3, as_uint_tg, uint3, float4)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(as_uint3, as_uint_tg, uint3, double2)
 #endif
#undef as_uint3
#define as_uint3(__a) __tg_builtin_gentype("as_uint3",__a)

#pragma tg_funcdef(as_uint4, as_uint_tg, uint4, uchar16)
#pragma tg_funcdef(as_uint4, as_uint_tg, uint4, char16)
#pragma tg_funcdef(as_uint4, as_uint_tg, uint4, ushort8)
#pragma tg_funcdef(as_uint4, as_uint_tg, uint4, short8)
#pragma tg_funcdef(as_uint4, as_uint_tg, uint4, uint3)
#pragma tg_funcdef(as_uint4, as_uint_tg, uint4, int3)
#pragma tg_funcdef(as_uint4, as_uint_tg, uint4, uint4)
#pragma tg_funcdef(as_uint4, as_uint_tg, uint4, int4)
#pragma tg_funcdef(as_uint4, as_uint_tg, uint4, ulong2)
#pragma tg_funcdef(as_uint4, as_uint_tg, uint4, long2)
#pragma tg_funcdef(as_uint4, as_uint_tg, uint4, float3)
#pragma tg_funcdef(as_uint4, as_uint_tg, uint4, float4)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(as_uint4, as_uint_tg, uint4, double2)
 #endif
#undef as_uint4
#define as_uint4(__a) __tg_builtin_gentype("as_uint4",__a)

#pragma tg_funcdef(as_uint8, as_uint_tg, uint8, ushort16)
#pragma tg_funcdef(as_uint8, as_uint_tg, uint8, short16)
#pragma tg_funcdef(as_uint8, as_uint_tg, uint8, uint8)
#pragma tg_funcdef(as_uint8, as_uint_tg, uint8, int8)
#pragma tg_funcdef(as_uint8, as_uint_tg, uint8, ulong3)
#pragma tg_funcdef(as_uint8, as_uint_tg, uint8, long3)
#pragma tg_funcdef(as_uint8, as_uint_tg, uint8, ulong4)
#pragma tg_funcdef(as_uint8, as_uint_tg, uint8, long4)
#pragma tg_funcdef(as_uint8, as_uint_tg, uint8, float8)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(as_uint8, as_uint_tg, uint8, double3)
#pragma tg_funcdef(as_uint8, as_uint_tg, uint8, double4)
 #endif
#undef as_uint8
#define as_uint8(__a) __tg_builtin_gentype("as_uint8",__a)

#pragma tg_funcdef(as_uint16, as_uint_tg, uint16, uint16)
#pragma tg_funcdef(as_uint16, as_uint_tg, uint16, int16)
#pragma tg_funcdef(as_uint16, as_uint_tg, uint16, ulong8)
#pragma tg_funcdef(as_uint16, as_uint_tg, uint16, long8)
#pragma tg_funcdef(as_uint16, as_uint_tg, uint16, float16)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(as_uint16, as_uint_tg, uint16, double8)
 #endif
#undef as_uint16
#define as_uint16(__a) __tg_builtin_gentype("as_uint16",__a)

/* as_floatN */
#pragma tg_funcdef(as_float, as_float_tg, float, uchar3)
#pragma tg_funcdef(as_float, as_float_tg, float, char3)
#pragma tg_funcdef(as_float, as_float_tg, float, uchar4)
#pragma tg_funcdef(as_float, as_float_tg, float, char4)
#pragma tg_funcdef(as_float, as_float_tg, float, ushort2)
#pragma tg_funcdef(as_float, as_float_tg, float, short2)
#pragma tg_funcdef(as_float, as_float_tg, float, uint)
#pragma tg_funcdef(as_float, as_float_tg, float, int)
#pragma tg_funcdef(as_float, as_float_tg, float, float)
#undef as_float
#define as_float(__a) __tg_builtin_gentype("as_float",__a)

#pragma tg_funcdef(as_float2, as_float_tg, float2, uchar8)
#pragma tg_funcdef(as_float2, as_float_tg, float2, char8)
#pragma tg_funcdef(as_float2, as_float_tg, float2, ushort3)
#pragma tg_funcdef(as_float2, as_float_tg, float2, short3)
#pragma tg_funcdef(as_float2, as_float_tg, float2, ushort4)
#pragma tg_funcdef(as_float2, as_float_tg, float2, short4)
#pragma tg_funcdef(as_float2, as_float_tg, float2, uint2)
#pragma tg_funcdef(as_float2, as_float_tg, float2, int2)
#pragma tg_funcdef(as_float2, as_float_tg, float2, ulong)
#pragma tg_funcdef(as_float2, as_float_tg, float2, long)
#pragma tg_funcdef(as_float2, as_float_tg, float2, float2)
#pragma tg_funcdef(as_float2, as_float_tg, float2, double)
#undef as_float2
#define as_float2(__a) __tg_builtin_gentype("as_float2",__a)

#pragma tg_funcdef(as_float3, as_float_tg, float3, uchar16)
#pragma tg_funcdef(as_float3, as_float_tg, float3, char16)
#pragma tg_funcdef(as_float3, as_float_tg, float3, ushort8)
#pragma tg_funcdef(as_float3, as_float_tg, float3, short8)
#pragma tg_funcdef(as_float3, as_float_tg, float3, uint3)
#pragma tg_funcdef(as_float3, as_float_tg, float3, int3)
#pragma tg_funcdef(as_float3, as_float_tg, float3, uint4)
#pragma tg_funcdef(as_float3, as_float_tg, float3, int4)
#pragma tg_funcdef(as_float3, as_float_tg, float3, ulong2)
#pragma tg_funcdef(as_float3, as_float_tg, float3, long2)
#pragma tg_funcdef(as_float3, as_float_tg, float3, float3)
#pragma tg_funcdef(as_float3, as_float_tg, float3, float4)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(as_float3, as_float_tg, float3, double2)
 #endif
#undef as_float3
#define as_float3(__a) __tg_builtin_gentype("as_float3",__a)

#pragma tg_funcdef(as_float4, as_float_tg, float4, uchar16)
#pragma tg_funcdef(as_float4, as_float_tg, float4, char16)
#pragma tg_funcdef(as_float4, as_float_tg, float4, ushort8)
#pragma tg_funcdef(as_float4, as_float_tg, float4, short8)
#pragma tg_funcdef(as_float4, as_float_tg, float4, uint3)
#pragma tg_funcdef(as_float4, as_float_tg, float4, int3)
#pragma tg_funcdef(as_float4, as_float_tg, float4, uint4)
#pragma tg_funcdef(as_float4, as_float_tg, float4, int4)
#pragma tg_funcdef(as_float4, as_float_tg, float4, ulong2)
#pragma tg_funcdef(as_float4, as_float_tg, float4, long2)
#pragma tg_funcdef(as_float4, as_float_tg, float4, float3)
#pragma tg_funcdef(as_float4, as_float_tg, float4, float4)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(as_float4, as_float_tg, float4, double2)
 #endif
#undef as_float4
#define as_float4(__a) __tg_builtin_gentype("as_float4",__a)

#pragma tg_funcdef(as_float8, as_float_tg, float8, ushort16)
#pragma tg_funcdef(as_float8, as_float_tg, float8, short16)
#pragma tg_funcdef(as_float8, as_float_tg, float8, uint8)
#pragma tg_funcdef(as_float8, as_float_tg, float8, int8)
#pragma tg_funcdef(as_float8, as_float_tg, float8, ulong3)
#pragma tg_funcdef(as_float8, as_float_tg, float8, long3)
#pragma tg_funcdef(as_float8, as_float_tg, float8, ulong4)
#pragma tg_funcdef(as_float8, as_float_tg, float8, long4)
#pragma tg_funcdef(as_float8, as_float_tg, float8, float8)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(as_float8, as_float_tg, float8, double3)
#pragma tg_funcdef(as_float8, as_float_tg, float8, double4)
 #endif
#undef as_float8
#define as_float8(__a) __tg_builtin_gentype("as_float8",__a)

#pragma tg_funcdef(as_float16, as_float_tg, float16, uint16)
#pragma tg_funcdef(as_float16, as_float_tg, float16, int16)
#pragma tg_funcdef(as_float16, as_float_tg, float16, ulong8)
#pragma tg_funcdef(as_float16, as_float_tg, float16, long8)
#pragma tg_funcdef(as_float16, as_float_tg, float16, float16)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(as_float16, as_float_tg, float16, double8)
 #endif
#undef as_float16
#define as_float16(__a) __tg_builtin_gentype("as_float16",__a)

/* as_doubleN */
#pragma tg_funcdef(as_double, as_double_tg, double, uchar8)
#pragma tg_funcdef(as_double, as_double_tg, double, char8)
#pragma tg_funcdef(as_double, as_double_tg, double, ushort3)
#pragma tg_funcdef(as_double, as_double_tg, double, short3)
#pragma tg_funcdef(as_double, as_double_tg, double, ushort4)
#pragma tg_funcdef(as_double, as_double_tg, double, short4)
#pragma tg_funcdef(as_double, as_double_tg, double, uint2)
#pragma tg_funcdef(as_double, as_double_tg, double, int2)
#pragma tg_funcdef(as_double, as_double_tg, double, ulong)
#pragma tg_funcdef(as_double, as_double_tg, double, long)
#pragma tg_funcdef(as_double, as_double_tg, double, float2)
#pragma tg_funcdef(as_double, as_double_tg, double, double)
#undef as_double
#define as_double(__a) __tg_builtin_gentype("as_double",__a)

 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)

#pragma tg_funcdef(as_double2, as_double_tg, double2, uchar16)
#pragma tg_funcdef(as_double2, as_double_tg, double2, char16)
#pragma tg_funcdef(as_double2, as_double_tg, double2, ushort8)
#pragma tg_funcdef(as_double2, as_double_tg, double2, short8)
#pragma tg_funcdef(as_double2, as_double_tg, double2, uint3)
#pragma tg_funcdef(as_double2, as_double_tg, double2, int3)
#pragma tg_funcdef(as_double2, as_double_tg, double2, uint4)
#pragma tg_funcdef(as_double2, as_double_tg, double2, int4)
#pragma tg_funcdef(as_double2, as_double_tg, double2, ulong2)
#pragma tg_funcdef(as_double2, as_double_tg, double2, long2)
#pragma tg_funcdef(as_double2, as_double_tg, double2, float3)
#pragma tg_funcdef(as_double2, as_double_tg, double2, float4)
#pragma tg_funcdef(as_double2, as_double_tg, double2, double2)
#undef as_double2
#define as_double2(__a) __tg_builtin_gentype("as_double2",__a)

#pragma tg_funcdef(as_double3, as_double_tg, double3, ushort16)
#pragma tg_funcdef(as_double3, as_double_tg, double3, short16)
#pragma tg_funcdef(as_double3, as_double_tg, double3, uint8)
#pragma tg_funcdef(as_double3, as_double_tg, double3, int8)
#pragma tg_funcdef(as_double3, as_double_tg, double3, ulong3)
#pragma tg_funcdef(as_double3, as_double_tg, double3, long3)
#pragma tg_funcdef(as_double3, as_double_tg, double3, ulong4)
#pragma tg_funcdef(as_double3, as_double_tg, double3, long4)
#pragma tg_funcdef(as_double3, as_double_tg, double3, float8)
#pragma tg_funcdef(as_double3, as_double_tg, double3, double3)
#pragma tg_funcdef(as_double3, as_double_tg, double3, double4)
#undef as_double3
#define as_double3(__a) __tg_builtin_gentype("as_double3",__a)

#pragma tg_funcdef(as_double4, as_double_tg, double4, ushort16)
#pragma tg_funcdef(as_double4, as_double_tg, double4, short16)
#pragma tg_funcdef(as_double4, as_double_tg, double4, uint8)
#pragma tg_funcdef(as_double4, as_double_tg, double4, int8)
#pragma tg_funcdef(as_double4, as_double_tg, double4, ulong3)
#pragma tg_funcdef(as_double4, as_double_tg, double4, long3)
#pragma tg_funcdef(as_double4, as_double_tg, double4, ulong4)
#pragma tg_funcdef(as_double4, as_double_tg, double4, long4)
#pragma tg_funcdef(as_double4, as_double_tg, double4, float8)
#pragma tg_funcdef(as_double4, as_double_tg, double4, double3)
#pragma tg_funcdef(as_double4, as_double_tg, double4, double4)
#undef as_double4
#define as_double4(__a) __tg_builtin_gentype("as_double4",__a)

#pragma tg_funcdef(as_double8, as_double_tg, double8, uint16)
#pragma tg_funcdef(as_double8, as_double_tg, double8, int16)
#pragma tg_funcdef(as_double8, as_double_tg, double8, ulong8)
#pragma tg_funcdef(as_double8, as_double_tg, double8, long8)
#pragma tg_funcdef(as_double8, as_double_tg, double8, float16)
#pragma tg_funcdef(as_double8, as_double_tg, double8, double8)
#undef as_double8
#define as_double8(__a) __tg_builtin_gentype("as_double8",__a)

#pragma tg_funcdef(as_double16, as_double_tg, double16, ulong16)
#pragma tg_funcdef(as_double16, as_double_tg, double16, long16)
#pragma tg_funcdef(as_double16, as_double_tg, double16, double16)
#undef as_double16
#define as_double16(__a) __tg_builtin_gentype("as_double16",__a)

 #endif

/* as_ulongN */
#pragma tg_funcdef(as_ulong, as_ulong_tg, ulong, uchar8)
#pragma tg_funcdef(as_ulong, as_ulong_tg, ulong, char8)
#pragma tg_funcdef(as_ulong, as_ulong_tg, ulong, ushort3)
#pragma tg_funcdef(as_ulong, as_ulong_tg, ulong, short3)
#pragma tg_funcdef(as_ulong, as_ulong_tg, ulong, ushort4)
#pragma tg_funcdef(as_ulong, as_ulong_tg, ulong, short4)
#pragma tg_funcdef(as_ulong, as_ulong_tg, ulong, uint2)
#pragma tg_funcdef(as_ulong, as_ulong_tg, ulong, int2)
#pragma tg_funcdef(as_ulong, as_ulong_tg, ulong, ulong)
#pragma tg_funcdef(as_ulong, as_ulong_tg, ulong, long)
#pragma tg_funcdef(as_ulong, as_ulong_tg, ulong, float2)
#pragma tg_funcdef(as_ulong, as_ulong_tg, ulong, double)
#undef as_ulong
#define as_ulong(__a) __tg_builtin_gentype("as_ulong",__a)

#pragma tg_funcdef(as_ulong2, as_ulong_tg, ulong2, uchar16)
#pragma tg_funcdef(as_ulong2, as_ulong_tg, ulong2, char16)
#pragma tg_funcdef(as_ulong2, as_ulong_tg, ulong2, ushort8)
#pragma tg_funcdef(as_ulong2, as_ulong_tg, ulong2, short8)
#pragma tg_funcdef(as_ulong2, as_ulong_tg, ulong2, uint3)
#pragma tg_funcdef(as_ulong2, as_ulong_tg, ulong2, int3)
#pragma tg_funcdef(as_ulong2, as_ulong_tg, ulong2, uint4)
#pragma tg_funcdef(as_ulong2, as_ulong_tg, ulong2, int4)
#pragma tg_funcdef(as_ulong2, as_ulong_tg, ulong2, ulong2)
#pragma tg_funcdef(as_ulong2, as_ulong_tg, ulong2, long2)
#pragma tg_funcdef(as_ulong2, as_ulong_tg, ulong2, float3)
#pragma tg_funcdef(as_ulong2, as_ulong_tg, ulong2, float4)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(as_ulong2, as_ulong_tg, ulong2, double2)
 #endif
#undef as_ulong2
#define as_ulong2(__a) __tg_builtin_gentype("as_ulong2",__a)

#pragma tg_funcdef(as_ulong3, as_ulong_tg, ulong3, ushort16)
#pragma tg_funcdef(as_ulong3, as_ulong_tg, ulong3, short16)
#pragma tg_funcdef(as_ulong3, as_ulong_tg, ulong3, uint8)
#pragma tg_funcdef(as_ulong3, as_ulong_tg, ulong3, int8)
#pragma tg_funcdef(as_ulong3, as_ulong_tg, ulong3, ulong3)
#pragma tg_funcdef(as_ulong3, as_ulong_tg, ulong3, long3)
#pragma tg_funcdef(as_ulong3, as_ulong_tg, ulong3, ulong4)
#pragma tg_funcdef(as_ulong3, as_ulong_tg, ulong3, long4)
#pragma tg_funcdef(as_ulong3, as_ulong_tg, ulong3, float8)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(as_ulong3, as_ulong_tg, ulong3, double3)
#pragma tg_funcdef(as_ulong3, as_ulong_tg, ulong3, double4)
 #endif
#undef as_ulong3
#define as_ulong3(__a) __tg_builtin_gentype("as_ulong3",__a)

#pragma tg_funcdef(as_ulong4, as_ulong_tg, ulong4, ushort16)
#pragma tg_funcdef(as_ulong4, as_ulong_tg, ulong4, short16)
#pragma tg_funcdef(as_ulong4, as_ulong_tg, ulong4, uint8)
#pragma tg_funcdef(as_ulong4, as_ulong_tg, ulong4, int8)
#pragma tg_funcdef(as_ulong4, as_ulong_tg, ulong4, ulong3)
#pragma tg_funcdef(as_ulong4, as_ulong_tg, ulong4, long3)
#pragma tg_funcdef(as_ulong4, as_ulong_tg, ulong4, ulong4)
#pragma tg_funcdef(as_ulong4, as_ulong_tg, ulong4, long4)
#pragma tg_funcdef(as_ulong4, as_ulong_tg, ulong4, float8)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(as_ulong4, as_ulong_tg, ulong4, double3)
#pragma tg_funcdef(as_ulong4, as_ulong_tg, ulong4, double4)
 #endif
#undef as_ulong4
#define as_ulong4(__a) __tg_builtin_gentype("as_ulong4",__a)

#pragma tg_funcdef(as_ulong8, as_ulong_tg, ulong8, uint16)
#pragma tg_funcdef(as_ulong8, as_ulong_tg, ulong8, int16)
#pragma tg_funcdef(as_ulong8, as_ulong_tg, ulong8, ulong8)
#pragma tg_funcdef(as_ulong8, as_ulong_tg, ulong8, long8)
#pragma tg_funcdef(as_ulong8, as_ulong_tg, ulong8, float16)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(as_ulong8, as_ulong_tg, ulong8, double8)
 #endif
#undef as_ulong8
#define as_ulong8(__a) __tg_builtin_gentype("as_ulong8",__a)

#pragma tg_funcdef(as_ulong16, as_ulong_tg, ulong16, ulong16)
#pragma tg_funcdef(as_ulong16, as_ulong_tg, ulong16, long16)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(as_ulong16, as_ulong_tg, ulong16, double16)
 #endif
#undef as_ulong16
#define as_ulong16(__a) __tg_builtin_gentype("as_ulong16",__a)

/* as_longN */
#pragma tg_funcdef(as_long, as_long_tg, long, uchar8)
#pragma tg_funcdef(as_long, as_long_tg, long, char8)
#pragma tg_funcdef(as_long, as_long_tg, long, ushort3)
#pragma tg_funcdef(as_long, as_long_tg, long, short3)
#pragma tg_funcdef(as_long, as_long_tg, long, ushort4)
#pragma tg_funcdef(as_long, as_long_tg, long, short4)
#pragma tg_funcdef(as_long, as_long_tg, long, uint2)
#pragma tg_funcdef(as_long, as_long_tg, long, int2)
#pragma tg_funcdef(as_long, as_long_tg, long, ulong)
#pragma tg_funcdef(as_long, as_long_tg, long, long)
#pragma tg_funcdef(as_long, as_long_tg, long, float2)
#pragma tg_funcdef(as_long, as_long_tg, long, double)
#undef as_long
#define as_long(__a) __tg_builtin_gentype("as_long",__a)

#pragma tg_funcdef(as_long2, as_long_tg, long2, uchar16)
#pragma tg_funcdef(as_long2, as_long_tg, long2, char16)
#pragma tg_funcdef(as_long2, as_long_tg, long2, ushort8)
#pragma tg_funcdef(as_long2, as_long_tg, long2, short8)
#pragma tg_funcdef(as_long2, as_long_tg, long2, uint3)
#pragma tg_funcdef(as_long2, as_long_tg, long2, int3)
#pragma tg_funcdef(as_long2, as_long_tg, long2, uint4)
#pragma tg_funcdef(as_long2, as_long_tg, long2, int4)
#pragma tg_funcdef(as_long2, as_long_tg, long2, ulong2)
#pragma tg_funcdef(as_long2, as_long_tg, long2, long2)
#pragma tg_funcdef(as_long2, as_long_tg, long2, float3)
#pragma tg_funcdef(as_long2, as_long_tg, long2, float4)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(as_long2, as_long_tg, long2, double2)
 #endif
#undef as_long2
#define as_long2(__a) __tg_builtin_gentype("as_long2",__a)

#pragma tg_funcdef(as_long3, as_long_tg, long3, ushort16)
#pragma tg_funcdef(as_long3, as_long_tg, long3, short16)
#pragma tg_funcdef(as_long3, as_long_tg, long3, uint8)
#pragma tg_funcdef(as_long3, as_long_tg, long3, int8)
#pragma tg_funcdef(as_long3, as_long_tg, long3, ulong3)
#pragma tg_funcdef(as_long3, as_long_tg, long3, long3)
#pragma tg_funcdef(as_long3, as_long_tg, long3, ulong4)
#pragma tg_funcdef(as_long3, as_long_tg, long3, long4)
#pragma tg_funcdef(as_long3, as_long_tg, long3, float8)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(as_long3, as_long_tg, long3, double3)
#pragma tg_funcdef(as_long3, as_long_tg, long3, double4)
 #endif
#undef as_long3
#define as_long3(__a) __tg_builtin_gentype("as_long3",__a)

#pragma tg_funcdef(as_long4, as_long_tg, long4, ushort16)
#pragma tg_funcdef(as_long4, as_long_tg, long4, short16)
#pragma tg_funcdef(as_long4, as_long_tg, long4, uint8)
#pragma tg_funcdef(as_long4, as_long_tg, long4, int8)
#pragma tg_funcdef(as_long4, as_long_tg, long4, ulong3)
#pragma tg_funcdef(as_long4, as_long_tg, long4, long3)
#pragma tg_funcdef(as_long4, as_long_tg, long4, ulong4)
#pragma tg_funcdef(as_long4, as_long_tg, long4, long4)
#pragma tg_funcdef(as_long4, as_long_tg, long4, float8)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(as_long4, as_long_tg, long4, double3)
#pragma tg_funcdef(as_long4, as_long_tg, long4, double4)
 #endif
#undef as_long4
#define as_long4(__a) __tg_builtin_gentype("as_long4",__a)

#pragma tg_funcdef(as_long8, as_long_tg, long8, uint16)
#pragma tg_funcdef(as_long8, as_long_tg, long8, int16)
#pragma tg_funcdef(as_long8, as_long_tg, long8, ulong8)
#pragma tg_funcdef(as_long8, as_long_tg, long8, long8)
#pragma tg_funcdef(as_long8, as_long_tg, long8, float16)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(as_long8, as_long_tg, long8, double8)
 #endif
#undef as_long8
#define as_long8(__a) __tg_builtin_gentype("as_long8",__a)

#pragma tg_funcdef(as_long16, as_long_tg, long16, ulong16)
#pragma tg_funcdef(as_long16, as_long_tg, long16, long16)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(as_long16, as_long_tg, long16, double16)
 #endif
#undef as_long16
#define as_long16(__a) __tg_builtin_gentype("as_long16",__a)

/* 6.11.1 Work-Item Functions */

/* get_work_dim */
/* get_global_size */
/* get_global_id */
/* get_local_size */
/* get_local_id */
/* get_num_groups */
/* get_group_id */

/* 6.11.2 Math Functions */

#pragma tg_funcdef(acos, __acos_float, float, float)
#pragma tg_funcdef(acos, __acos_float2, float2, float2)
#pragma tg_funcdef(acos, __acos_float3, float3, float3)
#pragma tg_funcdef(acos, __acos_float4, float4, float4)
#pragma tg_funcdef(acos, __acos_float8, float8, float8)
#pragma tg_funcdef(acos, __acos_float16, float16, float16)
#pragma tg_funcdef(acos, __acos_double, double, double)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(acos, __acos_double2, double2, double2)
#pragma tg_funcdef(acos, __acos_double3, double3, double3)
#pragma tg_funcdef(acos, __acos_double4, double4, double4)
#pragma tg_funcdef(acos, __acos_double8, double8, double8)
#pragma tg_funcdef(acos, __acos_double16, double16, double16)
 #endif
#undef acos
#define acos(__a) __tg_builtin("acos", __a)

#pragma tg_funcdef(acosh, __acosh_float, float, float)
#pragma tg_funcdef(acosh, __acosh_float2, float2, float2)
#pragma tg_funcdef(acosh, __acosh_float3, float3, float3)
#pragma tg_funcdef(acosh, __acosh_float4, float4, float4)
#pragma tg_funcdef(acosh, __acosh_float8, float8, float8)
#pragma tg_funcdef(acosh, __acosh_float16, float16, float16)
#pragma tg_funcdef(acosh, __acosh_double, double, double)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(acosh, __acosh_double2, double2, double2)
#pragma tg_funcdef(acosh, __acosh_double3, double3, double3)
#pragma tg_funcdef(acosh, __acosh_double4, double4, double4)
#pragma tg_funcdef(acosh, __acosh_double8, double8, double8)
#pragma tg_funcdef(acosh, __acosh_double16, double16, double16)
 #endif
#undef acosh
#define acosh(__a) __tg_builtin("acosh", __a)

#pragma tg_funcdef(acospi, __acospi_float, float, float)
#pragma tg_funcdef(acospi, __acospi_float2, float2, float2)
#pragma tg_funcdef(acospi, __acospi_float3, float3, float3)
#pragma tg_funcdef(acospi, __acospi_float4, float4, float4)
#pragma tg_funcdef(acospi, __acospi_float8, float8, float8)
#pragma tg_funcdef(acospi, __acospi_float16, float16, float16)
#pragma tg_funcdef(acospi, __acospi_double, double, double)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(acospi, __acospi_double2, double2, double2)
#pragma tg_funcdef(acospi, __acospi_double3, double3, double3)
#pragma tg_funcdef(acospi, __acospi_double4, double4, double4)
#pragma tg_funcdef(acospi, __acospi_double8, double8, double8)
#pragma tg_funcdef(acospi, __acospi_double16, double16, double16)
 #endif
#undef acospi
#define acospi(__a) __tg_builtin("acospi", __a)

#pragma tg_funcdef(asin, __asin_float, float, float)
#pragma tg_funcdef(asin, __asin_float2, float2, float2)
#pragma tg_funcdef(asin, __asin_float3, float3, float3)
#pragma tg_funcdef(asin, __asin_float4, float4, float4)
#pragma tg_funcdef(asin, __asin_float8, float8, float8)
#pragma tg_funcdef(asin, __asin_float16, float16, float16)
#pragma tg_funcdef(asin, __asin_double, double, double)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(asin, __asin_double2, double2, double2)
#pragma tg_funcdef(asin, __asin_double3, double3, double3)
#pragma tg_funcdef(asin, __asin_double4, double4, double4)
#pragma tg_funcdef(asin, __asin_double8, double8, double8)
#pragma tg_funcdef(asin, __asin_double16, double16, double16)
 #endif
#undef asin
#define asin(__a) __tg_builtin("asin", __a)

#pragma tg_funcdef(asinh, __asinh_float, float, float)
#pragma tg_funcdef(asinh, __asinh_float2, float2, float2)
#pragma tg_funcdef(asinh, __asinh_float3, float3, float3)
#pragma tg_funcdef(asinh, __asinh_float4, float4, float4)
#pragma tg_funcdef(asinh, __asinh_float8, float8, float8)
#pragma tg_funcdef(asinh, __asinh_float16, float16, float16)
#pragma tg_funcdef(asinh, __asinh_double, double, double)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(asinh, __asinh_double2, double2, double2)
#pragma tg_funcdef(asinh, __asinh_double3, double3, double3)
#pragma tg_funcdef(asinh, __asinh_double4, double4, double4)
#pragma tg_funcdef(asinh, __asinh_double8, double8, double8)
#pragma tg_funcdef(asinh, __asinh_double16, double16, double16)
 #endif
#undef asinh
#define asinh(__a) __tg_builtin("asinh", __a)

#pragma tg_funcdef(asinpi, __asinpi_float, float, float)
#pragma tg_funcdef(asinpi, __asinpi_float2, float2, float2)
#pragma tg_funcdef(asinpi, __asinpi_float3, float3, float3)
#pragma tg_funcdef(asinpi, __asinpi_float4, float4, float4)
#pragma tg_funcdef(asinpi, __asinpi_float8, float8, float8)
#pragma tg_funcdef(asinpi, __asinpi_float16, float16, float16)
#pragma tg_funcdef(asinpi, __asinpi_double, double, double)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(asinpi, __asinpi_double2, double2, double2)
#pragma tg_funcdef(asinpi, __asinpi_double3, double3, double3)
#pragma tg_funcdef(asinpi, __asinpi_double4, double4, double4)
#pragma tg_funcdef(asinpi, __asinpi_double8, double8, double8)
#pragma tg_funcdef(asinpi, __asinpi_double16, double16, double16)
 #endif
#undef asinpi
#define asinpi(__a) __tg_builtin("asinpi", __a)

#pragma tg_funcdef(atan, __atan_float, float, float)
#pragma tg_funcdef(atan, __atan_float2, float2, float2)
#pragma tg_funcdef(atan, __atan_float3, float3, float3)
#pragma tg_funcdef(atan, __atan_float4, float4, float4)
#pragma tg_funcdef(atan, __atan_float8, float8, float8)
#pragma tg_funcdef(atan, __atan_float16, float16, float16)
#pragma tg_funcdef(atan, __atan_double, double, double)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(atan, __atan_double2, double2, double2)
#pragma tg_funcdef(atan, __atan_double3, double3, double3)
#pragma tg_funcdef(atan, __atan_double4, double4, double4)
#pragma tg_funcdef(atan, __atan_double8, double8, double8)
#pragma tg_funcdef(atan, __atan_double16, double16, double16)
 #endif
#undef atan
#define atan(__a) __tg_builtin("atan", __a)

#pragma tg_funcdef(atan2, __atan2_float, float, float, float)
#pragma tg_funcdef(atan2, __atan2_float2, float2, float2, float2)
#pragma tg_funcdef(atan2, __atan2_float3, float3, float3, float3)
#pragma tg_funcdef(atan2, __atan2_float4, float4, float4, float4)
#pragma tg_funcdef(atan2, __atan2_float8, float8, float8, float8)
#pragma tg_funcdef(atan2, __atan2_float16, float16, float16, float16)
#pragma tg_funcdef(atan2, __atan2_double, double, double, double)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(atan2, __atan2_double2, double2, double2, double2)
#pragma tg_funcdef(atan2, __atan2_double3, double3, double3, double3)
#pragma tg_funcdef(atan2, __atan2_double4, double4, double4, double4)
#pragma tg_funcdef(atan2, __atan2_double8, double8, double8, double8)
#pragma tg_funcdef(atan2, __atan2_double16, double16, double16, double16)
 #endif
#undef atan2
#define atan2(__a, __b) __tg_builtin("atan2", __a, __b)

#pragma tg_funcdef(atanh, __atanh_float, float, float)
#pragma tg_funcdef(atanh, __atanh_float2, float2, float2)
#pragma tg_funcdef(atanh, __atanh_float3, float3, float3)
#pragma tg_funcdef(atanh, __atanh_float4, float4, float4)
#pragma tg_funcdef(atanh, __atanh_float8, float8, float8)
#pragma tg_funcdef(atanh, __atanh_float16, float16, float16)
#pragma tg_funcdef(atanh, __atanh_double, double, double)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(atanh, __atanh_double2, double2, double2)
#pragma tg_funcdef(atanh, __atanh_double3, double3, double3)
#pragma tg_funcdef(atanh, __atanh_double4, double4, double4)
#pragma tg_funcdef(atanh, __atanh_double8, double8, double8)
#pragma tg_funcdef(atanh, __atanh_double16, double16, double16)
 #endif
#undef atanh
#define atanh(__a) __tg_builtin("atanh", __a)

#pragma tg_funcdef(atanpi, __atanpi_float, float, float)
#pragma tg_funcdef(atanpi, __atanpi_float2, float2, float2)
#pragma tg_funcdef(atanpi, __atanpi_float3, float3, float3)
#pragma tg_funcdef(atanpi, __atanpi_float4, float4, float4)
#pragma tg_funcdef(atanpi, __atanpi_float8, float8, float8)
#pragma tg_funcdef(atanpi, __atanpi_float16, float16, float16)
#pragma tg_funcdef(atanpi, __atanpi_double, double, double)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(atanpi, __atanpi_double2, double2, double2)
#pragma tg_funcdef(atanpi, __atanpi_double3, double3, double3)
#pragma tg_funcdef(atanpi, __atanpi_double4, double4, double4)
#pragma tg_funcdef(atanpi, __atanpi_double8, double8, double8)
#pragma tg_funcdef(atanpi, __atanpi_double16, double16, double16)
 #endif
#undef atanpi
#define atanpi(__a) __tg_builtin("atanpi", __a)

#pragma tg_funcdef(atan2pi, __atan2pi_float, float, float, float)
#pragma tg_funcdef(atan2pi, __atan2pi_float2, float2, float2, float2)
#pragma tg_funcdef(atan2pi, __atan2pi_float3, float3, float3, float3)
#pragma tg_funcdef(atan2pi, __atan2pi_float4, float4, float4, float4)
#pragma tg_funcdef(atan2pi, __atan2pi_float8, float8, float8, float8)
#pragma tg_funcdef(atan2pi, __atan2pi_float16, float16, float16, float16)
#pragma tg_funcdef(atan2pi, __atan2pi_double, double, double, double)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(atan2pi, __atan2pi_double2, double2, double2, double2)
#pragma tg_funcdef(atan2pi, __atan2pi_double3, double3, double3, double3)
#pragma tg_funcdef(atan2pi, __atan2pi_double4, double4, double4, double4)
#pragma tg_funcdef(atan2pi, __atan2pi_double8, double8, double8, double8)
#pragma tg_funcdef(atan2pi, __atan2pi_double16, double16, double16, double16)
 #endif
#undef atan2pi
#define atan2pi(__a, __b) __tg_builtin("atan2pi", __a, __b)

#pragma tg_funcdef(cbrt, __cbrt_float, float, float)
#pragma tg_funcdef(cbrt, __cbrt_float2, float2, float2)
#pragma tg_funcdef(cbrt, __cbrt_float3, float3, float3)
#pragma tg_funcdef(cbrt, __cbrt_float4, float4, float4)
#pragma tg_funcdef(cbrt, __cbrt_float8, float8, float8)
#pragma tg_funcdef(cbrt, __cbrt_float16, float16, float16)
#pragma tg_funcdef(cbrt, __cbrt_double, double, double)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(cbrt, __cbrt_double2, double2, double2)
#pragma tg_funcdef(cbrt, __cbrt_double3, double3, double3)
#pragma tg_funcdef(cbrt, __cbrt_double4, double4, double4)
#pragma tg_funcdef(cbrt, __cbrt_double8, double8, double8)
#pragma tg_funcdef(cbrt, __cbrt_double16, double16, double16)
 #endif
#undef cbrt
#define cbrt(__a) __tg_builtin("cbrt", __a)

#pragma tg_funcdef(ceil, __ceil_float, float, float)
#pragma tg_funcdef(ceil, __ceil_float2, float2, float2)
#pragma tg_funcdef(ceil, __ceil_float3, float3, float3)
#pragma tg_funcdef(ceil, __ceil_float4, float4, float4)
#pragma tg_funcdef(ceil, __ceil_float8, float8, float8)
#pragma tg_funcdef(ceil, __ceil_float16, float16, float16)
#pragma tg_funcdef(ceil, __ceil_double, double, double)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(ceil, __ceil_double2, double2, double2)
#pragma tg_funcdef(ceil, __ceil_double3, double3, double3)
#pragma tg_funcdef(ceil, __ceil_double4, double4, double4)
#pragma tg_funcdef(ceil, __ceil_double8, double8, double8)
#pragma tg_funcdef(ceil, __ceil_double16, double16, double16)
 #endif
#undef ceil
#define ceil(__a) __tg_builtin("ceil", __a)

#pragma tg_funcdef(copysign, copysign_tg, float, float, float)
#pragma tg_funcdef(copysign, copysign_tg, float2, float2, float2)
#pragma tg_funcdef(copysign, copysign_tg, float3, float3, float3)
#pragma tg_funcdef(copysign, copysign_tg, float4, float4, float4)
#pragma tg_funcdef(copysign, copysign_tg, float8, float8, float8)
#pragma tg_funcdef(copysign, copysign_tg, float16, float16, float16)
#pragma tg_funcdef(copysign, copysign_tg, double, double, double)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(copysign, copysign_tg, double2, double2, double2)
#pragma tg_funcdef(copysign, copysign_tg, double3, double3, double3)
#pragma tg_funcdef(copysign, copysign_tg, double4, double4, double4)
#pragma tg_funcdef(copysign, copysign_tg, double8, double8, double8)
#pragma tg_funcdef(copysign, copysign_tg, double16, double16, double16)
 #endif
#undef copysign
#define copysign(__a,__b) __tg_builtin_gentype("copysign",__a,__b)

#pragma tg_funcdef(cos, __cos_float, float, float)
#pragma tg_funcdef(cos, __cos_float2, float2, float2)
#pragma tg_funcdef(cos, __cos_float3, float3, float3)
#pragma tg_funcdef(cos, __cos_float4, float4, float4)
#pragma tg_funcdef(cos, __cos_float8, float8, float8)
#pragma tg_funcdef(cos, __cos_float16, float16, float16)
#pragma tg_funcdef(cos, __cos_double, double, double)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(cos, __cos_double2, double2, double2)
#pragma tg_funcdef(cos, __cos_double3, double3, double3)
#pragma tg_funcdef(cos, __cos_double4, double4, double4)
#pragma tg_funcdef(cos, __cos_double8, double8, double8)
#pragma tg_funcdef(cos, __cos_double16, double16, double16)
 #endif
#undef cos
#define cos(__a) __tg_builtin("cos", __a)

#pragma tg_funcdef(cosh, __cosh_float, float, float)
#pragma tg_funcdef(cosh, __cosh_float2, float2, float2)
#pragma tg_funcdef(cosh, __cosh_float3, float3, float3)
#pragma tg_funcdef(cosh, __cosh_float4, float4, float4)
#pragma tg_funcdef(cosh, __cosh_float8, float8, float8)
#pragma tg_funcdef(cosh, __cosh_float16, float16, float16)
#pragma tg_funcdef(cosh, __cosh_double, double, double)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(cosh, __cosh_double2, double2, double2)
#pragma tg_funcdef(cosh, __cosh_double3, double3, double3)
#pragma tg_funcdef(cosh, __cosh_double4, double4, double4)
#pragma tg_funcdef(cosh, __cosh_double8, double8, double8)
#pragma tg_funcdef(cosh, __cosh_double16, double16, double16)
 #endif
#undef cosh
#define cosh(__a) __tg_builtin("cosh", __a)

#pragma tg_funcdef(cospi, __cospi_float, float, float)
#pragma tg_funcdef(cospi, __cospi_float2, float2, float2)
#pragma tg_funcdef(cospi, __cospi_float3, float3, float3)
#pragma tg_funcdef(cospi, __cospi_float4, float4, float4)
#pragma tg_funcdef(cospi, __cospi_float8, float8, float8)
#pragma tg_funcdef(cospi, __cospi_float16, float16, float16)
#pragma tg_funcdef(cospi, __cospi_double, double, double)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(cospi, __cospi_double2, double2, double2)
#pragma tg_funcdef(cospi, __cospi_double3, double3, double3)
#pragma tg_funcdef(cospi, __cospi_double4, double4, double4)
#pragma tg_funcdef(cospi, __cospi_double8, double8, double8)
#pragma tg_funcdef(cospi, __cospi_double16, double16, double16)
 #endif
#undef cospi
#define cospi(__a) __tg_builtin("cospi", __a)

#pragma tg_funcdef(erfc, __erfc_float, float, float)
#pragma tg_funcdef(erfc, __erfc_float2, float2, float2)
#pragma tg_funcdef(erfc, __erfc_float3, float3, float3)
#pragma tg_funcdef(erfc, __erfc_float4, float4, float4)
#pragma tg_funcdef(erfc, __erfc_float8, float8, float8)
#pragma tg_funcdef(erfc, __erfc_float16, float16, float16)
#pragma tg_funcdef(erfc, __erfc_double, double, double)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(erfc, __erfc_double2, double2, double2)
#pragma tg_funcdef(erfc, __erfc_double3, double3, double3)
#pragma tg_funcdef(erfc, __erfc_double4, double4, double4)
#pragma tg_funcdef(erfc, __erfc_double8, double8, double8)
#pragma tg_funcdef(erfc, __erfc_double16, double16, double16)
 #endif
#undef erfc
#define erfc(__a) __tg_builtin("erfc", __a)

#pragma tg_funcdef(erf, __erf_float, float, float)
#pragma tg_funcdef(erf, __erf_float2, float2, float2)
#pragma tg_funcdef(erf, __erf_float3, float3, float3)
#pragma tg_funcdef(erf, __erf_float4, float4, float4)
#pragma tg_funcdef(erf, __erf_float8, float8, float8)
#pragma tg_funcdef(erf, __erf_float16, float16, float16)
#pragma tg_funcdef(erf, __erf_double, double, double)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(erf, __erf_double2, double2, double2)
#pragma tg_funcdef(erf, __erf_double3, double3, double3)
#pragma tg_funcdef(erf, __erf_double4, double4, double4)
#pragma tg_funcdef(erf, __erf_double8, double8, double8)
#pragma tg_funcdef(erf, __erf_double16, double16, double16)
 #endif
#undef erf
#define erf(__a) __tg_builtin("erf", __a)

#pragma tg_funcdef(exp, __exp_float, float, float)
#pragma tg_funcdef(exp, __exp_float2, float2, float2)
#pragma tg_funcdef(exp, __exp_float3, float3, float3)
#pragma tg_funcdef(exp, __exp_float4, float4, float4)
#pragma tg_funcdef(exp, __exp_float8, float8, float8)
#pragma tg_funcdef(exp, __exp_float16, float16, float16)
#pragma tg_funcdef(exp, __exp_double, double, double)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(exp, __exp_double2, double2, double2)
#pragma tg_funcdef(exp, __exp_double3, double3, double3)
#pragma tg_funcdef(exp, __exp_double4, double4, double4)
#pragma tg_funcdef(exp, __exp_double8, double8, double8)
#pragma tg_funcdef(exp, __exp_double16, double16, double16)
 #endif
#undef exp
#define exp(__a) __tg_builtin("exp", __a)

#pragma tg_funcdef(exp2, __exp2_float, float, float)
#pragma tg_funcdef(exp2, __exp2_float2, float2, float2)
#pragma tg_funcdef(exp2, __exp2_float3, float3, float3)
#pragma tg_funcdef(exp2, __exp2_float4, float4, float4)
#pragma tg_funcdef(exp2, __exp2_float8, float8, float8)
#pragma tg_funcdef(exp2, __exp2_float16, float16, float16)
#pragma tg_funcdef(exp2, __exp2_double, double, double)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(exp2, __exp2_double2, double2, double2)
#pragma tg_funcdef(exp2, __exp2_double3, double3, double3)
#pragma tg_funcdef(exp2, __exp2_double4, double4, double4)
#pragma tg_funcdef(exp2, __exp2_double8, double8, double8)
#pragma tg_funcdef(exp2, __exp2_double16, double16, double16)
 #endif
#undef exp2
#define exp2(__a) __tg_builtin("exp2", __a)

#pragma tg_funcdef(exp10, __exp10_float, float, float)
#pragma tg_funcdef(exp10, __exp10_float2, float2, float2)
#pragma tg_funcdef(exp10, __exp10_float3, float3, float3)
#pragma tg_funcdef(exp10, __exp10_float4, float4, float4)
#pragma tg_funcdef(exp10, __exp10_float8, float8, float8)
#pragma tg_funcdef(exp10, __exp10_float16, float16, float16)
#pragma tg_funcdef(exp10, __exp10_double, double, double)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(exp10, __exp10_double2, double2, double2)
#pragma tg_funcdef(exp10, __exp10_double3, double3, double3)
#pragma tg_funcdef(exp10, __exp10_double4, double4, double4)
#pragma tg_funcdef(exp10, __exp10_double8, double8, double8)
#pragma tg_funcdef(exp10, __exp10_double16, double16, double16)
 #endif
#undef exp10
#define exp10(__a) __tg_builtin("exp10", __a)

#pragma tg_funcdef(expm1, __expm1_float, float, float)
#pragma tg_funcdef(expm1, __expm1_float2, float2, float2)
#pragma tg_funcdef(expm1, __expm1_float3, float3, float3)
#pragma tg_funcdef(expm1, __expm1_float4, float4, float4)
#pragma tg_funcdef(expm1, __expm1_float8, float8, float8)
#pragma tg_funcdef(expm1, __expm1_float16, float16, float16)
#pragma tg_funcdef(expm1, __expm1_double, double, double)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(expm1, __expm1_double2, double2, double2)
#pragma tg_funcdef(expm1, __expm1_double3, double3, double3)
#pragma tg_funcdef(expm1, __expm1_double4, double4, double4)
#pragma tg_funcdef(expm1, __expm1_double8, double8, double8)
#pragma tg_funcdef(expm1, __expm1_double16, double16, double16)
 #endif
#undef expm1
#define expm1(__a) __tg_builtin("expm1", __a)

#pragma tg_funcdef(fabs, fabs_tg, float, float)
#pragma tg_funcdef(fabs, fabs_tg, float2, float2)
#pragma tg_funcdef(fabs, fabs_tg, float3, float3)
#pragma tg_funcdef(fabs, fabs_tg, float4, float4)
#pragma tg_funcdef(fabs, fabs_tg, float8, float8)
#pragma tg_funcdef(fabs, fabs_tg, float16, float16)
#pragma tg_funcdef(fabs, fabs_tg, double, double)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(fabs, fabs_tg, double2, double2)
#pragma tg_funcdef(fabs, fabs_tg, double3, double3)
#pragma tg_funcdef(fabs, fabs_tg, double4, double4)
#pragma tg_funcdef(fabs, fabs_tg, double8, double8)
#pragma tg_funcdef(fabs, fabs_tg, double16, double16)
 #endif
#undef fabs
#define fabs(__a) __tg_builtin_gentype("fabs",__a)

#pragma tg_funcdef(fdim, __fdim_float, float, float, float)
#pragma tg_funcdef(fdim, __fdim_float2, float2, float2, float2)
#pragma tg_funcdef(fdim, __fdim_float3, float3, float3, float3)
#pragma tg_funcdef(fdim, __fdim_float4, float4, float4, float4)
#pragma tg_funcdef(fdim, __fdim_float8, float8, float8, float8)
#pragma tg_funcdef(fdim, __fdim_float16, float16, float16, float16)
#pragma tg_funcdef(fdim, __fdim_double, double, double, double)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(fdim, __fdim_double2, double2, double2, double2)
#pragma tg_funcdef(fdim, __fdim_double3, double3, double3, double3)
#pragma tg_funcdef(fdim, __fdim_double4, double4, double4, double4)
#pragma tg_funcdef(fdim, __fdim_double8, double8, double8, double8)
#pragma tg_funcdef(fdim, __fdim_double16, double16, double16, double16)
 #endif
#undef fdim
#define fdim(__a, __b) __tg_builtin("fdim", __a, __b)

#pragma tg_funcdef(floor, __floor_float, float, float)
#pragma tg_funcdef(floor, __floor_float2, float2, float2)
#pragma tg_funcdef(floor, __floor_float3, float3, float3)
#pragma tg_funcdef(floor, __floor_float4, float4, float4)
#pragma tg_funcdef(floor, __floor_float8, float8, float8)
#pragma tg_funcdef(floor, __floor_float16, float16, float16)
#pragma tg_funcdef(floor, __floor_double, double, double)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(floor, __floor_double2, double2, double2)
#pragma tg_funcdef(floor, __floor_double3, double3, double3)
#pragma tg_funcdef(floor, __floor_double4, double4, double4)
#pragma tg_funcdef(floor, __floor_double8, double8, double8)
#pragma tg_funcdef(floor, __floor_double16, double16, double16)
 #endif
#undef floor
#define floor(__a) __tg_builtin("floor", __a)

#pragma tg_funcdef(fma, fma_tg, float, float, float, float)
#pragma tg_funcdef(fma, fma_tg, float2, float2, float2, float2)
#pragma tg_funcdef(fma, fma_tg, float3, float3, float3, float3)
#pragma tg_funcdef(fma, fma_tg, float4, float4, float4, float4)
#pragma tg_funcdef(fma, fma_tg, float8, float8, float8, float8)
#pragma tg_funcdef(fma, fma_tg, float16, float16, float16, float16)
#pragma tg_funcdef(fma, fma_tg, double, double, double, double)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(fma, fma_tg, double2, double2, double2, double2)
#pragma tg_funcdef(fma, fma_tg, double3, double3, double3, double3)
#pragma tg_funcdef(fma, fma_tg, double4, double4, double4, double4)
#pragma tg_funcdef(fma, fma_tg, double8, double8, double8, double8)
#pragma tg_funcdef(fma, fma_tg, double16, double16, double16, double16)
 #endif
#undef fma
#define fma(__a,__b,__c) __tg_builtin_gentype("fma",__a,__b,__c)

#pragma tg_funcdef(__fnms, fnms_tg, float, float, float, float)
#pragma tg_funcdef(__fnms, fnms_tg, float2, float2, float2, float2)
#pragma tg_funcdef(__fnms, fnms_tg, float3, float3, float3, float3)
#pragma tg_funcdef(__fnms, fnms_tg, float4, float4, float4, float4)
#pragma tg_funcdef(__fnms, fnms_tg, float8, float8, float8, float8)
#pragma tg_funcdef(__fnms, fnms_tg, float16, float16, float16, float16)
#pragma tg_funcdef(__fnms, fnms_tg, double, double, double, double)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(__fnms, fnms_tg, double2, double2, double2, double2)
#pragma tg_funcdef(__fnms, fnms_tg, double3, double3, double3, double3)
#pragma tg_funcdef(__fnms, fnms_tg, double4, double4, double4, double4)
#pragma tg_funcdef(__fnms, fnms_tg, double8, double8, double8, double8)
#pragma tg_funcdef(__fnms, fnms_tg, double16, double16, double16, double16)
 #endif
#undef __fnms
#define __fnms(__a,__b,__c) __tg_builtin_gentype("__fnms",__a,__b,__c)

#pragma tg_funcdef(fmax, __fmax_float, float, float, float)
#pragma tg_funcdef(fmax, __fmax_float2, float2, float2, float2)
#pragma tg_funcdef(fmax, __fmax_float3, float3, float3, float3)
#pragma tg_funcdef(fmax, __fmax_float4, float4, float4, float4)
#pragma tg_funcdef(fmax, __fmax_float8, float8, float8, float8)
#pragma tg_funcdef(fmax, __fmax_float16, float16, float16, float16)
#pragma tg_funcdef(fmax, __fmax_float_float2, float2, float2, float)
#pragma tg_funcdef(fmax, __fmax_float_float3, float3, float3, float)
#pragma tg_funcdef(fmax, __fmax_float_float4, float4, float4, float)
#pragma tg_funcdef(fmax, __fmax_float_float8, float8, float8, float)
#pragma tg_funcdef(fmax, __fmax_float_float16, float16, float16, float)
#pragma tg_funcdef(fmax, __fmax_double, double, double, double)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(fmax, __fmax_double2, double2, double2, double2)
#pragma tg_funcdef(fmax, __fmax_double3, double3, double3, double3)
#pragma tg_funcdef(fmax, __fmax_double4, double4, double4, double4)
#pragma tg_funcdef(fmax, __fmax_double8, double8, double8, double8)
#pragma tg_funcdef(fmax, __fmax_double16, double16, double16, double16)
#pragma tg_funcdef(fmax, __fmax_double_double2, double2, double2, double)
#pragma tg_funcdef(fmax, __fmax_double_double3, double3, double3, double)
#pragma tg_funcdef(fmax, __fmax_double_double4, double4, double4, double)
#pragma tg_funcdef(fmax, __fmax_double_double8, double8, double8, double)
#pragma tg_funcdef(fmax, __fmax_double_double16, double16, double16, double)
 #endif
#undef fmax
#define fmax(__a, __b) __tg_builtin("fmax", __a, __b)

#pragma tg_funcdef(fmin, __fmin_float, float, float, float)
#pragma tg_funcdef(fmin, __fmin_float2, float2, float2, float2)
#pragma tg_funcdef(fmin, __fmin_float3, float3, float3, float3)
#pragma tg_funcdef(fmin, __fmin_float4, float4, float4, float4)
#pragma tg_funcdef(fmin, __fmin_float8, float8, float8, float8)
#pragma tg_funcdef(fmin, __fmin_float16, float16, float16, float16)
#pragma tg_funcdef(fmin, __fmin_float_float2, float2, float2, float)
#pragma tg_funcdef(fmin, __fmin_float_float3, float3, float3, float)
#pragma tg_funcdef(fmin, __fmin_float_float4, float4, float4, float)
#pragma tg_funcdef(fmin, __fmin_float_float8, float8, float8, float)
#pragma tg_funcdef(fmin, __fmin_float_float16, float16, float16, float)
#pragma tg_funcdef(fmin, __fmin_double, double, double, double)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(fmin, __fmin_double2, double2, double2, double2)
#pragma tg_funcdef(fmin, __fmin_double3, double3, double3, double3)
#pragma tg_funcdef(fmin, __fmin_double4, double4, double4, double4)
#pragma tg_funcdef(fmin, __fmin_double8, double8, double8, double8)
#pragma tg_funcdef(fmin, __fmin_double16, double16, double16, double16)
#pragma tg_funcdef(fmin, __fmin_double_double2, double2, double2, double)
#pragma tg_funcdef(fmin, __fmin_double_double3, double3, double3, double)
#pragma tg_funcdef(fmin, __fmin_double_double4, double4, double4, double)
#pragma tg_funcdef(fmin, __fmin_double_double8, double8, double8, double)
#pragma tg_funcdef(fmin, __fmin_double_double16, double16, double16, double)
 #endif
#undef fmin
#define fmin(__a, __b) __tg_builtin("fmin", __a, __b)

#pragma tg_funcdef(fmod, __fmod_float, float, float, float)
#pragma tg_funcdef(fmod, __fmod_float2, float2, float2, float2)
#pragma tg_funcdef(fmod, __fmod_float3, float3, float3, float3)
#pragma tg_funcdef(fmod, __fmod_float4, float4, float4, float4)
#pragma tg_funcdef(fmod, __fmod_float8, float8, float8, float8)
#pragma tg_funcdef(fmod, __fmod_float16, float16, float16, float16)
#pragma tg_funcdef(fmod, __fmod_double, double, double, double)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(fmod, __fmod_double2, double2, double2, double2)
#pragma tg_funcdef(fmod, __fmod_double3, double3, double3, double3)
#pragma tg_funcdef(fmod, __fmod_double4, double4, double4, double4)
#pragma tg_funcdef(fmod, __fmod_double8, double8, double8, double8)
#pragma tg_funcdef(fmod, __fmod_double16, double16, double16, double16)
 #endif
#undef fmod
#define fmod(__a, __b) __tg_builtin("fmod", __a, __b)

#pragma tg_funcdef(fract, __fract_float_global, float, float, __global float *)
#pragma tg_funcdef(fract, __fract_float2_global, float2, float2, __global float2 *)
#pragma tg_funcdef(fract, __fract_float3_global, float3, float3, __global float3 *)
#pragma tg_funcdef(fract, __fract_float4_global, float4, float4, __global float4 *)
#pragma tg_funcdef(fract, __fract_float8_global, float8, float8, __global float8 *)
#pragma tg_funcdef(fract, __fract_float16_global, float16, float16, __global float16 *)
#pragma tg_funcdef(fract, __fract_float, float, float, __local float *)
#pragma tg_funcdef(fract, __fract_float2, float2, float2, __local float2 *)
#pragma tg_funcdef(fract, __fract_float3, float3, float3, __local float3 *)
#pragma tg_funcdef(fract, __fract_float4, float4, float4, __local float4 *)
#pragma tg_funcdef(fract, __fract_float8, float8, float8, __local float8 *)
#pragma tg_funcdef(fract, __fract_float16, float16, float16, __local float16 *)
#pragma tg_funcdef(fract, __fract_float, float, float, __private float *)
#pragma tg_funcdef(fract, __fract_float2, float2, float2, __private float2 *)
#pragma tg_funcdef(fract, __fract_float3, float3, float3, __private float3 *)
#pragma tg_funcdef(fract, __fract_float4, float4, float4, __private float4 *)
#pragma tg_funcdef(fract, __fract_float8, float8, float8, __private float8 *)
#pragma tg_funcdef(fract, __fract_float16, float16, float16, __private float16 *)
#pragma tg_funcdef(fract, __fract_double_global, double, double, __global double *)
#pragma tg_funcdef(fract, __fract_double, double, double, __local double *)
#pragma tg_funcdef(fract, __fract_double, double, double, __private double *)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(fract, __fract_double2_global, double2, double2, __global double2 *)
#pragma tg_funcdef(fract, __fract_double3_global, double3, double3, __global double3 *)
#pragma tg_funcdef(fract, __fract_double4_global, double4, double4, __global double4 *)
#pragma tg_funcdef(fract, __fract_double8_global, double8, double8, __global double8 *)
#pragma tg_funcdef(fract, __fract_double16_global, double16, double16, __global double16 *)
#pragma tg_funcdef(fract, __fract_double2, double2, double2, __local double2 *)
#pragma tg_funcdef(fract, __fract_double3, double3, double3, __local double3 *)
#pragma tg_funcdef(fract, __fract_double4, double4, double4, __local double4 *)
#pragma tg_funcdef(fract, __fract_double8, double8, double8, __local double8 *)
#pragma tg_funcdef(fract, __fract_double16, double16, double16, __local double16 *)
#pragma tg_funcdef(fract, __fract_double2, double2, double2, __private double2 *)
#pragma tg_funcdef(fract, __fract_double3, double3, double3, __private double3 *)
#pragma tg_funcdef(fract, __fract_double4, double4, double4, __private double4 *)
#pragma tg_funcdef(fract, __fract_double8, double8, double8, __private double8 *)
#pragma tg_funcdef(fract, __fract_double16, double16, double16, __private double16 *)
 #endif
#undef fract
#define fract(__a, __b) __tg_builtin("fract", __a, __b)

#pragma tg_funcdef(frexp, __frexp_float_global, float, float, __global int *)
#pragma tg_funcdef(frexp, __frexp_float2_global, float2, float2, __global int2 *)
#pragma tg_funcdef(frexp, __frexp_float3_global, float3, float3, __global int3 *)
#pragma tg_funcdef(frexp, __frexp_float4_global, float4, float4, __global int4 *)
#pragma tg_funcdef(frexp, __frexp_float8_global, float8, float8, __global int8 *)
#pragma tg_funcdef(frexp, __frexp_float16_global, float16, float16, __global int16 *)
#pragma tg_funcdef(frexp, __frexp_float, float, float, __local int *)
#pragma tg_funcdef(frexp, __frexp_float2, float2, float2, __local int2 *)
#pragma tg_funcdef(frexp, __frexp_float3, float3, float3, __local int3 *)
#pragma tg_funcdef(frexp, __frexp_float4, float4, float4, __local int4 *)
#pragma tg_funcdef(frexp, __frexp_float8, float8, float8, __local int8 *)
#pragma tg_funcdef(frexp, __frexp_float16, float16, float16, __local int16 *)
#pragma tg_funcdef(frexp, __frexp_float, float, float, __private int *)
#pragma tg_funcdef(frexp, __frexp_float2, float2, float2, __private int2 *)
#pragma tg_funcdef(frexp, __frexp_float3, float3, float3, __private int3 *)
#pragma tg_funcdef(frexp, __frexp_float4, float4, float4, __private int4 *)
#pragma tg_funcdef(frexp, __frexp_float8, float8, float8, __private int8 *)
#pragma tg_funcdef(frexp, __frexp_float16, float16, float16, __private int16 *)
#pragma tg_funcdef(frexp, __frexp_double_global, double, double, __global int *)
#pragma tg_funcdef(frexp, __frexp_double, double, double, __local int *)
#pragma tg_funcdef(frexp, __frexp_double, double, double, __private int *)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(frexp, __frexp_double2_global, double2, double2, __global int2 *)
#pragma tg_funcdef(frexp, __frexp_double3_global, double3, double3, __global int3 *)
#pragma tg_funcdef(frexp, __frexp_double4_global, double4, double4, __global int4 *)
#pragma tg_funcdef(frexp, __frexp_double8_global, double8, double8, __global int8 *)
#pragma tg_funcdef(frexp, __frexp_double16_global, double16, double16, __global int16 *)
#pragma tg_funcdef(frexp, __frexp_double2, double2, double2, __local int2 *)
#pragma tg_funcdef(frexp, __frexp_double3, double3, double3, __local int3 *)
#pragma tg_funcdef(frexp, __frexp_double4, double4, double4, __local int4 *)
#pragma tg_funcdef(frexp, __frexp_double8, double8, double8, __local int8 *)
#pragma tg_funcdef(frexp, __frexp_double16, double16, double16, __local int16 *)
#pragma tg_funcdef(frexp, __frexp_double2, double2, double2, __private int2 *)
#pragma tg_funcdef(frexp, __frexp_double3, double3, double3, __private int3 *)
#pragma tg_funcdef(frexp, __frexp_double4, double4, double4, __private int4 *)
#pragma tg_funcdef(frexp, __frexp_double8, double8, double8, __private int8 *)
#pragma tg_funcdef(frexp, __frexp_double16, double16, double16, __private int16 *)
 #endif
#undef frexp
#define frexp(__a, __b) __tg_builtin("frexp", __a, __b)

#pragma tg_funcdef(hypot, __hypot_float, float, float, float)
#pragma tg_funcdef(hypot, __hypot_float2, float2, float2, float2)
#pragma tg_funcdef(hypot, __hypot_float3, float3, float3, float3)
#pragma tg_funcdef(hypot, __hypot_float4, float4, float4, float4)
#pragma tg_funcdef(hypot, __hypot_float8, float8, float8, float8)
#pragma tg_funcdef(hypot, __hypot_float16, float16, float16, float16)
#pragma tg_funcdef(hypot, __hypot_double, double, double, double)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(hypot, __hypot_double2, double2, double2, double2)
#pragma tg_funcdef(hypot, __hypot_double3, double3, double3, double3)
#pragma tg_funcdef(hypot, __hypot_double4, double4, double4, double4)
#pragma tg_funcdef(hypot, __hypot_double8, double8, double8, double8)
#pragma tg_funcdef(hypot, __hypot_double16, double16, double16, double16)
 #endif
#undef hypot
#define hypot(__a, __b) __tg_builtin("hypot", __a, __b)

#pragma tg_funcdef(ilogb, __ilogb_float, int, float)
#pragma tg_funcdef(ilogb, __ilogb_float2, int2, float2)
#pragma tg_funcdef(ilogb, __ilogb_float3, int3, float3)
#pragma tg_funcdef(ilogb, __ilogb_float4, int4, float4)
#pragma tg_funcdef(ilogb, __ilogb_float8, int8, float8)
#pragma tg_funcdef(ilogb, __ilogb_float16, int16, float16)
#pragma tg_funcdef(ilogb, __ilogb_double, int, double)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(ilogb, __ilogb_double2, int2, double2)
#pragma tg_funcdef(ilogb, __ilogb_double3, int3, double3)
#pragma tg_funcdef(ilogb, __ilogb_double4, int4, double4)
#pragma tg_funcdef(ilogb, __ilogb_double8, int8, double8)
#pragma tg_funcdef(ilogb, __ilogb_double16, int16, double16)
 #endif
#undef ilogb
#define ilogb(__a) __tg_builtin("ilogb", __a)

#pragma tg_funcdef(ldexp, __ldexp_float, float, float, int)
#pragma tg_funcdef(ldexp, __ldexp_float2, float2, float2, int2)
#pragma tg_funcdef(ldexp, __ldexp_float3, float3, float3, int3)
#pragma tg_funcdef(ldexp, __ldexp_float4, float4, float4, int4)
#pragma tg_funcdef(ldexp, __ldexp_float8, float8, float8, int8)
#pragma tg_funcdef(ldexp, __ldexp_float16, float16, float16, int16)

#pragma tg_funcdef(ldexp, __ldexp_int_float2, float2, float2, int)
#pragma tg_funcdef(ldexp, __ldexp_int_float3, float3, float3, int)
#pragma tg_funcdef(ldexp, __ldexp_int_float4, float4, float4, int)
#pragma tg_funcdef(ldexp, __ldexp_int_float8, float8, float8, int)
#pragma tg_funcdef(ldexp, __ldexp_int_float16, float16, float16, int)

#pragma tg_funcdef(ldexp, __ldexp_double, double, double, int)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(ldexp, __ldexp_double2, double2, double2, int2)
#pragma tg_funcdef(ldexp, __ldexp_double3, double3, double3, int3)
#pragma tg_funcdef(ldexp, __ldexp_double4, double4, double4, int4)
#pragma tg_funcdef(ldexp, __ldexp_double8, double8, double8, int8)
#pragma tg_funcdef(ldexp, __ldexp_double16, double16, double16, int16)

#pragma tg_funcdef(ldexp, __ldexp_int_double2, double2, double2, int)
#pragma tg_funcdef(ldexp, __ldexp_int_double3, double3, double3, int)
#pragma tg_funcdef(ldexp, __ldexp_int_double4, double4, double4, int)
#pragma tg_funcdef(ldexp, __ldexp_int_double8, double8, double8, int)
#pragma tg_funcdef(ldexp, __ldexp_int_double16, double16, double16, int)
 #endif
#undef ldexp
#define ldexp(__a, __b) __tg_builtin("ldexp", __a, __b)

#pragma tg_funcdef(lgamma, __lgamma_float, float, float)
#pragma tg_funcdef(lgamma, __lgamma_float2, float2, float2)
#pragma tg_funcdef(lgamma, __lgamma_float3, float3, float3)
#pragma tg_funcdef(lgamma, __lgamma_float4, float4, float4)
#pragma tg_funcdef(lgamma, __lgamma_float8, float8, float8)
#pragma tg_funcdef(lgamma, __lgamma_float16, float16, float16)
#pragma tg_funcdef(lgamma, __lgamma_double, double, double)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(lgamma, __lgamma_double2, double2, double2)
#pragma tg_funcdef(lgamma, __lgamma_double3, double3, double3)
#pragma tg_funcdef(lgamma, __lgamma_double4, double4, double4)
#pragma tg_funcdef(lgamma, __lgamma_double8, double8, double8)
#pragma tg_funcdef(lgamma, __lgamma_double16, double16, double16)
 #endif
#undef lgamma
#define lgamma(__a) __tg_builtin("lgamma", __a)

#pragma tg_funcdef(lgamma_r, __lgamma_r_float_global, float, float, __global int *)
#pragma tg_funcdef(lgamma_r, __lgamma_r_float2_global, float2, float2, __global int2 *)
#pragma tg_funcdef(lgamma_r, __lgamma_r_float3_global, float3, float3, __global int3 *)
#pragma tg_funcdef(lgamma_r, __lgamma_r_float4_global, float4, float4, __global int4 *)
#pragma tg_funcdef(lgamma_r, __lgamma_r_float8_global, float8, float8, __global int8 *)
#pragma tg_funcdef(lgamma_r, __lgamma_r_float16_global, float16, float16, __global int16 *)
#pragma tg_funcdef(lgamma_r, __lgamma_r_float, float, float, __local int *)
#pragma tg_funcdef(lgamma_r, __lgamma_r_float2, float2, float2, __local int2 *)
#pragma tg_funcdef(lgamma_r, __lgamma_r_float3, float3, float3, __local int3 *)
#pragma tg_funcdef(lgamma_r, __lgamma_r_float4, float4, float4, __local int4 *)
#pragma tg_funcdef(lgamma_r, __lgamma_r_float8, float8, float8, __local int8 *)
#pragma tg_funcdef(lgamma_r, __lgamma_r_float16, float16, float16, __local int16 *)
#pragma tg_funcdef(lgamma_r, __lgamma_r_float, float, float, __private int *)
#pragma tg_funcdef(lgamma_r, __lgamma_r_float2, float2, float2, __private int2 *)
#pragma tg_funcdef(lgamma_r, __lgamma_r_float3, float3, float3, __private int3 *)
#pragma tg_funcdef(lgamma_r, __lgamma_r_float4, float4, float4, __private int4 *)
#pragma tg_funcdef(lgamma_r, __lgamma_r_float8, float8, float8, __private int8 *)
#pragma tg_funcdef(lgamma_r, __lgamma_r_float16, float16, float16, __private int16 *)
#pragma tg_funcdef(lgamma_r, __lgamma_r_double_global, double, double, __global int *)
#pragma tg_funcdef(lgamma_r, __lgamma_r_double, double, double, __local int *)
#pragma tg_funcdef(lgamma_r, __lgamma_r_double, double, double, __private int *)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(lgamma_r, __lgamma_r_double2_global, double2, double2, __global int2 *)
#pragma tg_funcdef(lgamma_r, __lgamma_r_double3_global, double3, double3, __global int3 *)
#pragma tg_funcdef(lgamma_r, __lgamma_r_double4_global, double4, double4, __global int4 *)
#pragma tg_funcdef(lgamma_r, __lgamma_r_double8_global, double8, double8, __global int8 *)
#pragma tg_funcdef(lgamma_r, __lgamma_r_double16_global, double16, double16, __global int16 *)
#pragma tg_funcdef(lgamma_r, __lgamma_r_double2, double2, double2, __local int2 *)
#pragma tg_funcdef(lgamma_r, __lgamma_r_double3, double3, double3, __local int3 *)
#pragma tg_funcdef(lgamma_r, __lgamma_r_double4, double4, double4, __local int4 *)
#pragma tg_funcdef(lgamma_r, __lgamma_r_double8, double8, double8, __local int8 *)
#pragma tg_funcdef(lgamma_r, __lgamma_r_double16, double16, double16, __local int16 *)
#pragma tg_funcdef(lgamma_r, __lgamma_r_double2, double2, double2, __private int2 *)
#pragma tg_funcdef(lgamma_r, __lgamma_r_double3, double3, double3, __private int3 *)
#pragma tg_funcdef(lgamma_r, __lgamma_r_double4, double4, double4, __private int4 *)
#pragma tg_funcdef(lgamma_r, __lgamma_r_double8, double8, double8, __private int8 *)
#pragma tg_funcdef(lgamma_r, __lgamma_r_double16, double16, double16, __private int16 *)
#endif
#undef lgamma_r
#define lgamma_r(__a, __b) __tg_builtin("lgamma_r", __a, __b)

#pragma tg_funcdef(log, __log_float, float, float)
#pragma tg_funcdef(log, __log_float2, float2, float2)
#pragma tg_funcdef(log, __log_float3, float3, float3)
#pragma tg_funcdef(log, __log_float4, float4, float4)
#pragma tg_funcdef(log, __log_float8, float8, float8)
#pragma tg_funcdef(log, __log_float16, float16, float16)
#pragma tg_funcdef(log, __log_double, double, double)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(log, __log_double2, double2, double2)
#pragma tg_funcdef(log, __log_double3, double3, double3)
#pragma tg_funcdef(log, __log_double4, double4, double4)
#pragma tg_funcdef(log, __log_double8, double8, double8)
#pragma tg_funcdef(log, __log_double16, double16, double16)
 #endif
#undef log
#define log(__a) __tg_builtin("log", __a)

#pragma tg_funcdef(log2, __log2_float, float, float)
#pragma tg_funcdef(log2, __log2_float2, float2, float2)
#pragma tg_funcdef(log2, __log2_float3, float3, float3)
#pragma tg_funcdef(log2, __log2_float4, float4, float4)
#pragma tg_funcdef(log2, __log2_float8, float8, float8)
#pragma tg_funcdef(log2, __log2_float16, float16, float16)
#pragma tg_funcdef(log2, __log2_double, double, double)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(log2, __log2_double2, double2, double2)
#pragma tg_funcdef(log2, __log2_double3, double3, double3)
#pragma tg_funcdef(log2, __log2_double4, double4, double4)
#pragma tg_funcdef(log2, __log2_double8, double8, double8)
#pragma tg_funcdef(log2, __log2_double16, double16, double16)
 #endif
#undef log2
#define log2(__a) __tg_builtin("log2", __a)

#pragma tg_funcdef(log10, __log10_float, float, float)
#pragma tg_funcdef(log10, __log10_float2, float2, float2)
#pragma tg_funcdef(log10, __log10_float3, float3, float3)
#pragma tg_funcdef(log10, __log10_float4, float4, float4)
#pragma tg_funcdef(log10, __log10_float8, float8, float8)
#pragma tg_funcdef(log10, __log10_float16, float16, float16)
#pragma tg_funcdef(log10, __log10_double, double, double)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(log10, __log10_double2, double2, double2)
#pragma tg_funcdef(log10, __log10_double3, double3, double3)
#pragma tg_funcdef(log10, __log10_double4, double4, double4)
#pragma tg_funcdef(log10, __log10_double8, double8, double8)
#pragma tg_funcdef(log10, __log10_double16, double16, double16)
 #endif
#undef log10
#define log10(__a) __tg_builtin("log10", __a)

#pragma tg_funcdef(log1p, __log1p_float, float, float)
#pragma tg_funcdef(log1p, __log1p_float2, float2, float2)
#pragma tg_funcdef(log1p, __log1p_float3, float3, float3)
#pragma tg_funcdef(log1p, __log1p_float4, float4, float4)
#pragma tg_funcdef(log1p, __log1p_float8, float8, float8)
#pragma tg_funcdef(log1p, __log1p_float16, float16, float16)
#pragma tg_funcdef(log1p, __log1p_double, double, double)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(log1p, __log1p_double2, double2, double2)
#pragma tg_funcdef(log1p, __log1p_double3, double3, double3)
#pragma tg_funcdef(log1p, __log1p_double4, double4, double4)
#pragma tg_funcdef(log1p, __log1p_double8, double8, double8)
#pragma tg_funcdef(log1p, __log1p_double16, double16, double16)
 #endif
#undef log1p
#define log1p(__a) __tg_builtin("log1p", __a)

#pragma tg_funcdef(logb, __logb_float, float, float)
#pragma tg_funcdef(logb, __logb_float2, float2, float2)
#pragma tg_funcdef(logb, __logb_float3, float3, float3)
#pragma tg_funcdef(logb, __logb_float4, float4, float4)
#pragma tg_funcdef(logb, __logb_float8, float8, float8)
#pragma tg_funcdef(logb, __logb_float16, float16, float16)
#pragma tg_funcdef(logb, __logb_double, double, double)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(logb, __logb_double2, double2, double2)
#pragma tg_funcdef(logb, __logb_double3, double3, double3)
#pragma tg_funcdef(logb, __logb_double4, double4, double4)
#pragma tg_funcdef(logb, __logb_double8, double8, double8)
#pragma tg_funcdef(logb, __logb_double16, double16, double16)
 #endif
#undef logb
#define logb(__a) __tg_builtin("logb", __a)

#pragma tg_funcdef(mad, fma_tg, float, float, float, float)
#pragma tg_funcdef(mad, fma_tg, float2, float2, float2, float2)
#pragma tg_funcdef(mad, fma_tg, float3, float3, float3, float3)
#pragma tg_funcdef(mad, fma_tg, float4, float4, float4, float4)
#pragma tg_funcdef(mad, fma_tg, float8, float8, float8, float8)
#pragma tg_funcdef(mad, fma_tg, float16, float16, float16, float16)
#pragma tg_funcdef(mad, fma_tg, double, double, double, double)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(mad, fma_tg, double2, double2, double2, double2)
#pragma tg_funcdef(mad, fma_tg, double3, double3, double3, double3)
#pragma tg_funcdef(mad, fma_tg, double4, double4, double4, double4)
#pragma tg_funcdef(mad, fma_tg, double8, double8, double8, double8)
#pragma tg_funcdef(mad, fma_tg, double16, double16, double16, double16)
 #endif
#undef mad
#define mad(__a,__b,__c) __tg_builtin_gentype("mad",__a,__b,__c)

#pragma tg_funcdef(modf, __modf_float_global, float, float, __global float*)
#pragma tg_funcdef(modf, __modf_float2_global, float2, float2, __global float2*)
#pragma tg_funcdef(modf, __modf_float3_global, float3, float3, __global float3*)
#pragma tg_funcdef(modf, __modf_float4_global, float4, float4, __global float4*)
#pragma tg_funcdef(modf, __modf_float8_global, float8, float8, __global float8*)
#pragma tg_funcdef(modf, __modf_float16_global, float16, float16, __global float16*)
#pragma tg_funcdef(modf, __modf_float, float, float, __local float*)
#pragma tg_funcdef(modf, __modf_float2, float2, float2, __local float2*)
#pragma tg_funcdef(modf, __modf_float3, float3, float3, __local float3*)
#pragma tg_funcdef(modf, __modf_float4, float4, float4, __local float4*)
#pragma tg_funcdef(modf, __modf_float8, float8, float8, __local float8*)
#pragma tg_funcdef(modf, __modf_float16, float16, float16, __local float16*)
#pragma tg_funcdef(modf, __modf_float, float, float, __private float*)
#pragma tg_funcdef(modf, __modf_float2, float2, float2, __private float2*)
#pragma tg_funcdef(modf, __modf_float3, float3, float3, __private float3*)
#pragma tg_funcdef(modf, __modf_float4, float4, float4, __private float4*)
#pragma tg_funcdef(modf, __modf_float8, float8, float8, __private float8*)
#pragma tg_funcdef(modf, __modf_float16, float16, float16, __private float16*)
#pragma tg_funcdef(modf, __modf_double_global, double, double, __global double*)
#pragma tg_funcdef(modf, __modf_double, double, double, __local double*)
#pragma tg_funcdef(modf, __modf_double, double, double, __private double*)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(modf, __modf_double2_global, double2, double2, __global double2*)
#pragma tg_funcdef(modf, __modf_double3_global, double3, double3, __global double3*)
#pragma tg_funcdef(modf, __modf_double4_global, double4, double4, __global double4*)
#pragma tg_funcdef(modf, __modf_double8_global, double8, double8, __global double8*)
#pragma tg_funcdef(modf, __modf_double16_global, double16, double16, __global double16*)
#pragma tg_funcdef(modf, __modf_double2, double2, double2, __local double2*)
#pragma tg_funcdef(modf, __modf_double3, double3, double3, __local double3*)
#pragma tg_funcdef(modf, __modf_double4, double4, double4, __local double4*)
#pragma tg_funcdef(modf, __modf_double8, double8, double8, __local double8*)
#pragma tg_funcdef(modf, __modf_double16, double16, double16, __local double16*)
#pragma tg_funcdef(modf, __modf_double2, double2, double2, __private double2*)
#pragma tg_funcdef(modf, __modf_double3, double3, double3, __private double3*)
#pragma tg_funcdef(modf, __modf_double4, double4, double4, __private double4*)
#pragma tg_funcdef(modf, __modf_double8, double8, double8, __private double8*)
#pragma tg_funcdef(modf, __modf_double16, double16, double16, __private double16*)
 #endif
#undef modf
#define modf(__a, __b) __tg_builtin("modf", __a, __b)

#pragma tg_funcdef(nan, __nan_float, float, unsigned int)
#pragma tg_funcdef(nan, __nan_float2, float2, uint2)
#pragma tg_funcdef(nan, __nan_float3, float3, uint3)
#pragma tg_funcdef(nan, __nan_float4, float4, uint4)
#pragma tg_funcdef(nan, __nan_float8, float8, uint8)
#pragma tg_funcdef(nan, __nan_float16, float16, uint16)
#pragma tg_funcdef(nan, __nan_double, double, ulong)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(nan, __nan_double2, double2, ulong2)
#pragma tg_funcdef(nan, __nan_double3, double3, ulong3)
#pragma tg_funcdef(nan, __nan_double4, double4, ulong4)
#pragma tg_funcdef(nan, __nan_double8, double8, ulong8)
#pragma tg_funcdef(nan, __nan_double16, double16, ulong16)
 #endif
#undef nan
#define nan(__a) __tg_builtin("nan", __a)

#pragma tg_funcdef(nextafter, __nextafter_float, float, float, float)
#pragma tg_funcdef(nextafter, __nextafter_float2, float2, float2, float2)
#pragma tg_funcdef(nextafter, __nextafter_float3, float3, float3, float3)
#pragma tg_funcdef(nextafter, __nextafter_float4, float4, float4, float4)
#pragma tg_funcdef(nextafter, __nextafter_float8, float8, float8, float8)
#pragma tg_funcdef(nextafter, __nextafter_float16, float16, float16, float16)
#pragma tg_funcdef(nextafter, __nextafter_double, double, double, double)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(nextafter, __nextafter_double2, double2, double2, double2)
#pragma tg_funcdef(nextafter, __nextafter_double3, double3, double3, double3)
#pragma tg_funcdef(nextafter, __nextafter_double4, double4, double4, double4)
#pragma tg_funcdef(nextafter, __nextafter_double8, double8, double8, double8)
#pragma tg_funcdef(nextafter, __nextafter_double16, double16, double16, double16)
 #endif
#undef nextafter
#define nextafter(__a, __b) __tg_builtin("nextafter", __a, __b)

#pragma tg_funcdef(pow, __pow_float, float, float, float)
#pragma tg_funcdef(pow, __pow_float2, float2, float2, float2)
#pragma tg_funcdef(pow, __pow_float3, float3, float3, float3)
#pragma tg_funcdef(pow, __pow_float4, float4, float4, float4)
#pragma tg_funcdef(pow, __pow_float8, float8, float8, float8)
#pragma tg_funcdef(pow, __pow_float16, float16, float16, float16)
#pragma tg_funcdef(pow, __pow_double, double, double, double)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(pow, __pow_double2, double2, double2, double2)
#pragma tg_funcdef(pow, __pow_double3, double3, double3, double3)
#pragma tg_funcdef(pow, __pow_double4, double4, double4, double4)
#pragma tg_funcdef(pow, __pow_double8, double8, double8, double8)
#pragma tg_funcdef(pow, __pow_double16, double16, double16, double16)
 #endif
#undef pow
#define pow(__a, __b) __tg_builtin("pow", __a, __b)

#pragma tg_funcdef(pown, __pown_float, float, float, int)
#pragma tg_funcdef(pown, __pown_float2, float2, float2, int2)
#pragma tg_funcdef(pown, __pown_float3, float3, float3, int3)
#pragma tg_funcdef(pown, __pown_float4, float4, float4, int4)
#pragma tg_funcdef(pown, __pown_float8, float8, float8, int8)
#pragma tg_funcdef(pown, __pown_float16, float16, float16, int16)
#pragma tg_funcdef(pown, __pown_double, double, double, int)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(pown, __pown_double2, double2, double2, int2)
#pragma tg_funcdef(pown, __pown_double3, double3, double3, int3)
#pragma tg_funcdef(pown, __pown_double4, double4, double4, int4)
#pragma tg_funcdef(pown, __pown_double8, double8, double8, int8)
#pragma tg_funcdef(pown, __pown_double16, double16, double16, int16)
 #endif
#undef pown
#define pown(__a, __b) __tg_builtin("pown", __a, __b)

#pragma tg_funcdef(powr, __powr_float, float, float, float)
#pragma tg_funcdef(powr, __powr_float2, float2, float2, float2)
#pragma tg_funcdef(powr, __powr_float3, float3, float3, float3)
#pragma tg_funcdef(powr, __powr_float4, float4, float4, float4)
#pragma tg_funcdef(powr, __powr_float8, float8, float8, float8)
#pragma tg_funcdef(powr, __powr_float16, float16, float16, float16)
#pragma tg_funcdef(powr, __powr_double, double, double, double)
  #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(powr, __powr_double2, double2, double2, double2)
#pragma tg_funcdef(powr, __powr_double3, double3, double3, double3)
#pragma tg_funcdef(powr, __powr_double4, double4, double4, double4)
#pragma tg_funcdef(powr, __powr_double8, double8, double8, double8)
#pragma tg_funcdef(powr, __powr_double16, double16, double16, double16)
 #endif
#undef powr
#define powr(__a, __b) __tg_builtin("powr", __a, __b)

#pragma tg_funcdef(remainder, __remainder_float, float, float, float)
#pragma tg_funcdef(remainder, __remainder_float2, float2, float2, float2)
#pragma tg_funcdef(remainder, __remainder_float3, float3, float3, float3)
#pragma tg_funcdef(remainder, __remainder_float4, float4, float4, float4)
#pragma tg_funcdef(remainder, __remainder_float8, float8, float8, float8)
#pragma tg_funcdef(remainder, __remainder_float16, float16, float16, float16)
#pragma tg_funcdef(remainder, __remainder_double, double, double, double)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(remainder, __remainder_double2, double2, double2, double2)
#pragma tg_funcdef(remainder, __remainder_double3, double3, double3, double3)
#pragma tg_funcdef(remainder, __remainder_double4, double4, double4, double4)
#pragma tg_funcdef(remainder, __remainder_double8, double8, double8, double8)
#pragma tg_funcdef(remainder, __remainder_double16, double16, double16, double16)
 #endif
#undef remainder
#define remainder(__a, __b) __tg_builtin("remainder", __a, __b)

#pragma tg_funcdef(remquo, __remquo_float_global, float, float, float, __global int *)
#pragma tg_funcdef(remquo, __remquo_float2_global, float2, float2, float2, __global int2 *)
#pragma tg_funcdef(remquo, __remquo_float3_global, float3, float3, float3, __global int3 *)
#pragma tg_funcdef(remquo, __remquo_float4_global, float4, float4, float4, __global int4 *)
#pragma tg_funcdef(remquo, __remquo_float8_global, float8, float8, float8, __global int8 *)
#pragma tg_funcdef(remquo, __remquo_float16_global, float16, float16, float16, __global int16 *)
#pragma tg_funcdef(remquo, __remquo_float, float, float, float, __local int *)
#pragma tg_funcdef(remquo, __remquo_float2, float2, float2, float2, __local int2 *)
#pragma tg_funcdef(remquo, __remquo_float3, float3, float3, float3, __local int3 *)
#pragma tg_funcdef(remquo, __remquo_float4, float4, float4, float4, __local int4 *)
#pragma tg_funcdef(remquo, __remquo_float8, float8, float8, float8, __local int8 *)
#pragma tg_funcdef(remquo, __remquo_float16, float16, float16, float16, __local int16 *)
#pragma tg_funcdef(remquo, __remquo_float, float, float, float, __private int *)
#pragma tg_funcdef(remquo, __remquo_float2, float2, float2, float2, __private int2 *)
#pragma tg_funcdef(remquo, __remquo_float3, float3, float3, float3, __private int3 *)
#pragma tg_funcdef(remquo, __remquo_float4, float4, float4, float4, __private int4 *)
#pragma tg_funcdef(remquo, __remquo_float8, float8, float8, float8, __private int8 *)
#pragma tg_funcdef(remquo, __remquo_float16, float16, float16, float16, __private int16 *)
#pragma tg_funcdef(remquo, __remquo_double_global, double, double, double, __global int *)
#pragma tg_funcdef(remquo, __remquo_double, double, double, double, __local int *)
#pragma tg_funcdef(remquo, __remquo_double, double, double, double, __private int *)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(remquo, __remquo_double2_global, double2, double2, double2, __global int2 *)
#pragma tg_funcdef(remquo, __remquo_double3_global, double3, double3, double3, __global int3 *)
#pragma tg_funcdef(remquo, __remquo_double4_global, double4, double4, double4, __global int4 *)
#pragma tg_funcdef(remquo, __remquo_double8_global, double8, double8, double8, __global int8 *)
#pragma tg_funcdef(remquo, __remquo_double16_global, double16, double16, double16, __global int16 *)
#pragma tg_funcdef(remquo, __remquo_double2, double2, double2, double2, __local int2 *)
#pragma tg_funcdef(remquo, __remquo_double3, double3, double3, double3, __local int3 *)
#pragma tg_funcdef(remquo, __remquo_double4, double4, double4, double4, __local int4 *)
#pragma tg_funcdef(remquo, __remquo_double8, double8, double8, double8, __local int8 *)
#pragma tg_funcdef(remquo, __remquo_double16, double16, double16, double16, __local int16 *)
#pragma tg_funcdef(remquo, __remquo_double2, double2, double2, double2, __private int2 *)
#pragma tg_funcdef(remquo, __remquo_double3, double3, double3, double3, __private int3 *)
#pragma tg_funcdef(remquo, __remquo_double4, double4, double4, double4, __private int4 *)
#pragma tg_funcdef(remquo, __remquo_double8, double8, double8, double8, __private int8 *)
#pragma tg_funcdef(remquo, __remquo_double16, double16, double16, double16, __private int16 *)
 #endif
#undef remquo
#define remquo(__a, __b, __c) __tg_builtin("remquo", __a, __b, __c)

#pragma tg_funcdef(rint, __rint_float, float, float)
#pragma tg_funcdef(rint, __rint_float2, float2, float2)
#pragma tg_funcdef(rint, __rint_float3, float3, float3)
#pragma tg_funcdef(rint, __rint_float4, float4, float4)
#pragma tg_funcdef(rint, __rint_float8, float8, float8)
#pragma tg_funcdef(rint, __rint_float16, float16, float16)
#pragma tg_funcdef(rint, __rint_double, double, double)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(rint, __rint_double2, double2, double2)
#pragma tg_funcdef(rint, __rint_double3, double3, double3)
#pragma tg_funcdef(rint, __rint_double4, double4, double4)
#pragma tg_funcdef(rint, __rint_double8, double8, double8)
#pragma tg_funcdef(rint, __rint_double16, double16, double16)
 #endif
#undef rint
#define rint(__a) __tg_builtin("rint", __a)

#pragma tg_funcdef(rootn, __rootn_float, float, float, int)
#pragma tg_funcdef(rootn, __rootn_float2, float2, float2, int2)
#pragma tg_funcdef(rootn, __rootn_float3, float3, float3, int3)
#pragma tg_funcdef(rootn, __rootn_float4, float4, float4, int4)
#pragma tg_funcdef(rootn, __rootn_float8, float8, float8, int8)
#pragma tg_funcdef(rootn, __rootn_float16, float16, float16, int16)
#pragma tg_funcdef(rootn, __rootn_double, double, double, int)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(rootn, __rootn_double2, double2, double2, int2)
#pragma tg_funcdef(rootn, __rootn_double3, double3, double3, int3)
#pragma tg_funcdef(rootn, __rootn_double4, double4, double4, int4)
#pragma tg_funcdef(rootn, __rootn_double8, double8, double8, int8)
#pragma tg_funcdef(rootn, __rootn_double16, double16, double16, int16)
 #endif
#undef rootn
#define rootn(__a, __b) __tg_builtin("rootn", __a, __b)

#pragma tg_funcdef(round, __round_float, float, float)
#pragma tg_funcdef(round, __round_float2, float2, float2)
#pragma tg_funcdef(round, __round_float3, float3, float3)
#pragma tg_funcdef(round, __round_float4, float4, float4)
#pragma tg_funcdef(round, __round_float8, float8, float8)
#pragma tg_funcdef(round, __round_float16, float16, float16)
#pragma tg_funcdef(round, __round_double, double, double)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(round, __round_double2, double2, double2)
#pragma tg_funcdef(round, __round_double3, double3, double3)
#pragma tg_funcdef(round, __round_double4, double4, double4)
#pragma tg_funcdef(round, __round_double8, double8, double8)
#pragma tg_funcdef(round, __round_double16, double16, double16)
 #endif
#undef round
#define round(__a) __tg_builtin("round", __a)

#pragma tg_funcdef(rsqrt, __rsqrt_float, float, float)
#pragma tg_funcdef(rsqrt, __rsqrt_float2, float2, float2)
#pragma tg_funcdef(rsqrt, __rsqrt_float3, float3, float3)
#pragma tg_funcdef(rsqrt, __rsqrt_float4, float4, float4)
#pragma tg_funcdef(rsqrt, __rsqrt_float8, float8, float8)
#pragma tg_funcdef(rsqrt, __rsqrt_float16, float16, float16)
#pragma tg_funcdef(rsqrt, __rsqrt_double, double, double)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(rsqrt, __rsqrt_double2, double2, double2)
#pragma tg_funcdef(rsqrt, __rsqrt_double3, double3, double3)
#pragma tg_funcdef(rsqrt, __rsqrt_double4, double4, double4)
#pragma tg_funcdef(rsqrt, __rsqrt_double8, double8, double8)
#pragma tg_funcdef(rsqrt, __rsqrt_double16, double16, double16)
 #endif
#undef rsqrt
#define rsqrt(__a) __tg_builtin("rsqrt", __a)

#pragma tg_funcdef(sin, __sin_float, float, float)
#pragma tg_funcdef(sin, __sin_float2, float2, float2)
#pragma tg_funcdef(sin, __sin_float3, float3, float3)
#pragma tg_funcdef(sin, __sin_float4, float4, float4)
#pragma tg_funcdef(sin, __sin_float8, float8, float8)
#pragma tg_funcdef(sin, __sin_float16, float16, float16)
#pragma tg_funcdef(sin, __sin_double, double, double)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(sin, __sin_double2, double2, double2)
#pragma tg_funcdef(sin, __sin_double3, double3, double3)
#pragma tg_funcdef(sin, __sin_double4, double4, double4)
#pragma tg_funcdef(sin, __sin_double8, double8, double8)
#pragma tg_funcdef(sin, __sin_double16, double16, double16)
 #endif
#undef sin
#define sin(__a) __tg_builtin("sin", __a)

#pragma tg_funcdef(sincos, __sincos_float, float, float, __local float *)
#pragma tg_funcdef(sincos, __sincos_float2, float2, float2, __local float2 *)
#pragma tg_funcdef(sincos, __sincos_float3, float3, float3, __local float3 *)
#pragma tg_funcdef(sincos, __sincos_float4, float4, float4, __local float4 *)
#pragma tg_funcdef(sincos, __sincos_float8, float8, float8, __local float8 *)
#pragma tg_funcdef(sincos, __sincos_float16, float16, float16, __local float16 *)
#pragma tg_funcdef(sincos, __sincos_float, float, float, __private float *)
#pragma tg_funcdef(sincos, __sincos_float2, float2, float2, __private float2 *)
#pragma tg_funcdef(sincos, __sincos_float3, float3, float3, __private float3 *)
#pragma tg_funcdef(sincos, __sincos_float4, float4, float4, __private float4 *)
#pragma tg_funcdef(sincos, __sincos_float8, float8, float8, __private float8 *)
#pragma tg_funcdef(sincos, __sincos_float16, float16, float16, __private float16 *)
#pragma tg_funcdef(sincos, __sincos_float_global, float, float, __global float *)
#pragma tg_funcdef(sincos, __sincos_float2_global, float2, float2, __global float2 *)
#pragma tg_funcdef(sincos, __sincos_float3_global, float3, float3, __global float3 *)
#pragma tg_funcdef(sincos, __sincos_float4_global, float4, float4, __global float4 *)
#pragma tg_funcdef(sincos, __sincos_float8_global, float8, float8, __global float8 *)
#pragma tg_funcdef(sincos, __sincos_float16_global, float16, float16, __global float16 *)
#pragma tg_funcdef(sincos, __sincos_double, double, double, __local double *)
#pragma tg_funcdef(sincos, __sincos_double, double, double, __private double *)
#pragma tg_funcdef(sincos, __sincos_double_global, double, double, __global double *)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(sincos, __sincos_double2, double2, double2, __local double2 *)
#pragma tg_funcdef(sincos, __sincos_double3, double3, double3, __local double3 *)
#pragma tg_funcdef(sincos, __sincos_double4, double4, double4, __local double4 *)
#pragma tg_funcdef(sincos, __sincos_double8, double8, double8, __local double8 *)
#pragma tg_funcdef(sincos, __sincos_double16, double16, double16, __local double16 *)
#pragma tg_funcdef(sincos, __sincos_double2, double2, double2, __private double2 *)
#pragma tg_funcdef(sincos, __sincos_double3, double3, double3, __private double3 *)
#pragma tg_funcdef(sincos, __sincos_double4, double4, double4, __private double4 *)
#pragma tg_funcdef(sincos, __sincos_double8, double8, double8, __private double8 *)
#pragma tg_funcdef(sincos, __sincos_double16, double16, double16, __private double16 *)
#pragma tg_funcdef(sincos, __sincos_double2_global, double2, double2, __global double2 *)
#pragma tg_funcdef(sincos, __sincos_double3_global, double3, double3, __global double3 *)
#pragma tg_funcdef(sincos, __sincos_double4_global, double4, double4, __global double4 *)
#pragma tg_funcdef(sincos, __sincos_double8_global, double8, double8, __global double8 *)
#pragma tg_funcdef(sincos, __sincos_double16_global, double16, double16, __global double16 *)
 #endif
#undef sincos
#define sincos(__a, __b) __tg_builtin("sincos", __a, __b)

#pragma tg_funcdef(sinh, __sinh_float, float, float)
#pragma tg_funcdef(sinh, __sinh_float2, float2, float2)
#pragma tg_funcdef(sinh, __sinh_float3, float3, float3)
#pragma tg_funcdef(sinh, __sinh_float4, float4, float4)
#pragma tg_funcdef(sinh, __sinh_float8, float8, float8)
#pragma tg_funcdef(sinh, __sinh_float16, float16, float16)
#pragma tg_funcdef(sinh, __sinh_double, double, double)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(sinh, __sinh_double2, double2, double2)
#pragma tg_funcdef(sinh, __sinh_double3, double3, double3)
#pragma tg_funcdef(sinh, __sinh_double4, double4, double4)
#pragma tg_funcdef(sinh, __sinh_double8, double8, double8)
#pragma tg_funcdef(sinh, __sinh_double16, double16, double16)
 #endif
#undef sinh
#define sinh(__a) __tg_builtin("sinh", __a)

#pragma tg_funcdef(sinpi, __sinpi_float, float, float)
#pragma tg_funcdef(sinpi, __sinpi_float2, float2, float2)
#pragma tg_funcdef(sinpi, __sinpi_float3, float3, float3)
#pragma tg_funcdef(sinpi, __sinpi_float4, float4, float4)
#pragma tg_funcdef(sinpi, __sinpi_float8, float8, float8)
#pragma tg_funcdef(sinpi, __sinpi_float16, float16, float16)
#pragma tg_funcdef(sinpi, __sinpi_double, double, double)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(sinpi, __sinpi_double2, double2, double2)
#pragma tg_funcdef(sinpi, __sinpi_double3, double3, double3)
#pragma tg_funcdef(sinpi, __sinpi_double4, double4, double4)
#pragma tg_funcdef(sinpi, __sinpi_double8, double8, double8)
#pragma tg_funcdef(sinpi, __sinpi_double16, double16, double16)
 #endif
#undef sinpi
#define sinpi(__a) __tg_builtin("sinpi", __a)

#pragma tg_funcdef(sqrt, __sqrt_float, float, float)
#pragma tg_funcdef(sqrt, __sqrt_float2, float2, float2)
#pragma tg_funcdef(sqrt, __sqrt_float3, float3, float3)
#pragma tg_funcdef(sqrt, __sqrt_float4, float4, float4)
#pragma tg_funcdef(sqrt, __sqrt_float8, float8, float8)
#pragma tg_funcdef(sqrt, __sqrt_float16, float16, float16)
#pragma tg_funcdef(sqrt, __sqrt_double, double, double)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(sqrt, __sqrt_double2, double2, double2)
#pragma tg_funcdef(sqrt, __sqrt_double3, double3, double3)
#pragma tg_funcdef(sqrt, __sqrt_double4, double4, double4)
#pragma tg_funcdef(sqrt, __sqrt_double8, double8, double8)
#pragma tg_funcdef(sqrt, __sqrt_double16, double16, double16)
 #endif
#undef sqrt
#define sqrt(__a) __tg_builtin("sqrt", __a)

#pragma tg_funcdef(tan, __tan_float, float, float)
#pragma tg_funcdef(tan, __tan_float2, float2, float2)
#pragma tg_funcdef(tan, __tan_float3, float3, float3)
#pragma tg_funcdef(tan, __tan_float4, float4, float4)
#pragma tg_funcdef(tan, __tan_float8, float8, float8)
#pragma tg_funcdef(tan, __tan_float16, float16, float16)
#pragma tg_funcdef(tan, __tan_double, double, double)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(tan, __tan_double2, double2, double2)
#pragma tg_funcdef(tan, __tan_double3, double3, double3)
#pragma tg_funcdef(tan, __tan_double4, double4, double4)
#pragma tg_funcdef(tan, __tan_double8, double8, double8)
#pragma tg_funcdef(tan, __tan_double16, double16, double16)
 #endif
#undef tan
#define tan(__a) __tg_builtin("tan", __a)

#pragma tg_funcdef(tanh, __tanh_float, float, float)
#pragma tg_funcdef(tanh, __tanh_float2, float2, float2)
#pragma tg_funcdef(tanh, __tanh_float3, float3, float3)
#pragma tg_funcdef(tanh, __tanh_float4, float4, float4)
#pragma tg_funcdef(tanh, __tanh_float8, float8, float8)
#pragma tg_funcdef(tanh, __tanh_float16, float16, float16)
#pragma tg_funcdef(tanh, __tanh_double, double, double)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(tanh, __tanh_double2, double2, double2)
#pragma tg_funcdef(tanh, __tanh_double3, double3, double3)
#pragma tg_funcdef(tanh, __tanh_double4, double4, double4)
#pragma tg_funcdef(tanh, __tanh_double8, double8, double8)
#pragma tg_funcdef(tanh, __tanh_double16, double16, double16)
 #endif
#undef tanh
#define tanh(__a) __tg_builtin("tanh", __a)

#pragma tg_funcdef(tanpi, __tanpi_float, float, float)
#pragma tg_funcdef(tanpi, __tanpi_float2, float2, float2)
#pragma tg_funcdef(tanpi, __tanpi_float3, float3, float3)
#pragma tg_funcdef(tanpi, __tanpi_float4, float4, float4)
#pragma tg_funcdef(tanpi, __tanpi_float8, float8, float8)
#pragma tg_funcdef(tanpi, __tanpi_float16, float16, float16)
#pragma tg_funcdef(tanpi, __tanpi_double, double, double)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(tanpi, __tanpi_double2, double2, double2)
#pragma tg_funcdef(tanpi, __tanpi_double3, double3, double3)
#pragma tg_funcdef(tanpi, __tanpi_double4, double4, double4)
#pragma tg_funcdef(tanpi, __tanpi_double8, double8, double8)
#pragma tg_funcdef(tanpi, __tanpi_double16, double16, double16)
 #endif
#undef tanpi
#define tanpi(__a) __tg_builtin("tanpi", __a)

#pragma tg_funcdef(tgamma, __tgamma_float, float, float)
#pragma tg_funcdef(tgamma, __tgamma_float2, float2, float2)
#pragma tg_funcdef(tgamma, __tgamma_float3, float3, float3)
#pragma tg_funcdef(tgamma, __tgamma_float4, float4, float4)
#pragma tg_funcdef(tgamma, __tgamma_float8, float8, float8)
#pragma tg_funcdef(tgamma, __tgamma_float16, float16, float16)
#pragma tg_funcdef(tgamma, __tgamma_double, double, double)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(tgamma, __tgamma_double2, double2, double2)
#pragma tg_funcdef(tgamma, __tgamma_double3, double3, double3)
#pragma tg_funcdef(tgamma, __tgamma_double4, double4, double4)
#pragma tg_funcdef(tgamma, __tgamma_double8, double8, double8)
#pragma tg_funcdef(tgamma, __tgamma_double16, double16, double16)
 #endif
#undef tgamma
#define tgamma(__a) __tg_builtin("tgamma", __a)

#pragma tg_funcdef(trunc, __trunc_float, float, float)
#pragma tg_funcdef(trunc, __trunc_float2, float2, float2)
#pragma tg_funcdef(trunc, __trunc_float3, float3, float3)
#pragma tg_funcdef(trunc, __trunc_float4, float4, float4)
#pragma tg_funcdef(trunc, __trunc_float8, float8, float8)
#pragma tg_funcdef(trunc, __trunc_float16, float16, float16)
#pragma tg_funcdef(trunc, __trunc_double, double, double)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(trunc, __trunc_double2, double2, double2)
#pragma tg_funcdef(trunc, __trunc_double3, double3, double3)
#pragma tg_funcdef(trunc, __trunc_double4, double4, double4)
#pragma tg_funcdef(trunc, __trunc_double8, double8, double8)
#pragma tg_funcdef(trunc, __trunc_double16, double16, double16)
 #endif
#undef trunc
#define trunc(__a) __tg_builtin("trunc", __a)

#pragma tg_funcdef(half_cos, __cos_float, float, float)
#pragma tg_funcdef(half_cos, __cos_float2, float2, float2)
#pragma tg_funcdef(half_cos, __cos_float3, float3, float3)
#pragma tg_funcdef(half_cos, __cos_float4, float4, float4)
#pragma tg_funcdef(half_cos, __cos_float8, float8, float8)
#pragma tg_funcdef(half_cos, __cos_float16, float16, float16)
#undef half_cos
#define half_cos(__a) __tg_builtin("half_cos", __a)

#pragma tg_funcdef(half_divide, __half_divide_float, float, float, float)
#pragma tg_funcdef(half_divide, __half_divide_float2, float2, float2, float2)
#pragma tg_funcdef(half_divide, __half_divide_float3, float3, float3, float3)
#pragma tg_funcdef(half_divide, __half_divide_float4, float4, float4, float4)
#pragma tg_funcdef(half_divide, __half_divide_float8, float8, float8, float8)
#pragma tg_funcdef(half_divide, __half_divide_float16, float16, float16, float16)
#undef half_divide
#define half_divide(__a, __b) __tg_builtin("half_divide", __a, __b)

#pragma tg_funcdef(half_exp, __exp_float, float, float)
#pragma tg_funcdef(half_exp, __exp_float2, float2, float2)
#pragma tg_funcdef(half_exp, __exp_float3, float3, float3)
#pragma tg_funcdef(half_exp, __exp_float4, float4, float4)
#pragma tg_funcdef(half_exp, __exp_float8, float8, float8)
#pragma tg_funcdef(half_exp, __exp_float16, float16, float16)
#undef half_exp
#define half_exp(__a) __tg_builtin("half_exp", __a)

#pragma tg_funcdef(half_exp2, __exp2_float, float, float)
#pragma tg_funcdef(half_exp2, __exp2_float2, float2, float2)
#pragma tg_funcdef(half_exp2, __exp2_float3, float3, float3)
#pragma tg_funcdef(half_exp2, __exp2_float4, float4, float4)
#pragma tg_funcdef(half_exp2, __exp2_float8, float8, float8)
#pragma tg_funcdef(half_exp2, __exp2_float16, float16, float16)
#undef half_exp2
#define half_exp2(__a) __tg_builtin("half_exp2", __a)

#pragma tg_funcdef(half_exp10, __exp10_float, float, float)
#pragma tg_funcdef(half_exp10, __exp10_float2, float2, float2)
#pragma tg_funcdef(half_exp10, __exp10_float3, float3, float3)
#pragma tg_funcdef(half_exp10, __exp10_float4, float4, float4)
#pragma tg_funcdef(half_exp10, __exp10_float8, float8, float8)
#pragma tg_funcdef(half_exp10, __exp10_float16, float16, float16)
#undef half_exp10
#define half_exp10(__a) __tg_builtin("half_exp10", __a)

#pragma tg_funcdef(half_log, __log_float, float, float)
#pragma tg_funcdef(half_log, __log_float2, float2, float2)
#pragma tg_funcdef(half_log, __log_float3, float3, float3)
#pragma tg_funcdef(half_log, __log_float4, float4, float4)
#pragma tg_funcdef(half_log, __log_float8, float8, float8)
#pragma tg_funcdef(half_log, __log_float16, float16, float16)
#undef half_log
#define half_log(__a) __tg_builtin("half_log", __a)

#pragma tg_funcdef(half_log2, __log2_float, float, float)
#pragma tg_funcdef(half_log2, __log2_float2, float2, float2)
#pragma tg_funcdef(half_log2, __log2_float3, float3, float3)
#pragma tg_funcdef(half_log2, __log2_float4, float4, float4)
#pragma tg_funcdef(half_log2, __log2_float8, float8, float8)
#pragma tg_funcdef(half_log2, __log2_float16, float16, float16)
#undef half_log2
#define half_log2(__a) __tg_builtin("half_log2", __a)

#pragma tg_funcdef(half_log10, __log10_float, float, float)
#pragma tg_funcdef(half_log10, __log10_float2, float2, float2)
#pragma tg_funcdef(half_log10, __log10_float3, float3, float3)
#pragma tg_funcdef(half_log10, __log10_float4, float4, float4)
#pragma tg_funcdef(half_log10, __log10_float8, float8, float8)
#pragma tg_funcdef(half_log10, __log10_float16, float16, float16)
#undef half_log10
#define half_log10(__a) __tg_builtin("half_log10", __a)

#pragma tg_funcdef(half_powr, __powr_float, float, float, float)
#pragma tg_funcdef(half_powr, __powr_float2, float2, float2, float2)
#pragma tg_funcdef(half_powr, __powr_float3, float3, float3, float3)
#pragma tg_funcdef(half_powr, __powr_float4, float4, float4, float4)
#pragma tg_funcdef(half_powr, __powr_float8, float8, float8, float8)
#pragma tg_funcdef(half_powr, __powr_float16, float16, float16, float16)
#undef half_powr
#define half_powr(__a, __b) __tg_builtin("half_powr", __a, __b)

#pragma tg_funcdef(half_recip, __half_recip_float, float, float)
#pragma tg_funcdef(half_recip, __half_recip_float2, float2, float2)
#pragma tg_funcdef(half_recip, __half_recip_float3, float3, float3)
#pragma tg_funcdef(half_recip, __half_recip_float4, float4, float4)
#pragma tg_funcdef(half_recip, __half_recip_float8, float8, float8)
#pragma tg_funcdef(half_recip, __half_recip_float16, float16, float16)
#undef half_recip
#define half_recip(__a) __tg_builtin("half_recip", __a)

#pragma tg_funcdef(half_rsqrt, __rsqrt_float, float, float)
#pragma tg_funcdef(half_rsqrt, __rsqrt_float2, float2, float2)
#pragma tg_funcdef(half_rsqrt, __rsqrt_float3, float3, float3)
#pragma tg_funcdef(half_rsqrt, __rsqrt_float4, float4, float4)
#pragma tg_funcdef(half_rsqrt, __rsqrt_float8, float8, float8)
#pragma tg_funcdef(half_rsqrt, __rsqrt_float16, float16, float16)
#undef half_rsqrt
#define half_rsqrt(__a) __tg_builtin("half_rsqrt", __a)

#pragma tg_funcdef(half_sin, __sin_float, float, float)
#pragma tg_funcdef(half_sin, __sin_float2, float2, float2)
#pragma tg_funcdef(half_sin, __sin_float3, float3, float3)
#pragma tg_funcdef(half_sin, __sin_float4, float4, float4)
#pragma tg_funcdef(half_sin, __sin_float8, float8, float8)
#pragma tg_funcdef(half_sin, __sin_float16, float16, float16)
#undef half_sin
#define half_sin(__a) __tg_builtin("half_sin", __a)

#pragma tg_funcdef(half_sqrt, __sqrt_float, float, float)
#pragma tg_funcdef(half_sqrt, __sqrt_float2, float2, float2)
#pragma tg_funcdef(half_sqrt, __sqrt_float3, float3, float3)
#pragma tg_funcdef(half_sqrt, __sqrt_float4, float4, float4)
#pragma tg_funcdef(half_sqrt, __sqrt_float8, float8, float8)
#pragma tg_funcdef(half_sqrt, __sqrt_float16, float16, float16)
#undef half_sqrt
#define half_sqrt(__a) __tg_builtin("half_sqrt", __a)

#pragma tg_funcdef(half_tan, __tan_float, float, float)
#pragma tg_funcdef(half_tan, __tan_float2, float2, float2)
#pragma tg_funcdef(half_tan, __tan_float3, float3, float3)
#pragma tg_funcdef(half_tan, __tan_float4, float4, float4)
#pragma tg_funcdef(half_tan, __tan_float8, float8, float8)
#pragma tg_funcdef(half_tan, __tan_float16, float16, float16)
#undef half_tan
#define half_tan(__a) __tg_builtin("half_tan", __a)


#pragma tg_funcdef(native_cos, __native_cos_float, float, float)
#pragma tg_funcdef(native_cos, __native_cos_float2, float2, float2)
#pragma tg_funcdef(native_cos, __native_cos_float3, float3, float3)
#pragma tg_funcdef(native_cos, __native_cos_float4, float4, float4)
#pragma tg_funcdef(native_cos, __native_cos_float8, float8, float8)
#pragma tg_funcdef(native_cos, __native_cos_float16, float16, float16)
#undef native_cos
#define native_cos(__a) __tg_builtin("native_cos", __a)

#pragma tg_funcdef(native_divide, __native_divide_float, float, float, float)
#pragma tg_funcdef(native_divide, __native_divide_float2, float2, float2, float2)
#pragma tg_funcdef(native_divide, __native_divide_float3, float3, float3, float3)
#pragma tg_funcdef(native_divide, __native_divide_float4, float4, float4, float4)
#pragma tg_funcdef(native_divide, __native_divide_float8, float8, float8, float8)
#pragma tg_funcdef(native_divide, __native_divide_float16, float16, float16, float16)
#undef native_divide
#define native_divide(__a, __b) __tg_builtin("native_divide", __a, __b)

#pragma tg_funcdef(native_exp, __native_exp_float, float, float)
#pragma tg_funcdef(native_exp, __native_exp_float2, float2, float2)
#pragma tg_funcdef(native_exp, __native_exp_float3, float3, float3)
#pragma tg_funcdef(native_exp, __native_exp_float4, float4, float4)
#pragma tg_funcdef(native_exp, __native_exp_float8, float8, float8)
#pragma tg_funcdef(native_exp, __native_exp_float16, float16, float16)
#undef native_exp
#define native_exp(__a) __tg_builtin("native_exp", __a)

#pragma tg_funcdef(native_exp2, __native_exp2_float, float, float)
#pragma tg_funcdef(native_exp2, __native_exp2_float2, float2, float2)
#pragma tg_funcdef(native_exp2, __native_exp2_float3, float3, float3)
#pragma tg_funcdef(native_exp2, __native_exp2_float4, float4, float4)
#pragma tg_funcdef(native_exp2, __native_exp2_float8, float8, float8)
#pragma tg_funcdef(native_exp2, __native_exp2_float16, float16, float16)
#undef native_exp2
#define native_exp2(__a) __tg_builtin("native_exp2", __a)

#pragma tg_funcdef(native_exp10, __native_exp10_float, float, float)
#pragma tg_funcdef(native_exp10, __native_exp10_float2, float2, float2)
#pragma tg_funcdef(native_exp10, __native_exp10_float3, float3, float3)
#pragma tg_funcdef(native_exp10, __native_exp10_float4, float4, float4)
#pragma tg_funcdef(native_exp10, __native_exp10_float8, float8, float8)
#pragma tg_funcdef(native_exp10, __native_exp10_float16, float16, float16)
#undef native_exp10
#define native_exp10(__a) __tg_builtin("native_exp10", __a)

#pragma tg_funcdef(native_log, __native_log_float, float, float)
#pragma tg_funcdef(native_log, __native_log_float2, float2, float2)
#pragma tg_funcdef(native_log, __native_log_float3, float3, float3)
#pragma tg_funcdef(native_log, __native_log_float4, float4, float4)
#pragma tg_funcdef(native_log, __native_log_float8, float8, float8)
#pragma tg_funcdef(native_log, __native_log_float16, float16, float16)
#undef native_log
#define native_log(__a) __tg_builtin("native_log", __a)

#pragma tg_funcdef(native_log2, __native_log2_float, float, float)
#pragma tg_funcdef(native_log2, __native_log2_float2, float2, float2)
#pragma tg_funcdef(native_log2, __native_log2_float3, float3, float3)
#pragma tg_funcdef(native_log2, __native_log2_float4, float4, float4)
#pragma tg_funcdef(native_log2, __native_log2_float8, float8, float8)
#pragma tg_funcdef(native_log2, __native_log2_float16, float16, float16)
#undef native_log2
#define native_log2(__a) __tg_builtin("native_log2", __a)

#pragma tg_funcdef(native_log10, __native_log10_float, float, float)
#pragma tg_funcdef(native_log10, __native_log10_float2, float2, float2)
#pragma tg_funcdef(native_log10, __native_log10_float3, float3, float3)
#pragma tg_funcdef(native_log10, __native_log10_float4, float4, float4)
#pragma tg_funcdef(native_log10, __native_log10_float8, float8, float8)
#pragma tg_funcdef(native_log10, __native_log10_float16, float16, float16)
#undef native_log10
#define native_log10(__a) __tg_builtin("native_log10", __a)

#pragma tg_funcdef(native_powr, __native_powr_float, float, float, float)
#pragma tg_funcdef(native_powr, __native_powr_float2, float2, float2, float2)
#pragma tg_funcdef(native_powr, __native_powr_float3, float3, float3, float3)
#pragma tg_funcdef(native_powr, __native_powr_float4, float4, float4, float4)
#pragma tg_funcdef(native_powr, __native_powr_float8, float8, float8, float8)
#pragma tg_funcdef(native_powr, __native_powr_float16, float16, float16, float16)
#undef native_powr
#define native_powr(__a, __b) __tg_builtin("native_powr", __a, __b)

#pragma tg_funcdef(native_recip, __native_recip_float, float, float)
#pragma tg_funcdef(native_recip, __native_recip_float2, float2, float2)
#pragma tg_funcdef(native_recip, __native_recip_float3, float3, float3)
#pragma tg_funcdef(native_recip, __native_recip_float4, float4, float4)
#pragma tg_funcdef(native_recip, __native_recip_float8, float8, float8)
#pragma tg_funcdef(native_recip, __native_recip_float16, float16, float16)
#undef native_recip
#define native_recip(__a) __tg_builtin("native_recip", __a)

#pragma tg_funcdef(native_rsqrt, __native_rsqrt_float, float, float)
#pragma tg_funcdef(native_rsqrt, __native_rsqrt_float2, float2, float2)
#pragma tg_funcdef(native_rsqrt, __native_rsqrt_float3, float3, float3)
#pragma tg_funcdef(native_rsqrt, __native_rsqrt_float4, float4, float4)
#pragma tg_funcdef(native_rsqrt, __native_rsqrt_float8, float8, float8)
#pragma tg_funcdef(native_rsqrt, __native_rsqrt_float16, float16, float16)
#undef native_rsqrt
#define native_rsqrt(__a) __tg_builtin("native_rsqrt", __a)

#pragma tg_funcdef(native_sin, __native_sin_float, float, float)
#pragma tg_funcdef(native_sin, __native_sin_float2, float2, float2)
#pragma tg_funcdef(native_sin, __native_sin_float3, float3, float3)
#pragma tg_funcdef(native_sin, __native_sin_float4, float4, float4)
#pragma tg_funcdef(native_sin, __native_sin_float8, float8, float8)
#pragma tg_funcdef(native_sin, __native_sin_float16, float16, float16)
#undef native_sin
#define native_sin(__a) __tg_builtin("native_sin", __a)

#pragma tg_funcdef(native_sqrt, __native_sqrt_float, float, float)
#pragma tg_funcdef(native_sqrt, __native_sqrt_float2, float2, float2)
#pragma tg_funcdef(native_sqrt, __native_sqrt_float3, float3, float3)
#pragma tg_funcdef(native_sqrt, __native_sqrt_float4, float4, float4)
#pragma tg_funcdef(native_sqrt, __native_sqrt_float8, float8, float8)
#pragma tg_funcdef(native_sqrt, __native_sqrt_float16, float16, float16)
#undef native_sqrt
#define native_sqrt(__a) __tg_builtin("native_sqrt", __a)

#pragma tg_funcdef(native_tan, __native_tan_float, float, float)
#pragma tg_funcdef(native_tan, __native_tan_float2, float2, float2)
#pragma tg_funcdef(native_tan, __native_tan_float3, float3, float3)
#pragma tg_funcdef(native_tan, __native_tan_float4, float4, float4)
#pragma tg_funcdef(native_tan, __native_tan_float8, float8, float8)
#pragma tg_funcdef(native_tan, __native_tan_float16, float16, float16)
#undef native_tan
#define native_tan(__a) __tg_builtin("native_tan", __a)

/* 6.11.3 Integer Functions */

#pragma tg_funcdef(abs, __abs_char, uchar, char)
#pragma tg_funcdef(abs, __abs_char2, uchar2, char2)
#pragma tg_funcdef(abs, __abs_char3, uchar3, char3)
#pragma tg_funcdef(abs, __abs_char4, uchar4, char4)
#pragma tg_funcdef(abs, __abs_char8, uchar8, char8)
#pragma tg_funcdef(abs, __abs_char16, uchar16, char16)
#pragma tg_funcdef(abs, __abs_short, ushort, short)
#pragma tg_funcdef(abs, __abs_short2, ushort2, short2)
#pragma tg_funcdef(abs, __abs_short3, ushort3, short3)
#pragma tg_funcdef(abs, __abs_short4, ushort4, short4)
#pragma tg_funcdef(abs, __abs_short8, ushort8, short8)
#pragma tg_funcdef(abs, __abs_short16, ushort16, short16)
#pragma tg_funcdef(abs, __abs_int, uint, int)
#pragma tg_funcdef(abs, __abs_int2, uint2, int2)
#pragma tg_funcdef(abs, __abs_int3, uint3, int3)
#pragma tg_funcdef(abs, __abs_int4, uint4, int4)
#pragma tg_funcdef(abs, __abs_int8, uint8, int8)
#pragma tg_funcdef(abs, __abs_int16, uint16, int16)
#pragma tg_funcdef(abs, __abs_long, ulong, long)
#pragma tg_funcdef(abs, __abs_long2, ulong2, long2)
#pragma tg_funcdef(abs, __abs_long3, ulong3, long3)
#pragma tg_funcdef(abs, __abs_long4, ulong4, long4)
#pragma tg_funcdef(abs, __abs_long8, ulong8, long8)
#pragma tg_funcdef(abs, __abs_long16, ulong16, long16)
#pragma tg_funcdef(abs, __abs_uchar, uchar, uchar)
#pragma tg_funcdef(abs, __abs_uchar2, uchar2, uchar2)
#pragma tg_funcdef(abs, __abs_uchar3, uchar3, uchar3)
#pragma tg_funcdef(abs, __abs_uchar4, uchar4, uchar4)
#pragma tg_funcdef(abs, __abs_uchar8, uchar8, uchar8)
#pragma tg_funcdef(abs, __abs_uchar16, uchar16, uchar16)
#pragma tg_funcdef(abs, __abs_ushort, ushort, ushort)
#pragma tg_funcdef(abs, __abs_ushort2, ushort2, ushort2)
#pragma tg_funcdef(abs, __abs_ushort3, ushort3, ushort3)
#pragma tg_funcdef(abs, __abs_ushort4, ushort4, ushort4)
#pragma tg_funcdef(abs, __abs_ushort8, ushort8, ushort8)
#pragma tg_funcdef(abs, __abs_ushort16, ushort16, ushort16)
#pragma tg_funcdef(abs, __abs_uint, uint, uint)
#pragma tg_funcdef(abs, __abs_uint2, uint2, uint2)
#pragma tg_funcdef(abs, __abs_uint3, uint3, uint3)
#pragma tg_funcdef(abs, __abs_uint4, uint4, uint4)
#pragma tg_funcdef(abs, __abs_uint8, uint8, uint8)
#pragma tg_funcdef(abs, __abs_uint16, uint16, uint16)
#pragma tg_funcdef(abs, __abs_ulong, ulong, ulong)
#pragma tg_funcdef(abs, __abs_ulong2, ulong2, ulong2)
#pragma tg_funcdef(abs, __abs_ulong3, ulong3, ulong3)
#pragma tg_funcdef(abs, __abs_ulong4, ulong4, ulong4)
#pragma tg_funcdef(abs, __abs_ulong8, ulong8, ulong8)
#pragma tg_funcdef(abs, __abs_ulong16, ulong16, ulong16)
#undef abs
#define abs(__a) __tg_builtin("abs",__a)

#pragma tg_funcdef(abs_diff, __abs_diff_char, uchar, char, char)
#pragma tg_funcdef(abs_diff, __abs_diff_char2, uchar2, char2, char2)
#pragma tg_funcdef(abs_diff, __abs_diff_char3, uchar3, char3, char3)
#pragma tg_funcdef(abs_diff, __abs_diff_char4, uchar4, char4, char4)
#pragma tg_funcdef(abs_diff, __abs_diff_char8, uchar8, char8, char8)
#pragma tg_funcdef(abs_diff, __abs_diff_char16, uchar16, char16, char16)
#pragma tg_funcdef(abs_diff, __abs_diff_short, ushort, short, short)
#pragma tg_funcdef(abs_diff, __abs_diff_short2, ushort2, short2, short2)
#pragma tg_funcdef(abs_diff, __abs_diff_short3, ushort3, short3, short3)
#pragma tg_funcdef(abs_diff, __abs_diff_short4, ushort4, short4, short4)
#pragma tg_funcdef(abs_diff, __abs_diff_short8, ushort8, short8, short8)
#pragma tg_funcdef(abs_diff, __abs_diff_short16, ushort16, short16, short16)
#pragma tg_funcdef(abs_diff, __abs_diff_int, uint, int, int)
#pragma tg_funcdef(abs_diff, __abs_diff_int2, uint2, int2, int2)
#pragma tg_funcdef(abs_diff, __abs_diff_int3, uint3, int3, int3)
#pragma tg_funcdef(abs_diff, __abs_diff_int4, uint4, int4, int4)
#pragma tg_funcdef(abs_diff, __abs_diff_int8, uint8, int8, int8)
#pragma tg_funcdef(abs_diff, __abs_diff_int16, uint16, int16, int16)
#pragma tg_funcdef(abs_diff, __abs_diff_long, ulong, long, long)
#pragma tg_funcdef(abs_diff, __abs_diff_long2, ulong2, long2, long2)
#pragma tg_funcdef(abs_diff, __abs_diff_long3, ulong3, long3, long3)
#pragma tg_funcdef(abs_diff, __abs_diff_long4, ulong4, long4, long4)
#pragma tg_funcdef(abs_diff, __abs_diff_long8, ulong8, long8, long8)
#pragma tg_funcdef(abs_diff, __abs_diff_long16, ulong16, long16, long16)
#pragma tg_funcdef(abs_diff, __abs_diff_uchar, uchar, uchar, uchar)
#pragma tg_funcdef(abs_diff, __abs_diff_uchar2, uchar2, uchar2, uchar2)
#pragma tg_funcdef(abs_diff, __abs_diff_uchar3, uchar3, uchar3, uchar3)
#pragma tg_funcdef(abs_diff, __abs_diff_uchar4, uchar4, uchar4, uchar4)
#pragma tg_funcdef(abs_diff, __abs_diff_uchar8, uchar8, uchar8, uchar8)
#pragma tg_funcdef(abs_diff, __abs_diff_uchar16, uchar16, uchar16, uchar16)
#pragma tg_funcdef(abs_diff, __abs_diff_ushort, ushort, ushort, ushort)
#pragma tg_funcdef(abs_diff, __abs_diff_ushort2, ushort2, ushort2, ushort2)
#pragma tg_funcdef(abs_diff, __abs_diff_ushort3, ushort3, ushort3, ushort3)
#pragma tg_funcdef(abs_diff, __abs_diff_ushort4, ushort4, ushort4, ushort4)
#pragma tg_funcdef(abs_diff, __abs_diff_ushort8, ushort8, ushort8, ushort8)
#pragma tg_funcdef(abs_diff, __abs_diff_ushort16, ushort16, ushort16, ushort16)
#pragma tg_funcdef(abs_diff, __abs_diff_uint, uint, uint, uint)
#pragma tg_funcdef(abs_diff, __abs_diff_uint2, uint2, uint2, uint2)
#pragma tg_funcdef(abs_diff, __abs_diff_uint3, uint3, uint3, uint3)
#pragma tg_funcdef(abs_diff, __abs_diff_uint4, uint4, uint4, uint4)
#pragma tg_funcdef(abs_diff, __abs_diff_uint8, uint8, uint8, uint8)
#pragma tg_funcdef(abs_diff, __abs_diff_uint16, uint16, uint16, uint16)
#pragma tg_funcdef(abs_diff, __abs_diff_ulong, ulong, ulong, ulong)
#pragma tg_funcdef(abs_diff, __abs_diff_ulong2, ulong2, ulong2, ulong2)
#pragma tg_funcdef(abs_diff, __abs_diff_ulong3, ulong3, ulong3, ulong3)
#pragma tg_funcdef(abs_diff, __abs_diff_ulong4, ulong4, ulong4, ulong4)
#pragma tg_funcdef(abs_diff, __abs_diff_ulong8, ulong8, ulong8, ulong8)
#pragma tg_funcdef(abs_diff, __abs_diff_ulong16, ulong16, ulong16, ulong16)
#undef abs_diff
#define abs_diff(__a,__b) __tg_builtin("abs_diff",__a,__b)

#pragma tg_funcdef(add_sat, __add_sat_char, char, char, char)
#pragma tg_funcdef(add_sat, __add_sat_char2, char2, char2, char2)
#pragma tg_funcdef(add_sat, __add_sat_char3, char3, char3, char3)
#pragma tg_funcdef(add_sat, __add_sat_char4, char4, char4, char4)
#pragma tg_funcdef(add_sat, __add_sat_char8, char8, char8, char8)
#pragma tg_funcdef(add_sat, __add_sat_char16, char16, char16, char16)
#pragma tg_funcdef(add_sat, __add_sat_short, short, short, short)
#pragma tg_funcdef(add_sat, __add_sat_short2, short2, short2, short2)
#pragma tg_funcdef(add_sat, __add_sat_short3, short3, short3, short3)
#pragma tg_funcdef(add_sat, __add_sat_short4, short4, short4, short4)
#pragma tg_funcdef(add_sat, __add_sat_short8, short8, short8, short8)
#pragma tg_funcdef(add_sat, __add_sat_short16, short16, short16, short16)
#pragma tg_funcdef(add_sat, __add_sat_int, int, int, int)
#pragma tg_funcdef(add_sat, __add_sat_int2, int2, int2, int2)
#pragma tg_funcdef(add_sat, __add_sat_int3, int3, int3, int3)
#pragma tg_funcdef(add_sat, __add_sat_int4, int4, int4, int4)
#pragma tg_funcdef(add_sat, __add_sat_int8, int8, int8, int8)
#pragma tg_funcdef(add_sat, __add_sat_int16, int16, int16, int16)
#pragma tg_funcdef(add_sat, __add_sat_long, long, long, long)
#pragma tg_funcdef(add_sat, __add_sat_long2, long2, long2, long2)
#pragma tg_funcdef(add_sat, __add_sat_long3, long3, long3, long3)
#pragma tg_funcdef(add_sat, __add_sat_long4, long4, long4, long4)
#pragma tg_funcdef(add_sat, __add_sat_long8, long8, long8, long8)
#pragma tg_funcdef(add_sat, __add_sat_long16, long16, long16, long16)

#pragma tg_funcdef(add_sat, __add_sat_uchar, uchar, uchar, uchar)
#pragma tg_funcdef(add_sat, __add_sat_uchar2, uchar2, uchar2, uchar2)
#pragma tg_funcdef(add_sat, __add_sat_uchar3, uchar3, uchar3, uchar3)
#pragma tg_funcdef(add_sat, __add_sat_uchar4, uchar4, uchar4, uchar4)
#pragma tg_funcdef(add_sat, __add_sat_uchar8, uchar8, uchar8, uchar8)
#pragma tg_funcdef(add_sat, __add_sat_uchar16, uchar16, uchar16, uchar16)
#pragma tg_funcdef(add_sat, __add_sat_ushort, ushort, ushort, ushort)
#pragma tg_funcdef(add_sat, __add_sat_ushort2, ushort2, ushort2, ushort2)
#pragma tg_funcdef(add_sat, __add_sat_ushort3, ushort3, ushort3, ushort3)
#pragma tg_funcdef(add_sat, __add_sat_ushort4, ushort4, ushort4, ushort4)
#pragma tg_funcdef(add_sat, __add_sat_ushort8, ushort8, ushort8, ushort8)
#pragma tg_funcdef(add_sat, __add_sat_ushort16, ushort16, ushort16, ushort16)
#pragma tg_funcdef(add_sat, __add_sat_uint, uint, uint, uint)
#pragma tg_funcdef(add_sat, __add_sat_uint2, uint2, uint2, uint2)
#pragma tg_funcdef(add_sat, __add_sat_uint3, uint3, uint3, uint3)
#pragma tg_funcdef(add_sat, __add_sat_uint4, uint4, uint4, uint4)
#pragma tg_funcdef(add_sat, __add_sat_uint8, uint8, uint8, uint8)
#pragma tg_funcdef(add_sat, __add_sat_uint16, uint16, uint16, uint16)
#pragma tg_funcdef(add_sat, __add_sat_ulong, ulong, ulong, ulong)
#pragma tg_funcdef(add_sat, __add_sat_ulong2, ulong2, ulong2, ulong2)
#pragma tg_funcdef(add_sat, __add_sat_ulong3, ulong3, ulong3, ulong3)
#pragma tg_funcdef(add_sat, __add_sat_ulong4, ulong4, ulong4, ulong4)
#pragma tg_funcdef(add_sat, __add_sat_ulong8, ulong8, ulong8, ulong8)
#pragma tg_funcdef(add_sat, __add_sat_ulong16, ulong16, ulong16, ulong16)

#undef add_sat
#define add_sat(__a,__b) __tg_builtin("add_sat",__a,__b)

#pragma tg_funcdef(hadd, __hadd_char, char, char, char)
#pragma tg_funcdef(hadd, __hadd_char2, char2, char2, char2)
#pragma tg_funcdef(hadd, __hadd_char3, char3, char3, char3)
#pragma tg_funcdef(hadd, __hadd_char4, char4, char4, char4)
#pragma tg_funcdef(hadd, __hadd_char8, char8, char8, char8)
#pragma tg_funcdef(hadd, __hadd_char16, char16, char16, char16)
#pragma tg_funcdef(hadd, __hadd_short, short, short, short)
#pragma tg_funcdef(hadd, __hadd_short2, short2, short2, short2)
#pragma tg_funcdef(hadd, __hadd_short3, short3, short3, short3)
#pragma tg_funcdef(hadd, __hadd_short4, short4, short4, short4)
#pragma tg_funcdef(hadd, __hadd_short8, short8, short8, short8)
#pragma tg_funcdef(hadd, __hadd_short16, short16, short16, short16)
#pragma tg_funcdef(hadd, __hadd_int, int, int, int)
#pragma tg_funcdef(hadd, __hadd_int2, int2, int2, int2)
#pragma tg_funcdef(hadd, __hadd_int3, int3, int3, int3)
#pragma tg_funcdef(hadd, __hadd_int4, int4, int4, int4)
#pragma tg_funcdef(hadd, __hadd_int8, int8, int8, int8)
#pragma tg_funcdef(hadd, __hadd_int16, int16, int16, int16)
#pragma tg_funcdef(hadd, __hadd_long, long, long, long)
#pragma tg_funcdef(hadd, __hadd_long2, long2, long2, long2)
#pragma tg_funcdef(hadd, __hadd_long3, long3, long3, long3)
#pragma tg_funcdef(hadd, __hadd_long4, long4, long4, long4)
#pragma tg_funcdef(hadd, __hadd_long8, long8, long8, long8)
#pragma tg_funcdef(hadd, __hadd_long16, long16, long16, long16)

#pragma tg_funcdef(hadd, __hadd_uchar, uchar, uchar, uchar)
#pragma tg_funcdef(hadd, __hadd_uchar2, uchar2, uchar2, uchar2)
#pragma tg_funcdef(hadd, __hadd_uchar3, uchar3, uchar3, uchar3)
#pragma tg_funcdef(hadd, __hadd_uchar4, uchar4, uchar4, uchar4)
#pragma tg_funcdef(hadd, __hadd_uchar8, uchar8, uchar8, uchar8)
#pragma tg_funcdef(hadd, __hadd_uchar16, uchar16, uchar16, uchar16)
#pragma tg_funcdef(hadd, __hadd_ushort, ushort, ushort, ushort)
#pragma tg_funcdef(hadd, __hadd_ushort2, ushort2, ushort2, ushort2)
#pragma tg_funcdef(hadd, __hadd_ushort3, ushort3, ushort3, ushort3)
#pragma tg_funcdef(hadd, __hadd_ushort4, ushort4, ushort4, ushort4)
#pragma tg_funcdef(hadd, __hadd_ushort8, ushort8, ushort8, ushort8)
#pragma tg_funcdef(hadd, __hadd_ushort16, ushort16, ushort16, ushort16)
#pragma tg_funcdef(hadd, __hadd_uint, uint, uint, uint)
#pragma tg_funcdef(hadd, __hadd_uint2, uint2, uint2, uint2)
#pragma tg_funcdef(hadd, __hadd_uint3, uint3, uint3, uint3)
#pragma tg_funcdef(hadd, __hadd_uint4, uint4, uint4, uint4)
#pragma tg_funcdef(hadd, __hadd_uint8, uint8, uint8, uint8)
#pragma tg_funcdef(hadd, __hadd_uint16, uint16, uint16, uint16)
#pragma tg_funcdef(hadd, __hadd_ulong, ulong, ulong, ulong)
#pragma tg_funcdef(hadd, __hadd_ulong2, ulong2, ulong2, ulong2)
#pragma tg_funcdef(hadd, __hadd_ulong3, ulong3, ulong3, ulong3)
#pragma tg_funcdef(hadd, __hadd_ulong4, ulong4, ulong4, ulong4)
#pragma tg_funcdef(hadd, __hadd_ulong8, ulong8, ulong8, ulong8)
#pragma tg_funcdef(hadd, __hadd_ulong16, ulong16, ulong16, ulong16)

#undef hadd
#define hadd(__a,__b) __tg_builtin("hadd",__a,__b)

#pragma tg_funcdef(rhadd, __rhadd_char, char, char, char)
#pragma tg_funcdef(rhadd, __rhadd_char2, char2, char2, char2)
#pragma tg_funcdef(rhadd, __rhadd_char3, char3, char3, char3)
#pragma tg_funcdef(rhadd, __rhadd_char4, char4, char4, char4)
#pragma tg_funcdef(rhadd, __rhadd_char8, char8, char8, char8)
#pragma tg_funcdef(rhadd, __rhadd_char16, char16, char16, char16)
#pragma tg_funcdef(rhadd, __rhadd_short, short, short, short)
#pragma tg_funcdef(rhadd, __rhadd_short2, short2, short2, short2)
#pragma tg_funcdef(rhadd, __rhadd_short3, short3, short3, short3)
#pragma tg_funcdef(rhadd, __rhadd_short4, short4, short4, short4)
#pragma tg_funcdef(rhadd, __rhadd_short8, short8, short8, short8)
#pragma tg_funcdef(rhadd, __rhadd_short16, short16, short16, short16)
#pragma tg_funcdef(rhadd, __rhadd_int, int, int, int)
#pragma tg_funcdef(rhadd, __rhadd_int2, int2, int2, int2)
#pragma tg_funcdef(rhadd, __rhadd_int3, int3, int3, int3)
#pragma tg_funcdef(rhadd, __rhadd_int4, int4, int4, int4)
#pragma tg_funcdef(rhadd, __rhadd_int8, int8, int8, int8)
#pragma tg_funcdef(rhadd, __rhadd_int16, int16, int16, int16)
#pragma tg_funcdef(rhadd, __rhadd_long, long, long, long)
#pragma tg_funcdef(rhadd, __rhadd_long2, long2, long2, long2)
#pragma tg_funcdef(rhadd, __rhadd_long3, long3, long3, long3)
#pragma tg_funcdef(rhadd, __rhadd_long4, long4, long4, long4)
#pragma tg_funcdef(rhadd, __rhadd_long8, long8, long8, long8)
#pragma tg_funcdef(rhadd, __rhadd_long16, long16, long16, long16)

#pragma tg_funcdef(rhadd, __rhadd_uchar, uchar, uchar, uchar)
#pragma tg_funcdef(rhadd, __rhadd_uchar2, uchar2, uchar2, uchar2)
#pragma tg_funcdef(rhadd, __rhadd_uchar3, uchar3, uchar3, uchar3)
#pragma tg_funcdef(rhadd, __rhadd_uchar4, uchar4, uchar4, uchar4)
#pragma tg_funcdef(rhadd, __rhadd_uchar8, uchar8, uchar8, uchar8)
#pragma tg_funcdef(rhadd, __rhadd_uchar16, uchar16, uchar16, uchar16)
#pragma tg_funcdef(rhadd, __rhadd_ushort, ushort, ushort, ushort)
#pragma tg_funcdef(rhadd, __rhadd_ushort2, ushort2, ushort2, ushort2)
#pragma tg_funcdef(rhadd, __rhadd_ushort3, ushort3, ushort3, ushort3)
#pragma tg_funcdef(rhadd, __rhadd_ushort4, ushort4, ushort4, ushort4)
#pragma tg_funcdef(rhadd, __rhadd_ushort8, ushort8, ushort8, ushort8)
#pragma tg_funcdef(rhadd, __rhadd_ushort16, ushort16, ushort16, ushort16)
#pragma tg_funcdef(rhadd, __rhadd_uint, uint, uint, uint)
#pragma tg_funcdef(rhadd, __rhadd_uint2, uint2, uint2, uint2)
#pragma tg_funcdef(rhadd, __rhadd_uint3, uint3, uint3, uint3)
#pragma tg_funcdef(rhadd, __rhadd_uint4, uint4, uint4, uint4)
#pragma tg_funcdef(rhadd, __rhadd_uint8, uint8, uint8, uint8)
#pragma tg_funcdef(rhadd, __rhadd_uint16, uint16, uint16, uint16)
#pragma tg_funcdef(rhadd, __rhadd_ulong, ulong, ulong, ulong)
#pragma tg_funcdef(rhadd, __rhadd_ulong2, ulong2, ulong2, ulong2)
#pragma tg_funcdef(rhadd, __rhadd_ulong3, ulong3, ulong3, ulong3)
#pragma tg_funcdef(rhadd, __rhadd_ulong4, ulong4, ulong4, ulong4)
#pragma tg_funcdef(rhadd, __rhadd_ulong8, ulong8, ulong8, ulong8)
#pragma tg_funcdef(rhadd, __rhadd_ulong16, ulong16, ulong16, ulong16)

#undef rhadd
#define rhadd(__a,__b) __tg_builtin("rhadd",__a,__b)

#pragma tg_funcdef(clz, clz_tg, uchar, uchar)
#pragma tg_funcdef(clz, clz_tg, uchar2, uchar2)
#pragma tg_funcdef(clz, clz_tg, uchar3, uchar3)
#pragma tg_funcdef(clz, clz_tg, uchar4, uchar4)
#pragma tg_funcdef(clz, clz_tg, uchar8, uchar8)
#pragma tg_funcdef(clz, clz_tg, uchar16, uchar16)
#pragma tg_funcdef(clz, clz_tg, ushort, ushort)
#pragma tg_funcdef(clz, clz_tg, ushort2, ushort2)
#pragma tg_funcdef(clz, clz_tg, ushort3, ushort3)
#pragma tg_funcdef(clz, clz_tg, ushort4, ushort4)
#pragma tg_funcdef(clz, clz_tg, ushort8, ushort8)
#pragma tg_funcdef(clz, clz_tg, ushort16, ushort16)
#pragma tg_funcdef(clz, clz_tg, uint, uint)
#pragma tg_funcdef(clz, clz_tg, uint2, uint2)
#pragma tg_funcdef(clz, clz_tg, uint3, uint3)
#pragma tg_funcdef(clz, clz_tg, uint4, uint4)
#pragma tg_funcdef(clz, clz_tg, uint8, uint8)
#pragma tg_funcdef(clz, clz_tg, uint16, uint16)
#pragma tg_funcdef(clz, clz_tg, ulong, ulong)
#pragma tg_funcdef(clz, clz_tg, ulong2, ulong2)
#pragma tg_funcdef(clz, clz_tg, ulong3, ulong3)
#pragma tg_funcdef(clz, clz_tg, ulong4, ulong4)
#pragma tg_funcdef(clz, clz_tg, ulong8, ulong8)
#pragma tg_funcdef(clz, clz_tg, ulong16, ulong16)

#pragma tg_funcdef(clz, clz_tg, char, char)
#pragma tg_funcdef(clz, clz_tg, char2, char2)
#pragma tg_funcdef(clz, clz_tg, char3, char3)
#pragma tg_funcdef(clz, clz_tg, char4, char4)
#pragma tg_funcdef(clz, clz_tg, char8, char8)
#pragma tg_funcdef(clz, clz_tg, char16, char16)
#pragma tg_funcdef(clz, clz_tg, short, short)
#pragma tg_funcdef(clz, clz_tg, short2, short2)
#pragma tg_funcdef(clz, clz_tg, short3, short3)
#pragma tg_funcdef(clz, clz_tg, short4, short4)
#pragma tg_funcdef(clz, clz_tg, short8, short8)
#pragma tg_funcdef(clz, clz_tg, short16, short16)
#pragma tg_funcdef(clz, clz_tg, int, int)
#pragma tg_funcdef(clz, clz_tg, int2, int2)
#pragma tg_funcdef(clz, clz_tg, int3, int3)
#pragma tg_funcdef(clz, clz_tg, int4, int4)
#pragma tg_funcdef(clz, clz_tg, int8, int8)
#pragma tg_funcdef(clz, clz_tg, int16, int16)
#pragma tg_funcdef(clz, clz_tg, long, long)
#pragma tg_funcdef(clz, clz_tg, long2, long2)
#pragma tg_funcdef(clz, clz_tg, long3, long3)
#pragma tg_funcdef(clz, clz_tg, long4, long4)
#pragma tg_funcdef(clz, clz_tg, long8, long8)
#pragma tg_funcdef(clz, clz_tg, long16, long16)

#undef clz
#define clz(__a) __tg_builtin_gentype("clz", __a)

#pragma tg_funcdef(mad_hi, __mad_hi_char, char, char, char, char)
#pragma tg_funcdef(mad_hi, __mad_hi_char2, char2, char2, char2, char2)
#pragma tg_funcdef(mad_hi, __mad_hi_char3, char3, char3, char3, char3)
#pragma tg_funcdef(mad_hi, __mad_hi_char4, char4, char4, char4, char4)
#pragma tg_funcdef(mad_hi, __mad_hi_char8, char8, char8, char8, char8)
#pragma tg_funcdef(mad_hi, __mad_hi_char16, char16, char16, char16, char16)
#pragma tg_funcdef(mad_hi, __mad_hi_short, short, short, short, short)
#pragma tg_funcdef(mad_hi, __mad_hi_short2, short2, short2, short2, short2)
#pragma tg_funcdef(mad_hi, __mad_hi_short3, short3, short3, short3, short3)
#pragma tg_funcdef(mad_hi, __mad_hi_short4, short4, short4, short4, short4)
#pragma tg_funcdef(mad_hi, __mad_hi_short8, short8, short8, short8, short8)
#pragma tg_funcdef(mad_hi, __mad_hi_short16, short16, short16, short16, short16)
#pragma tg_funcdef(mad_hi, __mad_hi_int, int, int, int, int)
#pragma tg_funcdef(mad_hi, __mad_hi_int2, int2, int2, int2, int2)
#pragma tg_funcdef(mad_hi, __mad_hi_int3, int3, int3, int3, int3)
#pragma tg_funcdef(mad_hi, __mad_hi_int4, int4, int4, int4, int4)
#pragma tg_funcdef(mad_hi, __mad_hi_int8, int8, int8, int8, int8)
#pragma tg_funcdef(mad_hi, __mad_hi_int16, int16, int16, int16, int16)
#pragma tg_funcdef(mad_hi, __mad_hi_long, long, long, long, long)
#pragma tg_funcdef(mad_hi, __mad_hi_long2, long2, long2, long2, long2)
#pragma tg_funcdef(mad_hi, __mad_hi_long3, long3, long3, long3, long3)
#pragma tg_funcdef(mad_hi, __mad_hi_long4, long4, long4, long4, long4)
#pragma tg_funcdef(mad_hi, __mad_hi_long8, long8, long8, long8, long8)
#pragma tg_funcdef(mad_hi, __mad_hi_long16, long16, long16, long16, long16)

#pragma tg_funcdef(mad_hi, __mad_hi_uchar, uchar, uchar, uchar, uchar)
#pragma tg_funcdef(mad_hi, __mad_hi_uchar2, uchar2, uchar2, uchar2, uchar2)
#pragma tg_funcdef(mad_hi, __mad_hi_uchar3, uchar3, uchar3, uchar3, uchar3)
#pragma tg_funcdef(mad_hi, __mad_hi_uchar4, uchar4, uchar4, uchar4, uchar4)
#pragma tg_funcdef(mad_hi, __mad_hi_uchar8, uchar8, uchar8, uchar8, uchar8)
#pragma tg_funcdef(mad_hi, __mad_hi_uchar16, uchar16, uchar16, uchar16, uchar16)
#pragma tg_funcdef(mad_hi, __mad_hi_ushort, ushort, ushort, ushort, ushort)
#pragma tg_funcdef(mad_hi, __mad_hi_ushort2, ushort2, ushort2, ushort2, ushort2)
#pragma tg_funcdef(mad_hi, __mad_hi_ushort3, ushort3, ushort3, ushort3, ushort3)
#pragma tg_funcdef(mad_hi, __mad_hi_ushort4, ushort4, ushort4, ushort4, ushort4)
#pragma tg_funcdef(mad_hi, __mad_hi_ushort8, ushort8, ushort8, ushort8, ushort8)
#pragma tg_funcdef(mad_hi, __mad_hi_ushort16, ushort16, ushort16, ushort16, ushort16)
#pragma tg_funcdef(mad_hi, __mad_hi_uint, uint, uint, uint, uint)
#pragma tg_funcdef(mad_hi, __mad_hi_uint2, uint2, uint2, uint2, uint2)
#pragma tg_funcdef(mad_hi, __mad_hi_uint3, uint3, uint3, uint3, uint3)
#pragma tg_funcdef(mad_hi, __mad_hi_uint4, uint4, uint4, uint4, uint4)
#pragma tg_funcdef(mad_hi, __mad_hi_uint8, uint8, uint8, uint8, uint8)
#pragma tg_funcdef(mad_hi, __mad_hi_uint16, uint16, uint16, uint16, uint16)
#pragma tg_funcdef(mad_hi, __mad_hi_ulong, ulong, ulong, ulong, ulong)
#pragma tg_funcdef(mad_hi, __mad_hi_ulong2, ulong2, ulong2, ulong2, ulong2)
#pragma tg_funcdef(mad_hi, __mad_hi_ulong3, ulong3, ulong3, ulong3, ulong3)
#pragma tg_funcdef(mad_hi, __mad_hi_ulong4, ulong4, ulong4, ulong4, ulong4)
#pragma tg_funcdef(mad_hi, __mad_hi_ulong8, ulong8, ulong8, ulong8, ulong8)
#pragma tg_funcdef(mad_hi, __mad_hi_ulong16, ulong16, ulong16, ulong16, ulong16)

#undef mad_hi
#define mad_hi(__a,__b,__c) __tg_builtin("mad_hi",__a,__b,__c)

#pragma tg_funcdef(mad_sat, __mad_sat_char, char, char, char, char)
#pragma tg_funcdef(mad_sat, __mad_sat_char2, char2, char2, char2, char2)
#pragma tg_funcdef(mad_sat, __mad_sat_char3, char3, char3, char3, char3)
#pragma tg_funcdef(mad_sat, __mad_sat_char4, char4, char4, char4, char4)
#pragma tg_funcdef(mad_sat, __mad_sat_char8, char8, char8, char8, char8)
#pragma tg_funcdef(mad_sat, __mad_sat_char16, char16, char16, char16, char16)
#pragma tg_funcdef(mad_sat, __mad_sat_short, short, short, short, short)
#pragma tg_funcdef(mad_sat, __mad_sat_short2, short2, short2, short2, short2)
#pragma tg_funcdef(mad_sat, __mad_sat_short3, short3, short3, short3, short3)
#pragma tg_funcdef(mad_sat, __mad_sat_short4, short4, short4, short4, short4)
#pragma tg_funcdef(mad_sat, __mad_sat_short8, short8, short8, short8, short8)
#pragma tg_funcdef(mad_sat, __mad_sat_short16, short16, short16, short16, short16)
#pragma tg_funcdef(mad_sat, __mad_sat_int, int, int, int, int)
#pragma tg_funcdef(mad_sat, __mad_sat_int2, int2, int2, int2, int2)
#pragma tg_funcdef(mad_sat, __mad_sat_int3, int3, int3, int3, int3)
#pragma tg_funcdef(mad_sat, __mad_sat_int4, int4, int4, int4, int4)
#pragma tg_funcdef(mad_sat, __mad_sat_int8, int8, int8, int8, int8)
#pragma tg_funcdef(mad_sat, __mad_sat_int16, int16, int16, int16, int16)
#pragma tg_funcdef(mad_sat, __mad_sat_long, long, long, long, long)
#pragma tg_funcdef(mad_sat, __mad_sat_long2, long2, long2, long2, long2)
#pragma tg_funcdef(mad_sat, __mad_sat_long3, long3, long3, long3, long3)
#pragma tg_funcdef(mad_sat, __mad_sat_long4, long4, long4, long4, long4)
#pragma tg_funcdef(mad_sat, __mad_sat_long8, long8, long8, long8, long8)
#pragma tg_funcdef(mad_sat, __mad_sat_long16, long16, long16, long16, long16)

#pragma tg_funcdef(mad_sat, __mad_sat_uchar, uchar, uchar, uchar, uchar)
#pragma tg_funcdef(mad_sat, __mad_sat_uchar2, uchar2, uchar2, uchar2, uchar2)
#pragma tg_funcdef(mad_sat, __mad_sat_uchar3, uchar3, uchar3, uchar3, uchar3)
#pragma tg_funcdef(mad_sat, __mad_sat_uchar4, uchar4, uchar4, uchar4, uchar4)
#pragma tg_funcdef(mad_sat, __mad_sat_uchar8, uchar8, uchar8, uchar8, uchar8)
#pragma tg_funcdef(mad_sat, __mad_sat_uchar16, uchar16, uchar16, uchar16, uchar16)
#pragma tg_funcdef(mad_sat, __mad_sat_ushort, ushort, ushort, ushort, ushort)
#pragma tg_funcdef(mad_sat, __mad_sat_ushort2, ushort2, ushort2, ushort2, ushort2)
#pragma tg_funcdef(mad_sat, __mad_sat_ushort3, ushort3, ushort3, ushort3, ushort3)
#pragma tg_funcdef(mad_sat, __mad_sat_ushort4, ushort4, ushort4, ushort4, ushort4)
#pragma tg_funcdef(mad_sat, __mad_sat_ushort8, ushort8, ushort8, ushort8, ushort8)
#pragma tg_funcdef(mad_sat, __mad_sat_ushort16, ushort16, ushort16, ushort16, ushort16)
#pragma tg_funcdef(mad_sat, __mad_sat_uint, uint, uint, uint, uint)
#pragma tg_funcdef(mad_sat, __mad_sat_uint2, uint2, uint2, uint2, uint2)
#pragma tg_funcdef(mad_sat, __mad_sat_uint3, uint3, uint3, uint3, uint3)
#pragma tg_funcdef(mad_sat, __mad_sat_uint4, uint4, uint4, uint4, uint4)
#pragma tg_funcdef(mad_sat, __mad_sat_uint8, uint8, uint8, uint8, uint8)
#pragma tg_funcdef(mad_sat, __mad_sat_uint16, uint16, uint16, uint16, uint16)
#pragma tg_funcdef(mad_sat, __mad_sat_ulong, ulong, ulong, ulong, ulong)
#pragma tg_funcdef(mad_sat, __mad_sat_ulong2, ulong2, ulong2, ulong2, ulong2)
#pragma tg_funcdef(mad_sat, __mad_sat_ulong3, ulong3, ulong3, ulong3, ulong3)
#pragma tg_funcdef(mad_sat, __mad_sat_ulong4, ulong4, ulong4, ulong4, ulong4)
#pragma tg_funcdef(mad_sat, __mad_sat_ulong8, ulong8, ulong8, ulong8, ulong8)
#pragma tg_funcdef(mad_sat, __mad_sat_ulong16, ulong16, ulong16, ulong16, ulong16)

#undef mad_sat
#define mad_sat(__a,__b,__c) __tg_builtin("mad_sat",__a,__b,__c)

#pragma tg_funcdef(max, max_tg, char,  char,  char)
#pragma tg_funcdef(max, max_tg, char2, char2, char)
#pragma tg_funcdef(max, max_tg, char3, char3, char)
#pragma tg_funcdef(max, max_tg, char4, char4, char)
#pragma tg_funcdef(max, max_tg, char8, char8, char)
#pragma tg_funcdef(max, max_tg, char16,char16,char)
#pragma tg_funcdef(max, max_tg, char2, char2, char2)
#pragma tg_funcdef(max, max_tg, char3, char3, char3)
#pragma tg_funcdef(max, max_tg, char4, char4, char4)
#pragma tg_funcdef(max, max_tg, char8, char8, char8)
#pragma tg_funcdef(max, max_tg, char16,char16,char16)

#pragma tg_funcdef(max, max_tg, short,  short,  short)
#pragma tg_funcdef(max, max_tg, short2, short2, short)
#pragma tg_funcdef(max, max_tg, short3, short3, short)
#pragma tg_funcdef(max, max_tg, short4, short4, short)
#pragma tg_funcdef(max, max_tg, short8, short8, short)
#pragma tg_funcdef(max, max_tg, short16,short16,short)
#pragma tg_funcdef(max, max_tg, short2, short2, short2)
#pragma tg_funcdef(max, max_tg, short3, short3, short3)
#pragma tg_funcdef(max, max_tg, short4, short4, short4)
#pragma tg_funcdef(max, max_tg, short8, short8, short8)
#pragma tg_funcdef(max, max_tg, short16, short16, short16)

#pragma tg_funcdef(max, max_tg, int, int, int)
#pragma tg_funcdef(max, max_tg, int2, int2, int)
#pragma tg_funcdef(max, max_tg, int3, int3, int)
#pragma tg_funcdef(max, max_tg, int4, int4, int)
#pragma tg_funcdef(max, max_tg, int8, int8, int)
#pragma tg_funcdef(max, max_tg, int16, int16, int)
#pragma tg_funcdef(max, max_tg, int2, int2, int2)
#pragma tg_funcdef(max, max_tg, int3, int3, int3)
#pragma tg_funcdef(max, max_tg, int4, int4, int4)
#pragma tg_funcdef(max, max_tg, int8, int8, int8)
#pragma tg_funcdef(max, max_tg, int16, int16, int16)

#pragma tg_funcdef(max, max_tg, long, long, long)
#pragma tg_funcdef(max, max_tg, long2, long2, long)
#pragma tg_funcdef(max, max_tg, long3, long3, long)
#pragma tg_funcdef(max, max_tg, long4, long4, long)
#pragma tg_funcdef(max, max_tg, long8, long8, long)
#pragma tg_funcdef(max, max_tg, long16, long16, long)
#pragma tg_funcdef(max, max_tg, long2, long2, long2)
#pragma tg_funcdef(max, max_tg, long3, long3, long3)
#pragma tg_funcdef(max, max_tg, long4, long4, long4)
#pragma tg_funcdef(max, max_tg, long8, long8, long8)
#pragma tg_funcdef(max, max_tg, long16, long16, long16)

#pragma tg_funcdef(max, max_tg, uchar, uchar, uchar)
#pragma tg_funcdef(max, max_tg, uchar2, uchar2, uchar)
#pragma tg_funcdef(max, max_tg, uchar3, uchar3, uchar)
#pragma tg_funcdef(max, max_tg, uchar4, uchar4, uchar)
#pragma tg_funcdef(max, max_tg, uchar8, uchar8, uchar)
#pragma tg_funcdef(max, max_tg, uchar16,uchar16,uchar)
#pragma tg_funcdef(max, max_tg, uchar2, uchar2, uchar2)
#pragma tg_funcdef(max, max_tg, uchar3, uchar3, uchar3)
#pragma tg_funcdef(max, max_tg, uchar4, uchar4, uchar4)
#pragma tg_funcdef(max, max_tg, uchar8, uchar8, uchar8)
#pragma tg_funcdef(max, max_tg, uchar16, uchar16, uchar16)

#pragma tg_funcdef(max, max_tg, ushort, ushort, ushort)
#pragma tg_funcdef(max, max_tg, ushort2, ushort2, ushort)
#pragma tg_funcdef(max, max_tg, ushort3, ushort3, ushort)
#pragma tg_funcdef(max, max_tg, ushort4, ushort4, ushort)
#pragma tg_funcdef(max, max_tg, ushort8, ushort8, ushort)
#pragma tg_funcdef(max, max_tg, ushort16, ushort16, ushort)
#pragma tg_funcdef(max, max_tg, ushort2, ushort2, ushort2)
#pragma tg_funcdef(max, max_tg, ushort3, ushort3, ushort3)
#pragma tg_funcdef(max, max_tg, ushort4, ushort4, ushort4)
#pragma tg_funcdef(max, max_tg, ushort8, ushort8, ushort8)
#pragma tg_funcdef(max, max_tg, ushort16, ushort16, ushort16)

#pragma tg_funcdef(max, max_tg, uint, uint, uint)
#pragma tg_funcdef(max, max_tg, uint2, uint2, uint)
#pragma tg_funcdef(max, max_tg, uint3, uint3, uint)
#pragma tg_funcdef(max, max_tg, uint4, uint4, uint)
#pragma tg_funcdef(max, max_tg, uint8, uint8, uint)
#pragma tg_funcdef(max, max_tg, uint16, uint16, uint)
#pragma tg_funcdef(max, max_tg, uint2, uint2, uint2)
#pragma tg_funcdef(max, max_tg, uint3, uint3, uint3)
#pragma tg_funcdef(max, max_tg, uint4, uint4, uint4)
#pragma tg_funcdef(max, max_tg, uint8, uint8, uint8)
#pragma tg_funcdef(max, max_tg, uint16, uint16, uint16)

#pragma tg_funcdef(max, max_tg, ulong, ulong, ulong)
#pragma tg_funcdef(max, max_tg, ulong2, ulong2, ulong)
#pragma tg_funcdef(max, max_tg, ulong3, ulong3, ulong)
#pragma tg_funcdef(max, max_tg, ulong4, ulong4, ulong)
#pragma tg_funcdef(max, max_tg, ulong8, ulong8, ulong)
#pragma tg_funcdef(max, max_tg, ulong16, ulong16, ulong)
#pragma tg_funcdef(max, max_tg, ulong2, ulong2, ulong2)
#pragma tg_funcdef(max, max_tg, ulong3, ulong3, ulong3)
#pragma tg_funcdef(max, max_tg, ulong4, ulong4, ulong4)
#pragma tg_funcdef(max, max_tg, ulong8, ulong8, ulong8)
#pragma tg_funcdef(max, max_tg, ulong16, ulong16, ulong16)
// Defined below

#pragma tg_funcdef(min, min_tg, char, char, char)
#pragma tg_funcdef(min, min_tg, char2, char2, char)
#pragma tg_funcdef(min, min_tg, char3, char3, char)
#pragma tg_funcdef(min, min_tg, char4, char4, char)
#pragma tg_funcdef(min, min_tg, char8, char8, char)
#pragma tg_funcdef(min, min_tg, char16, char16, char)
#pragma tg_funcdef(min, min_tg, char2, char2, char2)
#pragma tg_funcdef(min, min_tg, char3, char3, char3)
#pragma tg_funcdef(min, min_tg, char4, char4, char4)
#pragma tg_funcdef(min, min_tg, char8, char8, char8)
#pragma tg_funcdef(min, min_tg, char16, char16, char16)

#pragma tg_funcdef(min, min_tg, short, short, short)
#pragma tg_funcdef(min, min_tg, short2, short2, short)
#pragma tg_funcdef(min, min_tg, short3, short3, short)
#pragma tg_funcdef(min, min_tg, short4, short4, short)
#pragma tg_funcdef(min, min_tg, short8, short8, short)
#pragma tg_funcdef(min, min_tg, short16, short16, short)
#pragma tg_funcdef(min, min_tg, short2, short2, short2)
#pragma tg_funcdef(min, min_tg, short3, short3, short3)
#pragma tg_funcdef(min, min_tg, short4, short4, short4)
#pragma tg_funcdef(min, min_tg, short8, short8, short8)
#pragma tg_funcdef(min, min_tg, short16, short16, short16)

#pragma tg_funcdef(min, min_tg, int, int, int)
#pragma tg_funcdef(min, min_tg, int2, int2, int)
#pragma tg_funcdef(min, min_tg, int3, int3, int)
#pragma tg_funcdef(min, min_tg, int4, int4, int)
#pragma tg_funcdef(min, min_tg, int8, int8, int)
#pragma tg_funcdef(min, min_tg, int16, int16, int)
#pragma tg_funcdef(min, min_tg, int2, int2, int2)
#pragma tg_funcdef(min, min_tg, int3, int3, int3)
#pragma tg_funcdef(min, min_tg, int4, int4, int4)
#pragma tg_funcdef(min, min_tg, int8, int8, int8)
#pragma tg_funcdef(min, min_tg, int16, int16, int16)

#pragma tg_funcdef(min, min_tg, long, long, long)
#pragma tg_funcdef(min, min_tg, long2, long2, long)
#pragma tg_funcdef(min, min_tg, long3, long3, long)
#pragma tg_funcdef(min, min_tg, long4, long4, long)
#pragma tg_funcdef(min, min_tg, long8, long8, long)
#pragma tg_funcdef(min, min_tg, long16, long16, long)
#pragma tg_funcdef(min, min_tg, long2, long2, long2)
#pragma tg_funcdef(min, min_tg, long3, long3, long3)
#pragma tg_funcdef(min, min_tg, long4, long4, long4)
#pragma tg_funcdef(min, min_tg, long8, long8, long8)
#pragma tg_funcdef(min, min_tg, long16, long16, long16)

#pragma tg_funcdef(min, min_tg, uchar, uchar, uchar)
#pragma tg_funcdef(min, min_tg, uchar2, uchar2, uchar)
#pragma tg_funcdef(min, min_tg, uchar3, uchar3, uchar)
#pragma tg_funcdef(min, min_tg, uchar4, uchar4, uchar)
#pragma tg_funcdef(min, min_tg, uchar8, uchar8, uchar)
#pragma tg_funcdef(min, min_tg, uchar16, uchar16, uchar)
#pragma tg_funcdef(min, min_tg, uchar2, uchar2, uchar2)
#pragma tg_funcdef(min, min_tg, uchar3, uchar3, uchar3)
#pragma tg_funcdef(min, min_tg, uchar4, uchar4, uchar4)
#pragma tg_funcdef(min, min_tg, uchar8, uchar8, uchar8)
#pragma tg_funcdef(min, min_tg, uchar16, uchar16, uchar16)

#pragma tg_funcdef(min, min_tg, ushort, ushort, ushort)
#pragma tg_funcdef(min, min_tg, ushort2, ushort2, ushort)
#pragma tg_funcdef(min, min_tg, ushort3, ushort3, ushort)
#pragma tg_funcdef(min, min_tg, ushort4, ushort4, ushort)
#pragma tg_funcdef(min, min_tg, ushort8, ushort8, ushort)
#pragma tg_funcdef(min, min_tg, ushort16, ushort16, ushort)
#pragma tg_funcdef(min, min_tg, ushort2, ushort2, ushort2)
#pragma tg_funcdef(min, min_tg, ushort3, ushort3, ushort3)
#pragma tg_funcdef(min, min_tg, ushort4, ushort4, ushort4)
#pragma tg_funcdef(min, min_tg, ushort8, ushort8, ushort8)
#pragma tg_funcdef(min, min_tg, ushort16, ushort16, ushort16)

#pragma tg_funcdef(min, min_tg, uint, uint, uint)
#pragma tg_funcdef(min, min_tg, uint2, uint2, uint)
#pragma tg_funcdef(min, min_tg, uint3, uint3, uint)
#pragma tg_funcdef(min, min_tg, uint4, uint4, uint)
#pragma tg_funcdef(min, min_tg, uint8, uint8, uint)
#pragma tg_funcdef(min, min_tg, uint16, uint16, uint)
#pragma tg_funcdef(min, min_tg, uint2, uint2, uint2)
#pragma tg_funcdef(min, min_tg, uint3, uint3, uint3)
#pragma tg_funcdef(min, min_tg, uint4, uint4, uint4)
#pragma tg_funcdef(min, min_tg, uint8, uint8, uint8)
#pragma tg_funcdef(min, min_tg, uint16, uint16, uint16)

#pragma tg_funcdef(min, min_tg, ulong, ulong, ulong)
#pragma tg_funcdef(min, min_tg, ulong2, ulong2, ulong)
#pragma tg_funcdef(min, min_tg, ulong3, ulong3, ulong)
#pragma tg_funcdef(min, min_tg, ulong4, ulong4, ulong)
#pragma tg_funcdef(min, min_tg, ulong8, ulong8, ulong)
#pragma tg_funcdef(min, min_tg, ulong16, ulong16, ulong)
#pragma tg_funcdef(min, min_tg, ulong2, ulong2, ulong2)
#pragma tg_funcdef(min, min_tg, ulong3, ulong3, ulong3)
#pragma tg_funcdef(min, min_tg, ulong4, ulong4, ulong4)
#pragma tg_funcdef(min, min_tg, ulong8, ulong8, ulong8)
#pragma tg_funcdef(min, min_tg, ulong16, ulong16, ulong16)

// Defined below

#pragma tg_funcdef(mul_hi, __mul_hi_char, char, char, char)
#pragma tg_funcdef(mul_hi, __mul_hi_char2, char2, char2, char2)
#pragma tg_funcdef(mul_hi, __mul_hi_char3, char3, char3, char3)
#pragma tg_funcdef(mul_hi, __mul_hi_char4, char4, char4, char4)
#pragma tg_funcdef(mul_hi, __mul_hi_char8, char8, char8, char8)
#pragma tg_funcdef(mul_hi, __mul_hi_char16, char16, char16, char16)
#pragma tg_funcdef(mul_hi, __mul_hi_short, short, short, short)
#pragma tg_funcdef(mul_hi, __mul_hi_short2, short2, short2, short2)
#pragma tg_funcdef(mul_hi, __mul_hi_short3, short3, short3, short3)
#pragma tg_funcdef(mul_hi, __mul_hi_short4, short4, short4, short4)
#pragma tg_funcdef(mul_hi, __mul_hi_short8, short8, short8, short8)
#pragma tg_funcdef(mul_hi, __mul_hi_short16, short16, short16, short16)
#pragma tg_funcdef(mul_hi, __mul_hi_int, int, int, int)
#pragma tg_funcdef(mul_hi, __mul_hi_int2, int2, int2, int2)
#pragma tg_funcdef(mul_hi, __mul_hi_int3, int3, int3, int3)
#pragma tg_funcdef(mul_hi, __mul_hi_int4, int4, int4, int4)
#pragma tg_funcdef(mul_hi, __mul_hi_int8, int8, int8, int8)
#pragma tg_funcdef(mul_hi, __mul_hi_int16, int16, int16, int16)
#pragma tg_funcdef(mul_hi, __mul_hi_long, long, long, long)
#pragma tg_funcdef(mul_hi, __mul_hi_long2, long2, long2, long2)
#pragma tg_funcdef(mul_hi, __mul_hi_long3, long3, long3, long3)
#pragma tg_funcdef(mul_hi, __mul_hi_long4, long4, long4, long4)
#pragma tg_funcdef(mul_hi, __mul_hi_long8, long8, long8, long8)
#pragma tg_funcdef(mul_hi, __mul_hi_long16, long16, long16, long16)

#pragma tg_funcdef(mul_hi, __mul_hi_uchar, uchar, uchar, uchar)
#pragma tg_funcdef(mul_hi, __mul_hi_uchar2, uchar2, uchar2, uchar2)
#pragma tg_funcdef(mul_hi, __mul_hi_uchar3, uchar3, uchar3, uchar3)
#pragma tg_funcdef(mul_hi, __mul_hi_uchar4, uchar4, uchar4, uchar4)
#pragma tg_funcdef(mul_hi, __mul_hi_uchar8, uchar8, uchar8, uchar8)
#pragma tg_funcdef(mul_hi, __mul_hi_uchar16, uchar16, uchar16, uchar16)
#pragma tg_funcdef(mul_hi, __mul_hi_ushort, ushort, ushort, ushort)
#pragma tg_funcdef(mul_hi, __mul_hi_ushort2, ushort2, ushort2, ushort2)
#pragma tg_funcdef(mul_hi, __mul_hi_ushort3, ushort3, ushort3, ushort3)
#pragma tg_funcdef(mul_hi, __mul_hi_ushort4, ushort4, ushort4, ushort4)
#pragma tg_funcdef(mul_hi, __mul_hi_ushort8, ushort8, ushort8, ushort8)
#pragma tg_funcdef(mul_hi, __mul_hi_ushort16, ushort16, ushort16, ushort16)
#pragma tg_funcdef(mul_hi, __mul_hi_uint, uint, uint, uint)
#pragma tg_funcdef(mul_hi, __mul_hi_uint2, uint2, uint2, uint2)
#pragma tg_funcdef(mul_hi, __mul_hi_uint3, uint3, uint3, uint3)
#pragma tg_funcdef(mul_hi, __mul_hi_uint4, uint4, uint4, uint4)
#pragma tg_funcdef(mul_hi, __mul_hi_uint8, uint8, uint8, uint8)
#pragma tg_funcdef(mul_hi, __mul_hi_uint16, uint16, uint16, uint16)
#pragma tg_funcdef(mul_hi, __mul_hi_ulong, ulong, ulong, ulong)
#pragma tg_funcdef(mul_hi, __mul_hi_ulong2, ulong2, ulong2, ulong2)
#pragma tg_funcdef(mul_hi, __mul_hi_ulong3, ulong3, ulong3, ulong3)
#pragma tg_funcdef(mul_hi, __mul_hi_ulong4, ulong4, ulong4, ulong4)
#pragma tg_funcdef(mul_hi, __mul_hi_ulong8, ulong8, ulong8, ulong8)
#pragma tg_funcdef(mul_hi, __mul_hi_ulong16, ulong16, ulong16, ulong16)

#undef mul_hi
#define mul_hi(__a,__b) __tg_builtin("mul_hi",__a,__b)

#pragma tg_funcdef(rotate, __rotate_tg, char, char, char)
#pragma tg_funcdef(rotate, __rotate_tg, char2, char2, char2)
#pragma tg_funcdef(rotate, __rotate_tg, char3, char3, char3)
#pragma tg_funcdef(rotate, __rotate_tg, char4, char4, char4)
#pragma tg_funcdef(rotate, __rotate_tg, char8, char8, char8)
#pragma tg_funcdef(rotate, __rotate_tg, char16, char16, char16)
#pragma tg_funcdef(rotate, __rotate_tg, short, short, short)
#pragma tg_funcdef(rotate, __rotate_tg, short2, short2, short2)
#pragma tg_funcdef(rotate, __rotate_tg, short3, short3, short3)
#pragma tg_funcdef(rotate, __rotate_tg, short4, short4, short4)
#pragma tg_funcdef(rotate, __rotate_tg, short8, short8, short8)
#pragma tg_funcdef(rotate, __rotate_tg, short16, short16, short16)
#pragma tg_funcdef(rotate, __rotate_tg, int, int, int)
#pragma tg_funcdef(rotate, __rotate_tg, int2, int2, int2)
#pragma tg_funcdef(rotate, __rotate_tg, int3, int3, int3)
#pragma tg_funcdef(rotate, __rotate_tg, int4, int4, int4)
#pragma tg_funcdef(rotate, __rotate_tg, int8, int8, int8)
#pragma tg_funcdef(rotate, __rotate_tg, int16, int16, int16)
#pragma tg_funcdef(rotate, __rotate_tg, long, long, long)
#pragma tg_funcdef(rotate, __rotate_tg, long2, long2, long2)
#pragma tg_funcdef(rotate, __rotate_tg, long3, long3, long3)
#pragma tg_funcdef(rotate, __rotate_tg, long4, long4, long4)
#pragma tg_funcdef(rotate, __rotate_tg, long8, long8, long8)
#pragma tg_funcdef(rotate, __rotate_tg, long16, long16, long16)

#pragma tg_funcdef(rotate, __rotate_tg, uchar, uchar, uchar)
#pragma tg_funcdef(rotate, __rotate_tg, uchar2, uchar2, uchar2)
#pragma tg_funcdef(rotate, __rotate_tg, uchar3, uchar3, uchar3)
#pragma tg_funcdef(rotate, __rotate_tg, uchar4, uchar4, uchar4)
#pragma tg_funcdef(rotate, __rotate_tg, uchar8, uchar8, uchar8)
#pragma tg_funcdef(rotate, __rotate_tg, uchar16, uchar16, uchar16)
#pragma tg_funcdef(rotate, __rotate_tg, ushort, ushort, ushort)
#pragma tg_funcdef(rotate, __rotate_tg, ushort2, ushort2, ushort2)
#pragma tg_funcdef(rotate, __rotate_tg, ushort3, ushort3, ushort3)
#pragma tg_funcdef(rotate, __rotate_tg, ushort4, ushort4, ushort4)
#pragma tg_funcdef(rotate, __rotate_tg, ushort8, ushort8, ushort8)
#pragma tg_funcdef(rotate, __rotate_tg, ushort16, ushort16, ushort16)
#pragma tg_funcdef(rotate, __rotate_tg, uint, uint, uint)
#pragma tg_funcdef(rotate, __rotate_tg, uint2, uint2, uint2)
#pragma tg_funcdef(rotate, __rotate_tg, uint3, uint3, uint3)
#pragma tg_funcdef(rotate, __rotate_tg, uint4, uint4, uint4)
#pragma tg_funcdef(rotate, __rotate_tg, uint8, uint8, uint8)
#pragma tg_funcdef(rotate, __rotate_tg, uint16, uint16, uint16)
#pragma tg_funcdef(rotate, __rotate_tg, ulong, ulong, ulong)
#pragma tg_funcdef(rotate, __rotate_tg, ulong2, ulong2, ulong2)
#pragma tg_funcdef(rotate, __rotate_tg, ulong3, ulong3, ulong3)
#pragma tg_funcdef(rotate, __rotate_tg, ulong4, ulong4, ulong4)
#pragma tg_funcdef(rotate, __rotate_tg, ulong8, ulong8, ulong8)
#pragma tg_funcdef(rotate, __rotate_tg, ulong16, ulong16, ulong16)
#undef rotate
#define rotate(__a,__b) __tg_builtin_gentype("rotate",__a,__b)

#pragma tg_funcdef(sub_sat, __sub_sat_char, char, char, char)
#pragma tg_funcdef(sub_sat, __sub_sat_char2, char2, char2, char2)
#pragma tg_funcdef(sub_sat, __sub_sat_char3, char3, char3, char3)
#pragma tg_funcdef(sub_sat, __sub_sat_char4, char4, char4, char4)
#pragma tg_funcdef(sub_sat, __sub_sat_char8, char8, char8, char8)
#pragma tg_funcdef(sub_sat, __sub_sat_char16, char16, char16, char16)
#pragma tg_funcdef(sub_sat, __sub_sat_short, short, short, short)
#pragma tg_funcdef(sub_sat, __sub_sat_short2, short2, short2, short2)
#pragma tg_funcdef(sub_sat, __sub_sat_short3, short3, short3, short3)
#pragma tg_funcdef(sub_sat, __sub_sat_short4, short4, short4, short4)
#pragma tg_funcdef(sub_sat, __sub_sat_short8, short8, short8, short8)
#pragma tg_funcdef(sub_sat, __sub_sat_short16, short16, short16, short16)
#pragma tg_funcdef(sub_sat, __sub_sat_int, int, int, int)
#pragma tg_funcdef(sub_sat, __sub_sat_int2, int2, int2, int2)
#pragma tg_funcdef(sub_sat, __sub_sat_int3, int3, int3, int3)
#pragma tg_funcdef(sub_sat, __sub_sat_int4, int4, int4, int4)
#pragma tg_funcdef(sub_sat, __sub_sat_int8, int8, int8, int8)
#pragma tg_funcdef(sub_sat, __sub_sat_int16, int16, int16, int16)
#pragma tg_funcdef(sub_sat, __sub_sat_long, long, long, long)
#pragma tg_funcdef(sub_sat, __sub_sat_long2, long2, long2, long2)
#pragma tg_funcdef(sub_sat, __sub_sat_long3, long3, long3, long3)
#pragma tg_funcdef(sub_sat, __sub_sat_long4, long4, long4, long4)
#pragma tg_funcdef(sub_sat, __sub_sat_long8, long8, long8, long8)
#pragma tg_funcdef(sub_sat, __sub_sat_long16, long16, long16, long16)

#pragma tg_funcdef(sub_sat, __sub_sat_uchar, uchar, uchar, uchar)
#pragma tg_funcdef(sub_sat, __sub_sat_uchar2, uchar2, uchar2, uchar2)
#pragma tg_funcdef(sub_sat, __sub_sat_uchar3, uchar3, uchar3, uchar3)
#pragma tg_funcdef(sub_sat, __sub_sat_uchar4, uchar4, uchar4, uchar4)
#pragma tg_funcdef(sub_sat, __sub_sat_uchar8, uchar8, uchar8, uchar8)
#pragma tg_funcdef(sub_sat, __sub_sat_uchar16, uchar16, uchar16, uchar16)
#pragma tg_funcdef(sub_sat, __sub_sat_ushort, ushort, ushort, ushort)
#pragma tg_funcdef(sub_sat, __sub_sat_ushort2, ushort2, ushort2, ushort2)
#pragma tg_funcdef(sub_sat, __sub_sat_ushort3, ushort3, ushort3, ushort3)
#pragma tg_funcdef(sub_sat, __sub_sat_ushort4, ushort4, ushort4, ushort4)
#pragma tg_funcdef(sub_sat, __sub_sat_ushort8, ushort8, ushort8, ushort8)
#pragma tg_funcdef(sub_sat, __sub_sat_ushort16, ushort16, ushort16, ushort16)
#pragma tg_funcdef(sub_sat, __sub_sat_uint, uint, uint, uint)
#pragma tg_funcdef(sub_sat, __sub_sat_uint2, uint2, uint2, uint2)
#pragma tg_funcdef(sub_sat, __sub_sat_uint3, uint3, uint3, uint3)
#pragma tg_funcdef(sub_sat, __sub_sat_uint4, uint4, uint4, uint4)
#pragma tg_funcdef(sub_sat, __sub_sat_uint8, uint8, uint8, uint8)
#pragma tg_funcdef(sub_sat, __sub_sat_uint16, uint16, uint16, uint16)
#pragma tg_funcdef(sub_sat, __sub_sat_ulong, ulong, ulong, ulong)
#pragma tg_funcdef(sub_sat, __sub_sat_ulong2, ulong2, ulong2, ulong2)
#pragma tg_funcdef(sub_sat, __sub_sat_ulong3, ulong3, ulong3, ulong3)
#pragma tg_funcdef(sub_sat, __sub_sat_ulong4, ulong4, ulong4, ulong4)
#pragma tg_funcdef(sub_sat, __sub_sat_ulong8, ulong8, ulong8, ulong8)
#pragma tg_funcdef(sub_sat, __sub_sat_ulong16, ulong16, ulong16, ulong16)

#undef sub_sat
#define sub_sat(__a,__b) __tg_builtin("sub_sat",__a,__b)

/* upsample */
#pragma tg_funcdef(upsample, __upsample_short, short, char, uchar)
#pragma tg_funcdef(upsample, __upsample_short2, short2, char2, uchar2)
#pragma tg_funcdef(upsample, __upsample_short3, short3, char3, uchar3)
#pragma tg_funcdef(upsample, __upsample_short4, short4, char4, uchar4)
#pragma tg_funcdef(upsample, __upsample_short8, short8, char8, uchar8)
#pragma tg_funcdef(upsample, __upsample_short16, short16, char16, uchar16)

#pragma tg_funcdef(upsample, __upsample_ushort, ushort, uchar, uchar)
#pragma tg_funcdef(upsample, __upsample_ushort2, ushort2, uchar2, uchar2)
#pragma tg_funcdef(upsample, __upsample_ushort3, ushort3, uchar3, uchar3)
#pragma tg_funcdef(upsample, __upsample_ushort4, ushort4, uchar4, uchar4)
#pragma tg_funcdef(upsample, __upsample_ushort8, ushort8, uchar8, uchar8)
#pragma tg_funcdef(upsample, __upsample_ushort16, ushort16, uchar16, uchar16)

#pragma tg_funcdef(upsample, __upsample_int, int, short, ushort)
#pragma tg_funcdef(upsample, __upsample_int2, int2, short2, ushort2)
#pragma tg_funcdef(upsample, __upsample_int3, int3, short3, ushort3)
#pragma tg_funcdef(upsample, __upsample_int4, int4, short4, ushort4)
#pragma tg_funcdef(upsample, __upsample_int8, int8, short8, ushort8)
#pragma tg_funcdef(upsample, __upsample_int16, int16, short16, ushort16)

#pragma tg_funcdef(upsample, __upsample_uint, uint, ushort, ushort)
#pragma tg_funcdef(upsample, __upsample_uint2, uint2, ushort2, ushort2)
#pragma tg_funcdef(upsample, __upsample_uint3, uint3, ushort3, ushort3)
#pragma tg_funcdef(upsample, __upsample_uint4, uint4, ushort4, ushort4)
#pragma tg_funcdef(upsample, __upsample_uint8, uint8, ushort8, ushort8)
#pragma tg_funcdef(upsample, __upsample_uint16, uint16, ushort16, ushort16)

#pragma tg_funcdef(upsample, __upsample_long, long, int, uint)
#pragma tg_funcdef(upsample, __upsample_long2, long2, int2, uint2)
#pragma tg_funcdef(upsample, __upsample_long3, long3, int3, uint3)
#pragma tg_funcdef(upsample, __upsample_long4, long4, int4, uint4)
#pragma tg_funcdef(upsample, __upsample_long8, long8, int8, uint8)
#pragma tg_funcdef(upsample, __upsample_long16, long16, int16, uint16)

#pragma tg_funcdef(upsample, __upsample_ulong, ulong, uint, uint)
#pragma tg_funcdef(upsample, __upsample_ulong2, ulong2, uint2, uint2)
#pragma tg_funcdef(upsample, __upsample_ulong3, ulong3, uint3, uint3)
#pragma tg_funcdef(upsample, __upsample_ulong4, ulong4, uint4, uint4)
#pragma tg_funcdef(upsample, __upsample_ulong8, ulong8, uint8, uint8)
#pragma tg_funcdef(upsample, __upsample_ulong16, ulong16, uint16, uint16)

#undef upsample
#define upsample(__a,__b) __tg_builtin("upsample",__a,__b)

/* mad24 */
#pragma tg_funcdef(mad24, __mad24_int, int, int, int, int)
#pragma tg_funcdef(mad24, __mad24_int2, int2, int2, int2, int2)
#pragma tg_funcdef(mad24, __mad24_int3, int3, int3, int3, int3)
#pragma tg_funcdef(mad24, __mad24_int4, int4, int4, int4, int4)
#pragma tg_funcdef(mad24, __mad24_int8, int8, int8, int8, int8) 
#pragma tg_funcdef(mad24, __mad24_int16, int16, int16, int16, int16)

#pragma tg_funcdef(mad24, __mad24_uint, uint, uint, uint, uint) 
#pragma tg_funcdef(mad24, __mad24_uint2, uint2, uint2, uint2, uint2)
#pragma tg_funcdef(mad24, __mad24_uint3, uint3, uint3, uint3, uint3)
#pragma tg_funcdef(mad24, __mad24_uint4, uint4, uint4, uint4, uint4)
#pragma tg_funcdef(mad24, __mad24_uint8, uint8, uint8, uint8, uint8)
#pragma tg_funcdef(mad24, __mad24_uint16, uint16, uint16, uint16, uint16)
#undef mad24
#define mad24(__a,__b,__c) __tg_builtin("mad24",__a,__b,__c)

/* mul24 */
#pragma tg_funcdef(mul24, __mul24_int, int, int, int)  
#pragma tg_funcdef(mul24, __mul24_int2, int2, int2, int2)
#pragma tg_funcdef(mul24, __mul24_int3, int3, int3, int3)
#pragma tg_funcdef(mul24, __mul24_int4, int4, int4, int4)
#pragma tg_funcdef(mul24, __mul24_int8, int8, int8, int8)
#pragma tg_funcdef(mul24, __mul24_int16, int16, int16, int16)

#pragma tg_funcdef(mul24, __mul24_uint, uint, uint, uint)
#pragma tg_funcdef(mul24, __mul24_uint2, uint2, uint2, uint2)
#pragma tg_funcdef(mul24, __mul24_uint3, uint3, uint3, uint3)
#pragma tg_funcdef(mul24, __mul24_uint4, uint4, uint4, uint4)
#pragma tg_funcdef(mul24, __mul24_uint8, uint8, uint8, uint8)
#pragma tg_funcdef(mul24, __mul24_uint16, uint16, uint16, uint16)
#undef mul24
#define mul24(__a,__b) __tg_builtin("mul24",__a,__b)

/* 6.11.4 Common */
#pragma tg_funcdef(clamp, __clamp_float, float, float, float, float)
#pragma tg_funcdef(clamp, __clamp_float2, float2, float2, float2, float2)
#pragma tg_funcdef(clamp, __clamp_float3, float3, float3, float3, float3)
#pragma tg_funcdef(clamp, __clamp_float4, float4, float4, float4, float4)
#pragma tg_funcdef(clamp, __clamp_float8, float8, float8, float8, float8)
#pragma tg_funcdef(clamp, __clamp_float16, float16, float16, float16, float16)
#pragma tg_funcdef(clamp, __clamp_float_float2, float2, float2, float, float)
#pragma tg_funcdef(clamp, __clamp_float_float3, float3, float3, float, float)
#pragma tg_funcdef(clamp, __clamp_float_float4, float4, float4, float, float)
#pragma tg_funcdef(clamp, __clamp_float_float8, float8, float8, float, float)
#pragma tg_funcdef(clamp, __clamp_float_float16, float16, float16, float, float)

#pragma tg_funcdef(clamp, __clamp_double, double, double, double, double)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(clamp, __clamp_double2, double2, double2, double2, double2)
#pragma tg_funcdef(clamp, __clamp_double3, double3, double3, double3, double3)
#pragma tg_funcdef(clamp, __clamp_double4, double4, double4, double4, double4)
#pragma tg_funcdef(clamp, __clamp_double8, double8, double8, double8, double8)
#pragma tg_funcdef(clamp, __clamp_double16, double16, double16, double16, double16)
#pragma tg_funcdef(clamp, __clamp_double_double2, double2, double2, double, double)
#pragma tg_funcdef(clamp, __clamp_double_double3, double3, double3, double, double)
#pragma tg_funcdef(clamp, __clamp_double_double4, double4, double4, double, double)
#pragma tg_funcdef(clamp, __clamp_double_double8, double8, double8, double, double)
#pragma tg_funcdef(clamp, __clamp_double_double16, double16, double16, double, double)
 #endif

#pragma tg_funcdef(clamp, __clamp_uchar, uchar, uchar, uchar, uchar)
#pragma tg_funcdef(clamp, __clamp_uchar2, uchar2, uchar2, uchar2, uchar2)
#pragma tg_funcdef(clamp, __clamp_uchar3, uchar3, uchar3, uchar3, uchar3)
#pragma tg_funcdef(clamp, __clamp_uchar4, uchar4, uchar4, uchar4, uchar4)
#pragma tg_funcdef(clamp, __clamp_uchar8, uchar8, uchar8, uchar8, uchar8)
#pragma tg_funcdef(clamp, __clamp_uchar16, uchar16, uchar16, uchar16, uchar16)
#pragma tg_funcdef(clamp, __clamp_uchar_uchar2, uchar2, uchar2, uchar, uchar)
#pragma tg_funcdef(clamp, __clamp_uchar_uchar3, uchar3, uchar3, uchar, uchar)
#pragma tg_funcdef(clamp, __clamp_uchar_uchar4, uchar4, uchar4, uchar, uchar)
#pragma tg_funcdef(clamp, __clamp_uchar_uchar8, uchar8, uchar8, uchar, uchar)
#pragma tg_funcdef(clamp, __clamp_uchar_uchar16, uchar16, uchar16, uchar, uchar)

#pragma tg_funcdef(clamp, __clamp_char, char, char, char, char)
#pragma tg_funcdef(clamp, __clamp_char2, char2, char2, char2, char2)
#pragma tg_funcdef(clamp, __clamp_char3, char3, char3, char3, char3)
#pragma tg_funcdef(clamp, __clamp_char4, char4, char4, char4, char4)
#pragma tg_funcdef(clamp, __clamp_char8, char8, char8, char8, char8)
#pragma tg_funcdef(clamp, __clamp_char16, char16, char16, char16, char16)
#pragma tg_funcdef(clamp, __clamp_char_char2, char2, char2, char, char)
#pragma tg_funcdef(clamp, __clamp_char_char3, char3, char3, char, char)
#pragma tg_funcdef(clamp, __clamp_char_char4, char4, char4, char, char)
#pragma tg_funcdef(clamp, __clamp_char_char8, char8, char8, char, char)
#pragma tg_funcdef(clamp, __clamp_char_char16, char16, char16, char, char)

#pragma tg_funcdef(clamp, __clamp_ushort, ushort, ushort, ushort, ushort)
#pragma tg_funcdef(clamp, __clamp_ushort2, ushort2, ushort2, ushort2, ushort2)
#pragma tg_funcdef(clamp, __clamp_ushort3, ushort3, ushort3, ushort3, ushort3)
#pragma tg_funcdef(clamp, __clamp_ushort4, ushort4, ushort4, ushort4, ushort4)
#pragma tg_funcdef(clamp, __clamp_ushort8, ushort8, ushort8, ushort8, ushort8)
#pragma tg_funcdef(clamp, __clamp_ushort16, ushort16, ushort16, ushort16, ushort16)
#pragma tg_funcdef(clamp, __clamp_ushort_ushort2, ushort2, ushort2, ushort, ushort)
#pragma tg_funcdef(clamp, __clamp_ushort_ushort3, ushort3, ushort3, ushort, ushort)
#pragma tg_funcdef(clamp, __clamp_ushort_ushort4, ushort4, ushort4, ushort, ushort)
#pragma tg_funcdef(clamp, __clamp_ushort_ushort8, ushort8, ushort8, ushort, ushort)
#pragma tg_funcdef(clamp, __clamp_ushort_ushort16, ushort16, ushort16, ushort, ushort)

#pragma tg_funcdef(clamp, __clamp_short, short, short, short, short)
#pragma tg_funcdef(clamp, __clamp_short2, short2, short2, short2, short2)
#pragma tg_funcdef(clamp, __clamp_short3, short3, short3, short3, short3)
#pragma tg_funcdef(clamp, __clamp_short4, short4, short4, short4, short4)
#pragma tg_funcdef(clamp, __clamp_short8, short8, short8, short8, short8)
#pragma tg_funcdef(clamp, __clamp_short16, short16, short16, short16, short16)
#pragma tg_funcdef(clamp, __clamp_short_short2, short2, short2, short, short)
#pragma tg_funcdef(clamp, __clamp_short_short3, short3, short3, short, short)
#pragma tg_funcdef(clamp, __clamp_short_short4, short4, short4, short, short)
#pragma tg_funcdef(clamp, __clamp_short_short8, short8, short8, short, short)
#pragma tg_funcdef(clamp, __clamp_short_short16, short16, short16, short, short)

#pragma tg_funcdef(clamp, __clamp_uint, uint, uint, uint, uint)
#pragma tg_funcdef(clamp, __clamp_uint2, uint2, uint2, uint2, uint2)
#pragma tg_funcdef(clamp, __clamp_uint3, uint3, uint3, uint3, uint3)
#pragma tg_funcdef(clamp, __clamp_uint4, uint4, uint4, uint4, uint4)
#pragma tg_funcdef(clamp, __clamp_uint8, uint8, uint8, uint8, uint8)
#pragma tg_funcdef(clamp, __clamp_uint16, uint16, uint16, uint16, uint16)
#pragma tg_funcdef(clamp, __clamp_uint_uint2, uint2, uint2, uint, uint)
#pragma tg_funcdef(clamp, __clamp_uint_uint3, uint3, uint3, uint, uint)
#pragma tg_funcdef(clamp, __clamp_uint_uint4, uint4, uint4, uint, uint)
#pragma tg_funcdef(clamp, __clamp_uint_uint8, uint8, uint8, uint, uint)
#pragma tg_funcdef(clamp, __clamp_uint_uint16, uint16, uint16, uint, uint)

#pragma tg_funcdef(clamp, __clamp_int, int, int, int, int)
#pragma tg_funcdef(clamp, __clamp_int2, int2, int2, int2, int2)
#pragma tg_funcdef(clamp, __clamp_int3, int3, int3, int3, int3)
#pragma tg_funcdef(clamp, __clamp_int4, int4, int4, int4, int4)
#pragma tg_funcdef(clamp, __clamp_int8, int8, int8, int8, int8)
#pragma tg_funcdef(clamp, __clamp_int16, int16, int16, int16, int16)
#pragma tg_funcdef(clamp, __clamp_int_int2, int2, int2, int, int)
#pragma tg_funcdef(clamp, __clamp_int_int3, int3, int3, int, int)
#pragma tg_funcdef(clamp, __clamp_int_int4, int4, int4, int, int)
#pragma tg_funcdef(clamp, __clamp_int_int8, int8, int8, int, int)
#pragma tg_funcdef(clamp, __clamp_int_int16, int16, int16, int, int)

#pragma tg_funcdef(clamp, __clamp_ulong, ulong, ulong, ulong, ulong)
#pragma tg_funcdef(clamp, __clamp_ulong2, ulong2, ulong2, ulong2, ulong2)
#pragma tg_funcdef(clamp, __clamp_ulong3, ulong3, ulong3, ulong3, ulong3)
#pragma tg_funcdef(clamp, __clamp_ulong4, ulong4, ulong4, ulong4, ulong4)
#pragma tg_funcdef(clamp, __clamp_ulong8, ulong8, ulong8, ulong8, ulong8)
#pragma tg_funcdef(clamp, __clamp_ulong16, ulong16, ulong16, ulong16, ulong16)
#pragma tg_funcdef(clamp, __clamp_ulong_ulong2, ulong2, ulong2, ulong, ulong)
#pragma tg_funcdef(clamp, __clamp_ulong_ulong3, ulong3, ulong3, ulong, ulong)
#pragma tg_funcdef(clamp, __clamp_ulong_ulong4, ulong4, ulong4, ulong, ulong)
#pragma tg_funcdef(clamp, __clamp_ulong_ulong8, ulong8, ulong8, ulong, ulong)
#pragma tg_funcdef(clamp, __clamp_ulong_ulong16, ulong16, ulong16, ulong, ulong)

#pragma tg_funcdef(clamp, __clamp_long, long, long, long, long)
#pragma tg_funcdef(clamp, __clamp_long2, long2, long2, long2, long2)
#pragma tg_funcdef(clamp, __clamp_long3, long3, long3, long3, long3)
#pragma tg_funcdef(clamp, __clamp_long4, long4, long4, long4, long4)
#pragma tg_funcdef(clamp, __clamp_long8, long8, long8, long8, long8)
#pragma tg_funcdef(clamp, __clamp_long16, long16, long16, long16, long16)
#pragma tg_funcdef(clamp, __clamp_long_long2, long2, long2, long, long)
#pragma tg_funcdef(clamp, __clamp_long_long3, long3, long3, long, long)
#pragma tg_funcdef(clamp, __clamp_long_long4, long4, long4, long, long)
#pragma tg_funcdef(clamp, __clamp_long_long8, long8, long8, long, long)
#pragma tg_funcdef(clamp, __clamp_long_long16, long16, long16, long, long)
#undef clamp
#define clamp(__a, __b, __c) __tg_builtin("clamp", __a, __b, __c)

#pragma tg_funcdef(degrees, __degrees_float, float, float)
#pragma tg_funcdef(degrees, __degrees_float2, float2, float2)
#pragma tg_funcdef(degrees, __degrees_float3, float3, float3)
#pragma tg_funcdef(degrees, __degrees_float4, float4, float4)
#pragma tg_funcdef(degrees, __degrees_float8, float8, float8)
#pragma tg_funcdef(degrees, __degrees_float16, float16, float16)
#pragma tg_funcdef(degrees, __degrees_double, double, double)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(degrees, __degrees_double2, double2, double2)
#pragma tg_funcdef(degrees, __degrees_double3, double3, double3)
#pragma tg_funcdef(degrees, __degrees_double4, double4, double4)
#pragma tg_funcdef(degrees, __degrees_double8, double8, double8)
#pragma tg_funcdef(degrees, __degrees_double16, double16, double16)
 #endif
#undef degrees
#define degrees(__a) __tg_builtin("degrees", __a)

#pragma tg_funcdef(max, max_tg, float, float, float)
#pragma tg_funcdef(max, max_tg, float2, float2, float)
#pragma tg_funcdef(max, max_tg, float3, float3, float)
#pragma tg_funcdef(max, max_tg, float4, float4, float)
#pragma tg_funcdef(max, max_tg, float8, float8, float)
#pragma tg_funcdef(max, max_tg, float16, float16, float)
#pragma tg_funcdef(max, max_tg, float2, float2, float2)
#pragma tg_funcdef(max, max_tg, float3, float3, float3)
#pragma tg_funcdef(max, max_tg, float4, float4, float4)
#pragma tg_funcdef(max, max_tg, float8, float8, float8)
#pragma tg_funcdef(max, max_tg, float16, float16, float16)

#pragma tg_funcdef(max, max_tg, double, double, double)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(max, max_tg, double2, double2, double)
#pragma tg_funcdef(max, max_tg, double3, double3, double)
#pragma tg_funcdef(max, max_tg, double4, double4, double)
#pragma tg_funcdef(max, max_tg, double8, double8, double)
#pragma tg_funcdef(max, max_tg, double16, double16, double)
#pragma tg_funcdef(max, max_tg, double2, double2, double2)
#pragma tg_funcdef(max, max_tg, double3, double3, double3)
#pragma tg_funcdef(max, max_tg, double4, double4, double4)
#pragma tg_funcdef(max, max_tg, double8, double8, double8)
#pragma tg_funcdef(max, max_tg, double16, double16, double16)
 #endif
#undef max
#define max(__a,__b) __tg_builtin_gentype("max",__a,__b)

#pragma tg_funcdef(min, min_tg, float, float, float)
#pragma tg_funcdef(min, min_tg, float2, float2, float)
#pragma tg_funcdef(min, min_tg, float3, float3, float)
#pragma tg_funcdef(min, min_tg, float4, float4, float)
#pragma tg_funcdef(min, min_tg, float8, float8, float)
#pragma tg_funcdef(min, min_tg, float16, float16, float)
#pragma tg_funcdef(min, min_tg, float2, float2, float2)
#pragma tg_funcdef(min, min_tg, float3, float3, float3)
#pragma tg_funcdef(min, min_tg, float4, float4, float4)
#pragma tg_funcdef(min, min_tg, float8, float8, float8)
#pragma tg_funcdef(min, min_tg, float16, float16, float16)

#pragma tg_funcdef(min, min_tg, double, double, double)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(min, min_tg, double2, double2, double)
#pragma tg_funcdef(min, min_tg, double3, double3, double)
#pragma tg_funcdef(min, min_tg, double4, double4, double)
#pragma tg_funcdef(min, min_tg, double8, double8, double)
#pragma tg_funcdef(min, min_tg, double16, double16, double)
#pragma tg_funcdef(min, min_tg, double2, double2, double2)
#pragma tg_funcdef(min, min_tg, double3, double3, double3)
#pragma tg_funcdef(min, min_tg, double4, double4, double4)
#pragma tg_funcdef(min, min_tg, double8, double8, double8)
#pragma tg_funcdef(min, min_tg, double16, double16, double16)
 #endif
#undef min
#define min(__a,__b) __tg_builtin_gentype("min",__a,__b)

#pragma tg_funcdef(mix, __mix_float, float, float, float, float)
#pragma tg_funcdef(mix, __mix_float2, float2, float2, float2, float2)
#pragma tg_funcdef(mix, __mix_float3, float3, float3, float3, float3)
#pragma tg_funcdef(mix, __mix_float4, float4, float4, float4, float4)
#pragma tg_funcdef(mix, __mix_float8, float8, float8, float8, float8)
#pragma tg_funcdef(mix, __mix_float16, float16, float16, float16, float16)

#pragma tg_funcdef(mix, __mix_float_float2, float2, float2, float2, float)
#pragma tg_funcdef(mix, __mix_float_float3, float3, float3, float3, float)
#pragma tg_funcdef(mix, __mix_float_float4, float4, float4, float4, float)
#pragma tg_funcdef(mix, __mix_float_float8, float8, float8, float8, float)
#pragma tg_funcdef(mix, __mix_float_float16, float16, float16, float16, float)

#pragma tg_funcdef(mix, __mix_double, double, double, double, double)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(mix, __mix_double2, double2, double2, double2, double2)
#pragma tg_funcdef(mix, __mix_double3, double3, double3, double3, double3)
#pragma tg_funcdef(mix, __mix_double4, double4, double4, double4, double4)
#pragma tg_funcdef(mix, __mix_double8, double8, double8, double8, double8)
#pragma tg_funcdef(mix, __mix_double16, double16, double16, double16, double16)

#pragma tg_funcdef(mix, __mix_double_double2, double2, double2, double2, double)
#pragma tg_funcdef(mix, __mix_double_double3, double3, double3, double3, double)
#pragma tg_funcdef(mix, __mix_double_double4, double4, double4, double4, double)
#pragma tg_funcdef(mix, __mix_double_double8, double8, double8, double8, double)
#pragma tg_funcdef(mix, __mix_double_double16, double16, double16, double16, double)
 #endif
#undef mix
#define mix(__a, __b, __c) __tg_builtin("mix", __a, __b, __c)

#pragma tg_funcdef(radians, __radians_float, float, float)
#pragma tg_funcdef(radians, __radians_float2, float2, float2)
#pragma tg_funcdef(radians, __radians_float3, float3, float3)
#pragma tg_funcdef(radians, __radians_float4, float4, float4)
#pragma tg_funcdef(radians, __radians_float8, float8, float8)
#pragma tg_funcdef(radians, __radians_float16, float16, float16)
#pragma tg_funcdef(radians, __radians_double, double, double)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(radians, __radians_double2, double2, double2)
#pragma tg_funcdef(radians, __radians_double3, double3, double3)
#pragma tg_funcdef(radians, __radians_double4, double4, double4)
#pragma tg_funcdef(radians, __radians_double8, double8, double8)
#pragma tg_funcdef(radians, __radians_double16, double16, double16)
 #endif
#undef radians
#define radians(__a) __tg_builtin("radians", __a)

#pragma tg_funcdef(step, __step_float, float, float, float)
#pragma tg_funcdef(step, __step_float2, float2, float2, float2)
#pragma tg_funcdef(step, __step_float3, float3, float3, float3)
#pragma tg_funcdef(step, __step_float4, float4, float4, float4)
#pragma tg_funcdef(step, __step_float8, float8, float8, float8)
#pragma tg_funcdef(step, __step_float16, float16, float16, float16)

#pragma tg_funcdef(step, __step_float_float2, float2, float, float2)
#pragma tg_funcdef(step, __step_float_float3, float3, float, float3)
#pragma tg_funcdef(step, __step_float_float4, float4, float, float4)
#pragma tg_funcdef(step, __step_float_float8, float8, float, float8)
#pragma tg_funcdef(step, __step_float_float16, float16, float, float16)

#pragma tg_funcdef(step, __step_double, double, double, double)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(step, __step_double2, double2, double2, double2)
#pragma tg_funcdef(step, __step_double3, double3, double3, double3)
#pragma tg_funcdef(step, __step_double4, double4, double4, double4)
#pragma tg_funcdef(step, __step_double8, double8, double8, double8)
#pragma tg_funcdef(step, __step_double16, double16, double16, double16)

#pragma tg_funcdef(step, __step_double_double2, double2, double, double2)
#pragma tg_funcdef(step, __step_double_double3, double3, double, double3)
#pragma tg_funcdef(step, __step_double_double4, double4, double, double4)
#pragma tg_funcdef(step, __step_double_double8, double8, double, double8)
#pragma tg_funcdef(step, __step_double_double16, double16, double, double16)
 #endif
#undef step
#define step(__a, __b) __tg_builtin("step", __a, __b)

#pragma tg_funcdef(smoothstep, __smoothstep_float, float, float, float, float)
#pragma tg_funcdef(smoothstep, __smoothstep_float2, float2, float2, float2, float2)
#pragma tg_funcdef(smoothstep, __smoothstep_float3, float3, float3, float3, float3)
#pragma tg_funcdef(smoothstep, __smoothstep_float4, float4, float4, float4, float4)
#pragma tg_funcdef(smoothstep, __smoothstep_float8, float8, float8, float8, float8)
#pragma tg_funcdef(smoothstep, __smoothstep_float16, float16, float16, float16, float16)

#pragma tg_funcdef(smoothstep, __smoothstep_float_float2, float2, float, float, float2)
#pragma tg_funcdef(smoothstep, __smoothstep_float_float3, float3, float, float, float3)
#pragma tg_funcdef(smoothstep, __smoothstep_float_float4, float4, float, float, float4)
#pragma tg_funcdef(smoothstep, __smoothstep_float_float8, float8, float, float, float8)
#pragma tg_funcdef(smoothstep, __smoothstep_float_float16, float16, float, float, float16)

#pragma tg_funcdef(smoothstep, __smoothstep_double, double, double, double, double)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(smoothstep, __smoothstep_double2, double2, double2, double2, double2)
#pragma tg_funcdef(smoothstep, __smoothstep_double3, double3, double3, double3, double3)
#pragma tg_funcdef(smoothstep, __smoothstep_double4, double4, double4, double4, double4)
#pragma tg_funcdef(smoothstep, __smoothstep_double8, double8, double8, double8, double8)
#pragma tg_funcdef(smoothstep, __smoothstep_double16, double16, double16, double16, double16)

#pragma tg_funcdef(smoothstep, __smoothstep_double_double2, double2, double, double, double2)
#pragma tg_funcdef(smoothstep, __smoothstep_double_double3, double3, double, double, double3)
#pragma tg_funcdef(smoothstep, __smoothstep_double_double4, double4, double, double, double4)
#pragma tg_funcdef(smoothstep, __smoothstep_double_double8, double8, double, double, double8)
#pragma tg_funcdef(smoothstep, __smoothstep_double_double16, double16, double, double, double16)
 #endif
#undef smoothstep
#define smoothstep(__a, __b, __c) __tg_builtin("smoothstep", __a, __b, __c)

#pragma tg_funcdef(sign, __sign_float, float, float)
#pragma tg_funcdef(sign, __sign_float2, float2, float2)
#pragma tg_funcdef(sign, __sign_float3, float3, float3)
#pragma tg_funcdef(sign, __sign_float4, float4, float4)
#pragma tg_funcdef(sign, __sign_float8, float8, float8)
#pragma tg_funcdef(sign, __sign_float16, float16, float16)
#pragma tg_funcdef(sign, __sign_double, double, double)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(sign, __sign_double2, double2, double2)
#pragma tg_funcdef(sign, __sign_double3, double3, double3)
#pragma tg_funcdef(sign, __sign_double4, double4, double4)
#pragma tg_funcdef(sign, __sign_double8, double8, double8)
#pragma tg_funcdef(sign, __sign_double16, double16, double16)
 #endif
#undef sign
#define sign(__a) __tg_builtin("sign", __a)

/* 6.11.5 Geometric */

#pragma tg_funcdef(cross, __cross_float3, float3, float3, float3)
#pragma tg_funcdef(cross, __cross_float4, float4, float4, float4)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(cross, __cross_double3, double3, double3, double3)
#pragma tg_funcdef(cross, __cross_double4, double4, double4, double4)
 #endif
#undef cross
#define cross(__a, __b) __tg_builtin("cross", __a, __b)

#pragma tg_funcdef(dot, __dot_float, float, float, float)
#pragma tg_funcdef(dot, __dot_float2, float, float2, float2)
#pragma tg_funcdef(dot, __dot_float3, float, float3, float3)
#pragma tg_funcdef(dot, __dot_float4, float, float4, float4)
#pragma tg_funcdef(dot, __dot_double, double, double, double)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(dot, __dot_double2, double, double2, double2)
#pragma tg_funcdef(dot, __dot_double3, double, double3, double3)
#pragma tg_funcdef(dot, __dot_double4, double, double4, double4)
 #endif
#undef dot
#define dot(__a, __b) __tg_builtin("dot", __a, __b)

#pragma tg_funcdef(distance, __distance_float, float, float, float)
#pragma tg_funcdef(distance, __distance_float2, float, float2, float2)
#pragma tg_funcdef(distance, __distance_float3, float, float3, float3)
#pragma tg_funcdef(distance, __distance_float4, float, float4, float4)
#pragma tg_funcdef(distance, __distance_double, double, double, double)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(distance, __distance_double2, double, double2, double2)
#pragma tg_funcdef(distance, __distance_double3, double, double3, double3)
#pragma tg_funcdef(distance, __distance_double4, double, double4, double4)
 #endif
#undef distance
#define distance(__a, __b) __tg_builtin("distance", __a, __b)

#pragma tg_funcdef(length, __length_float, float, float)
#pragma tg_funcdef(length, __length_float2, float, float2)
#pragma tg_funcdef(length, __length_float3, float, float3)
#pragma tg_funcdef(length, __length_float4, float, float4)
#pragma tg_funcdef(length, __length_double, double, double)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(length, __length_double2, double, double2)
#pragma tg_funcdef(length, __length_double3, double, double3)
#pragma tg_funcdef(length, __length_double4, double, double4)
 #endif
#undef length
#define length(__a) __tg_builtin("length", __a)

#pragma tg_funcdef(normalize, __normalize_float, float, float)
#pragma tg_funcdef(normalize, __normalize_float2, float2, float2)
#pragma tg_funcdef(normalize, __normalize_float3, float3, float3)
#pragma tg_funcdef(normalize, __normalize_float4, float4, float4)
#pragma tg_funcdef(normalize, __normalize_double, double, double)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(normalize, __normalize_double2, double2, double2)
#pragma tg_funcdef(normalize, __normalize_double3, double3, double3)
#pragma tg_funcdef(normalize, __normalize_double4, double4, double4)
 #endif
#undef normalize
#define normalize(__a) __tg_builtin("normalize", __a)

#pragma tg_funcdef(fast_distance, __fast_distance_float, float, float, float)
#pragma tg_funcdef(fast_distance, __fast_distance_float2, float, float2, float2)
#pragma tg_funcdef(fast_distance, __fast_distance_float3, float, float3, float3)
#pragma tg_funcdef(fast_distance, __fast_distance_float4, float, float4, float4)
#undef fast_distance
#define fast_distance(__a, __b) __tg_builtin("fast_distance", __a, __b)

#pragma tg_funcdef(fast_length, __fast_length_float, float, float)
#pragma tg_funcdef(fast_length, __fast_length_float2, float, float2)
#pragma tg_funcdef(fast_length, __fast_length_float3, float, float3)
#pragma tg_funcdef(fast_length, __fast_length_float4, float, float4)
#undef fast_length
#define fast_length(__a) __tg_builtin("fast_length", __a)

#pragma tg_funcdef(fast_normalize, __fast_normalize_float, float, float)
#pragma tg_funcdef(fast_normalize, __fast_normalize_float2, float2, float2)
#pragma tg_funcdef(fast_normalize, __fast_normalize_float3, float3, float3)
#pragma tg_funcdef(fast_normalize, __fast_normalize_float4, float4, float4)
#undef fast_normalize
#define fast_normalize(__a) __tg_builtin("fast_normalize", __a)

/* 6.14.6 Relational*/

#pragma tg_funcdef(isequal, __isequal_int, int, float, float)
#pragma tg_funcdef(isequal, __isequal_int2, int2, float2, float2)
#pragma tg_funcdef(isequal, __isequal_int3, int3, float3, float3)
#pragma tg_funcdef(isequal, __isequal_int4, int4, float4, float4)
#pragma tg_funcdef(isequal, __isequal_int8, int8, float8, float8)
#pragma tg_funcdef(isequal, __isequal_int16, int16, float16, float16)
#pragma tg_funcdef(isequal, __isequal_long, int, double, double)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(isequal, __isequal_long2, long2, double2, double2)
#pragma tg_funcdef(isequal, __isequal_long3, long3, double3, double3)
#pragma tg_funcdef(isequal, __isequal_long4, long4, double4, double4)
#pragma tg_funcdef(isequal, __isequal_long8, long8, double8, double8)
#pragma tg_funcdef(isequal, __isequal_long16, long16, double16, double16)
 #endif
#undef isequal
#define isequal(__a, __b) __tg_builtin("isequal",__a, __b)

#pragma tg_funcdef(isnotequal, __isnotequal_int, int, float, float)
#pragma tg_funcdef(isnotequal, __isnotequal_int2, int2, float2, float2)
#pragma tg_funcdef(isnotequal, __isnotequal_int3, int3, float3, float3)
#pragma tg_funcdef(isnotequal, __isnotequal_int4, int4, float4, float4)
#pragma tg_funcdef(isnotequal, __isnotequal_int8, int8, float8, float8)
#pragma tg_funcdef(isnotequal, __isnotequal_int16, int16, float16, float16)
#pragma tg_funcdef(isnotequal, __isnotequal_long, int, double, double)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(isnotequal, __isnotequal_long2, long2, double2, double2)
#pragma tg_funcdef(isnotequal, __isnotequal_long3, long3, double3, double3)
#pragma tg_funcdef(isnotequal, __isnotequal_long4, long4, double4, double4)
#pragma tg_funcdef(isnotequal, __isnotequal_long8, long8, double8, double8)
#pragma tg_funcdef(isnotequal, __isnotequal_long16, long16, double16, double16)
 #endif
#undef isnotequal
#define isnotequal(__a, __b) __tg_builtin("isnotequal",__a, __b)

#pragma tg_funcdef(isgreater, __isgreater_int, int, float, float)
#pragma tg_funcdef(isgreater, __isgreater_int2, int2, float2, float2)
#pragma tg_funcdef(isgreater, __isgreater_int3, int3, float3, float3)
#pragma tg_funcdef(isgreater, __isgreater_int4, int4, float4, float4)
#pragma tg_funcdef(isgreater, __isgreater_int8, int8, float8, float8)
#pragma tg_funcdef(isgreater, __isgreater_int16, int16, float16, float16)
#pragma tg_funcdef(isgreater, __isgreater_long, int, double, double)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(isgreater, __isgreater_long2, long2, double2, double2)
#pragma tg_funcdef(isgreater, __isgreater_long3, long3, double3, double3)
#pragma tg_funcdef(isgreater, __isgreater_long4, long4, double4, double4)
#pragma tg_funcdef(isgreater, __isgreater_long8, long8, double8, double8)
#pragma tg_funcdef(isgreater, __isgreater_long16, long16, double16, double16)
 #endif
#undef isgreater
#define isgreater(__a, __b) __tg_builtin("isgreater",__a, __b)

#pragma tg_funcdef(isgreaterequal, __isgreaterequal_int, int, float, float)
#pragma tg_funcdef(isgreaterequal, __isgreaterequal_int2, int2, float2, float2)
#pragma tg_funcdef(isgreaterequal, __isgreaterequal_int3, int3, float3, float3)
#pragma tg_funcdef(isgreaterequal, __isgreaterequal_int4, int4, float4, float4)
#pragma tg_funcdef(isgreaterequal, __isgreaterequal_int8, int8, float8, float8)
#pragma tg_funcdef(isgreaterequal, __isgreaterequal_int16, int16, float16, float16)
#pragma tg_funcdef(isgreaterequal, __isgreaterequal_long, int, double, double)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(isgreaterequal, __isgreaterequal_long2, long2, double2, double2)
#pragma tg_funcdef(isgreaterequal, __isgreaterequal_long3, long3, double3, double3)
#pragma tg_funcdef(isgreaterequal, __isgreaterequal_long4, long4, double4, double4)
#pragma tg_funcdef(isgreaterequal, __isgreaterequal_long8, long8, double8, double8)
#pragma tg_funcdef(isgreaterequal, __isgreaterequal_long16, long16, double16, double16)
 #endif
#undef isgreaterequal
#define isgreaterequal(__a, __b) __tg_builtin("isgreaterequal",__a, __b)

#pragma tg_funcdef(isless, __isless_int, int, float, float)
#pragma tg_funcdef(isless, __isless_int2, int2, float2, float2) 
#pragma tg_funcdef(isless, __isless_int3, int3, float3, float3) 
#pragma tg_funcdef(isless, __isless_int4, int4, float4, float4) 
#pragma tg_funcdef(isless, __isless_int8, int8, float8, float8) 
#pragma tg_funcdef(isless, __isless_int16, int16, float16, float16)
#pragma tg_funcdef(isless, __isless_long, int, double, double)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(isless, __isless_long2, long2, double2, double2) 
#pragma tg_funcdef(isless, __isless_long3, long3, double3, double3) 
#pragma tg_funcdef(isless, __isless_long4, long4, double4, double4) 
#pragma tg_funcdef(isless, __isless_long8, long8, double8, double8) 
#pragma tg_funcdef(isless, __isless_long16, long16, double16, double16)
 #endif
#undef isless
#define isless(__a, __b) __tg_builtin("isless",__a, __b)

#pragma tg_funcdef(islessequal, __islessequal_int, int, float, float)
#pragma tg_funcdef(islessequal, __islessequal_int2, int2, float2, float2)
#pragma tg_funcdef(islessequal, __islessequal_int3, int3, float3, float3)
#pragma tg_funcdef(islessequal, __islessequal_int4, int4, float4, float4)
#pragma tg_funcdef(islessequal, __islessequal_int8, int8, float8, float8)
#pragma tg_funcdef(islessequal, __islessequal_int16, int16, float16, float16)
#pragma tg_funcdef(islessequal, __islessequal_long, int, double, double)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(islessequal, __islessequal_long2, long2, double2, double2)
#pragma tg_funcdef(islessequal, __islessequal_long3, long3, double3, double3)
#pragma tg_funcdef(islessequal, __islessequal_long4, long4, double4, double4)
#pragma tg_funcdef(islessequal, __islessequal_long8, long8, double8, double8)
#pragma tg_funcdef(islessequal, __islessequal_long16, long16, double16, double16)
 #endif
#undef islessequal
#define islessequal(__a, __b) __tg_builtin("islessequal",__a, __b)

#pragma tg_funcdef(islessgreater, __islessgreater_int, int, float, float)
#pragma tg_funcdef(islessgreater, __islessgreater_int2, int2, float2, float2)
#pragma tg_funcdef(islessgreater, __islessgreater_int3, int3, float3, float3)
#pragma tg_funcdef(islessgreater, __islessgreater_int4, int4, float4, float4)
#pragma tg_funcdef(islessgreater, __islessgreater_int8, int8, float8, float8)
#pragma tg_funcdef(islessgreater, __islessgreater_int16, int16, float16, float16)
#pragma tg_funcdef(islessgreater, __islessgreater_long, int, double, double)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(islessgreater, __islessgreater_long2, long2, double2, double2)
#pragma tg_funcdef(islessgreater, __islessgreater_long3, long3, double3, double3)
#pragma tg_funcdef(islessgreater, __islessgreater_long4, long4, double4, double4)
#pragma tg_funcdef(islessgreater, __islessgreater_long8, long8, double8, double8)
#pragma tg_funcdef(islessgreater, __islessgreater_long16, long16, double16, double16)
 #endif
#undef islessgreater
#define islessgreater(__a, __b) __tg_builtin("islessgreater",__a, __b)

#pragma tg_funcdef(isfinite, __isfinite_int, int, float)
#pragma tg_funcdef(isfinite, __isfinite_int2, int2, float2)
#pragma tg_funcdef(isfinite, __isfinite_int3, int3, float3)
#pragma tg_funcdef(isfinite, __isfinite_int4, int4, float4)
#pragma tg_funcdef(isfinite, __isfinite_int8, int8, float8)
#pragma tg_funcdef(isfinite, __isfinite_int16, int16, float16)
#pragma tg_funcdef(isfinite, __isfinite_long, int, double)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(isfinite, __isfinite_long2, long2, double2)
#pragma tg_funcdef(isfinite, __isfinite_long3, long3, double3)
#pragma tg_funcdef(isfinite, __isfinite_long4, long4, double4)
#pragma tg_funcdef(isfinite, __isfinite_long8, long8, double8)
#pragma tg_funcdef(isfinite, __isfinite_long16, long16, double16)
 #endif
#undef isfinite
#define isfinite(__a) __tg_builtin("isfinite",__a)

#pragma tg_funcdef(isinf, __isinf_int, int, float)
#pragma tg_funcdef(isinf, __isinf_int2, int2, float2)
#pragma tg_funcdef(isinf, __isinf_int3, int3, float3)
#pragma tg_funcdef(isinf, __isinf_int4, int4, float4)
#pragma tg_funcdef(isinf, __isinf_int8, int8, float8)
#pragma tg_funcdef(isinf, __isinf_int16, int16, float16)
#pragma tg_funcdef(isinf, __isinf_long, int, double)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(isinf, __isinf_long2, long2, double2)
#pragma tg_funcdef(isinf, __isinf_long3, long3, double3)
#pragma tg_funcdef(isinf, __isinf_long4, long4, double4)
#pragma tg_funcdef(isinf, __isinf_long8, long8, double8)
#pragma tg_funcdef(isinf, __isinf_long16, long16, double16)
 #endif
#undef isinf
#define isinf(__a) __tg_builtin("isinf", __a)

#pragma tg_funcdef(isnan, __isnan_int, int, float)
#pragma tg_funcdef(isnan, __isnan_int2, int2, float2)
#pragma tg_funcdef(isnan, __isnan_int3, int3, float3)
#pragma tg_funcdef(isnan, __isnan_int4, int4, float4)
#pragma tg_funcdef(isnan, __isnan_int8, int8, float8)
#pragma tg_funcdef(isnan, __isnan_int16, int16, float16)
#pragma tg_funcdef(isnan, __isnan_long, int, double)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(isnan, __isnan_long2, long2, double2)
#pragma tg_funcdef(isnan, __isnan_long3, long3, double3)
#pragma tg_funcdef(isnan, __isnan_long4, long4, double4)
#pragma tg_funcdef(isnan, __isnan_long8, long8, double8)
#pragma tg_funcdef(isnan, __isnan_long16, long16, double16)
 #endif
#undef isnan
#define isnan(__a) __tg_builtin("isnan",__a)

#pragma tg_funcdef(isnormal, __isnormal_int, int, float)
#pragma tg_funcdef(isnormal, __isnormal_int2, int2, float2)
#pragma tg_funcdef(isnormal, __isnormal_int3, int3, float3)
#pragma tg_funcdef(isnormal, __isnormal_int4, int4, float4)
#pragma tg_funcdef(isnormal, __isnormal_int8, int8, float8)
#pragma tg_funcdef(isnormal, __isnormal_int16, int16, float16)
#pragma tg_funcdef(isnormal, __isnormal_long, int, double)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(isnormal, __isnormal_long2, long2, double2)
#pragma tg_funcdef(isnormal, __isnormal_long3, long3, double3)
#pragma tg_funcdef(isnormal, __isnormal_long4, long4, double4)
#pragma tg_funcdef(isnormal, __isnormal_long8, long8, double8)
#pragma tg_funcdef(isnormal, __isnormal_long16, long16, double16)
 #endif
#undef isnormal
#define isnormal(__a) __tg_builtin("isnormal",__a)

#pragma tg_funcdef(isordered, __isordered_int, int, float, float)
#pragma tg_funcdef(isordered, __isordered_int2, int2, float2, float2)
#pragma tg_funcdef(isordered, __isordered_int3, int3, float3, float3)
#pragma tg_funcdef(isordered, __isordered_int4, int4, float4, float4)
#pragma tg_funcdef(isordered, __isordered_int8, int8, float8, float8)
#pragma tg_funcdef(isordered, __isordered_int16, int16, float16, float16)
#pragma tg_funcdef(isordered, __isordered_long, int, double, double)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(isordered, __isordered_long2, long2, double2, double2)
#pragma tg_funcdef(isordered, __isordered_long3, long3, double3, double3)
#pragma tg_funcdef(isordered, __isordered_long4, long4, double4, double4)
#pragma tg_funcdef(isordered, __isordered_long8, long8, double8, double8)
#pragma tg_funcdef(isordered, __isordered_long16, long16, double16, double16)
 #endif
#undef isordered
#define isordered(__a, __b) __tg_builtin("isordered",__a, __b)

#pragma tg_funcdef(isunordered, __isunordered_int, int, float, float)
#pragma tg_funcdef(isunordered, __isunordered_int2, int2, float2, float2)
#pragma tg_funcdef(isunordered, __isunordered_int3, int3, float3, float3)
#pragma tg_funcdef(isunordered, __isunordered_int4, int4, float4, float4)
#pragma tg_funcdef(isunordered, __isunordered_int8, int8, float8, float8)
#pragma tg_funcdef(isunordered, __isunordered_int16, int16, float16, float16)
#pragma tg_funcdef(isunordered, __isunordered_long, int, double, double)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(isunordered, __isunordered_long2, long2, double2, double2)
#pragma tg_funcdef(isunordered, __isunordered_long3, long3, double3, double3)
#pragma tg_funcdef(isunordered, __isunordered_long4, long4, double4, double4)
#pragma tg_funcdef(isunordered, __isunordered_long8, long8, double8, double8)
#pragma tg_funcdef(isunordered, __isunordered_long16, long16, double16, double16)
 #endif
#undef isunordered
#define isunordered(__a, __b) __tg_builtin("isunordered",__a, __b)

#pragma tg_funcdef(signbit, __signbit_int, int, float)
#pragma tg_funcdef(signbit, __signbit_int2, int2, float2)
#pragma tg_funcdef(signbit, __signbit_int3, int3, float3)
#pragma tg_funcdef(signbit, __signbit_int4, int4, float4)
#pragma tg_funcdef(signbit, __signbit_int8, int8, float8)
#pragma tg_funcdef(signbit, __signbit_int16, int16, float16)
#pragma tg_funcdef(signbit, __signbit_long, int, double)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(signbit, __signbit_long2, long2, double2)
#pragma tg_funcdef(signbit, __signbit_long3, long3, double3)
#pragma tg_funcdef(signbit, __signbit_long4, long4, double4)
#pragma tg_funcdef(signbit, __signbit_long8, long8, double8)
#pragma tg_funcdef(signbit, __signbit_long16, long16, double16)
 #endif
#undef signbit
#define signbit(__a) __tg_builtin("signbit", __a)

#pragma tg_funcdef(any, any_tg, int, char)
#pragma tg_funcdef(any, any_tg, int, char2)
#pragma tg_funcdef(any, any_tg, int, char3)
#pragma tg_funcdef(any, any_tg, int, char4)
#pragma tg_funcdef(any, any_tg, int, char8)
#pragma tg_funcdef(any, any_tg, int, char16)
#pragma tg_funcdef(any, any_tg, int, short)
#pragma tg_funcdef(any, any_tg, int, short2)
#pragma tg_funcdef(any, any_tg, int, short3)
#pragma tg_funcdef(any, any_tg, int, short4)
#pragma tg_funcdef(any, any_tg, int, short8)
#pragma tg_funcdef(any, any_tg, int, short16)
#pragma tg_funcdef(any, any_tg, int, int)
#pragma tg_funcdef(any, any_tg, int, int2)
#pragma tg_funcdef(any, any_tg, int, int3)
#pragma tg_funcdef(any, any_tg, int, int4)
#pragma tg_funcdef(any, any_tg, int, int8)
#pragma tg_funcdef(any, any_tg, int, int16)
#pragma tg_funcdef(any, any_tg, int, long)
#pragma tg_funcdef(any, any_tg, int, long2)
#pragma tg_funcdef(any, any_tg, int, long3)
#pragma tg_funcdef(any, any_tg, int, long4)
#pragma tg_funcdef(any, any_tg, int, long8)
#pragma tg_funcdef(any, any_tg, int, long16)
#undef any
#define any(__a) __tg_builtin_gentype("any",__a)

#pragma tg_funcdef(all, all_tg, int, char)
#pragma tg_funcdef(all, all_tg, int, char2)
#pragma tg_funcdef(all, all_tg, int, char3)
#pragma tg_funcdef(all, all_tg, int, char4)
#pragma tg_funcdef(all, all_tg, int, char8)
#pragma tg_funcdef(all, all_tg, int, char16)
#pragma tg_funcdef(all, all_tg, int, short)
#pragma tg_funcdef(all, all_tg, int, short2)
#pragma tg_funcdef(all, all_tg, int, short3)
#pragma tg_funcdef(all, all_tg, int, short4)
#pragma tg_funcdef(all, all_tg, int, short8)
#pragma tg_funcdef(all, all_tg, int, short16)
#pragma tg_funcdef(all, all_tg, int, int)
#pragma tg_funcdef(all, all_tg, int, int2)
#pragma tg_funcdef(all, all_tg, int, int3)
#pragma tg_funcdef(all, all_tg, int, int4)
#pragma tg_funcdef(all, all_tg, int, int8)
#pragma tg_funcdef(all, all_tg, int, int16)
#pragma tg_funcdef(all, all_tg, int, long)
#pragma tg_funcdef(all, all_tg, int, long2)
#pragma tg_funcdef(all, all_tg, int, long3)
#pragma tg_funcdef(all, all_tg, int, long4)
#pragma tg_funcdef(all, all_tg, int, long8)
#pragma tg_funcdef(all, all_tg, int, long16)
#undef all
#define all(__a) __tg_builtin_gentype("all",__a)

#pragma tg_funcdef(bitselect, bitselect_tg, uchar, uchar, uchar, uchar)
#pragma tg_funcdef(bitselect, bitselect_tg, uchar2, uchar2, uchar2, uchar2)
#pragma tg_funcdef(bitselect, bitselect_tg, uchar3, uchar3, uchar3, uchar3)
#pragma tg_funcdef(bitselect, bitselect_tg, uchar4, uchar4, uchar4, uchar4)
#pragma tg_funcdef(bitselect, bitselect_tg, uchar8, uchar8, uchar8, uchar8)
#pragma tg_funcdef(bitselect, bitselect_tg, uchar16, uchar16, uchar16, uchar16)

#pragma tg_funcdef(bitselect, bitselect_tg, char, char, char, char)
#pragma tg_funcdef(bitselect, bitselect_tg, char2, char2, char2, char2)
#pragma tg_funcdef(bitselect, bitselect_tg, char3, char3, char3, char3)
#pragma tg_funcdef(bitselect, bitselect_tg, char4, char4, char4, char4)
#pragma tg_funcdef(bitselect, bitselect_tg, char8, char8, char8, char8)
#pragma tg_funcdef(bitselect, bitselect_tg, char16, char16, char16, char16)

#pragma tg_funcdef(bitselect, bitselect_tg, ushort, ushort, ushort, ushort)
#pragma tg_funcdef(bitselect, bitselect_tg, ushort2, ushort2, ushort2, ushort2)
#pragma tg_funcdef(bitselect, bitselect_tg, ushort3, ushort3, ushort3, ushort3)
#pragma tg_funcdef(bitselect, bitselect_tg, ushort4, ushort4, ushort4, ushort4)
#pragma tg_funcdef(bitselect, bitselect_tg, ushort8, ushort8, ushort8, ushort8)
#pragma tg_funcdef(bitselect, bitselect_tg, ushort16, ushort16, ushort16, ushort16)

#pragma tg_funcdef(bitselect, bitselect_tg, short, short, short, short)
#pragma tg_funcdef(bitselect, bitselect_tg, short2, short2, short2, short2)
#pragma tg_funcdef(bitselect, bitselect_tg, short3, short3, short3, short3)
#pragma tg_funcdef(bitselect, bitselect_tg, short4, short4, short4, short4)
#pragma tg_funcdef(bitselect, bitselect_tg, short8, short8, short8, short8)
#pragma tg_funcdef(bitselect, bitselect_tg, short16, short16, short16, short16)

#pragma tg_funcdef(bitselect, bitselect_tg, uint, uint, uint, uint)
#pragma tg_funcdef(bitselect, bitselect_tg, uint2, uint2, uint2, uint2) 
#pragma tg_funcdef(bitselect, bitselect_tg, uint3, uint3, uint3, uint3) 
#pragma tg_funcdef(bitselect, bitselect_tg, uint4, uint4, uint4, uint4) 
#pragma tg_funcdef(bitselect, bitselect_tg, uint8, uint8, uint8, uint8) 
#pragma tg_funcdef(bitselect, bitselect_tg, uint16, uint16, uint16, uint16)

#pragma tg_funcdef(bitselect, bitselect_tg, int, int, int, int)
#pragma tg_funcdef(bitselect, bitselect_tg, int2, int2, int2, int2) 
#pragma tg_funcdef(bitselect, bitselect_tg, int3, int3, int3, int3) 
#pragma tg_funcdef(bitselect, bitselect_tg, int4, int4, int4, int4) 
#pragma tg_funcdef(bitselect, bitselect_tg, int8, int8, int8, int8) 
#pragma tg_funcdef(bitselect, bitselect_tg, int16, int16, int16, int16)

#pragma tg_funcdef(bitselect, bitselect_tg, ulong, ulong, ulong, ulong)
#pragma tg_funcdef(bitselect, bitselect_tg, ulong2, ulong2, ulong2, ulong2)
#pragma tg_funcdef(bitselect, bitselect_tg, ulong3, ulong3, ulong3, ulong3)
#pragma tg_funcdef(bitselect, bitselect_tg, ulong4, ulong4, ulong4, ulong4)
#pragma tg_funcdef(bitselect, bitselect_tg, ulong8, ulong8, ulong8, ulong8)
#pragma tg_funcdef(bitselect, bitselect_tg, ulong16, ulong16, ulong16, ulong16)

#pragma tg_funcdef(bitselect, bitselect_tg, long, long, long, long)
#pragma tg_funcdef(bitselect, bitselect_tg, long2, long2, long2, long2)
#pragma tg_funcdef(bitselect, bitselect_tg, long3, long3, long3, long3)
#pragma tg_funcdef(bitselect, bitselect_tg, long4, long4, long4, long4)
#pragma tg_funcdef(bitselect, bitselect_tg, long8, long8, long8, long8)
#pragma tg_funcdef(bitselect, bitselect_tg, long16, long16, long16, long16)

#pragma tg_funcdef(bitselect, bitselect_tg, float, float, float, float)
#pragma tg_funcdef(bitselect, bitselect_tg, float2, float2, float2, float2)
#pragma tg_funcdef(bitselect, bitselect_tg, float3, float3, float3, float3)
#pragma tg_funcdef(bitselect, bitselect_tg, float4, float4, float4, float4)
#pragma tg_funcdef(bitselect, bitselect_tg, float8, float8, float8, float8)
#pragma tg_funcdef(bitselect, bitselect_tg, float16, float16, float16, float16)

#pragma tg_funcdef(bitselect, bitselect_tg, double, double, double, double)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(bitselect, bitselect_tg, double2, double2, double2, double2)
#pragma tg_funcdef(bitselect, bitselect_tg, double3, double3, double3, double3)
#pragma tg_funcdef(bitselect, bitselect_tg, double4, double4, double4, double4)
#pragma tg_funcdef(bitselect, bitselect_tg, double8, double8, double8, double8)
#pragma tg_funcdef(bitselect, bitselect_tg, double16, double16, double16, double16)
 #endif
#undef bitselect
#define bitselect(__a,__b,__c) __tg_builtin_gentype("bitselect",__a,__b,__c)

#pragma tg_funcdef(select, select_tg, uchar, uchar, uchar, uchar) 
#pragma tg_funcdef(select, select_tg, uchar2, uchar2, uchar2, uchar2)
#pragma tg_funcdef(select, select_tg, uchar3, uchar3, uchar3, uchar3)
#pragma tg_funcdef(select, select_tg, uchar4, uchar4, uchar4, uchar4)
#pragma tg_funcdef(select, select_tg, uchar8, uchar8, uchar8, uchar8)
#pragma tg_funcdef(select, select_tg, uchar16, uchar16, uchar16, uchar16)

#pragma tg_funcdef(select, select_tg, uchar, uchar, uchar, char) 
#pragma tg_funcdef(select, select_tg, uchar2, uchar2, uchar2, char2)
#pragma tg_funcdef(select, select_tg, uchar3, uchar3, uchar3, char3)
#pragma tg_funcdef(select, select_tg, uchar4, uchar4, uchar4, char4)
#pragma tg_funcdef(select, select_tg, uchar8, uchar8, uchar8, char8)
#pragma tg_funcdef(select, select_tg, uchar16, uchar16, uchar16, char16)

#pragma tg_funcdef(select, select_tg, char, char, char, uchar) 
#pragma tg_funcdef(select, select_tg, char2, char2, char2, uchar2)
#pragma tg_funcdef(select, select_tg, char3, char3, char3, uchar3)
#pragma tg_funcdef(select, select_tg, char4, char4, char4, uchar4)
#pragma tg_funcdef(select, select_tg, char8, char8, char8, uchar8)
#pragma tg_funcdef(select, select_tg, char16, char16, char16, uchar16)

#pragma tg_funcdef(select, select_tg, char, char, char, char) 
#pragma tg_funcdef(select, select_tg, char2, char2, char2, char2)
#pragma tg_funcdef(select, select_tg, char3, char3, char3, char3)
#pragma tg_funcdef(select, select_tg, char4, char4, char4, char4)
#pragma tg_funcdef(select, select_tg, char8, char8, char8, char8)
#pragma tg_funcdef(select, select_tg, char16, char16, char16, char16)

#pragma tg_funcdef(select, select_tg, ushort, ushort,  ushort, ushort)
#pragma tg_funcdef(select, select_tg, ushort2, ushort2, ushort2, ushort2)
#pragma tg_funcdef(select, select_tg, ushort3, ushort3, ushort3, ushort3)
#pragma tg_funcdef(select, select_tg, ushort4, ushort4, ushort4, ushort4)
#pragma tg_funcdef(select, select_tg, ushort8, ushort8, ushort8, ushort8)
#pragma tg_funcdef(select, select_tg, ushort16, ushort16, ushort16, ushort16)

#pragma tg_funcdef(select, select_tg, ushort, ushort,  ushort, short)
#pragma tg_funcdef(select, select_tg, ushort2, ushort2, ushort2, short2)
#pragma tg_funcdef(select, select_tg, ushort3, ushort3, ushort3, short3)
#pragma tg_funcdef(select, select_tg, ushort4, ushort4, ushort4, short4)
#pragma tg_funcdef(select, select_tg, ushort8, ushort8, ushort8, short8)
#pragma tg_funcdef(select, select_tg, ushort16, ushort16, ushort16, short16)

#pragma tg_funcdef(select, select_tg, short, short, short, ushort)
#pragma tg_funcdef(select, select_tg, short2, short2, short2, ushort2)
#pragma tg_funcdef(select, select_tg, short3, short3, short3, ushort3)
#pragma tg_funcdef(select, select_tg, short4, short4, short4, ushort4)
#pragma tg_funcdef(select, select_tg, short8, short8, short8, ushort8)
#pragma tg_funcdef(select, select_tg, short16, short16, short16, ushort16)

#pragma tg_funcdef(select, select_tg, short, short, short, short)
#pragma tg_funcdef(select, select_tg, short2, short2, short2, short2)
#pragma tg_funcdef(select, select_tg, short3, short3, short3, short3)
#pragma tg_funcdef(select, select_tg, short4, short4, short4, short4)
#pragma tg_funcdef(select, select_tg, short8, short8, short8, short8)
#pragma tg_funcdef(select, select_tg, short16, short16, short16, short16)

#pragma tg_funcdef(select, select_tg, uint, uint,  uint, uint)
#pragma tg_funcdef(select, select_tg, uint2, uint2, uint2, uint2) 
#pragma tg_funcdef(select, select_tg, uint3, uint3, uint3, uint3) 
#pragma tg_funcdef(select, select_tg, uint4, uint4, uint4, uint4) 
#pragma tg_funcdef(select, select_tg, uint8, uint8, uint8, uint8) 
#pragma tg_funcdef(select, select_tg, uint16, uint16, uint16, uint16)

#pragma tg_funcdef(select, select_tg, uint, uint,  uint, int)
#pragma tg_funcdef(select, select_tg, uint2, uint2, uint2, int2) 
#pragma tg_funcdef(select, select_tg, uint3, uint3, uint3, int3) 
#pragma tg_funcdef(select, select_tg, uint4, uint4, uint4, int4) 
#pragma tg_funcdef(select, select_tg, uint8, uint8, uint8, int8) 
#pragma tg_funcdef(select, select_tg, uint16, uint16, uint16, int16)

#pragma tg_funcdef(select, select_tg, int, int, int, uint)
#pragma tg_funcdef(select, select_tg, int2, int2, int2, uint2)
#pragma tg_funcdef(select, select_tg, int3, int3, int3, uint3)
#pragma tg_funcdef(select, select_tg, int4, int4, int4, uint4)
#pragma tg_funcdef(select, select_tg, int8, int8, int8, uint8)
#pragma tg_funcdef(select, select_tg, int16, int16, int16, uint16)

#pragma tg_funcdef(select, select_tg, int, int, int, int)
#pragma tg_funcdef(select, select_tg, int2, int2, int2, int2)
#pragma tg_funcdef(select, select_tg, int3, int3, int3, int3)
#pragma tg_funcdef(select, select_tg, int4, int4, int4, int4)
#pragma tg_funcdef(select, select_tg, int8, int8, int8, int8)
#pragma tg_funcdef(select, select_tg, int16, int16, int16, int16)

#pragma tg_funcdef(select, select_tg, ulong, ulong, ulong, ulong) 
#pragma tg_funcdef(select, select_tg, ulong2, ulong2, ulong2, ulong2)
#pragma tg_funcdef(select, select_tg, ulong3, ulong3, ulong3, ulong3)
#pragma tg_funcdef(select, select_tg, ulong4, ulong4, ulong4, ulong4)
#pragma tg_funcdef(select, select_tg, ulong8, ulong8, ulong8, ulong8)
#pragma tg_funcdef(select, select_tg, ulong16, ulong16, ulong16, ulong16)

#pragma tg_funcdef(select, select_tg, ulong, ulong, ulong, long) 
#pragma tg_funcdef(select, select_tg, ulong2, ulong2, ulong2, long2)
#pragma tg_funcdef(select, select_tg, ulong3, ulong3, ulong3, long3)
#pragma tg_funcdef(select, select_tg, ulong4, ulong4, ulong4, long4)
#pragma tg_funcdef(select, select_tg, ulong8, ulong8, ulong8, long8)
#pragma tg_funcdef(select, select_tg, ulong16, ulong16, ulong16, long16)

#pragma tg_funcdef(select, select_tg, long, long, long, ulong) 
#pragma tg_funcdef(select, select_tg, long2, long2, long2, ulong2)
#pragma tg_funcdef(select, select_tg, long3, long3, long3, ulong3)
#pragma tg_funcdef(select, select_tg, long4, long4, long4, ulong4)
#pragma tg_funcdef(select, select_tg, long8, long8, long8, ulong8)
#pragma tg_funcdef(select, select_tg, long16, long16, long16, ulong16)

#pragma tg_funcdef(select, select_tg, long, long, long, long) 
#pragma tg_funcdef(select, select_tg, long2, long2, long2, long2)
#pragma tg_funcdef(select, select_tg, long3, long3, long3, long3)
#pragma tg_funcdef(select, select_tg, long4, long4, long4, long4)
#pragma tg_funcdef(select, select_tg, long8, long8, long8, long8)
#pragma tg_funcdef(select, select_tg, long16, long16, long16, long16)

#pragma tg_funcdef(select, select_tg, float, float, float, uint)
#pragma tg_funcdef(select, select_tg, float2, float2, float2, uint2)
#pragma tg_funcdef(select, select_tg, float3, float3, float3, uint3)
#pragma tg_funcdef(select, select_tg, float4, float4, float4, uint4)
#pragma tg_funcdef(select, select_tg, float8, float8, float8, uint8)
#pragma tg_funcdef(select, select_tg, float16, float16, float16, uint16)

#pragma tg_funcdef(select, select_tg, float, float, float, int)
#pragma tg_funcdef(select, select_tg, float2, float2, float2, int2)
#pragma tg_funcdef(select, select_tg, float3, float3, float3, int3)
#pragma tg_funcdef(select, select_tg, float4, float4, float4, int4)
#pragma tg_funcdef(select, select_tg, float8, float8, float8, int8)
#pragma tg_funcdef(select, select_tg, float16, float16, float16, int16)

#pragma tg_funcdef(select, select_tg, double, double, double, long)
#pragma tg_funcdef(select, select_tg, double, double, double, ulong)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(select, select_tg, double2, double2, double2, long2)
#pragma tg_funcdef(select, select_tg, double3, double3, double3, long3)
#pragma tg_funcdef(select, select_tg, double4, double4, double4, long4)
#pragma tg_funcdef(select, select_tg, double8, double8, double8, long8)
#pragma tg_funcdef(select, select_tg, double16, double16, double16, long16)

#pragma tg_funcdef(select, select_tg, double2, double2, double2, ulong2)
#pragma tg_funcdef(select, select_tg, double3, double3, double3, ulong3)
#pragma tg_funcdef(select, select_tg, double4, double4, double4, ulong4)
#pragma tg_funcdef(select, select_tg, double8, double8, double8, ulong8)
#pragma tg_funcdef(select, select_tg, double16, double16, double16, ulong16)
 #endif
#undef select
#define select(__a,__b,__c) __tg_builtin_gentype("select",__a,__b,__c)

/* 6.11.7.Vector Data Load and Store Functions */

/* vloadn */
#pragma tg_funcdef(vload,   __vload_tg, char,     size_t, __global char*)
#pragma tg_funcdef(vload,   __vload_tg, short,    size_t, __global short*)
#pragma tg_funcdef(vload,   __vload_tg, int,      size_t, __global int*)
#pragma tg_funcdef(vload,   __vload_tg, long,     size_t, __global long*)
#pragma tg_funcdef(vload,   __vload_tg, float,    size_t, __global float*)
#pragma tg_funcdef(vload,   __vload_tg, uchar,    size_t, __global uchar*)
#pragma tg_funcdef(vload,   __vload_tg, ushort,   size_t, __global ushort*)
#pragma tg_funcdef(vload,   __vload_tg, uint,     size_t, __global uint*)
#pragma tg_funcdef(vload,   __vload_tg, ulong,    size_t, __global ulong*)
#pragma tg_funcdef(vload,   __vload_tg, char,     size_t, __local char*)
#pragma tg_funcdef(vload,   __vload_tg, short,    size_t, __local short*)
#pragma tg_funcdef(vload,   __vload_tg, int,      size_t, __local int*)
#pragma tg_funcdef(vload,   __vload_tg, long,     size_t, __local long*)
#pragma tg_funcdef(vload,   __vload_tg, float,    size_t, __local float*)
#pragma tg_funcdef(vload,   __vload_tg, uchar,    size_t, __local uchar*)
#pragma tg_funcdef(vload,   __vload_tg, ushort,   size_t, __local ushort*)
#pragma tg_funcdef(vload,   __vload_tg, uint,     size_t, __local uint*)
#pragma tg_funcdef(vload,   __vload_tg, ulong,    size_t, __local ulong*)
#pragma tg_funcdef(vload,   __vload_tg, char,     size_t, __constant char*)
#pragma tg_funcdef(vload,   __vload_tg, short,    size_t, __constant short*)
#pragma tg_funcdef(vload,   __vload_tg, int,      size_t, __constant int*)
#pragma tg_funcdef(vload,   __vload_tg, long,     size_t, __constant long*)
#pragma tg_funcdef(vload,   __vload_tg, float,    size_t, __constant float*)
#pragma tg_funcdef(vload,   __vload_tg, uchar,    size_t, __constant uchar*)
#pragma tg_funcdef(vload,   __vload_tg, ushort,   size_t, __constant ushort*)
#pragma tg_funcdef(vload,   __vload_tg, uint,     size_t, __constant uint*)
#pragma tg_funcdef(vload,   __vload_tg, ulong,    size_t, __constant ulong*)
#pragma tg_funcdef(vload,   __vload_tg, char,     size_t, __private char*)
#pragma tg_funcdef(vload,   __vload_tg, short,    size_t, __private short*)
#pragma tg_funcdef(vload,   __vload_tg, int,      size_t, __private int*)
#pragma tg_funcdef(vload,   __vload_tg, long,     size_t, __private long*)
#pragma tg_funcdef(vload,   __vload_tg, float,    size_t, __private float*)
#pragma tg_funcdef(vload,   __vload_tg, uchar,    size_t, __private uchar*)
#pragma tg_funcdef(vload,   __vload_tg, ushort,   size_t, __private ushort*)
#pragma tg_funcdef(vload,   __vload_tg, uint,     size_t, __private uint*)
#pragma tg_funcdef(vload,   __vload_tg, ulong,    size_t, __private ulong*)
#pragma tg_funcdef(vload,   __vload_tg, char,     size_t, const __global char*)
#pragma tg_funcdef(vload,   __vload_tg, short,    size_t, const __global short*)
#pragma tg_funcdef(vload,   __vload_tg, int,      size_t, const __global int*)
#pragma tg_funcdef(vload,   __vload_tg, long,     size_t, const __global long*)
#pragma tg_funcdef(vload,   __vload_tg, float,    size_t, const __global float*)
#pragma tg_funcdef(vload,   __vload_tg, uchar,    size_t, const __global uchar*)
#pragma tg_funcdef(vload,   __vload_tg, ushort,   size_t, const __global ushort*)
#pragma tg_funcdef(vload,   __vload_tg, uint,     size_t, const __global uint*)
#pragma tg_funcdef(vload,   __vload_tg, ulong,    size_t, const __global ulong*)
#pragma tg_funcdef(vload,   __vload_tg, char,     size_t, const __local char*)
#pragma tg_funcdef(vload,   __vload_tg, short,    size_t, const __local short*)
#pragma tg_funcdef(vload,   __vload_tg, int,      size_t, const __local int*)
#pragma tg_funcdef(vload,   __vload_tg, long,     size_t, const __local long*)
#pragma tg_funcdef(vload,   __vload_tg, float,    size_t, const __local float*)
#pragma tg_funcdef(vload,   __vload_tg, uchar,    size_t, const __local uchar*)
#pragma tg_funcdef(vload,   __vload_tg, ushort,   size_t, const __local ushort*)
#pragma tg_funcdef(vload,   __vload_tg, uint,     size_t, const __local uint*)
#pragma tg_funcdef(vload,   __vload_tg, ulong,    size_t, const __local ulong*)
#pragma tg_funcdef(vload,   __vload_tg, char,     size_t, const __constant char*)
#pragma tg_funcdef(vload,   __vload_tg, short,    size_t, const __constant short*)
#pragma tg_funcdef(vload,   __vload_tg, int,      size_t, const __constant int*)
#pragma tg_funcdef(vload,   __vload_tg, long,     size_t, const __constant long*)
#pragma tg_funcdef(vload,   __vload_tg, float,    size_t, const __constant float*)
#pragma tg_funcdef(vload,   __vload_tg, uchar,    size_t, const __constant uchar*)
#pragma tg_funcdef(vload,   __vload_tg, ushort,   size_t, const __constant ushort*)
#pragma tg_funcdef(vload,   __vload_tg, uint,     size_t, const __constant uint*)
#pragma tg_funcdef(vload,   __vload_tg, ulong,    size_t, const __constant ulong*)
#pragma tg_funcdef(vload,   __vload_tg, char,     size_t, const __private char*)
#pragma tg_funcdef(vload,   __vload_tg, short,    size_t, const __private short*)
#pragma tg_funcdef(vload,   __vload_tg, int,      size_t, const __private int*)
#pragma tg_funcdef(vload,   __vload_tg, long,     size_t, const __private long*)
#pragma tg_funcdef(vload,   __vload_tg, float,    size_t, const __private float*)
#pragma tg_funcdef(vload,   __vload_tg, uchar,    size_t, const __private uchar*)
#pragma tg_funcdef(vload,   __vload_tg, ushort,   size_t, const __private ushort*)
#pragma tg_funcdef(vload,   __vload_tg, uint,     size_t, const __private uint*)
#pragma tg_funcdef(vload,   __vload_tg, ulong,    size_t, const __private ulong*)

#pragma tg_funcdef(vload,   __vload_tg, double,    size_t, __global double*)
#pragma tg_funcdef(vload,   __vload_tg, double,    size_t, __local double*)
#pragma tg_funcdef(vload,   __vload_tg, double,    size_t, __constant double*)
#pragma tg_funcdef(vload,   __vload_tg, double,    size_t, __private double*)
#pragma tg_funcdef(vload,   __vload_tg, double,    size_t, const __global double*)
#pragma tg_funcdef(vload,   __vload_tg, double,    size_t, const __local double*)
#pragma tg_funcdef(vload,   __vload_tg, double,    size_t, const __constant double*)
#pragma tg_funcdef(vload,   __vload_tg, double,    size_t, const __private double*)

#undef vload
#define vload(__a, __b) __tg_builtin_gentype("vload",__a, __b)


#pragma tg_funcdef(vload2,   __vload_tg, char2,     size_t, __global char*)
#pragma tg_funcdef(vload2,   __vload_tg, short2,    size_t, __global short*)
#pragma tg_funcdef(vload2,   __vload_tg, int2,      size_t, __global int*)
#pragma tg_funcdef(vload2,   __vload_tg, long2,     size_t, __global long*)
#pragma tg_funcdef(vload2,   __vload_tg, float2,    size_t, __global float*)
#pragma tg_funcdef(vload2,   __vload_tg, uchar2,    size_t, __global uchar*)
#pragma tg_funcdef(vload2,   __vload_tg, ushort2,   size_t, __global ushort*)
#pragma tg_funcdef(vload2,   __vload_tg, uint2,     size_t, __global uint*)
#pragma tg_funcdef(vload2,   __vload_tg, ulong2,    size_t, __global ulong*)
#pragma tg_funcdef(vload2,   __vload_tg, char2,     size_t, __local char*)
#pragma tg_funcdef(vload2,   __vload_tg, short2,    size_t, __local short*)
#pragma tg_funcdef(vload2,   __vload_tg, int2,      size_t, __local int*)
#pragma tg_funcdef(vload2,   __vload_tg, long2,     size_t, __local long*)
#pragma tg_funcdef(vload2,   __vload_tg, float2,    size_t, __local float*)
#pragma tg_funcdef(vload2,   __vload_tg, uchar2,    size_t, __local uchar*)
#pragma tg_funcdef(vload2,   __vload_tg, ushort2,   size_t, __local ushort*)
#pragma tg_funcdef(vload2,   __vload_tg, uint2,     size_t, __local uint*)
#pragma tg_funcdef(vload2,   __vload_tg, ulong2,    size_t, __local ulong*)
#pragma tg_funcdef(vload2,   __vload_tg, char2,     size_t, __constant char*)
#pragma tg_funcdef(vload2,   __vload_tg, short2,    size_t, __constant short*)
#pragma tg_funcdef(vload2,   __vload_tg, int2,      size_t, __constant int*)
#pragma tg_funcdef(vload2,   __vload_tg, long2,     size_t, __constant long*)
#pragma tg_funcdef(vload2,   __vload_tg, float2,    size_t, __constant float*)
#pragma tg_funcdef(vload2,   __vload_tg, uchar2,    size_t, __constant uchar*)
#pragma tg_funcdef(vload2,   __vload_tg, ushort2,   size_t, __constant ushort*)
#pragma tg_funcdef(vload2,   __vload_tg, uint2,     size_t, __constant uint*)
#pragma tg_funcdef(vload2,   __vload_tg, ulong2,    size_t, __constant ulong*)
#pragma tg_funcdef(vload2,   __vload_tg, char2,     size_t, __private char*)
#pragma tg_funcdef(vload2,   __vload_tg, short2,    size_t, __private short*)
#pragma tg_funcdef(vload2,   __vload_tg, int2,      size_t, __private int*)
#pragma tg_funcdef(vload2,   __vload_tg, long2,     size_t, __private long*)
#pragma tg_funcdef(vload2,   __vload_tg, float2,    size_t, __private float*)
#pragma tg_funcdef(vload2,   __vload_tg, uchar2,    size_t, __private uchar*)
#pragma tg_funcdef(vload2,   __vload_tg, ushort2,   size_t, __private ushort*)
#pragma tg_funcdef(vload2,   __vload_tg, uint2,     size_t, __private uint*)
#pragma tg_funcdef(vload2,   __vload_tg, ulong2,    size_t, __private ulong*)
#pragma tg_funcdef(vload2,   __vload_tg, char2,     size_t, const __global char*)
#pragma tg_funcdef(vload2,   __vload_tg, short2,    size_t, const __global short*)
#pragma tg_funcdef(vload2,   __vload_tg, int2,      size_t, const __global int*)
#pragma tg_funcdef(vload2,   __vload_tg, long2,     size_t, const __global long*)
#pragma tg_funcdef(vload2,   __vload_tg, float2,    size_t, const __global float*)
#pragma tg_funcdef(vload2,   __vload_tg, uchar2,    size_t, const __global uchar*)
#pragma tg_funcdef(vload2,   __vload_tg, ushort2,   size_t, const __global ushort*)
#pragma tg_funcdef(vload2,   __vload_tg, uint2,     size_t, const __global uint*)
#pragma tg_funcdef(vload2,   __vload_tg, ulong2,    size_t, const __global ulong*)
#pragma tg_funcdef(vload2,   __vload_tg, char2,     size_t, const __local char*)
#pragma tg_funcdef(vload2,   __vload_tg, short2,    size_t, const __local short*)
#pragma tg_funcdef(vload2,   __vload_tg, int2,      size_t, const __local int*)
#pragma tg_funcdef(vload2,   __vload_tg, long2,     size_t, const __local long*)
#pragma tg_funcdef(vload2,   __vload_tg, float2,    size_t, const __local float*)
#pragma tg_funcdef(vload2,   __vload_tg, uchar2,    size_t, const __local uchar*)
#pragma tg_funcdef(vload2,   __vload_tg, ushort2,   size_t, const __local ushort*)
#pragma tg_funcdef(vload2,   __vload_tg, uint2,     size_t, const __local uint*)
#pragma tg_funcdef(vload2,   __vload_tg, ulong2,    size_t, const __local ulong*)
#pragma tg_funcdef(vload2,   __vload_tg, char2,     size_t, const __constant char*)
#pragma tg_funcdef(vload2,   __vload_tg, short2,    size_t, const __constant short*)
#pragma tg_funcdef(vload2,   __vload_tg, int2,      size_t, const __constant int*)
#pragma tg_funcdef(vload2,   __vload_tg, long2,     size_t, const __constant long*)
#pragma tg_funcdef(vload2,   __vload_tg, float2,    size_t, const __constant float*)
#pragma tg_funcdef(vload2,   __vload_tg, uchar2,    size_t, const __constant uchar*)
#pragma tg_funcdef(vload2,   __vload_tg, ushort2,   size_t, const __constant ushort*)
#pragma tg_funcdef(vload2,   __vload_tg, uint2,     size_t, const __constant uint*)
#pragma tg_funcdef(vload2,   __vload_tg, ulong2,    size_t, const __constant ulong*)
#pragma tg_funcdef(vload2,   __vload_tg, char2,     size_t, const __private char*)
#pragma tg_funcdef(vload2,   __vload_tg, short2,    size_t, const __private short*)
#pragma tg_funcdef(vload2,   __vload_tg, int2,      size_t, const __private int*)
#pragma tg_funcdef(vload2,   __vload_tg, long2,     size_t, const __private long*)
#pragma tg_funcdef(vload2,   __vload_tg, float2,    size_t, const __private float*)
#pragma tg_funcdef(vload2,   __vload_tg, uchar2,    size_t, const __private uchar*)
#pragma tg_funcdef(vload2,   __vload_tg, ushort2,   size_t, const __private ushort*)
#pragma tg_funcdef(vload2,   __vload_tg, uint2,     size_t, const __private uint*)
#pragma tg_funcdef(vload2,   __vload_tg, ulong2,    size_t, const __private ulong*)

 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(vload2,   __vload_tg, double2,    size_t, __global double*)
#pragma tg_funcdef(vload2,   __vload_tg, double2,    size_t, __local double*)
#pragma tg_funcdef(vload2,   __vload_tg, double2,    size_t, __constant double*)
#pragma tg_funcdef(vload2,   __vload_tg, double2,    size_t, __private double*)
#pragma tg_funcdef(vload2,   __vload_tg, double2,    size_t, const __global double*)
#pragma tg_funcdef(vload2,   __vload_tg, double2,    size_t, const __local double*)
#pragma tg_funcdef(vload2,   __vload_tg, double2,    size_t, const __constant double*)
#pragma tg_funcdef(vload2,   __vload_tg, double2,    size_t, const __private double*)
 #endif

#undef vload2
#define vload2(__a, __b) __tg_builtin_gentype("vload2",__a, __b)


#pragma tg_funcdef(vload3,   __vload_tg, char3,     size_t, __global char*)
#pragma tg_funcdef(vload3,   __vload_tg, short3,    size_t, __global short*)
#pragma tg_funcdef(vload3,   __vload_tg, int3,      size_t, __global int*)
#pragma tg_funcdef(vload3,   __vload_tg, long3,     size_t, __global long*)
#pragma tg_funcdef(vload3,   __vload_tg, float3,    size_t, __global float*)
#pragma tg_funcdef(vload3,   __vload_tg, uchar3,    size_t, __global uchar*)
#pragma tg_funcdef(vload3,   __vload_tg, ushort3,   size_t, __global ushort*)
#pragma tg_funcdef(vload3,   __vload_tg, uint3,     size_t, __global uint*)
#pragma tg_funcdef(vload3,   __vload_tg, ulong3,    size_t, __global ulong*)
#pragma tg_funcdef(vload3,   __vload_tg, char3,     size_t, __local char*)
#pragma tg_funcdef(vload3,   __vload_tg, short3,    size_t, __local short*)
#pragma tg_funcdef(vload3,   __vload_tg, int3,      size_t, __local int*)
#pragma tg_funcdef(vload3,   __vload_tg, long3,     size_t, __local long*)
#pragma tg_funcdef(vload3,   __vload_tg, float3,    size_t, __local float*)
#pragma tg_funcdef(vload3,   __vload_tg, uchar3,    size_t, __local uchar*)
#pragma tg_funcdef(vload3,   __vload_tg, ushort3,   size_t, __local ushort*)
#pragma tg_funcdef(vload3,   __vload_tg, uint3,     size_t, __local uint*)
#pragma tg_funcdef(vload3,   __vload_tg, ulong3,    size_t, __local ulong*)
#pragma tg_funcdef(vload3,   __vload_tg, char3,     size_t, __constant char*)
#pragma tg_funcdef(vload3,   __vload_tg, short3,    size_t, __constant short*)
#pragma tg_funcdef(vload3,   __vload_tg, int3,      size_t, __constant int*)
#pragma tg_funcdef(vload3,   __vload_tg, long3,     size_t, __constant long*)
#pragma tg_funcdef(vload3,   __vload_tg, float3,    size_t, __constant float*)
#pragma tg_funcdef(vload3,   __vload_tg, uchar3,    size_t, __constant uchar*)
#pragma tg_funcdef(vload3,   __vload_tg, ushort3,   size_t, __constant ushort*)
#pragma tg_funcdef(vload3,   __vload_tg, uint3,     size_t, __constant uint*)
#pragma tg_funcdef(vload3,   __vload_tg, ulong3,    size_t, __constant ulong*)
#pragma tg_funcdef(vload3,   __vload_tg, char3,     size_t, __private char*)
#pragma tg_funcdef(vload3,   __vload_tg, short3,    size_t, __private short*)
#pragma tg_funcdef(vload3,   __vload_tg, int3,      size_t, __private int*)
#pragma tg_funcdef(vload3,   __vload_tg, long3,     size_t, __private long*)
#pragma tg_funcdef(vload3,   __vload_tg, float3,    size_t, __private float*)
#pragma tg_funcdef(vload3,   __vload_tg, uchar3,    size_t, __private uchar*)
#pragma tg_funcdef(vload3,   __vload_tg, ushort3,   size_t, __private ushort*)
#pragma tg_funcdef(vload3,   __vload_tg, uint3,     size_t, __private uint*)
#pragma tg_funcdef(vload3,   __vload_tg, ulong3,    size_t, __private ulong*)
#pragma tg_funcdef(vload3,   __vload_tg, char3,     size_t, const __global char*)
#pragma tg_funcdef(vload3,   __vload_tg, short3,    size_t, const __global short*)
#pragma tg_funcdef(vload3,   __vload_tg, int3,      size_t, const __global int*)
#pragma tg_funcdef(vload3,   __vload_tg, long3,     size_t, const __global long*)
#pragma tg_funcdef(vload3,   __vload_tg, float3,    size_t, const __global float*)
#pragma tg_funcdef(vload3,   __vload_tg, uchar3,    size_t, const __global uchar*)
#pragma tg_funcdef(vload3,   __vload_tg, ushort3,   size_t, const __global ushort*)
#pragma tg_funcdef(vload3,   __vload_tg, uint3,     size_t, const __global uint*)
#pragma tg_funcdef(vload3,   __vload_tg, ulong3,    size_t, const __global ulong*)
#pragma tg_funcdef(vload3,   __vload_tg, char3,     size_t, const __local char*)
#pragma tg_funcdef(vload3,   __vload_tg, short3,    size_t, const __local short*)
#pragma tg_funcdef(vload3,   __vload_tg, int3,      size_t, const __local int*)
#pragma tg_funcdef(vload3,   __vload_tg, long3,     size_t, const __local long*)
#pragma tg_funcdef(vload3,   __vload_tg, float3,    size_t, const __local float*)
#pragma tg_funcdef(vload3,   __vload_tg, uchar3,    size_t, const __local uchar*)
#pragma tg_funcdef(vload3,   __vload_tg, ushort3,   size_t, const __local ushort*)
#pragma tg_funcdef(vload3,   __vload_tg, uint3,     size_t, const __local uint*)
#pragma tg_funcdef(vload3,   __vload_tg, ulong3,    size_t, const __local ulong*)
#pragma tg_funcdef(vload3,   __vload_tg, char3,     size_t, const __constant char*)
#pragma tg_funcdef(vload3,   __vload_tg, short3,    size_t, const __constant short*)
#pragma tg_funcdef(vload3,   __vload_tg, int3,      size_t, const __constant int*)
#pragma tg_funcdef(vload3,   __vload_tg, long3,     size_t, const __constant long*)
#pragma tg_funcdef(vload3,   __vload_tg, float3,    size_t, const __constant float*)
#pragma tg_funcdef(vload3,   __vload_tg, uchar3,    size_t, const __constant uchar*)
#pragma tg_funcdef(vload3,   __vload_tg, ushort3,   size_t, const __constant ushort*)
#pragma tg_funcdef(vload3,   __vload_tg, uint3,     size_t, const __constant uint*)
#pragma tg_funcdef(vload3,   __vload_tg, ulong3,    size_t, const __constant ulong*)
#pragma tg_funcdef(vload3,   __vload_tg, char3,     size_t, const __private char*)
#pragma tg_funcdef(vload3,   __vload_tg, short3,    size_t, const __private short*)
#pragma tg_funcdef(vload3,   __vload_tg, int3,      size_t, const __private int*)
#pragma tg_funcdef(vload3,   __vload_tg, long3,     size_t, const __private long*)
#pragma tg_funcdef(vload3,   __vload_tg, float3,    size_t, const __private float*)
#pragma tg_funcdef(vload3,   __vload_tg, uchar3,    size_t, const __private uchar*)
#pragma tg_funcdef(vload3,   __vload_tg, ushort3,   size_t, const __private ushort*)
#pragma tg_funcdef(vload3,   __vload_tg, uint3,     size_t, const __private uint*)
#pragma tg_funcdef(vload3,   __vload_tg, ulong3,    size_t, const __private ulong*)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(vload3,   __vload_tg, double3,    size_t, __global double*)
#pragma tg_funcdef(vload3,   __vload_tg, double3,    size_t, __local double*)
#pragma tg_funcdef(vload3,   __vload_tg, double3,    size_t, __constant double*)
#pragma tg_funcdef(vload3,   __vload_tg, double3,    size_t, __private double*)
#pragma tg_funcdef(vload3,   __vload_tg, double3,    size_t, const __global double*)
#pragma tg_funcdef(vload3,   __vload_tg, double3,    size_t, const __local double*)
#pragma tg_funcdef(vload3,   __vload_tg, double3,    size_t, const __constant double*)
#pragma tg_funcdef(vload3,   __vload_tg, double3,    size_t, const __private double*)
 #endif
#undef vload3
#define vload3(__a, __b) __tg_builtin_gentype("vload3",__a, __b)

#pragma tg_funcdef(vload4,   __vload_tg, char4,     size_t, __global char*)
#pragma tg_funcdef(vload4,   __vload_tg, short4,    size_t, __global short*)
#pragma tg_funcdef(vload4,   __vload_tg, int4,      size_t, __global int*)
#pragma tg_funcdef(vload4,   __vload_tg, long4,     size_t, __global long*)
#pragma tg_funcdef(vload4,   __vload_tg, float4,    size_t, __global float*)
#pragma tg_funcdef(vload4,   __vload_tg, uchar4,    size_t, __global uchar*)
#pragma tg_funcdef(vload4,   __vload_tg, ushort4,   size_t, __global ushort*)
#pragma tg_funcdef(vload4,   __vload_tg, uint4,     size_t, __global uint*)
#pragma tg_funcdef(vload4,   __vload_tg, ulong4,    size_t, __global ulong*)
#pragma tg_funcdef(vload4,   __vload_tg, char4,     size_t, __local char*)
#pragma tg_funcdef(vload4,   __vload_tg, short4,    size_t, __local short*)
#pragma tg_funcdef(vload4,   __vload_tg, int4,      size_t, __local int*)
#pragma tg_funcdef(vload4,   __vload_tg, long4,     size_t, __local long*)
#pragma tg_funcdef(vload4,   __vload_tg, float4,    size_t, __local float*)
#pragma tg_funcdef(vload4,   __vload_tg, uchar4,    size_t, __local uchar*)
#pragma tg_funcdef(vload4,   __vload_tg, ushort4,   size_t, __local ushort*)
#pragma tg_funcdef(vload4,   __vload_tg, uint4,     size_t, __local uint*)
#pragma tg_funcdef(vload4,   __vload_tg, ulong4,    size_t, __local ulong*)
#pragma tg_funcdef(vload4,   __vload_tg, char4,     size_t, __constant char*)
#pragma tg_funcdef(vload4,   __vload_tg, short4,    size_t, __constant short*)
#pragma tg_funcdef(vload4,   __vload_tg, int4,      size_t, __constant int*)
#pragma tg_funcdef(vload4,   __vload_tg, long4,     size_t, __constant long*)
#pragma tg_funcdef(vload4,   __vload_tg, float4,    size_t, __constant float*)
#pragma tg_funcdef(vload4,   __vload_tg, uchar4,    size_t, __constant uchar*)
#pragma tg_funcdef(vload4,   __vload_tg, ushort4,   size_t, __constant ushort*)
#pragma tg_funcdef(vload4,   __vload_tg, uint4,     size_t, __constant uint*)
#pragma tg_funcdef(vload4,   __vload_tg, ulong4,    size_t, __constant ulong*)
#pragma tg_funcdef(vload4,   __vload_tg, char4,     size_t, __private char*)
#pragma tg_funcdef(vload4,   __vload_tg, short4,    size_t, __private short*)
#pragma tg_funcdef(vload4,   __vload_tg, int4,      size_t, __private int*)
#pragma tg_funcdef(vload4,   __vload_tg, long4,     size_t, __private long*)
#pragma tg_funcdef(vload4,   __vload_tg, float4,    size_t, __private float*)
#pragma tg_funcdef(vload4,   __vload_tg, uchar4,    size_t, __private uchar*)
#pragma tg_funcdef(vload4,   __vload_tg, ushort4,   size_t, __private ushort*)
#pragma tg_funcdef(vload4,   __vload_tg, uint4,     size_t, __private uint*)
#pragma tg_funcdef(vload4,   __vload_tg, ulong4,    size_t, __private ulong*)
#pragma tg_funcdef(vload4,   __vload_tg, char4,     size_t, const __global char*)
#pragma tg_funcdef(vload4,   __vload_tg, short4,    size_t, const __global short*)
#pragma tg_funcdef(vload4,   __vload_tg, int4,      size_t, const __global int*)
#pragma tg_funcdef(vload4,   __vload_tg, long4,     size_t, const __global long*)
#pragma tg_funcdef(vload4,   __vload_tg, float4,    size_t, const __global float*)
#pragma tg_funcdef(vload4,   __vload_tg, uchar4,    size_t, const __global uchar*)
#pragma tg_funcdef(vload4,   __vload_tg, ushort4,   size_t, const __global ushort*)
#pragma tg_funcdef(vload4,   __vload_tg, uint4,     size_t, const __global uint*)
#pragma tg_funcdef(vload4,   __vload_tg, ulong4,    size_t, const __global ulong*)
#pragma tg_funcdef(vload4,   __vload_tg, char4,     size_t, const __local char*)
#pragma tg_funcdef(vload4,   __vload_tg, short4,    size_t, const __local short*)
#pragma tg_funcdef(vload4,   __vload_tg, int4,      size_t, const __local int*)
#pragma tg_funcdef(vload4,   __vload_tg, long4,     size_t, const __local long*)
#pragma tg_funcdef(vload4,   __vload_tg, float4,    size_t, const __local float*)
#pragma tg_funcdef(vload4,   __vload_tg, uchar4,    size_t, const __local uchar*)
#pragma tg_funcdef(vload4,   __vload_tg, ushort4,   size_t, const __local ushort*)
#pragma tg_funcdef(vload4,   __vload_tg, uint4,     size_t, const __local uint*)
#pragma tg_funcdef(vload4,   __vload_tg, ulong4,    size_t, const __local ulong*)
#pragma tg_funcdef(vload4,   __vload_tg, char4,     size_t, const __constant char*)
#pragma tg_funcdef(vload4,   __vload_tg, short4,    size_t, const __constant short*)
#pragma tg_funcdef(vload4,   __vload_tg, int4,      size_t, const __constant int*)
#pragma tg_funcdef(vload4,   __vload_tg, long4,     size_t, const __constant long*)
#pragma tg_funcdef(vload4,   __vload_tg, float4,    size_t, const __constant float*)
#pragma tg_funcdef(vload4,   __vload_tg, uchar4,    size_t, const __constant uchar*)
#pragma tg_funcdef(vload4,   __vload_tg, ushort4,   size_t, const __constant ushort*)
#pragma tg_funcdef(vload4,   __vload_tg, uint4,     size_t, const __constant uint*)
#pragma tg_funcdef(vload4,   __vload_tg, ulong4,    size_t, const __constant ulong*)
#pragma tg_funcdef(vload4,   __vload_tg, char4,     size_t, const __private char*)
#pragma tg_funcdef(vload4,   __vload_tg, short4,    size_t, const __private short*)
#pragma tg_funcdef(vload4,   __vload_tg, int4,      size_t, const __private int*)
#pragma tg_funcdef(vload4,   __vload_tg, long4,     size_t, const __private long*)
#pragma tg_funcdef(vload4,   __vload_tg, float4,    size_t, const __private float*)
#pragma tg_funcdef(vload4,   __vload_tg, uchar4,    size_t, const __private uchar*)
#pragma tg_funcdef(vload4,   __vload_tg, ushort4,   size_t, const __private ushort*)
#pragma tg_funcdef(vload4,   __vload_tg, uint4,     size_t, const __private uint*)
#pragma tg_funcdef(vload4,   __vload_tg, ulong4,    size_t, const __private ulong*)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(vload4,   __vload_tg, double4,    size_t, __global double*)
#pragma tg_funcdef(vload4,   __vload_tg, double4,    size_t, __local double*)
#pragma tg_funcdef(vload4,   __vload_tg, double4,    size_t, __constant double*)
#pragma tg_funcdef(vload4,   __vload_tg, double4,    size_t, __private double*)
#pragma tg_funcdef(vload4,   __vload_tg, double4,    size_t, const __global double*)
#pragma tg_funcdef(vload4,   __vload_tg, double4,    size_t, const __local double*)
#pragma tg_funcdef(vload4,   __vload_tg, double4,    size_t, const __constant double*)
#pragma tg_funcdef(vload4,   __vload_tg, double4,    size_t, const __private double*)
 #endif
#undef vload4
#define vload4(__a, __b) __tg_builtin_gentype("vload4",__a, __b)

#pragma tg_funcdef(vload8,   __vload_tg, char8,     size_t, __global char*)
#pragma tg_funcdef(vload8,   __vload_tg, short8,    size_t, __global short*)
#pragma tg_funcdef(vload8,   __vload_tg, int8,      size_t, __global int*)
#pragma tg_funcdef(vload8,   __vload_tg, long8,     size_t, __global long*)
#pragma tg_funcdef(vload8,   __vload_tg, float8,    size_t, __global float*)
#pragma tg_funcdef(vload8,   __vload_tg, uchar8,    size_t, __global uchar*)
#pragma tg_funcdef(vload8,   __vload_tg, ushort8,   size_t, __global ushort*)
#pragma tg_funcdef(vload8,   __vload_tg, uint8,     size_t, __global uint*)
#pragma tg_funcdef(vload8,   __vload_tg, ulong8,    size_t, __global ulong*)
#pragma tg_funcdef(vload8,   __vload_tg, char8,     size_t, __local char*)
#pragma tg_funcdef(vload8,   __vload_tg, short8,    size_t, __local short*)
#pragma tg_funcdef(vload8,   __vload_tg, int8,      size_t, __local int*)
#pragma tg_funcdef(vload8,   __vload_tg, long8,     size_t, __local long*)
#pragma tg_funcdef(vload8,   __vload_tg, float8,    size_t, __local float*)
#pragma tg_funcdef(vload8,   __vload_tg, uchar8,    size_t, __local uchar*)
#pragma tg_funcdef(vload8,   __vload_tg, ushort8,   size_t, __local ushort*)
#pragma tg_funcdef(vload8,   __vload_tg, uint8,     size_t, __local uint*)
#pragma tg_funcdef(vload8,   __vload_tg, ulong8,    size_t, __local ulong*)
#pragma tg_funcdef(vload8,   __vload_tg, char8,     size_t, __constant char*)
#pragma tg_funcdef(vload8,   __vload_tg, short8,    size_t, __constant short*)
#pragma tg_funcdef(vload8,   __vload_tg, int8,      size_t, __constant int*)
#pragma tg_funcdef(vload8,   __vload_tg, long8,     size_t, __constant long*)
#pragma tg_funcdef(vload8,   __vload_tg, float8,    size_t, __constant float*)
#pragma tg_funcdef(vload8,   __vload_tg, uchar8,    size_t, __constant uchar*)
#pragma tg_funcdef(vload8,   __vload_tg, ushort8,   size_t, __constant ushort*)
#pragma tg_funcdef(vload8,   __vload_tg, uint8,     size_t, __constant uint*)
#pragma tg_funcdef(vload8,   __vload_tg, ulong8,    size_t, __constant ulong*)
#pragma tg_funcdef(vload8,   __vload_tg, char8,     size_t, __private char*)
#pragma tg_funcdef(vload8,   __vload_tg, short8,    size_t, __private short*)
#pragma tg_funcdef(vload8,   __vload_tg, int8,      size_t, __private int*)
#pragma tg_funcdef(vload8,   __vload_tg, long8,     size_t, __private long*)
#pragma tg_funcdef(vload8,   __vload_tg, float8,    size_t, __private float*)
#pragma tg_funcdef(vload8,   __vload_tg, uchar8,    size_t, __private uchar*)
#pragma tg_funcdef(vload8,   __vload_tg, ushort8,   size_t, __private ushort*)
#pragma tg_funcdef(vload8,   __vload_tg, uint8,     size_t, __private uint*)
#pragma tg_funcdef(vload8,   __vload_tg, ulong8,    size_t, __private ulong*)
#pragma tg_funcdef(vload8,   __vload_tg, char8,     size_t, const __global char*)
#pragma tg_funcdef(vload8,   __vload_tg, short8,    size_t, const __global short*)
#pragma tg_funcdef(vload8,   __vload_tg, int8,      size_t, const __global int*)
#pragma tg_funcdef(vload8,   __vload_tg, long8,     size_t, const __global long*)
#pragma tg_funcdef(vload8,   __vload_tg, float8,    size_t, const __global float*)
#pragma tg_funcdef(vload8,   __vload_tg, uchar8,    size_t, const __global uchar*)
#pragma tg_funcdef(vload8,   __vload_tg, ushort8,   size_t, const __global ushort*)
#pragma tg_funcdef(vload8,   __vload_tg, uint8,     size_t, const __global uint*)
#pragma tg_funcdef(vload8,   __vload_tg, ulong8,    size_t, const __global ulong*)
#pragma tg_funcdef(vload8,   __vload_tg, char8,     size_t, const __local char*)
#pragma tg_funcdef(vload8,   __vload_tg, short8,    size_t, const __local short*)
#pragma tg_funcdef(vload8,   __vload_tg, int8,      size_t, const __local int*)
#pragma tg_funcdef(vload8,   __vload_tg, long8,     size_t, const __local long*)
#pragma tg_funcdef(vload8,   __vload_tg, float8,    size_t, const __local float*)
#pragma tg_funcdef(vload8,   __vload_tg, uchar8,    size_t, const __local uchar*)
#pragma tg_funcdef(vload8,   __vload_tg, ushort8,   size_t, const __local ushort*)
#pragma tg_funcdef(vload8,   __vload_tg, uint8,     size_t, const __local uint*)
#pragma tg_funcdef(vload8,   __vload_tg, ulong8,    size_t, const __local ulong*)
#pragma tg_funcdef(vload8,   __vload_tg, char8,     size_t, const __constant char*)
#pragma tg_funcdef(vload8,   __vload_tg, short8,    size_t, const __constant short*)
#pragma tg_funcdef(vload8,   __vload_tg, int8,      size_t, const __constant int*)
#pragma tg_funcdef(vload8,   __vload_tg, long8,     size_t, const __constant long*)
#pragma tg_funcdef(vload8,   __vload_tg, float8,    size_t, const __constant float*)
#pragma tg_funcdef(vload8,   __vload_tg, uchar8,    size_t, const __constant uchar*)
#pragma tg_funcdef(vload8,   __vload_tg, ushort8,   size_t, const __constant ushort*)
#pragma tg_funcdef(vload8,   __vload_tg, uint8,     size_t, const __constant uint*)
#pragma tg_funcdef(vload8,   __vload_tg, ulong8,    size_t, const __constant ulong*)
#pragma tg_funcdef(vload8,   __vload_tg, char8,     size_t, const __private char*)
#pragma tg_funcdef(vload8,   __vload_tg, short8,    size_t, const __private short*)
#pragma tg_funcdef(vload8,   __vload_tg, int8,      size_t, const __private int*)
#pragma tg_funcdef(vload8,   __vload_tg, long8,     size_t, const __private long*)
#pragma tg_funcdef(vload8,   __vload_tg, float8,    size_t, const __private float*)
#pragma tg_funcdef(vload8,   __vload_tg, uchar8,    size_t, const __private uchar*)
#pragma tg_funcdef(vload8,   __vload_tg, ushort8,   size_t, const __private ushort*)
#pragma tg_funcdef(vload8,   __vload_tg, uint8,     size_t, const __private uint*)
#pragma tg_funcdef(vload8,   __vload_tg, ulong8,    size_t, const __private ulong*)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(vload8,   __vload_tg, double8,    size_t, __global double*)
#pragma tg_funcdef(vload8,   __vload_tg, double8,    size_t, __local double*)
#pragma tg_funcdef(vload8,   __vload_tg, double8,    size_t, __constant double*)
#pragma tg_funcdef(vload8,   __vload_tg, double8,    size_t, __private double*)
#pragma tg_funcdef(vload8,   __vload_tg, double8,    size_t, const __global double*)
#pragma tg_funcdef(vload8,   __vload_tg, double8,    size_t, const __local double*)
#pragma tg_funcdef(vload8,   __vload_tg, double8,    size_t, const __constant double*)
#pragma tg_funcdef(vload8,   __vload_tg, double8,    size_t, const __private double*)
 #endif
#undef vload8
#define vload8(__a, __b) __tg_builtin_gentype("vload8",__a, __b)

#pragma tg_funcdef(vload16,   __vload_tg, char16,     size_t, __global char*)
#pragma tg_funcdef(vload16,   __vload_tg, short16,    size_t, __global short*)
#pragma tg_funcdef(vload16,   __vload_tg, int16,      size_t, __global int*)
#pragma tg_funcdef(vload16,   __vload_tg, long16,     size_t, __global long*)
#pragma tg_funcdef(vload16,   __vload_tg, float16,    size_t, __global float*)
#pragma tg_funcdef(vload16,   __vload_tg, uchar16,    size_t, __global uchar*)
#pragma tg_funcdef(vload16,   __vload_tg, ushort16,   size_t, __global ushort*)
#pragma tg_funcdef(vload16,   __vload_tg, uint16,     size_t, __global uint*)
#pragma tg_funcdef(vload16,   __vload_tg, ulong16,    size_t, __global ulong*)
#pragma tg_funcdef(vload16,   __vload_tg, char16,     size_t, __local char*)
#pragma tg_funcdef(vload16,   __vload_tg, short16,    size_t, __local short*)
#pragma tg_funcdef(vload16,   __vload_tg, int16,      size_t, __local int*)
#pragma tg_funcdef(vload16,   __vload_tg, long16,     size_t, __local long*)
#pragma tg_funcdef(vload16,   __vload_tg, float16,    size_t, __local float*)
#pragma tg_funcdef(vload16,   __vload_tg, uchar16,    size_t, __local uchar*)
#pragma tg_funcdef(vload16,   __vload_tg, ushort16,   size_t, __local ushort*)
#pragma tg_funcdef(vload16,   __vload_tg, uint16,     size_t, __local uint*)
#pragma tg_funcdef(vload16,   __vload_tg, ulong16,    size_t, __local ulong*)
#pragma tg_funcdef(vload16,   __vload_tg, char16,     size_t, __constant char*)
#pragma tg_funcdef(vload16,   __vload_tg, short16,    size_t, __constant short*)
#pragma tg_funcdef(vload16,   __vload_tg, int16,      size_t, __constant int*)
#pragma tg_funcdef(vload16,   __vload_tg, long16,     size_t, __constant long*)
#pragma tg_funcdef(vload16,   __vload_tg, float16,    size_t, __constant float*)
#pragma tg_funcdef(vload16,   __vload_tg, uchar16,    size_t, __constant uchar*)
#pragma tg_funcdef(vload16,   __vload_tg, ushort16,   size_t, __constant ushort*)
#pragma tg_funcdef(vload16,   __vload_tg, uint16,     size_t, __constant uint*)
#pragma tg_funcdef(vload16,   __vload_tg, ulong16,    size_t, __constant ulong*)
#pragma tg_funcdef(vload16,   __vload_tg, char16,     size_t, __private char*)
#pragma tg_funcdef(vload16,   __vload_tg, short16,    size_t, __private short*)
#pragma tg_funcdef(vload16,   __vload_tg, int16,      size_t, __private int*)
#pragma tg_funcdef(vload16,   __vload_tg, long16,     size_t, __private long*)
#pragma tg_funcdef(vload16,   __vload_tg, float16,    size_t, __private float*)
#pragma tg_funcdef(vload16,   __vload_tg, uchar16,    size_t, __private uchar*)
#pragma tg_funcdef(vload16,   __vload_tg, ushort16,   size_t, __private ushort*)
#pragma tg_funcdef(vload16,   __vload_tg, uint16,     size_t, __private uint*)
#pragma tg_funcdef(vload16,   __vload_tg, ulong16,    size_t, __private ulong*)
#pragma tg_funcdef(vload16,   __vload_tg, char16,     size_t, const __global char*)
#pragma tg_funcdef(vload16,   __vload_tg, short16,    size_t, const __global short*)
#pragma tg_funcdef(vload16,   __vload_tg, int16,      size_t, const __global int*)
#pragma tg_funcdef(vload16,   __vload_tg, long16,     size_t, const __global long*)
#pragma tg_funcdef(vload16,   __vload_tg, float16,    size_t, const __global float*)
#pragma tg_funcdef(vload16,   __vload_tg, uchar16,    size_t, const __global uchar*)
#pragma tg_funcdef(vload16,   __vload_tg, ushort16,   size_t, const __global ushort*)
#pragma tg_funcdef(vload16,   __vload_tg, uint16,     size_t, const __global uint*)
#pragma tg_funcdef(vload16,   __vload_tg, ulong16,    size_t, const __global ulong*)
#pragma tg_funcdef(vload16,   __vload_tg, char16,     size_t, const __local char*)
#pragma tg_funcdef(vload16,   __vload_tg, short16,    size_t, const __local short*)
#pragma tg_funcdef(vload16,   __vload_tg, int16,      size_t, const __local int*)
#pragma tg_funcdef(vload16,   __vload_tg, long16,     size_t, const __local long*)
#pragma tg_funcdef(vload16,   __vload_tg, float16,    size_t, const __local float*)
#pragma tg_funcdef(vload16,   __vload_tg, uchar16,    size_t, const __local uchar*)
#pragma tg_funcdef(vload16,   __vload_tg, ushort16,   size_t, const __local ushort*)
#pragma tg_funcdef(vload16,   __vload_tg, uint16,     size_t, const __local uint*)
#pragma tg_funcdef(vload16,   __vload_tg, ulong16,    size_t, const __local ulong*)
#pragma tg_funcdef(vload16,   __vload_tg, char16,     size_t, const __constant char*)
#pragma tg_funcdef(vload16,   __vload_tg, short16,    size_t, const __constant short*)
#pragma tg_funcdef(vload16,   __vload_tg, int16,      size_t, const __constant int*)
#pragma tg_funcdef(vload16,   __vload_tg, long16,     size_t, const __constant long*)
#pragma tg_funcdef(vload16,   __vload_tg, float16,    size_t, const __constant float*)
#pragma tg_funcdef(vload16,   __vload_tg, uchar16,    size_t, const __constant uchar*)
#pragma tg_funcdef(vload16,   __vload_tg, ushort16,   size_t, const __constant ushort*)
#pragma tg_funcdef(vload16,   __vload_tg, uint16,     size_t, const __constant uint*)
#pragma tg_funcdef(vload16,   __vload_tg, ulong16,    size_t, const __constant ulong*)
#pragma tg_funcdef(vload16,   __vload_tg, char16,     size_t, const __private char*)
#pragma tg_funcdef(vload16,   __vload_tg, short16,    size_t, const __private short*)
#pragma tg_funcdef(vload16,   __vload_tg, int16,      size_t, const __private int*)
#pragma tg_funcdef(vload16,   __vload_tg, long16,     size_t, const __private long*)
#pragma tg_funcdef(vload16,   __vload_tg, float16,    size_t, const __private float*)
#pragma tg_funcdef(vload16,   __vload_tg, uchar16,    size_t, const __private uchar*)
#pragma tg_funcdef(vload16,   __vload_tg, ushort16,   size_t, const __private ushort*)
#pragma tg_funcdef(vload16,   __vload_tg, uint16,     size_t, const __private uint*)
#pragma tg_funcdef(vload16,   __vload_tg, ulong16,    size_t, const __private ulong*)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(vload16,   __vload_tg, double16,    size_t, __global double*)
#pragma tg_funcdef(vload16,   __vload_tg, double16,    size_t, __local double*)
#pragma tg_funcdef(vload16,   __vload_tg, double16,    size_t, __constant double*)
#pragma tg_funcdef(vload16,   __vload_tg, double16,    size_t, __private double*)
#pragma tg_funcdef(vload16,   __vload_tg, double16,    size_t, const __global double*)
#pragma tg_funcdef(vload16,   __vload_tg, double16,    size_t, const __local double*)
#pragma tg_funcdef(vload16,   __vload_tg, double16,    size_t, const __constant double*)
#pragma tg_funcdef(vload16,   __vload_tg, double16,    size_t, const __private double*)
 #endif
#undef vload16
#define vload16(__a, __b) __tg_builtin_gentype("vload16",__a, __b)

/* vstoren */
#pragma tg_funcdef(vstore,   __vstore_tg, void, char,     size_t, __global char*)
#pragma tg_funcdef(vstore,   __vstore_tg, void, short,    size_t, __global short*)
#pragma tg_funcdef(vstore,   __vstore_tg, void, int,      size_t, __global int*)
#pragma tg_funcdef(vstore,   __vstore_tg, void, long,     size_t, __global long*)
#pragma tg_funcdef(vstore,   __vstore_tg, void, float,    size_t, __global float*)
#pragma tg_funcdef(vstore,   __vstore_tg, void, uchar,    size_t, __global uchar*)
#pragma tg_funcdef(vstore,   __vstore_tg, void, ushort,   size_t, __global ushort*)
#pragma tg_funcdef(vstore,   __vstore_tg, void, uint,     size_t, __global uint*)
#pragma tg_funcdef(vstore,   __vstore_tg, void, ulong,    size_t, __global ulong*)
#pragma tg_funcdef(vstore,   __vstore_tg, void, char,     size_t, __local char*)
#pragma tg_funcdef(vstore,   __vstore_tg, void, short,    size_t, __local short*)
#pragma tg_funcdef(vstore,   __vstore_tg, void, int,      size_t, __local int*)
#pragma tg_funcdef(vstore,   __vstore_tg, void, long,     size_t, __local long*)
#pragma tg_funcdef(vstore,   __vstore_tg, void, float,    size_t, __local float*)
#pragma tg_funcdef(vstore,   __vstore_tg, void, uchar,    size_t, __local uchar*)
#pragma tg_funcdef(vstore,   __vstore_tg, void, ushort,   size_t, __local ushort*)
#pragma tg_funcdef(vstore,   __vstore_tg, void, uint,     size_t, __local uint*)
#pragma tg_funcdef(vstore,   __vstore_tg, void, ulong,    size_t, __local ulong*)
#pragma tg_funcdef(vstore,   __vstore_tg, void, char,     size_t, __private char*)
#pragma tg_funcdef(vstore,   __vstore_tg, void, short,    size_t, __private short*)
#pragma tg_funcdef(vstore,   __vstore_tg, void, int,      size_t, __private int*)
#pragma tg_funcdef(vstore,   __vstore_tg, void, long,     size_t, __private long*)
#pragma tg_funcdef(vstore,   __vstore_tg, void, float,    size_t, __private float*)
#pragma tg_funcdef(vstore,   __vstore_tg, void, uchar,    size_t, __private uchar*)
#pragma tg_funcdef(vstore,   __vstore_tg, void, ushort,   size_t, __private ushort*)
#pragma tg_funcdef(vstore,   __vstore_tg, void, uint,     size_t, __private uint*)
#pragma tg_funcdef(vstore,   __vstore_tg, void, ulong,    size_t, __private ulong*)

#pragma tg_funcdef(vstore,   __vstore_tg, void, double,    size_t, __global double*)
#pragma tg_funcdef(vstore,   __vstore_tg, void, double,    size_t, __local double*)
#pragma tg_funcdef(vstore,   __vstore_tg, void, double,    size_t, __private double*)

#undef vstore
#define vstore(__a, __b, __c) __tg_builtin_gentype("vstore",__a, __b, __c)

#pragma tg_funcdef(vstore2,   __vstore_tg, void, char2,     size_t, __global char*)
#pragma tg_funcdef(vstore2,   __vstore_tg, void, short2,    size_t, __global short*)
#pragma tg_funcdef(vstore2,   __vstore_tg, void, int2,      size_t, __global int*)
#pragma tg_funcdef(vstore2,   __vstore_tg, void, long2,     size_t, __global long*)
#pragma tg_funcdef(vstore2,   __vstore_tg, void, float2,    size_t, __global float*)
#pragma tg_funcdef(vstore2,   __vstore_tg, void, uchar2,    size_t, __global uchar*)
#pragma tg_funcdef(vstore2,   __vstore_tg, void, ushort2,   size_t, __global ushort*)
#pragma tg_funcdef(vstore2,   __vstore_tg, void, uint2,     size_t, __global uint*)
#pragma tg_funcdef(vstore2,   __vstore_tg, void, ulong2,    size_t, __global ulong*)
#pragma tg_funcdef(vstore2,   __vstore_tg, void, char2,     size_t, __local char*)
#pragma tg_funcdef(vstore2,   __vstore_tg, void, short2,    size_t, __local short*)
#pragma tg_funcdef(vstore2,   __vstore_tg, void, int2,      size_t, __local int*)
#pragma tg_funcdef(vstore2,   __vstore_tg, void, long2,     size_t, __local long*)
#pragma tg_funcdef(vstore2,   __vstore_tg, void, float2,    size_t, __local float*)
#pragma tg_funcdef(vstore2,   __vstore_tg, void, uchar2,    size_t, __local uchar*)
#pragma tg_funcdef(vstore2,   __vstore_tg, void, ushort2,   size_t, __local ushort*)
#pragma tg_funcdef(vstore2,   __vstore_tg, void, uint2,     size_t, __local uint*)
#pragma tg_funcdef(vstore2,   __vstore_tg, void, ulong2,    size_t, __local ulong*)
#pragma tg_funcdef(vstore2,   __vstore_tg, void, char2,     size_t, __private char*)
#pragma tg_funcdef(vstore2,   __vstore_tg, void, short2,    size_t, __private short*)
#pragma tg_funcdef(vstore2,   __vstore_tg, void, int2,      size_t, __private int*)
#pragma tg_funcdef(vstore2,   __vstore_tg, void, long2,     size_t, __private long*)
#pragma tg_funcdef(vstore2,   __vstore_tg, void, float2,    size_t, __private float*)
#pragma tg_funcdef(vstore2,   __vstore_tg, void, uchar2,    size_t, __private uchar*)
#pragma tg_funcdef(vstore2,   __vstore_tg, void, ushort2,   size_t, __private ushort*)
#pragma tg_funcdef(vstore2,   __vstore_tg, void, uint2,     size_t, __private uint*)
#pragma tg_funcdef(vstore2,   __vstore_tg, void, ulong2,    size_t, __private ulong*)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(vstore2,   __vstore_tg, void, double2,    size_t, __global double*)
#pragma tg_funcdef(vstore2,   __vstore_tg, void, double2,    size_t, __local double*)
#pragma tg_funcdef(vstore2,   __vstore_tg, void, double2,    size_t, __private double*)
 #endif
#undef vstore2
#define vstore2(__a, __b, __c) __tg_builtin_gentype("vstore2",__a, __b, __c)

#pragma tg_funcdef(vstore3,   __vstore_tg, void, char3,     size_t, __global char*)
#pragma tg_funcdef(vstore3,   __vstore_tg, void, short3,    size_t, __global short*)
#pragma tg_funcdef(vstore3,   __vstore_tg, void, int3,      size_t, __global int*)
#pragma tg_funcdef(vstore3,   __vstore_tg, void, long3,     size_t, __global long*)
#pragma tg_funcdef(vstore3,   __vstore_tg, void, float3,    size_t, __global float*)
#pragma tg_funcdef(vstore3,   __vstore_tg, void, uchar3,    size_t, __global uchar*)
#pragma tg_funcdef(vstore3,   __vstore_tg, void, ushort3,   size_t, __global ushort*)
#pragma tg_funcdef(vstore3,   __vstore_tg, void, uint3,     size_t, __global uint*)
#pragma tg_funcdef(vstore3,   __vstore_tg, void, ulong3,    size_t, __global ulong*)
#pragma tg_funcdef(vstore3,   __vstore_tg, void, char3,     size_t, __local char*)
#pragma tg_funcdef(vstore3,   __vstore_tg, void, short3,    size_t, __local short*)
#pragma tg_funcdef(vstore3,   __vstore_tg, void, int3,      size_t, __local int*)
#pragma tg_funcdef(vstore3,   __vstore_tg, void, long3,     size_t, __local long*)
#pragma tg_funcdef(vstore3,   __vstore_tg, void, float3,    size_t, __local float*)
#pragma tg_funcdef(vstore3,   __vstore_tg, void, uchar3,    size_t, __local uchar*)
#pragma tg_funcdef(vstore3,   __vstore_tg, void, ushort3,   size_t, __local ushort*)
#pragma tg_funcdef(vstore3,   __vstore_tg, void, uint3,     size_t, __local uint*)
#pragma tg_funcdef(vstore3,   __vstore_tg, void, ulong3,    size_t, __local ulong*)
#pragma tg_funcdef(vstore3,   __vstore_tg, void, char3,     size_t, __private char*)
#pragma tg_funcdef(vstore3,   __vstore_tg, void, short3,    size_t, __private short*)
#pragma tg_funcdef(vstore3,   __vstore_tg, void, int3,      size_t, __private int*)
#pragma tg_funcdef(vstore3,   __vstore_tg, void, long3,     size_t, __private long*)
#pragma tg_funcdef(vstore3,   __vstore_tg, void, float3,    size_t, __private float*)
#pragma tg_funcdef(vstore3,   __vstore_tg, void, uchar3,    size_t, __private uchar*)
#pragma tg_funcdef(vstore3,   __vstore_tg, void, ushort3,   size_t, __private ushort*)
#pragma tg_funcdef(vstore3,   __vstore_tg, void, uint3,     size_t, __private uint*)
#pragma tg_funcdef(vstore3,   __vstore_tg, void, ulong3,    size_t, __private ulong*)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(vstore3,   __vstore_tg, void, double3,    size_t, __global double*)
#pragma tg_funcdef(vstore3,   __vstore_tg, void, double3,    size_t, __local double*)
#pragma tg_funcdef(vstore3,   __vstore_tg, void, double3,    size_t, __private double*)
 #endif
#undef vstore3
#define vstore3(__a, __b, __c) __tg_builtin_gentype("vstore3",__a, __b, __c)

#pragma tg_funcdef(vstore4,   __vstore_tg, void, char4,     size_t, __global char*)
#pragma tg_funcdef(vstore4,   __vstore_tg, void, short4,    size_t, __global short*)
#pragma tg_funcdef(vstore4,   __vstore_tg, void, int4,      size_t, __global int*)
#pragma tg_funcdef(vstore4,   __vstore_tg, void, long4,     size_t, __global long*)
#pragma tg_funcdef(vstore4,   __vstore_tg, void, float4,    size_t, __global float*)
#pragma tg_funcdef(vstore4,   __vstore_tg, void, uchar4,    size_t, __global uchar*)
#pragma tg_funcdef(vstore4,   __vstore_tg, void, ushort4,   size_t, __global ushort*)
#pragma tg_funcdef(vstore4,   __vstore_tg, void, uint4,     size_t, __global uint*)
#pragma tg_funcdef(vstore4,   __vstore_tg, void, ulong4,    size_t, __global ulong*)
#pragma tg_funcdef(vstore4,   __vstore_tg, void, char4,     size_t, __local char*)
#pragma tg_funcdef(vstore4,   __vstore_tg, void, short4,    size_t, __local short*)
#pragma tg_funcdef(vstore4,   __vstore_tg, void, int4,      size_t, __local int*)
#pragma tg_funcdef(vstore4,   __vstore_tg, void, long4,     size_t, __local long*)
#pragma tg_funcdef(vstore4,   __vstore_tg, void, float4,    size_t, __local float*)
#pragma tg_funcdef(vstore4,   __vstore_tg, void, uchar4,    size_t, __local uchar*)
#pragma tg_funcdef(vstore4,   __vstore_tg, void, ushort4,   size_t, __local ushort*)
#pragma tg_funcdef(vstore4,   __vstore_tg, void, uint4,     size_t, __local uint*)
#pragma tg_funcdef(vstore4,   __vstore_tg, void, ulong4,    size_t, __local ulong*)
#pragma tg_funcdef(vstore4,   __vstore_tg, void, char4,     size_t, __private char*)
#pragma tg_funcdef(vstore4,   __vstore_tg, void, short4,    size_t, __private short*)
#pragma tg_funcdef(vstore4,   __vstore_tg, void, int4,      size_t, __private int*)
#pragma tg_funcdef(vstore4,   __vstore_tg, void, long4,     size_t, __private long*)
#pragma tg_funcdef(vstore4,   __vstore_tg, void, float4,    size_t, __private float*)
#pragma tg_funcdef(vstore4,   __vstore_tg, void, uchar4,    size_t, __private uchar*)
#pragma tg_funcdef(vstore4,   __vstore_tg, void, ushort4,   size_t, __private ushort*)
#pragma tg_funcdef(vstore4,   __vstore_tg, void, uint4,     size_t, __private uint*)
#pragma tg_funcdef(vstore4,   __vstore_tg, void, ulong4,    size_t, __private ulong*)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(vstore4,   __vstore_tg, void, double4,    size_t, __global double*)
#pragma tg_funcdef(vstore4,   __vstore_tg, void, double4,    size_t, __local double*)
#pragma tg_funcdef(vstore4,   __vstore_tg, void, double4,    size_t, __private double*)
 #endif
#undef vstore4
#define vstore4(__a, __b, __c) __tg_builtin_gentype("vstore4",__a, __b, __c)

#pragma tg_funcdef(vstore8,   __vstore_tg, void, char8,     size_t, __global char*)
#pragma tg_funcdef(vstore8,   __vstore_tg, void, short8,    size_t, __global short*)
#pragma tg_funcdef(vstore8,   __vstore_tg, void, int8,      size_t, __global int*)
#pragma tg_funcdef(vstore8,   __vstore_tg, void, long8,     size_t, __global long*)
#pragma tg_funcdef(vstore8,   __vstore_tg, void, float8,    size_t, __global float*)
#pragma tg_funcdef(vstore8,   __vstore_tg, void, uchar8,    size_t, __global uchar*)
#pragma tg_funcdef(vstore8,   __vstore_tg, void, ushort8,   size_t, __global ushort*)
#pragma tg_funcdef(vstore8,   __vstore_tg, void, uint8,     size_t, __global uint*)
#pragma tg_funcdef(vstore8,   __vstore_tg, void, ulong8,    size_t, __global ulong*)
#pragma tg_funcdef(vstore8,   __vstore_tg, void, char8,     size_t, __local char*)
#pragma tg_funcdef(vstore8,   __vstore_tg, void, short8,    size_t, __local short*)
#pragma tg_funcdef(vstore8,   __vstore_tg, void, int8,      size_t, __local int*)
#pragma tg_funcdef(vstore8,   __vstore_tg, void, long8,     size_t, __local long*)
#pragma tg_funcdef(vstore8,   __vstore_tg, void, float8,    size_t, __local float*)
#pragma tg_funcdef(vstore8,   __vstore_tg, void, uchar8,    size_t, __local uchar*)
#pragma tg_funcdef(vstore8,   __vstore_tg, void, ushort8,   size_t, __local ushort*)
#pragma tg_funcdef(vstore8,   __vstore_tg, void, uint8,     size_t, __local uint*)
#pragma tg_funcdef(vstore8,   __vstore_tg, void, ulong8,    size_t, __local ulong*)
#pragma tg_funcdef(vstore8,   __vstore_tg, void, char8,     size_t, __private char*)
#pragma tg_funcdef(vstore8,   __vstore_tg, void, short8,    size_t, __private short*)
#pragma tg_funcdef(vstore8,   __vstore_tg, void, int8,      size_t, __private int*)
#pragma tg_funcdef(vstore8,   __vstore_tg, void, long8,     size_t, __private long*)
#pragma tg_funcdef(vstore8,   __vstore_tg, void, float8,    size_t, __private float*)
#pragma tg_funcdef(vstore8,   __vstore_tg, void, uchar8,    size_t, __private uchar*)
#pragma tg_funcdef(vstore8,   __vstore_tg, void, ushort8,   size_t, __private ushort*)
#pragma tg_funcdef(vstore8,   __vstore_tg, void, uint8,     size_t, __private uint*)
#pragma tg_funcdef(vstore8,   __vstore_tg, void, ulong8,    size_t, __private ulong*)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(vstore8,   __vstore_tg, void, double8,    size_t, __global double*)
#pragma tg_funcdef(vstore8,   __vstore_tg, void, double8,    size_t, __local double*)
#pragma tg_funcdef(vstore8,   __vstore_tg, void, double8,    size_t, __private double*)
 #endif
#undef vstore8
#define vstore8(__a, __b, __c) __tg_builtin_gentype("vstore8",__a, __b, __c)

#pragma tg_funcdef(vstore16,   __vstore_tg, void, char16,     size_t, __global char*)
#pragma tg_funcdef(vstore16,   __vstore_tg, void, short16,    size_t, __global short*)
#pragma tg_funcdef(vstore16,   __vstore_tg, void, int16,      size_t, __global int*)
#pragma tg_funcdef(vstore16,   __vstore_tg, void, long16,     size_t, __global long*)
#pragma tg_funcdef(vstore16,   __vstore_tg, void, float16,    size_t, __global float*)
#pragma tg_funcdef(vstore16,   __vstore_tg, void, uchar16,    size_t, __global uchar*)
#pragma tg_funcdef(vstore16,   __vstore_tg, void, ushort16,   size_t, __global ushort*)
#pragma tg_funcdef(vstore16,   __vstore_tg, void, uint16,     size_t, __global uint*)
#pragma tg_funcdef(vstore16,   __vstore_tg, void, ulong16,    size_t, __global ulong*)
#pragma tg_funcdef(vstore16,   __vstore_tg, void, char16,     size_t, __local char*)
#pragma tg_funcdef(vstore16,   __vstore_tg, void, short16,    size_t, __local short*)
#pragma tg_funcdef(vstore16,   __vstore_tg, void, int16,      size_t, __local int*)
#pragma tg_funcdef(vstore16,   __vstore_tg, void, long16,     size_t, __local long*)
#pragma tg_funcdef(vstore16,   __vstore_tg, void, float16,    size_t, __local float*)
#pragma tg_funcdef(vstore16,   __vstore_tg, void, uchar16,    size_t, __local uchar*)
#pragma tg_funcdef(vstore16,   __vstore_tg, void, ushort16,   size_t, __local ushort*)
#pragma tg_funcdef(vstore16,   __vstore_tg, void, uint16,     size_t, __local uint*)
#pragma tg_funcdef(vstore16,   __vstore_tg, void, ulong16,    size_t, __local ulong*)
#pragma tg_funcdef(vstore16,   __vstore_tg, void, char16,     size_t, __private char*)
#pragma tg_funcdef(vstore16,   __vstore_tg, void, short16,    size_t, __private short*)
#pragma tg_funcdef(vstore16,   __vstore_tg, void, int16,      size_t, __private int*)
#pragma tg_funcdef(vstore16,   __vstore_tg, void, long16,     size_t, __private long*)
#pragma tg_funcdef(vstore16,   __vstore_tg, void, float16,    size_t, __private float*)
#pragma tg_funcdef(vstore16,   __vstore_tg, void, uchar16,    size_t, __private uchar*)
#pragma tg_funcdef(vstore16,   __vstore_tg, void, ushort16,   size_t, __private ushort*)
#pragma tg_funcdef(vstore16,   __vstore_tg, void, uint16,     size_t, __private uint*)
#pragma tg_funcdef(vstore16,   __vstore_tg, void, ulong16,    size_t, __private ulong*)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(vstore16,   __vstore_tg, void, double16,    size_t, __global double*)
#pragma tg_funcdef(vstore16,   __vstore_tg, void, double16,    size_t, __local double*)
#pragma tg_funcdef(vstore16,   __vstore_tg, void, double16,    size_t, __private double*)
 #endif
#undef vstore16
#define vstore16(__a, __b, __c) __tg_builtin_gentype("vstore16",__a, __b, __c)

/* vload_halfN */
#pragma tg_funcdef(vload_half, vload_half_tg, float, size_t, __global   half*, int)
#pragma tg_funcdef(vload_half, vload_half_tg, float, size_t, __local    half*, int)
#pragma tg_funcdef(vload_half, vload_half_tg, float, size_t, __constant half*, int)
#pragma tg_funcdef(vload_half, vload_half_tg, float, size_t, __private  half*, int)
#pragma tg_funcdef(vload_half, vload_half_tg, float, size_t, const __global   half*, int)
#pragma tg_funcdef(vload_half, vload_half_tg, float, size_t, const __local    half*, int)
#pragma tg_funcdef(vload_half, vload_half_tg, float, size_t, const __constant half*, int)
#pragma tg_funcdef(vload_half, vload_half_tg, float, size_t, const __private  half*, int)
#pragma tg_funcdef(vload_half, vload_half_tg, double, size_t, __global   half*, int)
#pragma tg_funcdef(vload_half, vload_half_tg, double, size_t, __local    half*, int)
#pragma tg_funcdef(vload_half, vload_half_tg, double, size_t, __constant half*, int)
#pragma tg_funcdef(vload_half, vload_half_tg, double, size_t, __private  half*, int)
#pragma tg_funcdef(vload_half, vload_half_tg, double, size_t, const __global   half*, int)
#pragma tg_funcdef(vload_half, vload_half_tg, double, size_t, const __local    half*, int)
#pragma tg_funcdef(vload_half, vload_half_tg, double, size_t, const __constant half*, int)
#pragma tg_funcdef(vload_half, vload_half_tg, double, size_t, const __private  half*, int)
#undef vload_half
#undef vloada_half
#define vload_half(__a, __b)  __tg_builtin_gentype("vload_half",__a, __b, 0)
#define vloada_half(__a, __b) __tg_builtin_gentype("vload_half",__a, __b, 1)

#pragma tg_funcdef(vload_half2, vload_half_tg, float2, size_t, __global   half*, int)
#pragma tg_funcdef(vload_half2, vload_half_tg, float2, size_t, __local    half*, int)
#pragma tg_funcdef(vload_half2, vload_half_tg, float2, size_t, __constant half*, int)
#pragma tg_funcdef(vload_half2, vload_half_tg, float2, size_t, __private  half*, int)
#pragma tg_funcdef(vload_half2, vload_half_tg, float2, size_t, const __global   half*, int)
#pragma tg_funcdef(vload_half2, vload_half_tg, float2, size_t, const __local    half*, int)
#pragma tg_funcdef(vload_half2, vload_half_tg, float2, size_t, const __constant half*, int)
#pragma tg_funcdef(vload_half2, vload_half_tg, float2, size_t, const __private  half*, int)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(vload_half2, vload_half_tg, double2, size_t, __global   half*, int)
#pragma tg_funcdef(vload_half2, vload_half_tg, double2, size_t, __local    half*, int)
#pragma tg_funcdef(vload_half2, vload_half_tg, double2, size_t, __constant half*, int)
#pragma tg_funcdef(vload_half2, vload_half_tg, double2, size_t, __private  half*, int)
#pragma tg_funcdef(vload_half2, vload_half_tg, double2, size_t, const __global   half*, int)
#pragma tg_funcdef(vload_half2, vload_half_tg, double2, size_t, const __local    half*, int)
#pragma tg_funcdef(vload_half2, vload_half_tg, double2, size_t, const __constant half*, int)
#pragma tg_funcdef(vload_half2, vload_half_tg, double2, size_t, const __private  half*, int)
 #endif
#undef vload_half2
#undef vloada_half2
#define vload_half2(__a, __b)  __tg_builtin_gentype("vload_half2",__a, __b, 0)
#define vloada_half2(__a, __b) __tg_builtin_gentype("vload_half2",__a, __b, 1)

#pragma tg_funcdef(vload_half3, vload_half_tg, float3, size_t, __global   half*, int)
#pragma tg_funcdef(vload_half3, vload_half_tg, float3, size_t, __local    half*, int)
#pragma tg_funcdef(vload_half3, vload_half_tg, float3, size_t, __constant half*, int)
#pragma tg_funcdef(vload_half3, vload_half_tg, float3, size_t, __private  half*, int)
#pragma tg_funcdef(vload_half3, vload_half_tg, float3, size_t, const __global   half*, int)
#pragma tg_funcdef(vload_half3, vload_half_tg, float3, size_t, const __local    half*, int)
#pragma tg_funcdef(vload_half3, vload_half_tg, float3, size_t, const __constant half*, int)
#pragma tg_funcdef(vload_half3, vload_half_tg, float3, size_t, const __private  half*, int)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(vload_half3, vload_half_tg, double3, size_t, __global   half*, int)
#pragma tg_funcdef(vload_half3, vload_half_tg, double3, size_t, __local    half*, int)
#pragma tg_funcdef(vload_half3, vload_half_tg, double3, size_t, __constant half*, int)
#pragma tg_funcdef(vload_half3, vload_half_tg, double3, size_t, __private  half*, int)
#pragma tg_funcdef(vload_half3, vload_half_tg, double3, size_t, const __global   half*, int)
#pragma tg_funcdef(vload_half3, vload_half_tg, double3, size_t, const __local    half*, int)
#pragma tg_funcdef(vload_half3, vload_half_tg, double3, size_t, const __constant half*, int)
#pragma tg_funcdef(vload_half3, vload_half_tg, double3, size_t, const __private  half*, int)
 #endif
#undef vload_half3
#undef vloada_half3
#define vload_half3(__a, __b)  __tg_builtin_gentype("vload_half3",__a, __b, 0)
#define vloada_half3(__a, __b) __tg_builtin_gentype("vload_half3",__a, __b, 1)

#pragma tg_funcdef(vload_half4, vload_half_tg, float4, size_t, __global   half*, int)
#pragma tg_funcdef(vload_half4, vload_half_tg, float4, size_t, __local    half*, int)
#pragma tg_funcdef(vload_half4, vload_half_tg, float4, size_t, __constant half*, int)
#pragma tg_funcdef(vload_half4, vload_half_tg, float4, size_t, __private  half*, int)
#pragma tg_funcdef(vload_half4, vload_half_tg, float4, size_t, const __global   half*, int)
#pragma tg_funcdef(vload_half4, vload_half_tg, float4, size_t, const __local    half*, int)
#pragma tg_funcdef(vload_half4, vload_half_tg, float4, size_t, const __constant half*, int)
#pragma tg_funcdef(vload_half4, vload_half_tg, float4, size_t, const __private  half*, int)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(vload_half4, vload_half_tg, double4, size_t, __global   half*, int)
#pragma tg_funcdef(vload_half4, vload_half_tg, double4, size_t, __local    half*, int)
#pragma tg_funcdef(vload_half4, vload_half_tg, double4, size_t, __constant half*, int)
#pragma tg_funcdef(vload_half4, vload_half_tg, double4, size_t, __private  half*, int)
#pragma tg_funcdef(vload_half4, vload_half_tg, double4, size_t, const __global   half*, int)
#pragma tg_funcdef(vload_half4, vload_half_tg, double4, size_t, const __local    half*, int)
#pragma tg_funcdef(vload_half4, vload_half_tg, double4, size_t, const __constant half*, int)
#pragma tg_funcdef(vload_half4, vload_half_tg, double4, size_t, const __private  half*, int)
 #endif
#undef vload_half4
#undef vloada_half4
#define vload_half4(__a, __b)  __tg_builtin_gentype("vload_half4",__a, __b, 0)
#define vloada_half4(__a, __b) __tg_builtin_gentype("vload_half4",__a, __b, 1)

#pragma tg_funcdef(vload_half8, vload_half_tg, float8, size_t, __global   half*, int)
#pragma tg_funcdef(vload_half8, vload_half_tg, float8, size_t, __local    half*, int)
#pragma tg_funcdef(vload_half8, vload_half_tg, float8, size_t, __constant half*, int)
#pragma tg_funcdef(vload_half8, vload_half_tg, float8, size_t, __private  half*, int)
#pragma tg_funcdef(vload_half8, vload_half_tg, float8, size_t, const __global   half*, int)
#pragma tg_funcdef(vload_half8, vload_half_tg, float8, size_t, const __local    half*, int)
#pragma tg_funcdef(vload_half8, vload_half_tg, float8, size_t, const __constant half*, int)
#pragma tg_funcdef(vload_half8, vload_half_tg, float8, size_t, const __private  half*, int)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(vload_half8, vload_half_tg, double8, size_t, __global   half*, int)
#pragma tg_funcdef(vload_half8, vload_half_tg, double8, size_t, __local    half*, int)
#pragma tg_funcdef(vload_half8, vload_half_tg, double8, size_t, __constant half*, int)
#pragma tg_funcdef(vload_half8, vload_half_tg, double8, size_t, __private  half*, int)
#pragma tg_funcdef(vload_half8, vload_half_tg, double8, size_t, const __global   half*, int)
#pragma tg_funcdef(vload_half8, vload_half_tg, double8, size_t, const __local    half*, int)
#pragma tg_funcdef(vload_half8, vload_half_tg, double8, size_t, const __constant half*, int)
#pragma tg_funcdef(vload_half8, vload_half_tg, double8, size_t, const __private  half*, int)
 #endif
#undef vload_half8
#undef vloada_half8
#define vload_half8(__a, __b)  __tg_builtin_gentype("vload_half8",__a, __b, 0)
#define vloada_half8(__a, __b) __tg_builtin_gentype("vload_half8",__a, __b, 1)

#pragma tg_funcdef(vload_half16, vload_half_tg, float16, size_t, __global   half*, int)
#pragma tg_funcdef(vload_half16, vload_half_tg, float16, size_t, __local    half*, int)
#pragma tg_funcdef(vload_half16, vload_half_tg, float16, size_t, __constant half*, int)
#pragma tg_funcdef(vload_half16, vload_half_tg, float16, size_t, __private  half*, int)
#pragma tg_funcdef(vload_half16, vload_half_tg, float16, size_t, const __global   half*, int)
#pragma tg_funcdef(vload_half16, vload_half_tg, float16, size_t, const __local    half*, int)
#pragma tg_funcdef(vload_half16, vload_half_tg, float16, size_t, const __constant half*, int)
#pragma tg_funcdef(vload_half16, vload_half_tg, float16, size_t, const __private  half*, int)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(vload_half16, vload_half_tg, double16, size_t, __global   half*, int)
#pragma tg_funcdef(vload_half16, vload_half_tg, double16, size_t, __local    half*, int)
#pragma tg_funcdef(vload_half16, vload_half_tg, double16, size_t, __constant half*, int)
#pragma tg_funcdef(vload_half16, vload_half_tg, double16, size_t, __private  half*, int)
#pragma tg_funcdef(vload_half16, vload_half_tg, double16, size_t, const __global   half*, int)
#pragma tg_funcdef(vload_half16, vload_half_tg, double16, size_t, const __local    half*, int)
#pragma tg_funcdef(vload_half16, vload_half_tg, double16, size_t, const __constant half*, int)
#pragma tg_funcdef(vload_half16, vload_half_tg, double16, size_t, const __private  half*, int)
 #endif
#undef vload_half16
#undef vloada_half16
#define vload_half16(__a, __b)  __tg_builtin_gentype("vload_half16",__a, __b, 0)
#define vloada_half16(__a, __b) __tg_builtin_gentype("vload_half16",__a, __b, 1)

/* vstore_halfN<_roundingMode> */
#pragma tg_funcdef(vstore_half, vstore_half_tg, void, float, size_t, __global  half*, int, int)
#pragma tg_funcdef(vstore_half, vstore_half_tg, void, float, size_t, __local   half*, int, int)
#pragma tg_funcdef(vstore_half, vstore_half_tg, void, float, size_t, __private half*, int, int)
#pragma tg_funcdef(vstore_half, vstore_half_tg, void, double, size_t, __global  half*, int, int)
#pragma tg_funcdef(vstore_half, vstore_half_tg, void, double, size_t, __local   half*, int, int)
#pragma tg_funcdef(vstore_half, vstore_half_tg, void, double, size_t, __private half*, int, int)
#undef vstore_half
#undef vstore_half_rte
#undef vstore_half_rtz
#undef vstore_half_rtp
#undef vstore_half_rtn
#undef vstorea_half
#undef vstorea_half_rte
#undef vstorea_half_rtz
#undef vstorea_half_rtp
#undef vstorea_half_rtn
#define vstore_half(__a, __b, __c)      __tg_builtin_gentype("vstore_half",__a, __b, __c, 0, 0)
#define vstore_half_rte(__a, __b, __c)  __tg_builtin_gentype("vstore_half",__a, __b, __c, 0, 1)
#define vstore_half_rtz(__a, __b, __c)  __tg_builtin_gentype("vstore_half",__a, __b, __c, 0, 2)
#define vstore_half_rtp(__a, __b, __c)  __tg_builtin_gentype("vstore_half",__a, __b, __c, 0, 3)
#define vstore_half_rtn(__a, __b, __c)  __tg_builtin_gentype("vstore_half",__a, __b, __c, 0, 4)
#define vstorea_half(__a, __b, __c)     __tg_builtin_gentype("vstore_half",__a, __b, __c, 1, 0)
#define vstorea_half_rte(__a, __b, __c) __tg_builtin_gentype("vstore_half",__a, __b, __c, 1, 1)
#define vstorea_half_rtz(__a, __b, __c) __tg_builtin_gentype("vstore_half",__a, __b, __c, 1, 2)
#define vstorea_half_rtp(__a, __b, __c) __tg_builtin_gentype("vstore_half",__a, __b, __c, 1, 3)
#define vstorea_half_rtn(__a, __b, __c) __tg_builtin_gentype("vstore_half",__a, __b, __c, 1, 4)

#pragma tg_funcdef(vstore_half2, vstore_half_tg, void, float2, size_t, __global  half*, int, int)
#pragma tg_funcdef(vstore_half2, vstore_half_tg, void, float2, size_t, __local   half*, int, int)
#pragma tg_funcdef(vstore_half2, vstore_half_tg, void, float2, size_t, __private half*, int, int)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(vstore_half2, vstore_half_tg, void, double2, size_t, __global  half*, int, int)
#pragma tg_funcdef(vstore_half2, vstore_half_tg, void, double2, size_t, __local   half*, int, int)
#pragma tg_funcdef(vstore_half2, vstore_half_tg, void, double2, size_t, __private half*, int, int)
 #endif
#undef vstore_half2
#undef vstore_half2_rte
#undef vstore_half2_rtz
#undef vstore_half2_rtp
#undef vstore_half2_rtn
#undef vstorea_half2
#undef vstorea_half2_rte
#undef vstorea_half2_rtz
#undef vstorea_half2_rtp
#undef vstorea_half2_rtn
#define vstore_half2(__a, __b, __c)      __tg_builtin_gentype("vstore_half2",__a, __b, __c, 0, 0)
#define vstore_half2_rte(__a, __b, __c)  __tg_builtin_gentype("vstore_half2",__a, __b, __c, 0, 1)
#define vstore_half2_rtz(__a, __b, __c)  __tg_builtin_gentype("vstore_half2",__a, __b, __c, 0, 2)
#define vstore_half2_rtp(__a, __b, __c)  __tg_builtin_gentype("vstore_half2",__a, __b, __c, 0, 3)
#define vstore_half2_rtn(__a, __b, __c)  __tg_builtin_gentype("vstore_half2",__a, __b, __c, 0, 4)
#define vstorea_half2(__a, __b, __c)     __tg_builtin_gentype("vstore_half2",__a, __b, __c, 1, 0)
#define vstorea_half2_rte(__a, __b, __c) __tg_builtin_gentype("vstore_half2",__a, __b, __c, 1, 1)
#define vstorea_half2_rtz(__a, __b, __c) __tg_builtin_gentype("vstore_half2",__a, __b, __c, 1, 2)
#define vstorea_half2_rtp(__a, __b, __c) __tg_builtin_gentype("vstore_half2",__a, __b, __c, 1, 3)
#define vstorea_half2_rtn(__a, __b, __c) __tg_builtin_gentype("vstore_half2",__a, __b, __c, 1, 4)

#pragma tg_funcdef(vstore_half3, vstore_half_tg, void, float3, size_t, __global  half*, int, int)
#pragma tg_funcdef(vstore_half3, vstore_half_tg, void, float3, size_t, __local   half*, int, int)
#pragma tg_funcdef(vstore_half3, vstore_half_tg, void, float3, size_t, __private half*, int, int)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(vstore_half3, vstore_half_tg, void, double3, size_t, __global  half*, int, int)
#pragma tg_funcdef(vstore_half3, vstore_half_tg, void, double3, size_t, __local   half*, int, int)
#pragma tg_funcdef(vstore_half3, vstore_half_tg, void, double3, size_t, __private half*, int, int)
 #endif
#undef vstore_half3
#undef vstore_half3_rte
#undef vstore_half3_rtz
#undef vstore_half3_rtp
#undef vstore_half3_rtn
#undef vstorea_half3
#undef vstorea_half3_rte
#undef vstorea_half3_rtz
#undef vstorea_half3_rtp
#undef vstorea_half3_rtn
#define vstore_half3(__a, __b, __c)      __tg_builtin_gentype("vstore_half3",__a, __b, __c, 0, 0)
#define vstore_half3_rte(__a, __b, __c)  __tg_builtin_gentype("vstore_half3",__a, __b, __c, 0, 1)
#define vstore_half3_rtz(__a, __b, __c)  __tg_builtin_gentype("vstore_half3",__a, __b, __c, 0, 2)
#define vstore_half3_rtp(__a, __b, __c)  __tg_builtin_gentype("vstore_half3",__a, __b, __c, 0, 3)
#define vstore_half3_rtn(__a, __b, __c)  __tg_builtin_gentype("vstore_half3",__a, __b, __c, 0, 4)
#define vstorea_half3(__a, __b, __c)     __tg_builtin_gentype("vstore_half3",__a, __b, __c, 1, 0)
#define vstorea_half3_rte(__a, __b, __c) __tg_builtin_gentype("vstore_half3",__a, __b, __c, 1, 1)
#define vstorea_half3_rtz(__a, __b, __c) __tg_builtin_gentype("vstore_half3",__a, __b, __c, 1, 2)
#define vstorea_half3_rtp(__a, __b, __c) __tg_builtin_gentype("vstore_half3",__a, __b, __c, 1, 3)
#define vstorea_half3_rtn(__a, __b, __c) __tg_builtin_gentype("vstore_half3",__a, __b, __c, 1, 4)

#pragma tg_funcdef(vstore_half4, vstore_half_tg, void, float4, size_t, __global  half*, int, int)
#pragma tg_funcdef(vstore_half4, vstore_half_tg, void, float4, size_t, __local   half*, int, int)
#pragma tg_funcdef(vstore_half4, vstore_half_tg, void, float4, size_t, __private half*, int, int)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(vstore_half4, vstore_half_tg, void, double4, size_t, __global  half*, int, int)
#pragma tg_funcdef(vstore_half4, vstore_half_tg, void, double4, size_t, __local   half*, int, int)
#pragma tg_funcdef(vstore_half4, vstore_half_tg, void, double4, size_t, __private half*, int, int)
 #endif
#undef vstore_half4
#undef vstore_half4_rte
#undef vstore_half4_rtz
#undef vstore_half4_rtp
#undef vstore_half4_rtn
#undef vstorea_half4
#undef vstorea_half4_rte
#undef vstorea_half4_rtz
#undef vstorea_half4_rtp
#undef vstorea_half4_rtn
#define vstore_half4(__a, __b, __c)      __tg_builtin_gentype("vstore_half4",__a, __b, __c, 0, 0)
#define vstore_half4_rte(__a, __b, __c)  __tg_builtin_gentype("vstore_half4",__a, __b, __c, 0, 1)
#define vstore_half4_rtz(__a, __b, __c)  __tg_builtin_gentype("vstore_half4",__a, __b, __c, 0, 2)
#define vstore_half4_rtp(__a, __b, __c)  __tg_builtin_gentype("vstore_half4",__a, __b, __c, 0, 3)
#define vstore_half4_rtn(__a, __b, __c)  __tg_builtin_gentype("vstore_half4",__a, __b, __c, 0, 4)
#define vstorea_half4(__a, __b, __c)     __tg_builtin_gentype("vstore_half4",__a, __b, __c, 1, 0)
#define vstorea_half4_rte(__a, __b, __c) __tg_builtin_gentype("vstore_half4",__a, __b, __c, 1, 1)
#define vstorea_half4_rtz(__a, __b, __c) __tg_builtin_gentype("vstore_half4",__a, __b, __c, 1, 2)
#define vstorea_half4_rtp(__a, __b, __c) __tg_builtin_gentype("vstore_half4",__a, __b, __c, 1, 3)
#define vstorea_half4_rtn(__a, __b, __c) __tg_builtin_gentype("vstore_half4",__a, __b, __c, 1, 4)

#pragma tg_funcdef(vstore_half8, vstore_half_tg, void, float8, size_t, __global  half*, int, int)
#pragma tg_funcdef(vstore_half8, vstore_half_tg, void, float8, size_t, __local   half*, int, int)
#pragma tg_funcdef(vstore_half8, vstore_half_tg, void, float8, size_t, __private half*, int, int)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(vstore_half8, vstore_half_tg, void, double8, size_t, __global  half*, int, int)
#pragma tg_funcdef(vstore_half8, vstore_half_tg, void, double8, size_t, __local   half*, int, int)
#pragma tg_funcdef(vstore_half8, vstore_half_tg, void, double8, size_t, __private half*, int, int)
 #endif
#undef vstore_half8
#undef vstore_half8_rte
#undef vstore_half8_rtz
#undef vstore_half8_rtp
#undef vstore_half8_rtn
#undef vstorea_half8
#undef vstorea_half8_rte
#undef vstorea_half8_rtz
#undef vstorea_half8_rtp
#undef vstorea_half8_rtn
#define vstore_half8(__a, __b, __c)      __tg_builtin_gentype("vstore_half8",__a, __b, __c, 0, 0)
#define vstore_half8_rte(__a, __b, __c)  __tg_builtin_gentype("vstore_half8",__a, __b, __c, 0, 1)
#define vstore_half8_rtz(__a, __b, __c)  __tg_builtin_gentype("vstore_half8",__a, __b, __c, 0, 2)
#define vstore_half8_rtp(__a, __b, __c)  __tg_builtin_gentype("vstore_half8",__a, __b, __c, 0, 3)
#define vstore_half8_rtn(__a, __b, __c)  __tg_builtin_gentype("vstore_half8",__a, __b, __c, 0, 4)
#define vstorea_half8(__a, __b, __c)     __tg_builtin_gentype("vstore_half8",__a, __b, __c, 1, 0)
#define vstorea_half8_rte(__a, __b, __c) __tg_builtin_gentype("vstore_half8",__a, __b, __c, 1, 1)
#define vstorea_half8_rtz(__a, __b, __c) __tg_builtin_gentype("vstore_half8",__a, __b, __c, 1, 2)
#define vstorea_half8_rtp(__a, __b, __c) __tg_builtin_gentype("vstore_half8",__a, __b, __c, 1, 3)
#define vstorea_half8_rtn(__a, __b, __c) __tg_builtin_gentype("vstore_half8",__a, __b, __c, 1, 4)

#pragma tg_funcdef(vstore_half16, vstore_half_tg, void, float16, size_t, __global  half*, int, int)
#pragma tg_funcdef(vstore_half16, vstore_half_tg, void, float16, size_t, __local   half*, int, int)
#pragma tg_funcdef(vstore_half16, vstore_half_tg, void, float16, size_t, __private half*, int, int)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(vstore_half16, vstore_half_tg, void, double16, size_t, __global  half*, int, int)
#pragma tg_funcdef(vstore_half16, vstore_half_tg, void, double16, size_t, __local   half*, int, int)
#pragma tg_funcdef(vstore_half16, vstore_half_tg, void, double16, size_t, __private half*, int, int)
 #endif
#undef vstore_half16
#undef vstore_half16_rte
#undef vstore_half16_rtz
#undef vstore_half16_rtp
#undef vstore_half16_rtn
#undef vstorea_half16
#undef vstorea_half16_rte
#undef vstorea_half16_rtz
#undef vstorea_half16_rtp
#undef vstorea_half16_rtn
#define vstore_half16(__a, __b, __c)      __tg_builtin_gentype("vstore_half16",__a, __b, __c, 0, 0)
#define vstore_half16_rte(__a, __b, __c)  __tg_builtin_gentype("vstore_half16",__a, __b, __c, 0, 1)
#define vstore_half16_rtz(__a, __b, __c)  __tg_builtin_gentype("vstore_half16",__a, __b, __c, 0, 2)
#define vstore_half16_rtp(__a, __b, __c)  __tg_builtin_gentype("vstore_half16",__a, __b, __c, 0, 3)
#define vstore_half16_rtn(__a, __b, __c)  __tg_builtin_gentype("vstore_half16",__a, __b, __c, 0, 4)
#define vstorea_half16(__a, __b, __c)     __tg_builtin_gentype("vstore_half16",__a, __b, __c, 1, 0)
#define vstorea_half16_rte(__a, __b, __c) __tg_builtin_gentype("vstore_half16",__a, __b, __c, 1, 1)
#define vstorea_half16_rtz(__a, __b, __c) __tg_builtin_gentype("vstore_half16",__a, __b, __c, 1, 2)
#define vstorea_half16_rtp(__a, __b, __c) __tg_builtin_gentype("vstore_half16",__a, __b, __c, 1, 3)
#define vstorea_half16_rtn(__a, __b, __c) __tg_builtin_gentype("vstore_half16",__a, __b, __c, 1, 4)

/* 6.11.8 Image Read and Write Functions - Not applicable */

/* 6.11.9 Synchronization Functions */
#undef barrier
#define barrier __barrier

/* 6.11.10 Explicit Memory Fence Functions */
#undef mem_fence
#define mem_fence __mem_fence
#undef read_mem_fence
#define read_mem_fence __read_mem_fence
#undef write_mem_fence
#define write_mem_fence __write_mem_fence

/* 6.11.11 Async Copies from Global to Local Memory, Local to Global Memory, and Prefetch */
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_char,  event_t, __local char*, __global char*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_short, event_t, __local char2*, __global char2*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_int,   event_t, __local char3*, __global char3*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_int,   event_t, __local char4*, __global char4*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_long,  event_t, __local char8*, __global char8*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_long2, event_t, __local char16*, __global char16*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_char,  event_t, __local uchar*, __global uchar*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_short, event_t, __local uchar2*, __global uchar2*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_int,   event_t, __local uchar3*, __global uchar3*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_int,   event_t, __local uchar4*, __global uchar4*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_long,  event_t, __local uchar8*, __global uchar8*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_long2, event_t, __local uchar16*, __global uchar16*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_short, event_t, __local short*, __global short*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_int,   event_t, __local short2*, __global short2*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_long,  event_t, __local short3*, __global short3*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_long,  event_t, __local short4*, __global short4*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_long2, event_t, __local short8*, __global short8*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_long4, event_t, __local short16*, __global short16*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_short, event_t, __local ushort*, __global ushort*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_int,   event_t, __local ushort2*, __global ushort2*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_long,  event_t, __local ushort3*, __global ushort3*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_long,  event_t, __local ushort4*, __global ushort4*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_long2, event_t, __local ushort8*, __global ushort8*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_long4, event_t, __local ushort16*, __global ushort16*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_int,   event_t, __local int*, __global int*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_long,  event_t, __local int2*, __global int2*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_long2, event_t, __local int3*, __global int3*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_long2, event_t, __local int4*, __global int4*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_long4, event_t, __local int8*, __global int8*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_long8, event_t, __local int16*, __global int16*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_int,   event_t, __local uint*, __global uint*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_long,  event_t, __local uint2*, __global uint2*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_long2, event_t, __local uint3*, __global uint3*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_long2, event_t, __local uint4*, __global uint4*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_long4, event_t, __local uint8*, __global uint8*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_long8, event_t, __local uint16*, __global uint16*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_long,  event_t, __local long*, __global long*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_long2, event_t, __local long2*, __global long2*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_long4, event_t, __local long3*, __global long3*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_long4, event_t, __local long4*, __global long4*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_long8, event_t, __local long8*, __global long8*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_long16,event_t, __local long16*, __global long16*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_long,  event_t, __local ulong*, __global ulong*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_long2, event_t, __local ulong2*, __global ulong2*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_long4, event_t, __local ulong3*, __global ulong3*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_long4, event_t, __local ulong4*, __global ulong4*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_long8, event_t, __local ulong8*, __global ulong8*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_long16,event_t, __local ulong16*, __global ulong16*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_int,   event_t, __local float*, __global float*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_long,  event_t, __local float2*, __global float2*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_long2, event_t, __local float3*, __global float3*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_long2, event_t, __local float4*, __global float4*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_long4, event_t, __local float8*, __global float8*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_long8, event_t, __local float16*, __global float16*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_long,  event_t, __local double*, __global double*, size_t, event_t)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_long2, event_t, __local double2*, __global double2*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_long4, event_t, __local double3*, __global double3*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_long4, event_t, __local double4*, __global double4*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_long8, event_t, __local double8*, __global double8*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_long16,event_t, __local double16*, __global double16*, size_t, event_t)
 #endif

#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_char,  event_t, __local char*, const __global char*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_short, event_t, __local char2*, const __global char2*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_int,   event_t, __local char3*, const __global char3*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_int,   event_t, __local char4*, const __global char4*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_long,  event_t, __local char8*, const __global char8*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_long2, event_t, __local char16*, const __global char16*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_char,  event_t, __local uchar*, const __global uchar*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_short, event_t, __local uchar2*, const __global uchar2*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_int,   event_t, __local uchar3*, const __global uchar3*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_int,   event_t, __local uchar4*, const __global uchar4*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_long,  event_t, __local uchar8*, const __global uchar8*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_long2, event_t, __local uchar16*, const __global uchar16*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_short, event_t, __local short*, const __global short*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_int,   event_t, __local short2*, const __global short2*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_long,  event_t, __local short3*, const __global short3*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_long,  event_t, __local short4*, const __global short4*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_long2, event_t, __local short8*, const __global short8*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_long4, event_t, __local short16*, const __global short16*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_short, event_t, __local ushort*, const __global ushort*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_int,   event_t, __local ushort2*, const __global ushort2*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_long,  event_t, __local ushort3*, const __global ushort3*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_long,  event_t, __local ushort4*, const __global ushort4*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_long2, event_t, __local ushort8*, const __global ushort8*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_long4, event_t, __local ushort16*, const __global ushort16*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_int,   event_t, __local int*, const __global int*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_long,  event_t, __local int2*, const __global int2*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_long2, event_t, __local int3*, const __global int3*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_long2, event_t, __local int4*, const __global int4*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_long4, event_t, __local int8*, const __global int8*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_long8, event_t, __local int16*, const __global int16*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_int,   event_t, __local uint*, const __global uint*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_long,  event_t, __local uint2*, const __global uint2*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_long2, event_t, __local uint3*, const __global uint3*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_long2, event_t, __local uint4*, const __global uint4*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_long4, event_t, __local uint8*, const __global uint8*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_long8, event_t, __local uint16*, const __global uint16*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_long,  event_t, __local long*, const __global long*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_long2, event_t, __local long2*, const __global long2*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_long4, event_t, __local long3*, const __global long3*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_long4, event_t, __local long4*, const __global long4*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_long8, event_t, __local long8*, const __global long8*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_long16,event_t, __local long16*, const __global long16*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_long,  event_t, __local ulong*, const __global ulong*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_long2, event_t, __local ulong2*, const __global ulong2*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_long4, event_t, __local ulong3*, const __global ulong3*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_long4, event_t, __local ulong4*, const __global ulong4*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_long8, event_t, __local ulong8*, const __global ulong8*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_long16,event_t, __local ulong16*, const __global ulong16*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_int,   event_t, __local float*, const __global float*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_long,  event_t, __local float2*, const __global float2*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_long2, event_t, __local float3*, const __global float3*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_long2, event_t, __local float4*, const __global float4*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_long4, event_t, __local float8*, const __global float8*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_long8, event_t, __local float16*, const __global float16*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_long,  event_t, __local double*, const __global double*, size_t, event_t)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_long2, event_t, __local double2*, const __global double2*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_long4, event_t, __local double3*, const __global double3*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_long4, event_t, __local double4*, const __global double4*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_long8, event_t, __local double8*, const __global double8*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_get_long16,event_t, __local double16*, const __global double16*, size_t, event_t)
 #endif

#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_char,  event_t, __global char*, __local char*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_short, event_t, __global char2*, __local char2*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_int,   event_t, __global char3*, __local char3*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_int,   event_t, __global char4*, __local char4*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_long,  event_t, __global char8*, __local char8*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_long2, event_t, __global char16*, __local char16*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_char,  event_t, __global uchar*, __local uchar*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_short, event_t, __global uchar2*, __local uchar2*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_int,   event_t, __global uchar3*, __local uchar3*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_int,   event_t, __global uchar4*, __local uchar4*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_long,  event_t, __global uchar8*, __local uchar8*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_long2, event_t, __global uchar16*, __local uchar16*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_short, event_t, __global short*, __local short*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_int,   event_t, __global short2*, __local short2*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_long,  event_t, __global short3*, __local short3*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_long,  event_t, __global short4*, __local short4*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_long2, event_t, __global short8*, __local short8*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_long4, event_t, __global short16*, __local short16*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_short, event_t, __global ushort*, __local ushort*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_int,   event_t, __global ushort2*, __local ushort2*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_long,  event_t, __global ushort3*, __local ushort3*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_long,  event_t, __global ushort4*, __local ushort4*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_long2, event_t, __global ushort8*, __local ushort8*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_long4, event_t, __global ushort16*, __local ushort16*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_int,   event_t, __global int*, __local int*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_long,  event_t, __global int2*, __local int2*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_long2, event_t, __global int3*, __local int3*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_long2, event_t, __global int4*, __local int4*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_long4, event_t, __global int8*, __local int8*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_long8, event_t, __global int16*, __local int16*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_int,   event_t, __global uint*, __local uint*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_long,  event_t, __global uint2*, __local uint2*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_long2, event_t, __global uint3*, __local uint3*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_long2, event_t, __global uint4*, __local uint4*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_long4, event_t, __global uint8*, __local uint8*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_long8, event_t, __global uint16*, __local uint16*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_long,  event_t, __global long*, __local long*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_long2, event_t, __global long2*, __local long2*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_long4, event_t, __global long3*, __local long3*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_long4, event_t, __global long4*, __local long4*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_long8, event_t, __global long8*, __local long8*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_long16,event_t, __global long16*, __local long16*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_long,  event_t, __global ulong*, __local ulong*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_long2, event_t, __global ulong2*, __local ulong2*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_long4, event_t, __global ulong3*, __local ulong3*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_long4, event_t, __global ulong4*, __local ulong4*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_long8, event_t, __global ulong8*, __local ulong8*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_long16,event_t, __global ulong16*, __local ulong16*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_int,   event_t, __global float*, __local float*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_long,  event_t, __global float2*, __local float2*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_long2, event_t, __global float3*, __local float3*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_long2, event_t, __global float4*, __local float4*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_long4, event_t, __global float8*, __local float8*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_long8, event_t, __global float16*, __local float16*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_long,   event_t, __global double*, __local double*, size_t, event_t)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_long2,  event_t, __global double2*, __local double2*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_long4, event_t, __global double3*, __local double3*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_long4, event_t, __global double4*, __local double4*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_long8, event_t, __global double8*, __local double8*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_long16, event_t, __global double16*, __local double16*, size_t, event_t)
 #endif

#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_char,  event_t, __global char*, const __local char*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_short, event_t, __global char2*, const __local char2*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_int,   event_t, __global char3*, const __local char3*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_int,   event_t, __global char4*, const __local char4*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_long,  event_t, __global char8*, const __local char8*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_long2, event_t, __global char16*, const __local char16*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_char,  event_t, __global uchar*, const __local uchar*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_short, event_t, __global uchar2*, const __local uchar2*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_int,   event_t, __global uchar3*, const __local uchar3*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_int,   event_t, __global uchar4*, const __local uchar4*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_long,  event_t, __global uchar8*, const __local uchar8*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_long2, event_t, __global uchar16*, const __local uchar16*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_short, event_t, __global short*, const __local short*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_int,   event_t, __global short2*, const __local short2*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_long,  event_t, __global short3*, const __local short3*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_long,  event_t, __global short4*, const __local short4*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_long2, event_t, __global short8*, const __local short8*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_long4, event_t, __global short16*, const __local short16*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_short, event_t, __global ushort*, const __local ushort*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_int,   event_t, __global ushort2*, const __local ushort2*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_long,  event_t, __global ushort3*, const __local ushort3*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_long,  event_t, __global ushort4*, const __local ushort4*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_long2, event_t, __global ushort8*, const __local ushort8*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_long4, event_t, __global ushort16*, const __local ushort16*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_int,   event_t, __global int*, const __local int*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_long,  event_t, __global int2*, const __local int2*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_long2, event_t, __global int3*, const __local int3*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_long2, event_t, __global int4*, const __local int4*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_long4, event_t, __global int8*, const __local int8*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_long8, event_t, __global int16*, const __local int16*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_int,   event_t, __global uint*, const __local uint*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_long,  event_t, __global uint2*, const __local uint2*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_long2, event_t, __global uint3*, const __local uint3*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_long2, event_t, __global uint4*, const __local uint4*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_long4, event_t, __global uint8*, const __local uint8*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_long8, event_t, __global uint16*, const __local uint16*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_long,  event_t, __global long*, const __local long*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_long2, event_t, __global long2*, const __local long2*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_long4, event_t, __global long3*, const __local long3*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_long4, event_t, __global long4*, const __local long4*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_long8, event_t, __global long8*, const __local long8*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_long16,event_t, __global long16*, const __local long16*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_long,  event_t, __global ulong*, const __local ulong*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_long2, event_t, __global ulong2*, const __local ulong2*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_long4, event_t, __global ulong3*, const __local ulong3*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_long4, event_t, __global ulong4*, const __local ulong4*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_long8, event_t, __global ulong8*, const __local ulong8*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_long16,event_t, __global ulong16*, const __local ulong16*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_int,   event_t, __global float*, const __local float*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_long,  event_t, __global float2*, const __local float2*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_long2, event_t, __global float3*, const __local float3*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_long2, event_t, __global float4*, const __local float4*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_long4, event_t, __global float8*, const __local float8*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_long8, event_t, __global float16*, const __local float16*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_long,   event_t, __global double*, const __local double*, size_t, event_t)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_long2,  event_t, __global double2*, const __local double2*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_long4, event_t, __global double3*, const __local double3*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_long4, event_t, __global double4*, const __local double4*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_long8, event_t, __global double8*, const __local double8*, size_t, event_t)
#pragma tg_funcdef(async_work_group_copy, __async_work_group_copy_put_long16, event_t, __global double16*, const __local double16*, size_t, event_t)
 #endif
#undef async_work_group_copy
#define async_work_group_copy(__a, __b, __c, __d) __tg_builtin("async_work_group_copy", __a, __b, __c, __d)


#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_char,  event_t, __local char*, __global char*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_short, event_t, __local char2*, __global char2*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_int,   event_t, __local char3*, __global char3*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_int,   event_t, __local char4*, __global char4*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_long,  event_t, __local char8*, __global char8*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_long2, event_t, __local char16*, __global char16*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_char,  event_t, __local uchar*, __global uchar*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_short, event_t, __local uchar2*, __global uchar2*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_int,   event_t, __local uchar3*, __global uchar3*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_int,   event_t, __local uchar4*, __global uchar4*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_long,  event_t, __local uchar8*, __global uchar8*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_long2, event_t, __local uchar16*, __global uchar16*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_short, event_t, __local short*, __global short*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_int,   event_t, __local short2*, __global short2*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_long,  event_t, __local short3*, __global short3*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_long,  event_t, __local short4*, __global short4*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_long2, event_t, __local short8*, __global short8*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_long4, event_t, __local short16*, __global short16*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_short, event_t, __local ushort*, __global ushort*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_int,   event_t, __local ushort2*, __global ushort2*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_long,  event_t, __local ushort3*, __global ushort3*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_long,  event_t, __local ushort4*, __global ushort4*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_long2, event_t, __local ushort8*, __global ushort8*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_long4, event_t, __local ushort16*, __global ushort16*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_int,   event_t, __local int*, __global int*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_long,  event_t, __local int2*, __global int2*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_long2, event_t, __local int3*, __global int3*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_long2, event_t, __local int4*, __global int4*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_long4, event_t, __local int8*, __global int8*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_long8, event_t, __local int16*, __global int16*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_int,   event_t, __local uint*, __global uint*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_long,  event_t, __local uint2*, __global uint2*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_long2, event_t, __local uint3*, __global uint3*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_long2, event_t, __local uint4*, __global uint4*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_long4, event_t, __local uint8*, __global uint8*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_long8, event_t, __local uint16*, __global uint16*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_long,  event_t, __local long*, __global long*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_long2, event_t, __local long2*, __global long2*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_long4, event_t, __local long3*, __global long3*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_long4, event_t, __local long4*, __global long4*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_long8, event_t, __local long8*, __global long8*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_long16,event_t, __local long16*, __global long16*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_long,  event_t, __local ulong*, __global ulong*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_long2, event_t, __local ulong2*, __global ulong2*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_long4, event_t, __local ulong3*, __global ulong3*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_long4, event_t, __local ulong4*, __global ulong4*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_long8, event_t, __local ulong8*, __global ulong8*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_long16,event_t, __local ulong16*, __global ulong16*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_int,   event_t, __local float*, __global float*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_long,  event_t, __local float2*, __global float2*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_long2, event_t, __local float3*, __global float3*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_long2, event_t, __local float4*, __global float4*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_long4, event_t, __local float8*, __global float8*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_long8, event_t, __local float16*, __global float16*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_long,   event_t, __local double*, __global double*, size_t, size_t, event_t)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_long2,  event_t, __local double2*, __global double2*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_long4, event_t, __local double3*, __global double3*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_long4, event_t, __local double4*, __global double4*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_long8, event_t, __local double8*, __global double8*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_long16, event_t, __local double16*, __global double16*, size_t, size_t, event_t)
 #endif

#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_char,  event_t, __local char*, const __global char*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_short, event_t, __local char2*, const __global char2*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_int,   event_t, __local char3*, const __global char3*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_int,   event_t, __local char4*, const __global char4*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_long,  event_t, __local char8*, const __global char8*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_long2, event_t, __local char16*, const __global char16*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_char,  event_t, __local uchar*, const __global uchar*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_short, event_t, __local uchar2*, const __global uchar2*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_int,   event_t, __local uchar3*, const __global uchar3*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_int,   event_t, __local uchar4*, const __global uchar4*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_long,  event_t, __local uchar8*, const __global uchar8*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_long2, event_t, __local uchar16*, const __global uchar16*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_short, event_t, __local short*, const __global short*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_int,   event_t, __local short2*, const __global short2*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_long,  event_t, __local short3*, const __global short3*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_long,  event_t, __local short4*, const __global short4*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_long2, event_t, __local short8*, const __global short8*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_long4, event_t, __local short16*, const __global short16*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_short, event_t, __local ushort*, const __global ushort*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_int,   event_t, __local ushort2*, const __global ushort2*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_long,  event_t, __local ushort3*, const __global ushort3*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_long,  event_t, __local ushort4*, const __global ushort4*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_long2, event_t, __local ushort8*, const __global ushort8*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_long4, event_t, __local ushort16*, const __global ushort16*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_int,   event_t, __local int*, const __global int*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_long,  event_t, __local int2*, const __global int2*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_long2, event_t, __local int3*, const __global int3*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_long2, event_t, __local int4*, const __global int4*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_long4, event_t, __local int8*, const __global int8*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_long8, event_t, __local int16*, const __global int16*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_int,   event_t, __local uint*, const __global uint*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_long,  event_t, __local uint2*, const __global uint2*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_long2, event_t, __local uint3*, const __global uint3*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_long2, event_t, __local uint4*, const __global uint4*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_long4, event_t, __local uint8*, const __global uint8*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_long8, event_t, __local uint16*, const __global uint16*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_long,  event_t, __local long*, const __global long*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_long2, event_t, __local long2*, const __global long2*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_long4, event_t, __local long3*, const __global long3*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_long4, event_t, __local long4*, const __global long4*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_long8, event_t, __local long8*, const __global long8*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_long16,event_t, __local long16*, const __global long16*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_long,  event_t, __local ulong*, const __global ulong*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_long2, event_t, __local ulong2*, const __global ulong2*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_long4, event_t, __local ulong3*, const __global ulong3*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_long4, event_t, __local ulong4*, const __global ulong4*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_long8, event_t, __local ulong8*, const __global ulong8*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_long16,event_t, __local ulong16*, const __global ulong16*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_int,   event_t, __local float*, const __global float*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_long,  event_t, __local float2*, const __global float2*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_long2, event_t, __local float3*, const __global float3*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_long2, event_t, __local float4*, const __global float4*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_long4, event_t, __local float8*, const __global float8*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_long8, event_t, __local float16*, const __global float16*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_long,   event_t, __local double*, const __global double*, size_t, size_t, event_t)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_long2,  event_t, __local double2*, const __global double2*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_long4, event_t, __local double3*, const __global double3*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_long4, event_t, __local double4*, const __global double4*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_long8, event_t, __local double8*, const __global double8*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_get_long16, event_t, __local double16*, const __global double16*, size_t, size_t, event_t)
 #endif

#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_char,  event_t, __global char*, __local char*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_short, event_t, __global char2*, __local char2*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_int,   event_t, __global char3*, __local char3*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_int,   event_t, __global char4*, __local char4*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_long,  event_t, __global char8*, __local char8*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_long2, event_t, __global char16*, __local char16*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_char,  event_t, __global uchar*, __local uchar*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_short, event_t, __global uchar2*, __local uchar2*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_int,   event_t, __global uchar3*, __local uchar3*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_int,   event_t, __global uchar4*, __local uchar4*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_long,  event_t, __global uchar8*, __local uchar8*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_long2, event_t, __global uchar16*, __local uchar16*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_short, event_t, __global short*, __local short*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_int,   event_t, __global short2*, __local short2*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_long,  event_t, __global short3*, __local short3*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_long,  event_t, __global short4*, __local short4*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_long2, event_t, __global short8*, __local short8*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_long4, event_t, __global short16*, __local short16*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_short, event_t, __global ushort*, __local ushort*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_int,   event_t, __global ushort2*, __local ushort2*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_long,  event_t, __global ushort3*, __local ushort3*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_long,  event_t, __global ushort4*, __local ushort4*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_long2, event_t, __global ushort8*, __local ushort8*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_long4, event_t, __global ushort16*, __local ushort16*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_int,   event_t, __global int*, __local int*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_long,  event_t, __global int2*, __local int2*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_long2, event_t, __global int3*, __local int3*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_long2, event_t, __global int4*, __local int4*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_long4, event_t, __global int8*, __local int8*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_long8, event_t, __global int16*, __local int16*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_int,   event_t, __global uint*, __local uint*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_long,  event_t, __global uint2*, __local uint2*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_long2, event_t, __global uint3*, __local uint3*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_long2, event_t, __global uint4*, __local uint4*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_long4, event_t, __global uint8*, __local uint8*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_long8, event_t, __global uint16*, __local uint16*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_long,  event_t, __global long*, __local long*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_long2, event_t, __global long2*, __local long2*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_long4, event_t, __global long3*, __local long3*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_long4, event_t, __global long4*, __local long4*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_long8, event_t, __global long8*, __local long8*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_long16,event_t, __global long16*, __local long16*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_long,  event_t, __global ulong*, __local ulong*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_long2, event_t, __global ulong2*, __local ulong2*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_long4, event_t, __global ulong3*, __local ulong3*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_long4, event_t, __global ulong4*, __local ulong4*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_long8, event_t, __global ulong8*, __local ulong8*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_long16,event_t, __global ulong16*, __local ulong16*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_int,   event_t, __global float*, __local float*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_long,  event_t, __global float2*, __local float2*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_long2, event_t, __global float3*, __local float3*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_long2, event_t, __global float4*, __local float4*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_long4, event_t, __global float8*, __local float8*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_long8, event_t, __global float16*, __local float16*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_long,   event_t, __global double*, __local double*, size_t, size_t, event_t)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_long2,  event_t, __global double2*, __local double2*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_long4, event_t, __global double3*, __local double3*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_long4, event_t, __global double4*, __local double4*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_long8, event_t, __global double8*, __local double8*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_long16, event_t, __global double16*, __local double16*, size_t, size_t, event_t)
 #endif

#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_char,  event_t, __global char*, const __local char*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_short, event_t, __global char2*, const __local char2*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_int,   event_t, __global char3*, const __local char3*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_int,   event_t, __global char4*, const __local char4*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_long,  event_t, __global char8*, const __local char8*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_long2, event_t, __global char16*, const __local char16*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_char,  event_t, __global uchar*, const __local uchar*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_short, event_t, __global uchar2*, const __local uchar2*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_int,   event_t, __global uchar3*, const __local uchar3*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_int,   event_t, __global uchar4*, const __local uchar4*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_long,  event_t, __global uchar8*, const __local uchar8*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_long2, event_t, __global uchar16*, const __local uchar16*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_short, event_t, __global short*, const __local short*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_int,   event_t, __global short2*, const __local short2*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_long,  event_t, __global short3*, const __local short3*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_long,  event_t, __global short4*, const __local short4*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_long2, event_t, __global short8*, const __local short8*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_long4, event_t, __global short16*, const __local short16*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_short, event_t, __global ushort*, const __local ushort*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_int,   event_t, __global ushort2*, const __local ushort2*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_long,  event_t, __global ushort3*, const __local ushort3*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_long,  event_t, __global ushort4*, const __local ushort4*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_long2, event_t, __global ushort8*, const __local ushort8*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_long4, event_t, __global ushort16*, const __local ushort16*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_int,   event_t, __global int*, const __local int*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_long,  event_t, __global int2*, const __local int2*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_long2, event_t, __global int3*, const __local int3*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_long2, event_t, __global int4*, const __local int4*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_long4, event_t, __global int8*, const __local int8*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_long8, event_t, __global int16*, const __local int16*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_int,   event_t, __global uint*, const __local uint*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_long,  event_t, __global uint2*, const __local uint2*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_long2, event_t, __global uint3*, const __local uint3*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_long2, event_t, __global uint4*, const __local uint4*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_long4, event_t, __global uint8*, const __local uint8*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_long8, event_t, __global uint16*, const __local uint16*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_long,  event_t, __global long*, const __local long*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_long2, event_t, __global long2*, const __local long2*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_long4, event_t, __global long3*, const __local long3*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_long4, event_t, __global long4*, const __local long4*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_long8, event_t, __global long8*, const __local long8*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_long16,event_t, __global long16*, const __local long16*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_long,  event_t, __global ulong*, const __local ulong*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_long2, event_t, __global ulong2*, const __local ulong2*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_long4, event_t, __global ulong3*, const __local ulong3*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_long4, event_t, __global ulong4*, const __local ulong4*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_long8, event_t, __global ulong8*, const __local ulong8*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_long16,event_t, __global ulong16*, const __local ulong16*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_int,   event_t, __global float*, const __local float*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_long,  event_t, __global float2*, const __local float2*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_long2, event_t, __global float3*, const __local float3*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_long2, event_t, __global float4*, const __local float4*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_long4, event_t, __global float8*, const __local float8*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_long8, event_t, __global float16*, const __local float16*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_long,   event_t, __global double*, const __local double*, size_t, size_t, event_t)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_long2,  event_t, __global double2*, const __local double2*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_long4, event_t, __global double3*, const __local double3*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_long4, event_t, __global double4*, const __local double4*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_long8, event_t, __global double8*, const __local double8*, size_t, size_t, event_t)
#pragma tg_funcdef(async_work_group_strided_copy, __async_work_group_strided_copy_put_long16, event_t, __global double16*, const __local double16*, size_t, size_t, event_t)
 #endif
#undef async_work_group_strided_copy
#define async_work_group_strided_copy(__a, __b, __c, __d, __e) __tg_builtin("async_work_group_strided_copy", __a, __b, __c, __d, __e)

/* wait_group_events */
#pragma tg_funcdef(prefetch, __prefetch_char,  void, __global char*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_short, void, __global char2*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_int,   void, __global char3*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_int,   void, __global char4*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_long,  void, __global char8*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_long2, void, __global char16*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_char,  void, __global uchar*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_short, void, __global uchar2*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_int,   void, __global uchar3*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_int,   void, __global uchar4*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_long,  void, __global uchar8*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_long2, void, __global uchar16*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_short, void, __global short*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_int,   void, __global short2*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_long,  void, __global short3*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_long,  void, __global short4*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_long2, void, __global short8*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_long4, void, __global short16*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_short, void, __global ushort*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_int,   void, __global ushort2*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_long,  void, __global ushort3*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_long,  void, __global ushort4*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_long2, void, __global ushort8*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_long4, void, __global ushort16*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_int,   void, __global int*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_long,  void, __global int2*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_long2, void, __global int3*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_long2, void, __global int4*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_long4, void, __global int8*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_long8, void, __global int16*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_int,   void, __global uint*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_long,  void, __global uint2*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_long2, void, __global uint3*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_long2, void, __global uint4*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_long4, void, __global uint8*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_long8, void, __global uint16*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_long,  void, __global long*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_long2, void, __global long2*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_long4, void, __global long3*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_long4, void, __global long4*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_long8, void, __global long8*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_long16,void, __global long16*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_long,  void, __global ulong*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_long2, void, __global ulong2*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_long4, void, __global ulong3*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_long4, void, __global ulong4*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_long8, void, __global ulong8*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_long16,void, __global ulong16*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_int,   void, __global float*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_long,  void, __global float2*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_long2, void, __global float3*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_long2, void, __global float4*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_long4, void, __global float8*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_long8, void, __global float16*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_long,  void, __global double*,  size_t)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(prefetch, __prefetch_long2, void, __global double2*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_long4, void, __global double3*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_long4, void, __global double4*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_long8, void, __global double8*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_long16,void, __global double16*,size_t)
 #endif
#pragma tg_funcdef(prefetch, __prefetch_char,  void, const __global char*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_short, void, const __global char2*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_int,   void, const __global char3*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_int,   void, const __global char4*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_long,  void, const __global char8*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_long2, void, const __global char16*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_char,  void, const __global uchar*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_short, void, const __global uchar2*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_int,   void, const __global uchar3*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_int,   void, const __global uchar4*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_long,  void, const __global uchar8*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_long2, void, const __global uchar16*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_short, void, const __global short*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_int,   void, const __global short2*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_long,  void, const __global short3*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_long,  void, const __global short4*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_long2, void, const __global short8*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_long4, void, const __global short16*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_short, void, const __global ushort*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_int,   void, const __global ushort2*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_long,  void, const __global ushort3*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_long,  void, const __global ushort4*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_long2, void, const __global ushort8*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_long4, void, const __global ushort16*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_int,   void, const __global int*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_long,  void, const __global int2*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_long2, void, const __global int3*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_long2, void, const __global int4*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_long4, void, const __global int8*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_long8, void, const __global int16*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_int,   void, const __global uint*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_long,  void, const __global uint2*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_long2, void, const __global uint3*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_long2, void, const __global uint4*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_long4, void, const __global uint8*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_long8, void, const __global uint16*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_long,  void, const __global long*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_long2, void, const __global long2*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_long4, void, const __global long3*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_long4, void, const __global long4*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_long8, void, const __global long8*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_long16,void, const __global long16*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_long,  void, const __global ulong*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_long2, void, const __global ulong2*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_long4, void, const __global ulong3*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_long4, void, const __global ulong4*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_long8, void, const __global ulong8*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_long16,void, const __global ulong16*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_int,   void, const __global float*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_long,  void, const __global float2*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_long2, void, const __global float3*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_long2, void, const __global float4*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_long4, void, const __global float8*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_long8, void, const __global float16*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_long,  void, const __global double*,  size_t)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(prefetch, __prefetch_long2, void, const __global double2*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_long4, void, const __global double3*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_long4, void, const __global double4*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_long8, void, const __global double8*, size_t)
#pragma tg_funcdef(prefetch, __prefetch_long16,void, const __global double16*,size_t)
 #endif
#undef prefetch
#define prefetch(__a, __b) __tg_builtin("prefetch", __a, __b)

#pragma tg_funcdef(minmag, __minmag_float, float, float, float)
#pragma tg_funcdef(minmag, __minmag_float2, float2, float2, float2)
#pragma tg_funcdef(minmag, __minmag_float3, float3, float3, float3)
#pragma tg_funcdef(minmag, __minmag_float4, float4, float4, float4)
#pragma tg_funcdef(minmag, __minmag_float8, float8, float8, float8)
#pragma tg_funcdef(minmag, __minmag_float16, float16, float16, float16)
#pragma tg_funcdef(minmag, __minmag_double, double, double, double)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(minmag, __minmag_double2, double2, double2, double2)
#pragma tg_funcdef(minmag, __minmag_double3, double3, double3, double3)
#pragma tg_funcdef(minmag, __minmag_double4, double4, double4, double4)
#pragma tg_funcdef(minmag, __minmag_double8, double8, double8, double8)
#pragma tg_funcdef(minmag, __minmag_double16, double16, double16, double16)
 #endif
#undef minmag
#define minmag(__a, __b) __tg_builtin("minmag", __a, __b)

#pragma tg_funcdef(maxmag, __maxmag_float, float, float, float)
#pragma tg_funcdef(maxmag, __maxmag_float2, float2, float2, float2)
#pragma tg_funcdef(maxmag, __maxmag_float3, float3, float3, float3)
#pragma tg_funcdef(maxmag, __maxmag_float4, float4, float4, float4)
#pragma tg_funcdef(maxmag, __maxmag_float8, float8, float8, float8)
#pragma tg_funcdef(maxmag, __maxmag_float16, float16, float16, float16)
#pragma tg_funcdef(maxmag, __maxmag_double, double, double, double)
 #if defined(_ARCH_PWR7) || defined(_ARCH_CELLSPU)
#pragma tg_funcdef(maxmag, __maxmag_double2, double2, double2, double2)
#pragma tg_funcdef(maxmag, __maxmag_double3, double3, double3, double3)
#pragma tg_funcdef(maxmag, __maxmag_double4, double4, double4, double4)
#pragma tg_funcdef(maxmag, __maxmag_double8, double8, double8, double8)
#pragma tg_funcdef(maxmag, __maxmag_double16, double16, double16, double16)
 #endif
#undef maxmag
#define maxmag(__a, __b) __tg_builtin("maxmag", __a, __b)


#pragma tg_funcdef(atomic_add, __atom_add_int, int, volatile __global int *, int)
#pragma tg_funcdef(atomic_add, __atom_add_int, unsigned int, volatile __global unsigned int *, unsigned int)
#pragma tg_funcdef(atomic_add, __atom_add_int_local, int, volatile __local int *, int)
#pragma tg_funcdef(atomic_add, __atom_add_int_local, unsigned int, volatile __local unsigned int *, unsigned int)
#pragma tg_funcdef(atomic_add, __atom_add_int, int, __global int *, int)
#pragma tg_funcdef(atomic_add, __atom_add_int, unsigned int, __global unsigned int *, unsigned int)
#pragma tg_funcdef(atomic_add, __atom_add_int_local, int, __local int *, int)
#pragma tg_funcdef(atomic_add, __atom_add_int_local, unsigned int, __local unsigned int *, unsigned int)
#undef atomic_add
#define atomic_add(__a, __b) __tg_builtin("atomic_add", __a, __b)

#pragma tg_funcdef(atomic_and, __atom_and_int, int, volatile __global int *, int)
#pragma tg_funcdef(atomic_and, __atom_and_int, unsigned int, volatile __global unsigned int *, unsigned int)
#pragma tg_funcdef(atomic_and, __atom_and_int_local, int, volatile __local int *, int)
#pragma tg_funcdef(atomic_and, __atom_and_int_local, unsigned int, volatile __local unsigned int *, unsigned int)
#pragma tg_funcdef(atomic_and, __atom_and_int, int, __global int *, int)
#pragma tg_funcdef(atomic_and, __atom_and_int, unsigned int, __global unsigned int *, unsigned int)
#pragma tg_funcdef(atomic_and, __atom_and_int_local, int, __local int *, int)
#pragma tg_funcdef(atomic_and, __atom_and_int_local, unsigned int, __local unsigned int *, unsigned int)
#undef atomic_and
#define atomic_and(__a, __b) __tg_builtin("atomic_and", __a, __b)

#pragma tg_funcdef(atomic_cmpxchg, __atom_cmpxchg_int, int, volatile __global int *, int, int)
#pragma tg_funcdef(atomic_cmpxchg, __atom_cmpxchg_int, unsigned int, volatile __global unsigned int *, unsigned int, unsigned int)
#pragma tg_funcdef(atomic_cmpxchg, __atom_cmpxchg_int_local, int, volatile __local int *, int, int)
#pragma tg_funcdef(atomic_cmpxchg, __atom_cmpxchg_int_local, unsigned int, volatile __local unsigned int *, unsigned int, unsigned int)
#pragma tg_funcdef(atomic_cmpxchg, __atom_cmpxchg_int, int, __global int *, int, int)
#pragma tg_funcdef(atomic_cmpxchg, __atom_cmpxchg_int, unsigned int, __global unsigned int *, unsigned int, unsigned int)
#pragma tg_funcdef(atomic_cmpxchg, __atom_cmpxchg_int_local, int, __local int *, int, int)
#pragma tg_funcdef(atomic_cmpxchg, __atom_cmpxchg_int_local, unsigned int, __local unsigned int *, unsigned int, unsigned int)
#undef atomic_cmpxchg
#define atomic_cmpxchg(__a, __b, __c) __tg_builtin("atomic_cmpxchg", __a, __b, __c)

#pragma tg_funcdef(atomic_dec, __atom_dec_int, int, volatile __global int *)
#pragma tg_funcdef(atomic_dec, __atom_dec_int, unsigned int, volatile __global unsigned int *)
#pragma tg_funcdef(atomic_dec, __atom_dec_int_local, int, volatile __local int *)
#pragma tg_funcdef(atomic_dec, __atom_dec_int_local, unsigned int, volatile __local unsigned int *)
#pragma tg_funcdef(atomic_dec, __atom_dec_int, int, __global int *)
#pragma tg_funcdef(atomic_dec, __atom_dec_int, unsigned int, __global unsigned int *)
#pragma tg_funcdef(atomic_dec, __atom_dec_int_local, int, __local int *)
#pragma tg_funcdef(atomic_dec, __atom_dec_int_local, unsigned int, __local unsigned int *)
#undef atomic_dec
#define atomic_dec(__a) __tg_builtin("atomic_dec", __a)

#pragma tg_funcdef(atomic_inc, __atom_inc_int, int, volatile __global int *)
#pragma tg_funcdef(atomic_inc, __atom_inc_int, unsigned int, volatile __global unsigned int *)
#pragma tg_funcdef(atomic_inc, __atom_inc_int_local, int, volatile __local int *)
#pragma tg_funcdef(atomic_inc, __atom_inc_int_local, unsigned int, volatile __local unsigned int *)
#pragma tg_funcdef(atomic_inc, __atom_inc_int, int, __global int *)
#pragma tg_funcdef(atomic_inc, __atom_inc_int, unsigned int, __global unsigned int *)
#pragma tg_funcdef(atomic_inc, __atom_inc_int_local, int, __local int *)
#pragma tg_funcdef(atomic_inc, __atom_inc_int_local, unsigned int, __local unsigned int *)
#undef atomic_inc
#define atomic_inc(__a) __tg_builtin("atomic_inc", __a)

#pragma tg_funcdef(atomic_max, __atom_max_int, int, volatile __global int *, int)
#pragma tg_funcdef(atomic_max, __atom_max_uint, unsigned int, volatile __global unsigned int *, unsigned int)
#pragma tg_funcdef(atomic_max, __atom_max_int_local, int, volatile __local int *, int)
#pragma tg_funcdef(atomic_max, __atom_max_uint_local, unsigned int, volatile __local unsigned int *, unsigned int)
#pragma tg_funcdef(atomic_max, __atom_max_int, int, __global int *, int)
#pragma tg_funcdef(atomic_max, __atom_max_uint, unsigned int, __global unsigned int *, unsigned int)
#pragma tg_funcdef(atomic_max, __atom_max_int_local, int, __local int *, int)
#pragma tg_funcdef(atomic_max, __atom_max_uint_local, unsigned int, __local unsigned int *, unsigned int)
#undef atomic_max
#define atomic_max(__a, __b) __tg_builtin("atomic_max", __a, __b)

#pragma tg_funcdef(atomic_min, __atom_min_int, int, volatile __global int *, int)
#pragma tg_funcdef(atomic_min, __atom_min_uint, unsigned int, volatile __global unsigned int *, unsigned int)
#pragma tg_funcdef(atomic_min, __atom_min_int_local, int, volatile __local int *, int)
#pragma tg_funcdef(atomic_min, __atom_min_uint_local, unsigned int, volatile __local unsigned int *, unsigned int)
#pragma tg_funcdef(atomic_min, __atom_min_int, int, __global int *, int)
#pragma tg_funcdef(atomic_min, __atom_min_uint, unsigned int, __global unsigned int *, unsigned int)
#pragma tg_funcdef(atomic_min, __atom_min_int_local, int, __local int *, int)
#pragma tg_funcdef(atomic_min, __atom_min_uint_local, unsigned int, __local unsigned int *, unsigned int)
#undef atomic_min
#define atomic_min(__a, __b) __tg_builtin("atomic_min", __a, __b)

#pragma tg_funcdef(atomic_or, __atom_or_int, int, volatile __global int *, int)
#pragma tg_funcdef(atomic_or, __atom_or_int, unsigned int, volatile __global unsigned int *, unsigned int)
#pragma tg_funcdef(atomic_or, __atom_or_int_local, int, volatile __local int *, int)
#pragma tg_funcdef(atomic_or, __atom_or_int_local, unsigned int, volatile __local unsigned int *, unsigned int)
#pragma tg_funcdef(atomic_or, __atom_or_int, int, __global int *, int)
#pragma tg_funcdef(atomic_or, __atom_or_int, unsigned int, __global unsigned int *, unsigned int)
#pragma tg_funcdef(atomic_or, __atom_or_int_local, int, __local int *, int)
#pragma tg_funcdef(atomic_or, __atom_or_int_local, unsigned int, __local unsigned int *, unsigned int)
#undef atomic_or
#define atomic_or(__a, __b) __tg_builtin("atomic_or", __a, __b)

#pragma tg_funcdef(atomic_sub, __atom_sub_int, int, volatile __global int *, int)
#pragma tg_funcdef(atomic_sub, __atom_sub_int, unsigned int, volatile __global unsigned int *, unsigned int)
#pragma tg_funcdef(atomic_sub, __atom_sub_int_local, int, volatile __local int *, int)
#pragma tg_funcdef(atomic_sub, __atom_sub_int_local, unsigned int, volatile __local unsigned int *, unsigned int)
#pragma tg_funcdef(atomic_sub, __atom_sub_int, int, __global int *, int)
#pragma tg_funcdef(atomic_sub, __atom_sub_int, unsigned int, __global unsigned int *, unsigned int)
#pragma tg_funcdef(atomic_sub, __atom_sub_int_local, int, __local int *, int)
#pragma tg_funcdef(atomic_sub, __atom_sub_int_local, unsigned int, __local unsigned int *, unsigned int)
#undef atomic_sub
#define atomic_sub(__a, __b) __tg_builtin("atomic_sub", __a, __b)

#pragma tg_funcdef(atomic_xchg, __atom_xchg_int, int, volatile __global int *, int)
#pragma tg_funcdef(atomic_xchg, __atom_xchg_int, unsigned int, volatile __global unsigned int *, unsigned int)
#pragma tg_funcdef(atomic_xchg, __atom_xchg_float, float, volatile __global float *, float)
#pragma tg_funcdef(atomic_xchg, __atom_xchg_int_local, int, volatile __local int *, int)
#pragma tg_funcdef(atomic_xchg, __atom_xchg_int_local, unsigned int, volatile __local unsigned int *, unsigned int)
#pragma tg_funcdef(atomic_xchg, __atom_xchg_float_local, float, volatile __local float *, float)
#pragma tg_funcdef(atomic_xchg, __atom_xchg_int, int, __global int *, int)
#pragma tg_funcdef(atomic_xchg, __atom_xchg_int, unsigned int, __global unsigned int *, unsigned int)
#pragma tg_funcdef(atomic_xchg, __atom_xchg_float, float, __global float *, float)
#pragma tg_funcdef(atomic_xchg, __atom_xchg_int_local, int, __local int *, int)
#pragma tg_funcdef(atomic_xchg, __atom_xchg_int_local, unsigned int, __local unsigned int *, unsigned int)
#pragma tg_funcdef(atomic_xchg, __atom_xchg_float_local, float, __local float *, float)
#undef atomic_xchg
#define atomic_xchg(__a, __b) __tg_builtin("atomic_xchg", __a, __b)

#pragma tg_funcdef(atomic_xor, __atom_xor_int, int, volatile __global int *, int)
#pragma tg_funcdef(atomic_xor, __atom_xor_int, unsigned int, volatile __global unsigned int *, unsigned int)
#pragma tg_funcdef(atomic_xor, __atom_xor_int_local, int, volatile __local int *, int)
#pragma tg_funcdef(atomic_xor, __atom_xor_int_local, unsigned int, volatile __local unsigned int *, unsigned int)
#pragma tg_funcdef(atomic_xor, __atom_xor_int, int, __global int *, int)
#pragma tg_funcdef(atomic_xor, __atom_xor_int, unsigned int, __global unsigned int *, unsigned int)
#pragma tg_funcdef(atomic_xor, __atom_xor_int_local, int, __local int *, int)
#pragma tg_funcdef(atomic_xor, __atom_xor_int_local, unsigned int, __local unsigned int *, unsigned int)
#undef atomic_xor
#define atomic_xor(__a, __b) __tg_builtin("atomic_xor", __a, __b)

#pragma tg_funcdef(atom_add, __atom_add_int, int, volatile __global int *, int)
#pragma tg_funcdef(atom_add, __atom_add_int, int, __global int *, int)
#pragma tg_funcdef(atom_add, __atom_add_int, unsigned int, volatile __global unsigned int *, unsigned int)
#pragma tg_funcdef(atom_add, __atom_add_int, unsigned int, __global unsigned int *, unsigned int)
#pragma tg_funcdef(atom_add, __atom_add_long, long, volatile __global long *, long)
#pragma tg_funcdef(atom_add, __atom_add_long, long, __global long *, long)
#pragma tg_funcdef(atom_add, __atom_add_long, ulong, volatile __global ulong *, ulong)
#pragma tg_funcdef(atom_add, __atom_add_long, ulong, __global ulong *, ulong)
#pragma tg_funcdef(atom_add, __atom_add_int_local, int, volatile __local int *, int)
#pragma tg_funcdef(atom_add, __atom_add_int_local, int, __local int *, int)
#pragma tg_funcdef(atom_add, __atom_add_int_local, unsigned int, volatile __local unsigned int *, unsigned int)
#pragma tg_funcdef(atom_add, __atom_add_int_local, unsigned int, __local unsigned int *, unsigned int)
#pragma tg_funcdef(atom_add, __atom_add_long_local, long, volatile __local long *, long)
#pragma tg_funcdef(atom_add, __atom_add_long_local, long, __local long *, long)
#pragma tg_funcdef(atom_add, __atom_add_long_local, ulong, volatile __local ulong *, ulong)
#pragma tg_funcdef(atom_add, __atom_add_long_local, ulong, __local ulong *, ulong)
#undef atom_add
#define atom_add(__a, __b) __tg_builtin("atom_add", __a, __b)

#pragma tg_funcdef(atom_and, __atom_and_int, int, volatile __global int *, int)
#pragma tg_funcdef(atom_and, __atom_and_int, int,  __global int *, int)
#pragma tg_funcdef(atom_and, __atom_and_int, unsigned int, volatile __global unsigned int *, unsigned int)
#pragma tg_funcdef(atom_and, __atom_and_int, unsigned int,  __global unsigned int *, unsigned int)
#pragma tg_funcdef(atom_and, __atom_and_long, long, volatile __global long *, long)
#pragma tg_funcdef(atom_and, __atom_and_long, long,  __global long *, long)
#pragma tg_funcdef(atom_and, __atom_and_long, ulong, volatile __global ulong *, ulong)
#pragma tg_funcdef(atom_and, __atom_and_long, ulong,  __global ulong *, ulong)
#pragma tg_funcdef(atom_and, __atom_and_int_local, int, volatile __local int *, int)
#pragma tg_funcdef(atom_and, __atom_and_int_local, int,  __local int *, int)
#pragma tg_funcdef(atom_and, __atom_and_int_local, unsigned int, volatile __local unsigned int *, unsigned int)
#pragma tg_funcdef(atom_and, __atom_and_int_local, unsigned int,  __local unsigned int *, unsigned int)
#pragma tg_funcdef(atom_and, __atom_and_long_local, long, volatile __local long *, long)
#pragma tg_funcdef(atom_and, __atom_and_long_local, long,  __local long *, long)
#pragma tg_funcdef(atom_and, __atom_and_long_local, ulong, volatile __local ulong *, ulong)
#pragma tg_funcdef(atom_and, __atom_and_long_local, ulong, __local ulong *, ulong)
#undef atom_and
#define atom_and(__a, __b) __tg_builtin("atom_and", __a, __b)

#pragma tg_funcdef(atom_cmpxchg, __atom_cmpxchg_int, int, volatile  __global int *, int, int)
#pragma tg_funcdef(atom_cmpxchg, __atom_cmpxchg_int, int,  __global int *, int, int)
#pragma tg_funcdef(atom_cmpxchg, __atom_cmpxchg_int, unsigned int,  volatile __global unsigned int *, unsigned int, unsigned int)
#pragma tg_funcdef(atom_cmpxchg, __atom_cmpxchg_int, unsigned int,  __global unsigned int *, unsigned int, unsigned int)
#pragma tg_funcdef(atom_cmpxchg, __atom_cmpxchg_long, long, volatile __global long *, long, long)
#pragma tg_funcdef(atom_cmpxchg, __atom_cmpxchg_long, long,  __global long *, long, long)
#pragma tg_funcdef(atom_cmpxchg, __atom_cmpxchg_long, ulong, volatile __global ulong *, ulong, ulong)
#pragma tg_funcdef(atom_cmpxchg, __atom_cmpxchg_long, ulong,  __global ulong *, ulong, ulong)
#pragma tg_funcdef(atom_cmpxchg, __atom_cmpxchg_int_local, int, volatile __local int *, int, int)
#pragma tg_funcdef(atom_cmpxchg, __atom_cmpxchg_int_local, int,  __local int *, int, int)
#pragma tg_funcdef(atom_cmpxchg, __atom_cmpxchg_int_local, unsigned int, volatile __local unsigned int *, unsigned int, unsigned int)
#pragma tg_funcdef(atom_cmpxchg, __atom_cmpxchg_int_local, unsigned int,  __local unsigned int *, unsigned int, unsigned int)
#pragma tg_funcdef(atom_cmpxchg, __atom_cmpxchg_long_local, long, volatile __local long *, long, long)
#pragma tg_funcdef(atom_cmpxchg, __atom_cmpxchg_long_local, long,  __local long *, long, long)
#pragma tg_funcdef(atom_cmpxchg, __atom_cmpxchg_long_local, ulong, volatile __local ulong *, ulong, ulong)
#pragma tg_funcdef(atom_cmpxchg, __atom_cmpxchg_long_local, ulong,  __local ulong *, ulong, ulong)
#undef atom_cmpxchg
#define atom_cmpxchg(__a, __b, __c) __tg_builtin("atom_cmpxchg", __a, __b, __c)

#pragma tg_funcdef(atom_dec, __atom_dec_int, int, volatile __global int *)
#pragma tg_funcdef(atom_dec, __atom_dec_int, int,  __global int *)
#pragma tg_funcdef(atom_dec, __atom_dec_int, unsigned int,  volatile __global unsigned int *)
#pragma tg_funcdef(atom_dec, __atom_dec_int, unsigned int,  __global unsigned int *)
#pragma tg_funcdef(atom_dec, __atom_dec_long, long, volatile __global long *)
#pragma tg_funcdef(atom_dec, __atom_dec_long, long,  __global long *)
#pragma tg_funcdef(atom_dec, __atom_dec_long, ulong, volatile __global ulong *)
#pragma tg_funcdef(atom_dec, __atom_dec_long, ulong,  __global ulong *)
#pragma tg_funcdef(atom_dec, __atom_dec_int_local, int, volatile __local int *)
#pragma tg_funcdef(atom_dec, __atom_dec_int_local, int,  __local int *)
#pragma tg_funcdef(atom_dec, __atom_dec_int_local, unsigned int, volatile __local unsigned int *)
#pragma tg_funcdef(atom_dec, __atom_dec_int_local, unsigned int,  __local unsigned int *)
#pragma tg_funcdef(atom_dec, __atom_dec_long_local, long, volatile __local long *)
#pragma tg_funcdef(atom_dec, __atom_dec_long_local, long,  __local long *)
#pragma tg_funcdef(atom_dec, __atom_dec_long_local, ulong, volatile __local ulong *)
#pragma tg_funcdef(atom_dec, __atom_dec_long_local, ulong,  __local ulong *)
#undef atom_dec
#define atom_dec(__a) __tg_builtin("atom_dec", __a)

#pragma tg_funcdef(atom_inc, __atom_inc_int, int, volatile __global int *)
#pragma tg_funcdef(atom_inc, __atom_inc_int, int,  __global int *)
#pragma tg_funcdef(atom_inc, __atom_inc_int, unsigned int,  volatile __global unsigned int *)
#pragma tg_funcdef(atom_inc, __atom_inc_int, unsigned int,  __global unsigned int *)
#pragma tg_funcdef(atom_inc, __atom_inc_long, long, volatile __global long *)
#pragma tg_funcdef(atom_inc, __atom_inc_long, long,  __global long *)
#pragma tg_funcdef(atom_inc, __atom_inc_long, ulong, volatile __global ulong *)
#pragma tg_funcdef(atom_inc, __atom_inc_long, ulong,  __global ulong *)
#pragma tg_funcdef(atom_inc, __atom_inc_int_local, int, volatile __local int *)
#pragma tg_funcdef(atom_inc, __atom_inc_int_local, int,  __local int *)
#pragma tg_funcdef(atom_inc, __atom_inc_int_local, unsigned int, volatile __local unsigned int *)
#pragma tg_funcdef(atom_inc, __atom_inc_int_local, unsigned int,  __local unsigned int *)
#pragma tg_funcdef(atom_inc, __atom_inc_long_local, long, volatile __local long *)
#pragma tg_funcdef(atom_inc, __atom_inc_long_local, long,  __local long *)
#pragma tg_funcdef(atom_inc, __atom_inc_long_local, ulong, volatile __local ulong *)
#pragma tg_funcdef(atom_inc, __atom_inc_long_local, ulong,  __local ulong *)
#undef atom_inc
#define atom_inc(__a) __tg_builtin("atom_inc", __a)

#pragma tg_funcdef(atom_max, __atom_max_int, int, volatile  __global int *, int)
#pragma tg_funcdef(atom_max, __atom_max_int, int,  __global int *, int)
#pragma tg_funcdef(atom_max, __atom_max_uint, unsigned int, volatile  __global unsigned int *, unsigned int)
#pragma tg_funcdef(atom_max, __atom_max_uint, unsigned int,  __global unsigned int *, unsigned int)
#pragma tg_funcdef(atom_max, __atom_max_long, long, volatile __global long *, long)
#pragma tg_funcdef(atom_max, __atom_max_long, long,  __global long *, long)
#pragma tg_funcdef(atom_max, __atom_max_ulong, ulong, volatile __global ulong *, ulong)
#pragma tg_funcdef(atom_max, __atom_max_ulong, ulong,  __global ulong *, ulong)
#pragma tg_funcdef(atom_max, __atom_max_int_local, int,  volatile __local int *, int)
#pragma tg_funcdef(atom_max, __atom_max_int_local, int,  __local int *, int)
#pragma tg_funcdef(atom_max, __atom_max_uint_local, unsigned int,  volatile __local unsigned int *, unsigned int)
#pragma tg_funcdef(atom_max, __atom_max_uint_local, unsigned int,  __local unsigned int *, unsigned int)
#pragma tg_funcdef(atom_max, __atom_max_long_local, long, volatile __local long *, long)
#pragma tg_funcdef(atom_max, __atom_max_long_local, long,  __local long *, long)
#pragma tg_funcdef(atom_max, __atom_max_ulong_local, ulong, volatile __local ulong *, ulong)
#pragma tg_funcdef(atom_max, __atom_max_ulong_local, ulong,  __local ulong *, ulong)
#undef atom_max
#define atom_max(__a, __b) __tg_builtin("atom_max", __a, __b)

#pragma tg_funcdef(atom_min, __atom_min_int, int, volatile  __global int *, int)
#pragma tg_funcdef(atom_min, __atom_min_int, int,  __global int *, int)
#pragma tg_funcdef(atom_min, __atom_min_uint, unsigned int, volatile __global unsigned int *, unsigned int)
#pragma tg_funcdef(atom_min, __atom_min_uint, unsigned int,  __global unsigned int *, unsigned int)
#pragma tg_funcdef(atom_min, __atom_min_long, long, volatile __global long *, long)
#pragma tg_funcdef(atom_min, __atom_min_long, long,  __global long *, long)
#pragma tg_funcdef(atom_min, __atom_min_ulong, ulong, volatile __global ulong *, ulong)
#pragma tg_funcdef(atom_min, __atom_min_ulong, ulong,  __global ulong *, ulong)
#pragma tg_funcdef(atom_min, __atom_min_int_local, int, volatile __local int *, int)
#pragma tg_funcdef(atom_min, __atom_min_int_local, int,  __local int *, int)
#pragma tg_funcdef(atom_min, __atom_min_uint_local, unsigned int, volatile __local unsigned int *, unsigned int)
#pragma tg_funcdef(atom_min, __atom_min_uint_local, unsigned int,  __local unsigned int *, unsigned int)
#pragma tg_funcdef(atom_min, __atom_min_long_local, long, volatile __local long *, long)
#pragma tg_funcdef(atom_min, __atom_min_long_local, long,  __local long *, long)
#pragma tg_funcdef(atom_min, __atom_min_ulong_local, ulong, volatile __local ulong *, ulong)
#pragma tg_funcdef(atom_min, __atom_min_ulong_local, ulong,  __local ulong *, ulong)
#undef atom_min
#define atom_min(__a, __b) __tg_builtin("atom_min", __a, __b)

#pragma tg_funcdef(atom_or, __atom_or_int, int, volatile __global int *, int)
#pragma tg_funcdef(atom_or, __atom_or_int, int,  __global int *, int)
#pragma tg_funcdef(atom_or, __atom_or_int, unsigned int, volatile __global unsigned int *, unsigned int)
#pragma tg_funcdef(atom_or, __atom_or_int, unsigned int,  __global unsigned int *, unsigned int)
#pragma tg_funcdef(atom_or, __atom_or_long, long, volatile __global long *, long)
#pragma tg_funcdef(atom_or, __atom_or_long, long,  __global long *, long)
#pragma tg_funcdef(atom_or, __atom_or_long, ulong, volatile __global ulong *, ulong)
#pragma tg_funcdef(atom_or, __atom_or_long, ulong,  __global ulong *, ulong)
#pragma tg_funcdef(atom_or, __atom_or_int_local, int, volatile __local int *, int)
#pragma tg_funcdef(atom_or, __atom_or_int_local, int,  __local int *, int)
#pragma tg_funcdef(atom_or, __atom_or_int_local, unsigned int, volatile __local unsigned int *, unsigned int)
#pragma tg_funcdef(atom_or, __atom_or_int_local, unsigned int,  __local unsigned int *, unsigned int)
#pragma tg_funcdef(atom_or, __atom_or_long_local, long, volatile __local long *, long)
#pragma tg_funcdef(atom_or, __atom_or_long_local, long,  __local long *, long)
#pragma tg_funcdef(atom_or, __atom_or_long_local, ulong, volatile __local ulong *, ulong)
#pragma tg_funcdef(atom_or, __atom_or_long_local, ulong,  __local ulong *, ulong)
#undef atom_or
#define atom_or(__a, __b) __tg_builtin("atom_or", __a, __b)

#pragma tg_funcdef(atom_sub, __atom_sub_int, int, volatile __global int *, int)
#pragma tg_funcdef(atom_sub, __atom_sub_int, int,  __global int *, int)
#pragma tg_funcdef(atom_sub, __atom_sub_int, unsigned int, volatile __global unsigned int *, unsigned int)
#pragma tg_funcdef(atom_sub, __atom_sub_int, unsigned int,  __global unsigned int *, unsigned int)
#pragma tg_funcdef(atom_sub, __atom_sub_long, long, volatile __global long *, long)
#pragma tg_funcdef(atom_sub, __atom_sub_long, long,  __global long *, long)
#pragma tg_funcdef(atom_sub, __atom_sub_long, ulong, volatile __global ulong *, ulong)
#pragma tg_funcdef(atom_sub, __atom_sub_long, ulong,  __global ulong *, ulong)
#pragma tg_funcdef(atom_sub, __atom_sub_int_local, int, volatile __local int *, int)
#pragma tg_funcdef(atom_sub, __atom_sub_int_local, int,  __local int *, int)
#pragma tg_funcdef(atom_sub, __atom_sub_int_local, unsigned int, volatile __local unsigned int *, unsigned int)
#pragma tg_funcdef(atom_sub, __atom_sub_int_local, unsigned int,  __local unsigned int *, unsigned int)
#pragma tg_funcdef(atom_sub, __atom_sub_long_local, long, volatile __local long *, long)
#pragma tg_funcdef(atom_sub, __atom_sub_long_local, long,  __local long *, long)
#pragma tg_funcdef(atom_sub, __atom_sub_long_local, ulong, volatile __local ulong *, ulong)
#pragma tg_funcdef(atom_sub, __atom_sub_long_local, ulong,  __local ulong *, ulong)
#undef atom_sub
#define atom_sub(__a, __b) __tg_builtin("atom_sub", __a, __b)

#pragma tg_funcdef(atom_xchg, __atom_xchg_int, int, volatile __global int *, int)
#pragma tg_funcdef(atom_xchg, __atom_xchg_int, int,  __global int *, int)
#pragma tg_funcdef(atom_xchg, __atom_xchg_int, unsigned int, volatile __global unsigned int *, unsigned int)
#pragma tg_funcdef(atom_xchg, __atom_xchg_int, unsigned int,  __global unsigned int *, unsigned int)
#pragma tg_funcdef(atom_xchg, __atom_xchg_long, long, volatile __global long *, long)
#pragma tg_funcdef(atom_xchg, __atom_xchg_long, long,  __global long *, long)
#pragma tg_funcdef(atom_xchg, __atom_xchg_long, ulong, volatile __global ulong *, ulong)
#pragma tg_funcdef(atom_xchg, __atom_xchg_long, ulong,  __global ulong *, ulong)
#pragma tg_funcdef(atom_xchg, __atom_xchg_int_local, int, volatile __local int *, int)
#pragma tg_funcdef(atom_xchg, __atom_xchg_int_local, int,  __local int *, int)
#pragma tg_funcdef(atom_xchg, __atom_xchg_int_local, unsigned int, volatile __local unsigned int *, unsigned int)
#pragma tg_funcdef(atom_xchg, __atom_xchg_int_local, unsigned int,  __local unsigned int *, unsigned int)
#pragma tg_funcdef(atom_xchg, __atom_xchg_long_local, long, volatile __local long *, long)
#pragma tg_funcdef(atom_xchg, __atom_xchg_long_local, long,  __local long *, long)
#pragma tg_funcdef(atom_xchg, __atom_xchg_long_local, ulong, volatile __local ulong *, ulong)
#pragma tg_funcdef(atom_xchg, __atom_xchg_long_local, ulong,  __local ulong *, ulong)
#undef atom_xchg
#define atom_xchg(__a, __b) __tg_builtin("atom_xchg", __a, __b)

#pragma tg_funcdef(atom_xor, __atom_xor_int, int, volatile __global int *, int)
#pragma tg_funcdef(atom_xor, __atom_xor_int, int,  __global int *, int)
#pragma tg_funcdef(atom_xor, __atom_xor_int, unsigned int, volatile __global unsigned int *, unsigned int)
#pragma tg_funcdef(atom_xor, __atom_xor_int, unsigned int,  __global unsigned int *, unsigned int)
#pragma tg_funcdef(atom_xor, __atom_xor_long, long, volatile __global long *, long)
#pragma tg_funcdef(atom_xor, __atom_xor_long, long,  __global long *, long)
#pragma tg_funcdef(atom_xor, __atom_xor_long, ulong, volatile __global ulong *, ulong)
#pragma tg_funcdef(atom_xor, __atom_xor_long, ulong,  __global ulong *, ulong)
#pragma tg_funcdef(atom_xor, __atom_xor_int_local, int, volatile __local int *, int)
#pragma tg_funcdef(atom_xor, __atom_xor_int_local, int,  __local int *, int)
#pragma tg_funcdef(atom_xor, __atom_xor_int_local, unsigned int, volatile __local unsigned int *, unsigned int)
#pragma tg_funcdef(atom_xor, __atom_xor_int_local, unsigned int,  __local unsigned int *, unsigned int)
#pragma tg_funcdef(atom_xor, __atom_xor_long_local, long, volatile __local long *, long)
#pragma tg_funcdef(atom_xor, __atom_xor_long_local, long,  __local long *, long)
#pragma tg_funcdef(atom_xor, __atom_xor_long_local, ulong, volatile __local ulong *, ulong)
#pragma tg_funcdef(atom_xor, __atom_xor_long_local, ulong,  __local ulong *, ulong)
#undef atom_xor
#define atom_xor(__a, __b) __tg_builtin("atom_xor", __a, __b)
#endif /* __IBM_VACPP_xl_gentype_h */
