/**********************************************************************/
/*                                                                    */
/*   Licensed Materials - Property of IBM.                            */
/*   IBM XL C for OpenCL, V0.3 (technology preview)                   */
/*   Copyright IBM Corp. 1991, 2006.                                  */
/*   All Rights Reserved.                                             */
/*   US Government Users Restricted Rights -                          */
/*   Use, duplication or disclosure restricted by                     */
/*   GSA ADP Schedule Contract with IBM Corp.                         */
/*                                                                    */
/**********************************************************************/

#ifndef __IBM_VACPP_sys_cdefs_h
#define __IBM_VACPP_sys_cdefs_h

#  include_next <sys/cdefs.h>

#  ifndef __cplusplus /* ! __cplusplus */
#    ifdef __THROW
#      undef  __THROW
#      define __THROW
#    endif /* __THROW */
#  endif  /* not __cplusplus */

#    ifdef __nonnull
#      undef  __nonnull
#      define __nonnull(x)
#    endif /* __nonnull */

#  ifdef __REDIRECT
     /* VisualAge C/C++ does not support __asm__ for aliasing so we use an alternate mechanism. */
#    undef __REDIRECT
#    undef __REDIRECT_NTH
#    if defined(__C99_PRAGMA_OPERATOR)
#      define __VACPP_MKSTR(__a) #__a

#      define __VACPP_MKMAP(__a, __b)  __VACPP_MKMAP1(__a, #__b)

#      define __VACPP_MKMAP1(__a, __b) __VACPP_MKSTR(map(__a, __b))

#      define __REDIRECT(__func, __prototype, __alias) __func __prototype  _Pragma(__VACPP_MKMAP(__func, __alias))
#      define __REDIRECT_NTH(__func, __prototype, __alias) __func __prototype __THROW  _Pragma(__VACPP_MKMAP(__func, __alias))
#    endif /* __cplusplus  && __C99_PRAGMA_OPERATOR */
#  endif /* __REDIRECT */
#endif /* not __IBM_VACPP_sys_cdefs_h */ 
