/**********************************************************************/
/*                                                                    */
/*   Licensed Materials - Property of IBM.                            */
/*   IBM XL C for OpenCL, V0.3 (technology preview)                   */
/*   Copyright IBM Corp. 1991, 2007.                                  */
/*   All Rights Reserved.                                             */
/*   US Government Users Restricted Rights -                          */
/*   Use, duplication or disclosure restricted by                     */
/*   GSA ADP Schedule Contract with IBM Corp.                         */
/*                                                                    */
/**********************************************************************/

#ifndef __IBM_VACPP_string_h
#define __IBM_VACPP_string_h 1

#if defined __STR__ && !defined __NO_STRING_INLINES 

# ifdef __cplusplus

#   if __SPU__
#     include <sys/features.h>
#   else
#     include <features.h>
#   endif
#   include <sys/types.h>

    extern "C" {
      extern char   *strcpy(char *, const char *) __THROW __attribute__((__IBMBuiltin__));
      extern int     strcmp(const char *, const char *) __THROW __attribute__((__IBMBuiltin__));
      extern size_t  strlen(const char *) __THROW __attribute__((__IBMBuiltin__));
      extern char   *strchr(const char *, int ) __THROW __attribute__((__IBMBuiltin__));
      extern char   *strrchr(const char *, int ) __THROW __attribute__((__IBMBuiltin__));
      extern char   *strcat(char *, const char *) __THROW __attribute__((__IBMBuiltin__));
      extern void   *memchr(const void *, int , size_t) __THROW __attribute__((__IBMBuiltin__));
      extern void   *memcpy(void *, const void *, size_t) __THROW __attribute__((__IBMBuiltin__));
      extern void   *memmove(void *s1, const void *, size_t ) __THROW __attribute__((__IBMBuiltin__));
      extern int     memcmp(const void *, const void *, size_t ) __THROW __attribute__((__IBMBuiltin__));
      extern void   *memset(void *, int , size_t ) __THROW __attribute__((__IBMBuiltin__));
      extern void   *memccpy(void *, const void *, int , size_t) __THROW __attribute__((__IBMBuiltin__));
      extern char   *strncat(char *, const char *, size_t ) __THROW __attribute__((__IBMBuiltin__));
      extern int     strncmp(const char *, const char *, size_t ) __THROW __attribute__((__IBMBuiltin__));
      extern char   *strncpy(char *, const char *, size_t) __THROW __attribute__((__IBMBuiltin__));

#     ifdef _ALL_SOURCE
        extern char   *index(const char *, int ) __THROW __attribute__((__IBMBuiltin__));
        extern char   *rindex(const char *, int ) __THROW __attribute__((__IBMBuiltin__));
#     endif /* _ALL_SOURCE */
    };

# endif /* __cplusplus */

# define _HAVE_STRING_ARCH_strcpy
# define _HAVE_STRING_ARCH_strcmp
# define _HAVE_STRING_ARCH_strchr
# define _HAVE_STRING_ARCH_memset
# define _HAVE_STRING_ARCH_strncat
# define _HAVE_STRING_ARCH_strncmp
# define _HAVE_STRING_ARCH_strncpy

#endif /* defined __STR__ && ! defined __NO_STRING_INLINES */
#endif /*__IBM_VACPP_string_h */

#ifdef __cplusplus
/*
 * Rename conflicting builtin declarations
 */
#define __bzero  __string_bzero
#include_next <string.h>
#undef __bzero
#else
#include_next <string.h>
#endif /* __cplusplus */

#ifndef __IBM_VACPP_string_h_2
#define __IBM_VACPP_string_h_2 1
#if defined __STR__ && !defined __NO_STRING_INLINES

# ifndef __cplusplus /* ! __cplusplus */

#   define strcpy(__s1,__s2) __strcpy(__s1,__s2)
#   define strcmp(__s1,__s2) __strcmp(__s1,__s2)
#   define strlen(__s1) __strlen(__s1)
#   define strchr(__s1,__c) __strchr(__s1,__c)
#   define strrchr(__s1,__c) __strrchr(__s1,__c)
#   define strcat(__s1,__s2) __strcat(__s1,__s2)
#   define memchr(__s1,__c,__n) __memchr(__s1,__c,__n)
#   define memcpy(__s1,__s2,__n) __memcpy(__s1,__s2,__n)
#   define memmove(__s1,__s2,__n) __memmove(__s1,__s2,__n)
#   define memcmp(__s1,__s2,__n) __memcmp(__s1,__s2,__n)
#   define memset(__s1,__c,__n) __memset(__s1,__c,__n)
#   define memccpy(__target,__source,__c,__n)  __memccpy(__target,__source,__c,__n)
#   define strncat(__s1, __s2, __n)    __strncat(__s1, __s2, __n)
#   define strncmp(__s1, __s2, __n)    __strncmp(__s1, __s2, __n)
#   define strncpy(__s1, __s2, __n)    __strncpy(__s1, __s2, __n)

#   ifdef _ALL_SOURCE
#     define index(__s1,__c) __strchr(__s1,__c)
#     define rindex(__s1,__c) __strrchr(__s1,__c)
#   endif /* _ALL_SOURCE */
 
# endif /* __cplusplus */

#endif /* defined __STR__ && !defined __NO_STRING_INLINES */

#endif /* not __IBM_VACPP_string_h_2 */ 
