/**********************************************************************/
/*                                                                    */
/*   Licensed Materials - Property of IBM.                            */
/*   IBM XL C for OpenCL, V0.3 (technology preview)                   */
/*   Copyright IBM Corp. 1991, 2007.                                  */
/*   All Rights Reserved.                                             */
/*   US Government Users Restricted Rights -                          */
/*   Use, duplication or disclosure restricted by                     */
/*   GSA ADP Schedule Contract with IBM Corp.                         */
/*                                                                    */
/**********************************************************************/

#if defined __MATH__ /* && !defined __NO_MATH_INLINES */

# ifdef __cplusplus

#   if __SPU__
#     ifdef __THROW
#       undef  __THROW
#     endif 
#     define __THROW
#     include <sys/features.h>
#   else
#     include <features.h>
#   endif
#   include <sys/types.h>

extern "C" {

  extern int abs(int) __THROW __attribute__((__IBMBuiltin__));
  extern long labs(long) __THROW __attribute__((__IBMBuiltin__));
  
# ifdef _LONG_LONG
      extern long long llabs(long long) __THROW __attribute__((__IBMBuiltin__));
# endif

# ifdef _ALL_SOURCE
  extern void imul_dbl(long, long, long *) __THROW __attribute__((__IBMBuiltin__));
  extern void umul_dbl(unsigned long, unsigned long, unsigned long *) __THROW __attribute__((__IBMBuiltin__));
# endif
};

# endif /* __cplusplus */

#endif /* defined __MATH && !defined __NO_MATH_INLINES */

#undef div
#undef ldiv

#include_next <stdlib.h>

#if defined __MATH__ /* && !defined __NO_MATH_INLINES */

# ifndef __cplusplus /* ! __cplusplus */

#ifndef _XL_OPENCL
# define abs(__j)             __abs(__j)
#endif /* !defined _XL_OPENCL */
# define llabs(__j)           __llabs(__j)
# define labs(__j)            __labs(__j)
# define div(__numer,__denom)   __div(__numer,__denom)
# define ldiv(__numer,__denom)  __ldiv(__numer,__denom)

#   if defined _ALL_SOURCE
#     define imul_dbl(__a, __b, __c)  __imul_dbl(__a, __b, __c)
#     define umul_dbl(__a, __b, __c)  __umul_dbl(__a, __b, __c)
#   endif /* _ALL_SOURCE */

# endif /* __cplusplus */

#endif /* defined __MATH && !defined __NO_MATH_INLINES */
