/**********************************************************************/
/*                                                                    */
/*   Licensed Materials - Property of IBM.                            */
/*   IBM XL C for OpenCL, V0.3 (technology preview)                   */
/*   Copyright IBM Corp. 1991, 2007.                                  */
/*   All Rights Reserved.                                             */
/*   US Government Users Restricted Rights -                          */
/*   Use, duplication or disclosure restricted by                     */
/*   GSA ADP Schedule Contract with IBM Corp.                         */
/*                                                                    */
/**********************************************************************/

#ifndef __IBM_VACPP_stdarg_h
#ifndef __need___va_list
#define __IBM_VACPP_stdarg_h 1
#endif /* not __need___va_list */
#undef __need___va_list

#if __cplusplus
extern "C" {
#endif

#undef _Va_start
#undef _Va_arg
#undef _Va_end
#undef __va_copy

#if __64BIT__

# ifndef __BUILTIN_VA_LIST
# define __BUILTIN_VA_LIST
#  ifndef __XLC_BUILTIN_VAARG__
    typedef char *__builtin_va_list;
#  endif
# endif

# if __cplusplus
#  define _Va_start(__list,__parmN) ( (__list) = __vastart(__parmN) )
# else
#  define _Va_start(__list,__parmN) \
        ( (__list) = (char *)((unsigned long)&(__parmN) + (((sizeof(__parmN)+7)/8)*8)) )
# endif

#  define _Va_align(__list,__t)  __extension__ \
        ( (__list) = (__typeof__(__list)) (((unsigned long)(__list) + \
                      ((__alignof__(__t) == 16 && !__is_longDouble(__t)) ? 15 : 3)) \
                      & ~((__alignof__(__t) == 16 && !__is_longDouble(__t)) ? 15 : 3)) )

# define _Va_arg(__list,__t)  \
         ( (_Va_align(__list,__t), (((__list) += (((sizeof(__t)+7)/8)*8))-sizeof(__t))) )
# define _Va_end(__list)  ( (__list) = (char *)0 )
# define __va_copy(__list1,__list2)  ( (__list1) = (__list2) )

#else /* 32-bit */

  extern void _Builtin __vastart(void *);
  extern void* __va_arg(void*, int);

# define _Va_start(__list,__parmN)  ( __vastart(&(__list)) )
# define _Va_arg(__list,__t) \
         ( __va_arg( (__list), __builtin_va_arg_incr((__typeof__(__typeof__(__t) *))0)) )
# define _Va_end(__list)  ( (void*)0 )
# define __va_copy(__list1,__list2)  ( (__list1)[0] = (__list2)[0] )

#endif /* 32-bit */

#ifndef __GNUC_VA_LIST
#define __GNUC_VA_LIST
typedef __builtin_va_list __gnuc_va_list;
#endif

#if !defined(__VA_LIST) && !defined(_VA_LIST_DEFINED) && !defined(_VA_LIST) && !defined(_VA_LIST_T_H) && !defined(__va_list__)
#define __VA_LIST
#define _VA_LIST_DEFINED
#define _VA_LIST
#define _VA_LIST_T_H
#define __va_list__
typedef __builtin_va_list va_list;
#endif

#if __IBM_VACPP_stdarg_h

#ifdef __SPU__
#if !defined(__NO_XLC_BUILTIN_VA)
 #define va_start(__list,__parmN) __builtin_va_start(__list,__parmN)
 #define va_arg(__list,__mode) __builtin_va_arg(__list,__mode)
#else
  #define va_start(__list,__parmN) __list = (char *)((unsigned long)&(__parmN) + \
    (((sizeof(__parmN)+15)/16)*16))
  #define va_end(__list) (__list)=(char *)0
  #define va_arg(__list, __mode) ((__mode *)( (((__list)+=(((sizeof(__mode)+15)/16)*16)) -\
    (((sizeof(__mode)+15)/16)*16)) ))[0]
#endif
#if !defined(__NO_XLC_BUILTIN_VA) && defined(__IBMC__)
 #define va_end(__list) __builtin_va_end(__list) 
#elif !defined(__NO_XLC_BUILTIN_VA) && defined(__IBMCPP__)
  #define va_end(__list)
#endif
#else

#if defined(__64BIT__) && (defined(__IBMC__) || defined(__IBMCPP__)) && !defined(__NO_XLC_BUILTIN_VA)
# define va_start(__list,__parmN) __builtin_va_start(__list,__parmN)
#else
# define va_start(__list,__parmN)  ( (void) _Va_start(__list,__parmN) )
#endif

#if __64BIT__
#if (defined(__IBMC__) || defined(__IBMCPP__)) && !defined(__NO_XLC_BUILTIN_VA)
# define va_arg(__list,__t)  __builtin_va_arg(__list,__t)
#else
# define va_arg(__list,__t)  __extension__ \
         ((__typeof__(__typeof__(__t) *)) _Va_arg(__list,__t))[0]
#endif
#else
# define va_arg(__list,__t)  __extension__ \
         (*((__typeof__(__typeof__(__t) *)) _Va_arg(__list,__t)))
#endif /* __64BIT__ */


#if defined(__IBMC__) && !defined(__NO_XLC_BUILTIN_VA)
#define va_end(__list) __builtin_va_end(__list)
#else
#define va_end(__list) ( (void) _Va_end(__list) )
#endif

#endif /* __SPU__ */
	 
#if !(__STDC__ && __STDC_VERSION__ < 199901L)
# ifdef va_copy
#  undef va_copy
# endif

#if defined(__IBMC__) && !defined(__NO_XLC_BUILTIN_VA) && __IBMC__>=800
# define va_copy(__list1,__list2) __builtin_va_copy(__list1,__list2)
#else
# define va_copy(__list1,__list2) ( (void) (__va_copy(__list1,__list2)) )
#endif

#endif

#endif /* __IBM_VACPP_stdarg_h */

#if __cplusplus
}
#endif

#endif /* not __IBM_VACPP_stdarg_h */ 
