/**********************************************************************/
/*                                                                    */
/*   Licensed Materials - Property of IBM.                            */
/*   IBM XL C for OpenCL, V0.3 (technology preview)                   */
/*   Copyright IBM Corp. 1991, 2006.                                  */
/*   All Rights Reserved.                                             */
/*   US Government Users Restricted Rights -                          */
/*   Use, duplication or disclosure restricted by                     */
/*   GSA ADP Schedule Contract with IBM Corp.                         */
/*                                                                    */
/**********************************************************************/

#ifndef _SPU_INTRINSICS_H
#define _SPU_INTRINSICS_H 1

/* Single Token Vector Data Types */
#define vec_uchar16          vector unsigned char      
#define vec_char16           vector signed char        
#define vec_ushort8          vector unsigned short     
#define vec_short8           vector signed short       
#define vec_uint4            vector unsigned int       
#define vec_int4             vector signed int         
#define vec_ullong2          vector unsigned long long 
#define vec_llong2           vector signed long long   
#define vec_float4           vector float              
#define vec_double2          vector double             

/* SPU Channel Numbers */
#define SPU_RdEventStat      0
#define SPU_WrEventMask      1
#define SPU_WrEventAck       2
#define SPU_RdSigNotify1     3
#define SPU_RdSigNotify2     4
#define SPU_WrDec            7
#define SPU_RdDec            8
#define SPU_RdEventMask      11
#define SPU_RdMachStat       13
#define SPU_WrSRR0           14
#define SPU_RdSRR0           15
#define SPU_WrOutMbox        28
#define SPU_RdInMbox         29
#define SPU_WrOutIntrMbox    30

/* MCF Channel Numbers */
#define MFC_WrMSSyncReq      9
#define MFC_RdTagMask        12
#define MFC_LSA              16
#define MFC_EAH              17
#define MFC_EAL              18
#define MFC_Size             19
#define MFC_TagID            20
#define MFC_Cmd              21
#define MFC_WrTagMask        22
#define MFC_WrTagUpdate      23
#define MFC_RdTagStat        24
#define MFC_RdListStallStat  25
#define MFC_WrListStallAck   26
#define MFC_RdAtomicStat     27

#include <spu_internals.h>

#endif /* _SPU_INTRINSICS_H */
