/**********************************************************************/
/*                                                                    */
/*   Licensed Materials - Property of IBM.                            */
/*   IBM XL C for OpenCL, V0.3 (technology preview)                   */
/*   Copyright IBM Corp. 1991, 2007.                                  */
/*   All Rights Reserved.                                             */
/*   US Government Users Restricted Rights -                          */
/*   Use, duplication or disclosure restricted by                     */
/*   GSA ADP Schedule Contract with IBM Corp.                         */
/*                                                                    */
/**********************************************************************/

#ifndef _SPU_INTERNALS_H
#define _SPU_INTERNALS_H 1

#define SPU_SV_NEG_DENORM    0x01  /* Test for a negative denormalized number.  */
#define SPU_SV_POS_DENORM    0x02  /* Test for a positive denormalized number.  */
#define SPU_SV_NEG_ZERO      0x04  /* Test for a negative zero. */
#define SPU_SV_POS_ZERO      0x08  /* Test for a positive zero.  */
#define SPU_SV_NEG_INFINITY  0x10  /* Test for a negative infinity. */
#define SPU_SV_POS_INFINITY  0x20  /* Test for a positive infinity. */
#define SPU_SV_NAN           0x40  /* Test for a Not a Number, both signaling and quiet. */

#include "intrinsics_generic.h"
#include "intrinsics_specific.h"

#endif /* _SPU_INTERNALS_H */
