/**********************************************************************/
/*                                                                    */
/*   Licensed Materials - Property of IBM.                            */
/*   IBM XL C for OpenCL, V0.3 (technology preview)                   */
/*   Copyright IBM Corp. 2007.                                        */
/*   All Rights Reserved.                                             */
/*   US Government Users Restricted Rights -                          */
/*   Use, duplication or disclosure restricted by                     */
/*   GSA ADP Schedule Contract with IBM Corp.                         */
/*                                                                    */
/**********************************************************************/

#ifndef _PPU_INTRINSICS_H
#define _PPU_INTRINSICS_H 1

#ifdef __cplusplus
#include "builtins.h"

extern "C" {
#endif 

#define __V4SI __vector signed int 

#define __cntlzw(v) __clz(v)
#define __cntlzd(v) __clzll(v)

#define __nop()     (__nop)(0)
#define __cctpl()   (__nop)(1)
#define __cctpm()   (__nop)(2)
#define __cctph()   (__nop)(3)
#define __db8cyc()  (__nop)(28)
#define __db10cyc() (__nop)(29)
#define __db12cyc() (__nop)(30)
#define __db16cyc() (__nop)(31)

#define __dcbf(base) \
  __asm__ volatile ("dcbf %y0" : "=m" (*(__V4SI*) (base)) : : "memory")
 
#define __dcbst(base) \
  __asm__ volatile ("dcbst %y0" : "=m" (*(__V4SI*) (base)) : : "memory")

#define __icbi(base) \
  __asm__ volatile ("icbi %y0" : "=m" (*(__V4SI*) (base)) : : "memory")
  
#define __dcbi(base) \
  __asm__ volatile ("dcbi %y0" : "=m" (*(__V4SI*) (base)) : : "memory")

#define __dcbt_TH1000(EATRUNC, D, UG, ID)				\
  __asm__ volatile ("dcbt %y0,8"					\
	   : "=m" (*(__V4SI*) ((((unsigned long long) EATRUNC) & ~0x7F)	\
	   		       | (((D & 1) << 6)			\
	   		       | ((UG & 1) << 5)			\
	   		       | (ID & 0xF)))) : : "memory")

#define __dcbt_TH1010(GO, S, UNITCNT, T, U, ID)			     \
  __asm__ volatile ("dcbt %y0,10"				     \
	   : "=m" (*(__V4SI*) ((((unsigned long long) GO & 1) << 31) \
	   		       | ((S & 0x3) << 29)		     \
	   		       | ((UNITCNT & 0x3FF) << 7)	     \
	   		       | ((T & 1) << 6)			     \
	   		       | ((U & 1) << 5)			     \
	   		       | (ID & 0xF))) : : "memory")

#define __lhbrx(base) \
  __load2r(base)

#define __lwbrx(base) \
  __load4r(base)

#define __ldbrx(base) \
  __load8r(base)

#define __sthbrx(base, value) \
  __store2r((value), (unsigned short*)(base))

#define __stwbrx(base, value) \
  __store4r((value), (unsigned*)(base))

#define __stdbrx(base, value) \
  __store8r((value), (unsigned long long*)(base))

#define __mffs() \
  __readflm() 

#ifndef __cplusplus 
static __inline__ float __fnabsf(float x) __attribute__((always_inline));
#endif
static __inline__ float
__fnabsf(float x)
{
  return __fnabss(x);
}

static __inline__ long long ___fctid (double __x) {
  union {
    double    __d;
    long long __ll;
  } __u;
  __u.__d = __fctid (__x);
  return __u.__ll; 
}
#define __fctid ___fctid

static __inline__ long long ___fctidz (double __x) {
  union {
    double    __d;
    long long __ll;
  } __u;
  __u.__d = __fctidz (__x);
  return __u.__ll; 
}
#define __fctidz ___fctidz


static __inline__ double ___fcfid (long long __x) {
  union {
    double    __d;
    long long __ll;
  } __u;
  __u.__ll = __x;
  return __fcfid (__u.__d);
}
#define __fcfid ___fcfid

static __inline__ int ___fctiw (double __x) {
  union {
    double    __d;
    long long __ll;
  } __u;
  __u.__d = __fctiw (__x);
  return __u.__ll; 
}
#define __fctiw ___fctiw

static __inline__ int ___fctiwz (double __x) {
  union {
    double    __d;
    long long __ll;
  } __u;
  __u.__d = __fctiwz (__x);
  return __u.__ll; 
}
#define __fctiwz ___fctiwz

#if !defined(__64BIT__)
static __inline__ unsigned long long ____mftb() {
  unsigned int hi,lo;
  for (;;) {
    hi = __mftbu();
    lo = __mftb();
    if (hi == __mftbu())
      break;
  }
  return ((unsigned long long) hi) << 32 | lo;
}
#define __mftb ____mftb
#endif

#ifdef __cplusplus
unsigned int __maskg(unsigned int, unsigned int) __attribute__((__IBMBuiltin__));
#endif

#define __rlwnm(__a, __b, __mb, __me) (__rlwnm)(__a, __b, __maskg(__mb,__me))
#define __rlwimi(__a, __b, __sh, __mb, __me) (__rlwimi)(__a, __b, __sh, __maskg(__mb,__me))

#define __frsp(d)  ((float)d)
#define __stfiwx(a,b) __stfiw(a,b)

#define __rldcl(a,b,mb) \
  __extension__ ({unsigned long long d; \
  __asm__  ("rldcl %0,%1,%2,%3" : "=r" (d) : "r" (a), "r" (b), "i" (mb)); \
  d;})

#define __rldcr(a,b,mb) \
  __extension__ ({unsigned long long d; \
  __asm__  ("rldcr %0,%1,%2,%3" : "=r" (d) : "r" (a), "r" (b), "i" (mb)); \
  d;})

#define __rldicl(a,sh,mb) \
  __extension__ ({unsigned long long d; \
  __asm__  ("rldicl %0,%1,%2,%3" : "=r" (d) : "r" (a), "i" (sh), "i" (mb)); \
  d;})

#define __rldic(a,sh,mb) \
  __extension__ ({unsigned long long d; \
  __asm__  ("rldic %0,%1,%2,%3" : "=r" (d) : "r" (a), "i" (sh), "i" (mb)); \
  d;})

#define __rldimi(a,b,sh,mb) \
  __extension__ ({unsigned long long d; \
  __asm__ ("rldimi %0,%1,%2,%3" : "=r" (d) : "r" (b), "i" (sh), "i" (mb), "0" (a)); \
  d;})

#define __rldicr(a,sh,me) \
  __extension__ ({unsigned long long d; \
  __asm__  ("rldicr %0,%1,%2,%3" : "=r" (d) : "r" (a), "i" (sh), "i" (me)); \
  d;})

#define __rlwinm(a,sh,mb,me) \
  __extension__ ({unsigned int d; \
  __asm__  ("rlwinm %0,%1,%2,%3,%4" : "=r" (d) : "r" (a), "i" (sh), "i" (mb), "i" (me)); \
  d;})

#ifdef __cplusplus
}
#endif

#endif /* _PPU_INTRINSICS_H */
