/**********************************************************************/
/*                                                                    */
/*   Licensed Materials - Property of IBM.                            */
/*   IBM XL C for OpenCL, V0.3 (technology preview)                   */
/*   Copyright IBM Corp. 2009.                                        */
/*   All Rights Reserved.                                             */
/*   US Government Users Restricted Rights -                          */
/*   Use, duplication or disclosure restricted by                     */
/*   GSA ADP Schedule Contract with IBM Corp.                         */
/*                                                                    */
/**********************************************************************/

#ifndef  __XLC_OPENCL_INTERNALS_H__
#define __XLC_OPENCL_INTERNALS_H__ 1

#define CL_VERSION_1_0 100
#define CL_VERSION_1_1 110

typedef long long llong;

#if defined (__SPU__)
#define _SIZE_T
#endif /* __SPU__ */
typedef __SIZE_TYPE__ size_t;

#define _PTRDIFF_T
typedef __PTRDIFF_TYPE__ ptrdiff_t;
typedef signed   __PTRDIFF_TYPE__ intptr_t;
typedef unsigned __PTRDIFF_TYPE__ uintptr_t;

#define kernel   __kernel

#define global   __global
#define local    __local
#define constant __constant
#define private  __private

typedef unsigned long image2d_t;
typedef unsigned long image3d_t;
typedef unsigned long sampler_t;

#endif  /* __XLC_OPENCL_INTERNALS_H__ */
