/**********************************************************************/
/*                                                                    */
/*   Licensed Materials - Property of IBM.                            */
/*   IBM XL C for OpenCL, V0.3 (technology preview)                   */
/*   Copyright IBM Corp. 2003, 2007.                                  */
/*   All Rights Reserved.                                             */
/*   US Government Users Restricted Rights -                          */
/*   Use, duplication or disclosure restricted by                     */
/*   GSA ADP Schedule Contract with IBM Corp.                         */
/*                                                                    */
/**********************************************************************/

#ifndef __IBM_VACPP_math_h
#define __IBM_VACPP_math_h 1

#ifndef _XL_OPENCL

#if defined __MATH__ /* && ! defined __NO_MATH_INLINES */

# ifdef __cplusplus

#   if __SPU__
#     ifdef __THROW
#       undef  __THROW
#     endif 
#     define __THROW
#     include <sys/features.h>
#   else
#     include <features.h>
#   endif
#   include <sys/types.h>   

    extern "C" {
      extern double acos(double) __THROW __attribute__((__IBMBuiltin__));
      extern double asin(double) __THROW __attribute__((__IBMBuiltin__));
      extern double atan(double) __THROW __attribute__((__IBMBuiltin__));
      extern double atan2(double, double) __THROW __attribute__((__IBMBuiltin__));
      extern double cbrt(double) __THROW __attribute__((__IBMBuiltin__));
      extern double ceil(double) __THROW __attribute__((__IBMBuiltin__));
      extern double cosh(double) __THROW __attribute__((__IBMBuiltin__));
      extern double cos(double) __THROW __attribute__((__IBMBuiltin__));
      extern double exp(double) __THROW __attribute__((__IBMBuiltin__));
      extern float  expf(float) __THROW __attribute__((__IBMBuiltin__));
      extern float  exp2f(float) __THROW __attribute__((__IBMBuiltin__));
      extern double expm1(double) __THROW __attribute__((__IBMBuiltin__));
      extern double fabs(double) __THROW __attribute__((__IBMBuiltin__));
      extern double floor(double) __THROW __attribute__((__IBMBuiltin__));
      extern float  fsqrts(float) __THROW __attribute__((__IBMBuiltin__));
      extern double log(double) __THROW __attribute__((__IBMBuiltin__));
      extern float  logf(float) __THROW __attribute__((__IBMBuiltin__));
      extern double log10(double) __THROW __attribute__((__IBMBuiltin__));
      extern double log1p(double) __THROW __attribute__((__IBMBuiltin__));
      extern double pow(double,double) __THROW __attribute__((__IBMBuiltin__));
      extern float  powf(float, float) __THROW __attribute__((__IBMBuiltin__));
      extern double sin(double) __THROW __attribute__((__IBMBuiltin__));
      extern double sinh(double) __THROW __attribute__((__IBMBuiltin__));
      extern void   sincosf(float, float*, float*) __THROW __attribute__((__IBMBuiltin__));
      extern double sqrt(double) __THROW __attribute__((__IBMBuiltin__));
      extern float  sqrtf(float) __THROW __attribute__((__IBMBuiltin__));
      extern float  sqrtfs(float) __THROW __attribute__((__IBMBuiltin__));
      extern double tan(double) __THROW __attribute__((__IBMBuiltin__));
      extern double tanh(double) __THROW __attribute__((__IBMBuiltin__));
      
#     ifdef _ALL_SOURCE
        extern double copysign(double, double) __THROW __attribute__((__IBMBuiltin__));
#     endif   
    };

# endif /* __cplusplus */

#endif /* defined __MATH && ! defined __NO_MATH_INLINES */

#include_next <math.h>

#if defined __MATH__ /* && !defined __NO_MATH_INLINES */
     
# if !defined(__cplusplus) /* ! __cplusplus */

#   undef acos
#   undef acosh
#   undef asin
#   undef asinh
#   undef atan
#   undef atanh
#   undef atan2
#   undef cbrt
#   undef ceil

#   undef ceilf
#   undef cos
#   undef cosh

#   undef exp
#   undef expm1
#   undef fabs
#   undef fabsf
#   undef floor

#   undef expf
#   undef logf
#   undef sincosf
#   undef exp2f
#   undef powf

#   undef floorf

#   undef fsqrts

#   undef log
#   undef log10

#   undef log1p
#   undef pow

#   undef sin
#   undef sinh

#   undef sqrt
#   undef sqrtf
#   undef sqrtfs
#   undef tan
#   undef tanh
#   undef ceill
#   undef fabsl
#   undef floorl

#   define acos(__x)         __acos(__x)
#   define acosh(__x)        __acosh(__x)
#   define asin(__x)         __asin(__x)
#   define asinh(__x)        __asinh(__x)
#   define atan(__x)         __atan(__x)
#   define atanh(__x)        __atanh(__x)
#   define atan2(__x,__y)    __atan2(__x,__y)
#   define cbrt(__x)         __cbrt(__x)
#   define ceil(__x)         __ceil(__x)

#   define ceilf(__x)        __ceilf(__x)

#   define ceill(__x)        __ceil(__x)

#   define cos(__x)          __cos(__x)
#   define cosh(__x)         __cosh(__x)

#   define expf(__x)         __expf(__x)
#   define logf(__x)         __logf(__x)
#   define sincosf(__x,__y,__z)  __sincosf(__x,__y,__z)
#   define exp2f(__x)        __exp2f(__x)
#   define powf(__x,__y)     __powf(__x,__y)

#   define exp(__x)          __exp(__x)
#   define expm1(__x)        __expm1(__x)
#   define fabs(__x)         __fabs(__x)
#   define fabsf(__x)         __fabsf(__x)
#   define fabsl(__x)        __fabs(__x)
#   define floor(__x)        __floor(__x)

#   define floorf(__x)       __floorf(__x)

#   define floorl(__x)       __floor(__x)
#   define fsqrts(__x)       __fsqrts(__x)

#   define log(__x)          __log(__x)
#   define log10(__x)        __log10(__x)

#   define log1p(__x)        __log1p(__x)
#   define pow(__x,__y)      __pow(__x,__y)

#   define sin(__x)          __sin(__x)
#   define sinh(__x)         __sinh(__x)

#   define sqrt(__x)         __sqrt(__x)
#   define sqrtf(__x)        __sqrtf(__x)
#   define sqrtfs(__x)       __sqrtfs(__x)
#   define tan(__x)          __tan(__x)
#   define tanh(__x)         __tanh(__x)

#   ifdef _ALL_SOURCE
#     define copysign(x,y)     __copysign(x,y)
#   endif /* _ALL_SOURCE */

# endif /* ! __cplusplus */

# undef  HUGE_VAL
# define HUGE_VAL (__extension__ 0x1.0p2047)

# if defined(__SPU__) || (!((defined(__STDC__) && __STDC_VERSION__ < 199901L)) || defined(_ISOC99_SOURCE))
#   undef  HUGE_VALL
#   define HUGE_VALL HUGE_VAL
# endif

# if defined(__SPU__)
#   undef  HUGE_VALF
#   ifdef FLT_MAX
#     define HUGE_VALF FLT_MAX
#   else
#     define HUGE_VALF __FLT_MAX__
#   endif
# elif !((defined(__STDC__) && __STDC_VERSION__ < 199901L)) || defined(_ISOC99_SOURCE)
#   undef  HUGE_VALF
#   define HUGE_VALF INFINITY
# endif

# if defined(__SPU__) || (!((defined(__STDC__) && __STDC_VERSION__ < 199901L)) || defined(_ISOC99_SOURCE))
#   ifndef __cplusplus
#     undef  INFINITY
#     define INFINITY  __builtin_val("0x7f800000", float)  
#     undef  NAN
#     define NAN       __builtin_val("0x7fc00000", float) 
#   endif
# endif

# if !((defined(__STDC__) && __STDC_VERSION__ < 199901L)) || defined(_ISOC99_SOURCE)
#  ifdef __cplusplus
    static const unsigned int _SINFINITY = 0x7f800000;
    static const unsigned int _SQNAN     = 0x7fc00000;
#   undef  INFINITY
#   define INFINITY  (*((float *)(&_SINFINITY)))
#   undef  NAN
#   define NAN       (*((float *)(&_SQNAN)))      
#  endif

#   undef  isgreater
#   define isgreater(x, y)                                         \
      (__extension__                                               \
        ({ __typeof__(x) __x = (x); __typeof__(y) __y = (y);       \
           (isnan(__x) || isnan(__y)) ? 0 : (__x) > (__y); }))

#   undef  isgreaterequal
#   define isgreaterequal(x, y)                                    \
      (__extension__                                               \
        ({ __typeof__(x) __x = (x); __typeof__(y) __y = (y);       \
           (isnan(__x) || isnan(__y)) ? 0 : (__x) >= (__y); }))

#   undef  isless
#   define isless(x, y)                                            \
      (__extension__                                               \
        ({ __typeof__(x) __x = (x); __typeof__(y) __y = (y);       \
           (isnan(__x) || isnan(__y)) ? 0 : (__x) < (__y); }))

#   undef  islessequal
#   define islessequal(x, y)                                       \
      (__extension__                                               \
        ({ __typeof__(x) __x = (x); __typeof__(y) __y = (y);       \
           (isnan(__x) || isnan(__y)) ? 0 : (__x) <= (__y); }))

#   undef  islessgreater
#   define islessgreater(x, y)                                     \
      (__extension__                                               \
        ({ __typeof__(x) __x = (x); __typeof__(y) __y = (y);       \
           (isnan(__x) || isnan(__y)) ? 0 : (__x) != (__y); }))

#   undef  isunordered
#   define isunordered(x, y)                                       \
      (__extension__                                               \
        ({ __typeof__(x) __x = (x); __typeof__(y) __y = (y);       \
           (isnan(__x) || isnan(__y)); }))
# endif /* ISOC99 */

#endif /* defined __MATH && ! defined __NO_MATH_INLINES */

#else

#undef  INFINITY
#define INFINITY  __builtin_val("0x7f800000", float)
#undef  NAN
#define NAN       __builtin_val("0x7fc00000", float)

#endif /* defined _XL_OPENCL */

#endif /* not __IBM_VACPP_math_h */ 
