/**********************************************************************/
/*                                                                    */
/*   Licensed Materials - Property of IBM.                            */
/*   IBM XL C for OpenCL, V0.3 (technology preview)                   */
/*   Copyright IBM Corp. 2005, 2006.                                  */
/*   All Rights Reserved.                                             */
/*   US Government Users Restricted Rights -                          */
/*   Use, duplication or disclosure restricted by                     */
/*   GSA ADP Schedule Contract with IBM Corp.                         */
/*                                                                    */
/**********************************************************************/

/***************************************************************************
 * specific vector intrinsics
 *
 ***************************************************************************/

#ifndef _INTRINSICS_SPECIFIC_H
#define _INTRINSICS_SPECIFIC_H 1

typedef vector unsigned char qword;

#ifndef __cplusplus /* ! __cplusplus */

/* Generate Controls for sub-quadword insertion */
#define si_cbd		__si_cbd
#define si_cbx		__si_cbx
#define si_cdd		__si_cdd
#define si_cdx		__si_cdx
#define si_chd		__si_chd
#define si_chx		__si_chx
#define si_cwd		__si_cwd
#define si_cwx		__si_cwx

/* Constant Formation Intrinsics */
#define si_il		__si_il
#define si_ila		__si_ila
#define si_ilh		__si_ilh
#define si_ilhu		__si_ilhu
#define si_iohl		__si_iohl

/* nop */
#define si_lnop		__si_lnop
#define si_nop		__si_nop

/* Memory Load and Store Intrinsics */
#define si_lqa		__si_lqa
#define si_lqd		__si_lqd
#define si_lqr		__si_lqr
#define si_lqx		__si_lqx
#define si_stqa		__si_stqa
#define si_stqd		__si_stqd
#define si_stqr		__si_stqr
#define si_stqx		__si_stqx

/* Control Intrinsics */
#define si_stopd	__si_stopd

/* Casting Intrinsics */
#define si_to_char	__si_to_char
#define si_to_uchar	__si_to_uchar
#define si_to_short	__si_to_short
#define si_to_ushort	__si_to_ushort
#define si_to_int	__si_to_int
#define si_to_uint	__si_to_uint
#define si_to_ptr	__si_to_ptr
#define si_to_llong	__si_to_llong
#define si_to_ullong	__si_to_ullong
#define si_to_float	__si_to_float
#define si_to_double	__si_to_double
#define si_from_char	__si_from_char
#define si_from_uchar	__si_from_uchar
#define si_from_short	__si_from_short
#define si_from_ushort	__si_from_ushort
#define si_from_int	__si_from_int
#define si_from_uint	__si_from_uint
#define si_from_ptr	__si_from_ptr
#define si_from_llong	__si_from_llong
#define si_from_ullong	__si_from_ullong
#define si_from_float	__si_from_float
#define si_from_double	__si_from_double

/* Conversion Intrinsics */
#define si_cuflt	__si_cuflt
#define si_csflt	__si_csflt
#define si_cflts	__si_cflts
#define si_cfltu	__si_cfltu

#define si_xsbh		__si_xsbh
#define si_xshw		__si_xshw
#define si_xswd		__si_xswd
#define si_fesd		__si_fesd
#define si_frds		__si_frds

/* Arithmetic Intrinsics */
#define si_a            __si_a
#define si_ah           __si_ah
#define si_ai           __si_ai
#define si_ahi          __si_ahi
#define si_fa		__si_fa
#define si_dfa		__si_dfa

#define si_addx         __si_addx
#define si_bg           __si_bg
#define si_bgx          __si_bgx
#define si_cg           __si_cg
#define si_cgx          __si_cgx

#define si_mpya		__si_mpya
#define si_fma		__si_fma
#define si_dfma		__si_dfma
#define si_mpyhha	__si_mpyhha
#define si_mpyhhau	__si_mpyhhau
#define si_fms		__si_fms
#define si_dfms		__si_dfms
#define si_fm		__si_fm
#define si_dfm		__si_dfm
#define si_mpyh		__si_mpyh
#define si_mpyhh	__si_mpyhh
#define si_mpyhhu	__si_mpyhhu
#define si_mpy		__si_mpy
#define si_mpyi		__si_mpyi
#define si_mpyu		__si_mpyu
#define si_mpyui	__si_mpyui
#define si_mpys		__si_mpys
#define si_dfnma	__si_dfnma
#define si_fnms		__si_fnms
#define si_dfnms	__si_dfnms
#define si_frest	__si_frest
#define si_fi		__si_fi
#define si_frsqest	__si_frsqest
#define si_sfh          __si_sfh
#define si_sf           __si_sf
#define si_sfi          __si_sfi
#define si_sfhi         __si_sfhi
#define si_fs		__si_fs
#define si_dfs		__si_dfs
#define si_sfx          __si_sfx

/* Byte Operation Intrinsics */
#define si_absdb	__si_absdb
#define si_avgb		__si_avgb
#define si_sumb		__si_sumb

/* Compare, Branch and Halt Intrinsics */
#define si_bisled	__si_bisled
#define si_bisledd	__si_bisledd
#define si_bislede	__si_bislede

#define si_fcmeq	__si_fcmeq
#define si_fcmgt	__si_fcmgt
#define si_ceqb         __si_ceqb
#define si_ceqh         __si_ceqh
#define si_ceq          __si_ceq
#define si_fceq		__si_fceq
#define si_ceqbi        __si_ceqbi
#define si_ceqhi        __si_ceqhi
#define si_ceqi         __si_ceqi
#define si_cgtb		__si_cgtb
#define si_cgtbi	__si_cgtbi
#define si_clgtb	__si_clgtb
#define si_clgtbi	__si_clgtbi
#define si_cgth		__si_cgth
#define si_cgthi	__si_cgthi
#define si_clgth	__si_clgth
#define si_clgthi	__si_clgthi
#define si_cgt		__si_cgt
#define si_cgti		__si_cgti
#define si_clgt		__si_clgt
#define si_clgti	__si_clgti
#define si_fcgt		__si_fcgt

#define si_heq		__si_heq
#define si_heqi		__si_heqi
#define si_hgt		__si_hgt
#define si_hlgt		__si_hlgt
#define si_hgti		__si_hgti
#define si_hlgti	__si_hlgti

/* Bits and Mask Intrinsics */
#define si_cntb         __si_cntb
#define si_clz          __si_clz
#define si_gbb		__si_gbb
#define si_gbh		__si_gbh
#define si_gb		__si_gb
#define si_fsmb		__si_fsmb
#define si_fsmbi	__si_fsmbi
#define si_fsmh		__si_fsmh
#define si_fsm		__si_fsm
#define si_selb		__si_selb
#define si_shufb	__si_shufb

/* Logical Intrinsics */
#define si_and		__si_and
#define si_andbi	__si_andbi
#define si_andhi	__si_andhi
#define si_andi		__si_andi
#define si_andc		__si_andc
#define si_eqv		__si_eqv
#define si_nand		__si_nand
#define si_nor		__si_nor
#define si_or		__si_or
#define si_orbi		__si_orbi
#define si_orhi		__si_orhi
#define si_ori		__si_ori
#define si_orc		__si_orc
#define si_orx		__si_orx
#define si_xor		__si_xor
#define si_xorbi	__si_xorbi
#define si_xorhi	__si_xorhi
#define si_xori		__si_xori

/* Shift and Rotate Intrinsics */
#define si_roth		__si_roth
#define si_rot		__si_rot
#define si_rothi	__si_rothi
#define si_roti		__si_roti
#define si_rothm	__si_rothm
#define si_rotm		__si_rotm
#define si_rothmi	__si_rothmi
#define si_rotmi	__si_rotmi
#define si_rotmah	__si_rotmah
#define si_rotma	__si_rotma
#define si_rotmahi	__si_rotmahi
#define si_rotmai	__si_rotmai
#define si_rotqmbii	__si_rotqmbii
#define si_rotqmbi	__si_rotqmbi
#define si_rotqmbyi	__si_rotqmbyi
#define si_rotqmby	__si_rotqmby
#define si_rotqmbybi	__si_rotqmbybi
#define si_rotqbii	__si_rotqbii
#define si_rotqbi	__si_rotqbi
#define si_rotqbyi	__si_rotqbyi
#define si_rotqby	__si_rotqby
#define si_rotqbybi	__si_rotqbybi
#define si_shlh		__si_shlh
#define si_shl		__si_shl
#define si_shlhi	__si_shlhi
#define si_shli		__si_shli
#define si_shlqbii	__si_shlqbii
#define si_shlqbi	__si_shlqbi
#define si_shlqbyi	__si_shlqbyi
#define si_shlqby	__si_shlqby
#define si_shlqbybi	__si_shlqbybi

/* Control Intrinsics */
#define si_mfspr	__si_mfspr
#define si_fscrwr	__si_fscrwr
#define si_fscrrd	__si_fscrrd
#define si_mtspr	__si_mtspr
#define si_dsync	__si_dsync
#define si_stop		__si_stop
#define si_sync		__si_sync
#define si_syncc	__si_syncc

/* Channel Control Intrinsics */
#define si_rdch		__si_rdch
#define si_rchcnt	__si_rchcnt
#define si_wrch		__si_wrch

#ifdef __SPU_EDP__
#define si_dfcmeq       __si_dfcmeq
#define si_dfcmgt       __si_dfcmgt
#define si_dfceq        __si_dfceq
#define si_dfcgt        __si_dfcgt
#define si_dftsv        __si_dftsv
#endif

#endif /* ! __cplusplus */

#endif /* _INTRINSICS_SPECIFIC_H */
