/**********************************************************************/
/*                                                                    */
/*   Licensed Materials - Property of IBM.                            */
/*   IBM XL C for OpenCL, V0.3 (technology preview)                   */
/*   Copyright IBM Corp. 1991, 2005.                                  */
/*   All Rights Reserved.                                             */
/*   US Government Users Restricted Rights -                          */
/*   Use, duplication or disclosure restricted by                     */
/*   GSA ADP Schedule Contract with IBM Corp.                         */
/*                                                                    */
/**********************************************************************/

/* Macro definition for vector intrinsics  */

#ifndef _INTRINSICS_MACRO_H
#define _INTRINSICS_MACRO_H

#define _all_cmpeq(_a,_b) (spu_extract(spu_gather(spu_cmpeq((vector unsigned int)(_a),(vector unsigned int)(_b))),0) == 15)

#define vfgt_istrue(a, b) (spu_extract(spu_gather(spu_cmpgt(a,b)),0) == 15)
#define vfeqv_istrue(a,b) (spu_extract(spu_gather(spu_cmpeq(a, b)),0) == 15)
#define vdeqv_istrue(a,b) (spu_extract(spu_gather(spu_cmpeq((vector signed int)a, (vector signed int)b)),0) == 15)
#define veqv32_istrue(a,b) (spu_extract(spu_gather(spu_cmpeq(a, b)),0) == 15)
#define veqv32u_istrue(a,b) (spu_extract(spu_gather(spu_cmpeq(a, b)),0) == 15)
#define veqv16_istrue(a,b) (spu_extract(spu_gather(spu_cmpeq(a, b)),0) == 255)
#define veqv16u_istrue(a,b) (spu_extract(spu_gather(spu_cmpeq(a, b)),0) == 255)
#define veqv8u_istrue(a,b) (spu_extract(spu_gather(spu_cmpeq((vector signed int)a, (vector signed int)b)),0) == 15)
#define veqv8_istrue(a,b) (spu_extract(spu_gather(spu_cmpeq((vector signed int)a, (vector signed int)b)),0) == 15)
#define veqv64_istrue(a,b) (spu_extract(spu_gather(spu_cmpeq((vector signed int)a, (vector signed int) b)),0) == 15)
#define veqv64u_istrue(a,b) (spu_extract(spu_gather(spu_cmpeq((vector signed int)a, (vector signed int)b)),0) == 15)

#define printvint(a) (printf("(%d,%d,%d,%d)\n",(a).d[0],(a).d[1],(a).d[2],(a).d[3]))
#endif
