/**********************************************************************/
/*                                                                    */
/*   Licensed Materials - Property of IBM.                            */
/*   IBM XL C for OpenCL, V0.3 (technology preview)                   */
/*   Copyright IBM Corp. 1991, 2005.                                  */
/*   All Rights Reserved.                                             */
/*   US Government Users Restricted Rights -                          */
/*   Use, duplication or disclosure restricted by                     */
/*   GSA ADP Schedule Contract with IBM Corp.                         */
/*                                                                    */
/**********************************************************************/

/********************************************************************
* SPU type generic intrinsics
*********************************************************************/
#ifndef _INTRINSICS_H
#define _INTRINSICS_H 1

#if (defined(__SPU__) || defined(__CELL_PU__))

#ifndef __cplusplus /* ! __cplusplus */
/* #pragma tg_funcdef is a c only pragma */

/* spu_absd */
#pragma tg_funcdef(spu_absd, __si_absdb, vector unsigned char, vector unsigned char, vector unsigned char)
#undef  spu_absd
#define spu_absd(__a,__b) __tg_builtin("spu_absd",__a,__b)

/* spu_add */
#pragma tg_funcdef(spu_add, __si_a,     vector signed int, vector signed int, vector signed int)
#pragma tg_funcdef(spu_add, __vi_add4s, vector signed int, vector signed int, signed int)
#pragma tg_funcdef(spu_add, __si_a,     vector unsigned int, vector unsigned int, vector unsigned int)
#pragma tg_funcdef(spu_add, __vi_add4u, vector unsigned int, vector unsigned int, signed int)
#pragma tg_funcdef(spu_add, __si_ah,    vector signed short, vector signed short, vector signed short)
#pragma tg_funcdef(spu_add, __vi_add2s, vector signed short, vector signed short, signed int)
#pragma tg_funcdef(spu_add, __si_ah,    vector unsigned short, vector unsigned short, vector unsigned short)
#pragma tg_funcdef(spu_add, __vi_add2u, vector unsigned short, vector unsigned short, signed int)
#pragma tg_funcdef(spu_add, __si_fa,    vector float, vector float, vector float)
#pragma tg_funcdef(spu_add, __si_dfa,   vector double, vector double, vector double)
#undef  spu_add
#define spu_add(__a,__b) __tg_builtin("spu_add",__a,__b)

/* spu_addx */
#pragma tg_funcdef(spu_addx, __si_addx, vector signed int, vector signed int, vector signed int, vector signed int)
#pragma tg_funcdef(spu_addx, __si_addx, vector unsigned int, vector unsigned int, vector unsigned int, vector unsigned int)
#undef  spu_addx
#define spu_addx(__a,__b,__c) __tg_builtin("spu_addx",__a,__b,__c)

/* spu_genc */
#pragma tg_funcdef(spu_genc, __si_cg, vector signed int, vector signed int, vector signed int)
#pragma tg_funcdef(spu_genc, __si_cg, vector unsigned int, vector unsigned int, vector unsigned int)
#undef  spu_genc
#define spu_genc(__a,__b) __tg_builtin("spu_genc",__a,__b)

/* spu_gencx */
#pragma tg_funcdef(spu_gencx, __si_cgx, vector signed int, vector signed int, vector signed int, vector signed int)
#pragma tg_funcdef(spu_gencx, __si_cgx, vector unsigned int, vector unsigned int, vector unsigned int, vector unsigned int)
#undef  spu_gencx
#define spu_gencx(__a,__b,__c) __tg_builtin("spu_gencx",__a,__b,__c)

/* spu_and */
#pragma tg_funcdef(spu_and, __si_and,   vector signed int, vector signed int, vector signed int)
#pragma tg_funcdef(spu_and, __si_and,   vector unsigned int, vector unsigned int, vector unsigned int)
#pragma tg_funcdef(spu_and, __si_and,   vector signed short, vector signed short, vector signed short)
#pragma tg_funcdef(spu_and, __si_and,   vector unsigned short, vector unsigned short, vector unsigned short)
#pragma tg_funcdef(spu_and, __si_and,   vector float, vector float, vector float)
#pragma tg_funcdef(spu_and, __si_and,   vector double, vector double, vector double)
#pragma tg_funcdef(spu_and, __si_and,   vector signed char, vector signed char, vector signed char)
#pragma tg_funcdef(spu_and, __si_and,   vector unsigned char, vector unsigned char, vector unsigned char)
#pragma tg_funcdef(spu_and, __si_and,   vector signed long long, vector signed long long, vector signed long long)
#pragma tg_funcdef(spu_and, __si_and,   vector unsigned long long, vector unsigned long long, vector unsigned long long)
#pragma tg_funcdef(spu_and, __vi_and4s, vector signed int, vector signed int, signed int)
#pragma tg_funcdef(spu_and, __vi_and4u, vector unsigned int, vector unsigned int, signed int)
#pragma tg_funcdef(spu_and, __vi_and2s, vector signed short, vector signed short, signed int)
#pragma tg_funcdef(spu_and, __vi_and2u, vector unsigned short, vector unsigned short, signed int)
#pragma tg_funcdef(spu_and, __vi_and1s, vector signed char, vector signed char, signed int)
#pragma tg_funcdef(spu_and, __vi_and1u, vector unsigned char, vector unsigned char, signed int)
#undef  spu_and
#define spu_and(__a,__b) __tg_builtin("spu_and",__a,__b)

/* spu_andc */
#pragma tg_funcdef(spu_andc, __si_andc, vector signed int, vector signed int, vector signed int)
#pragma tg_funcdef(spu_andc, __si_andc, vector unsigned int, vector unsigned int, vector unsigned int)
#pragma tg_funcdef(spu_andc, __si_andc, vector signed short, vector signed short, vector signed short)
#pragma tg_funcdef(spu_andc, __si_andc, vector unsigned short, vector unsigned short, vector unsigned short)
#pragma tg_funcdef(spu_andc, __si_andc, vector float, vector float, vector float)
#pragma tg_funcdef(spu_andc, __si_andc, vector double, vector double, vector double)
#pragma tg_funcdef(spu_andc, __si_andc, vector signed char, vector signed char, vector signed char)
#pragma tg_funcdef(spu_andc, __si_andc, vector unsigned char, vector unsigned char, vector unsigned char)
#pragma tg_funcdef(spu_andc, __si_andc, vector signed long long, vector signed long long, vector signed long long)
#pragma tg_funcdef(spu_andc, __si_andc, vector unsigned long long, vector unsigned long long, vector unsigned long long)
#undef  spu_andc
#define spu_andc(__a,__b) __tg_builtin("spu_andc",__a,__b)

/* spu_avg */
#pragma tg_funcdef(spu_avg, __si_avgb, vector unsigned char, vector unsigned char, vector unsigned char)
#undef  spu_avg
#define spu_avg(__a,__b) __tg_builtin("spu_avg",__a,__b)

/* spu_cmpabseq */
#pragma tg_funcdef(spu_cmpabseq, __si_fcmeq, vector unsigned int, vector float, vector float)
#pragma tg_funcdef(spu_cmpabseq, __si_dfcmeq, vector unsigned long long, vector double, vector double)
#undef  spu_cmpabseq
#define spu_cmpabseq(__a,__b) __tg_builtin("spu_cmpabseq",__a,__b)

/* spu_cmpabsgt */
#pragma tg_funcdef(spu_cmpabsgt, __si_fcmgt, vector unsigned int, vector float, vector float)
#pragma tg_funcdef(spu_cmpabsgt, __si_dfcmgt, vector unsigned long long, vector double, vector double)
#undef  spu_cmpabsgt
#define spu_cmpabsgt(__a,__b) __tg_builtin("spu_cmpabsgt",__a,__b)

/* spu_cmpeq */
#pragma tg_funcdef(spu_cmpeq, __si_ceq,     vector unsigned int, vector signed int, vector signed int)
#pragma tg_funcdef(spu_cmpeq, __vi_cmpeq4s, vector unsigned int, vector signed int, signed int)
#pragma tg_funcdef(spu_cmpeq, __si_ceq,     vector unsigned int, vector unsigned int, vector unsigned int)
#pragma tg_funcdef(spu_cmpeq, __vi_cmpeq4u, vector unsigned int, vector unsigned int, signed int)
#pragma tg_funcdef(spu_cmpeq, __si_ceqh,    vector unsigned short, vector signed short, vector signed short)
#pragma tg_funcdef(spu_cmpeq, __vi_cmpeq2s, vector unsigned short, vector signed short, signed int)
#pragma tg_funcdef(spu_cmpeq, __si_ceqh,    vector unsigned short, vector unsigned short, vector unsigned short)
#pragma tg_funcdef(spu_cmpeq, __vi_cmpeq2u, vector unsigned short, vector unsigned short, signed int)
#pragma tg_funcdef(spu_cmpeq, __si_fceq,    vector unsigned int, vector float, vector float)
#pragma tg_funcdef(spu_cmpeq, __si_ceqb,    vector unsigned char, vector signed char, vector signed char)
#pragma tg_funcdef(spu_cmpeq, __vi_cmpeq1s, vector unsigned char, vector signed char, signed int)
#pragma tg_funcdef(spu_cmpeq, __si_ceqb,    vector unsigned char, vector unsigned char, vector unsigned char)
#pragma tg_funcdef(spu_cmpeq, __vi_cmpeq1u, vector unsigned char, vector unsigned char, signed int)
#pragma tg_funcdef(spu_cmpeq, __si_dfceq, vector unsigned long long, vector double, vector double)
#undef  spu_cmpeq
#define spu_cmpeq(__a,__b) __tg_builtin("spu_cmpeq",__a,__b)

/* spu_cmpgt */
#pragma tg_funcdef(spu_cmpgt, __si_cgt,     vector unsigned int, vector signed int, vector signed int)
#pragma tg_funcdef(spu_cmpgt, __vi_cmpgt4s, vector unsigned int, vector signed int, signed int)
#pragma tg_funcdef(spu_cmpgt, __si_clgt,    vector unsigned int, vector unsigned int, vector unsigned int)
#pragma tg_funcdef(spu_cmpgt, __vi_cmpgt4u, vector unsigned int, vector unsigned int, signed int)
#pragma tg_funcdef(spu_cmpgt, __si_cgth,    vector unsigned short, vector signed short, vector signed short)
#pragma tg_funcdef(spu_cmpgt, __vi_cmpgt2s, vector unsigned short, vector signed short, signed int)
#pragma tg_funcdef(spu_cmpgt, __si_clgth,   vector unsigned short, vector unsigned short, vector unsigned short)
#pragma tg_funcdef(spu_cmpgt, __vi_cmpgt2u, vector unsigned short, vector unsigned short, signed int)
#pragma tg_funcdef(spu_cmpgt, __si_fcgt,    vector unsigned int, vector float, vector float)
#pragma tg_funcdef(spu_cmpgt, __si_cgtb,    vector unsigned char, vector signed char, vector signed char)
#pragma tg_funcdef(spu_cmpgt, __vi_cmpgt1s, vector unsigned char, vector signed char, signed int)
#pragma tg_funcdef(spu_cmpgt, __si_clgtb,   vector unsigned char, vector unsigned char, vector unsigned char)
#pragma tg_funcdef(spu_cmpgt, __vi_cmpgt1u, vector unsigned char, vector unsigned char, signed int)
#pragma tg_funcdef(spu_cmpgt, __si_dfcgt, vector unsigned long long, vector double, vector double)
#undef  spu_cmpgt
#define spu_cmpgt(__a,__b) __tg_builtin("spu_cmpgt",__a,__b)

/* spu_cntb */
#pragma tg_funcdef(spu_cntb, __si_cntb, vector unsigned char, vector signed char)
#pragma tg_funcdef(spu_cntb, __si_cntb, vector unsigned char, vector unsigned char)
#undef  spu_cntb
#define spu_cntb(__a) __tg_builtin("spu_cntb",__a)

/* spu_cntzw */
#pragma tg_funcdef(spu_cntzw, __si_clz, vector unsigned int, vector signed int)
#pragma tg_funcdef(spu_cntzw, __si_clz, vector unsigned int, vector unsigned int)
#pragma tg_funcdef(spu_cntzw, __si_clz, vector unsigned int, vector float)
#undef  spu_cntzw
#define spu_cntzw(__a) __tg_builtin("spu_cntzw",__a)
#undef  spu_cntlz
#define spu_cntlz(__a) __tg_builtin("spu_cntzw",__a)

/* spu_convtf */
#pragma tg_funcdef(spu_convtf, __si_cuflt, vector float, vector unsigned int, signed int)
#pragma tg_funcdef(spu_convtf, __si_csflt, vector float, vector signed int, signed int)
#undef  spu_convtf
#define spu_convtf(__a,__b) __tg_builtin("spu_convtf",__a,__b)

/* spu_convts */
#pragma tg_funcdef(spu_convts, __si_cflts, vector signed int, vector float, signed int)
#undef  spu_convts
#define spu_convts(__a,__b) __tg_builtin("spu_convts",__a,__b)

/* spu_convtu */
#pragma tg_funcdef(spu_convtu, __si_cfltu, vector unsigned int, vector float, signed int)
#undef  spu_convtu
#define spu_convtu(__a,__b) __tg_builtin("spu_convtu",__a,__b)

/* spu_eqv */
#pragma tg_funcdef(spu_eqv, __si_eqv, vector signed int, vector signed int, vector signed int)
#pragma tg_funcdef(spu_eqv, __si_eqv, vector unsigned int, vector unsigned int, vector unsigned int)
#pragma tg_funcdef(spu_eqv, __si_eqv, vector signed short, vector signed short, vector signed short)
#pragma tg_funcdef(spu_eqv, __si_eqv, vector unsigned short, vector unsigned short, vector unsigned short)
#pragma tg_funcdef(spu_eqv, __si_eqv, vector float, vector float, vector float)
#pragma tg_funcdef(spu_eqv, __si_eqv, vector double, vector double, vector double)
#pragma tg_funcdef(spu_eqv, __si_eqv, vector signed char, vector signed char, vector signed char)
#pragma tg_funcdef(spu_eqv, __si_eqv, vector unsigned char, vector unsigned char, vector unsigned char)
#pragma tg_funcdef(spu_eqv, __si_eqv, vector signed long long, vector signed long long, vector signed long long)
#pragma tg_funcdef(spu_eqv, __si_eqv, vector unsigned long long, vector unsigned long long, vector unsigned long long)
#undef  spu_eqv
#define spu_eqv(__a,__b) __tg_builtin("spu_eqv",__a,__b)

/* spu_extend */
#pragma tg_funcdef(spu_extend, __si_xsbh, vector signed short, vector signed char)
#pragma tg_funcdef(spu_extend, __si_xshw, vector signed int, vector signed short)
#pragma tg_funcdef(spu_extend, __si_xswd, vector signed long long, vector signed int)
#pragma tg_funcdef(spu_extend, __si_fesd, vector double, vector float)
#undef  spu_extend
#define spu_extend(__a) __tg_builtin("spu_extend",__a)

/* spu_extract */
#pragma tg_funcdef(spu_extract, __vi_extract1s, signed char, vector signed char, signed int)
#pragma tg_funcdef(spu_extract, __vi_extract1u, unsigned char, vector unsigned char, signed int)
#pragma tg_funcdef(spu_extract, __vi_extract2s, signed short, vector signed short, signed int)
#pragma tg_funcdef(spu_extract, __vi_extract2u, unsigned short, vector unsigned short, signed int)
#pragma tg_funcdef(spu_extract, __vi_extract4s, signed int, vector signed int, signed int)
#pragma tg_funcdef(spu_extract, __vi_extract4u, unsigned int, vector unsigned int, signed int)
#pragma tg_funcdef(spu_extract, __vi_extract8s, signed long long, vector signed long long, signed int)
#pragma tg_funcdef(spu_extract, __vi_extract8u, unsigned long long, vector unsigned long long, signed int)
#pragma tg_funcdef(spu_extract, __vi_extract4f, float, vector float, signed int)
#pragma tg_funcdef(spu_extract, __vi_extract8d, double, vector double, signed int)
#undef  spu_extract
#define spu_extract(__a,__b) __tg_builtin("spu_extract",__a,__b)

/* spu_fi */
#pragma tg_funcdef(spu_fi, __si_fi, vector float, vector float, vector float)
#undef  spu_fi
#define spu_fi(__a,__b) __tg_builtin("spu_fi",__a,__b)

/* spu_gather */
#pragma tg_funcdef(spu_gather, __si_gbb, vector unsigned int, vector signed char)
#pragma tg_funcdef(spu_gather, __si_gbb, vector unsigned int, vector unsigned char)
#pragma tg_funcdef(spu_gather, __si_gbh, vector unsigned int, vector signed short)
#pragma tg_funcdef(spu_gather, __si_gbh, vector unsigned int, vector unsigned short)
#pragma tg_funcdef(spu_gather, __si_gb,  vector unsigned int, vector signed int)
#pragma tg_funcdef(spu_gather, __si_gb,  vector unsigned int, vector unsigned int)
#pragma tg_funcdef(spu_gather, __si_gb,  vector unsigned int, vector float)
#undef  spu_gather
#define spu_gather(__a) __tg_builtin("spu_gather",__a)

/* spu_hcmpeq */
#pragma tg_funcdef(spu_hcmpeq, __vi_heq, void, signed int, signed int)
#undef  spu_hcmpeq
#define spu_hcmpeq(__a,__b) __tg_builtin("spu_hcmpeq",__a,__b)

/* spu_hcmpgt */
#pragma tg_funcdef(spu_hcmpgt, __vi_hgt,  void, signed int, signed int)
#pragma tg_funcdef(spu_hcmpgt, __vi_hlgt, void, unsigned int, unsigned int)
#pragma tg_funcdef(spu_hcmpgt, __vi_hlgt, void, unsigned int, signed int)
#undef  spu_hcmpgt
#define spu_hcmpgt(__a,__b) __tg_builtin("spu_hcmpgt",__a,__b)

/* spu_insert */
#pragma tg_funcdef(spu_insert, __vi_insert1s, vector signed char,       signed char,      vector signed char, signed int)
#pragma tg_funcdef(spu_insert, __vi_insert1s, vector signed char,       signed int,       vector signed char, signed int)
#pragma tg_funcdef(spu_insert, __vi_insert1u, vector unsigned char,     unsigned char,    vector unsigned char, signed int)
#pragma tg_funcdef(spu_insert, __vi_insert1u, vector unsigned char,     signed int,       vector unsigned char, signed int)
#pragma tg_funcdef(spu_insert, __vi_insert2s, vector signed short,      signed short,     vector signed short, signed int)
#pragma tg_funcdef(spu_insert, __vi_insert2s, vector signed short,      signed int,       vector signed short, signed int)
#pragma tg_funcdef(spu_insert, __vi_insert2u, vector unsigned short,    unsigned short,   vector unsigned short, signed int)
#pragma tg_funcdef(spu_insert, __vi_insert2u, vector unsigned short,    signed int,       vector unsigned short, signed int)
#pragma tg_funcdef(spu_insert, __vi_insert4s, vector signed int,        signed int,       vector signed int, signed int)
#pragma tg_funcdef(spu_insert, __vi_insert4u, vector unsigned int,      unsigned int,     vector unsigned int, signed int)
#pragma tg_funcdef(spu_insert, __vi_insert4u, vector unsigned int,      signed int,       vector unsigned int, signed int)
#pragma tg_funcdef(spu_insert, __vi_insert8s, vector signed long long,  signed long long, vector signed long long, signed int)
#pragma tg_funcdef(spu_insert, __vi_insert8s, vector signed long long,  signed int,       vector signed long long, signed int)
#pragma tg_funcdef(spu_insert, __vi_insert8u, vector unsigned long long,unsigned long long,vector unsigned long long, signed int)
#pragma tg_funcdef(spu_insert, __vi_insert8u, vector unsigned long long,signed int, vector unsigned long long, signed int)
#pragma tg_funcdef(spu_insert, __vi_insert4f, vector float,  float,  vector float,  signed int)
#pragma tg_funcdef(spu_insert, __vi_insert8f, vector float,  double, vector float,  signed int)
#pragma tg_funcdef(spu_insert, __vi_insert8d, vector double, double, vector double, signed int)
#undef  spu_insert
#define spu_insert(__a,__b,__c) __tg_builtin("spu_insert",__a,__b,__c)

/* spu_madd */
#pragma tg_funcdef(spu_madd, __si_mpya, vector signed int, vector signed short, vector signed short, vector signed int)
#pragma tg_funcdef(spu_madd, __si_fma,  vector float, vector float, vector float, vector float)
#pragma tg_funcdef(spu_madd, __si_dfma, vector double, vector double, vector double, vector double)
#undef  spu_madd
#define spu_madd(__a,__b,__c) __tg_builtin("spu_madd",__a,__b,__c)

/* spu_maskb */
#pragma tg_funcdef(spu_maskb, __vi_fsmb, vector unsigned char, signed int)
#undef  spu_maskb
#define spu_maskb(__a) __tg_builtin("spu_maskb",__a)

/* spu_maskh */
#pragma tg_funcdef(spu_maskh, __vi_fsmh, vector unsigned short, signed int)
#undef  spu_maskh
#define spu_maskh(__a) __tg_builtin("spu_maskh",__a)

/* spu_maskw */
#pragma tg_funcdef(spu_maskw, __vi_fsm, vector unsigned int, signed int)
#undef  spu_maskw
#define spu_maskw(__a) __tg_builtin("spu_maskw",__a)

/* spu_mhhadd */
#pragma tg_funcdef(spu_mhhadd, __si_mpyhha,  vector signed int, vector signed short, vector signed short, vector signed int)
#pragma tg_funcdef(spu_mhhadd, __si_mpyhhau, vector unsigned int, vector unsigned short, vector unsigned short, vector unsigned int)
#undef  spu_mhhadd
#define spu_mhhadd(__a,__b,__c) __tg_builtin("spu_mhhadd",__a,__b,__c)

/* spu_msub */
#pragma tg_funcdef(spu_msub, __si_fms,  vector float, vector float, vector float, vector float)
#pragma tg_funcdef(spu_msub, __si_dfms, vector double, vector double, vector double, vector double)
#undef  spu_msub
#define spu_msub(__a,__b,__c) __tg_builtin("spu_msub",__a,__b,__c)

/* spu_mtfpscr */
#pragma tg_funcdef(spu_mtfpscr, __si_fscrwr, void, vector unsigned int)
#undef  spu_mtfpscr
#define spu_mtfpscr(__a) __tg_builtin("spu_mtfpscr",__a)

/* spu_mtspr */
#undef  spu_mtspr
#define spu_mtspr(__a,__b) __vi_mtspr(__a,__b)

/* spu_mul */
#pragma tg_funcdef(spu_mul, __si_fm,  vector float, vector float, vector float)
#pragma tg_funcdef(spu_mul, __si_dfm, vector double, vector double, vector double)
#undef  spu_mul
#define spu_mul(__a,__b) __tg_builtin("spu_mul",__a,__b)

/* spu_mulh */
#pragma tg_funcdef(spu_mulh, __si_mpyh, vector signed int, vector signed short, vector signed short)
#undef  spu_mulh
#define spu_mulh(__a,__b) __tg_builtin("spu_mulh",__a,__b)

/* spu_mule */
#pragma tg_funcdef(spu_mule, __si_mpyhh,  vector signed int, vector signed short, vector signed short)
#pragma tg_funcdef(spu_mule, __si_mpyhhu, vector unsigned int, vector unsigned short, vector unsigned short)
#undef  spu_mule
#define spu_mule(__a,__b) __tg_builtin("spu_mule",__a,__b)

/* spu_mulo */
#pragma tg_funcdef(spu_mulo, __si_mpy,    vector signed int, vector signed short, vector signed short)
#pragma tg_funcdef(spu_mulo, __vi_mulo2s, vector signed int, vector signed short, signed int)
#pragma tg_funcdef(spu_mulo, __si_mpyu,   vector unsigned int, vector unsigned short, vector unsigned short)
#pragma tg_funcdef(spu_mulo, __vi_mulo2u, vector unsigned int, vector unsigned short, signed int)
#undef  spu_mulo
#define spu_mulo(__a,__b) __tg_builtin("spu_mulo",__a,__b)

/* spu_mulsr */
#pragma tg_funcdef(spu_mulsr, __si_mpys, vector signed int, vector signed short, vector signed short)
#undef  spu_mulsr
#define spu_mulsr(__a,__b) __tg_builtin("spu_mulsr",__a,__b)

/* spu_nand */
#pragma tg_funcdef(spu_nand, __si_nand, vector signed int, vector signed int, vector signed int)
#pragma tg_funcdef(spu_nand, __si_nand, vector unsigned int, vector unsigned int, vector unsigned int)
#pragma tg_funcdef(spu_nand, __si_nand, vector signed short, vector signed short, vector signed short)
#pragma tg_funcdef(spu_nand, __si_nand, vector unsigned short, vector unsigned short, vector unsigned short)
#pragma tg_funcdef(spu_nand, __si_nand, vector float, vector float, vector float)
#pragma tg_funcdef(spu_nand, __si_nand, vector double, vector double, vector double)
#pragma tg_funcdef(spu_nand, __si_nand, vector signed char, vector signed char, vector signed char)
#pragma tg_funcdef(spu_nand, __si_nand, vector unsigned char, vector unsigned char, vector unsigned char)
#pragma tg_funcdef(spu_nand, __si_nand, vector signed long long, vector signed long long, vector signed long long)
#pragma tg_funcdef(spu_nand, __si_nand, vector unsigned long long, vector unsigned long long, vector unsigned long long)
#undef  spu_nand
#define spu_nand(__a,__b) __tg_builtin("spu_nand",__a,__b)

/* spu_nmadd */
#pragma tg_funcdef(spu_nmadd, __si_dfnma, vector double, vector double, vector double, vector double)
#undef  spu_nmadd
#define spu_nmadd(__a,__b,__c) __tg_builtin("spu_nmadd",__a,__b,__c)

/* spu_nmsub */
#pragma tg_funcdef(spu_nmsub, __si_fnms,  vector float, vector float, vector float, vector float)
#pragma tg_funcdef(spu_nmsub, __si_dfnms, vector double, vector double, vector double, vector double)
#undef  spu_nmsub
#define spu_nmsub(__a,__b,__c) __tg_builtin("spu_nmsub",__a,__b,__c)

/* spu_nor */
#pragma tg_funcdef(spu_nor, __si_nor, vector signed int, vector signed int, vector signed int)
#pragma tg_funcdef(spu_nor, __si_nor, vector unsigned int, vector unsigned int, vector unsigned int)
#pragma tg_funcdef(spu_nor, __si_nor, vector signed short, vector signed short, vector signed short)
#pragma tg_funcdef(spu_nor, __si_nor, vector unsigned short, vector unsigned short, vector unsigned short)
#pragma tg_funcdef(spu_nor, __si_nor, vector float, vector float, vector float)
#pragma tg_funcdef(spu_nor, __si_nor, vector double, vector double, vector double)
#pragma tg_funcdef(spu_nor, __si_nor, vector signed char, vector signed char, vector signed char)
#pragma tg_funcdef(spu_nor, __si_nor, vector unsigned char, vector unsigned char, vector unsigned char)
#pragma tg_funcdef(spu_nor, __si_nor, vector signed long long, vector signed long long, vector signed long long)
#pragma tg_funcdef(spu_nor, __si_nor, vector unsigned long long, vector unsigned long long, vector unsigned long long)
#undef  spu_nor
#define spu_nor(__a,__b) __tg_builtin("spu_nor",__a,__b)

/* spu_or */
#pragma tg_funcdef(spu_or, __si_or,   vector signed int, vector signed int, vector signed int)
#pragma tg_funcdef(spu_or, __si_or,   vector unsigned int, vector unsigned int, vector unsigned int)
#pragma tg_funcdef(spu_or, __si_or,   vector signed short, vector signed short, vector signed short)
#pragma tg_funcdef(spu_or, __si_or,   vector unsigned short, vector unsigned short, vector unsigned short)
#pragma tg_funcdef(spu_or, __si_or,   vector float, vector float, vector float)
#pragma tg_funcdef(spu_or, __si_or,   vector double, vector double, vector double)
#pragma tg_funcdef(spu_or, __si_or,   vector signed char, vector signed char, vector signed char)
#pragma tg_funcdef(spu_or, __si_or,   vector unsigned char, vector unsigned char, vector unsigned char)
#pragma tg_funcdef(spu_or, __si_or,   vector signed long long, vector signed long long, vector signed long long)
#pragma tg_funcdef(spu_or, __si_or,   vector unsigned long long, vector unsigned long long, vector unsigned long long)
#pragma tg_funcdef(spu_or, __vi_or4s, vector signed int, vector signed int, signed int)
#pragma tg_funcdef(spu_or, __vi_or4u, vector unsigned int, vector unsigned int, signed int)
#pragma tg_funcdef(spu_or, __vi_or2s, vector signed short, vector signed short, signed int)
#pragma tg_funcdef(spu_or, __vi_or2u, vector unsigned short, vector unsigned short, signed int)
#pragma tg_funcdef(spu_or, __vi_or1s, vector signed char, vector signed char, signed int)
#pragma tg_funcdef(spu_or, __vi_or1u, vector unsigned char, vector unsigned char, signed int)
#undef  spu_or
#define spu_or(__a,__b) __tg_builtin("spu_or",__a,__b)

/* spu_orc */
#pragma tg_funcdef(spu_orc, __si_orc, vector signed int, vector signed int, vector signed int)
#pragma tg_funcdef(spu_orc, __si_orc, vector unsigned int, vector unsigned int, vector unsigned int)
#pragma tg_funcdef(spu_orc, __si_orc, vector signed short, vector signed short, vector signed short)
#pragma tg_funcdef(spu_orc, __si_orc, vector unsigned short, vector unsigned short, vector unsigned short)
#pragma tg_funcdef(spu_orc, __si_orc, vector float, vector float, vector float)
#pragma tg_funcdef(spu_orc, __si_orc, vector double, vector double, vector double)
#pragma tg_funcdef(spu_orc, __si_orc, vector signed char, vector signed char, vector signed char)
#pragma tg_funcdef(spu_orc, __si_orc, vector unsigned char, vector unsigned char, vector unsigned char)
#pragma tg_funcdef(spu_orc, __si_orc, vector signed long long, vector signed long long, vector signed long long)
#pragma tg_funcdef(spu_orc, __si_orc, vector unsigned long long, vector unsigned long long, vector unsigned long long)
#undef  spu_orc
#define spu_orc(__a,__b) __tg_builtin("spu_orc",__a,__b)

/* spu_promote */
#pragma tg_funcdef(spu_promote, __vi_promote1s, vector signed char, signed char, signed int)
#pragma tg_funcdef(spu_promote, __vi_promote1u, vector unsigned char, unsigned char, signed int)
#pragma tg_funcdef(spu_promote, __vi_promote2s, vector signed short, signed short, signed int)
#pragma tg_funcdef(spu_promote, __vi_promote2u, vector unsigned short, unsigned short, signed int)
#pragma tg_funcdef(spu_promote, __vi_promote4s, vector signed int, signed int, signed int)
#pragma tg_funcdef(spu_promote, __vi_promote4u, vector unsigned int, unsigned int, signed int)
#pragma tg_funcdef(spu_promote, __vi_promote8s, vector signed long long, signed long long, signed int)
#pragma tg_funcdef(spu_promote, __vi_promote8u, vector unsigned long long, unsigned long long, signed int)
#pragma tg_funcdef(spu_promote, __vi_promote4f, vector float, float, signed int)
#pragma tg_funcdef(spu_promote, __vi_promote8d, vector double, double, signed int)
#undef  spu_promote
#define spu_promote(__a,__b) __tg_builtin("spu_promote",__a,__b)

/* spu_readchqw */
#pragma tg_funcdef(spu_readchqw, __si_rdch, vector unsigned int, signed int)
#undef  spu_readchqw
#define spu_readchqw(__a) __tg_builtin("spu_readchqw",__a)

/* spu_readchcnt */
#pragma tg_funcdef(spu_readchcnt, __vi_rchcnt, unsigned int, signed int)
#undef  spu_readchcnt
#define spu_readchcnt(__a) __tg_builtin("spu_readchcnt",__a)

/* spu_rl */
#pragma tg_funcdef(spu_rl, __si_rot,   vector signed int, vector signed int, vector signed int)
#pragma tg_funcdef(spu_rl, __vi_rl4s,  vector signed int, vector signed int, signed int)
#pragma tg_funcdef(spu_rl, __si_rot,   vector unsigned int, vector unsigned int, vector signed int)
#pragma tg_funcdef(spu_rl, __vi_rl4u,  vector unsigned int, vector unsigned int, signed int)
#pragma tg_funcdef(spu_rl, __si_roth,  vector signed short, vector signed short, vector signed short)
#pragma tg_funcdef(spu_rl, __vi_rl2s,  vector signed short, vector signed short, signed int)
#pragma tg_funcdef(spu_rl, __si_roth,  vector unsigned short, vector unsigned short, vector signed short)
#pragma tg_funcdef(spu_rl, __vi_rl2u,  vector unsigned short, vector unsigned short, signed int)
#undef  spu_rl
#define spu_rl(__a,__b) __tg_builtin("spu_rl",__a,__b)

/* spu_rlmask */
#pragma tg_funcdef(spu_rlmask, __si_rotm,     vector signed int, vector signed int, vector signed int)
#pragma tg_funcdef(spu_rlmask, __vi_rlmask4s, vector signed int, vector signed int, signed int)
#pragma tg_funcdef(spu_rlmask, __si_rotm,     vector unsigned int, vector unsigned int, vector signed int)
#pragma tg_funcdef(spu_rlmask, __vi_rlmask4u, vector unsigned int, vector unsigned int, signed int)
#pragma tg_funcdef(spu_rlmask, __si_rothm,    vector signed short, vector signed short, vector signed short)
#pragma tg_funcdef(spu_rlmask, __vi_rlmask2s, vector signed short, vector signed short, signed int)
#pragma tg_funcdef(spu_rlmask, __si_rothm,    vector unsigned short, vector unsigned short, vector signed short)
#pragma tg_funcdef(spu_rlmask, __vi_rlmask2u, vector unsigned short, vector unsigned short, signed int)
#undef  spu_rlmask
#define spu_rlmask(__a,__b) __tg_builtin("spu_rlmask",__a,__b)

/* spu_rlmaskqw */
#pragma tg_funcdef(spu_rlmaskqw, __vi_rotqmbi, vector signed int, vector signed int, signed int)
#pragma tg_funcdef(spu_rlmaskqw, __vi_rotqmbi, vector unsigned int, vector unsigned int, signed int)
#pragma tg_funcdef(spu_rlmaskqw, __vi_rotqmbi, vector signed short, vector signed short, signed int)
#pragma tg_funcdef(spu_rlmaskqw, __vi_rotqmbi, vector unsigned short, vector unsigned short, signed int)
#pragma tg_funcdef(spu_rlmaskqw, __vi_rotqmbi, vector float, vector float, signed int)
#pragma tg_funcdef(spu_rlmaskqw, __vi_rotqmbi, vector double, vector double, signed int)
#pragma tg_funcdef(spu_rlmaskqw, __vi_rotqmbi, vector signed char, vector signed char, signed int)
#pragma tg_funcdef(spu_rlmaskqw, __vi_rotqmbi, vector unsigned char, vector unsigned char, signed int)
#pragma tg_funcdef(spu_rlmaskqw, __vi_rotqmbi, vector signed long long, vector signed long long, signed int)
#pragma tg_funcdef(spu_rlmaskqw, __vi_rotqmbi, vector unsigned long long, vector unsigned long long, signed int)
#undef  spu_rlmaskqw
#define spu_rlmaskqw(__a,__b) __tg_builtin("spu_rlmaskqw",__a,__b)

/* spu_rlmaskqwbyte */
#pragma tg_funcdef(spu_rlmaskqwbyte, __vi_rotqmby, vector signed int, vector signed int, signed int)
#pragma tg_funcdef(spu_rlmaskqwbyte, __vi_rotqmby, vector unsigned int, vector unsigned int, signed int)
#pragma tg_funcdef(spu_rlmaskqwbyte, __vi_rotqmby, vector signed short, vector signed short, signed int)
#pragma tg_funcdef(spu_rlmaskqwbyte, __vi_rotqmby, vector unsigned short, vector unsigned short, signed int)
#pragma tg_funcdef(spu_rlmaskqwbyte, __vi_rotqmby, vector float, vector float, signed int)
#pragma tg_funcdef(spu_rlmaskqwbyte, __vi_rotqmby, vector double, vector double, signed int)
#pragma tg_funcdef(spu_rlmaskqwbyte, __vi_rotqmby, vector signed char, vector signed char, signed int)
#pragma tg_funcdef(spu_rlmaskqwbyte, __vi_rotqmby, vector unsigned char, vector unsigned char, signed int)
#pragma tg_funcdef(spu_rlmaskqwbyte, __vi_rotqmby, vector signed long long, vector signed long long, signed int)
#pragma tg_funcdef(spu_rlmaskqwbyte, __vi_rotqmby, vector unsigned long long, vector unsigned long long, signed int)
#undef  spu_rlmaskqwbyte
#define spu_rlmaskqwbyte(__a,__b) __tg_builtin("spu_rlmaskqwbyte",__a,__b)

/* spu_rlmaskqwbytebc */
#pragma tg_funcdef(spu_rlmaskqwbytebc, __vi_rotqmbybi, vector signed int, vector signed int, signed int)
#pragma tg_funcdef(spu_rlmaskqwbytebc, __vi_rotqmbybi, vector unsigned int, vector unsigned int, signed int)
#pragma tg_funcdef(spu_rlmaskqwbytebc, __vi_rotqmbybi, vector signed short, vector signed short, signed int)
#pragma tg_funcdef(spu_rlmaskqwbytebc, __vi_rotqmbybi, vector unsigned short, vector unsigned short, signed int)
#pragma tg_funcdef(spu_rlmaskqwbytebc, __vi_rotqmbybi, vector float, vector float, signed int)
#pragma tg_funcdef(spu_rlmaskqwbytebc, __vi_rotqmbybi, vector double, vector double, signed int)
#pragma tg_funcdef(spu_rlmaskqwbytebc, __vi_rotqmbybi, vector signed char, vector signed char, signed int)
#pragma tg_funcdef(spu_rlmaskqwbytebc, __vi_rotqmbybi, vector unsigned char, vector unsigned char, signed int)
#pragma tg_funcdef(spu_rlmaskqwbytebc, __vi_rotqmbybi, vector signed long long, vector signed long long, signed int)
#pragma tg_funcdef(spu_rlmaskqwbytebc, __vi_rotqmbybi, vector unsigned long long, vector unsigned long long, signed int)
#undef  spu_rlmaskqwbytebc
#define spu_rlmaskqwbytebc(__a,__b) __tg_builtin("spu_rlmaskqwbytebc",__a,__b)

/* spu_rlmaska */
#pragma tg_funcdef(spu_rlmaska, __si_rotma,     vector signed int, vector signed int, vector signed int)
#pragma tg_funcdef(spu_rlmaska, __vi_rlmaska4s, vector signed int, vector signed int, signed int)
#pragma tg_funcdef(spu_rlmaska, __si_rotma,     vector unsigned int, vector unsigned int, vector signed int)
#pragma tg_funcdef(spu_rlmaska, __vi_rlmaska4u, vector unsigned int, vector unsigned int, signed int)
#pragma tg_funcdef(spu_rlmaska, __si_rotmah,    vector signed short, vector signed short, vector signed short)
#pragma tg_funcdef(spu_rlmaska, __vi_rlmaska2s, vector signed short, vector signed short, signed int)
#pragma tg_funcdef(spu_rlmaska, __si_rotmah,    vector unsigned short, vector unsigned short, vector signed short)
#pragma tg_funcdef(spu_rlmaska, __vi_rlmaska2u, vector unsigned short, vector unsigned short, signed int)
#undef  spu_rlmaska
#define spu_rlmaska(__a,__b) __tg_builtin("spu_rlmaska",__a,__b)

/* spu_rlqw */
#pragma tg_funcdef(spu_rlqw, __vi_rotqbi, vector signed int, vector signed int, signed int)
#pragma tg_funcdef(spu_rlqw, __vi_rotqbi, vector unsigned int, vector unsigned int, signed int)
#pragma tg_funcdef(spu_rlqw, __vi_rotqbi, vector signed short, vector signed short, signed int)
#pragma tg_funcdef(spu_rlqw, __vi_rotqbi, vector unsigned short, vector unsigned short, signed int)
#pragma tg_funcdef(spu_rlqw, __vi_rotqbi, vector float, vector float, signed int)
#pragma tg_funcdef(spu_rlqw, __vi_rotqbi, vector double, vector double, signed int)
#pragma tg_funcdef(spu_rlqw, __vi_rotqbi, vector signed char, vector signed char, signed int)
#pragma tg_funcdef(spu_rlqw, __vi_rotqbi, vector unsigned char, vector unsigned char, signed int)
#pragma tg_funcdef(spu_rlqw, __vi_rotqbi, vector signed long long, vector signed long long, signed int)
#pragma tg_funcdef(spu_rlqw, __vi_rotqbi, vector unsigned long long, vector unsigned long long, signed int)
#undef  spu_rlqw
#define spu_rlqw(__a,__b) __tg_builtin("spu_rlqw",__a,__b)

/* spu_rlqwbyte */
#pragma tg_funcdef(spu_rlqwbyte, __vi_rotqby, vector signed int, vector signed int, signed int)
#pragma tg_funcdef(spu_rlqwbyte, __vi_rotqby, vector unsigned int, vector unsigned int, signed int)
#pragma tg_funcdef(spu_rlqwbyte, __vi_rotqby, vector signed short, vector signed short, signed int)
#pragma tg_funcdef(spu_rlqwbyte, __vi_rotqby, vector unsigned short, vector unsigned short, signed int)
#pragma tg_funcdef(spu_rlqwbyte, __vi_rotqby, vector float, vector float, signed int)
#pragma tg_funcdef(spu_rlqwbyte, __vi_rotqby, vector double, vector double, signed int)
#pragma tg_funcdef(spu_rlqwbyte, __vi_rotqby, vector signed char, vector signed char, signed int)
#pragma tg_funcdef(spu_rlqwbyte, __vi_rotqby, vector unsigned char, vector unsigned char, signed int)
#pragma tg_funcdef(spu_rlqwbyte, __vi_rotqby, vector signed long long, vector signed long long, signed int)
#pragma tg_funcdef(spu_rlqwbyte, __vi_rotqby, vector unsigned long long, vector unsigned long long, signed int)
#undef  spu_rlqwbyte
#define spu_rlqwbyte(__a,__b) __tg_builtin("spu_rlqwbyte",__a,__b)

/* spu_rlqwbytebc */
#pragma tg_funcdef(spu_rlqwbytebc, __vi_rotqbybi, vector signed int, vector signed int, signed int)
#pragma tg_funcdef(spu_rlqwbytebc, __vi_rotqbybi, vector unsigned int, vector unsigned int, signed int)
#pragma tg_funcdef(spu_rlqwbytebc, __vi_rotqbybi, vector signed short, vector signed short, signed int)
#pragma tg_funcdef(spu_rlqwbytebc, __vi_rotqbybi, vector unsigned short, vector unsigned short, signed int)
#pragma tg_funcdef(spu_rlqwbytebc, __vi_rotqbybi, vector float, vector float, signed int)
#pragma tg_funcdef(spu_rlqwbytebc, __vi_rotqbybi, vector double, vector double, signed int)
#pragma tg_funcdef(spu_rlqwbytebc, __vi_rotqbybi, vector signed char, vector signed char, signed int)
#pragma tg_funcdef(spu_rlqwbytebc, __vi_rotqbybi, vector unsigned char, vector unsigned char, signed int)
#pragma tg_funcdef(spu_rlqwbytebc, __vi_rotqbybi, vector signed long long, vector signed long long, signed int)
#pragma tg_funcdef(spu_rlqwbytebc, __vi_rotqbybi, vector unsigned long long, vector unsigned long long, signed int)
#undef  spu_rlqwbytebc
#define spu_rlqwbytebc(__a,__b) __tg_builtin("spu_rlqwbytebc",__a,__b)

/* spu_roundtf */
#pragma tg_funcdef(spu_roundtf, __si_frds, vector float, vector double)
#undef  spu_roundtf
#define spu_roundtf(__a) __tg_builtin("spu_roundtf",__a)

/* spu_sel */
#pragma tg_funcdef(spu_sel, __si_selb, vector signed int, vector signed int, vector signed int, vector unsigned int)
#pragma tg_funcdef(spu_sel, __si_selb, vector unsigned int, vector unsigned int, vector unsigned int, vector unsigned int)
#pragma tg_funcdef(spu_sel, __si_selb, vector signed short, vector signed short, vector signed short, vector unsigned short)
#pragma tg_funcdef(spu_sel, __si_selb, vector signed short, vector signed short, vector signed short, vector unsigned char)
#pragma tg_funcdef(spu_sel, __si_selb, vector unsigned short, vector unsigned short, vector unsigned short, vector unsigned short)
#pragma tg_funcdef(spu_sel, __si_selb, vector float, vector float, vector float, vector unsigned int)
#pragma tg_funcdef(spu_sel, __si_selb, vector double, vector double, vector double, vector unsigned long long)
#pragma tg_funcdef(spu_sel, __si_selb, vector signed char, vector signed char, vector signed char, vector unsigned char)
#pragma tg_funcdef(spu_sel, __si_selb, vector unsigned char, vector unsigned char, vector unsigned char, vector unsigned char)
#pragma tg_funcdef(spu_sel, __si_selb, vector signed long long, vector signed long long, vector signed long long, vector unsigned long long)
#pragma tg_funcdef(spu_sel, __si_selb, vector unsigned long long, vector unsigned long long, vector unsigned long long, vector unsigned long long)
#pragma tg_funcdef(spu_sel, __si_selb, vector float, vector float, vector float, vector unsigned char)
#pragma tg_funcdef(spu_sel, __si_selb, vector signed int, vector signed int, vector signed int, vector unsigned char)
#undef  spu_sel
#define spu_sel(__a,__b,__c) __tg_builtin("spu_sel",__a,__b,__c)

/* spu_shuffle */
#pragma tg_funcdef(spu_shuffle, __si_shufb, vector signed int, vector signed int, vector signed int, vector unsigned char)
#pragma tg_funcdef(spu_shuffle, __si_shufb, vector unsigned int, vector unsigned int, vector unsigned int, vector unsigned char)
#pragma tg_funcdef(spu_shuffle, __si_shufb, vector signed short, vector signed short, vector signed short, vector unsigned char)
#pragma tg_funcdef(spu_shuffle, __si_shufb, vector unsigned short, vector unsigned short, vector unsigned short, vector unsigned char)
#pragma tg_funcdef(spu_shuffle, __si_shufb, vector float, vector float, vector float, vector unsigned char)
#pragma tg_funcdef(spu_shuffle, __si_shufb, vector double, vector double, vector double, vector unsigned char)
#pragma tg_funcdef(spu_shuffle, __si_shufb, vector signed char, vector signed char, vector signed char, vector unsigned char)
#pragma tg_funcdef(spu_shuffle, __si_shufb, vector unsigned char, vector unsigned char, vector unsigned char, vector unsigned char)
#pragma tg_funcdef(spu_shuffle, __si_shufb, vector signed long long, vector signed long long, vector signed long long, vector unsigned char)
#pragma tg_funcdef(spu_shuffle, __si_shufb, vector unsigned long long, vector unsigned long long, vector unsigned long long, vector unsigned char)
#undef  spu_shuffle
#define spu_shuffle(__a,__b,__c) __tg_builtin("spu_shuffle",__a,__b,__c)

/* spu_sl */
#pragma tg_funcdef(spu_sl, __si_shl,   vector signed int, vector signed int, vector unsigned int)
#pragma tg_funcdef(spu_sl, __vi_sl4s,  vector signed int, vector signed int, signed int)
#pragma tg_funcdef(spu_sl, __si_shl,   vector unsigned int, vector unsigned int, vector unsigned int)
#pragma tg_funcdef(spu_sl, __vi_sl4u,  vector unsigned int, vector unsigned int, signed int)
#pragma tg_funcdef(spu_sl, __si_shlh,  vector signed short, vector signed short, vector unsigned short)
#pragma tg_funcdef(spu_sl, __vi_sl2s,  vector signed short, vector signed short, signed int)
#pragma tg_funcdef(spu_sl, __si_shlh,  vector unsigned short, vector unsigned short, vector unsigned short)
#pragma tg_funcdef(spu_sl, __vi_sl2u,  vector unsigned short, vector unsigned short, signed int)
#undef  spu_sl
#define spu_sl(__a,__b) __tg_builtin("spu_sl",__a,__b)

/* spu_slqw */
#pragma tg_funcdef(spu_slqw, __vi_shlqbi, vector signed int, vector signed int, signed int)
#pragma tg_funcdef(spu_slqw, __vi_shlqbi, vector unsigned int, vector unsigned int, signed int)
#pragma tg_funcdef(spu_slqw, __vi_shlqbi, vector signed short, vector signed short, signed int)
#pragma tg_funcdef(spu_slqw, __vi_shlqbi, vector unsigned short, vector unsigned short, signed int)
#pragma tg_funcdef(spu_slqw, __vi_shlqbi, vector float, vector float, signed int)
#pragma tg_funcdef(spu_slqw, __vi_shlqbi, vector double, vector double, signed int)
#pragma tg_funcdef(spu_slqw, __vi_shlqbi, vector signed char, vector signed char, signed int)
#pragma tg_funcdef(spu_slqw, __vi_shlqbi, vector unsigned char, vector unsigned char, signed int)
#pragma tg_funcdef(spu_slqw, __vi_shlqbi, vector signed long long, vector signed long long, signed int)
#pragma tg_funcdef(spu_slqw, __vi_shlqbi, vector unsigned long long, vector unsigned long long, signed int)
#undef  spu_slqw
#define spu_slqw(__a,__b) __tg_builtin("spu_slqw",__a,__b)

/* spu_slqwbyte */
#pragma tg_funcdef(spu_slqwbyte, __vi_shlqby, vector signed int, vector signed int, signed int)
#pragma tg_funcdef(spu_slqwbyte, __vi_shlqby, vector unsigned int, vector unsigned int, signed int)
#pragma tg_funcdef(spu_slqwbyte, __vi_shlqby, vector signed short, vector signed short, signed int)
#pragma tg_funcdef(spu_slqwbyte, __vi_shlqby, vector unsigned short, vector unsigned short, signed int)
#pragma tg_funcdef(spu_slqwbyte, __vi_shlqby, vector float, vector float, signed int)
#pragma tg_funcdef(spu_slqwbyte, __vi_shlqby, vector double, vector double, signed int)
#pragma tg_funcdef(spu_slqwbyte, __vi_shlqby, vector signed char, vector signed char, signed int)
#pragma tg_funcdef(spu_slqwbyte, __vi_shlqby, vector unsigned char, vector unsigned char, signed int)
#pragma tg_funcdef(spu_slqwbyte, __vi_shlqby, vector signed long long, vector signed long long, signed int)
#pragma tg_funcdef(spu_slqwbyte, __vi_shlqby, vector unsigned long long, vector unsigned long long, signed int)
#undef  spu_slqwbyte
#define spu_slqwbyte(__a,__b) __tg_builtin("spu_slqwbyte",__a,__b)

/* spu_slqwbytebc */
#pragma tg_funcdef(spu_slqwbytebc, __vi_shlqbybi, vector signed int, vector signed int, signed int)
#pragma tg_funcdef(spu_slqwbytebc, __vi_shlqbybi, vector unsigned int, vector unsigned int, signed int)
#pragma tg_funcdef(spu_slqwbytebc, __vi_shlqbybi, vector signed short, vector signed short, signed int)
#pragma tg_funcdef(spu_slqwbytebc, __vi_shlqbybi, vector unsigned short, vector unsigned short, signed int)
#pragma tg_funcdef(spu_slqwbytebc, __vi_shlqbybi, vector float, vector float, signed int)
#pragma tg_funcdef(spu_slqwbytebc, __vi_shlqbybi, vector double, vector double, signed int)
#pragma tg_funcdef(spu_slqwbytebc, __vi_shlqbybi, vector signed char, vector signed char, signed int)
#pragma tg_funcdef(spu_slqwbytebc, __vi_shlqbybi, vector unsigned char, vector unsigned char, signed int)
#pragma tg_funcdef(spu_slqwbytebc, __vi_shlqbybi, vector signed long long, vector signed long long, signed int)
#pragma tg_funcdef(spu_slqwbytebc, __vi_shlqbybi, vector unsigned long long, vector unsigned long long, signed int)
#undef  spu_slqwbytebc
#define spu_slqwbytebc(__a,__b) __tg_builtin("spu_slqwbytebc",__a,__b)

/* spu_splats */
#pragma tg_funcdef(spu_splats, __vi_splats1s, vector signed char, signed char)
#pragma tg_funcdef(spu_splats, __vi_splats1u, vector unsigned char, unsigned char)
#pragma tg_funcdef(spu_splats, __vi_splats2s, vector signed short, signed short)
#pragma tg_funcdef(spu_splats, __vi_splats2u, vector unsigned short, unsigned short)
#pragma tg_funcdef(spu_splats, __vi_splats4s, vector signed int, signed int)
#pragma tg_funcdef(spu_splats, __vi_splats4u, vector unsigned int, unsigned int)
#pragma tg_funcdef(spu_splats, __vi_splats8s, vector signed long long, signed long long)
#pragma tg_funcdef(spu_splats, __vi_splats8u, vector unsigned long long, unsigned long long)
#pragma tg_funcdef(spu_splats, __vi_splats4f, vector float, float)
#pragma tg_funcdef(spu_splats, __vi_splats8d, vector double, double)
#undef  spu_splats
#define spu_splats(__a) __tg_builtin("spu_splats",__a)

/* spu_sub */
#pragma tg_funcdef(spu_sub, __si_sf,    vector signed int, vector signed int, vector signed int)
#pragma tg_funcdef(spu_sub, __vi_sub4s, vector signed int, vector signed int, signed int)
#pragma tg_funcdef(spu_sub, __si_sf,    vector unsigned int, vector unsigned int, vector unsigned int)
#pragma tg_funcdef(spu_sub, __vi_sub4u, vector unsigned int, vector unsigned int, signed int)
#pragma tg_funcdef(spu_sub, __si_sfh,   vector signed short, vector signed short, vector signed short)
#pragma tg_funcdef(spu_sub, __vi_sub2s, vector signed short, vector signed short, signed int)
#pragma tg_funcdef(spu_sub, __si_sfh,   vector unsigned short, vector unsigned short, vector unsigned short)
#pragma tg_funcdef(spu_sub, __vi_sub2u, vector unsigned short, vector unsigned short, signed int)
#pragma tg_funcdef(spu_sub, __vi_sub4f, vector float, vector float, vector float)
#pragma tg_funcdef(spu_sub, __vi_sub8d, vector double, vector double, vector double)
#undef  spu_sub
/* note: generic and specific intrinsics have arguments ordered differently */
#define spu_sub(__a,__b) __tg_builtin("spu_sub",__b,__a)

/* spu_subx */
#pragma tg_funcdef(spu_subx, __si_sfx, vector signed int, vector signed int, vector signed int, vector signed int)
#pragma tg_funcdef(spu_subx, __si_sfx, vector unsigned int, vector unsigned int, vector unsigned int, vector unsigned int)
#undef  spu_subx
/* note: generic and specific intrinsics have arguments ordered differently */
#define spu_subx(__a,__b,__c) __tg_builtin("spu_subx",__b,__a,__c)

/* spu_genb */
#pragma tg_funcdef(spu_genb, __si_bg, vector signed int, vector signed int, vector signed int)
#pragma tg_funcdef(spu_genb, __si_bg, vector unsigned int, vector unsigned int, vector unsigned int)
#undef  spu_genb
/* note: generic and specific intrinsics have arguments ordered differently */
#define spu_genb(__a,__b) __tg_builtin("spu_genb",__b,__a)

/* spu_genbx */
#pragma tg_funcdef(spu_genbx, __si_bgx, vector signed int, vector signed int, vector signed int, vector signed int)
#pragma tg_funcdef(spu_genbx, __si_bgx, vector unsigned int, vector unsigned int, vector unsigned int, vector unsigned int)
#undef  spu_genbx
/* note: generic and specific intrinsics have arguments ordered differently */
#define spu_genbx(__a,__b,__c) __tg_builtin("spu_genbx",__b,__a,__c)

/* spu_sumb */
#pragma tg_funcdef(spu_sumb, __si_sumb, vector unsigned short, vector unsigned char, vector unsigned char)
#undef  spu_sumb
#define spu_sumb(__a,__b) __tg_builtin("spu_sumb",__a,__b)

/* spu_testsv */
#pragma tg_funcdef(spu_testsv, __si_dftsv, vector unsigned long long, vector double, unsigned int)
#pragma tg_funcdef(spu_testsv, __si_dftsv, vector unsigned long long, vector double, signed int)
#undef  spu_testsv
#define spu_testsv(__a,__b) __tg_builtin("spu_testsv",__a,__b)

/* spu_writechqw */
#pragma tg_funcdef(spu_writechqw, __si_wrch, void, signed int, vector signed int)
#pragma tg_funcdef(spu_writechqw, __si_wrch, void, signed int, vector unsigned int)
#pragma tg_funcdef(spu_writechqw, __si_wrch, void, signed int, vector signed short)
#pragma tg_funcdef(spu_writechqw, __si_wrch, void, signed int, vector unsigned short)
#pragma tg_funcdef(spu_writechqw, __si_wrch, void, signed int, vector float)
#pragma tg_funcdef(spu_writechqw, __si_wrch, void, signed int, vector double)
#pragma tg_funcdef(spu_writechqw, __si_wrch, void, signed int, vector signed char)
#pragma tg_funcdef(spu_writechqw, __si_wrch, void, signed int, vector unsigned char)
#pragma tg_funcdef(spu_writechqw, __si_wrch, void, signed int, vector signed long long)
#pragma tg_funcdef(spu_writechqw, __si_wrch, void, signed int, vector unsigned long long)
#undef  spu_writechqw
#define spu_writechqw(__a,__b) __tg_builtin("spu_writechqw",__a,__b)

/* spu_xor */
#pragma tg_funcdef(spu_xor, __si_xor,   vector signed int, vector signed int, vector signed int)
#pragma tg_funcdef(spu_xor, __si_xor,   vector unsigned int, vector unsigned int, vector unsigned int)
#pragma tg_funcdef(spu_xor, __si_xor,   vector signed short, vector signed short, vector signed short)
#pragma tg_funcdef(spu_xor, __si_xor,   vector unsigned short, vector unsigned short, vector unsigned short)
#pragma tg_funcdef(spu_xor, __si_xor,   vector float, vector float, vector float)
#pragma tg_funcdef(spu_xor, __si_xor,   vector double, vector double, vector double)
#pragma tg_funcdef(spu_xor, __si_xor,   vector signed char, vector signed char, vector signed char)
#pragma tg_funcdef(spu_xor, __si_xor,   vector unsigned char, vector unsigned char, vector unsigned char)
#pragma tg_funcdef(spu_xor, __si_xor,   vector signed long long, vector signed long long, vector signed long long)
#pragma tg_funcdef(spu_xor, __si_xor,   vector unsigned long long, vector unsigned long long, vector unsigned long long)
#pragma tg_funcdef(spu_xor, __vi_xor4s, vector signed int, vector signed int, signed int)
#pragma tg_funcdef(spu_xor, __vi_xor4u, vector unsigned int, vector unsigned int, signed int)
#pragma tg_funcdef(spu_xor, __vi_xor2s, vector signed short, vector signed short, signed int)
#pragma tg_funcdef(spu_xor, __vi_xor2u, vector unsigned short, vector unsigned short, signed int)
#pragma tg_funcdef(spu_xor, __vi_xor1s, vector signed char, vector signed char, signed int)
#pragma tg_funcdef(spu_xor, __vi_xor1u, vector unsigned char, vector unsigned char, signed int)
#undef  spu_xor
#define spu_xor(__a,__b) __tg_builtin("spu_xor",__a,__b)

/* spu_orx */
#pragma tg_funcdef(spu_orx, __si_orx, vector signed int, vector signed int)
#pragma tg_funcdef(spu_orx, __si_orx, vector unsigned int, vector unsigned int)
#undef  spu_orx
#define spu_orx(__a) __tg_builtin("spu_orx",__a)

/* intrinsics declared by other intrinsics */

/* spu_re */
#pragma tg_funcdef(spu_re, __vi_re, vector float, vector float)
#undef  spu_re
#define spu_re(__a) __tg_builtin("spu_re",__a)

/* spu_rsqrte */
#pragma tg_funcdef(spu_rsqrte, __vi_rsqrte, vector float, vector float)
#undef  spu_rsqrte
#define spu_rsqrte(__a) __tg_builtin("spu_rsqrte",__a)

/* generic intrinsics with direct mapping to specific intrinsics */

/* spu_mfspr */
#undef  spu_mfspr
#define spu_mfspr(_a) __vi_mfspr(_a)

/* spu_readch */
#undef  spu_readch
#define spu_readch(_a) __vi_rdch(_a)

/* spu_writech */
#undef  spu_writech
#define spu_writech(_a,_b) __si_wrch((_a),__si_from_uint(_b))

/* spu_bisled */
#undef  spu_bisled
#define spu_bisled(__a)   __vi_bisled(__a)

/* spu_bisled_d */
#undef  spu_bisled_d
#define spu_bisled_d(__a) __vi_bisledd(__a)

/* spu_bisled_e */
#undef  spu_bisled_e
#define spu_bisled_e(__a) __vi_bislede(__a)

/* spu_dsync */
#undef  spu_dsync
#define spu_dsync __si_dsync

/* spu_mffpscr */
#undef  spu_mffpscr
#define spu_mffpscr (vector unsigned int)__si_fscrrd

/* spu_stop */
#undef  spu_stop
#define spu_stop(__a) __si_stop(__a)

/* spu_sync */
#undef  spu_sync
#define spu_sync __si_sync

/* spu_sync_c */
#undef  spu_sync_c
#define spu_sync_c __si_syncc

/* spu_mfcdma32 */
#undef  spu_mfcdma32
#define spu_mfcdma32 __spu_mfcdma32

/* spu_mfcdma64 */
#undef  spu_mfcdma64
#define spu_mfcdma64 __spu_mfcdma64

/* spu_mfcstat */
#undef  spu_mfcstat
#define spu_mfcstat __spu_mfcstat

/* spu_ienable */
#undef  spu_ienable
#define spu_ienable __spu_ienable

/* spu_idisable */
#undef  spu_idisable
#define spu_idisable __spu_idisable

#endif /* ! __cplusplus */

#endif /* defined(__SPU__) || defined(__CELL_PU__) */

#endif /* _INTRINSICS_H */
