/**********************************************************************/
/*                                                                    */
/*   Licensed Materials - Property of IBM.                            */
/*   IBM XL C for OpenCL, V0.3 (technology preview)                   */
/*   Copyright IBM Corp. 1991, 2005.                                  */
/*   All Rights Reserved.                                             */
/*   US Government Users Restricted Rights -                          */
/*   Use, duplication or disclosure restricted by                     */
/*   GSA ADP Schedule Contract with IBM Corp.                         */
/*                                                                    */
/**********************************************************************/

#ifndef __IBM_VACPP_internal__xlc_altivec_h
#define __IBM_VACPP_internal__xlc_altivec_h 1

/* vec_abs */
#pragma tg_funcdef(vec_abs,__vec_abs,vector signed char,  vector signed char)
#pragma tg_funcdef(vec_abs,__vec_abs,vector signed short, vector signed short)
#pragma tg_funcdef(vec_abs,__vec_abs,vector signed int,   vector signed int)
#pragma tg_funcdef(vec_abs,__vec_abs,vector float,        vector float)
#define vec_abs(a)  __tg_builtin("vec_abs",a)

/* vec_abss */
#pragma tg_funcdef(vec_abss,__vec_abss,vector signed char,  vector signed char)
#pragma tg_funcdef(vec_abss,__vec_abss,vector signed short, vector signed short)
#pragma tg_funcdef(vec_abss,__vec_abss,vector signed int,   vector signed int)
#define vec_abss(a)  __tg_builtin("vec_abss",a)

/* vec_vaddubm */
#pragma tg_funcdef(vec_vaddubm,__vec_add,vector unsigned char,vector unsigned char,vector unsigned char)
#pragma tg_funcdef(vec_vaddubm,__vec_add,vector unsigned char,vector unsigned char,vector bool char)
#pragma tg_funcdef(vec_vaddubm,__vec_add,vector unsigned char,vector bool char,vector unsigned char)
#pragma tg_funcdef(vec_vaddubm,__vec_add,vector signed char,vector signed char,vector signed char)
#pragma tg_funcdef(vec_vaddubm,__vec_add,vector signed char,vector signed char,vector bool char)
#pragma tg_funcdef(vec_vaddubm,__vec_add,vector signed char,vector bool char,vector signed char)
#define vec_vaddubm(a,b)  __tg_builtin("vec_vaddubm",a,b)

/* vec_vadduhm */
#pragma tg_funcdef(vec_vadduhm,__vec_add,vector unsigned short,vector unsigned short,vector unsigned short)
#pragma tg_funcdef(vec_vadduhm,__vec_add,vector unsigned short,vector unsigned short,vector bool short)
#pragma tg_funcdef(vec_vadduhm,__vec_add,vector unsigned short,vector bool short,vector unsigned short)
#pragma tg_funcdef(vec_vadduhm,__vec_add,vector signed short,vector signed short,vector signed short)
#pragma tg_funcdef(vec_vadduhm,__vec_add,vector signed short,vector signed short,vector bool short)
#pragma tg_funcdef(vec_vadduhm,__vec_add,vector signed short,vector bool short,vector signed short)
#define vec_vadduhm(a,b)  __tg_builtin("vec_vadduhm",a,b)

/* vec_vadduwm */
#pragma tg_funcdef(vec_vadduwm,__vec_add,vector unsigned int,vector unsigned int,vector unsigned int)
#pragma tg_funcdef(vec_vadduwm,__vec_add,vector unsigned int,vector unsigned int,vector bool int)
#pragma tg_funcdef(vec_vadduwm,__vec_add,vector unsigned int,vector bool int,vector unsigned int)
#pragma tg_funcdef(vec_vadduwm,__vec_add,vector signed int,vector signed int,vector signed int)
#pragma tg_funcdef(vec_vadduwm,__vec_add,vector signed int,vector signed int,vector bool int)
#pragma tg_funcdef(vec_vadduwm,__vec_add,vector signed int,vector bool int,vector signed int)
#define vec_vadduwm(a,b)  __tg_builtin("vec_vadduwm",a,b)

/* vec_vaddfp */
#pragma tg_funcdef(vec_vaddfp,__vec_add,vector float,vector float,vector float)
#define vec_vaddfp(a,b)  __tg_builtin("vec_vaddfp",a,b)

/* vec_add */
#pragma tg_funcdef(vec_add,__vec_add,vector unsigned char,vector unsigned char,vector unsigned char)
#pragma tg_funcdef(vec_add,__vec_add,vector unsigned char,vector unsigned char,vector bool char)
#pragma tg_funcdef(vec_add,__vec_add,vector unsigned char,vector bool char,vector unsigned char)
#pragma tg_funcdef(vec_add,__vec_add,vector signed char,vector signed char,vector signed char)
#pragma tg_funcdef(vec_add,__vec_add,vector signed char,vector signed char,vector bool char)
#pragma tg_funcdef(vec_add,__vec_add,vector signed char,vector bool char,vector signed char)
#pragma tg_funcdef(vec_add,__vec_add,vector unsigned short,vector unsigned short,vector unsigned short)
#pragma tg_funcdef(vec_add,__vec_add,vector unsigned short,vector unsigned short,vector bool short)
#pragma tg_funcdef(vec_add,__vec_add,vector unsigned short,vector bool short,vector unsigned short)
#pragma tg_funcdef(vec_add,__vec_add,vector signed short,vector signed short,vector signed short)
#pragma tg_funcdef(vec_add,__vec_add,vector signed short,vector signed short,vector bool short)
#pragma tg_funcdef(vec_add,__vec_add,vector signed short,vector bool short,vector signed short)
#pragma tg_funcdef(vec_add,__vec_add,vector unsigned int,vector unsigned int,vector unsigned int)
#pragma tg_funcdef(vec_add,__vec_add,vector unsigned int,vector unsigned int,vector bool int)
#pragma tg_funcdef(vec_add,__vec_add,vector unsigned int,vector bool int,vector unsigned int)
#pragma tg_funcdef(vec_add,__vec_add,vector signed int,vector signed int,vector signed int)
#pragma tg_funcdef(vec_add,__vec_add,vector signed int,vector signed int,vector bool int)
#pragma tg_funcdef(vec_add,__vec_add,vector signed int,vector bool int,vector signed int)
#pragma tg_funcdef(vec_add,__vec_add,vector float,vector float,vector float)
#define vec_add(a,b)  __tg_builtin("vec_add",a,b)

/* vec_vaddcuw */
#pragma tg_funcdef(vec_vaddcuw,__vec_addc,vector unsigned int,vector unsigned int,vector unsigned int)
#define vec_vaddcuw(a,b)  __tg_builtin("vec_vaddcuw",a,b)

/* vec_addc */
#define vec_addc(a,b)  __vec_addc(a,b)

/* vec_vaddubs */
#pragma tg_funcdef(vec_vaddubs,__vec_adds,vector unsigned char,vector unsigned char,vector unsigned char)
#pragma tg_funcdef(vec_vaddubs,__vec_adds,vector unsigned char,vector unsigned char,vector bool char)
#pragma tg_funcdef(vec_vaddubs,__vec_adds,vector unsigned char,vector bool char,vector unsigned char)
#define vec_vaddubs(a,b)  __tg_builtin("vec_vaddubs",a,b)

/* vec_vaddsbs */
#pragma tg_funcdef(vec_vaddsbs,__vec_adds,vector signed char,vector signed char,vector signed char)
#pragma tg_funcdef(vec_vaddsbs,__vec_adds,vector signed char,vector signed char,vector bool char)
#pragma tg_funcdef(vec_vaddsbs,__vec_adds,vector signed char,vector bool char,vector signed char)
#define vec_vaddsbs(a,b)  __tg_builtin("vec_vaddsbs",a,b)

/* vec_vadduhs */
#pragma tg_funcdef(vec_vadduhs,__vec_adds,vector unsigned short,vector unsigned short,vector unsigned short)
#pragma tg_funcdef(vec_vadduhs,__vec_adds,vector unsigned short,vector unsigned short,vector bool short)
#pragma tg_funcdef(vec_vadduhs,__vec_adds,vector unsigned short,vector bool short,vector unsigned short)
#define vec_vadduhs(a,b)  __tg_builtin("vec_vadduhs",a,b)

/* vec_vaddshs */
#pragma tg_funcdef(vec_vaddshs,__vec_adds,vector signed short,vector signed short,vector signed short)
#pragma tg_funcdef(vec_vaddshs,__vec_adds,vector signed short,vector signed short,vector bool short)
#pragma tg_funcdef(vec_vaddshs,__vec_adds,vector signed short,vector bool short,vector signed short)
#define vec_vaddshs(a,b)  __tg_builtin("vec_vaddshs",a,b)

/* vec_vadduws */
#pragma tg_funcdef(vec_vadduws,__vec_adds,vector unsigned int,vector unsigned int,vector unsigned int)
#pragma tg_funcdef(vec_vadduws,__vec_adds,vector unsigned int,vector unsigned int,vector bool int)
#pragma tg_funcdef(vec_vadduws,__vec_adds,vector unsigned int,vector bool int,vector unsigned int)
#define vec_vadduws(a,b)  __tg_builtin("vec_vadduws",a,b)

/* vec_vaddsws */
#pragma tg_funcdef(vec_vaddsws,__vec_adds,vector signed int,vector signed int,vector signed int)
#pragma tg_funcdef(vec_vaddsws,__vec_adds,vector signed int,vector signed int,vector bool int)
#pragma tg_funcdef(vec_vaddsws,__vec_adds,vector signed int,vector bool int,vector signed int)
#define vec_vaddsws(a,b)  __tg_builtin("vec_vaddsws",a,b)

/* vec_adds */
#pragma tg_funcdef(vec_adds,__vec_adds,vector unsigned char,vector unsigned char,vector unsigned char)
#pragma tg_funcdef(vec_adds,__vec_adds,vector unsigned char,vector unsigned char,vector bool char)
#pragma tg_funcdef(vec_adds,__vec_adds,vector unsigned char,vector bool char,vector unsigned char)
#pragma tg_funcdef(vec_adds,__vec_adds,vector signed char,vector signed char,vector signed char)
#pragma tg_funcdef(vec_adds,__vec_adds,vector signed char,vector signed char,vector bool char)
#pragma tg_funcdef(vec_adds,__vec_adds,vector signed char,vector bool char,vector signed char)
#pragma tg_funcdef(vec_adds,__vec_adds,vector unsigned short,vector unsigned short,vector unsigned short)
#pragma tg_funcdef(vec_adds,__vec_adds,vector unsigned short,vector unsigned short,vector bool short)
#pragma tg_funcdef(vec_adds,__vec_adds,vector unsigned short,vector bool short,vector unsigned short)
#pragma tg_funcdef(vec_adds,__vec_adds,vector signed short,vector signed short,vector signed short)
#pragma tg_funcdef(vec_adds,__vec_adds,vector signed short,vector signed short,vector bool short)
#pragma tg_funcdef(vec_adds,__vec_adds,vector signed short,vector bool short,vector signed short)
#pragma tg_funcdef(vec_adds,__vec_adds,vector unsigned int,vector unsigned int,vector unsigned int)
#pragma tg_funcdef(vec_adds,__vec_adds,vector unsigned int,vector unsigned int,vector bool int)
#pragma tg_funcdef(vec_adds,__vec_adds,vector unsigned int,vector bool int,vector unsigned int)
#pragma tg_funcdef(vec_adds,__vec_adds,vector signed int,vector signed int,vector signed int)
#pragma tg_funcdef(vec_adds,__vec_adds,vector signed int,vector signed int,vector bool int)
#pragma tg_funcdef(vec_adds,__vec_adds,vector signed int,vector bool int,vector signed int)
#define vec_adds(a,b)  __tg_builtin("vec_adds",a,b)

/* vec_vand */
#pragma tg_funcdef(vec_vand,__vec_and,vector unsigned char,vector unsigned char,vector unsigned char)
#pragma tg_funcdef(vec_vand,__vec_and,vector unsigned char,vector unsigned char,vector bool char)
#pragma tg_funcdef(vec_vand,__vec_and,vector unsigned char,vector bool char,vector unsigned char)
#pragma tg_funcdef(vec_vand,__vec_and,vector signed char,vector signed char,vector signed char)
#pragma tg_funcdef(vec_vand,__vec_and,vector signed char,vector signed char,vector bool char)
#pragma tg_funcdef(vec_vand,__vec_and,vector signed char,vector bool char,vector signed char)
#pragma tg_funcdef(vec_vand,__vec_and,vector bool char,vector bool char,vector bool char)
#pragma tg_funcdef(vec_vand,__vec_and,vector unsigned short,vector unsigned short,vector unsigned short)
#pragma tg_funcdef(vec_vand,__vec_and,vector unsigned short,vector unsigned short,vector bool short)
#pragma tg_funcdef(vec_vand,__vec_and,vector unsigned short,vector bool short,vector unsigned short)
#pragma tg_funcdef(vec_vand,__vec_and,vector signed short,vector signed short,vector signed short)
#pragma tg_funcdef(vec_vand,__vec_and,vector signed short,vector signed short,vector bool short)
#pragma tg_funcdef(vec_vand,__vec_and,vector signed short,vector bool short,vector signed short)
#pragma tg_funcdef(vec_vand,__vec_and,vector bool short,vector bool short,vector bool short)
#pragma tg_funcdef(vec_vand,__vec_and,vector unsigned int,vector unsigned int,vector unsigned int)
#pragma tg_funcdef(vec_vand,__vec_and,vector unsigned int,vector unsigned int,vector bool int)
#pragma tg_funcdef(vec_vand,__vec_and,vector unsigned int,vector bool int,vector unsigned int)
#pragma tg_funcdef(vec_vand,__vec_and,vector signed int,vector signed int,vector signed int)
#pragma tg_funcdef(vec_vand,__vec_and,vector signed int,vector signed int,vector bool int)
#pragma tg_funcdef(vec_vand,__vec_and,vector signed int,vector bool int,vector signed int)
#pragma tg_funcdef(vec_vand,__vec_and,vector bool int,vector bool int,vector bool int)
#pragma tg_funcdef(vec_vand,__vec_and,vector float,vector bool int,vector float)
#pragma tg_funcdef(vec_vand,__vec_and,vector float,vector float,vector bool int)
#pragma tg_funcdef(vec_vand,__vec_and,vector float,vector float,vector float)
#define vec_vand(a,b)  __tg_builtin("vec_vand",a,b)

/* vec_and */
#pragma tg_funcdef(vec_and,__vec_and,vector unsigned char,vector unsigned char,vector unsigned char)
#pragma tg_funcdef(vec_and,__vec_and,vector unsigned char,vector unsigned char,vector bool char)
#pragma tg_funcdef(vec_and,__vec_and,vector unsigned char,vector bool char,vector unsigned char)
#pragma tg_funcdef(vec_and,__vec_and,vector signed char,vector signed char,vector signed char)
#pragma tg_funcdef(vec_and,__vec_and,vector signed char,vector signed char,vector bool char)
#pragma tg_funcdef(vec_and,__vec_and,vector signed char,vector bool char,vector signed char)
#pragma tg_funcdef(vec_and,__vec_and,vector bool char,vector bool char,vector bool char)
#pragma tg_funcdef(vec_and,__vec_and,vector unsigned short,vector unsigned short,vector unsigned short)
#pragma tg_funcdef(vec_and,__vec_and,vector unsigned short,vector unsigned short,vector bool short)
#pragma tg_funcdef(vec_and,__vec_and,vector unsigned short,vector bool short,vector unsigned short)
#pragma tg_funcdef(vec_and,__vec_and,vector signed short,vector signed short,vector signed short)
#pragma tg_funcdef(vec_and,__vec_and,vector signed short,vector signed short,vector bool short)
#pragma tg_funcdef(vec_and,__vec_and,vector signed short,vector bool short,vector signed short)
#pragma tg_funcdef(vec_and,__vec_and,vector bool short,vector bool short,vector bool short)
#pragma tg_funcdef(vec_and,__vec_and,vector unsigned int,vector unsigned int,vector unsigned int)
#pragma tg_funcdef(vec_and,__vec_and,vector unsigned int,vector unsigned int,vector bool int)
#pragma tg_funcdef(vec_and,__vec_and,vector unsigned int,vector bool int,vector unsigned int)
#pragma tg_funcdef(vec_and,__vec_and,vector signed int,vector signed int,vector signed int)
#pragma tg_funcdef(vec_and,__vec_and,vector signed int,vector signed int,vector bool int)
#pragma tg_funcdef(vec_and,__vec_and,vector signed int,vector bool int,vector signed int)
#pragma tg_funcdef(vec_and,__vec_and,vector bool int,vector bool int,vector bool int)
#pragma tg_funcdef(vec_and,__vec_and,vector float,vector bool int,vector float)
#pragma tg_funcdef(vec_and,__vec_and,vector float,vector float,vector bool int)
#pragma tg_funcdef(vec_and,__vec_and,vector float,vector float,vector float)
#define vec_and(a,b)  __tg_builtin("vec_and",a,b)

/* vec_vandc */
#pragma tg_funcdef(vec_vandc,__vec_andc,vector unsigned char,vector unsigned char,vector unsigned char)
#pragma tg_funcdef(vec_vandc,__vec_andc,vector unsigned char,vector unsigned char,vector bool char)
#pragma tg_funcdef(vec_vandc,__vec_andc,vector unsigned char,vector bool char,vector unsigned char)
#pragma tg_funcdef(vec_vandc,__vec_andc,vector signed char,vector signed char,vector signed char)
#pragma tg_funcdef(vec_vandc,__vec_andc,vector signed char,vector signed char,vector bool char)
#pragma tg_funcdef(vec_vandc,__vec_andc,vector signed char,vector bool char,vector signed char)
#pragma tg_funcdef(vec_vandc,__vec_andc,vector bool char,vector bool char,vector bool char)
#pragma tg_funcdef(vec_vandc,__vec_andc,vector unsigned short,vector unsigned short,vector unsigned short)
#pragma tg_funcdef(vec_vandc,__vec_andc,vector unsigned short,vector unsigned short,vector bool short)
#pragma tg_funcdef(vec_vandc,__vec_andc,vector unsigned short,vector bool short,vector unsigned short)
#pragma tg_funcdef(vec_vandc,__vec_andc,vector signed short,vector signed short,vector signed short)
#pragma tg_funcdef(vec_vandc,__vec_andc,vector signed short,vector signed short,vector bool short)
#pragma tg_funcdef(vec_vandc,__vec_andc,vector signed short,vector bool short,vector signed short)
#pragma tg_funcdef(vec_vandc,__vec_andc,vector bool short,vector bool short,vector bool short)
#pragma tg_funcdef(vec_vandc,__vec_andc,vector unsigned int,vector unsigned int,vector unsigned int)
#pragma tg_funcdef(vec_vandc,__vec_andc,vector unsigned int,vector unsigned int,vector bool int)
#pragma tg_funcdef(vec_vandc,__vec_andc,vector unsigned int,vector bool int,vector unsigned int)
#pragma tg_funcdef(vec_vandc,__vec_andc,vector signed int,vector signed int,vector signed int)
#pragma tg_funcdef(vec_vandc,__vec_andc,vector signed int,vector signed int,vector bool int)
#pragma tg_funcdef(vec_vandc,__vec_andc,vector signed int,vector bool int,vector signed int)
#pragma tg_funcdef(vec_vandc,__vec_andc,vector bool int,vector bool int,vector bool int)
#pragma tg_funcdef(vec_vandc,__vec_andc,vector float,vector bool int,vector float)
#pragma tg_funcdef(vec_vandc,__vec_andc,vector float,vector float,vector bool int)
#pragma tg_funcdef(vec_vandc,__vec_andc,vector float,vector float, vector float)
#define vec_vandc(a,b)  __tg_builtin("vec_vandc",a,b)

/* vec_andc */
#pragma tg_funcdef(vec_andc,__vec_andc,vector unsigned char,vector unsigned char,vector unsigned char)
#pragma tg_funcdef(vec_andc,__vec_andc,vector unsigned char,vector unsigned char,vector bool char)
#pragma tg_funcdef(vec_andc,__vec_andc,vector unsigned char,vector bool char,vector unsigned char)
#pragma tg_funcdef(vec_andc,__vec_andc,vector signed char,vector signed char,vector signed char)
#pragma tg_funcdef(vec_andc,__vec_andc,vector signed char,vector signed char,vector bool char)
#pragma tg_funcdef(vec_andc,__vec_andc,vector signed char,vector bool char,vector signed char)
#pragma tg_funcdef(vec_andc,__vec_andc,vector bool char,vector bool char,vector bool char)
#pragma tg_funcdef(vec_andc,__vec_andc,vector unsigned short,vector unsigned short,vector unsigned short)
#pragma tg_funcdef(vec_andc,__vec_andc,vector unsigned short,vector unsigned short,vector bool short)
#pragma tg_funcdef(vec_andc,__vec_andc,vector unsigned short,vector bool short,vector unsigned short)
#pragma tg_funcdef(vec_andc,__vec_andc,vector signed short,vector signed short,vector signed short)
#pragma tg_funcdef(vec_andc,__vec_andc,vector signed short,vector signed short,vector bool short)
#pragma tg_funcdef(vec_andc,__vec_andc,vector signed short,vector bool short,vector signed short)
#pragma tg_funcdef(vec_andc,__vec_andc,vector bool short,vector bool short,vector bool short)
#pragma tg_funcdef(vec_andc,__vec_andc,vector unsigned int,vector unsigned int,vector unsigned int)
#pragma tg_funcdef(vec_andc,__vec_andc,vector unsigned int,vector unsigned int,vector bool int)
#pragma tg_funcdef(vec_andc,__vec_andc,vector unsigned int,vector bool int,vector unsigned int)
#pragma tg_funcdef(vec_andc,__vec_andc,vector signed int,vector signed int,vector signed int)
#pragma tg_funcdef(vec_andc,__vec_andc,vector signed int,vector signed int,vector bool int)
#pragma tg_funcdef(vec_andc,__vec_andc,vector signed int,vector bool int,vector signed int)
#pragma tg_funcdef(vec_andc,__vec_andc,vector bool int,vector bool int,vector bool int)
#pragma tg_funcdef(vec_andc,__vec_andc,vector float,vector bool int,vector float)
#pragma tg_funcdef(vec_andc,__vec_andc,vector float,vector float,vector bool int)
#pragma tg_funcdef(vec_andc,__vec_andc,vector float,vector float, vector float)
#define vec_andc(a,b)  __tg_builtin("vec_andc",a,b)

/* vec_vavgub */
#pragma tg_funcdef(vec_vavgub,__vec_avg,vector unsigned char,vector unsigned char,vector unsigned char)
#define vec_vavgub(a,b)  __tg_builtin("vec_vavgub",a,b)

/* vec_vavgsb */
#pragma tg_funcdef(vec_vavgsb,__vec_avg,vector signed char,vector signed char,vector signed char)
#define vec_vavgsb(a,b)  __tg_builtin("vec_vavgsb",a,b)

/* vec_vavguh */
#pragma tg_funcdef(vec_vavguh,__vec_avg,vector unsigned short,vector unsigned short,vector unsigned short)
#define vec_vavguh(a,b)  __tg_builtin("vec_vavguh",a,b)

/* vec_vavgsh */
#pragma tg_funcdef(vec_vavgsh,__vec_avg,vector signed short,vector signed short,vector signed short)
#define vec_vavgsh(a,b)  __tg_builtin("vec_vavgsh",a,b)

/* vec_vavguw */
#pragma tg_funcdef(vec_vavguw,__vec_avg,vector unsigned int,vector unsigned int,vector unsigned int)
#define vec_vavguw(a,b)  __tg_builtin("vec_vavguw",a,b)

/* vec_vavgsw */
#pragma tg_funcdef(vec_vavgsw,__vec_avg,vector signed int,vector signed int,vector signed int)
#define vec_vavgsw(a,b)  __tg_builtin("vec_vavgsw",a,b)

/* vec_avg */
#pragma tg_funcdef(vec_avg,__vec_avg,vector unsigned char,vector unsigned char,vector unsigned char)
#pragma tg_funcdef(vec_avg,__vec_avg,vector signed char,vector signed char,vector signed char)
#pragma tg_funcdef(vec_avg,__vec_avg,vector unsigned short,vector unsigned short,vector unsigned short)
#pragma tg_funcdef(vec_avg,__vec_avg,vector signed short,vector signed short,vector signed short)
#pragma tg_funcdef(vec_avg,__vec_avg,vector unsigned int,vector unsigned int,vector unsigned int)
#pragma tg_funcdef(vec_avg,__vec_avg,vector signed int,vector signed int,vector signed int)
#define vec_avg(a,b)  __tg_builtin("vec_avg",a,b)

/* vec_vrfip */
#pragma tg_funcdef(vec_vrfip,__vec_ceil,vector float,vector float)
#define vec_vrfip(a)  __tg_builtin("vec_vrfip",a)

/* vec_ceil */
#define vec_ceil(a)  __vec_ceil(a)

/* vec_vcmpbfp */
#pragma tg_funcdef(vec_vcmpbfp,__vec_cmpb,vector signed int, vector float, vector float)
#define vec_vcmpbfp(a,b)  __tg_builtin("vec_vcmpbfp",a,b)

/* vec_cmpb */
#define vec_cmpb(a,b)  __vec_cmpb(a,b)

/* vec_vcmpequb */
#pragma tg_funcdef(vec_vcmpequb,__vec_cmpeq,vector bool char,vector unsigned char,vector unsigned char)
#pragma tg_funcdef(vec_vcmpequb,__vec_cmpeq,vector bool char,vector signed char,vector signed char)
#define vec_vcmpequb(a,b)  __tg_builtin("vec_vcmpequb",a,b)

/* vec_vcmpequh */
#pragma tg_funcdef(vec_vcmpequh,__vec_cmpeq,vector bool short,vector unsigned short,vector unsigned short)
#pragma tg_funcdef(vec_vcmpequh,__vec_cmpeq,vector bool short,vector signed short,vector signed short)
#define vec_vcmpequh(a,b)  __tg_builtin("vec_vcmpequh",a,b)

/* vec_vcmpequw */
#pragma tg_funcdef(vec_vcmpequw,__vec_cmpeq,vector bool int,vector unsigned int,vector unsigned int)
#pragma tg_funcdef(vec_vcmpequw,__vec_cmpeq,vector bool int,vector signed int,vector signed int)
#define vec_vcmpequw(a,b)  __tg_builtin("vec_vcmpequw",a,b)

/* vec_vcmpeqfp */
#pragma tg_funcdef(vec_vcmpeqfp,__vec_cmpeq,vector bool int,vector float,vector float)
#define vec_vcmpeqfp(a,b)  __tg_builtin("vec_vcmpeqfp",a,b)

/* vec_cmpeq */
#pragma tg_funcdef(vec_cmpeq,__vec_cmpeq,vector bool char,vector unsigned char,vector unsigned char)
#pragma tg_funcdef(vec_cmpeq,__vec_cmpeq,vector bool char,vector signed char,vector signed char)
#pragma tg_funcdef(vec_cmpeq,__vec_cmpeq,vector bool short,vector unsigned short,vector unsigned short)
#pragma tg_funcdef(vec_cmpeq,__vec_cmpeq,vector bool short,vector signed short,vector signed short)
#pragma tg_funcdef(vec_cmpeq,__vec_cmpeq,vector bool int,vector unsigned int,vector unsigned int)
#pragma tg_funcdef(vec_cmpeq,__vec_cmpeq,vector bool int,vector signed int,vector signed int)
#pragma tg_funcdef(vec_cmpeq,__vec_cmpeq,vector bool int,vector float,vector float)
#define vec_cmpeq(a,b)  __tg_builtin("vec_cmpeq",a,b)

/* vec_vcmpgefp */
#pragma tg_funcdef(vec_vcmpgefp,__vec_cmpge,vector bool int,vector float,vector float)
#define vec_vcmpgefp(a,b)  __tg_builtin("vec_vcmpgefp",a,b)

/* vec_cmpge */
#define vec_cmpge(a,b)  __vec_cmpge(a,b)

/* vec_vcmpgtub */
#pragma tg_funcdef(vec_vcmpgtub,__vec_cmpgt,vector bool char,vector unsigned char,vector unsigned char)
#define vec_vcmpgtub(a,b)  __tg_builtin("vec_vcmpgtub",a,b)

/* vec_vcmpgtsb */
#pragma tg_funcdef(vec_vcmpgtsb,__vec_cmpgt,vector bool char,vector signed char,vector signed char)
#define vec_vcmpgtsb(a,b)  __tg_builtin("vec_vcmpgtsb",a,b)

/* vec_vcmpgtuh */
#pragma tg_funcdef(vec_vcmpgtuh,__vec_cmpgt,vector bool short,vector unsigned short,vector unsigned short)
#define vec_vcmpgtuh(a,b)  __tg_builtin("vec_vcmpgtuh",a,b)

/* vec_vcmpgtsh */
#pragma tg_funcdef(vec_vcmpgtsh,__vec_cmpgt,vector bool short,vector signed short,vector signed short)
#define vec_vcmpgtsh(a,b)  __tg_builtin("vec_vcmpgtsh",a,b)

/* vec_vcmpgtuw */
#pragma tg_funcdef(vec_vcmpgtuw,__vec_cmpgt,vector bool int,vector unsigned int,vector unsigned int)
#define vec_vcmpgtuw(a,b)  __tg_builtin("vec_vcmpgtuw",a,b)

/* vec_vcmpgtsw */
#pragma tg_funcdef(vec_vcmpgtsw,__vec_cmpgt,vector bool int,vector signed int,vector signed int)
#define vec_vcmpgtsw(a,b)  __tg_builtin("vec_vcmpgtsw",a,b)

/* vec_vcmpgtfp */
#pragma tg_funcdef(vec_vcmpgtfp,__vec_cmpgt,vector bool int,vector float,vector float)
#define vec_vcmpgtfp(a,b)  __tg_builtin("vec_vcmpgtfp",a,b)

/* vec_cmpgt */
#pragma tg_funcdef(vec_cmpgt,__vec_cmpgt,vector bool char,vector unsigned char,vector unsigned char)
#pragma tg_funcdef(vec_cmpgt,__vec_cmpgt,vector bool char,vector signed char,vector signed char)
#pragma tg_funcdef(vec_cmpgt,__vec_cmpgt,vector bool short,vector unsigned short,vector unsigned short)
#pragma tg_funcdef(vec_cmpgt,__vec_cmpgt,vector bool short,vector signed short,vector signed short)
#pragma tg_funcdef(vec_cmpgt,__vec_cmpgt,vector bool int,vector unsigned int,vector unsigned int)
#pragma tg_funcdef(vec_cmpgt,__vec_cmpgt,vector bool int,vector signed int,vector signed int)
#pragma tg_funcdef(vec_cmpgt,__vec_cmpgt,vector bool int,vector float,vector float)
#define vec_cmpgt(a,b)  __tg_builtin("vec_cmpgt",a,b)

/* vec_cmple */
#define vec_cmple(a,b)  __vec_cmple(a,b)

/* vec_cmplt */
#pragma tg_funcdef(vec_cmplt,__vec_cmplt,vector bool char,vector unsigned char,vector unsigned char)
#pragma tg_funcdef(vec_cmplt,__vec_cmplt,vector bool char,vector signed char,vector signed char)
#pragma tg_funcdef(vec_cmplt,__vec_cmplt,vector bool short,vector unsigned short,vector unsigned short)
#pragma tg_funcdef(vec_cmplt,__vec_cmplt,vector bool short,vector signed short,vector signed short)
#pragma tg_funcdef(vec_cmplt,__vec_cmplt,vector bool int,vector unsigned int,vector unsigned int)
#pragma tg_funcdef(vec_cmplt,__vec_cmplt,vector bool int,vector signed int,vector signed int)
#pragma tg_funcdef(vec_cmplt,__vec_cmplt,vector bool int,vector float,vector float)
#define vec_cmplt(a,b)  __tg_builtin("vec_cmplt",a,b)

/* vec_vcfux */
#pragma tg_funcdef(vec_vcfux,__vec_ctf,vector float,vector unsigned int,int)
#define vec_vcfux(a,b)  __tg_builtin("vec_vcfux",a,b)

/* vec_vcfsx */
#pragma tg_funcdef(vec_vcfsx,__vec_ctf,vector float,vector signed int,int)
#define vec_vcfsx(a,b)  __tg_builtin("vec_vcfsx",a,b)

/* vec_ctf */
#pragma tg_funcdef(vec_ctf,__vec_ctf,vector float,vector unsigned int,int)
#pragma tg_funcdef(vec_ctf,__vec_ctf,vector float,vector signed int,int)
#define vec_ctf(a,b)  __tg_builtin("vec_ctf",a,b)

/* vec_vctsxs */
#pragma tg_funcdef(vec_vctsxs,__vec_cts,vector signed int,vector float,int)
#define vec_vctsxs(a,b)  __tg_builtin("vec_vctsxs",a,b)

/* vec_cts */
#define vec_cts(a,b)  __vec_cts(a,b)

/* vec_vctuxs */
#pragma tg_funcdef(vec_vctuxs,__vec_ctu,vector unsigned int,vector float,int)
#define vec_vctuxs(a,b)  __tg_builtin("vec_vctuxs",a,b)

/* vec_ctu */
#define vec_ctu(a,b)  __vec_ctu(a,b)

/* vec_dss */
#define vec_dss(a)  __vec_dss(a)

/* vec_dssall */
#define vec_dssall()  __vec_dssall()

/* vec_dst */
#define vec_dst(a,b,c)  __vec_dst(a,b,c)

/* vec_dstst */
#define vec_dstst(a,b,c)  __vec_dstst(a,b,c)

/* vec_dststt */
#define vec_dststt(a,b,c)  __vec_dststt(a,b,c)

/* vec_dstt */
#define vec_dstt(a,b,c)  __vec_dstt(a,b,c)

/* vec_vexptefp */
#pragma tg_funcdef(vec_vexptefp,__vec_expte,vector float,vector float)
#define vec_vexptefp(a)  __tg_builtin("vec_vexptefp",a)

/* vec_expte */
#define vec_expte(a)  __vec_expte(a)

/* vec_extract */
#pragma tg_funcdef(vec_extract, __vec_extract_u1,  unsigned char,   vector unsigned char,   signed int)
#pragma tg_funcdef(vec_extract, __vec_extract_s1,  signed char,     vector signed char,     signed int)
#pragma tg_funcdef(vec_extract, __vec_extract_u2,  unsigned short,  vector unsigned short,  signed int)
#pragma tg_funcdef(vec_extract, __vec_extract_s2,  signed short,    vector signed short,    signed int)
#pragma tg_funcdef(vec_extract, __vec_extract_u4,  unsigned int,    vector unsigned int,    signed int)
#pragma tg_funcdef(vec_extract, __vec_extract_s4,  signed int,      vector signed int,      signed int)
#pragma tg_funcdef(vec_extract, __vec_extract_f4,  float,           vector float,           signed int)
#undef  vec_extract
#define vec_extract(__a,__b) __tg_builtin("vec_extract",__a,__b)

/* vec_vrfim */
#pragma tg_funcdef(vec_vrfim,__vec_floor,vector float,vector float)
#define vec_vrfim(a)  __tg_builtin("vec_vrfim",a)

/* vec_floor */
#define vec_floor(a)  __vec_floor(a)

/* vec_insert */
#pragma tg_funcdef(vec_insert, __vec_insert_u1, vector unsigned char,   unsigned char,   vector unsigned char,   signed int)
#pragma tg_funcdef(vec_insert, __vec_insert_u1, vector unsigned char,   signed int,      vector unsigned char,   signed int)
#pragma tg_funcdef(vec_insert, __vec_insert_s1, vector signed char,     signed char,     vector signed char,     signed int)
#pragma tg_funcdef(vec_insert, __vec_insert_s1, vector signed char,     signed int,      vector signed char,     signed int)
#pragma tg_funcdef(vec_insert, __vec_insert_u2, vector unsigned short,  unsigned short,  vector unsigned short,  signed int)
#pragma tg_funcdef(vec_insert, __vec_insert_u2, vector unsigned short,  signed int,      vector unsigned short,  signed int)
#pragma tg_funcdef(vec_insert, __vec_insert_s2, vector signed short,    signed short,    vector signed short,    signed int)
#pragma tg_funcdef(vec_insert, __vec_insert_s2, vector signed short,    signed int,      vector signed short,    signed int)
#pragma tg_funcdef(vec_insert, __vec_insert_u4, vector unsigned int,    unsigned int,    vector unsigned int,    signed int)
#pragma tg_funcdef(vec_insert, __vec_insert_u4, vector unsigned int,    signed int,      vector unsigned int,    signed int)
#pragma tg_funcdef(vec_insert, __vec_insert_s4, vector signed int,      signed int,      vector signed int,      signed int)
#pragma tg_funcdef(vec_insert, __vec_insert_f4, vector float,           float,           vector float,           signed int)
#pragma tg_funcdef(vec_insert, __vec_insert_f4, vector float,           double,          vector float,           signed int)
#undef  vec_insert
#define vec_insert(__a,__b,__c) __tg_builtin("vec_insert",__a,__b,__c)

/* vec_lvx */
#pragma tg_funcdef(vec_lvx,__vec_ld,vector unsigned char,int,vector unsigned char*)
#pragma tg_funcdef(vec_lvx,__vec_ld,vector unsigned char,int,unsigned char*)
#pragma tg_funcdef(vec_lvx,__vec_ld,vector signed char,int,vector signed char*)
#pragma tg_funcdef(vec_lvx,__vec_ld,vector signed char,int,signed char*)
#pragma tg_funcdef(vec_lvx,__vec_ld,vector bool char,int,vector bool char*)
#pragma tg_funcdef(vec_lvx,__vec_ld,vector unsigned short,int,vector unsigned short*)
#pragma tg_funcdef(vec_lvx,__vec_ld,vector unsigned short,int,unsigned short*)
#pragma tg_funcdef(vec_lvx,__vec_ld,vector signed short,int,vector signed short*)
#pragma tg_funcdef(vec_lvx,__vec_ld,vector signed short,int,signed short*)
#pragma tg_funcdef(vec_lvx,__vec_ld,vector bool short,int,vector bool short*)
#pragma tg_funcdef(vec_lvx,__vec_ld,vector pixel,int,vector pixel*)
#pragma tg_funcdef(vec_lvx,__vec_ld,vector unsigned int,int,vector unsigned int*)
#pragma tg_funcdef(vec_lvx,__vec_ld,vector unsigned int,int,unsigned int*)
#pragma tg_funcdef(vec_lvx,__vec_ld,vector signed int,int,vector signed int*)
#pragma tg_funcdef(vec_lvx,__vec_ld,vector signed int,int,signed int*)
#ifndef __64BIT__
#pragma tg_funcdef(vec_lvx,__vec_ld,vector unsigned int,int,unsigned long*)
#pragma tg_funcdef(vec_lvx,__vec_ld,vector signed int,int,signed long*)
#endif /* __64BIT__ */
#pragma tg_funcdef(vec_lvx,__vec_ld,vector bool int,int,vector bool int*)
#pragma tg_funcdef(vec_lvx,__vec_ld,vector float,int,vector float*)
#pragma tg_funcdef(vec_lvx,__vec_ld,vector float,int,float*)
#ifdef __64BIT__
#pragma tg_funcdef(vec_lvx,__vec_ld,vector unsigned char,long,vector unsigned char*)
#pragma tg_funcdef(vec_lvx,__vec_ld,vector unsigned char,long,unsigned char*)
#pragma tg_funcdef(vec_lvx,__vec_ld,vector signed char,long,vector signed char*)
#pragma tg_funcdef(vec_lvx,__vec_ld,vector signed char,long,signed char*)
#pragma tg_funcdef(vec_lvx,__vec_ld,vector bool char,long,vector bool char*)
#pragma tg_funcdef(vec_lvx,__vec_ld,vector unsigned short,long,vector unsigned short*)
#pragma tg_funcdef(vec_lvx,__vec_ld,vector unsigned short,long,unsigned short*)
#pragma tg_funcdef(vec_lvx,__vec_ld,vector signed short,long,vector signed short*)
#pragma tg_funcdef(vec_lvx,__vec_ld,vector signed short,long,signed short*)
#pragma tg_funcdef(vec_lvx,__vec_ld,vector bool short,long,vector bool short*)
#pragma tg_funcdef(vec_lvx,__vec_ld,vector pixel,long,vector pixel*)
#pragma tg_funcdef(vec_lvx,__vec_ld,vector unsigned int,long,vector unsigned int*)
#pragma tg_funcdef(vec_lvx,__vec_ld,vector unsigned int,long,unsigned int*)
#pragma tg_funcdef(vec_lvx,__vec_ld,vector signed int,long,vector signed int*)
#pragma tg_funcdef(vec_lvx,__vec_ld,vector signed int,long,signed int*)
#pragma tg_funcdef(vec_lvx,__vec_ld,vector bool int,long,vector bool int*)
#pragma tg_funcdef(vec_lvx,__vec_ld,vector float,long,vector float*)
#pragma tg_funcdef(vec_lvx,__vec_ld,vector float,long,float*)
#endif /* __64BIT__ */
#define vec_lvx(a,b)  __tg_builtin("vec_lvx",a,b)

/* vec_ld */
#pragma tg_funcdef(vec_ld,__vec_ld,vector unsigned char,int,vector unsigned char*)
#pragma tg_funcdef(vec_ld,__vec_ld,vector unsigned char,int,unsigned char*)
#pragma tg_funcdef(vec_ld,__vec_ld,vector signed char,int,vector signed char*)
#pragma tg_funcdef(vec_ld,__vec_ld,vector signed char,int,signed char*)
#pragma tg_funcdef(vec_ld,__vec_ld,vector bool char,int,vector bool char*)
#pragma tg_funcdef(vec_ld,__vec_ld,vector unsigned short,int,vector unsigned short*)
#pragma tg_funcdef(vec_ld,__vec_ld,vector unsigned short,int,unsigned short*)
#pragma tg_funcdef(vec_ld,__vec_ld,vector signed short,int,vector signed short*)
#pragma tg_funcdef(vec_ld,__vec_ld,vector signed short,int,signed short*)
#pragma tg_funcdef(vec_ld,__vec_ld,vector bool short,int,vector bool short*)
#pragma tg_funcdef(vec_ld,__vec_ld,vector pixel,int,vector pixel*)
#pragma tg_funcdef(vec_ld,__vec_ld,vector unsigned int,int,vector unsigned int*)
#pragma tg_funcdef(vec_ld,__vec_ld,vector unsigned int,int,unsigned int*)
#pragma tg_funcdef(vec_ld,__vec_ld,vector signed int,int,vector signed int*)
#pragma tg_funcdef(vec_ld,__vec_ld,vector signed int,int,signed int*)
#ifndef __64BIT__
#pragma tg_funcdef(vec_ld,__vec_ld,vector unsigned int,int,unsigned long*)
#pragma tg_funcdef(vec_ld,__vec_ld,vector signed int,int,signed long*)
#endif /* __64BIT__ */
#pragma tg_funcdef(vec_ld,__vec_ld,vector bool int,int,vector bool int*)
#pragma tg_funcdef(vec_ld,__vec_ld,vector float,int,vector float*)
#pragma tg_funcdef(vec_ld,__vec_ld,vector float,int,float*)
#ifdef __64BIT__
#pragma tg_funcdef(vec_ld,__vec_ld,vector unsigned char,long,vector unsigned char*)
#pragma tg_funcdef(vec_ld,__vec_ld,vector unsigned char,long,unsigned char*)
#pragma tg_funcdef(vec_ld,__vec_ld,vector signed char,long,vector signed char*)
#pragma tg_funcdef(vec_ld,__vec_ld,vector signed char,long,signed char*)
#pragma tg_funcdef(vec_ld,__vec_ld,vector bool char,long,vector bool char*)
#pragma tg_funcdef(vec_ld,__vec_ld,vector unsigned short,long,vector unsigned short*)
#pragma tg_funcdef(vec_ld,__vec_ld,vector unsigned short,long,unsigned short*)
#pragma tg_funcdef(vec_ld,__vec_ld,vector signed short,long,vector signed short*)
#pragma tg_funcdef(vec_ld,__vec_ld,vector signed short,long,signed short*)
#pragma tg_funcdef(vec_ld,__vec_ld,vector bool short,long,vector bool short*)
#pragma tg_funcdef(vec_ld,__vec_ld,vector pixel,long,vector pixel*)
#pragma tg_funcdef(vec_ld,__vec_ld,vector unsigned int,long,vector unsigned int*)
#pragma tg_funcdef(vec_ld,__vec_ld,vector unsigned int,long,unsigned int*)
#pragma tg_funcdef(vec_ld,__vec_ld,vector signed int,long,vector signed int*)
#pragma tg_funcdef(vec_ld,__vec_ld,vector signed int,long,signed int*)
#pragma tg_funcdef(vec_ld,__vec_ld,vector bool int,long,vector bool int*)
#pragma tg_funcdef(vec_ld,__vec_ld,vector float,long,vector float*)
#pragma tg_funcdef(vec_ld,__vec_ld,vector float,long,float*)
#endif /* __64BIT__ */
#define vec_ld(a,b)  __tg_builtin("vec_ld",a,b)

/* vec_lde */
#pragma tg_funcdef(vec_lde,__vec_lde_b,vector unsigned char,int,unsigned char*)
#pragma tg_funcdef(vec_lde,__vec_lde_b,vector signed char,int,signed char*)
#pragma tg_funcdef(vec_lde,__vec_lde_h,vector unsigned short,int,unsigned short*)
#pragma tg_funcdef(vec_lde,__vec_lde_h,vector signed short,int,signed short*)
#pragma tg_funcdef(vec_lde,__vec_lde_w,vector unsigned int,int,unsigned int*)
#pragma tg_funcdef(vec_lde,__vec_lde_w,vector signed int,int,signed int*)
#ifndef __64BIT__
#pragma tg_funcdef(vec_lde,__vec_lde_w,vector unsigned int,int,unsigned long*)
#pragma tg_funcdef(vec_lde,__vec_lde_w,vector signed int,int,signed long*)
#endif /* __64BIT__ */
#pragma tg_funcdef(vec_lde,__vec_lde_w,vector float,int,float*)
#ifdef __64BIT__
#pragma tg_funcdef(vec_lde,__vec_lde_b,vector unsigned char,long,unsigned char*)
#pragma tg_funcdef(vec_lde,__vec_lde_b,vector signed char,long,signed char*)
#pragma tg_funcdef(vec_lde,__vec_lde_h,vector unsigned short,long,unsigned short*)
#pragma tg_funcdef(vec_lde,__vec_lde_h,vector signed short,long,signed short*)
#pragma tg_funcdef(vec_lde,__vec_lde_w,vector unsigned int,long,unsigned int*)
#pragma tg_funcdef(vec_lde,__vec_lde_w,vector signed int,long,signed int*)
#pragma tg_funcdef(vec_lde,__vec_lde_w,vector float,long,float*)
#endif /* __64BIT__ */
#define vec_lde(a,b)  __tg_builtin("vec_lde",a,b)

/* vec_lvebx */
#pragma tg_funcdef(vec_lvebx,__vec_lde_b,vector unsigned char,int,unsigned char*)
#pragma tg_funcdef(vec_lvebx,__vec_lde_b,vector signed char,int,signed char*)
#ifdef __64BIT__
#pragma tg_funcdef(vec_lvebx,__vec_lde_b,vector unsigned char,long,unsigned char*)
#pragma tg_funcdef(vec_lvebx,__vec_lde_b,vector signed char,long,signed char*)
#endif /* __64BIT__ */
#define vec_lvebx(a,b)  __tg_builtin("vec_lvebx",a,b)

/* vec_lvehx */
#pragma tg_funcdef(vec_lvehx,__vec_lde_h,vector unsigned short,int,unsigned short*)
#pragma tg_funcdef(vec_lvehx,__vec_lde_h,vector signed short,int,signed short*)
#ifdef __64BIT__
#pragma tg_funcdef(vec_lvehx,__vec_lde_h,vector unsigned short,long,unsigned short*)
#pragma tg_funcdef(vec_lvehx,__vec_lde_h,vector signed short,long,signed short*)
#endif /* __64BIT__ */
#define vec_lvehx(a,b)  __tg_builtin("vec_lvehx",a,b)

/* vec_lvewx */
#pragma tg_funcdef(vec_lvewx,__vec_lde_w,vector unsigned int,int,unsigned int*)
#pragma tg_funcdef(vec_lvewx,__vec_lde_w,vector signed int,int,signed int*)
#ifndef __64BIT__
#pragma tg_funcdef(vec_lvewx,__vec_lde_w,vector unsigned int,int,unsigned long*)
#pragma tg_funcdef(vec_lvewx,__vec_lde_w,vector signed int,int,signed long*)
#endif /* __64BIT__ */
#pragma tg_funcdef(vec_lvewx,__vec_lde_w,vector float,int,float*)
#ifdef __64BIT__
#pragma tg_funcdef(vec_lvewx,__vec_lde_w,vector unsigned int,long,unsigned int*)
#pragma tg_funcdef(vec_lvewx,__vec_lde_w,vector signed int,long,signed int*)
#pragma tg_funcdef(vec_lvewx,__vec_lde_w,vector float,long,float*)
#endif /* __64BIT__ */
#define vec_lvewx(a,b)  __tg_builtin("vec_lvewx",a,b)

/* vec_lvxl */
#pragma tg_funcdef(vec_lvxl,__vec_ldl,vector unsigned char,int,vector unsigned char*)
#pragma tg_funcdef(vec_lvxl,__vec_ldl,vector unsigned char,int,unsigned char*)
#pragma tg_funcdef(vec_lvxl,__vec_ldl,vector signed char,int,vector signed char*)
#pragma tg_funcdef(vec_lvxl,__vec_ldl,vector signed char,int,signed char*)
#pragma tg_funcdef(vec_lvxl,__vec_ldl,vector bool char,int,vector bool char*)
#pragma tg_funcdef(vec_lvxl,__vec_ldl,vector unsigned short,int,vector unsigned short*)
#pragma tg_funcdef(vec_lvxl,__vec_ldl,vector unsigned short,int,unsigned short*)
#pragma tg_funcdef(vec_lvxl,__vec_ldl,vector signed short,int,vector signed short*)
#pragma tg_funcdef(vec_lvxl,__vec_ldl,vector signed short,int,signed short*)
#pragma tg_funcdef(vec_lvxl,__vec_ldl,vector bool short,int,vector bool short*)
#pragma tg_funcdef(vec_lvxl,__vec_ldl,vector pixel,int,vector pixel*)
#pragma tg_funcdef(vec_lvxl,__vec_ldl,vector unsigned int,int,vector unsigned int*)
#pragma tg_funcdef(vec_lvxl,__vec_ldl,vector unsigned int,int,unsigned int*)
#pragma tg_funcdef(vec_lvxl,__vec_ldl,vector signed int,int,vector signed int*)
#pragma tg_funcdef(vec_lvxl,__vec_ldl,vector signed int,int,signed int*)
#ifndef __64BIT__
#pragma tg_funcdef(vec_lvxl,__vec_ldl,vector unsigned int,int,unsigned long*)
#pragma tg_funcdef(vec_lvxl,__vec_ldl,vector signed int,int,signed long*)
#endif /* __64BIT__ */
#pragma tg_funcdef(vec_lvxl,__vec_ldl,vector bool int,int,vector bool int*)
#pragma tg_funcdef(vec_lvxl,__vec_ldl,vector float,int,vector float*)
#pragma tg_funcdef(vec_lvxl,__vec_ldl,vector float,int,float*)
#ifdef __64BIT__
#pragma tg_funcdef(vec_lvxl,__vec_ldl,vector unsigned char,long,vector unsigned char*)
#pragma tg_funcdef(vec_lvxl,__vec_ldl,vector unsigned char,long,unsigned char*)
#pragma tg_funcdef(vec_lvxl,__vec_ldl,vector signed char,long,vector signed char*)
#pragma tg_funcdef(vec_lvxl,__vec_ldl,vector signed char,long,signed char*)
#pragma tg_funcdef(vec_lvxl,__vec_ldl,vector bool char,long,vector bool char*)
#pragma tg_funcdef(vec_lvxl,__vec_ldl,vector unsigned short,long,vector unsigned short*)
#pragma tg_funcdef(vec_lvxl,__vec_ldl,vector unsigned short,long,unsigned short*)
#pragma tg_funcdef(vec_lvxl,__vec_ldl,vector signed short,long,vector signed short*)
#pragma tg_funcdef(vec_lvxl,__vec_ldl,vector signed short,long,signed short*)
#pragma tg_funcdef(vec_lvxl,__vec_ldl,vector bool short,long,vector bool short*)
#pragma tg_funcdef(vec_lvxl,__vec_ldl,vector pixel,long,vector pixel*)
#pragma tg_funcdef(vec_lvxl,__vec_ldl,vector unsigned int,long,vector unsigned int*)
#pragma tg_funcdef(vec_lvxl,__vec_ldl,vector unsigned int,long,unsigned int*)
#pragma tg_funcdef(vec_lvxl,__vec_ldl,vector signed int,long,vector signed int*)
#pragma tg_funcdef(vec_lvxl,__vec_ldl,vector signed int,long,signed int*)
#pragma tg_funcdef(vec_lvxl,__vec_ldl,vector bool int,long,vector bool int*)
#pragma tg_funcdef(vec_lvxl,__vec_ldl,vector float,long,vector float*)
#pragma tg_funcdef(vec_lvxl,__vec_ldl,vector float,long,float*)
#endif /* __64BIT__ */
#define vec_lvxl(a,b)  __tg_builtin("vec_lvxl",a,b)

/* vec_ldl */
#pragma tg_funcdef(vec_ldl,__vec_ldl,vector unsigned char,int,vector unsigned char*)
#pragma tg_funcdef(vec_ldl,__vec_ldl,vector unsigned char,int,unsigned char*)
#pragma tg_funcdef(vec_ldl,__vec_ldl,vector signed char,int,vector signed char*)
#pragma tg_funcdef(vec_ldl,__vec_ldl,vector signed char,int,signed char*)
#pragma tg_funcdef(vec_ldl,__vec_ldl,vector bool char,int,vector bool char*)
#pragma tg_funcdef(vec_ldl,__vec_ldl,vector unsigned short,int,vector unsigned short*)
#pragma tg_funcdef(vec_ldl,__vec_ldl,vector unsigned short,int,unsigned short*)
#pragma tg_funcdef(vec_ldl,__vec_ldl,vector signed short,int,vector signed short*)
#pragma tg_funcdef(vec_ldl,__vec_ldl,vector signed short,int,signed short*)
#pragma tg_funcdef(vec_ldl,__vec_ldl,vector bool short,int,vector bool short*)
#pragma tg_funcdef(vec_ldl,__vec_ldl,vector pixel,int,vector pixel*)
#pragma tg_funcdef(vec_ldl,__vec_ldl,vector unsigned int,int,vector unsigned int*)
#pragma tg_funcdef(vec_ldl,__vec_ldl,vector unsigned int,int,unsigned int*)
#pragma tg_funcdef(vec_ldl,__vec_ldl,vector signed int,int,vector signed int*)
#pragma tg_funcdef(vec_ldl,__vec_ldl,vector signed int,int,signed int*)
#ifndef __64BIT__
#pragma tg_funcdef(vec_ldl,__vec_ldl,vector unsigned int,int,unsigned long*)
#pragma tg_funcdef(vec_ldl,__vec_ldl,vector signed int,int,signed long*)
#endif /* __64BIT__ */
#pragma tg_funcdef(vec_ldl,__vec_ldl,vector bool int,int,vector bool int*)
#pragma tg_funcdef(vec_ldl,__vec_ldl,vector float,int,vector float*)
#pragma tg_funcdef(vec_ldl,__vec_ldl,vector float,int,float*)
#ifdef __64BIT__
#pragma tg_funcdef(vec_ldl,__vec_ldl,vector unsigned char,long,vector unsigned char*)
#pragma tg_funcdef(vec_ldl,__vec_ldl,vector unsigned char,long,unsigned char*)
#pragma tg_funcdef(vec_ldl,__vec_ldl,vector signed char,long,vector signed char*)
#pragma tg_funcdef(vec_ldl,__vec_ldl,vector signed char,long,signed char*)
#pragma tg_funcdef(vec_ldl,__vec_ldl,vector bool char,long,vector bool char*)
#pragma tg_funcdef(vec_ldl,__vec_ldl,vector unsigned short,long,vector unsigned short*)
#pragma tg_funcdef(vec_ldl,__vec_ldl,vector unsigned short,long,unsigned short*)
#pragma tg_funcdef(vec_ldl,__vec_ldl,vector signed short,long,vector signed short*)
#pragma tg_funcdef(vec_ldl,__vec_ldl,vector signed short,long,signed short*)
#pragma tg_funcdef(vec_ldl,__vec_ldl,vector bool short,long,vector bool short*)
#pragma tg_funcdef(vec_ldl,__vec_ldl,vector pixel,long,vector pixel*)
#pragma tg_funcdef(vec_ldl,__vec_ldl,vector unsigned int,long,vector unsigned int*)
#pragma tg_funcdef(vec_ldl,__vec_ldl,vector unsigned int,long,unsigned int*)
#pragma tg_funcdef(vec_ldl,__vec_ldl,vector signed int,long,vector signed int*)
#pragma tg_funcdef(vec_ldl,__vec_ldl,vector signed int,long,signed int*)
#pragma tg_funcdef(vec_ldl,__vec_ldl,vector bool int,long,vector bool int*)
#pragma tg_funcdef(vec_ldl,__vec_ldl,vector float,long,vector float*)
#pragma tg_funcdef(vec_ldl,__vec_ldl,vector float,long,float*)
#endif /* __64BIT__ */
#define vec_ldl(a,b)  __tg_builtin("vec_ldl",a,b)

/* vec_vlogefp */
#pragma tg_funcdef(vec_vlogefp,__vec_loge,vector float,vector float)
#define vec_vlogefp(a)  __tg_builtin("vec_vlogefp",a)

/* vec_loge */
#define vec_loge(a)  __vec_loge(a)

/* vec_lvlx */
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector unsigned char,int,vector unsigned char*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector unsigned char,int,const vector unsigned char*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector unsigned char,int,volatile vector unsigned char*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector unsigned char,int,const volatile vector unsigned char*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector unsigned char,int,unsigned char*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector unsigned char,int,const unsigned char*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector unsigned char,int,volatile unsigned char*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector unsigned char,int,const volatile unsigned char*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector signed char,int,vector signed char*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector signed char,int,const vector signed char*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector signed char,int,volatile vector signed char*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector signed char,int,const volatile vector signed char*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector signed char,int,signed char*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector signed char,int,const signed char*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector signed char,int,volatile signed char*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector signed char,int,const volatile signed char*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector bool char,int,vector bool char*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector bool char,int,const vector bool char*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector bool char,int,volatile vector bool char*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector bool char,int,const volatile vector bool char*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector unsigned short,int,vector unsigned short*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector unsigned short,int,const vector unsigned short*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector unsigned short,int,volatile vector unsigned short*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector unsigned short,int,const volatile vector unsigned short*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector unsigned short,int,unsigned short*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector unsigned short,int,const unsigned short*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector unsigned short,int,volatile unsigned short*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector unsigned short,int,const volatile unsigned short*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector signed short,int,vector signed short*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector signed short,int,const vector signed short*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector signed short,int,volatile vector signed short*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector signed short,int,const volatile vector signed short*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector signed short,int,signed short*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector signed short,int,const signed short*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector signed short,int,volatile signed short*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector signed short,int,const volatile signed short*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector bool short,int,vector bool short*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector bool short,int,const vector bool short*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector bool short,int,volatile vector bool short*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector bool short,int,const volatile vector bool short*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector pixel,int,vector pixel*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector pixel,int,const vector pixel*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector pixel,int,volatile vector pixel*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector pixel,int,const volatile vector pixel*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector unsigned int,int,vector unsigned int*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector unsigned int,int,const vector unsigned int*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector unsigned int,int,volatile vector unsigned int*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector unsigned int,int,const volatile vector unsigned int*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector unsigned int,int,unsigned int*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector unsigned int,int,const unsigned int*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector unsigned int,int,volatile unsigned int*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector unsigned int,int,const volatile unsigned int*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector signed int,int,vector signed int*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector signed int,int,const vector signed int*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector signed int,int,volatile vector signed int*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector signed int,int,const volatile vector signed int*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector signed int,int,signed int*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector signed int,int,const signed int*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector signed int,int,volatile signed int*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector signed int,int,const volatile signed int*)
#ifndef __64BIT__
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector unsigned int,int,unsigned long*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector unsigned int,int,const unsigned long*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector unsigned int,int,volatile unsigned long*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector unsigned int,int,const volatile unsigned long*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector signed int,int,signed long*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector signed int,int,const signed long*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector signed int,int,volatile signed long*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector signed int,int,const volatile signed long*)
#endif /* __64BIT__ */
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector bool int,int,vector bool int*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector bool int,int,const vector bool int*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector bool int,int,volatile vector bool int*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector bool int,int,const volatile vector bool int*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector float,int,vector float*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector float,int,const vector float*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector float,int,volatile vector float*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector float,int,const volatile vector float*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector float,int,float*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector float,int,const float*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector float,int,volatile float*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector float,int,const volatile float*)
#ifdef __64BIT__
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector unsigned char,long,vector unsigned char*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector unsigned char,long,const vector unsigned char*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector unsigned char,long,volatile vector unsigned char*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector unsigned char,long,const volatile vector unsigned char*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector unsigned char,long,unsigned char*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector unsigned char,long,const unsigned char*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector unsigned char,long,volatile unsigned char*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector unsigned char,long,const volatile unsigned char*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector signed char,long,vector signed char*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector signed char,long,const vector signed char*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector signed char,long,volatile vector signed char*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector signed char,long,const volatile vector signed char*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector signed char,long,signed char*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector signed char,long,const signed char*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector signed char,long,volatile signed char*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector signed char,long,const volatile signed char*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector bool char,long,vector bool char*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector bool char,long,const vector bool char*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector bool char,long,volatile vector bool char*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector bool char,long,const volatile vector bool char*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector unsigned short,long,vector unsigned short*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector unsigned short,long,const vector unsigned short*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector unsigned short,long,volatile vector unsigned short*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector unsigned short,long,const volatile vector unsigned short*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector unsigned short,long,unsigned short*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector unsigned short,long,const unsigned short*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector unsigned short,long,volatile unsigned short*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector unsigned short,long,const volatile unsigned short*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector signed short,long,vector signed short*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector signed short,long,const vector signed short*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector signed short,long,volatile vector signed short*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector signed short,long,const volatile vector signed short*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector signed short,long,signed short*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector signed short,long,const signed short*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector signed short,long,volatile signed short*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector signed short,long,const volatile signed short*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector bool short,long,vector bool short*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector bool short,long,const vector bool short*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector bool short,long,volatile vector bool short*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector bool short,long,const volatile vector bool short*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector pixel,long,vector pixel*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector pixel,long,const vector pixel*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector pixel,long,volatile vector pixel*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector pixel,long,const volatile vector pixel*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector unsigned int,long,vector unsigned int*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector unsigned int,long,const vector unsigned int*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector unsigned int,long,volatile vector unsigned int*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector unsigned int,long,const volatile vector unsigned int*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector unsigned int,long,unsigned int*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector unsigned int,long,const unsigned int*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector unsigned int,long,volatile unsigned int*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector unsigned int,long,const volatile unsigned int*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector signed int,long,vector signed int*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector signed int,long,const vector signed int*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector signed int,long,volatile vector signed int*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector signed int,long,const volatile vector signed int*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector signed int,long,signed int*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector signed int,long,const signed int*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector signed int,long,volatile signed int*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector signed int,long,const volatile signed int*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector bool int,long,vector bool int*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector bool int,long,const vector bool int*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector bool int,long,volatile vector bool int*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector bool int,long,const volatile vector bool int*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector float,long,vector float*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector float,long,const vector float*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector float,long,volatile vector float*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector float,long,const volatile vector float*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector float,long,float*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector float,long,const float*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector float,long,volatile float*)
#pragma tg_funcdef(vec_lvlx,__vec_lvlx,vector float,long,const volatile float*)
#endif /* __64BIT__ */
#define vec_lvlx(a,b)  __tg_builtin("vec_lvlx",a,b)

/* vec_lvlxl */
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector unsigned char,int,vector unsigned char*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector unsigned char,int,const vector unsigned char*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector unsigned char,int,volatile vector unsigned char*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector unsigned char,int,const volatile vector unsigned char*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector unsigned char,int,unsigned char*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector unsigned char,int,const unsigned char*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector unsigned char,int,volatile unsigned char*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector unsigned char,int,const volatile unsigned char*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector signed char,int,vector signed char*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector signed char,int,const vector signed char*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector signed char,int,volatile vector signed char*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector signed char,int,const volatile vector signed char*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector signed char,int,signed char*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector signed char,int,const signed char*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector signed char,int,volatile signed char*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector signed char,int,const volatile signed char*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector bool char,int,vector bool char*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector bool char,int,const vector bool char*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector bool char,int,volatile vector bool char*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector bool char,int,const volatile vector bool char*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector unsigned short,int,vector unsigned short*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector unsigned short,int,const vector unsigned short*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector unsigned short,int,volatile vector unsigned short*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector unsigned short,int,const volatile vector unsigned short*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector unsigned short,int,unsigned short*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector unsigned short,int,const unsigned short*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector unsigned short,int,volatile unsigned short*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector unsigned short,int,const volatile unsigned short*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector signed short,int,vector signed short*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector signed short,int,const vector signed short*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector signed short,int,volatile vector signed short*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector signed short,int,const volatile vector signed short*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector signed short,int,signed short*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector signed short,int,const signed short*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector signed short,int,volatile signed short*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector signed short,int,const volatile signed short*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector bool short,int,vector bool short*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector bool short,int,const vector bool short*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector bool short,int,volatile vector bool short*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector bool short,int,const volatile vector bool short*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector pixel,int,vector pixel*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector pixel,int,const vector pixel*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector pixel,int,volatile vector pixel*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector pixel,int,const volatile vector pixel*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector unsigned int,int,vector unsigned int*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector unsigned int,int,const vector unsigned int*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector unsigned int,int,volatile vector unsigned int*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector unsigned int,int,const volatile vector unsigned int*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector unsigned int,int,unsigned int*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector unsigned int,int,const unsigned int*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector unsigned int,int,volatile unsigned int*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector unsigned int,int,const volatile unsigned int*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector signed int,int,vector signed int*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector signed int,int,const vector signed int*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector signed int,int,volatile vector signed int*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector signed int,int,const volatile vector signed int*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector signed int,int,signed int*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector signed int,int,const signed int*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector signed int,int,volatile signed int*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector signed int,int,const volatile signed int*)
#ifndef __64BIT__
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector unsigned int,int,unsigned long*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector unsigned int,int,const unsigned long*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector unsigned int,int,volatile unsigned long*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector unsigned int,int,const volatile unsigned long*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector signed int,int,signed long*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector signed int,int,const signed long*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector signed int,int,volatile signed long*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector signed int,int,const volatile signed long*)
#endif /* __64BIT__ */
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector bool int,int,vector bool int*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector bool int,int,const vector bool int*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector bool int,int,volatile vector bool int*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector bool int,int,const volatile vector bool int*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector float,int,vector float*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector float,int,const vector float*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector float,int,volatile vector float*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector float,int,const volatile vector float*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector float,int,float*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector float,int,const float*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector float,int,volatile float*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector float,int,const volatile float*)
#ifdef __64BIT__
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector unsigned char,long,vector unsigned char*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector unsigned char,long,const vector unsigned char*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector unsigned char,long,volatile vector unsigned char*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector unsigned char,long,const volatile vector unsigned char*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector unsigned char,long,unsigned char*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector unsigned char,long,const unsigned char*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector unsigned char,long,volatile unsigned char*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector unsigned char,long,const volatile unsigned char*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector signed char,long,vector signed char*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector signed char,long,const vector signed char*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector signed char,long,volatile vector signed char*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector signed char,long,const volatile vector signed char*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector signed char,long,signed char*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector signed char,long,const signed char*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector signed char,long,volatile signed char*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector signed char,long,const volatile signed char*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector bool char,long,vector bool char*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector bool char,long,const vector bool char*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector bool char,long,volatile vector bool char*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector bool char,long,const volatile vector bool char*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector unsigned short,long,vector unsigned short*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector unsigned short,long,const vector unsigned short*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector unsigned short,long,volatile vector unsigned short*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector unsigned short,long,const volatile vector unsigned short*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector unsigned short,long,unsigned short*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector unsigned short,long,const unsigned short*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector unsigned short,long,volatile unsigned short*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector unsigned short,long,const volatile unsigned short*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector signed short,long,vector signed short*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector signed short,long,const vector signed short*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector signed short,long,volatile vector signed short*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector signed short,long,const volatile vector signed short*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector signed short,long,signed short*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector signed short,long,const signed short*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector signed short,long,volatile signed short*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector signed short,long,const volatile signed short*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector bool short,long,vector bool short*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector bool short,long,const vector bool short*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector bool short,long,volatile vector bool short*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector bool short,long,const volatile vector bool short*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector pixel,long,vector pixel*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector pixel,long,const vector pixel*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector pixel,long,volatile vector pixel*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector pixel,long,const volatile vector pixel*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector unsigned int,long,vector unsigned int*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector unsigned int,long,const vector unsigned int*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector unsigned int,long,volatile vector unsigned int*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector unsigned int,long,const volatile vector unsigned int*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector unsigned int,long,unsigned int*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector unsigned int,long,const unsigned int*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector unsigned int,long,volatile unsigned int*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector unsigned int,long,const volatile unsigned int*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector signed int,long,vector signed int*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector signed int,long,const vector signed int*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector signed int,long,volatile vector signed int*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector signed int,long,const volatile vector signed int*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector signed int,long,signed int*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector signed int,long,const signed int*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector signed int,long,volatile signed int*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector signed int,long,const volatile signed int*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector bool int,long,vector bool int*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector bool int,long,const vector bool int*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector bool int,long,volatile vector bool int*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector bool int,long,const volatile vector bool int*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector float,long,vector float*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector float,long,const vector float*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector float,long,volatile vector float*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector float,long,const volatile vector float*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector float,long,float*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector float,long,const float*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector float,long,volatile float*)
#pragma tg_funcdef(vec_lvlxl,__vec_lvlxl,vector float,long,const volatile float*)
#endif /* __64BIT__ */
#define vec_lvlxl(a,b)  __tg_builtin("vec_lvlxl",a,b)

/* vec_lvrx */
#pragma tg_funcdef(vec_lvrx,__vec_lvrx,vector unsigned char,int,vector unsigned char*)
#pragma tg_funcdef(vec_lvrx,__vec_lvrx,vector unsigned char,int,unsigned char*)
#pragma tg_funcdef(vec_lvrx,__vec_lvrx,vector signed char,int,vector signed char*)
#pragma tg_funcdef(vec_lvrx,__vec_lvrx,vector signed char,int,signed char*)
#pragma tg_funcdef(vec_lvrx,__vec_lvrx,vector bool char,int,vector bool char*)
#pragma tg_funcdef(vec_lvrx,__vec_lvrx,vector unsigned short,int,vector unsigned short*)
#pragma tg_funcdef(vec_lvrx,__vec_lvrx,vector unsigned short,int,unsigned short*)
#pragma tg_funcdef(vec_lvrx,__vec_lvrx,vector signed short,int,vector signed short*)
#pragma tg_funcdef(vec_lvrx,__vec_lvrx,vector signed short,int,signed short*)
#pragma tg_funcdef(vec_lvrx,__vec_lvrx,vector bool short,int,vector bool short*)
#pragma tg_funcdef(vec_lvrx,__vec_lvrx,vector pixel,int,vector pixel*)
#pragma tg_funcdef(vec_lvrx,__vec_lvrx,vector unsigned int,int,vector unsigned int*)
#pragma tg_funcdef(vec_lvrx,__vec_lvrx,vector unsigned int,int,unsigned int*)
#pragma tg_funcdef(vec_lvrx,__vec_lvrx,vector signed int,int,vector signed int*)
#pragma tg_funcdef(vec_lvrx,__vec_lvrx,vector signed int,int,signed int*)
#ifndef __64BIT__
#pragma tg_funcdef(vec_lvrx,__vec_lvrx,vector unsigned int,int,unsigned long*)
#pragma tg_funcdef(vec_lvrx,__vec_lvrx,vector signed int,int,signed long*)
#endif /* __64BIT__ */
#pragma tg_funcdef(vec_lvrx,__vec_lvrx,vector bool int,int,vector bool int*)
#pragma tg_funcdef(vec_lvrx,__vec_lvrx,vector float,int,vector float*)
#pragma tg_funcdef(vec_lvrx,__vec_lvrx,vector float,int,float*)
#ifdef __64BIT__
#pragma tg_funcdef(vec_lvrx,__vec_lvrx,vector unsigned char,long,vector unsigned char*)
#pragma tg_funcdef(vec_lvrx,__vec_lvrx,vector unsigned char,long,unsigned char*)
#pragma tg_funcdef(vec_lvrx,__vec_lvrx,vector signed char,long,vector signed char*)
#pragma tg_funcdef(vec_lvrx,__vec_lvrx,vector signed char,long,signed char*)
#pragma tg_funcdef(vec_lvrx,__vec_lvrx,vector bool char,long,vector bool char*)
#pragma tg_funcdef(vec_lvrx,__vec_lvrx,vector unsigned short,long,vector unsigned short*)
#pragma tg_funcdef(vec_lvrx,__vec_lvrx,vector unsigned short,long,unsigned short*)
#pragma tg_funcdef(vec_lvrx,__vec_lvrx,vector signed short,long,vector signed short*)
#pragma tg_funcdef(vec_lvrx,__vec_lvrx,vector signed short,long,signed short*)
#pragma tg_funcdef(vec_lvrx,__vec_lvrx,vector bool short,long,vector bool short*)
#pragma tg_funcdef(vec_lvrx,__vec_lvrx,vector pixel,long,vector pixel*)
#pragma tg_funcdef(vec_lvrx,__vec_lvrx,vector unsigned int,long,vector unsigned int*)
#pragma tg_funcdef(vec_lvrx,__vec_lvrx,vector unsigned int,long,unsigned int*)
#pragma tg_funcdef(vec_lvrx,__vec_lvrx,vector signed int,long,vector signed int*)
#pragma tg_funcdef(vec_lvrx,__vec_lvrx,vector signed int,long,signed int*)
#pragma tg_funcdef(vec_lvrx,__vec_lvrx,vector bool int,long,vector bool int*)
#pragma tg_funcdef(vec_lvrx,__vec_lvrx,vector float,long,vector float*)
#pragma tg_funcdef(vec_lvrx,__vec_lvrx,vector float,long,float*)
#endif /* __64BIT__ */
#define vec_lvrx(a,b)  __tg_builtin("vec_lvrx",a,b)

/* vec_lvrxl */
#pragma tg_funcdef(vec_lvrxl,__vec_lvrxl,vector unsigned char,int,vector unsigned char*)
#pragma tg_funcdef(vec_lvrxl,__vec_lvrxl,vector unsigned char,int,unsigned char*)
#pragma tg_funcdef(vec_lvrxl,__vec_lvrxl,vector signed char,int,vector signed char*)
#pragma tg_funcdef(vec_lvrxl,__vec_lvrxl,vector signed char,int,signed char*)
#pragma tg_funcdef(vec_lvrxl,__vec_lvrxl,vector bool char,int,vector bool char*)
#pragma tg_funcdef(vec_lvrxl,__vec_lvrxl,vector unsigned short,int,vector unsigned short*)
#pragma tg_funcdef(vec_lvrxl,__vec_lvrxl,vector unsigned short,int,unsigned short*)
#pragma tg_funcdef(vec_lvrxl,__vec_lvrxl,vector signed short,int,vector signed short*)
#pragma tg_funcdef(vec_lvrxl,__vec_lvrxl,vector signed short,int,signed short*)
#pragma tg_funcdef(vec_lvrxl,__vec_lvrxl,vector bool short,int,vector bool short*)
#pragma tg_funcdef(vec_lvrxl,__vec_lvrxl,vector pixel,int,vector pixel*)
#pragma tg_funcdef(vec_lvrxl,__vec_lvrxl,vector unsigned int,int,vector unsigned int*)
#pragma tg_funcdef(vec_lvrxl,__vec_lvrxl,vector unsigned int,int,unsigned int*)
#pragma tg_funcdef(vec_lvrxl,__vec_lvrxl,vector signed int,int,vector signed int*)
#pragma tg_funcdef(vec_lvrxl,__vec_lvrxl,vector signed int,int,signed int*)
#ifndef __64BIT__
#pragma tg_funcdef(vec_lvrxl,__vec_lvrxl,vector unsigned int,int,unsigned long*)
#pragma tg_funcdef(vec_lvrxl,__vec_lvrxl,vector signed int,int,signed long*)
#endif /* __64BIT__ */
#pragma tg_funcdef(vec_lvrxl,__vec_lvrxl,vector bool int,int,vector bool int*)
#pragma tg_funcdef(vec_lvrxl,__vec_lvrxl,vector float,int,vector float*)
#pragma tg_funcdef(vec_lvrxl,__vec_lvrxl,vector float,int,float*)
#ifdef __64BIT__
#pragma tg_funcdef(vec_lvrxl,__vec_lvrxl,vector unsigned char,long,vector unsigned char*)
#pragma tg_funcdef(vec_lvrxl,__vec_lvrxl,vector unsigned char,long,unsigned char*)
#pragma tg_funcdef(vec_lvrxl,__vec_lvrxl,vector signed char,long,vector signed char*)
#pragma tg_funcdef(vec_lvrxl,__vec_lvrxl,vector signed char,long,signed char*)
#pragma tg_funcdef(vec_lvrxl,__vec_lvrxl,vector bool char,long,vector bool char*)
#pragma tg_funcdef(vec_lvrxl,__vec_lvrxl,vector unsigned short,long,vector unsigned short*)
#pragma tg_funcdef(vec_lvrxl,__vec_lvrxl,vector unsigned short,long,unsigned short*)
#pragma tg_funcdef(vec_lvrxl,__vec_lvrxl,vector signed short,long,vector signed short*)
#pragma tg_funcdef(vec_lvrxl,__vec_lvrxl,vector signed short,long,signed short*)
#pragma tg_funcdef(vec_lvrxl,__vec_lvrxl,vector bool short,long,vector bool short*)
#pragma tg_funcdef(vec_lvrxl,__vec_lvrxl,vector pixel,long,vector pixel*)
#pragma tg_funcdef(vec_lvrxl,__vec_lvrxl,vector unsigned int,long,vector unsigned int*)
#pragma tg_funcdef(vec_lvrxl,__vec_lvrxl,vector unsigned int,long,unsigned int*)
#pragma tg_funcdef(vec_lvrxl,__vec_lvrxl,vector signed int,long,vector signed int*)
#pragma tg_funcdef(vec_lvrxl,__vec_lvrxl,vector signed int,long,signed int*)
#pragma tg_funcdef(vec_lvrxl,__vec_lvrxl,vector bool int,long,vector bool int*)
#pragma tg_funcdef(vec_lvrxl,__vec_lvrxl,vector float,long,vector float*)
#pragma tg_funcdef(vec_lvrxl,__vec_lvrxl,vector float,long,float*)
#endif /* __64BIT__ */
#define vec_lvrxl(a,b)  __tg_builtin("vec_lvrxl",a,b)

/* vec_lvsl */
#pragma tg_funcdef(vec_lvsl,__vec_lvsl,vector unsigned char,int,unsigned char*)
#pragma tg_funcdef(vec_lvsl,__vec_lvsl,vector unsigned char,int,signed char*)
#pragma tg_funcdef(vec_lvsl,__vec_lvsl,vector unsigned char,int,unsigned short*)
#pragma tg_funcdef(vec_lvsl,__vec_lvsl,vector unsigned char,int,short*)
#pragma tg_funcdef(vec_lvsl,__vec_lvsl,vector unsigned char,int,unsigned int*)
#pragma tg_funcdef(vec_lvsl,__vec_lvsl,vector unsigned char,int,int*)
#ifndef __64BIT__
#pragma tg_funcdef(vec_lvsl,__vec_lvsl,vector unsigned char,int,unsigned long*)
#pragma tg_funcdef(vec_lvsl,__vec_lvsl,vector unsigned char,int,long*)
#endif /* __64BIT__ */
#pragma tg_funcdef(vec_lvsl,__vec_lvsl,vector unsigned char,int,float*)
#ifdef __64BIT__
#pragma tg_funcdef(vec_lvsl,__vec_lvsl,vector unsigned char,long,unsigned char*)
#pragma tg_funcdef(vec_lvsl,__vec_lvsl,vector unsigned char,long,signed char*)
#pragma tg_funcdef(vec_lvsl,__vec_lvsl,vector unsigned char,long,unsigned short*)
#pragma tg_funcdef(vec_lvsl,__vec_lvsl,vector unsigned char,long,short*)
#pragma tg_funcdef(vec_lvsl,__vec_lvsl,vector unsigned char,long,unsigned int*)
#pragma tg_funcdef(vec_lvsl,__vec_lvsl,vector unsigned char,long,int*)
#pragma tg_funcdef(vec_lvsl,__vec_lvsl,vector unsigned char,long,float*)
#endif /* __64BIT__ */
#define vec_lvsl(a,b)  __tg_builtin("vec_lvsl",a,b)

/* vec_lvsr */
#pragma tg_funcdef(vec_lvsr,__vec_lvsr,vector unsigned char,int,unsigned char*)
#pragma tg_funcdef(vec_lvsr,__vec_lvsr,vector unsigned char,int,signed char*)
#pragma tg_funcdef(vec_lvsr,__vec_lvsr,vector unsigned char,int,unsigned short*)
#pragma tg_funcdef(vec_lvsr,__vec_lvsr,vector unsigned char,int,short*)
#pragma tg_funcdef(vec_lvsr,__vec_lvsr,vector unsigned char,int,unsigned int*)
#pragma tg_funcdef(vec_lvsr,__vec_lvsr,vector unsigned char,int,int*)
#ifndef __64BIT__
#pragma tg_funcdef(vec_lvsr,__vec_lvsr,vector unsigned char,int,unsigned long*)
#pragma tg_funcdef(vec_lvsr,__vec_lvsr,vector unsigned char,int,long*)
#endif /* __64BIT__ */
#pragma tg_funcdef(vec_lvsr,__vec_lvsr,vector unsigned char,int,float*)
#ifdef __64BIT__
#pragma tg_funcdef(vec_lvsr,__vec_lvsr,vector unsigned char,long,unsigned char*)
#pragma tg_funcdef(vec_lvsr,__vec_lvsr,vector unsigned char,long,signed char*)
#pragma tg_funcdef(vec_lvsr,__vec_lvsr,vector unsigned char,long,unsigned short*)
#pragma tg_funcdef(vec_lvsr,__vec_lvsr,vector unsigned char,long,short*)
#pragma tg_funcdef(vec_lvsr,__vec_lvsr,vector unsigned char,long,unsigned int*)
#pragma tg_funcdef(vec_lvsr,__vec_lvsr,vector unsigned char,long,int*)
#pragma tg_funcdef(vec_lvsr,__vec_lvsr,vector unsigned char,long,float*)
#endif /* __64BIT__ */
#define vec_lvsr(a,b)  __tg_builtin("vec_lvsr",a,b)

/* vec_vmaddfp */
#pragma tg_funcdef(vec_vmaddfp,__vec_madd,vector float,vector float,vector float,vector float)
#define vec_vmaddfp(a,b,c)  __tg_builtin("vec_vmaddfp",a,b,c)

/* vec_madd */
#define vec_madd(a,b,c)  __vec_madd(a,b,c)

/* vec_vmhaddshs */
#pragma tg_funcdef(vec_vmhaddshs,__vec_madds,vector signed short,vector signed short,vector signed short,vector signed short)
#define vec_vmhaddshs(a,b,c)  __tg_builtin("vec_vmhaddshs",a,b,c)

/* vec_madds */
#define vec_madds(a,b,c)  __vec_madds(a,b,c)

/* vec_vmaxub */
#pragma tg_funcdef(vec_vmaxub,__vec_max,vector unsigned char,vector unsigned char,vector unsigned char)
#pragma tg_funcdef(vec_vmaxub,__vec_max,vector unsigned char,vector unsigned char,vector bool char)
#pragma tg_funcdef(vec_vmaxub,__vec_max,vector unsigned char,vector bool char,vector unsigned char)
#define vec_vmaxub(a,b)  __tg_builtin("vec_vmaxub",a,b)

/* vec_vmaxsb */
#pragma tg_funcdef(vec_vmaxsb,__vec_max,vector signed char,vector signed char,vector signed char)
#pragma tg_funcdef(vec_vmaxsb,__vec_max,vector signed char,vector signed char,vector bool char)
#pragma tg_funcdef(vec_vmaxsb,__vec_max,vector signed char,vector bool char,vector signed char)
#define vec_vmaxsb(a,b)  __tg_builtin("vec_vmaxsb",a,b)

/* vec_vmaxuh */
#pragma tg_funcdef(vec_vmaxuh,__vec_max,vector unsigned short,vector unsigned short,vector unsigned short)
#pragma tg_funcdef(vec_vmaxuh,__vec_max,vector unsigned short,vector unsigned short,vector bool short)
#pragma tg_funcdef(vec_vmaxuh,__vec_max,vector unsigned short,vector bool short,vector unsigned short)
#define vec_vmaxuh(a,b)  __tg_builtin("vec_vmaxuh",a,b)

/* vec_vmaxsh */
#pragma tg_funcdef(vec_vmaxsh,__vec_max,vector signed short,vector signed short,vector signed short)
#pragma tg_funcdef(vec_vmaxsh,__vec_max,vector signed short,vector signed short,vector bool short)
#pragma tg_funcdef(vec_vmaxsh,__vec_max,vector signed short,vector bool short,vector signed short)
#define vec_vmaxsh(a,b)  __tg_builtin("vec_vmaxsh",a,b)

/* vec_vmaxuw */
#pragma tg_funcdef(vec_vmaxuw,__vec_max,vector unsigned int,vector unsigned int,vector unsigned int)
#pragma tg_funcdef(vec_vmaxuw,__vec_max,vector unsigned int,vector unsigned int,vector bool int)
#pragma tg_funcdef(vec_vmaxuw,__vec_max,vector unsigned int,vector bool int,vector unsigned int)
#define vec_vmaxuw(a,b)  __tg_builtin("vec_vmaxuw",a,b)

/* vec_vmaxsw */
#pragma tg_funcdef(vec_vmaxsw,__vec_max,vector signed int,vector signed int,vector signed int)
#pragma tg_funcdef(vec_vmaxsw,__vec_max,vector signed int,vector signed int,vector bool int)
#pragma tg_funcdef(vec_vmaxsw,__vec_max,vector signed int,vector bool int,vector signed int)
#define vec_vmaxsw(a,b)  __tg_builtin("vec_vmaxsw",a,b)

/* vec_vmaxfp */
#pragma tg_funcdef(vec_vmaxfp,__vec_max,vector float,vector float,vector float)
#define vec_vmaxfp(a,b)  __tg_builtin("vec_vmaxfp",a,b)

/* vec_max */
#pragma tg_funcdef(vec_max,__vec_max,vector unsigned char,vector unsigned char,vector unsigned char)
#pragma tg_funcdef(vec_max,__vec_max,vector unsigned char,vector unsigned char,vector bool char)
#pragma tg_funcdef(vec_max,__vec_max,vector unsigned char,vector bool char,vector unsigned char)
#pragma tg_funcdef(vec_max,__vec_max,vector signed char,vector signed char,vector signed char)
#pragma tg_funcdef(vec_max,__vec_max,vector signed char,vector signed char,vector bool char)
#pragma tg_funcdef(vec_max,__vec_max,vector signed char,vector bool char,vector signed char)
#pragma tg_funcdef(vec_max,__vec_max,vector unsigned short,vector unsigned short,vector unsigned short)
#pragma tg_funcdef(vec_max,__vec_max,vector unsigned short,vector unsigned short,vector bool short)
#pragma tg_funcdef(vec_max,__vec_max,vector unsigned short,vector bool short,vector unsigned short)
#pragma tg_funcdef(vec_max,__vec_max,vector signed short,vector signed short,vector signed short)
#pragma tg_funcdef(vec_max,__vec_max,vector signed short,vector signed short,vector bool short)
#pragma tg_funcdef(vec_max,__vec_max,vector signed short,vector bool short,vector signed short)
#pragma tg_funcdef(vec_max,__vec_max,vector unsigned int,vector unsigned int,vector unsigned int)
#pragma tg_funcdef(vec_max,__vec_max,vector unsigned int,vector unsigned int,vector bool int)
#pragma tg_funcdef(vec_max,__vec_max,vector unsigned int,vector bool int,vector unsigned int)
#pragma tg_funcdef(vec_max,__vec_max,vector signed int,vector signed int,vector signed int)
#pragma tg_funcdef(vec_max,__vec_max,vector signed int,vector signed int,vector bool int)
#pragma tg_funcdef(vec_max,__vec_max,vector signed int,vector bool int,vector signed int)
#pragma tg_funcdef(vec_max,__vec_max,vector float,vector float,vector float)
#define vec_max(a,b)  __tg_builtin("vec_max",a,b)

/* vec_vmrghb */
#pragma tg_funcdef(vec_vmrghb,__vec_mergeh,vector unsigned char,vector unsigned char,vector unsigned char)
#pragma tg_funcdef(vec_vmrghb,__vec_mergeh,vector signed char,vector signed char,vector signed char)
#pragma tg_funcdef(vec_vmrghb,__vec_mergeh,vector bool char,vector bool char,vector bool char)
#define vec_vmrghb(a,b)  __tg_builtin("vec_vmrghb",a,b)

/* vec_vmrghh */
#pragma tg_funcdef(vec_vmrghh,__vec_mergeh,vector unsigned short,vector unsigned short,vector unsigned short)
#pragma tg_funcdef(vec_vmrghh,__vec_mergeh,vector signed short,vector signed short,vector signed short)
#pragma tg_funcdef(vec_vmrghh,__vec_mergeh,vector bool short,vector bool short,vector bool short)
#pragma tg_funcdef(vec_vmrghh,__vec_mergeh,vector pixel,vector pixel,vector pixel)
#define vec_vmrghh(a,b)  __tg_builtin("vec_vmrghh",a,b)

/* vec_vmrghw */
#pragma tg_funcdef(vec_vmrghw,__vec_mergeh,vector unsigned int,vector unsigned int,vector unsigned int)
#pragma tg_funcdef(vec_vmrghw,__vec_mergeh,vector signed int,vector signed int,vector signed int)
#pragma tg_funcdef(vec_vmrghw,__vec_mergeh,vector bool int,vector bool int,vector bool int)
#pragma tg_funcdef(vec_vmrghw,__vec_mergeh,vector float,vector float,vector float)
#define vec_vmrghw(a,b)  __tg_builtin("vec_vmrghw",a,b)

/* vec_mergeh */
#pragma tg_funcdef(vec_mergeh,__vec_mergeh,vector unsigned char,vector unsigned char,vector unsigned char)
#pragma tg_funcdef(vec_mergeh,__vec_mergeh,vector signed char,vector signed char,vector signed char)
#pragma tg_funcdef(vec_mergeh,__vec_mergeh,vector bool char,vector bool char,vector bool char)
#pragma tg_funcdef(vec_mergeh,__vec_mergeh,vector unsigned short,vector unsigned short,vector unsigned short)
#pragma tg_funcdef(vec_mergeh,__vec_mergeh,vector signed short,vector signed short,vector signed short)
#pragma tg_funcdef(vec_mergeh,__vec_mergeh,vector bool short,vector bool short,vector bool short)
#pragma tg_funcdef(vec_mergeh,__vec_mergeh,vector pixel,vector pixel,vector pixel)
#pragma tg_funcdef(vec_mergeh,__vec_mergeh,vector unsigned int,vector unsigned int,vector unsigned int)
#pragma tg_funcdef(vec_mergeh,__vec_mergeh,vector signed int,vector signed int,vector signed int)
#pragma tg_funcdef(vec_mergeh,__vec_mergeh,vector bool int,vector bool int,vector bool int)
#pragma tg_funcdef(vec_mergeh,__vec_mergeh,vector float,vector float,vector float)
#define vec_mergeh(a,b)  __tg_builtin("vec_mergeh",a,b)

/* vec_vmrglb */
#pragma tg_funcdef(vec_vmrglb,__vec_mergel,vector unsigned char,vector unsigned char,vector unsigned char)
#pragma tg_funcdef(vec_vmrglb,__vec_mergel,vector signed char,vector signed char,vector signed char)
#pragma tg_funcdef(vec_vmrglb,__vec_mergel,vector bool char,vector bool char,vector bool char)
#define vec_vmrglb(a,b)  __tg_builtin("vec_vmrglb",a,b)

/* vec_vmrglh */
#pragma tg_funcdef(vec_vmrglh,__vec_mergel,vector unsigned short,vector unsigned short,vector unsigned short)
#pragma tg_funcdef(vec_vmrglh,__vec_mergel,vector signed short,vector signed short,vector signed short)
#pragma tg_funcdef(vec_vmrglh,__vec_mergel,vector bool short,vector bool short,vector bool short)
#pragma tg_funcdef(vec_vmrglh,__vec_mergel,vector pixel,vector pixel,vector pixel)
#define vec_vmrglh(a,b)  __tg_builtin("vec_vmrglh",a,b)

/* vec_vmrglw */
#pragma tg_funcdef(vec_vmrglw,__vec_mergel,vector unsigned int,vector unsigned int,vector unsigned int)
#pragma tg_funcdef(vec_vmrglw,__vec_mergel,vector signed int,vector signed int,vector signed int)
#pragma tg_funcdef(vec_vmrglw,__vec_mergel,vector bool int,vector bool int,vector bool int)
#pragma tg_funcdef(vec_vmrglw,__vec_mergel,vector float,vector float,vector float)
#define vec_vmrglw(a,b)  __tg_builtin("vec_vmrglw",a,b)

/* vec_mergel */
#pragma tg_funcdef(vec_mergel,__vec_mergel,vector unsigned char,vector unsigned char,vector unsigned char)
#pragma tg_funcdef(vec_mergel,__vec_mergel,vector signed char,vector signed char,vector signed char)
#pragma tg_funcdef(vec_mergel,__vec_mergel,vector bool char,vector bool char,vector bool char)
#pragma tg_funcdef(vec_mergel,__vec_mergel,vector unsigned short,vector unsigned short,vector unsigned short)
#pragma tg_funcdef(vec_mergel,__vec_mergel,vector signed short,vector signed short,vector signed short)
#pragma tg_funcdef(vec_mergel,__vec_mergel,vector bool short,vector bool short,vector bool short)
#pragma tg_funcdef(vec_mergel,__vec_mergel,vector pixel,vector pixel,vector pixel)
#pragma tg_funcdef(vec_mergel,__vec_mergel,vector unsigned int,vector unsigned int,vector unsigned int)
#pragma tg_funcdef(vec_mergel,__vec_mergel,vector signed int,vector signed int,vector signed int)
#pragma tg_funcdef(vec_mergel,__vec_mergel,vector bool int,vector bool int,vector bool int)
#pragma tg_funcdef(vec_mergel,__vec_mergel,vector float,vector float,vector float)
#define vec_mergel(a,b)  __tg_builtin("vec_mergel",a,b)

/* vec_mfvscr */
#define vec_mfvscr() __vec_mfvscr()

/* vec_vminub */
#pragma tg_funcdef(vec_vminub,__vec_min,vector unsigned char,vector unsigned char,vector unsigned char)
#pragma tg_funcdef(vec_vminub,__vec_min,vector unsigned char,vector unsigned char,vector bool char)
#pragma tg_funcdef(vec_vminub,__vec_min,vector unsigned char,vector bool char,vector unsigned char)
#define vec_vminub(a,b)  __tg_builtin("vec_vminub",a,b)

/* vec_vminsb */
#pragma tg_funcdef(vec_vminsb,__vec_min,vector signed char,vector signed char,vector signed char)
#pragma tg_funcdef(vec_vminsb,__vec_min,vector signed char,vector signed char,vector bool char)
#pragma tg_funcdef(vec_vminsb,__vec_min,vector signed char,vector bool char,vector signed char)
#define vec_vminsb(a,b)  __tg_builtin("vec_vminsb",a,b)

/* vec_vminuh */
#pragma tg_funcdef(vec_vminuh,__vec_min,vector unsigned short,vector unsigned short,vector unsigned short)
#pragma tg_funcdef(vec_vminuh,__vec_min,vector unsigned short,vector unsigned short,vector bool short)
#pragma tg_funcdef(vec_vminuh,__vec_min,vector unsigned short,vector bool short,vector unsigned short)
#define vec_vminuh(a,b)  __tg_builtin("vec_vminuh",a,b)

/* vec_vminsh */
#pragma tg_funcdef(vec_vminsh,__vec_min,vector signed short,vector signed short,vector signed short)
#pragma tg_funcdef(vec_vminsh,__vec_min,vector signed short,vector signed short,vector bool short)
#pragma tg_funcdef(vec_vminsh,__vec_min,vector signed short,vector bool short,vector signed short)
#define vec_vminsh(a,b)  __tg_builtin("vec_vminsh",a,b)

/* vec_vminuw */
#pragma tg_funcdef(vec_vminuw,__vec_min,vector unsigned int,vector unsigned int,vector unsigned int)
#pragma tg_funcdef(vec_vminuw,__vec_min,vector unsigned int,vector unsigned int,vector bool int)
#pragma tg_funcdef(vec_vminuw,__vec_min,vector unsigned int,vector bool int,vector unsigned int)
#define vec_vminuw(a,b)  __tg_builtin("vec_vminuw",a,b)

/* vec_vminsw */
#pragma tg_funcdef(vec_vminsw,__vec_min,vector signed int,vector signed int,vector signed int)
#pragma tg_funcdef(vec_vminsw,__vec_min,vector signed int,vector signed int,vector bool int)
#pragma tg_funcdef(vec_vminsw,__vec_min,vector signed int,vector bool int,vector signed int)
#define vec_vminsw(a,b)  __tg_builtin("vec_vminsw",a,b)

/* vec_vminfp */
#pragma tg_funcdef(vec_vminfp,__vec_min,vector float,vector float,vector float)
#define vec_vminfp(a,b)  __tg_builtin("vec_vminfp",a,b)

/* vec_min */
#pragma tg_funcdef(vec_min,__vec_min,vector unsigned char,vector unsigned char,vector unsigned char)
#pragma tg_funcdef(vec_min,__vec_min,vector unsigned char,vector unsigned char,vector bool char)
#pragma tg_funcdef(vec_min,__vec_min,vector unsigned char,vector bool char,vector unsigned char)
#pragma tg_funcdef(vec_min,__vec_min,vector signed char,vector signed char,vector signed char)
#pragma tg_funcdef(vec_min,__vec_min,vector signed char,vector signed char,vector bool char)
#pragma tg_funcdef(vec_min,__vec_min,vector signed char,vector bool char,vector signed char)
#pragma tg_funcdef(vec_min,__vec_min,vector unsigned int,vector unsigned int,vector unsigned int)
#pragma tg_funcdef(vec_min,__vec_min,vector unsigned int,vector unsigned int,vector bool int)
#pragma tg_funcdef(vec_min,__vec_min,vector unsigned int,vector bool int,vector unsigned int)
#pragma tg_funcdef(vec_min,__vec_min,vector signed int,vector signed int,vector signed int)
#pragma tg_funcdef(vec_min,__vec_min,vector signed int,vector signed int,vector bool int)
#pragma tg_funcdef(vec_min,__vec_min,vector signed int,vector bool int,vector signed int)
#pragma tg_funcdef(vec_min,__vec_min,vector unsigned short,vector unsigned short,vector unsigned short)
#pragma tg_funcdef(vec_min,__vec_min,vector unsigned short,vector unsigned short,vector bool short)
#pragma tg_funcdef(vec_min,__vec_min,vector unsigned short,vector bool short,vector unsigned short)
#pragma tg_funcdef(vec_min,__vec_min,vector signed short,vector signed short,vector signed short)
#pragma tg_funcdef(vec_min,__vec_min,vector signed short,vector signed short,vector bool short)
#pragma tg_funcdef(vec_min,__vec_min,vector signed short,vector bool short,vector signed short)
#pragma tg_funcdef(vec_min,__vec_min,vector float,vector float,vector float)
#define vec_min(a,b)  __tg_builtin("vec_min",a,b)

/* vec_vmladduhm */
#pragma tg_funcdef(vec_vmladduhm,__vec_mladd,vector unsigned short,vector unsigned short,vector unsigned short,vector unsigned short)
#pragma tg_funcdef(vec_vmladduhm,__vec_mladd,vector signed short,vector unsigned short,vector signed short,vector signed short)
#pragma tg_funcdef(vec_vmladduhm,__vec_mladd,vector signed short,vector signed short,vector unsigned short,vector unsigned short)
#pragma tg_funcdef(vec_vmladduhm,__vec_mladd,vector signed short,vector signed short,vector signed short,vector signed short)
#define vec_vmladduhm(a,b,c)  __tg_builtin("vec_vmladduhm",a,b,c)

/* vec_mladd */
#pragma tg_funcdef(vec_mladd,__vec_mladd,vector unsigned short,vector unsigned short,vector unsigned short,vector unsigned short)
#pragma tg_funcdef(vec_mladd,__vec_mladd,vector signed short,vector unsigned short,vector signed short,vector signed short)
#pragma tg_funcdef(vec_mladd,__vec_mladd,vector signed short,vector signed short,vector unsigned short,vector unsigned short)
#pragma tg_funcdef(vec_mladd,__vec_mladd,vector signed short,vector signed short,vector signed short,vector signed short)
#define vec_mladd(a,b,c)  __tg_builtin("vec_mladd",a,b,c)

/* vec_vmhraddshs */
#pragma tg_funcdef(vec_vmhraddshs,__vec_mradds,vector signed short,vector signed short,vector signed short,vector signed short)
#define vec_vmhraddshs(a,b,c)  __tg_builtin("vec_vmhraddshs",a,b,c)

/* vec_mradds */
#define vec_mradds(a,b,c)  __vec_mradds(a,b,c)

/* vec_vmsumubm */
#pragma tg_funcdef(vec_vmsumubm,__vec_msum,vector unsigned int,vector unsigned char,vector unsigned char,vector unsigned int)
#define vec_vmsumubm(a,b,c)  __tg_builtin("vec_vmsumubm",a,b,c)

/* vec_vmsummbm */
#pragma tg_funcdef(vec_vmsummbm,__vec_msum,vector signed int,vector signed char,vector unsigned char,vector signed int)
#define vec_vmsummbm(a,b,c)  __tg_builtin("vec_vmsummbm",a,b,c)

/* vec_vmsumuhm */
#pragma tg_funcdef(vec_vmsumuhm,__vec_msum,vector unsigned int,vector unsigned short,vector unsigned short,vector unsigned int)
#define vec_vmsumuhm(a,b,c)  __tg_builtin("vec_vmsumuhm",a,b,c)

/* vec_vmsumshm */
#pragma tg_funcdef(vec_vmsumshm,__vec_msum,vector signed int,vector signed short,vector signed short,vector signed int)
#define vec_vmsumshm(a,b,c)  __tg_builtin("vec_vmsumshm",a,b,c)

/* vec_msum */
#pragma tg_funcdef(vec_msum,__vec_msum,vector unsigned int,vector unsigned char,vector unsigned char,vector unsigned int)
#pragma tg_funcdef(vec_msum,__vec_msum,vector signed int,vector signed char,vector unsigned char,vector signed int)
#pragma tg_funcdef(vec_msum,__vec_msum,vector unsigned int,vector unsigned short,vector unsigned short,vector unsigned int)
#pragma tg_funcdef(vec_msum,__vec_msum,vector signed int,vector signed short,vector signed short,vector signed int)
#define vec_msum(a,b,c)  __tg_builtin("vec_msum",a,b,c)

/* vec_vmsumuhs */
#pragma tg_funcdef(vec_vmsumuhs,__vec_msums,vector unsigned int,vector unsigned short,vector unsigned short,vector unsigned int)
#define vec_vmsumuhs(a,b,c)  __tg_builtin("vec_vmsumuhs",a,b,c)

/* vec_vmsumshs */
#pragma tg_funcdef(vec_vmsumshs,__vec_msums,vector signed int,vector signed short,vector signed short,vector signed int)
#define vec_vmsumshs(a,b,c)  __tg_builtin("vec_vmsumshs",a,b,c)

/* vec_msums */
#pragma tg_funcdef(vec_msums,__vec_msums,vector unsigned int,vector unsigned short,vector unsigned short,vector unsigned int)
#pragma tg_funcdef(vec_msums,__vec_msums,vector signed int,vector signed short,vector signed short,vector signed int)
#define vec_msums(a,b,c)  __tg_builtin("vec_msums",a,b,c)

/* vec_mtvscr */
#pragma tg_funcdef(vec_mtvscr,__vec_mtvscr,void,vector unsigned char)
#pragma tg_funcdef(vec_mtvscr,__vec_mtvscr,void,vector signed char)
#pragma tg_funcdef(vec_mtvscr,__vec_mtvscr,void,vector bool char)
#pragma tg_funcdef(vec_mtvscr,__vec_mtvscr,void,vector unsigned short)
#pragma tg_funcdef(vec_mtvscr,__vec_mtvscr,void,vector signed short)
#pragma tg_funcdef(vec_mtvscr,__vec_mtvscr,void,vector bool short)
#pragma tg_funcdef(vec_mtvscr,__vec_mtvscr,void,vector pixel)
#pragma tg_funcdef(vec_mtvscr,__vec_mtvscr,void,vector unsigned int)
#pragma tg_funcdef(vec_mtvscr,__vec_mtvscr,void,vector signed int)
#pragma tg_funcdef(vec_mtvscr,__vec_mtvscr,void,vector bool int)
#define vec_mtvscr(a)  __tg_builtin("vec_mtvscr",a)

/* vec_vmuleub */
#pragma tg_funcdef(vec_vmuleub,__vec_mule,vector unsigned short,vector unsigned char,vector unsigned char)
#define vec_vmuleub(a,b)  __tg_builtin("vec_vmuleub",a,b)

/* vec_vmulesb */
#pragma tg_funcdef(vec_vmulesb,__vec_mule,vector signed short,vector signed char,vector signed char)
#define vec_vmulesb(a,b)  __tg_builtin("vec_vmulesb",a,b)

/* vec_vmuleuh */
#pragma tg_funcdef(vec_vmuleuh,__vec_mule,vector unsigned int,vector unsigned short,vector unsigned short)
#define vec_vmuleuh(a,b)  __tg_builtin("vec_vmuleuh",a,b)

/* vec_vmulesh */
#pragma tg_funcdef(vec_vmulesh,__vec_mule,vector signed int,vector signed short,vector signed short)
#define vec_vmulesh(a,b)  __tg_builtin("vec_vmulesh",a,b)

/* vec_mule */
#pragma tg_funcdef(vec_mule,__vec_mule,vector unsigned short,vector unsigned char,vector unsigned char)
#pragma tg_funcdef(vec_mule,__vec_mule,vector signed short,vector signed char,vector signed char)
#pragma tg_funcdef(vec_mule,__vec_mule,vector unsigned int,vector unsigned short,vector unsigned short)
#pragma tg_funcdef(vec_mule,__vec_mule,vector signed int,vector signed short,vector signed short)
#define vec_mule(a,b)  __tg_builtin("vec_mule",a,b)

/* vec_vmuloub */
#pragma tg_funcdef(vec_vmuloub,__vec_mulo,vector unsigned short,vector unsigned char,vector unsigned char)
#define vec_vmuloub(a,b)  __tg_builtin("vec_vmuloub",a,b)

/* vec_vmulosb */
#pragma tg_funcdef(vec_vmulosb,__vec_mulo,vector signed short,vector signed char,vector signed char)
#define vec_vmulosb(a,b)  __tg_builtin("vec_vmulosb",a,b)

/* vec_vmulouh */
#pragma tg_funcdef(vec_vmulouh,__vec_mulo,vector unsigned int,vector unsigned short,vector unsigned short)
#define vec_vmulouh(a,b)  __tg_builtin("vec_vmulouh",a,b)

/* vec_vmulosh */
#pragma tg_funcdef(vec_vmulosh,__vec_mulo,vector signed int,vector signed short,vector signed short)
#define vec_vmulosh(a,b)  __tg_builtin("vec_vmulosh",a,b)

/* vec_mulo */
#pragma tg_funcdef(vec_mulo,__vec_mulo,vector unsigned short,vector unsigned char,vector unsigned char)
#pragma tg_funcdef(vec_mulo,__vec_mulo,vector signed short,vector signed char,vector signed char)
#pragma tg_funcdef(vec_mulo,__vec_mulo,vector unsigned int,vector unsigned short,vector unsigned short)
#pragma tg_funcdef(vec_mulo,__vec_mulo,vector signed int,vector signed short,vector signed short)
#define vec_mulo(a,b)  __tg_builtin("vec_mulo",a,b)

/* vec_vnmsubfp */
#pragma tg_funcdef(vec_vnmsubfp,__vec_nmsub,vector float,vector float,vector float,vector float)
#define vec_vnmsubfp(a,b,c)  __tg_builtin("vec_vnmsubfp",a,b,c)

/* vec_nmsub */
#define vec_nmsub(a,b,c)  __vec_nmsub(a,b,c)

/* vec_vnor */
#pragma tg_funcdef(vec_vnor,__vec_nor,vector unsigned char,vector unsigned char,vector unsigned char)
#pragma tg_funcdef(vec_vnor,__vec_nor,vector signed char,vector signed char,vector signed char)
#pragma tg_funcdef(vec_vnor,__vec_nor,vector bool char,vector bool char,vector bool char)
#pragma tg_funcdef(vec_vnor,__vec_nor,vector unsigned short,vector unsigned short,vector unsigned short)
#pragma tg_funcdef(vec_vnor,__vec_nor,vector signed short,vector signed short,vector signed short)
#pragma tg_funcdef(vec_vnor,__vec_nor,vector bool short,vector bool short,vector bool short)
#pragma tg_funcdef(vec_vnor,__vec_nor,vector unsigned int,vector unsigned int,vector unsigned int)
#pragma tg_funcdef(vec_vnor,__vec_nor,vector signed int,vector signed int,vector signed int)
#pragma tg_funcdef(vec_vnor,__vec_nor,vector bool int,vector bool int,vector bool int)
#pragma tg_funcdef(vec_vnor,__vec_nor,vector float,vector float,vector float)
#define vec_vnor(a,b)  __tg_builtin("vec_vnor",a,b)

/* vec_nor */
#pragma tg_funcdef(vec_nor,__vec_nor,vector unsigned char,vector unsigned char,vector unsigned char)
#pragma tg_funcdef(vec_nor,__vec_nor,vector signed char,vector signed char,vector signed char)
#pragma tg_funcdef(vec_nor,__vec_nor,vector bool char,vector bool char,vector bool char)
#pragma tg_funcdef(vec_nor,__vec_nor,vector unsigned short,vector unsigned short,vector unsigned short)
#pragma tg_funcdef(vec_nor,__vec_nor,vector signed short,vector signed short,vector signed short)
#pragma tg_funcdef(vec_nor,__vec_nor,vector bool short,vector bool short,vector bool short)
#pragma tg_funcdef(vec_nor,__vec_nor,vector unsigned int,vector unsigned int,vector unsigned int)
#pragma tg_funcdef(vec_nor,__vec_nor,vector signed int,vector signed int,vector signed int)
#pragma tg_funcdef(vec_nor,__vec_nor,vector bool int,vector bool int,vector bool int)
#pragma tg_funcdef(vec_nor,__vec_nor,vector float,vector float,vector float)
#define vec_nor(a,b)  __tg_builtin("vec_nor",a,b)

/* vec_vor */
#pragma tg_funcdef(vec_vor,__vec_or,vector unsigned char,vector unsigned char,vector unsigned char)
#pragma tg_funcdef(vec_vor,__vec_or,vector unsigned char,vector unsigned char,vector bool char)
#pragma tg_funcdef(vec_vor,__vec_or,vector unsigned char,vector bool char,vector unsigned char)
#pragma tg_funcdef(vec_vor,__vec_or,vector signed char,vector signed char,vector signed char)
#pragma tg_funcdef(vec_vor,__vec_or,vector signed char,vector signed char,vector bool char)
#pragma tg_funcdef(vec_vor,__vec_or,vector signed char,vector bool char,vector signed char)
#pragma tg_funcdef(vec_vor,__vec_or,vector bool char,vector bool char,vector bool char)
#pragma tg_funcdef(vec_vor,__vec_or,vector unsigned short,vector unsigned short,vector unsigned short)
#pragma tg_funcdef(vec_vor,__vec_or,vector unsigned short,vector unsigned short,vector bool short)
#pragma tg_funcdef(vec_vor,__vec_or,vector unsigned short,vector bool short,vector unsigned short)
#pragma tg_funcdef(vec_vor,__vec_or,vector signed short,vector signed short,vector signed short)
#pragma tg_funcdef(vec_vor,__vec_or,vector signed short,vector signed short,vector bool short)
#pragma tg_funcdef(vec_vor,__vec_or,vector signed short,vector bool short,vector signed short)
#pragma tg_funcdef(vec_vor,__vec_or,vector bool short,vector bool short,vector bool short)
#pragma tg_funcdef(vec_vor,__vec_or,vector unsigned int,vector unsigned int,vector unsigned int)
#pragma tg_funcdef(vec_vor,__vec_or,vector unsigned int,vector unsigned int,vector bool int)
#pragma tg_funcdef(vec_vor,__vec_or,vector unsigned int,vector bool int,vector unsigned int)
#pragma tg_funcdef(vec_vor,__vec_or,vector signed int,vector signed int,vector signed int)
#pragma tg_funcdef(vec_vor,__vec_or,vector signed int,vector signed int,vector bool int)
#pragma tg_funcdef(vec_vor,__vec_or,vector signed int,vector bool int,vector signed int)
#pragma tg_funcdef(vec_vor,__vec_or,vector bool int,vector bool int,vector bool int)
#pragma tg_funcdef(vec_vor,__vec_or,vector float,vector bool int,vector float)
#pragma tg_funcdef(vec_vor,__vec_or,vector float,vector float,vector bool int)
#pragma tg_funcdef(vec_vor,__vec_or,vector float,vector float, vector float)
#define vec_vor(a,b)  __tg_builtin("vec_vor",a,b)

/* vec_or */
#pragma tg_funcdef(vec_or,__vec_or,vector unsigned char,vector unsigned char,vector unsigned char)
#pragma tg_funcdef(vec_or,__vec_or,vector unsigned char,vector unsigned char,vector bool char)
#pragma tg_funcdef(vec_or,__vec_or,vector unsigned char,vector bool char,vector unsigned char)
#pragma tg_funcdef(vec_or,__vec_or,vector signed char,vector signed char,vector signed char)
#pragma tg_funcdef(vec_or,__vec_or,vector signed char,vector signed char,vector bool char)
#pragma tg_funcdef(vec_or,__vec_or,vector signed char,vector bool char,vector signed char)
#pragma tg_funcdef(vec_or,__vec_or,vector bool char,vector bool char,vector bool char)
#pragma tg_funcdef(vec_or,__vec_or,vector unsigned short,vector unsigned short,vector unsigned short)
#pragma tg_funcdef(vec_or,__vec_or,vector unsigned short,vector unsigned short,vector bool short)
#pragma tg_funcdef(vec_or,__vec_or,vector unsigned short,vector bool short,vector unsigned short)
#pragma tg_funcdef(vec_or,__vec_or,vector signed short,vector signed short,vector signed short)
#pragma tg_funcdef(vec_or,__vec_or,vector signed short,vector signed short,vector bool short)
#pragma tg_funcdef(vec_or,__vec_or,vector signed short,vector bool short,vector signed short)
#pragma tg_funcdef(vec_or,__vec_or,vector bool short,vector bool short,vector bool short)
#pragma tg_funcdef(vec_or,__vec_or,vector unsigned int,vector unsigned int,vector unsigned int)
#pragma tg_funcdef(vec_or,__vec_or,vector unsigned int,vector unsigned int,vector bool int)
#pragma tg_funcdef(vec_or,__vec_or,vector unsigned int,vector bool int,vector unsigned int)
#pragma tg_funcdef(vec_or,__vec_or,vector signed int,vector signed int,vector signed int)
#pragma tg_funcdef(vec_or,__vec_or,vector signed int,vector signed int,vector bool int)
#pragma tg_funcdef(vec_or,__vec_or,vector signed int,vector bool int,vector signed int)
#pragma tg_funcdef(vec_or,__vec_or,vector bool int,vector bool int,vector bool int)
#pragma tg_funcdef(vec_or,__vec_or,vector float,vector bool int,vector float)
#pragma tg_funcdef(vec_or,__vec_or,vector float,vector float,vector bool int)
#pragma tg_funcdef(vec_or,__vec_or,vector float,vector float, vector float)
#define vec_or(a,b)  __tg_builtin("vec_or",a,b)

/* vec_vpkuhum */
#pragma tg_funcdef(vec_vpkuhum,__vec_pack,vector unsigned char,vector unsigned short,vector unsigned short)
#pragma tg_funcdef(vec_vpkuhum,__vec_pack,vector signed char,vector signed short,vector signed short)
#pragma tg_funcdef(vec_vpkuhum,__vec_pack,vector bool char,vector bool short,vector bool short)
#define vec_vpkuhum(a,b)  __tg_builtin("vec_vpkuhum",a,b)

/* vec_vpkuwum */
#pragma tg_funcdef(vec_vpkuwum,__vec_pack,vector unsigned short,vector unsigned int,vector unsigned int)
#pragma tg_funcdef(vec_vpkuwum,__vec_pack,vector signed short,vector signed int,vector signed int)
#pragma tg_funcdef(vec_vpkuwum,__vec_pack,vector bool short,vector bool int,vector bool int)
#define vec_vpkuwum(a,b)  __tg_builtin("vec_vpkuwum",a,b)

/* vec_pack */
#pragma tg_funcdef(vec_pack,__vec_pack,vector unsigned char,vector unsigned short,vector unsigned short)
#pragma tg_funcdef(vec_pack,__vec_pack,vector signed char,vector signed short,vector signed short)
#pragma tg_funcdef(vec_pack,__vec_pack,vector bool char,vector bool short,vector bool short)
#pragma tg_funcdef(vec_pack,__vec_pack,vector unsigned short,vector unsigned int,vector unsigned int)
#pragma tg_funcdef(vec_pack,__vec_pack,vector signed short,vector signed int,vector signed int)
#pragma tg_funcdef(vec_pack,__vec_pack,vector bool short,vector bool int,vector bool int)
#define vec_pack(a,b)  __tg_builtin("vec_pack",a,b)

/* vec_vpkpx */
#pragma tg_funcdef(vec_vpkpx,__vec_packpx,vector pixel,vector unsigned int,vector unsigned int)
#define vec_vpkpx(a,b)  __tg_builtin("vec_vpkpx",a,b)

/* vec_packpx */
#define vec_packpx(a,b)  __vec_packpx(a,b)

/* vec_vpkuhus */
#pragma tg_funcdef(vec_vpkuhus,__vec_packs,vector unsigned char,vector unsigned short,vector unsigned short)
#define vec_vpkuhus(a,b)  __tg_builtin("vec_vpkuhus",a,b)

/* vec_vpkshss */
#pragma tg_funcdef(vec_vpkshss,__vec_packs,vector signed char,vector signed short,vector signed short)
#define vec_vpkshss(a,b)  __tg_builtin("vec_vpkshss",a,b)

/* vec_vpkuwus */
#pragma tg_funcdef(vec_vpkuwus,__vec_packs,vector unsigned short,vector unsigned int,vector unsigned int)
#define vec_vpkuwus(a,b)  __tg_builtin("vec_vpkuwus",a,b)

/* vec_vpkswss */
#pragma tg_funcdef(vec_vpkswss,__vec_packs,vector signed short,vector signed int,vector signed int)
#define vec_vpkswss(a,b)  __tg_builtin("vec_vpkswss",a,b)

/* vec_packs */
#pragma tg_funcdef(vec_packs,__vec_packs,vector unsigned char,vector unsigned short,vector unsigned short)
#pragma tg_funcdef(vec_packs,__vec_packs,vector signed char,vector signed short,vector signed short)
#pragma tg_funcdef(vec_packs,__vec_packs,vector unsigned short,vector unsigned int,vector unsigned int)
#pragma tg_funcdef(vec_packs,__vec_packs,vector signed short,vector signed int,vector signed int)
#define vec_packs(a,b)  __tg_builtin("vec_packs",a,b)

/* vec_vpkshus */
#pragma tg_funcdef(vec_vpkshus,__vec_packsu,vector unsigned char,vector signed short,vector signed short)
#define vec_vpkshus(a,b)  __tg_builtin("vec_vpkshus",a,b)

/* vec_vpkswus */
#pragma tg_funcdef(vec_vpkswus,__vec_packsu,vector unsigned short,vector signed int,vector signed int)
#define vec_vpkswus(a,b)  __tg_builtin("vec_vpkswus",a,b)

/* vec_packsu */
#pragma tg_funcdef(vec_packsu,__vec_packsu,vector unsigned char,vector unsigned short,vector unsigned short)
#pragma tg_funcdef(vec_packsu,__vec_packsu,vector unsigned char,vector signed short,vector signed short)
#pragma tg_funcdef(vec_packsu,__vec_packsu,vector unsigned short,vector unsigned int,vector unsigned int)
#pragma tg_funcdef(vec_packsu,__vec_packsu,vector unsigned short,vector signed int,vector signed int)
#define vec_packsu(a,b)  __tg_builtin("vec_packsu",a,b)

/* vec_vperm */
#pragma tg_funcdef(vec_vperm,__vec_perm,vector unsigned char,vector unsigned char,vector unsigned char,vector unsigned char)
#pragma tg_funcdef(vec_vperm,__vec_perm,vector signed char,vector signed char,vector signed char,vector unsigned char)
#pragma tg_funcdef(vec_vperm,__vec_perm,vector bool char,vector bool char,vector bool char,vector unsigned char)
#pragma tg_funcdef(vec_vperm,__vec_perm,vector unsigned short,vector unsigned short,vector unsigned short,vector unsigned char)
#pragma tg_funcdef(vec_vperm,__vec_perm,vector signed short,vector signed short,vector signed short,vector unsigned char)
#pragma tg_funcdef(vec_vperm,__vec_perm,vector bool short,vector bool short,vector bool short,vector unsigned char)
#pragma tg_funcdef(vec_vperm,__vec_perm,vector pixel,vector pixel, vector pixel,vector unsigned char)
#pragma tg_funcdef(vec_vperm,__vec_perm,vector unsigned int,vector unsigned int,vector unsigned int,vector unsigned char)
#pragma tg_funcdef(vec_vperm,__vec_perm,vector signed int,vector signed int,vector signed int,vector unsigned char)
#pragma tg_funcdef(vec_vperm,__vec_perm,vector bool int,vector bool int,vector bool int,vector unsigned char)
#pragma tg_funcdef(vec_vperm,__vec_perm,vector float,vector float, vector float,vector unsigned char)
#define vec_vperm(a,b,c)  __tg_builtin("vec_vperm",a,b,c)

/* vec_perm */
#pragma tg_funcdef(vec_perm,__vec_perm,vector unsigned char,vector unsigned char,vector unsigned char,vector unsigned char)
#pragma tg_funcdef(vec_perm,__vec_perm,vector signed char,vector signed char,vector signed char,vector unsigned char)
#pragma tg_funcdef(vec_perm,__vec_perm,vector bool char,vector bool char,vector bool char,vector unsigned char)
#pragma tg_funcdef(vec_perm,__vec_perm,vector unsigned short,vector unsigned short,vector unsigned short,vector unsigned char)
#pragma tg_funcdef(vec_perm,__vec_perm,vector signed short,vector signed short,vector signed short,vector unsigned char)
#pragma tg_funcdef(vec_perm,__vec_perm,vector bool short,vector bool short,vector bool short,vector unsigned char)
#pragma tg_funcdef(vec_perm,__vec_perm,vector pixel,vector pixel, vector pixel,vector unsigned char)
#pragma tg_funcdef(vec_perm,__vec_perm,vector unsigned int,vector unsigned int,vector unsigned int,vector unsigned char)
#pragma tg_funcdef(vec_perm,__vec_perm,vector signed int,vector signed int,vector signed int,vector unsigned char)
#pragma tg_funcdef(vec_perm,__vec_perm,vector bool int,vector bool int,vector bool int,vector unsigned char)
#pragma tg_funcdef(vec_perm,__vec_perm,vector float,vector float, vector float,vector unsigned char)
#define vec_perm(a,b,c)  __tg_builtin("vec_perm",a,b,c)

/* vec_promote */
#pragma tg_funcdef(vec_promote, __vec_promote_u1,  vector unsigned char,   unsigned char,   signed int)
#pragma tg_funcdef(vec_promote, __vec_promote_s1,  vector signed char,     signed char,     signed int)
#pragma tg_funcdef(vec_promote, __vec_promote_u2,  vector unsigned short,  unsigned short,  signed int)
#pragma tg_funcdef(vec_promote, __vec_promote_s2,  vector signed short,    signed short,    signed int)
#pragma tg_funcdef(vec_promote, __vec_promote_u4,  vector unsigned int,    unsigned int,    signed int)
#pragma tg_funcdef(vec_promote, __vec_promote_s4,  vector signed int,      signed int,      signed int)
#pragma tg_funcdef(vec_promote, __vec_promote_f4,  vector float,           float,           signed int)
#undef  vec_promote
#define vec_promote(__a,__b) __tg_builtin("vec_promote",__a,__b)

/* vec_vrefp */
#pragma tg_funcdef(vec_vrefp,__vec_re,vector float,vector float)
#define vec_vrefp(a)  __tg_builtin("vec_vrefp",a)

/* vec_re */
#define vec_re(a)  __vec_re(a)

/* vec_vrlb */
#pragma tg_funcdef(vec_vrlb,__vec_rl,vector unsigned char,vector unsigned char,vector unsigned char)
#pragma tg_funcdef(vec_vrlb,__vec_rl,vector signed char,vector signed char,vector unsigned char)
#define vec_vrlb(a,b)  __tg_builtin("vec_vrlb",a,b)

/* vec_vrlh */
#pragma tg_funcdef(vec_vrlh,__vec_rl,vector unsigned short,vector unsigned short,vector unsigned short)
#pragma tg_funcdef(vec_vrlh,__vec_rl,vector signed short,vector signed short,vector unsigned short)
#define vec_vrlh(a,b)  __tg_builtin("vec_vrlh",a,b)

/* vec_vrlw */
#pragma tg_funcdef(vec_vrlw,__vec_rl,vector unsigned int,vector unsigned int,vector unsigned int)
#pragma tg_funcdef(vec_vrlw,__vec_rl,vector signed int,vector signed int,vector unsigned int)
#define vec_vrlw(a,b)  __tg_builtin("vec_vrlw",a,b)

/* vec_rl */
#pragma tg_funcdef(vec_rl,__vec_rl,vector unsigned char,vector unsigned char,vector unsigned char)
#pragma tg_funcdef(vec_rl,__vec_rl,vector signed char,vector signed char,vector unsigned char)
#pragma tg_funcdef(vec_rl,__vec_rl,vector unsigned short,vector unsigned short,vector unsigned short)
#pragma tg_funcdef(vec_rl,__vec_rl,vector signed short,vector signed short,vector unsigned short)
#pragma tg_funcdef(vec_rl,__vec_rl,vector unsigned int,vector unsigned int,vector unsigned int)
#pragma tg_funcdef(vec_rl,__vec_rl,vector signed int,vector signed int,vector unsigned int)
#define vec_rl(a,b)  __tg_builtin("vec_rl",a,b)

/* vec_vrfin */
#pragma tg_funcdef(vec_vrfin,__vec_round,vector float,vector float)
#define vec_vrfin(a)  __tg_builtin("vec_vrfin",a)

/* vec_round */
#define vec_round(a)  __vec_round(a)

/* vec_vrsqrtefp */
#pragma tg_funcdef(vec_vrsqrtefp,__vec_rsqrte,vector float,vector float)
#define vec_vrsqrtefp(a)  __tg_builtin("vec_vrsqrtefp",a)

/* vec_rsqrte */
#define vec_rsqrte(a)  __vec_rsqrte(a)

/* vec_vsel */
#pragma tg_funcdef(vec_vsel,__vec_sel,vector unsigned char,vector unsigned char,vector unsigned char,vector unsigned char)
#pragma tg_funcdef(vec_vsel,__vec_sel,vector unsigned char,vector unsigned char,vector unsigned char,vector bool char)
#pragma tg_funcdef(vec_vsel,__vec_sel,vector signed char,vector signed char,vector signed char,vector unsigned char)
#pragma tg_funcdef(vec_vsel,__vec_sel,vector signed char,vector signed char,vector signed char,vector bool char)
#pragma tg_funcdef(vec_vsel,__vec_sel,vector bool char,vector bool char,vector bool char,vector unsigned char)
#pragma tg_funcdef(vec_vsel,__vec_sel,vector bool char,vector bool char,vector bool char,vector bool char)
#pragma tg_funcdef(vec_vsel,__vec_sel,vector unsigned short,vector unsigned short,vector unsigned short,vector unsigned short)
#pragma tg_funcdef(vec_vsel,__vec_sel,vector unsigned short,vector unsigned short,vector unsigned short,vector bool short)
#pragma tg_funcdef(vec_vsel,__vec_sel,vector signed short,vector signed short,vector signed short,vector unsigned short)
#pragma tg_funcdef(vec_vsel,__vec_sel,vector signed short,vector signed short,vector signed short,vector bool short)
#pragma tg_funcdef(vec_vsel,__vec_sel,vector bool short,vector bool short,vector bool short,vector unsigned short)
#pragma tg_funcdef(vec_vsel,__vec_sel,vector bool short,vector bool short,vector bool short,vector bool short)
#pragma tg_funcdef(vec_vsel,__vec_sel,vector unsigned int,vector unsigned int,vector unsigned int,vector unsigned int)
#pragma tg_funcdef(vec_vsel,__vec_sel,vector unsigned int,vector unsigned int,vector unsigned int,vector bool int)
#pragma tg_funcdef(vec_vsel,__vec_sel,vector signed int,vector signed int,vector signed int,vector unsigned int)
#pragma tg_funcdef(vec_vsel,__vec_sel,vector signed int,vector signed int,vector signed int,vector bool int)
#pragma tg_funcdef(vec_vsel,__vec_sel,vector bool int,vector bool int,vector bool int,vector unsigned int)
#pragma tg_funcdef(vec_vsel,__vec_sel,vector bool int,vector bool int,vector bool int,vector bool int)
#pragma tg_funcdef(vec_vsel,__vec_sel,vector float,vector float,vector float,vector unsigned int)
#pragma tg_funcdef(vec_vsel,__vec_sel,vector float,vector float,vector float,vector bool int)
#define vec_vsel(a,b,c)  __tg_builtin("vec_vsel",a,b,c)

/* vec_sel */
#pragma tg_funcdef(vec_sel,__vec_sel,vector unsigned char,vector unsigned char,vector unsigned char,vector unsigned char)
#pragma tg_funcdef(vec_sel,__vec_sel,vector unsigned char,vector unsigned char,vector unsigned char,vector bool char)
#pragma tg_funcdef(vec_sel,__vec_sel,vector signed char,vector signed char,vector signed char,vector unsigned char)
#pragma tg_funcdef(vec_sel,__vec_sel,vector signed char,vector signed char,vector signed char,vector bool char)
#pragma tg_funcdef(vec_sel,__vec_sel,vector bool char,vector bool char,vector bool char,vector unsigned char)
#pragma tg_funcdef(vec_sel,__vec_sel,vector bool char,vector bool char,vector bool char,vector bool char)
#pragma tg_funcdef(vec_sel,__vec_sel,vector unsigned short,vector unsigned short,vector unsigned short,vector unsigned short)
#pragma tg_funcdef(vec_sel,__vec_sel,vector unsigned short,vector unsigned short,vector unsigned short,vector bool short)
#pragma tg_funcdef(vec_sel,__vec_sel,vector signed short,vector signed short,vector signed short,vector unsigned short)
#pragma tg_funcdef(vec_sel,__vec_sel,vector signed short,vector signed short,vector signed short,vector bool short)
#pragma tg_funcdef(vec_sel,__vec_sel,vector bool short,vector bool short,vector bool short,vector unsigned short)
#pragma tg_funcdef(vec_sel,__vec_sel,vector bool short,vector bool short,vector bool short,vector bool short)
#pragma tg_funcdef(vec_sel,__vec_sel,vector unsigned int,vector unsigned int,vector unsigned int,vector unsigned int)
#pragma tg_funcdef(vec_sel,__vec_sel,vector unsigned int,vector unsigned int,vector unsigned int,vector bool int)
#pragma tg_funcdef(vec_sel,__vec_sel,vector signed int,vector signed int,vector signed int,vector unsigned int)
#pragma tg_funcdef(vec_sel,__vec_sel,vector signed int,vector signed int,vector signed int,vector bool int)
#pragma tg_funcdef(vec_sel,__vec_sel,vector bool int,vector bool int,vector bool int,vector unsigned int)
#pragma tg_funcdef(vec_sel,__vec_sel,vector bool int,vector bool int,vector bool int,vector bool int)
#pragma tg_funcdef(vec_sel,__vec_sel,vector float,vector float,vector float,vector unsigned int)
#pragma tg_funcdef(vec_sel,__vec_sel,vector float,vector float,vector float,vector bool int)
#define vec_sel(a,b,c)  __tg_builtin("vec_sel",a,b,c)

/* vec_vslb */
#pragma tg_funcdef(vec_vslb,__vec_sl,vector unsigned char,vector unsigned char,vector unsigned char)
#pragma tg_funcdef(vec_vslb,__vec_sl,vector signed char,vector signed char,vector unsigned char)
#define vec_vslb(a,b)  __tg_builtin("vec_vslb",a,b)

/* vec_vslh */
#pragma tg_funcdef(vec_vslh,__vec_sl,vector unsigned short,vector unsigned short,vector unsigned short)
#pragma tg_funcdef(vec_vslh,__vec_sl,vector signed short,vector signed short,vector unsigned short)
#define vec_vslh(a,b)  __tg_builtin("vec_vslh",a,b)

/* vec_vslw */
#pragma tg_funcdef(vec_vslw,__vec_sl,vector unsigned int,vector unsigned int,vector unsigned int)
#pragma tg_funcdef(vec_vslw,__vec_sl,vector signed int,vector signed int,vector unsigned int)
#define vec_vslw(a,b)  __tg_builtin("vec_vslw",a,b)

/* vec_sl */
#pragma tg_funcdef(vec_sl,__vec_sl,vector unsigned char,vector unsigned char,vector unsigned char)
#pragma tg_funcdef(vec_sl,__vec_sl,vector signed char,vector signed char,vector unsigned char)
#pragma tg_funcdef(vec_sl,__vec_sl,vector unsigned short,vector unsigned short,vector unsigned short)
#pragma tg_funcdef(vec_sl,__vec_sl,vector signed short,vector signed short,vector unsigned short)
#pragma tg_funcdef(vec_sl,__vec_sl,vector unsigned int,vector unsigned int,vector unsigned int)
#pragma tg_funcdef(vec_sl,__vec_sl,vector signed int,vector signed int,vector unsigned int)
#define vec_sl(a,b)  __tg_builtin("vec_sl",a,b)

/* vec_vsldoi */
#pragma tg_funcdef(vec_vsldoi,__vec_sld,vector unsigned char, vector unsigned char,  vector unsigned char,  int)
#pragma tg_funcdef(vec_vsldoi,__vec_sld,vector signed char,   vector signed char,    vector signed char,    int)
#pragma tg_funcdef(vec_vsldoi,__vec_sld,vector unsigned short,vector unsigned short, vector unsigned short, int)
#pragma tg_funcdef(vec_vsldoi,__vec_sld,vector signed short,  vector signed short,   vector signed short,   int)
#pragma tg_funcdef(vec_vsldoi,__vec_sld,vector pixel,         vector pixel,          vector pixel,          int)
#pragma tg_funcdef(vec_vsldoi,__vec_sld,vector unsigned int,  vector unsigned int,   vector unsigned int,   int)
#pragma tg_funcdef(vec_vsldoi,__vec_sld,vector signed int,    vector signed int,     vector signed int,     int)
#pragma tg_funcdef(vec_vsldoi,__vec_sld,vector float,         vector float,          vector float,          int)
#define vec_vsldoi(a,b,c)  __tg_builtin("vec_vsldoi",a,b,c)

/* vec_sld */
#pragma tg_funcdef(vec_sld,__vec_sld,vector unsigned char, vector unsigned char,  vector unsigned char,  int)
#pragma tg_funcdef(vec_sld,__vec_sld,vector signed char,   vector signed char,    vector signed char,    int)
#pragma tg_funcdef(vec_sld,__vec_sld,vector unsigned short,vector unsigned short, vector unsigned short, int)
#pragma tg_funcdef(vec_sld,__vec_sld,vector signed short,  vector signed short,   vector signed short,   int)
#pragma tg_funcdef(vec_sld,__vec_sld,vector pixel,         vector pixel,          vector pixel,          int)
#pragma tg_funcdef(vec_sld,__vec_sld,vector unsigned int,  vector unsigned int,   vector unsigned int,   int)
#pragma tg_funcdef(vec_sld,__vec_sld,vector signed int,    vector signed int,     vector signed int,     int)
#pragma tg_funcdef(vec_sld,__vec_sld,vector float,         vector float,          vector float,          int)
#define vec_sld(a,b,c)  __tg_builtin("vec_sld",a,b,c)

/* vec_vsl */
#pragma tg_funcdef(vec_vsl,__vec_sll,vector unsigned char,vector unsigned char,vector unsigned char)
#pragma tg_funcdef(vec_vsl,__vec_sll,vector unsigned char,vector unsigned char,vector unsigned int)
#pragma tg_funcdef(vec_vsl,__vec_sll,vector unsigned char,vector unsigned char,vector unsigned short)
#pragma tg_funcdef(vec_vsl,__vec_sll,vector signed char,vector signed char,vector unsigned char)
#pragma tg_funcdef(vec_vsl,__vec_sll,vector signed char,vector signed char,vector unsigned int)
#pragma tg_funcdef(vec_vsl,__vec_sll,vector signed char,vector signed char,vector unsigned short)
#pragma tg_funcdef(vec_vsl,__vec_sll,vector bool char,vector bool char,vector unsigned char)
#pragma tg_funcdef(vec_vsl,__vec_sll,vector bool char,vector bool char,vector unsigned int)
#pragma tg_funcdef(vec_vsl,__vec_sll,vector bool char,vector bool char,vector unsigned short)
#pragma tg_funcdef(vec_vsl,__vec_sll,vector unsigned short,vector unsigned short,vector unsigned char)
#pragma tg_funcdef(vec_vsl,__vec_sll,vector unsigned short,vector unsigned short,vector unsigned int)
#pragma tg_funcdef(vec_vsl,__vec_sll,vector unsigned short,vector unsigned short,vector unsigned short)
#pragma tg_funcdef(vec_vsl,__vec_sll,vector signed short,vector signed short,vector unsigned char)
#pragma tg_funcdef(vec_vsl,__vec_sll,vector signed short,vector signed short,vector unsigned int)
#pragma tg_funcdef(vec_vsl,__vec_sll,vector signed short,vector signed short,vector unsigned short)
#pragma tg_funcdef(vec_vsl,__vec_sll,vector bool short,vector bool short,vector unsigned char)
#pragma tg_funcdef(vec_vsl,__vec_sll,vector bool short,vector bool short,vector unsigned int)
#pragma tg_funcdef(vec_vsl,__vec_sll,vector bool short,vector bool short,vector unsigned short)
#pragma tg_funcdef(vec_vsl,__vec_sll,vector pixel,vector pixel,vector unsigned char)
#pragma tg_funcdef(vec_vsl,__vec_sll,vector pixel,vector pixel,vector unsigned int)
#pragma tg_funcdef(vec_vsl,__vec_sll,vector pixel,vector pixel,vector unsigned short)
#pragma tg_funcdef(vec_vsl,__vec_sll,vector unsigned int,vector unsigned int,vector unsigned char)
#pragma tg_funcdef(vec_vsl,__vec_sll,vector unsigned int,vector unsigned int,vector unsigned int)
#pragma tg_funcdef(vec_vsl,__vec_sll,vector unsigned int,vector unsigned int,vector unsigned short)
#pragma tg_funcdef(vec_vsl,__vec_sll,vector signed int,vector signed int,vector unsigned char)
#pragma tg_funcdef(vec_vsl,__vec_sll,vector signed int,vector signed int,vector unsigned int)
#pragma tg_funcdef(vec_vsl,__vec_sll,vector signed int,vector signed int,vector unsigned short)
#pragma tg_funcdef(vec_vsl,__vec_sll,vector bool int,vector bool int,vector unsigned char)
#pragma tg_funcdef(vec_vsl,__vec_sll,vector bool int,vector bool int,vector unsigned int)
#pragma tg_funcdef(vec_vsl,__vec_sll,vector bool int,vector bool int,vector unsigned short)
#define vec_vsl(a,b)  __tg_builtin("vec_vsl",a,b)

/* vec_sll */
#pragma tg_funcdef(vec_sll,__vec_sll,vector unsigned char,vector unsigned char,vector unsigned char)
#pragma tg_funcdef(vec_sll,__vec_sll,vector unsigned char,vector unsigned char,vector unsigned int)
#pragma tg_funcdef(vec_sll,__vec_sll,vector unsigned char,vector unsigned char,vector unsigned short)
#pragma tg_funcdef(vec_sll,__vec_sll,vector signed char,vector signed char,vector unsigned char)
#pragma tg_funcdef(vec_sll,__vec_sll,vector signed char,vector signed char,vector unsigned int)
#pragma tg_funcdef(vec_sll,__vec_sll,vector signed char,vector signed char,vector unsigned short)
#pragma tg_funcdef(vec_sll,__vec_sll,vector bool char,vector bool char,vector unsigned char)
#pragma tg_funcdef(vec_sll,__vec_sll,vector bool char,vector bool char,vector unsigned int)
#pragma tg_funcdef(vec_sll,__vec_sll,vector bool char,vector bool char,vector unsigned short)
#pragma tg_funcdef(vec_sll,__vec_sll,vector unsigned short,vector unsigned short,vector unsigned char)
#pragma tg_funcdef(vec_sll,__vec_sll,vector unsigned short,vector unsigned short,vector unsigned int)
#pragma tg_funcdef(vec_sll,__vec_sll,vector unsigned short,vector unsigned short,vector unsigned short)
#pragma tg_funcdef(vec_sll,__vec_sll,vector signed short,vector signed short,vector unsigned char)
#pragma tg_funcdef(vec_sll,__vec_sll,vector signed short,vector signed short,vector unsigned int)
#pragma tg_funcdef(vec_sll,__vec_sll,vector signed short,vector signed short,vector unsigned short)
#pragma tg_funcdef(vec_sll,__vec_sll,vector bool short,vector bool short,vector unsigned char)
#pragma tg_funcdef(vec_sll,__vec_sll,vector bool short,vector bool short,vector unsigned int)
#pragma tg_funcdef(vec_sll,__vec_sll,vector bool short,vector bool short,vector unsigned short)
#pragma tg_funcdef(vec_sll,__vec_sll,vector pixel,vector pixel,vector unsigned char)
#pragma tg_funcdef(vec_sll,__vec_sll,vector pixel,vector pixel,vector unsigned int)
#pragma tg_funcdef(vec_sll,__vec_sll,vector pixel,vector pixel,vector unsigned short)
#pragma tg_funcdef(vec_sll,__vec_sll,vector unsigned int,vector unsigned int,vector unsigned char)
#pragma tg_funcdef(vec_sll,__vec_sll,vector unsigned int,vector unsigned int,vector unsigned int)
#pragma tg_funcdef(vec_sll,__vec_sll,vector unsigned int,vector unsigned int,vector unsigned short)
#pragma tg_funcdef(vec_sll,__vec_sll,vector signed int,vector signed int,vector unsigned char)
#pragma tg_funcdef(vec_sll,__vec_sll,vector signed int,vector signed int,vector unsigned int)
#pragma tg_funcdef(vec_sll,__vec_sll,vector signed int,vector signed int,vector unsigned short)
#pragma tg_funcdef(vec_sll,__vec_sll,vector bool int,vector bool int,vector unsigned char)
#pragma tg_funcdef(vec_sll,__vec_sll,vector bool int,vector bool int,vector unsigned int)
#pragma tg_funcdef(vec_sll,__vec_sll,vector bool int,vector bool int,vector unsigned short)
#define vec_sll(a,b)  __tg_builtin("vec_sll",a,b)

/* vec_vslo */
#pragma tg_funcdef(vec_vslo,__vec_slo,vector unsigned char,vector unsigned char,vector unsigned char)
#pragma tg_funcdef(vec_vslo,__vec_slo,vector unsigned char,vector unsigned char,vector signed char)
#pragma tg_funcdef(vec_vslo,__vec_slo,vector signed char,vector signed char,vector unsigned char)
#pragma tg_funcdef(vec_vslo,__vec_slo,vector signed char,vector signed char,vector signed char)
#pragma tg_funcdef(vec_vslo,__vec_slo,vector unsigned short,vector unsigned short,vector unsigned char)
#pragma tg_funcdef(vec_vslo,__vec_slo,vector unsigned short,vector unsigned short,vector signed char)
#pragma tg_funcdef(vec_vslo,__vec_slo,vector signed short,vector signed short,vector unsigned char)
#pragma tg_funcdef(vec_vslo,__vec_slo,vector signed short,vector signed short,vector signed char)
#pragma tg_funcdef(vec_vslo,__vec_slo,vector pixel,vector pixel,vector unsigned char)
#pragma tg_funcdef(vec_vslo,__vec_slo,vector pixel,vector pixel,vector signed char)
#pragma tg_funcdef(vec_vslo,__vec_slo,vector unsigned int,vector unsigned int,vector unsigned char)
#pragma tg_funcdef(vec_vslo,__vec_slo,vector unsigned int,vector unsigned int,vector signed char)
#pragma tg_funcdef(vec_vslo,__vec_slo,vector signed int,vector signed int,vector unsigned char)
#pragma tg_funcdef(vec_vslo,__vec_slo,vector signed int,vector signed int,vector signed char)
#pragma tg_funcdef(vec_vslo,__vec_slo,vector float,vector float,vector unsigned char)
#pragma tg_funcdef(vec_vslo,__vec_slo,vector float,vector float,vector signed char)
#define vec_vslo(a,b)  __tg_builtin("vec_vslo",a,b)

/* vec_slo */
#pragma tg_funcdef(vec_slo,__vec_slo,vector unsigned char,vector unsigned char,vector unsigned char)
#pragma tg_funcdef(vec_slo,__vec_slo,vector unsigned char,vector unsigned char,vector signed char)
#pragma tg_funcdef(vec_slo,__vec_slo,vector signed char,vector signed char,vector unsigned char)
#pragma tg_funcdef(vec_slo,__vec_slo,vector signed char,vector signed char,vector signed char)
#pragma tg_funcdef(vec_slo,__vec_slo,vector unsigned short,vector unsigned short,vector unsigned char)
#pragma tg_funcdef(vec_slo,__vec_slo,vector unsigned short,vector unsigned short,vector signed char)
#pragma tg_funcdef(vec_slo,__vec_slo,vector signed short,vector signed short,vector unsigned char)
#pragma tg_funcdef(vec_slo,__vec_slo,vector signed short,vector signed short,vector signed char)
#pragma tg_funcdef(vec_slo,__vec_slo,vector pixel,vector pixel,vector unsigned char)
#pragma tg_funcdef(vec_slo,__vec_slo,vector pixel,vector pixel,vector signed char)
#pragma tg_funcdef(vec_slo,__vec_slo,vector unsigned int,vector unsigned int,vector unsigned char)
#pragma tg_funcdef(vec_slo,__vec_slo,vector unsigned int,vector unsigned int,vector signed char)
#pragma tg_funcdef(vec_slo,__vec_slo,vector signed int,vector signed int,vector unsigned char)
#pragma tg_funcdef(vec_slo,__vec_slo,vector signed int,vector signed int,vector signed char)
#pragma tg_funcdef(vec_slo,__vec_slo,vector float,vector float,vector unsigned char)
#pragma tg_funcdef(vec_slo,__vec_slo,vector float,vector float,vector signed char)
#define vec_slo(a,b)  __tg_builtin("vec_slo",a,b)

/* vec_vspltb */
#pragma tg_funcdef(vec_vspltb,__vec_splat,vector unsigned char,vector unsigned char,int)
#pragma tg_funcdef(vec_vspltb,__vec_splat,vector signed char,vector signed char,int)
#pragma tg_funcdef(vec_vspltb,__vec_splat,vector bool char,vector bool char,int)
#define vec_vspltb(a,b)  __tg_builtin("vec_vspltb",a,b)

/* vec_vsplth */
#pragma tg_funcdef(vec_vsplth,__vec_splat,vector unsigned short,vector unsigned short,int)
#pragma tg_funcdef(vec_vsplth,__vec_splat,vector signed short,vector signed short,int)
#pragma tg_funcdef(vec_vsplth,__vec_splat,vector bool short,vector bool short,int)
#pragma tg_funcdef(vec_vsplth,__vec_splat,vector pixel,vector pixel,int)
#define vec_vsplth(a,b)  __tg_builtin("vec_vsplth",a,b)

/* vec_vspltw */
#pragma tg_funcdef(vec_vspltw,__vec_splat,vector unsigned int,vector unsigned int,int)
#pragma tg_funcdef(vec_vspltw,__vec_splat,vector signed int,vector signed int,int)
#pragma tg_funcdef(vec_vspltw,__vec_splat,vector bool int,vector bool int,int)
#pragma tg_funcdef(vec_vspltw,__vec_splat,vector float,vector float,int)
#define vec_vspltw(a,b)  __tg_builtin("vec_vspltw",a,b)

/* vec_splat */
#pragma tg_funcdef(vec_splat,__vec_splat,vector unsigned char,vector unsigned char,int)
#pragma tg_funcdef(vec_splat,__vec_splat,vector signed char,vector signed char,int)
#pragma tg_funcdef(vec_splat,__vec_splat,vector bool char,vector bool char,int)
#pragma tg_funcdef(vec_splat,__vec_splat,vector unsigned short,vector unsigned short,int)
#pragma tg_funcdef(vec_splat,__vec_splat,vector signed short,vector signed short,int)
#pragma tg_funcdef(vec_splat,__vec_splat,vector bool short,vector bool short,int)
#pragma tg_funcdef(vec_splat,__vec_splat,vector pixel,vector pixel,int)
#pragma tg_funcdef(vec_splat,__vec_splat,vector unsigned int,vector unsigned int,int)
#pragma tg_funcdef(vec_splat,__vec_splat,vector signed int,vector signed int,int)
#pragma tg_funcdef(vec_splat,__vec_splat,vector bool int,vector bool int,int)
#pragma tg_funcdef(vec_splat,__vec_splat,vector float,vector float,int)
#define vec_splat(a,b)  __tg_builtin("vec_splat",a,b)

/* vec_splats */
#pragma tg_funcdef(vec_splats, __vec_splats_u1,  vector unsigned char,   unsigned char)
#pragma tg_funcdef(vec_splats, __vec_splats_s1,  vector signed char,     signed char)
#pragma tg_funcdef(vec_splats, __vec_splats_u2,  vector unsigned short,  unsigned short)
#pragma tg_funcdef(vec_splats, __vec_splats_s2,  vector signed short,    signed short)
#pragma tg_funcdef(vec_splats, __vec_splats_u4,  vector unsigned int,    unsigned int)
#pragma tg_funcdef(vec_splats, __vec_splats_s4,  vector signed int,      signed int)
#pragma tg_funcdef(vec_splats, __vec_splats_f4,  vector float,           float)
#undef  vec_splats
#define vec_splats(__a) __tg_builtin("vec_splats",__a)

/* vec_vspltisb */
#pragma tg_funcdef(vec_vspltisb,__vec_splat_s8,vector signed char,int)
#define vec_vspltisb(a)  __tg_builtin("vec_vspltisb",a)

/* vec_splat_s8 */
#define vec_splat_s8(a)  __vec_splat_s8(a)

/* vec_vspltish */
#pragma tg_funcdef(vec_vspltish,__vec_splat_s16,vector signed short,int)
#define vec_vspltish(a)  __tg_builtin("vec_vspltish",a)

/* vec_splat_s16 */
#define vec_splat_s16(a)  __vec_splat_s16(a)

/* vec_vspltisw */
#pragma tg_funcdef(vec_vspltisw,__vec_splat_s32,vector signed int,int)
#define vec_vspltisw(a)  __tg_builtin("vec_vspltisw",a)

/* vec_splat_s32 */
#define vec_splat_s32(a)  __vec_splat_s32(a)

/* vec_splat_u8 */
#define vec_splat_u8(a)  __vec_splat_u8(a)

/* vec_splat_u16 */
#define vec_splat_u16(a)  __vec_splat_u16(a)

/* vec_splat_u32 */
#define vec_splat_u32(a)  __vec_splat_u32(a)

/* vec_vsrb */
#pragma tg_funcdef(vec_vsrb,__vec_sr,vector unsigned char,vector unsigned char,vector unsigned char)
#pragma tg_funcdef(vec_vsrb,__vec_sr,vector signed char,vector signed char,vector unsigned char)
#define vec_vsrb(a,b)  __tg_builtin("vec_vsrb",a,b)

/* vec_vsrh */
#pragma tg_funcdef(vec_vsrh,__vec_sr,vector unsigned short,vector unsigned short,vector unsigned short)
#pragma tg_funcdef(vec_vsrh,__vec_sr,vector signed short,vector signed short,vector unsigned short)
#define vec_vsrh(a,b)  __tg_builtin("vec_vsrh",a,b)

/* vec_vsrw */
#pragma tg_funcdef(vec_vsrw,__vec_sr,vector unsigned int,vector unsigned int,vector unsigned int)
#pragma tg_funcdef(vec_vsrw,__vec_sr,vector signed int,vector signed int,vector unsigned int)
#define vec_vsrw(a,b)  __tg_builtin("vec_vsrw",a,b)

/* vec_sr */
#pragma tg_funcdef(vec_sr,__vec_sr,vector unsigned char,vector unsigned char,vector unsigned char)
#pragma tg_funcdef(vec_sr,__vec_sr,vector signed char,vector signed char,vector unsigned char)
#pragma tg_funcdef(vec_sr,__vec_sr,vector unsigned short,vector unsigned short,vector unsigned short)
#pragma tg_funcdef(vec_sr,__vec_sr,vector signed short,vector signed short,vector unsigned short)
#pragma tg_funcdef(vec_sr,__vec_sr,vector unsigned int,vector unsigned int,vector unsigned int)
#pragma tg_funcdef(vec_sr,__vec_sr,vector signed int,vector signed int,vector unsigned int)
#define vec_sr(a,b)  __tg_builtin("vec_sr",a,b)

/* vec_vsrab */
#pragma tg_funcdef(vec_vsrab,__vec_sra,vector unsigned char,vector unsigned char,vector unsigned char)
#pragma tg_funcdef(vec_vsrab,__vec_sra,vector signed char,vector signed char,vector unsigned char)
#define vec_vsrab(a,b)  __tg_builtin("vec_vsrab",a,b)

/* vec_vsrah */
#pragma tg_funcdef(vec_vsrah,__vec_sra,vector unsigned short,vector unsigned short,vector unsigned short)
#pragma tg_funcdef(vec_vsrah,__vec_sra,vector signed short,vector signed short,vector unsigned short)
#define vec_vsrah(a,b)  __tg_builtin("vec_vsrah",a,b)

/* vec_vsraw */
#pragma tg_funcdef(vec_vsraw,__vec_sra,vector unsigned int,vector unsigned int,vector unsigned int)
#pragma tg_funcdef(vec_vsraw,__vec_sra,vector signed int,vector signed int,vector unsigned int)
#define vec_vsraw(a,b)  __tg_builtin("vec_vsraw",a,b)

/* vec_sra */
#pragma tg_funcdef(vec_sra,__vec_sra,vector unsigned char,vector unsigned char,vector unsigned char)
#pragma tg_funcdef(vec_sra,__vec_sra,vector signed char,vector signed char,vector unsigned char)
#pragma tg_funcdef(vec_sra,__vec_sra,vector unsigned short,vector unsigned short,vector unsigned short)
#pragma tg_funcdef(vec_sra,__vec_sra,vector signed short,vector signed short,vector unsigned short)
#pragma tg_funcdef(vec_sra,__vec_sra,vector unsigned int,vector unsigned int,vector unsigned int)
#pragma tg_funcdef(vec_sra,__vec_sra,vector signed int,vector signed int,vector unsigned int)
#define vec_sra(a,b)  __tg_builtin("vec_sra",a,b)

/* vec_vsr */
#pragma tg_funcdef(vec_vsr,__vec_srl,vector unsigned char,vector unsigned char,vector unsigned char)
#pragma tg_funcdef(vec_vsr,__vec_srl,vector unsigned char,vector unsigned char,vector unsigned int)
#pragma tg_funcdef(vec_vsr,__vec_srl,vector unsigned char,vector unsigned char,vector unsigned short)
#pragma tg_funcdef(vec_vsr,__vec_srl,vector signed char,vector signed char,vector unsigned char)
#pragma tg_funcdef(vec_vsr,__vec_srl,vector signed char,vector signed char,vector unsigned int)
#pragma tg_funcdef(vec_vsr,__vec_srl,vector signed char,vector signed char,vector unsigned short)
#pragma tg_funcdef(vec_vsr,__vec_srl,vector bool char,vector bool char,vector unsigned char)
#pragma tg_funcdef(vec_vsr,__vec_srl,vector bool char,vector bool char,vector unsigned int)
#pragma tg_funcdef(vec_vsr,__vec_srl,vector bool char,vector bool char,vector unsigned short)
#pragma tg_funcdef(vec_vsr,__vec_srl,vector unsigned short,vector unsigned short,vector unsigned char)
#pragma tg_funcdef(vec_vsr,__vec_srl,vector unsigned short,vector unsigned short,vector unsigned int)
#pragma tg_funcdef(vec_vsr,__vec_srl,vector unsigned short,vector unsigned short,vector unsigned short)
#pragma tg_funcdef(vec_vsr,__vec_srl,vector signed short,vector signed short,vector unsigned char)
#pragma tg_funcdef(vec_vsr,__vec_srl,vector signed short,vector signed short,vector unsigned int)
#pragma tg_funcdef(vec_vsr,__vec_srl,vector signed short,vector signed short,vector unsigned short)
#pragma tg_funcdef(vec_vsr,__vec_srl,vector bool short,vector bool short,vector unsigned char)
#pragma tg_funcdef(vec_vsr,__vec_srl,vector bool short,vector bool short,vector unsigned int)
#pragma tg_funcdef(vec_vsr,__vec_srl,vector bool short,vector bool short,vector unsigned short)
#pragma tg_funcdef(vec_vsr,__vec_srl,vector pixel,vector pixel,vector unsigned char)
#pragma tg_funcdef(vec_vsr,__vec_srl,vector pixel,vector pixel,vector unsigned int)
#pragma tg_funcdef(vec_vsr,__vec_srl,vector pixel,vector pixel,vector unsigned short)
#pragma tg_funcdef(vec_vsr,__vec_srl,vector unsigned int,vector unsigned int,vector unsigned char)
#pragma tg_funcdef(vec_vsr,__vec_srl,vector unsigned int,vector unsigned int,vector unsigned int)
#pragma tg_funcdef(vec_vsr,__vec_srl,vector unsigned int,vector unsigned int,vector unsigned short)
#pragma tg_funcdef(vec_vsr,__vec_srl,vector signed int,vector signed int,vector unsigned char)
#pragma tg_funcdef(vec_vsr,__vec_srl,vector signed int,vector signed int,vector unsigned int)
#pragma tg_funcdef(vec_vsr,__vec_srl,vector signed int,vector signed int,vector unsigned short)
#pragma tg_funcdef(vec_vsr,__vec_srl,vector bool int,vector bool int,vector unsigned char)
#pragma tg_funcdef(vec_vsr,__vec_srl,vector bool int,vector bool int,vector unsigned int)
#pragma tg_funcdef(vec_vsr,__vec_srl,vector bool int,vector bool int,vector unsigned short)
#define vec_vsr(a,b)  __tg_builtin("vec_vsr",a,b)

/* vec_srl */
#pragma tg_funcdef(vec_srl,__vec_srl,vector unsigned char,vector unsigned char,vector unsigned char)
#pragma tg_funcdef(vec_srl,__vec_srl,vector unsigned char,vector unsigned char,vector unsigned int)
#pragma tg_funcdef(vec_srl,__vec_srl,vector unsigned char,vector unsigned char,vector unsigned short)
#pragma tg_funcdef(vec_srl,__vec_srl,vector signed char,vector signed char,vector unsigned char)
#pragma tg_funcdef(vec_srl,__vec_srl,vector signed char,vector signed char,vector unsigned int)
#pragma tg_funcdef(vec_srl,__vec_srl,vector signed char,vector signed char,vector unsigned short)
#pragma tg_funcdef(vec_srl,__vec_srl,vector bool char,vector bool char,vector unsigned char)
#pragma tg_funcdef(vec_srl,__vec_srl,vector bool char,vector bool char,vector unsigned int)
#pragma tg_funcdef(vec_srl,__vec_srl,vector bool char,vector bool char,vector unsigned short)
#pragma tg_funcdef(vec_srl,__vec_srl,vector unsigned short,vector unsigned short,vector unsigned char)
#pragma tg_funcdef(vec_srl,__vec_srl,vector unsigned short,vector unsigned short,vector unsigned int)
#pragma tg_funcdef(vec_srl,__vec_srl,vector unsigned short,vector unsigned short,vector unsigned short)
#pragma tg_funcdef(vec_srl,__vec_srl,vector signed short,vector signed short,vector unsigned char)
#pragma tg_funcdef(vec_srl,__vec_srl,vector signed short,vector signed short,vector unsigned int)
#pragma tg_funcdef(vec_srl,__vec_srl,vector signed short,vector signed short,vector unsigned short)
#pragma tg_funcdef(vec_srl,__vec_srl,vector bool short,vector bool short,vector unsigned char)
#pragma tg_funcdef(vec_srl,__vec_srl,vector bool short,vector bool short,vector unsigned int)
#pragma tg_funcdef(vec_srl,__vec_srl,vector bool short,vector bool short,vector unsigned short)
#pragma tg_funcdef(vec_srl,__vec_srl,vector pixel,vector pixel,vector unsigned char)
#pragma tg_funcdef(vec_srl,__vec_srl,vector pixel,vector pixel,vector unsigned int)
#pragma tg_funcdef(vec_srl,__vec_srl,vector pixel,vector pixel,vector unsigned short)
#pragma tg_funcdef(vec_srl,__vec_srl,vector unsigned int,vector unsigned int,vector unsigned char)
#pragma tg_funcdef(vec_srl,__vec_srl,vector unsigned int,vector unsigned int,vector unsigned int)
#pragma tg_funcdef(vec_srl,__vec_srl,vector unsigned int,vector unsigned int,vector unsigned short)
#pragma tg_funcdef(vec_srl,__vec_srl,vector signed int,vector signed int,vector unsigned char)
#pragma tg_funcdef(vec_srl,__vec_srl,vector signed int,vector signed int,vector unsigned int)
#pragma tg_funcdef(vec_srl,__vec_srl,vector signed int,vector signed int,vector unsigned short)
#pragma tg_funcdef(vec_srl,__vec_srl,vector bool int,vector bool int,vector unsigned char)
#pragma tg_funcdef(vec_srl,__vec_srl,vector bool int,vector bool int,vector unsigned int)
#pragma tg_funcdef(vec_srl,__vec_srl,vector bool int,vector bool int,vector unsigned short)
#define vec_srl(a,b)  __tg_builtin("vec_srl",a,b)

/* vec_vsro */
#pragma tg_funcdef(vec_vsro,__vec_sro,vector unsigned char,vector unsigned char,vector unsigned char)
#pragma tg_funcdef(vec_vsro,__vec_sro,vector unsigned char,vector unsigned char,vector signed char)
#pragma tg_funcdef(vec_vsro,__vec_sro,vector signed char,vector signed char,vector unsigned char)
#pragma tg_funcdef(vec_vsro,__vec_sro,vector signed char,vector signed char,vector signed char)
#pragma tg_funcdef(vec_vsro,__vec_sro,vector unsigned short,vector unsigned short,vector unsigned char)
#pragma tg_funcdef(vec_vsro,__vec_sro,vector unsigned short,vector unsigned short,vector signed char)
#pragma tg_funcdef(vec_vsro,__vec_sro,vector signed short,vector signed short,vector unsigned char)
#pragma tg_funcdef(vec_vsro,__vec_sro,vector signed short,vector signed short,vector signed char)
#pragma tg_funcdef(vec_vsro,__vec_sro,vector pixel,vector pixel,vector unsigned char)
#pragma tg_funcdef(vec_vsro,__vec_sro,vector pixel,vector pixel,vector signed char)
#pragma tg_funcdef(vec_vsro,__vec_sro,vector unsigned int,vector unsigned int,vector unsigned char)
#pragma tg_funcdef(vec_vsro,__vec_sro,vector unsigned int,vector unsigned int,vector signed char)
#pragma tg_funcdef(vec_vsro,__vec_sro,vector signed int,vector signed int,vector unsigned char)
#pragma tg_funcdef(vec_vsro,__vec_sro,vector signed int,vector signed int,vector signed char)
#pragma tg_funcdef(vec_vsro,__vec_sro,vector float,vector float,vector unsigned char)
#pragma tg_funcdef(vec_vsro,__vec_sro,vector float,vector float,vector signed char)
#define vec_vsro(a,b)  __tg_builtin("vec_vsro",a,b)

/* vec_sro */
#pragma tg_funcdef(vec_sro,__vec_sro,vector unsigned char,vector unsigned char,vector unsigned char)
#pragma tg_funcdef(vec_sro,__vec_sro,vector unsigned char,vector unsigned char,vector signed char)
#pragma tg_funcdef(vec_sro,__vec_sro,vector signed char,vector signed char,vector unsigned char)
#pragma tg_funcdef(vec_sro,__vec_sro,vector signed char,vector signed char,vector signed char)
#pragma tg_funcdef(vec_sro,__vec_sro,vector unsigned short,vector unsigned short,vector unsigned char)
#pragma tg_funcdef(vec_sro,__vec_sro,vector unsigned short,vector unsigned short,vector signed char)
#pragma tg_funcdef(vec_sro,__vec_sro,vector signed short,vector signed short,vector unsigned char)
#pragma tg_funcdef(vec_sro,__vec_sro,vector signed short,vector signed short,vector signed char)
#pragma tg_funcdef(vec_sro,__vec_sro,vector pixel,vector pixel,vector unsigned char)
#pragma tg_funcdef(vec_sro,__vec_sro,vector pixel,vector pixel,vector signed char)
#pragma tg_funcdef(vec_sro,__vec_sro,vector unsigned int,vector unsigned int,vector unsigned char)
#pragma tg_funcdef(vec_sro,__vec_sro,vector unsigned int,vector unsigned int,vector signed char)
#pragma tg_funcdef(vec_sro,__vec_sro,vector signed int,vector signed int,vector unsigned char)
#pragma tg_funcdef(vec_sro,__vec_sro,vector signed int,vector signed int,vector signed char)
#pragma tg_funcdef(vec_sro,__vec_sro,vector float,vector float,vector unsigned char)
#pragma tg_funcdef(vec_sro,__vec_sro,vector float,vector float,vector signed char)
#define vec_sro(a,b)  __tg_builtin("vec_sro",a,b)

/* vec_stvx */
#pragma tg_funcdef(vec_stvx,__vec_st,void,vector unsigned char,int,vector unsigned char*)
#pragma tg_funcdef(vec_stvx,__vec_st,void,vector unsigned char,int,unsigned char*)
#pragma tg_funcdef(vec_stvx,__vec_st,void,vector signed char,int,vector signed char*)
#pragma tg_funcdef(vec_stvx,__vec_st,void,vector signed char,int,signed char*)
#pragma tg_funcdef(vec_stvx,__vec_st,void,vector bool char,int,vector bool char*)
#pragma tg_funcdef(vec_stvx,__vec_st,void,vector bool char,int,unsigned char*)
#pragma tg_funcdef(vec_stvx,__vec_st,void,vector bool char,int,signed char*)
#pragma tg_funcdef(vec_stvx,__vec_st,void,vector unsigned short,int,vector unsigned short*)
#pragma tg_funcdef(vec_stvx,__vec_st,void,vector unsigned short,int,unsigned short*)
#pragma tg_funcdef(vec_stvx,__vec_st,void,vector signed short,int,vector signed short*)
#pragma tg_funcdef(vec_stvx,__vec_st,void,vector signed short,int,signed short*)
#pragma tg_funcdef(vec_stvx,__vec_st,void,vector bool short,int,vector bool short*)
#pragma tg_funcdef(vec_stvx,__vec_st,void,vector bool short,int,unsigned short*)
#pragma tg_funcdef(vec_stvx,__vec_st,void,vector bool short,int,short*)
#pragma tg_funcdef(vec_stvx,__vec_st,void,vector pixel,int,vector pixel*)
#pragma tg_funcdef(vec_stvx,__vec_st,void,vector pixel,int,unsigned short*)
#pragma tg_funcdef(vec_stvx,__vec_st,void,vector pixel,int,short*)
#pragma tg_funcdef(vec_stvx,__vec_st,void,vector unsigned int,int,vector unsigned int*)
#pragma tg_funcdef(vec_stvx,__vec_st,void,vector unsigned int,int,unsigned int*)
#pragma tg_funcdef(vec_stvx,__vec_st,void,vector signed int,int,vector signed int*)
#pragma tg_funcdef(vec_stvx,__vec_st,void,vector signed int,int,signed int*)
#ifndef __64BIT__
#pragma tg_funcdef(vec_stvx,__vec_st,void,vector unsigned int,int,unsigned long*)
#pragma tg_funcdef(vec_stvx,__vec_st,void,vector signed int,int,signed long*)
#endif /* __64BIT__ */
#pragma tg_funcdef(vec_stvx,__vec_st,void,vector bool int,int,vector bool int*)
#pragma tg_funcdef(vec_stvx,__vec_st,void,vector bool int,int,unsigned int*)
#pragma tg_funcdef(vec_stvx,__vec_st,void,vector bool int,int,int*)
#pragma tg_funcdef(vec_stvx,__vec_st,void,vector float,int,vector float*)
#pragma tg_funcdef(vec_stvx,__vec_st,void,vector float,int,float*)
#ifdef __64BIT__
#pragma tg_funcdef(vec_stvx,__vec_st,void,vector unsigned char,long,vector unsigned char*)
#pragma tg_funcdef(vec_stvx,__vec_st,void,vector unsigned char,long,unsigned char*)
#pragma tg_funcdef(vec_stvx,__vec_st,void,vector signed char,long,vector signed char*)
#pragma tg_funcdef(vec_stvx,__vec_st,void,vector signed char,long,signed char*)
#pragma tg_funcdef(vec_stvx,__vec_st,void,vector bool char,long,vector bool char*)
#pragma tg_funcdef(vec_stvx,__vec_st,void,vector bool char,long,unsigned char*)
#pragma tg_funcdef(vec_stvx,__vec_st,void,vector bool char,long,signed char*)
#pragma tg_funcdef(vec_stvx,__vec_st,void,vector unsigned short,long,vector unsigned short*)
#pragma tg_funcdef(vec_stvx,__vec_st,void,vector unsigned short,long,unsigned short*)
#pragma tg_funcdef(vec_stvx,__vec_st,void,vector signed short,long,vector signed short*)
#pragma tg_funcdef(vec_stvx,__vec_st,void,vector signed short,long,signed short*)
#pragma tg_funcdef(vec_stvx,__vec_st,void,vector bool short,long,vector bool short*)
#pragma tg_funcdef(vec_stvx,__vec_st,void,vector bool short,long,unsigned short*)
#pragma tg_funcdef(vec_stvx,__vec_st,void,vector bool short,long,short*)
#pragma tg_funcdef(vec_stvx,__vec_st,void,vector pixel,long,vector pixel*)
#pragma tg_funcdef(vec_stvx,__vec_st,void,vector pixel,long,unsigned short*)
#pragma tg_funcdef(vec_stvx,__vec_st,void,vector pixel,long,short*)
#pragma tg_funcdef(vec_stvx,__vec_st,void,vector unsigned int,long,vector unsigned int*)
#pragma tg_funcdef(vec_stvx,__vec_st,void,vector unsigned int,long,unsigned int*)
#pragma tg_funcdef(vec_stvx,__vec_st,void,vector signed int,long,vector signed int*)
#pragma tg_funcdef(vec_stvx,__vec_st,void,vector signed int,long,signed int*)
#pragma tg_funcdef(vec_stvx,__vec_st,void,vector bool int,long,vector bool int*)
#pragma tg_funcdef(vec_stvx,__vec_st,void,vector bool int,long,unsigned int*)
#pragma tg_funcdef(vec_stvx,__vec_st,void,vector bool int,long,int*)
#pragma tg_funcdef(vec_stvx,__vec_st,void,vector float,long,vector float*)
#pragma tg_funcdef(vec_stvx,__vec_st,void,vector float,long,float*)
#endif /* __64BIT__ */
#define vec_stvx(a,b,c)  __tg_builtin("vec_stvx",a,b,c)

/* vec_st */
#pragma tg_funcdef(vec_st,__vec_st,void,vector unsigned char,int,vector unsigned char*)
#pragma tg_funcdef(vec_st,__vec_st,void,vector unsigned char,int,unsigned char*)
#pragma tg_funcdef(vec_st,__vec_st,void,vector signed char,int,vector signed char*)
#pragma tg_funcdef(vec_st,__vec_st,void,vector signed char,int,signed char*)
#pragma tg_funcdef(vec_st,__vec_st,void,vector bool char,int,vector bool char*)
#pragma tg_funcdef(vec_st,__vec_st,void,vector bool char,int,unsigned char*)
#pragma tg_funcdef(vec_st,__vec_st,void,vector bool char,int,signed char*)
#pragma tg_funcdef(vec_st,__vec_st,void,vector unsigned short,int,vector unsigned short*)
#pragma tg_funcdef(vec_st,__vec_st,void,vector unsigned short,int,unsigned short*)
#pragma tg_funcdef(vec_st,__vec_st,void,vector signed short,int,vector signed short*)
#pragma tg_funcdef(vec_st,__vec_st,void,vector signed short,int,signed short*)
#pragma tg_funcdef(vec_st,__vec_st,void,vector bool short,int,vector bool short*)
#pragma tg_funcdef(vec_st,__vec_st,void,vector bool short,int,unsigned short*)
#pragma tg_funcdef(vec_st,__vec_st,void,vector bool short,int,short*)
#pragma tg_funcdef(vec_st,__vec_st,void,vector pixel,int,vector pixel*)
#pragma tg_funcdef(vec_st,__vec_st,void,vector pixel,int,unsigned short*)
#pragma tg_funcdef(vec_st,__vec_st,void,vector pixel,int,short*)
#pragma tg_funcdef(vec_st,__vec_st,void,vector unsigned int,int,vector unsigned int*)
#pragma tg_funcdef(vec_st,__vec_st,void,vector unsigned int,int,unsigned int*)
#pragma tg_funcdef(vec_st,__vec_st,void,vector signed int,int,vector signed int*)
#pragma tg_funcdef(vec_st,__vec_st,void,vector signed int,int,signed int*)
#ifndef __64BIT__
#pragma tg_funcdef(vec_st,__vec_st,void,vector unsigned int,int,unsigned long*)
#pragma tg_funcdef(vec_st,__vec_st,void,vector signed int,int,signed long*)
#endif /* __64BIT__ */
#pragma tg_funcdef(vec_st,__vec_st,void,vector bool int,int,vector bool int*)
#pragma tg_funcdef(vec_st,__vec_st,void,vector bool int,int,unsigned int*)
#pragma tg_funcdef(vec_st,__vec_st,void,vector bool int,int,int*)
#pragma tg_funcdef(vec_st,__vec_st,void,vector float,int,vector float*)
#pragma tg_funcdef(vec_st,__vec_st,void,vector float,int,float*)
#ifdef __64BIT__
#pragma tg_funcdef(vec_st,__vec_st,void,vector unsigned char,long,vector unsigned char*)
#pragma tg_funcdef(vec_st,__vec_st,void,vector unsigned char,long,unsigned char*)
#pragma tg_funcdef(vec_st,__vec_st,void,vector signed char,long,vector signed char*)
#pragma tg_funcdef(vec_st,__vec_st,void,vector signed char,long,signed char*)
#pragma tg_funcdef(vec_st,__vec_st,void,vector bool char,long,vector bool char*)
#pragma tg_funcdef(vec_st,__vec_st,void,vector bool char,long,unsigned char*)
#pragma tg_funcdef(vec_st,__vec_st,void,vector bool char,long,signed char*)
#pragma tg_funcdef(vec_st,__vec_st,void,vector unsigned short,long,vector unsigned short*)
#pragma tg_funcdef(vec_st,__vec_st,void,vector unsigned short,long,unsigned short*)
#pragma tg_funcdef(vec_st,__vec_st,void,vector signed short,long,vector signed short*)
#pragma tg_funcdef(vec_st,__vec_st,void,vector signed short,long,signed short*)
#pragma tg_funcdef(vec_st,__vec_st,void,vector bool short,long,vector bool short*)
#pragma tg_funcdef(vec_st,__vec_st,void,vector bool short,long,unsigned short*)
#pragma tg_funcdef(vec_st,__vec_st,void,vector bool short,long,short*)
#pragma tg_funcdef(vec_st,__vec_st,void,vector pixel,long,vector pixel*)
#pragma tg_funcdef(vec_st,__vec_st,void,vector pixel,long,unsigned short*)
#pragma tg_funcdef(vec_st,__vec_st,void,vector pixel,long,short*)
#pragma tg_funcdef(vec_st,__vec_st,void,vector unsigned int,long,vector unsigned int*)
#pragma tg_funcdef(vec_st,__vec_st,void,vector unsigned int,long,unsigned int*)
#pragma tg_funcdef(vec_st,__vec_st,void,vector signed int,long,vector signed int*)
#pragma tg_funcdef(vec_st,__vec_st,void,vector signed int,long,signed int*)
#pragma tg_funcdef(vec_st,__vec_st,void,vector bool int,long,vector bool int*)
#pragma tg_funcdef(vec_st,__vec_st,void,vector bool int,long,unsigned int*)
#pragma tg_funcdef(vec_st,__vec_st,void,vector bool int,long,int*)
#pragma tg_funcdef(vec_st,__vec_st,void,vector float,long,vector float*)
#pragma tg_funcdef(vec_st,__vec_st,void,vector float,long,float*)
#endif /* __64BIT__ */
#define vec_st(a,b,c)  __tg_builtin("vec_st",a,b,c)

/* vec_ste */
#pragma tg_funcdef(vec_ste,__vec_ste_b,void,vector unsigned char,int,unsigned char*)
#pragma tg_funcdef(vec_ste,__vec_ste_b,void,vector signed char,int,signed char*)
#pragma tg_funcdef(vec_ste,__vec_ste_b,void,vector bool char,int,unsigned char*)
#pragma tg_funcdef(vec_ste,__vec_ste_b,void,vector bool char,int,signed char*)
#pragma tg_funcdef(vec_ste,__vec_ste_h,void,vector unsigned short,int,unsigned short*)
#pragma tg_funcdef(vec_ste,__vec_ste_h,void,vector signed short,int,short*)
#pragma tg_funcdef(vec_ste,__vec_ste_h,void,vector bool short,int,unsigned short*)
#pragma tg_funcdef(vec_ste,__vec_ste_h,void,vector bool short,int,short*)
#pragma tg_funcdef(vec_ste,__vec_ste_h,void,vector pixel,int,unsigned short*)
#pragma tg_funcdef(vec_ste,__vec_ste_h,void,vector pixel,int,short*)
#pragma tg_funcdef(vec_ste,__vec_ste_w,void,vector unsigned int,int,unsigned int*)
#pragma tg_funcdef(vec_ste,__vec_ste_w,void,vector signed int,int,signed int*)
#ifndef __64BIT__
#pragma tg_funcdef(vec_ste,__vec_ste_w,void,vector unsigned int,int,unsigned long*)
#pragma tg_funcdef(vec_ste,__vec_ste_w,void,vector signed int,int,signed long*)
#endif /* __64BIT__ */
#pragma tg_funcdef(vec_ste,__vec_ste_w,void,vector bool int,int,unsigned int*)
#pragma tg_funcdef(vec_ste,__vec_ste_w,void,vector bool int,int,int*)
#pragma tg_funcdef(vec_ste,__vec_ste_w,void,vector float,int,float*)
#ifdef __64BIT__
#pragma tg_funcdef(vec_ste,__vec_ste_b,void,vector unsigned char,long,unsigned char*)
#pragma tg_funcdef(vec_ste,__vec_ste_b,void,vector signed char,long,signed char*)
#pragma tg_funcdef(vec_ste,__vec_ste_b,void,vector bool char,long,unsigned char*)
#pragma tg_funcdef(vec_ste,__vec_ste_b,void,vector bool char,long,signed char*)
#pragma tg_funcdef(vec_ste,__vec_ste_h,void,vector unsigned short,long,unsigned short*)
#pragma tg_funcdef(vec_ste,__vec_ste_h,void,vector signed short,long,short*)
#pragma tg_funcdef(vec_ste,__vec_ste_h,void,vector bool short,long,unsigned short*)
#pragma tg_funcdef(vec_ste,__vec_ste_h,void,vector bool short,long,short*)
#pragma tg_funcdef(vec_ste,__vec_ste_h,void,vector pixel,long,unsigned short*)
#pragma tg_funcdef(vec_ste,__vec_ste_h,void,vector pixel,long,short*)
#pragma tg_funcdef(vec_ste,__vec_ste_w,void,vector unsigned int,long,unsigned int*)
#pragma tg_funcdef(vec_ste,__vec_ste_w,void,vector signed int,long,signed int*)
#pragma tg_funcdef(vec_ste,__vec_ste_w,void,vector bool int,long,unsigned int*)
#pragma tg_funcdef(vec_ste,__vec_ste_w,void,vector bool int,long,int*)
#pragma tg_funcdef(vec_ste,__vec_ste_w,void,vector float,long,float*)
#endif /* __64BIT__ */
#define vec_ste(a,b,c)  __tg_builtin("vec_ste",a,b,c)

/* vec_stvebx */
#pragma tg_funcdef(vec_stvebx,__vec_ste_b,void,vector unsigned char,int,unsigned char*)
#pragma tg_funcdef(vec_stvebx,__vec_ste_b,void,vector signed char,int,signed char*)
#pragma tg_funcdef(vec_stvebx,__vec_ste_b,void,vector bool char,int,unsigned char*)
#pragma tg_funcdef(vec_stvebx,__vec_ste_b,void,vector bool char,int,signed char*)
#ifdef __64BIT__
#pragma tg_funcdef(vec_stvebx,__vec_ste_b,void,vector unsigned char,long,unsigned char*)
#pragma tg_funcdef(vec_stvebx,__vec_ste_b,void,vector signed char,long,signed char*)
#pragma tg_funcdef(vec_stvebx,__vec_ste_b,void,vector bool char,long,unsigned char*)
#pragma tg_funcdef(vec_stvebx,__vec_ste_b,void,vector bool char,long,signed char*)
#endif /* __64BIT__ */
#define vec_stvebx(a,b,c)  __tg_builtin("vec_stvebx",a,b,c)

/* vec_stvehx */
#pragma tg_funcdef(vec_stvehx,__vec_ste_h,void,vector unsigned short,int,unsigned short*)
#pragma tg_funcdef(vec_stvehx,__vec_ste_h,void,vector signed short,int,short*)
#pragma tg_funcdef(vec_stvehx,__vec_ste_h,void,vector bool short,int,unsigned short*)
#pragma tg_funcdef(vec_stvehx,__vec_ste_h,void,vector bool short,int,short*)
#pragma tg_funcdef(vec_stvehx,__vec_ste_h,void,vector pixel,int,unsigned short*)
#pragma tg_funcdef(vec_stvehx,__vec_ste_h,void,vector pixel,int,short*)
#ifdef __64BIT__
#pragma tg_funcdef(vec_stvehx,__vec_ste_h,void,vector unsigned short,long,unsigned short*)
#pragma tg_funcdef(vec_stvehx,__vec_ste_h,void,vector signed short,long,short*)
#pragma tg_funcdef(vec_stvehx,__vec_ste_h,void,vector bool short,long,unsigned short*)
#pragma tg_funcdef(vec_stvehx,__vec_ste_h,void,vector bool short,long,short*)
#pragma tg_funcdef(vec_stvehx,__vec_ste_h,void,vector pixel,long,unsigned short*)
#pragma tg_funcdef(vec_stvehx,__vec_ste_h,void,vector pixel,long,short*)
#endif /* __64BIT__ */
#define vec_stvehx(a,b,c)  __tg_builtin("vec_stvehx",a,b,c)

/* vec_stvewx */
#pragma tg_funcdef(vec_stvewx,__vec_ste_w,void,vector unsigned int,int,unsigned int*)
#pragma tg_funcdef(vec_stvewx,__vec_ste_w,void,vector signed int,int,signed int*)
#pragma tg_funcdef(vec_stvewx,__vec_ste_w,void,vector bool int,int,unsigned int*)
#pragma tg_funcdef(vec_stvewx,__vec_ste_w,void,vector bool int,int,int*)
#ifndef __64BIT__
#pragma tg_funcdef(vec_stvewx,__vec_ste_w,void,vector unsigned int,int,unsigned long*)
#pragma tg_funcdef(vec_stvewx,__vec_ste_w,void,vector signed int,int,signed long*)
#endif /* __64BIT__ */
#pragma tg_funcdef(vec_stvewx,__vec_ste_w,void,vector float,int,float*)
#ifdef __64BIT__
#pragma tg_funcdef(vec_stvewx,__vec_ste_w,void,vector unsigned int,long,unsigned int*)
#pragma tg_funcdef(vec_stvewx,__vec_ste_w,void,vector signed int,long,signed int*)
#pragma tg_funcdef(vec_stvewx,__vec_ste_w,void,vector bool int,long,unsigned int*)
#pragma tg_funcdef(vec_stvewx,__vec_ste_w,void,vector bool int,long,int*)
#pragma tg_funcdef(vec_stvewx,__vec_ste_w,void,vector float,long,float*)
#endif /* __64BIT__ */
#define vec_stvewx(a,b,c)  __tg_builtin("vec_stvewx",a,b,c)

/* vec_stvxl */
#pragma tg_funcdef(vec_stvxl,__vec_stl,void,vector unsigned char,int,vector unsigned char*)
#pragma tg_funcdef(vec_stvxl,__vec_stl,void,vector unsigned char,int,unsigned char*)
#pragma tg_funcdef(vec_stvxl,__vec_stl,void,vector signed char,int,vector signed char*)
#pragma tg_funcdef(vec_stvxl,__vec_stl,void,vector signed char,int,signed char*)
#pragma tg_funcdef(vec_stvxl,__vec_stl,void,vector bool char,int,vector bool char*)
#pragma tg_funcdef(vec_stvxl,__vec_stl,void,vector bool char,int,unsigned char*)
#pragma tg_funcdef(vec_stvxl,__vec_stl,void,vector bool char,int,signed char*)
#pragma tg_funcdef(vec_stvxl,__vec_stl,void,vector unsigned short,int,vector unsigned short*)
#pragma tg_funcdef(vec_stvxl,__vec_stl,void,vector unsigned short,int,unsigned short*)
#pragma tg_funcdef(vec_stvxl,__vec_stl,void,vector signed short,int,vector signed short*)
#pragma tg_funcdef(vec_stvxl,__vec_stl,void,vector signed short,int,signed short*)
#pragma tg_funcdef(vec_stvxl,__vec_stl,void,vector bool short,int,vector bool short*)
#pragma tg_funcdef(vec_stvxl,__vec_stl,void,vector bool short,int,unsigned short*)
#pragma tg_funcdef(vec_stvxl,__vec_stl,void,vector bool short,int,short*)
#pragma tg_funcdef(vec_stvxl,__vec_stl,void,vector pixel,int,vector pixel*)
#pragma tg_funcdef(vec_stvxl,__vec_stl,void,vector pixel,int,unsigned short*)
#pragma tg_funcdef(vec_stvxl,__vec_stl,void,vector pixel,int,short*)
#pragma tg_funcdef(vec_stvxl,__vec_stl,void,vector unsigned int,int,vector unsigned int*)
#pragma tg_funcdef(vec_stvxl,__vec_stl,void,vector unsigned int,int,unsigned int*)
#pragma tg_funcdef(vec_stvxl,__vec_stl,void,vector signed int,int,vector signed int*)
#pragma tg_funcdef(vec_stvxl,__vec_stl,void,vector signed int,int,signed int*)
#ifndef __64BIT__
#pragma tg_funcdef(vec_stvxl,__vec_stl,void,vector unsigned int,int,unsigned long*)
#pragma tg_funcdef(vec_stvxl,__vec_stl,void,vector signed int,int,signed long*)
#endif /* __64BIT__ */
#pragma tg_funcdef(vec_stvxl,__vec_stl,void,vector bool int,int,vector bool int*)
#pragma tg_funcdef(vec_stvxl,__vec_stl,void,vector bool int,int,unsigned int*)
#pragma tg_funcdef(vec_stvxl,__vec_stl,void,vector bool int,int,int*)
#pragma tg_funcdef(vec_stvxl,__vec_stl,void,vector float,int,vector float*)
#pragma tg_funcdef(vec_stvxl,__vec_stl,void,vector float,int,float*)
#ifdef __64BIT__
#pragma tg_funcdef(vec_stvxl,__vec_stl,void,vector unsigned char,long,vector unsigned char*)
#pragma tg_funcdef(vec_stvxl,__vec_stl,void,vector unsigned char,long,unsigned char*)
#pragma tg_funcdef(vec_stvxl,__vec_stl,void,vector signed char,long,vector signed char*)
#pragma tg_funcdef(vec_stvxl,__vec_stl,void,vector signed char,long,signed char*)
#pragma tg_funcdef(vec_stvxl,__vec_stl,void,vector bool char,long,vector bool char*)
#pragma tg_funcdef(vec_stvxl,__vec_stl,void,vector bool char,long,unsigned char*)
#pragma tg_funcdef(vec_stvxl,__vec_stl,void,vector bool char,long,signed char*)
#pragma tg_funcdef(vec_stvxl,__vec_stl,void,vector unsigned short,long,vector unsigned short*)
#pragma tg_funcdef(vec_stvxl,__vec_stl,void,vector unsigned short,long,unsigned short*)
#pragma tg_funcdef(vec_stvxl,__vec_stl,void,vector signed short,long,vector signed short*)
#pragma tg_funcdef(vec_stvxl,__vec_stl,void,vector signed short,long,signed short*)
#pragma tg_funcdef(vec_stvxl,__vec_stl,void,vector bool short,long,vector bool short*)
#pragma tg_funcdef(vec_stvxl,__vec_stl,void,vector bool short,long,unsigned short*)
#pragma tg_funcdef(vec_stvxl,__vec_stl,void,vector bool short,long,short*)
#pragma tg_funcdef(vec_stvxl,__vec_stl,void,vector pixel,long,vector pixel*)
#pragma tg_funcdef(vec_stvxl,__vec_stl,void,vector pixel,long,unsigned short*)
#pragma tg_funcdef(vec_stvxl,__vec_stl,void,vector pixel,long,short*)
#pragma tg_funcdef(vec_stvxl,__vec_stl,void,vector unsigned int,long,vector unsigned int*)
#pragma tg_funcdef(vec_stvxl,__vec_stl,void,vector unsigned int,long,unsigned int*)
#pragma tg_funcdef(vec_stvxl,__vec_stl,void,vector signed int,long,vector signed int*)
#pragma tg_funcdef(vec_stvxl,__vec_stl,void,vector signed int,long,signed int*)
#pragma tg_funcdef(vec_stvxl,__vec_stl,void,vector bool int,long,vector bool int*)
#pragma tg_funcdef(vec_stvxl,__vec_stl,void,vector bool int,long,unsigned int*)
#pragma tg_funcdef(vec_stvxl,__vec_stl,void,vector bool int,long,int*)
#pragma tg_funcdef(vec_stvxl,__vec_stl,void,vector float,long,vector float*)
#pragma tg_funcdef(vec_stvxl,__vec_stl,void,vector float,long,float*)
#endif /* __64BIT__ */
#define vec_stvxl(a,b,c)  __tg_builtin("vec_stvxl",a,b,c)

/* vec_stl */
#pragma tg_funcdef(vec_stl,__vec_stl,void,vector unsigned char,int,vector unsigned char*)
#pragma tg_funcdef(vec_stl,__vec_stl,void,vector unsigned char,int,unsigned char*)
#pragma tg_funcdef(vec_stl,__vec_stl,void,vector signed char,int,vector signed char*)
#pragma tg_funcdef(vec_stl,__vec_stl,void,vector signed char,int,signed char*)
#pragma tg_funcdef(vec_stl,__vec_stl,void,vector bool char,int,vector bool char*)
#pragma tg_funcdef(vec_stl,__vec_stl,void,vector bool char,int,unsigned char*)
#pragma tg_funcdef(vec_stl,__vec_stl,void,vector bool char,int,signed char*)
#pragma tg_funcdef(vec_stl,__vec_stl,void,vector unsigned short,int,vector unsigned short*)
#pragma tg_funcdef(vec_stl,__vec_stl,void,vector unsigned short,int,unsigned short*)
#pragma tg_funcdef(vec_stl,__vec_stl,void,vector signed short,int,vector signed short*)
#pragma tg_funcdef(vec_stl,__vec_stl,void,vector signed short,int,signed short*)
#pragma tg_funcdef(vec_stl,__vec_stl,void,vector bool short,int,vector bool short*)
#pragma tg_funcdef(vec_stl,__vec_stl,void,vector bool short,int,unsigned short*)
#pragma tg_funcdef(vec_stl,__vec_stl,void,vector bool short,int,short*)
#pragma tg_funcdef(vec_stl,__vec_stl,void,vector pixel,int,vector pixel*)
#pragma tg_funcdef(vec_stl,__vec_stl,void,vector pixel,int,unsigned short*)
#pragma tg_funcdef(vec_stl,__vec_stl,void,vector pixel,int,short*)
#pragma tg_funcdef(vec_stl,__vec_stl,void,vector unsigned int,int,vector unsigned int*)
#pragma tg_funcdef(vec_stl,__vec_stl,void,vector unsigned int,int,unsigned int*)
#pragma tg_funcdef(vec_stl,__vec_stl,void,vector signed int,int,vector signed int*)
#pragma tg_funcdef(vec_stl,__vec_stl,void,vector signed int,int,signed int*)
#ifndef __64BIT__
#pragma tg_funcdef(vec_stl,__vec_stl,void,vector unsigned int,int,unsigned long*)
#pragma tg_funcdef(vec_stl,__vec_stl,void,vector signed int,int,signed long*)
#endif /* __64BIT__ */
#pragma tg_funcdef(vec_stl,__vec_stl,void,vector bool int,int,vector bool int*)
#pragma tg_funcdef(vec_stl,__vec_stl,void,vector bool int,int,unsigned int*)
#pragma tg_funcdef(vec_stl,__vec_stl,void,vector bool int,int,int*)
#pragma tg_funcdef(vec_stl,__vec_stl,void,vector float,int,vector float*)
#pragma tg_funcdef(vec_stl,__vec_stl,void,vector float,int,float*)
#ifdef __64BIT__
#pragma tg_funcdef(vec_stl,__vec_stl,void,vector unsigned char,long,vector unsigned char*)
#pragma tg_funcdef(vec_stl,__vec_stl,void,vector unsigned char,long,unsigned char*)
#pragma tg_funcdef(vec_stl,__vec_stl,void,vector signed char,long,vector signed char*)
#pragma tg_funcdef(vec_stl,__vec_stl,void,vector signed char,long,signed char*)
#pragma tg_funcdef(vec_stl,__vec_stl,void,vector bool char,long,vector bool char*)
#pragma tg_funcdef(vec_stl,__vec_stl,void,vector bool char,long,unsigned char*)
#pragma tg_funcdef(vec_stl,__vec_stl,void,vector bool char,long,signed char*)
#pragma tg_funcdef(vec_stl,__vec_stl,void,vector unsigned short,long,vector unsigned short*)
#pragma tg_funcdef(vec_stl,__vec_stl,void,vector unsigned short,long,unsigned short*)
#pragma tg_funcdef(vec_stl,__vec_stl,void,vector signed short,long,vector signed short*)
#pragma tg_funcdef(vec_stl,__vec_stl,void,vector signed short,long,signed short*)
#pragma tg_funcdef(vec_stl,__vec_stl,void,vector bool short,long,vector bool short*)
#pragma tg_funcdef(vec_stl,__vec_stl,void,vector bool short,long,unsigned short*)
#pragma tg_funcdef(vec_stl,__vec_stl,void,vector bool short,long,short*)
#pragma tg_funcdef(vec_stl,__vec_stl,void,vector pixel,long,vector pixel*)
#pragma tg_funcdef(vec_stl,__vec_stl,void,vector pixel,long,unsigned short*)
#pragma tg_funcdef(vec_stl,__vec_stl,void,vector pixel,long,short*)
#pragma tg_funcdef(vec_stl,__vec_stl,void,vector unsigned int,long,vector unsigned int*)
#pragma tg_funcdef(vec_stl,__vec_stl,void,vector unsigned int,long,unsigned int*)
#pragma tg_funcdef(vec_stl,__vec_stl,void,vector signed int,long,vector signed int*)
#pragma tg_funcdef(vec_stl,__vec_stl,void,vector signed int,long,signed int*)
#pragma tg_funcdef(vec_stl,__vec_stl,void,vector bool int,long,vector bool int*)
#pragma tg_funcdef(vec_stl,__vec_stl,void,vector bool int,long,unsigned int*)
#pragma tg_funcdef(vec_stl,__vec_stl,void,vector bool int,long,int*)
#pragma tg_funcdef(vec_stl,__vec_stl,void,vector float,long,vector float*)
#pragma tg_funcdef(vec_stl,__vec_stl,void,vector float,long,float*)
#endif /* __64BIT__ */
#define vec_stl(a,b,c)  __tg_builtin("vec_stl",a,b,c)

/* vec_stvlx */
#pragma tg_funcdef(vec_stvlx,__vec_stvlx,void,vector unsigned char,int,vector unsigned char*)
#pragma tg_funcdef(vec_stvlx,__vec_stvlx,void,vector unsigned char,int,unsigned char*)
#pragma tg_funcdef(vec_stvlx,__vec_stvlx,void,vector signed char,int,vector signed char*)
#pragma tg_funcdef(vec_stvlx,__vec_stvlx,void,vector signed char,int,signed char*)
#pragma tg_funcdef(vec_stvlx,__vec_stvlx,void,vector bool char,int,vector bool char*)
#pragma tg_funcdef(vec_stvlx,__vec_stvlx,void,vector bool char,int,unsigned char*)
#pragma tg_funcdef(vec_stvlx,__vec_stvlx,void,vector bool char,int,signed char*)
#pragma tg_funcdef(vec_stvlx,__vec_stvlx,void,vector unsigned short,int,vector unsigned short*)
#pragma tg_funcdef(vec_stvlx,__vec_stvlx,void,vector unsigned short,int,unsigned short*)
#pragma tg_funcdef(vec_stvlx,__vec_stvlx,void,vector signed short,int,vector signed short*)
#pragma tg_funcdef(vec_stvlx,__vec_stvlx,void,vector signed short,int,signed short*)
#pragma tg_funcdef(vec_stvlx,__vec_stvlx,void,vector bool short,int,vector bool short*)
#pragma tg_funcdef(vec_stvlx,__vec_stvlx,void,vector bool short,int,unsigned short*)
#pragma tg_funcdef(vec_stvlx,__vec_stvlx,void,vector bool short,int,short*)
#pragma tg_funcdef(vec_stvlx,__vec_stvlx,void,vector pixel,int,vector pixel*)
#pragma tg_funcdef(vec_stvlx,__vec_stvlx,void,vector pixel,int,unsigned short*)
#pragma tg_funcdef(vec_stvlx,__vec_stvlx,void,vector pixel,int,short*)
#pragma tg_funcdef(vec_stvlx,__vec_stvlx,void,vector unsigned int,int,vector unsigned int*)
#pragma tg_funcdef(vec_stvlx,__vec_stvlx,void,vector unsigned int,int,unsigned int*)
#pragma tg_funcdef(vec_stvlx,__vec_stvlx,void,vector signed int,int,vector signed int*)
#pragma tg_funcdef(vec_stvlx,__vec_stvlx,void,vector signed int,int,signed int*)
#ifndef __64BIT__
#pragma tg_funcdef(vec_stvlx,__vec_stvlx,void,vector unsigned int,int,unsigned long*)
#pragma tg_funcdef(vec_stvlx,__vec_stvlx,void,vector signed int,int,signed long*)
#endif /* __64BIT__ */
#pragma tg_funcdef(vec_stvlx,__vec_stvlx,void,vector bool int,int,vector bool int*)
#pragma tg_funcdef(vec_stvlx,__vec_stvlx,void,vector bool int,int,unsigned int*)
#pragma tg_funcdef(vec_stvlx,__vec_stvlx,void,vector bool int,int,int*)
#pragma tg_funcdef(vec_stvlx,__vec_stvlx,void,vector float,int,vector float*)
#pragma tg_funcdef(vec_stvlx,__vec_stvlx,void,vector float,int,float*)
#ifdef __64BIT__
#pragma tg_funcdef(vec_stvlx,__vec_stvlx,void,vector unsigned char,long,vector unsigned char*)
#pragma tg_funcdef(vec_stvlx,__vec_stvlx,void,vector unsigned char,long,unsigned char*)
#pragma tg_funcdef(vec_stvlx,__vec_stvlx,void,vector signed char,long,vector signed char*)
#pragma tg_funcdef(vec_stvlx,__vec_stvlx,void,vector signed char,long,signed char*)
#pragma tg_funcdef(vec_stvlx,__vec_stvlx,void,vector bool char,long,vector bool char*)
#pragma tg_funcdef(vec_stvlx,__vec_stvlx,void,vector bool char,long,unsigned char*)
#pragma tg_funcdef(vec_stvlx,__vec_stvlx,void,vector bool char,long,signed char*)
#pragma tg_funcdef(vec_stvlx,__vec_stvlx,void,vector unsigned short,long,vector unsigned short*)
#pragma tg_funcdef(vec_stvlx,__vec_stvlx,void,vector unsigned short,long,unsigned short*)
#pragma tg_funcdef(vec_stvlx,__vec_stvlx,void,vector signed short,long,vector signed short*)
#pragma tg_funcdef(vec_stvlx,__vec_stvlx,void,vector signed short,long,signed short*)
#pragma tg_funcdef(vec_stvlx,__vec_stvlx,void,vector bool short,long,vector bool short*)
#pragma tg_funcdef(vec_stvlx,__vec_stvlx,void,vector bool short,long,unsigned short*)
#pragma tg_funcdef(vec_stvlx,__vec_stvlx,void,vector bool short,long,short*)
#pragma tg_funcdef(vec_stvlx,__vec_stvlx,void,vector pixel,long,vector pixel*)
#pragma tg_funcdef(vec_stvlx,__vec_stvlx,void,vector pixel,long,unsigned short*)
#pragma tg_funcdef(vec_stvlx,__vec_stvlx,void,vector pixel,long,short*)
#pragma tg_funcdef(vec_stvlx,__vec_stvlx,void,vector unsigned int,long,vector unsigned int*)
#pragma tg_funcdef(vec_stvlx,__vec_stvlx,void,vector unsigned int,long,unsigned int*)
#pragma tg_funcdef(vec_stvlx,__vec_stvlx,void,vector signed int,long,vector signed int*)
#pragma tg_funcdef(vec_stvlx,__vec_stvlx,void,vector signed int,long,signed int*)
#pragma tg_funcdef(vec_stvlx,__vec_stvlx,void,vector bool int,long,vector bool int*)
#pragma tg_funcdef(vec_stvlx,__vec_stvlx,void,vector bool int,long,unsigned int*)
#pragma tg_funcdef(vec_stvlx,__vec_stvlx,void,vector bool int,long,int*)
#pragma tg_funcdef(vec_stvlx,__vec_stvlx,void,vector float,long,vector float*)
#pragma tg_funcdef(vec_stvlx,__vec_stvlx,void,vector float,long,float*)
#endif /* __64BIT__ */
#define vec_stvlx(a,b,c)  __tg_builtin("vec_stvlx",a,b,c)

/* vec_stvlxl */
#pragma tg_funcdef(vec_stvlxl,__vec_stvlxl,void,vector unsigned char,int,vector unsigned char*)
#pragma tg_funcdef(vec_stvlxl,__vec_stvlxl,void,vector unsigned char,int,unsigned char*)
#pragma tg_funcdef(vec_stvlxl,__vec_stvlxl,void,vector signed char,int,vector signed char*)
#pragma tg_funcdef(vec_stvlxl,__vec_stvlxl,void,vector signed char,int,signed char*)
#pragma tg_funcdef(vec_stvlxl,__vec_stvlxl,void,vector bool char,int,vector bool char*)
#pragma tg_funcdef(vec_stvlxl,__vec_stvlxl,void,vector bool char,int,unsigned char*)
#pragma tg_funcdef(vec_stvlxl,__vec_stvlxl,void,vector bool char,int,signed char*)
#pragma tg_funcdef(vec_stvlxl,__vec_stvlxl,void,vector unsigned short,int,vector unsigned short*)
#pragma tg_funcdef(vec_stvlxl,__vec_stvlxl,void,vector unsigned short,int,unsigned short*)
#pragma tg_funcdef(vec_stvlxl,__vec_stvlxl,void,vector signed short,int,vector signed short*)
#pragma tg_funcdef(vec_stvlxl,__vec_stvlxl,void,vector signed short,int,signed short*)
#pragma tg_funcdef(vec_stvlxl,__vec_stvlxl,void,vector bool short,int,vector bool short*)
#pragma tg_funcdef(vec_stvlxl,__vec_stvlxl,void,vector bool short,int,unsigned short*)
#pragma tg_funcdef(vec_stvlxl,__vec_stvlxl,void,vector bool short,int,short*)
#pragma tg_funcdef(vec_stvlxl,__vec_stvlxl,void,vector pixel,int,vector pixel*)
#pragma tg_funcdef(vec_stvlxl,__vec_stvlxl,void,vector pixel,int,unsigned short*)
#pragma tg_funcdef(vec_stvlxl,__vec_stvlxl,void,vector pixel,int,short*)
#pragma tg_funcdef(vec_stvlxl,__vec_stvlxl,void,vector unsigned int,int,vector unsigned int*)
#pragma tg_funcdef(vec_stvlxl,__vec_stvlxl,void,vector unsigned int,int,unsigned int*)
#pragma tg_funcdef(vec_stvlxl,__vec_stvlxl,void,vector signed int,int,vector signed int*)
#pragma tg_funcdef(vec_stvlxl,__vec_stvlxl,void,vector signed int,int,signed int*)
#ifndef __64BIT__
#pragma tg_funcdef(vec_stvlxl,__vec_stvlxl,void,vector unsigned int,int,unsigned long*)
#pragma tg_funcdef(vec_stvlxl,__vec_stvlxl,void,vector signed int,int,signed long*)
#endif /* __64BIT__ */
#pragma tg_funcdef(vec_stvlxl,__vec_stvlxl,void,vector bool int,int,vector bool int*)
#pragma tg_funcdef(vec_stvlxl,__vec_stvlxl,void,vector bool int,int,unsigned int*)
#pragma tg_funcdef(vec_stvlxl,__vec_stvlxl,void,vector bool int,int,int*)
#pragma tg_funcdef(vec_stvlxl,__vec_stvlxl,void,vector float,int,vector float*)
#pragma tg_funcdef(vec_stvlxl,__vec_stvlxl,void,vector float,int,float*)
#ifdef __64BIT__
#pragma tg_funcdef(vec_stvlxl,__vec_stvlxl,void,vector unsigned char,long,vector unsigned char*)
#pragma tg_funcdef(vec_stvlxl,__vec_stvlxl,void,vector unsigned char,long,unsigned char*)
#pragma tg_funcdef(vec_stvlxl,__vec_stvlxl,void,vector signed char,long,vector signed char*)
#pragma tg_funcdef(vec_stvlxl,__vec_stvlxl,void,vector signed char,long,signed char*)
#pragma tg_funcdef(vec_stvlxl,__vec_stvlxl,void,vector bool char,long,vector bool char*)
#pragma tg_funcdef(vec_stvlxl,__vec_stvlxl,void,vector bool char,long,unsigned char*)
#pragma tg_funcdef(vec_stvlxl,__vec_stvlxl,void,vector bool char,long,signed char*)
#pragma tg_funcdef(vec_stvlxl,__vec_stvlxl,void,vector unsigned short,long,vector unsigned short*)
#pragma tg_funcdef(vec_stvlxl,__vec_stvlxl,void,vector unsigned short,long,unsigned short*)
#pragma tg_funcdef(vec_stvlxl,__vec_stvlxl,void,vector signed short,long,vector signed short*)
#pragma tg_funcdef(vec_stvlxl,__vec_stvlxl,void,vector signed short,long,signed short*)
#pragma tg_funcdef(vec_stvlxl,__vec_stvlxl,void,vector bool short,long,vector bool short*)
#pragma tg_funcdef(vec_stvlxl,__vec_stvlxl,void,vector bool short,long,unsigned short*)
#pragma tg_funcdef(vec_stvlxl,__vec_stvlxl,void,vector bool short,long,short*)
#pragma tg_funcdef(vec_stvlxl,__vec_stvlxl,void,vector pixel,long,vector pixel*)
#pragma tg_funcdef(vec_stvlxl,__vec_stvlxl,void,vector pixel,long,unsigned short*)
#pragma tg_funcdef(vec_stvlxl,__vec_stvlxl,void,vector pixel,long,short*)
#pragma tg_funcdef(vec_stvlxl,__vec_stvlxl,void,vector unsigned int,long,vector unsigned int*)
#pragma tg_funcdef(vec_stvlxl,__vec_stvlxl,void,vector unsigned int,long,unsigned int*)
#pragma tg_funcdef(vec_stvlxl,__vec_stvlxl,void,vector signed int,long,vector signed int*)
#pragma tg_funcdef(vec_stvlxl,__vec_stvlxl,void,vector signed int,long,signed int*)
#pragma tg_funcdef(vec_stvlxl,__vec_stvlxl,void,vector bool int,long,vector bool int*)
#pragma tg_funcdef(vec_stvlxl,__vec_stvlxl,void,vector bool int,long,unsigned int*)
#pragma tg_funcdef(vec_stvlxl,__vec_stvlxl,void,vector bool int,long,int*)
#pragma tg_funcdef(vec_stvlxl,__vec_stvlxl,void,vector float,long,vector float*)
#pragma tg_funcdef(vec_stvlxl,__vec_stvlxl,void,vector float,long,float*)
#endif /* __64BIT__ */
#define vec_stvlxl(a,b,c)  __tg_builtin("vec_stvlxl",a,b,c)

/* vec_stvlx */
#pragma tg_funcdef(vec_stvrx,__vec_stvrx,void,vector unsigned char,int,vector unsigned char*)
#pragma tg_funcdef(vec_stvrx,__vec_stvrx,void,vector unsigned char,int,unsigned char*)
#pragma tg_funcdef(vec_stvrx,__vec_stvrx,void,vector signed char,int,vector signed char*)
#pragma tg_funcdef(vec_stvrx,__vec_stvrx,void,vector signed char,int,signed char*)
#pragma tg_funcdef(vec_stvrx,__vec_stvrx,void,vector bool char,int,vector bool char*)
#pragma tg_funcdef(vec_stvrx,__vec_stvrx,void,vector bool char,int,unsigned char*)
#pragma tg_funcdef(vec_stvrx,__vec_stvrx,void,vector bool char,int,signed char*)
#pragma tg_funcdef(vec_stvrx,__vec_stvrx,void,vector unsigned short,int,vector unsigned short*)
#pragma tg_funcdef(vec_stvrx,__vec_stvrx,void,vector unsigned short,int,unsigned short*)
#pragma tg_funcdef(vec_stvrx,__vec_stvrx,void,vector signed short,int,vector signed short*)
#pragma tg_funcdef(vec_stvrx,__vec_stvrx,void,vector signed short,int,signed short*)
#pragma tg_funcdef(vec_stvrx,__vec_stvrx,void,vector bool short,int,vector bool short*)
#pragma tg_funcdef(vec_stvrx,__vec_stvrx,void,vector bool short,int,unsigned short*)
#pragma tg_funcdef(vec_stvrx,__vec_stvrx,void,vector bool short,int,short*)
#pragma tg_funcdef(vec_stvrx,__vec_stvrx,void,vector pixel,int,vector pixel*)
#pragma tg_funcdef(vec_stvrx,__vec_stvrx,void,vector pixel,int,unsigned short*)
#pragma tg_funcdef(vec_stvrx,__vec_stvrx,void,vector pixel,int,short*)
#pragma tg_funcdef(vec_stvrx,__vec_stvrx,void,vector unsigned int,int,vector unsigned int*)
#pragma tg_funcdef(vec_stvrx,__vec_stvrx,void,vector unsigned int,int,unsigned int*)
#pragma tg_funcdef(vec_stvrx,__vec_stvrx,void,vector signed int,int,vector signed int*)
#pragma tg_funcdef(vec_stvrx,__vec_stvrx,void,vector signed int,int,signed int*)
#ifndef __64BIT__
#pragma tg_funcdef(vec_stvrx,__vec_stvrx,void,vector unsigned int,int,unsigned long*)
#pragma tg_funcdef(vec_stvrx,__vec_stvrx,void,vector signed int,int,signed long*)
#endif /* __64BIT__ */
#pragma tg_funcdef(vec_stvrx,__vec_stvrx,void,vector bool int,int,vector bool int*)
#pragma tg_funcdef(vec_stvrx,__vec_stvrx,void,vector bool int,int,unsigned int*)
#pragma tg_funcdef(vec_stvrx,__vec_stvrx,void,vector bool int,int,int*)
#pragma tg_funcdef(vec_stvrx,__vec_stvrx,void,vector float,int,vector float*)
#pragma tg_funcdef(vec_stvrx,__vec_stvrx,void,vector float,int,float*)
#ifdef __64BIT__
#pragma tg_funcdef(vec_stvrx,__vec_stvrx,void,vector unsigned char,long,vector unsigned char*)
#pragma tg_funcdef(vec_stvrx,__vec_stvrx,void,vector unsigned char,long,unsigned char*)
#pragma tg_funcdef(vec_stvrx,__vec_stvrx,void,vector signed char,long,vector signed char*)
#pragma tg_funcdef(vec_stvrx,__vec_stvrx,void,vector signed char,long,signed char*)
#pragma tg_funcdef(vec_stvrx,__vec_stvrx,void,vector bool char,long,vector bool char*)
#pragma tg_funcdef(vec_stvrx,__vec_stvrx,void,vector bool char,long,unsigned char*)
#pragma tg_funcdef(vec_stvrx,__vec_stvrx,void,vector bool char,long,signed char*)
#pragma tg_funcdef(vec_stvrx,__vec_stvrx,void,vector unsigned short,long,vector unsigned short*)
#pragma tg_funcdef(vec_stvrx,__vec_stvrx,void,vector unsigned short,long,unsigned short*)
#pragma tg_funcdef(vec_stvrx,__vec_stvrx,void,vector signed short,long,vector signed short*)
#pragma tg_funcdef(vec_stvrx,__vec_stvrx,void,vector signed short,long,signed short*)
#pragma tg_funcdef(vec_stvrx,__vec_stvrx,void,vector bool short,long,vector bool short*)
#pragma tg_funcdef(vec_stvrx,__vec_stvrx,void,vector bool short,long,unsigned short*)
#pragma tg_funcdef(vec_stvrx,__vec_stvrx,void,vector bool short,long,short*)
#pragma tg_funcdef(vec_stvrx,__vec_stvrx,void,vector pixel,long,vector pixel*)
#pragma tg_funcdef(vec_stvrx,__vec_stvrx,void,vector pixel,long,unsigned short*)
#pragma tg_funcdef(vec_stvrx,__vec_stvrx,void,vector pixel,long,short*)
#pragma tg_funcdef(vec_stvrx,__vec_stvrx,void,vector unsigned int,long,vector unsigned int*)
#pragma tg_funcdef(vec_stvrx,__vec_stvrx,void,vector unsigned int,long,unsigned int*)
#pragma tg_funcdef(vec_stvrx,__vec_stvrx,void,vector signed int,long,vector signed int*)
#pragma tg_funcdef(vec_stvrx,__vec_stvrx,void,vector signed int,long,signed int*)
#pragma tg_funcdef(vec_stvrx,__vec_stvrx,void,vector bool int,long,vector bool int*)
#pragma tg_funcdef(vec_stvrx,__vec_stvrx,void,vector bool int,long,unsigned int*)
#pragma tg_funcdef(vec_stvrx,__vec_stvrx,void,vector bool int,long,int*)
#pragma tg_funcdef(vec_stvrx,__vec_stvrx,void,vector float,long,vector float*)
#pragma tg_funcdef(vec_stvrx,__vec_stvrx,void,vector float,long,float*)
#endif /* __64BIT__ */
#define vec_stvrx(a,b,c)  __tg_builtin("vec_stvrx",a,b,c)

/* vec_stvrxl */
#pragma tg_funcdef(vec_stvrxl,__vec_stvrxl,void,vector unsigned char,int,vector unsigned char*)
#pragma tg_funcdef(vec_stvrxl,__vec_stvrxl,void,vector unsigned char,int,unsigned char*)
#pragma tg_funcdef(vec_stvrxl,__vec_stvrxl,void,vector signed char,int,vector signed char*)
#pragma tg_funcdef(vec_stvrxl,__vec_stvrxl,void,vector signed char,int,signed char*)
#pragma tg_funcdef(vec_stvrxl,__vec_stvrxl,void,vector bool char,int,vector bool char*)
#pragma tg_funcdef(vec_stvrxl,__vec_stvrxl,void,vector bool char,int,unsigned char*)
#pragma tg_funcdef(vec_stvrxl,__vec_stvrxl,void,vector bool char,int,signed char*)
#pragma tg_funcdef(vec_stvrxl,__vec_stvrxl,void,vector unsigned short,int,vector unsigned short*)
#pragma tg_funcdef(vec_stvrxl,__vec_stvrxl,void,vector unsigned short,int,unsigned short*)
#pragma tg_funcdef(vec_stvrxl,__vec_stvrxl,void,vector signed short,int,vector signed short*)
#pragma tg_funcdef(vec_stvrxl,__vec_stvrxl,void,vector signed short,int,signed short*)
#pragma tg_funcdef(vec_stvrxl,__vec_stvrxl,void,vector bool short,int,vector bool short*)
#pragma tg_funcdef(vec_stvrxl,__vec_stvrxl,void,vector bool short,int,unsigned short*)
#pragma tg_funcdef(vec_stvrxl,__vec_stvrxl,void,vector bool short,int,short*)
#pragma tg_funcdef(vec_stvrxl,__vec_stvrxl,void,vector pixel,int,vector pixel*)
#pragma tg_funcdef(vec_stvrxl,__vec_stvrxl,void,vector pixel,int,unsigned short*)
#pragma tg_funcdef(vec_stvrxl,__vec_stvrxl,void,vector pixel,int,short*)
#pragma tg_funcdef(vec_stvrxl,__vec_stvrxl,void,vector unsigned int,int,vector unsigned int*)
#pragma tg_funcdef(vec_stvrxl,__vec_stvrxl,void,vector unsigned int,int,unsigned int*)
#pragma tg_funcdef(vec_stvrxl,__vec_stvrxl,void,vector signed int,int,vector signed int*)
#pragma tg_funcdef(vec_stvrxl,__vec_stvrxl,void,vector signed int,int,signed int*)
#ifndef __64BIT__
#pragma tg_funcdef(vec_stvrxl,__vec_stvrxl,void,vector unsigned int,int,unsigned long*)
#pragma tg_funcdef(vec_stvrxl,__vec_stvrxl,void,vector signed int,int,signed long*)
#endif /* __64BIT__ */
#pragma tg_funcdef(vec_stvrxl,__vec_stvrxl,void,vector bool int,int,vector bool int*)
#pragma tg_funcdef(vec_stvrxl,__vec_stvrxl,void,vector bool int,int,unsigned int*)
#pragma tg_funcdef(vec_stvrxl,__vec_stvrxl,void,vector bool int,int,int*)
#pragma tg_funcdef(vec_stvrxl,__vec_stvrxl,void,vector float,int,vector float*)
#pragma tg_funcdef(vec_stvrxl,__vec_stvrxl,void,vector float,int,float*)
#ifdef __64BIT__
#pragma tg_funcdef(vec_stvrxl,__vec_stvrxl,void,vector unsigned char,long,vector unsigned char*)
#pragma tg_funcdef(vec_stvrxl,__vec_stvrxl,void,vector unsigned char,long,unsigned char*)
#pragma tg_funcdef(vec_stvrxl,__vec_stvrxl,void,vector signed char,long,vector signed char*)
#pragma tg_funcdef(vec_stvrxl,__vec_stvrxl,void,vector signed char,long,signed char*)
#pragma tg_funcdef(vec_stvrxl,__vec_stvrxl,void,vector bool char,long,vector bool char*)
#pragma tg_funcdef(vec_stvrxl,__vec_stvrxl,void,vector bool char,long,unsigned char*)
#pragma tg_funcdef(vec_stvrxl,__vec_stvrxl,void,vector bool char,long,signed char*)
#pragma tg_funcdef(vec_stvrxl,__vec_stvrxl,void,vector unsigned short,long,vector unsigned short*)
#pragma tg_funcdef(vec_stvrxl,__vec_stvrxl,void,vector unsigned short,long,unsigned short*)
#pragma tg_funcdef(vec_stvrxl,__vec_stvrxl,void,vector signed short,long,vector signed short*)
#pragma tg_funcdef(vec_stvrxl,__vec_stvrxl,void,vector signed short,long,signed short*)
#pragma tg_funcdef(vec_stvrxl,__vec_stvrxl,void,vector bool short,long,vector bool short*)
#pragma tg_funcdef(vec_stvrxl,__vec_stvrxl,void,vector bool short,long,unsigned short*)
#pragma tg_funcdef(vec_stvrxl,__vec_stvrxl,void,vector bool short,long,short*)
#pragma tg_funcdef(vec_stvrxl,__vec_stvrxl,void,vector pixel,long,vector pixel*)
#pragma tg_funcdef(vec_stvrxl,__vec_stvrxl,void,vector pixel,long,unsigned short*)
#pragma tg_funcdef(vec_stvrxl,__vec_stvrxl,void,vector pixel,long,short*)
#pragma tg_funcdef(vec_stvrxl,__vec_stvrxl,void,vector unsigned int,long,vector unsigned int*)
#pragma tg_funcdef(vec_stvrxl,__vec_stvrxl,void,vector unsigned int,long,unsigned int*)
#pragma tg_funcdef(vec_stvrxl,__vec_stvrxl,void,vector signed int,long,vector signed int*)
#pragma tg_funcdef(vec_stvrxl,__vec_stvrxl,void,vector signed int,long,signed int*)
#pragma tg_funcdef(vec_stvrxl,__vec_stvrxl,void,vector bool int,long,vector bool int*)
#pragma tg_funcdef(vec_stvrxl,__vec_stvrxl,void,vector bool int,long,unsigned int*)
#pragma tg_funcdef(vec_stvrxl,__vec_stvrxl,void,vector bool int,long,int*)
#pragma tg_funcdef(vec_stvrxl,__vec_stvrxl,void,vector float,long,vector float*)
#pragma tg_funcdef(vec_stvrxl,__vec_stvrxl,void,vector float,long,float*)
#endif /* __64BIT__ */
#define vec_stvrxl(a,b,c)  __tg_builtin("vec_stvrxl",a,b,c)

/* vec_vsububm */
#pragma tg_funcdef(vec_vsububm,__vec_sub,vector unsigned char,vector unsigned char,vector unsigned char)
#pragma tg_funcdef(vec_vsububm,__vec_sub,vector unsigned char,vector unsigned char,vector bool char)
#pragma tg_funcdef(vec_vsububm,__vec_sub,vector unsigned char,vector bool char,vector unsigned char)
#pragma tg_funcdef(vec_vsububm,__vec_sub,vector signed char,vector signed char,vector signed char)
#pragma tg_funcdef(vec_vsububm,__vec_sub,vector signed char,vector signed char,vector bool char)
#pragma tg_funcdef(vec_vsububm,__vec_sub,vector signed char,vector bool char,vector signed char)
#define vec_vsububm(a,b)  __tg_builtin("vec_vsububm",a,b)

/* vec_vsubuhm */
#pragma tg_funcdef(vec_vsubuhm,__vec_sub,vector unsigned short,vector unsigned short,vector unsigned short)
#pragma tg_funcdef(vec_vsubuhm,__vec_sub,vector unsigned short,vector unsigned short,vector bool short)
#pragma tg_funcdef(vec_vsubuhm,__vec_sub,vector unsigned short,vector bool short,vector unsigned short)
#pragma tg_funcdef(vec_vsubuhm,__vec_sub,vector signed short,vector signed short,vector signed short)
#pragma tg_funcdef(vec_vsubuhm,__vec_sub,vector signed short,vector signed short,vector bool short)
#pragma tg_funcdef(vec_vsubuhm,__vec_sub,vector signed short,vector bool short,vector signed short)
#define vec_vsubuhm(a,b)  __tg_builtin("vec_vsubuhm",a,b)

/* vec_vsubuwm */
#pragma tg_funcdef(vec_vsubuwm,__vec_sub,vector unsigned int,vector unsigned int,vector unsigned int)
#pragma tg_funcdef(vec_vsubuwm,__vec_sub,vector unsigned int,vector unsigned int,vector bool int)
#pragma tg_funcdef(vec_vsubuwm,__vec_sub,vector unsigned int,vector bool int,vector unsigned int)
#pragma tg_funcdef(vec_vsubuwm,__vec_sub,vector signed int,vector signed int,vector signed int)
#pragma tg_funcdef(vec_vsubuwm,__vec_sub,vector signed int,vector signed int,vector bool int)
#pragma tg_funcdef(vec_vsubuwm,__vec_sub,vector signed int,vector bool int,vector signed int)
#define vec_vsubuwm(a,b)  __tg_builtin("vec_vsubuwm",a,b)

/* vec_vsubfp */
#pragma tg_funcdef(vec_vsubfp,__vec_sub,vector float,vector float,vector float)
#define vec_vsubfp(a,b)  __tg_builtin("vec_vsubfp",a,b)

/* vec_sub */
#pragma tg_funcdef(vec_sub,__vec_sub,vector unsigned char,vector unsigned char,vector unsigned char)
#pragma tg_funcdef(vec_sub,__vec_sub,vector unsigned char,vector unsigned char,vector bool char)
#pragma tg_funcdef(vec_sub,__vec_sub,vector unsigned char,vector bool char,vector unsigned char)
#pragma tg_funcdef(vec_sub,__vec_sub,vector signed char,vector signed char,vector signed char)
#pragma tg_funcdef(vec_sub,__vec_sub,vector signed char,vector signed char,vector bool char)
#pragma tg_funcdef(vec_sub,__vec_sub,vector signed char,vector bool char,vector signed char)
#pragma tg_funcdef(vec_sub,__vec_sub,vector unsigned int,vector unsigned int,vector unsigned int)
#pragma tg_funcdef(vec_sub,__vec_sub,vector unsigned int,vector unsigned int,vector bool int)
#pragma tg_funcdef(vec_sub,__vec_sub,vector unsigned int,vector bool int,vector unsigned int)
#pragma tg_funcdef(vec_sub,__vec_sub,vector signed int,vector signed int,vector signed int)
#pragma tg_funcdef(vec_sub,__vec_sub,vector signed int,vector signed int,vector bool int)
#pragma tg_funcdef(vec_sub,__vec_sub,vector signed int,vector bool int,vector signed int)
#pragma tg_funcdef(vec_sub,__vec_sub,vector unsigned short,vector unsigned short,vector unsigned short)
#pragma tg_funcdef(vec_sub,__vec_sub,vector unsigned short,vector unsigned short,vector bool short)
#pragma tg_funcdef(vec_sub,__vec_sub,vector unsigned short,vector bool short,vector unsigned short)
#pragma tg_funcdef(vec_sub,__vec_sub,vector signed short,vector signed short,vector signed short)
#pragma tg_funcdef(vec_sub,__vec_sub,vector signed short,vector signed short,vector bool short)
#pragma tg_funcdef(vec_sub,__vec_sub,vector signed short,vector bool short,vector signed short)
#pragma tg_funcdef(vec_sub,__vec_sub,vector float,vector float,vector float)
#define vec_sub(a,b)  __tg_builtin("vec_sub",a,b)

/* vec_vsubcuw */
#pragma tg_funcdef(vec_vsubcuw,__vec_subc,vector unsigned int,vector unsigned int,vector unsigned int)
#define vec_vsubcuw(a,b)  __tg_builtin("vec_vsubcuw",a,b)

/* vec_subc */
#define vec_subc(a,b)  __vec_subc(a,b)

/* vec_vsububs */
#pragma tg_funcdef(vec_vsububs,__vec_subs,vector unsigned char,vector unsigned char,vector unsigned char)
#pragma tg_funcdef(vec_vsububs,__vec_subs,vector unsigned char,vector unsigned char,vector bool char)
#pragma tg_funcdef(vec_vsububs,__vec_subs,vector unsigned char,vector bool char,vector unsigned char)
#define vec_vsububs(a,b)  __tg_builtin("vec_vsububs",a,b)

/* vec_vsubsbs */
#pragma tg_funcdef(vec_vsubsbs,__vec_subs,vector signed char,vector signed char,vector signed char)
#pragma tg_funcdef(vec_vsubsbs,__vec_subs,vector signed char,vector signed char,vector bool char)
#pragma tg_funcdef(vec_vsubsbs,__vec_subs,vector signed char,vector bool char,vector signed char)
#define vec_vsubsbs(a,b)  __tg_builtin("vec_vsubsbs",a,b)

/* vec_vsubuhs */
#pragma tg_funcdef(vec_vsubuhs,__vec_subs,vector unsigned short,vector unsigned short,vector unsigned short)
#pragma tg_funcdef(vec_vsubuhs,__vec_subs,vector unsigned short,vector unsigned short,vector bool short)
#pragma tg_funcdef(vec_vsubuhs,__vec_subs,vector unsigned short,vector bool short,vector unsigned short)
#define vec_vsubuhs(a,b)  __tg_builtin("vec_vsubuhs",a,b)

/* vec_vsubshs */
#pragma tg_funcdef(vec_vsubshs,__vec_subs,vector signed short,vector signed short,vector signed short)
#pragma tg_funcdef(vec_vsubshs,__vec_subs,vector signed short,vector signed short,vector bool short)
#pragma tg_funcdef(vec_vsubshs,__vec_subs,vector signed short,vector bool short,vector signed short)
#define vec_vsubshs(a,b)  __tg_builtin("vec_vsubshs",a,b)

/* vec_vsubuws */
#pragma tg_funcdef(vec_vsubuws,__vec_subs,vector unsigned int,vector unsigned int,vector unsigned int)
#pragma tg_funcdef(vec_vsubuws,__vec_subs,vector unsigned int,vector unsigned int,vector bool int)
#pragma tg_funcdef(vec_vsubuws,__vec_subs,vector unsigned int,vector bool int,vector unsigned int)
#define vec_vsubuws(a,b)  __tg_builtin("vec_vsubuws",a,b)

/* vec_vsubsws */
#pragma tg_funcdef(vec_vsubsws,__vec_subs,vector signed int,vector signed int,vector signed int)
#pragma tg_funcdef(vec_vsubsws,__vec_subs,vector signed int,vector signed int,vector bool int)
#pragma tg_funcdef(vec_vsubsws,__vec_subs,vector signed int,vector bool int,vector signed int)
#define vec_vsubsws(a,b)  __tg_builtin("vec_vsubsws",a,b)

/* vec_subs */
#pragma tg_funcdef(vec_subs,__vec_subs,vector unsigned char,vector unsigned char,vector unsigned char)
#pragma tg_funcdef(vec_subs,__vec_subs,vector unsigned char,vector unsigned char,vector bool char)
#pragma tg_funcdef(vec_subs,__vec_subs,vector unsigned char,vector bool char,vector unsigned char)
#pragma tg_funcdef(vec_subs,__vec_subs,vector signed char,vector signed char,vector signed char)
#pragma tg_funcdef(vec_subs,__vec_subs,vector signed char,vector signed char,vector bool char)
#pragma tg_funcdef(vec_subs,__vec_subs,vector signed char,vector bool char,vector signed char)
#pragma tg_funcdef(vec_subs,__vec_subs,vector unsigned short,vector unsigned short,vector unsigned short)
#pragma tg_funcdef(vec_subs,__vec_subs,vector unsigned short,vector unsigned short,vector bool short)
#pragma tg_funcdef(vec_subs,__vec_subs,vector unsigned short,vector bool short,vector unsigned short)
#pragma tg_funcdef(vec_subs,__vec_subs,vector signed short,vector signed short,vector signed short)
#pragma tg_funcdef(vec_subs,__vec_subs,vector signed short,vector signed short,vector bool short)
#pragma tg_funcdef(vec_subs,__vec_subs,vector signed short,vector bool short,vector signed short)
#pragma tg_funcdef(vec_subs,__vec_subs,vector unsigned int,vector unsigned int,vector unsigned int)
#pragma tg_funcdef(vec_subs,__vec_subs,vector unsigned int,vector unsigned int,vector bool int)
#pragma tg_funcdef(vec_subs,__vec_subs,vector unsigned int,vector bool int,vector unsigned int)
#pragma tg_funcdef(vec_subs,__vec_subs,vector signed int,vector signed int,vector signed int)
#pragma tg_funcdef(vec_subs,__vec_subs,vector signed int,vector signed int,vector bool int)
#pragma tg_funcdef(vec_subs,__vec_subs,vector signed int,vector bool int,vector signed int)
#define vec_subs(a,b)  __tg_builtin("vec_subs",a,b)

/* vec_vsum4ubs */
#pragma tg_funcdef(vec_vsum4ubs,__vec_sum4s,vector unsigned int,vector unsigned char,vector unsigned int)
#define vec_vsum4ubs(a,b)  __tg_builtin("vec_vsum4ubs",a,b)

/* vec_vsum4sbs */
#pragma tg_funcdef(vec_vsum4sbs,__vec_sum4s,vector signed int,vector signed char,vector signed int)
#define vec_vsum4sbs(a,b)  __tg_builtin("vec_vsum4sbs",a,b)

/* vec_vsum4shs */
#pragma tg_funcdef(vec_vsum4shs,__vec_sum4s,vector signed int,vector signed short,vector signed int)
#define vec_vsum4shs(a,b)  __tg_builtin("vec_vsum4shs",a,b)

/* vec_sum4s */
#pragma tg_funcdef(vec_sum4s,__vec_sum4s,vector unsigned int,vector unsigned char,vector unsigned int)
#pragma tg_funcdef(vec_sum4s,__vec_sum4s,vector signed int,vector signed char,vector signed int)
#pragma tg_funcdef(vec_sum4s,__vec_sum4s,vector signed int,vector signed short,vector signed int)
#define vec_sum4s(a,b)  __tg_builtin("vec_sum4s",a,b)

/* vec_vsum2sws */
#pragma tg_funcdef(vec_vsum2sws,__vec_sum2s,vector signed int,vector signed int,vector signed int)
#define vec_vsum2sws(a,b)  __tg_builtin("vec_vsum2sws",a,b)

/* vec_sum2s */
#define vec_sum2s(a,b)  __vec_sum2s(a,b)

/* vec_vsumsws */
#pragma tg_funcdef(vec_vsumsws,__vec_sums,vector signed int,vector signed int,vector signed int)
#define vec_vsumsws(a,b)  __tg_builtin("vec_vsumsws",a,b)

/* vec_sums */
#define vec_sums(a,b)  __vec_sums(a,b)

/* vec_vrfiz */
#pragma tg_funcdef(vec_vrfiz,__vec_trunc,vector float,vector float)
#define vec_vrfiz(a)  __tg_builtin("vec_vrfiz",a)

/* vec_trunc */
#define vec_trunc(a)  __vec_trunc(a)

/* vec_vupkhsb */
#pragma tg_funcdef(vec_vupkhsb,__vec_unpackh,vector signed short,  vector signed char)
#pragma tg_funcdef(vec_vupkhsb,__vec_unpackh,vector bool short, vector bool char)
#define vec_vupkhsb(a)  __tg_builtin("vec_vupkhsb",a)

/* vec_vupkhpx */
#pragma tg_funcdef(vec_vupkhpx,__vec_unpackhp,vector unsigned int,  vector pixel)
#define vec_vupkhpx(a)  __tg_builtin("vec_vupkhpx",a)

/* vec_vupkhsh */
#pragma tg_funcdef(vec_vupkhsh,__vec_unpackh,vector signed int,  vector signed short)
#pragma tg_funcdef(vec_vupkhsh,__vec_unpackh,vector bool int, vector bool short)
#define vec_vupkhsh(a)  __tg_builtin("vec_vupkhsh",a)

/* vec_unpackh */
#pragma tg_funcdef(vec_unpackh,__vec_unpackh,vector signed short,  vector signed char)
#pragma tg_funcdef(vec_unpackh,__vec_unpackh,vector bool short, vector bool char)
#pragma tg_funcdef(vec_unpackh,__vec_unpackhp,vector unsigned int,  vector pixel)
#pragma tg_funcdef(vec_unpackh,__vec_unpackh,vector signed int,  vector signed short)
#pragma tg_funcdef(vec_unpackh,__vec_unpackh,vector bool int, vector bool short)
#define vec_unpackh(a)  __tg_builtin("vec_unpackh",a)

/* vec_vupklsb */
#pragma tg_funcdef(vec_vupklsb,__vec_unpackl,vector signed short,  vector signed char)
#pragma tg_funcdef(vec_vupklsb,__vec_unpackl,vector bool short, vector bool char)
#define vec_vupklsb(a)  __tg_builtin("vec_vupklsb",a)

/* vec_vupklpx */
#pragma tg_funcdef(vec_vupklpx,__vec_unpacklp,vector unsigned int,  vector pixel)
#define vec_vupklpx(a)  __tg_builtin("vec_vupklpx",a)

/* vec_vupklsh */
#pragma tg_funcdef(vec_vupklsh,__vec_unpackl,vector signed int,  vector signed short)
#pragma tg_funcdef(vec_vupklsh,__vec_unpackl,vector bool int, vector bool short)
#define vec_vupklsh(a)  __tg_builtin("vec_vupklsh",a)

/* vec_unpackl */
#pragma tg_funcdef(vec_unpackl,__vec_unpackl,vector signed short,  vector signed char)
#pragma tg_funcdef(vec_unpackl,__vec_unpackl,vector bool short, vector bool char)
#pragma tg_funcdef(vec_unpackl,__vec_unpacklp,vector unsigned int,  vector pixel)
#pragma tg_funcdef(vec_unpackl,__vec_unpackl,vector signed int,  vector signed short)
#pragma tg_funcdef(vec_unpackl,__vec_unpackl,vector bool int, vector bool short)
#define vec_unpackl(a)  __tg_builtin("vec_unpackl",a)

/* vec_vxor */
#pragma tg_funcdef(vec_vxor,__vec_xor,vector unsigned char,vector unsigned char,vector unsigned char)
#pragma tg_funcdef(vec_vxor,__vec_xor,vector unsigned char,vector unsigned char,vector bool char)
#pragma tg_funcdef(vec_vxor,__vec_xor,vector unsigned char,vector bool char,vector unsigned char)
#pragma tg_funcdef(vec_vxor,__vec_xor,vector signed char,vector signed char,vector signed char)
#pragma tg_funcdef(vec_vxor,__vec_xor,vector signed char,vector signed char,vector bool char)
#pragma tg_funcdef(vec_vxor,__vec_xor,vector signed char,vector bool char,vector signed char)
#pragma tg_funcdef(vec_vxor,__vec_xor,vector bool char,vector bool char,vector bool char)
#pragma tg_funcdef(vec_vxor,__vec_xor,vector unsigned short,vector unsigned short,vector unsigned short)
#pragma tg_funcdef(vec_vxor,__vec_xor,vector unsigned short,vector unsigned short,vector bool short)
#pragma tg_funcdef(vec_vxor,__vec_xor,vector unsigned short,vector bool short,vector unsigned short)
#pragma tg_funcdef(vec_vxor,__vec_xor,vector signed short,vector signed short,vector signed short)
#pragma tg_funcdef(vec_vxor,__vec_xor,vector signed short,vector signed short,vector bool short)
#pragma tg_funcdef(vec_vxor,__vec_xor,vector signed short,vector bool short,vector signed short)
#pragma tg_funcdef(vec_vxor,__vec_xor,vector bool short,vector bool short,vector bool short)
#pragma tg_funcdef(vec_vxor,__vec_xor,vector unsigned int,vector unsigned int,vector unsigned int)
#pragma tg_funcdef(vec_vxor,__vec_xor,vector unsigned int,vector unsigned int,vector bool int)
#pragma tg_funcdef(vec_vxor,__vec_xor,vector unsigned int,vector bool int,vector unsigned int)
#pragma tg_funcdef(vec_vxor,__vec_xor,vector signed int,vector signed int,vector signed int)
#pragma tg_funcdef(vec_vxor,__vec_xor,vector signed int,vector signed int,vector bool int)
#pragma tg_funcdef(vec_vxor,__vec_xor,vector signed int,vector bool int,vector signed int)
#pragma tg_funcdef(vec_vxor,__vec_xor,vector bool int,vector bool int,vector bool int)
#pragma tg_funcdef(vec_vxor,__vec_xor,vector float,vector bool int,vector float)
#pragma tg_funcdef(vec_vxor,__vec_xor,vector float,vector float,vector bool int)
#pragma tg_funcdef(vec_vxor,__vec_xor,vector float,vector float, vector float)
#define vec_vxor(a,b)  __tg_builtin("vec_vxor",a,b)

/* vec_xor */
#pragma tg_funcdef(vec_xor,__vec_xor,vector unsigned char,vector unsigned char,vector unsigned char)
#pragma tg_funcdef(vec_xor,__vec_xor,vector unsigned char,vector unsigned char,vector bool char)
#pragma tg_funcdef(vec_xor,__vec_xor,vector unsigned char,vector bool char,vector unsigned char)
#pragma tg_funcdef(vec_xor,__vec_xor,vector signed char,vector signed char,vector signed char)
#pragma tg_funcdef(vec_xor,__vec_xor,vector signed char,vector signed char,vector bool char)
#pragma tg_funcdef(vec_xor,__vec_xor,vector signed char,vector bool char,vector signed char)
#pragma tg_funcdef(vec_xor,__vec_xor,vector bool char,vector bool char,vector bool char)
#pragma tg_funcdef(vec_xor,__vec_xor,vector unsigned short,vector unsigned short,vector unsigned short)
#pragma tg_funcdef(vec_xor,__vec_xor,vector unsigned short,vector unsigned short,vector bool short)
#pragma tg_funcdef(vec_xor,__vec_xor,vector unsigned short,vector bool short,vector unsigned short)
#pragma tg_funcdef(vec_xor,__vec_xor,vector signed short,vector signed short,vector signed short)
#pragma tg_funcdef(vec_xor,__vec_xor,vector signed short,vector signed short,vector bool short)
#pragma tg_funcdef(vec_xor,__vec_xor,vector signed short,vector bool short,vector signed short)
#pragma tg_funcdef(vec_xor,__vec_xor,vector bool short,vector bool short,vector bool short)
#pragma tg_funcdef(vec_xor,__vec_xor,vector unsigned int,vector unsigned int,vector unsigned int)
#pragma tg_funcdef(vec_xor,__vec_xor,vector unsigned int,vector unsigned int,vector bool int)
#pragma tg_funcdef(vec_xor,__vec_xor,vector unsigned int,vector bool int,vector unsigned int)
#pragma tg_funcdef(vec_xor,__vec_xor,vector signed int,vector signed int,vector signed int)
#pragma tg_funcdef(vec_xor,__vec_xor,vector signed int,vector signed int,vector bool int)
#pragma tg_funcdef(vec_xor,__vec_xor,vector signed int,vector bool int,vector signed int)
#pragma tg_funcdef(vec_xor,__vec_xor,vector bool int,vector bool int,vector bool int)
#pragma tg_funcdef(vec_xor,__vec_xor,vector float,vector bool int,vector float)
#pragma tg_funcdef(vec_xor,__vec_xor,vector float,vector float,vector bool int)
#pragma tg_funcdef(vec_xor,__vec_xor,vector float,vector float, vector float)
#define vec_xor(a,b)  __tg_builtin("vec_xor",a,b)

/* vec_all_eq */
#pragma tg_funcdef(vec_all_eq,__vec_all_eq,int,vector unsigned char,vector unsigned char)
#pragma tg_funcdef(vec_all_eq,__vec_all_eq,int,vector unsigned char,vector bool char)
#pragma tg_funcdef(vec_all_eq,__vec_all_eq,int,vector signed char,vector signed char)
#pragma tg_funcdef(vec_all_eq,__vec_all_eq,int,vector signed char,vector bool char)
#pragma tg_funcdef(vec_all_eq,__vec_all_eq,int,vector bool char,vector unsigned char)
#pragma tg_funcdef(vec_all_eq,__vec_all_eq,int,vector bool char,vector signed char)
#pragma tg_funcdef(vec_all_eq,__vec_all_eq,int,vector bool char,vector bool char)
#pragma tg_funcdef(vec_all_eq,__vec_all_eq,int,vector unsigned short,vector unsigned short)
#pragma tg_funcdef(vec_all_eq,__vec_all_eq,int,vector unsigned short,vector bool short)
#pragma tg_funcdef(vec_all_eq,__vec_all_eq,int,vector signed short,vector signed short)
#pragma tg_funcdef(vec_all_eq,__vec_all_eq,int,vector signed short,vector bool short)
#pragma tg_funcdef(vec_all_eq,__vec_all_eq,int,vector bool short,vector unsigned short)
#pragma tg_funcdef(vec_all_eq,__vec_all_eq,int,vector bool short,vector signed short)
#pragma tg_funcdef(vec_all_eq,__vec_all_eq,int,vector bool short,vector bool short)
#pragma tg_funcdef(vec_all_eq,__vec_all_eq,int,vector pixel,vector pixel)
#pragma tg_funcdef(vec_all_eq,__vec_all_eq,int,vector unsigned int,vector unsigned int)
#pragma tg_funcdef(vec_all_eq,__vec_all_eq,int,vector unsigned int,vector bool int)
#pragma tg_funcdef(vec_all_eq,__vec_all_eq,int,vector signed int,vector signed int)
#pragma tg_funcdef(vec_all_eq,__vec_all_eq,int,vector signed int,vector bool int)
#pragma tg_funcdef(vec_all_eq,__vec_all_eq,int,vector bool int,vector unsigned int)
#pragma tg_funcdef(vec_all_eq,__vec_all_eq,int,vector bool int,vector signed int)
#pragma tg_funcdef(vec_all_eq,__vec_all_eq,int,vector bool int,vector bool int)
#pragma tg_funcdef(vec_all_eq,__vec_all_eq,int,vector float,vector float)
#define vec_all_eq(a,b)  __tg_builtin("vec_all_eq",a,b)

/* vec_any_eq */
#pragma tg_funcdef(vec_any_eq,__vec_any_eq,int,vector unsigned char,vector unsigned char)
#pragma tg_funcdef(vec_any_eq,__vec_any_eq,int,vector unsigned char,vector bool char)
#pragma tg_funcdef(vec_any_eq,__vec_any_eq,int,vector signed char,vector signed char)
#pragma tg_funcdef(vec_any_eq,__vec_any_eq,int,vector signed char,vector bool char)
#pragma tg_funcdef(vec_any_eq,__vec_any_eq,int,vector bool char,vector unsigned char)
#pragma tg_funcdef(vec_any_eq,__vec_any_eq,int,vector bool char,vector signed char)
#pragma tg_funcdef(vec_any_eq,__vec_any_eq,int,vector bool char,vector bool char)
#pragma tg_funcdef(vec_any_eq,__vec_any_eq,int,vector unsigned short,vector unsigned short)
#pragma tg_funcdef(vec_any_eq,__vec_any_eq,int,vector unsigned short,vector bool short)
#pragma tg_funcdef(vec_any_eq,__vec_any_eq,int,vector signed short,vector signed short)
#pragma tg_funcdef(vec_any_eq,__vec_any_eq,int,vector signed short,vector bool short)
#pragma tg_funcdef(vec_any_eq,__vec_any_eq,int,vector bool short,vector unsigned short)
#pragma tg_funcdef(vec_any_eq,__vec_any_eq,int,vector bool short,vector signed short)
#pragma tg_funcdef(vec_any_eq,__vec_any_eq,int,vector bool short,vector bool short)
#pragma tg_funcdef(vec_any_eq,__vec_any_eq,int,vector pixel,vector pixel)
#pragma tg_funcdef(vec_any_eq,__vec_any_eq,int,vector unsigned int,vector unsigned int)
#pragma tg_funcdef(vec_any_eq,__vec_any_eq,int,vector unsigned int,vector bool int)
#pragma tg_funcdef(vec_any_eq,__vec_any_eq,int,vector signed int,vector signed int)
#pragma tg_funcdef(vec_any_eq,__vec_any_eq,int,vector signed int,vector bool int)
#pragma tg_funcdef(vec_any_eq,__vec_any_eq,int,vector bool int,vector unsigned int)
#pragma tg_funcdef(vec_any_eq,__vec_any_eq,int,vector bool int,vector signed int)
#pragma tg_funcdef(vec_any_eq,__vec_any_eq,int,vector bool int,vector bool int)
#pragma tg_funcdef(vec_any_eq,__vec_any_eq,int,vector float,vector float)
#define vec_any_eq(a,b)  __tg_builtin("vec_any_eq",a,b)

/* vec_all_ge */
#pragma tg_funcdef(vec_all_ge,__vec_all_ge,int,vector unsigned char,vector unsigned char)
#pragma tg_funcdef(vec_all_ge,__vec_all_ge,int,vector unsigned char,vector bool char)
#pragma tg_funcdef(vec_all_ge,__vec_all_ge,int,vector bool char,vector unsigned char)
#pragma tg_funcdef(vec_all_ge,__vec_all_ge,int,vector signed char,vector signed char)
#pragma tg_funcdef(vec_all_ge,__vec_all_ge,int,vector signed char,vector bool char)
#pragma tg_funcdef(vec_all_ge,__vec_all_ge,int,vector bool char,vector signed char)
#pragma tg_funcdef(vec_all_ge,__vec_all_ge,int,vector unsigned short,vector unsigned short)
#pragma tg_funcdef(vec_all_ge,__vec_all_ge,int,vector unsigned short,vector bool short)
#pragma tg_funcdef(vec_all_ge,__vec_all_ge,int,vector bool short,vector unsigned short)
#pragma tg_funcdef(vec_all_ge,__vec_all_ge,int,vector signed short,vector signed short)
#pragma tg_funcdef(vec_all_ge,__vec_all_ge,int,vector signed short,vector bool short)
#pragma tg_funcdef(vec_all_ge,__vec_all_ge,int,vector bool short,vector signed short)
#pragma tg_funcdef(vec_all_ge,__vec_all_ge,int,vector unsigned int,vector unsigned int)
#pragma tg_funcdef(vec_all_ge,__vec_all_ge,int,vector unsigned int,vector bool int)
#pragma tg_funcdef(vec_all_ge,__vec_all_ge,int,vector bool int,vector unsigned int)
#pragma tg_funcdef(vec_all_ge,__vec_all_ge,int,vector signed int,vector signed int)
#pragma tg_funcdef(vec_all_ge,__vec_all_ge,int,vector signed int,vector bool int)
#pragma tg_funcdef(vec_all_ge,__vec_all_ge,int,vector bool int,vector signed int)
#pragma tg_funcdef(vec_all_ge,__vec_all_ge,int,vector float,vector float)
#define vec_all_ge(a,b)  __tg_builtin("vec_all_ge",a,b)

/* vec_any_ge */
#pragma tg_funcdef(vec_any_ge,__vec_any_ge,int,vector unsigned char,vector unsigned char)
#pragma tg_funcdef(vec_any_ge,__vec_any_ge,int,vector unsigned char,vector bool char)
#pragma tg_funcdef(vec_any_ge,__vec_any_ge,int,vector bool char,vector unsigned char)
#pragma tg_funcdef(vec_any_ge,__vec_any_ge,int,vector signed char,vector signed char)
#pragma tg_funcdef(vec_any_ge,__vec_any_ge,int,vector signed char,vector bool char)
#pragma tg_funcdef(vec_any_ge,__vec_any_ge,int,vector bool char,vector signed char)
#pragma tg_funcdef(vec_any_ge,__vec_any_ge,int,vector unsigned short,vector unsigned short)
#pragma tg_funcdef(vec_any_ge,__vec_any_ge,int,vector unsigned short,vector bool short)
#pragma tg_funcdef(vec_any_ge,__vec_any_ge,int,vector bool short,vector unsigned short)
#pragma tg_funcdef(vec_any_ge,__vec_any_ge,int,vector signed short,vector signed short)
#pragma tg_funcdef(vec_any_ge,__vec_any_ge,int,vector signed short,vector bool short)
#pragma tg_funcdef(vec_any_ge,__vec_any_ge,int,vector bool short,vector signed short)
#pragma tg_funcdef(vec_any_ge,__vec_any_ge,int,vector unsigned int,vector unsigned int)
#pragma tg_funcdef(vec_any_ge,__vec_any_ge,int,vector unsigned int,vector bool int)
#pragma tg_funcdef(vec_any_ge,__vec_any_ge,int,vector bool int,vector unsigned int)
#pragma tg_funcdef(vec_any_ge,__vec_any_ge,int,vector signed int,vector signed int)
#pragma tg_funcdef(vec_any_ge,__vec_any_ge,int,vector signed int,vector bool int)
#pragma tg_funcdef(vec_any_ge,__vec_any_ge,int,vector bool int,vector signed int)
#pragma tg_funcdef(vec_any_ge,__vec_any_ge,int,vector float,vector float)
#define vec_any_ge(a,b)  __tg_builtin("vec_any_ge",a,b)

/* vec_all_gt */
#pragma tg_funcdef(vec_all_gt,__vec_all_gt,int,vector unsigned char,vector unsigned char)
#pragma tg_funcdef(vec_all_gt,__vec_all_gt,int,vector unsigned char,vector bool char)
#pragma tg_funcdef(vec_all_gt,__vec_all_gt,int,vector bool char,vector unsigned char)
#pragma tg_funcdef(vec_all_gt,__vec_all_gt,int,vector signed char,vector signed char)
#pragma tg_funcdef(vec_all_gt,__vec_all_gt,int,vector signed char,vector bool char)
#pragma tg_funcdef(vec_all_gt,__vec_all_gt,int,vector bool char,vector signed char)
#pragma tg_funcdef(vec_all_gt,__vec_all_gt,int,vector unsigned short,vector unsigned short)
#pragma tg_funcdef(vec_all_gt,__vec_all_gt,int,vector unsigned short,vector bool short)
#pragma tg_funcdef(vec_all_gt,__vec_all_gt,int,vector bool short,vector unsigned short)
#pragma tg_funcdef(vec_all_gt,__vec_all_gt,int,vector signed short,vector signed short)
#pragma tg_funcdef(vec_all_gt,__vec_all_gt,int,vector signed short,vector bool short)
#pragma tg_funcdef(vec_all_gt,__vec_all_gt,int,vector bool short,vector signed short)
#pragma tg_funcdef(vec_all_gt,__vec_all_gt,int,vector unsigned int,vector unsigned int)
#pragma tg_funcdef(vec_all_gt,__vec_all_gt,int,vector unsigned int,vector bool int)
#pragma tg_funcdef(vec_all_gt,__vec_all_gt,int,vector bool int,vector unsigned int)
#pragma tg_funcdef(vec_all_gt,__vec_all_gt,int,vector signed int,vector signed int)
#pragma tg_funcdef(vec_all_gt,__vec_all_gt,int,vector signed int,vector bool int)
#pragma tg_funcdef(vec_all_gt,__vec_all_gt,int,vector bool int,vector signed int)
#pragma tg_funcdef(vec_all_gt,__vec_all_gt,int,vector float,vector float)
#define vec_all_gt(a,b)  __tg_builtin("vec_all_gt",a,b)

/* vec_any_gt */
#pragma tg_funcdef(vec_any_gt,__vec_any_gt,int,vector unsigned char,vector unsigned char)
#pragma tg_funcdef(vec_any_gt,__vec_any_gt,int,vector unsigned char,vector bool char)
#pragma tg_funcdef(vec_any_gt,__vec_any_gt,int,vector bool char,vector unsigned char)
#pragma tg_funcdef(vec_any_gt,__vec_any_gt,int,vector signed char,vector signed char)
#pragma tg_funcdef(vec_any_gt,__vec_any_gt,int,vector signed char,vector bool char)
#pragma tg_funcdef(vec_any_gt,__vec_any_gt,int,vector bool char,vector signed char)
#pragma tg_funcdef(vec_any_gt,__vec_any_gt,int,vector unsigned short,vector unsigned short)
#pragma tg_funcdef(vec_any_gt,__vec_any_gt,int,vector unsigned short,vector bool short)
#pragma tg_funcdef(vec_any_gt,__vec_any_gt,int,vector bool short,vector unsigned short)
#pragma tg_funcdef(vec_any_gt,__vec_any_gt,int,vector signed short,vector signed short)
#pragma tg_funcdef(vec_any_gt,__vec_any_gt,int,vector signed short,vector bool short)
#pragma tg_funcdef(vec_any_gt,__vec_any_gt,int,vector bool short,vector signed short)
#pragma tg_funcdef(vec_any_gt,__vec_any_gt,int,vector unsigned int,vector unsigned int)
#pragma tg_funcdef(vec_any_gt,__vec_any_gt,int,vector unsigned int,vector bool int)
#pragma tg_funcdef(vec_any_gt,__vec_any_gt,int,vector bool int,vector unsigned int)
#pragma tg_funcdef(vec_any_gt,__vec_any_gt,int,vector signed int,vector signed int)
#pragma tg_funcdef(vec_any_gt,__vec_any_gt,int,vector signed int,vector bool int)
#pragma tg_funcdef(vec_any_gt,__vec_any_gt,int,vector bool int,vector signed int)
#pragma tg_funcdef(vec_any_gt,__vec_any_gt,int,vector float,vector float)
#define vec_any_gt(a,b)  __tg_builtin("vec_any_gt",a,b)

/* vec_all_le */
#pragma tg_funcdef(vec_all_le,__vec_all_le,int,vector unsigned char,vector unsigned char)
#pragma tg_funcdef(vec_all_le,__vec_all_le,int,vector unsigned char,vector bool char)
#pragma tg_funcdef(vec_all_le,__vec_all_le,int,vector bool char,vector unsigned char)
#pragma tg_funcdef(vec_all_le,__vec_all_le,int,vector signed char,vector signed char)
#pragma tg_funcdef(vec_all_le,__vec_all_le,int,vector signed char,vector bool char)
#pragma tg_funcdef(vec_all_le,__vec_all_le,int,vector bool char,vector signed char)
#pragma tg_funcdef(vec_all_le,__vec_all_le,int,vector unsigned short,vector unsigned short)
#pragma tg_funcdef(vec_all_le,__vec_all_le,int,vector unsigned short,vector bool short)
#pragma tg_funcdef(vec_all_le,__vec_all_le,int,vector bool short,vector unsigned short)
#pragma tg_funcdef(vec_all_le,__vec_all_le,int,vector signed short,vector signed short)
#pragma tg_funcdef(vec_all_le,__vec_all_le,int,vector signed short,vector bool short)
#pragma tg_funcdef(vec_all_le,__vec_all_le,int,vector bool short,vector signed short)
#pragma tg_funcdef(vec_all_le,__vec_all_le,int,vector unsigned int,vector unsigned int)
#pragma tg_funcdef(vec_all_le,__vec_all_le,int,vector unsigned int,vector bool int)
#pragma tg_funcdef(vec_all_le,__vec_all_le,int,vector bool int,vector unsigned int)
#pragma tg_funcdef(vec_all_le,__vec_all_le,int,vector signed int,vector signed int)
#pragma tg_funcdef(vec_all_le,__vec_all_le,int,vector signed int,vector bool int)
#pragma tg_funcdef(vec_all_le,__vec_all_le,int,vector bool int,vector signed int)
#pragma tg_funcdef(vec_all_le,__vec_all_le,int,vector float,vector float)
#define vec_all_le(a,b)  __tg_builtin("vec_all_le",a,b)

/* vec_any_le */
#pragma tg_funcdef(vec_any_le,__vec_any_le,int,vector unsigned char,vector unsigned char)
#pragma tg_funcdef(vec_any_le,__vec_any_le,int,vector unsigned char,vector bool char)
#pragma tg_funcdef(vec_any_le,__vec_any_le,int,vector bool char,vector unsigned char)
#pragma tg_funcdef(vec_any_le,__vec_any_le,int,vector signed char,vector signed char)
#pragma tg_funcdef(vec_any_le,__vec_any_le,int,vector signed char,vector bool char)
#pragma tg_funcdef(vec_any_le,__vec_any_le,int,vector bool char,vector signed char)
#pragma tg_funcdef(vec_any_le,__vec_any_le,int,vector unsigned short,vector unsigned short)
#pragma tg_funcdef(vec_any_le,__vec_any_le,int,vector unsigned short,vector bool short)
#pragma tg_funcdef(vec_any_le,__vec_any_le,int,vector bool short,vector unsigned short)
#pragma tg_funcdef(vec_any_le,__vec_any_le,int,vector signed short,vector signed short)
#pragma tg_funcdef(vec_any_le,__vec_any_le,int,vector signed short,vector bool short)
#pragma tg_funcdef(vec_any_le,__vec_any_le,int,vector bool short,vector signed short)
#pragma tg_funcdef(vec_any_le,__vec_any_le,int,vector unsigned int,vector unsigned int)
#pragma tg_funcdef(vec_any_le,__vec_any_le,int,vector unsigned int,vector bool int)
#pragma tg_funcdef(vec_any_le,__vec_any_le,int,vector bool int,vector unsigned int)
#pragma tg_funcdef(vec_any_le,__vec_any_le,int,vector signed int,vector signed int)
#pragma tg_funcdef(vec_any_le,__vec_any_le,int,vector signed int,vector bool int)
#pragma tg_funcdef(vec_any_le,__vec_any_le,int,vector bool int,vector signed int)
#pragma tg_funcdef(vec_any_le,__vec_any_le,int,vector float,vector float)
#define vec_any_le(a,b)  __tg_builtin("vec_any_le",a,b)

/* vec_all_lt */
#pragma tg_funcdef(vec_all_lt,__vec_all_lt,int,vector unsigned char,vector unsigned char)
#pragma tg_funcdef(vec_all_lt,__vec_all_lt,int,vector unsigned char,vector bool char)
#pragma tg_funcdef(vec_all_lt,__vec_all_lt,int,vector bool char,vector unsigned char)
#pragma tg_funcdef(vec_all_lt,__vec_all_lt,int,vector signed char,vector signed char)
#pragma tg_funcdef(vec_all_lt,__vec_all_lt,int,vector signed char,vector bool char)
#pragma tg_funcdef(vec_all_lt,__vec_all_lt,int,vector bool char,vector signed char)
#pragma tg_funcdef(vec_all_lt,__vec_all_lt,int,vector unsigned short,vector unsigned short)
#pragma tg_funcdef(vec_all_lt,__vec_all_lt,int,vector unsigned short,vector bool short)
#pragma tg_funcdef(vec_all_lt,__vec_all_lt,int,vector bool short,vector unsigned short)
#pragma tg_funcdef(vec_all_lt,__vec_all_lt,int,vector signed short,vector signed short)
#pragma tg_funcdef(vec_all_lt,__vec_all_lt,int,vector signed short,vector bool short)
#pragma tg_funcdef(vec_all_lt,__vec_all_lt,int,vector bool short,vector signed short)
#pragma tg_funcdef(vec_all_lt,__vec_all_lt,int,vector unsigned int,vector unsigned int)
#pragma tg_funcdef(vec_all_lt,__vec_all_lt,int,vector unsigned int,vector bool int)
#pragma tg_funcdef(vec_all_lt,__vec_all_lt,int,vector bool int,vector unsigned int)
#pragma tg_funcdef(vec_all_lt,__vec_all_lt,int,vector signed int,vector signed int)
#pragma tg_funcdef(vec_all_lt,__vec_all_lt,int,vector signed int,vector bool int)
#pragma tg_funcdef(vec_all_lt,__vec_all_lt,int,vector bool int,vector signed int)
#pragma tg_funcdef(vec_all_lt,__vec_all_lt,int,vector float,vector float)
#define vec_all_lt(a,b)  __tg_builtin("vec_all_lt",a,b)

/* vec_any_lt */
#pragma tg_funcdef(vec_any_lt,__vec_any_lt,int,vector unsigned char,vector unsigned char)
#pragma tg_funcdef(vec_any_lt,__vec_any_lt,int,vector unsigned char,vector bool char)
#pragma tg_funcdef(vec_any_lt,__vec_any_lt,int,vector bool char,vector unsigned char)
#pragma tg_funcdef(vec_any_lt,__vec_any_lt,int,vector signed char,vector signed char)
#pragma tg_funcdef(vec_any_lt,__vec_any_lt,int,vector signed char,vector bool char)
#pragma tg_funcdef(vec_any_lt,__vec_any_lt,int,vector bool char,vector signed char)
#pragma tg_funcdef(vec_any_lt,__vec_any_lt,int,vector unsigned short,vector unsigned short)
#pragma tg_funcdef(vec_any_lt,__vec_any_lt,int,vector unsigned short,vector bool short)
#pragma tg_funcdef(vec_any_lt,__vec_any_lt,int,vector bool short,vector unsigned short)
#pragma tg_funcdef(vec_any_lt,__vec_any_lt,int,vector signed short,vector signed short)
#pragma tg_funcdef(vec_any_lt,__vec_any_lt,int,vector signed short,vector bool short)
#pragma tg_funcdef(vec_any_lt,__vec_any_lt,int,vector bool short,vector signed short)
#pragma tg_funcdef(vec_any_lt,__vec_any_lt,int,vector unsigned int,vector unsigned int)
#pragma tg_funcdef(vec_any_lt,__vec_any_lt,int,vector unsigned int,vector bool int)
#pragma tg_funcdef(vec_any_lt,__vec_any_lt,int,vector bool int,vector unsigned int)
#pragma tg_funcdef(vec_any_lt,__vec_any_lt,int,vector signed int,vector signed int)
#pragma tg_funcdef(vec_any_lt,__vec_any_lt,int,vector signed int,vector bool int)
#pragma tg_funcdef(vec_any_lt,__vec_any_lt,int,vector bool int,vector signed int)
#pragma tg_funcdef(vec_any_lt,__vec_any_lt,int,vector float,vector float)
#define vec_any_lt(a,b)  __tg_builtin("vec_any_lt",a,b)

/* vec_all_ne */
#pragma tg_funcdef(vec_all_ne,__vec_all_ne,int,vector unsigned char,vector unsigned char)
#pragma tg_funcdef(vec_all_ne,__vec_all_ne,int,vector unsigned char,vector bool char)
#pragma tg_funcdef(vec_all_ne,__vec_all_ne,int,vector signed char,vector signed char)
#pragma tg_funcdef(vec_all_ne,__vec_all_ne,int,vector signed char,vector bool char)
#pragma tg_funcdef(vec_all_ne,__vec_all_ne,int,vector bool char,vector unsigned char)
#pragma tg_funcdef(vec_all_ne,__vec_all_ne,int,vector bool char,vector signed char)
#pragma tg_funcdef(vec_all_ne,__vec_all_ne,int,vector bool char,vector bool char)
#pragma tg_funcdef(vec_all_ne,__vec_all_ne,int,vector unsigned short,vector unsigned short)
#pragma tg_funcdef(vec_all_ne,__vec_all_ne,int,vector unsigned short,vector bool short)
#pragma tg_funcdef(vec_all_ne,__vec_all_ne,int,vector signed short,vector signed short)
#pragma tg_funcdef(vec_all_ne,__vec_all_ne,int,vector signed short,vector bool short)
#pragma tg_funcdef(vec_all_ne,__vec_all_ne,int,vector bool short,vector unsigned short)
#pragma tg_funcdef(vec_all_ne,__vec_all_ne,int,vector bool short,vector signed short)
#pragma tg_funcdef(vec_all_ne,__vec_all_ne,int,vector bool short,vector bool short)
#pragma tg_funcdef(vec_all_ne,__vec_all_ne,int,vector pixel,vector pixel)
#pragma tg_funcdef(vec_all_ne,__vec_all_ne,int,vector unsigned int,vector unsigned int)
#pragma tg_funcdef(vec_all_ne,__vec_all_ne,int,vector unsigned int,vector bool int)
#pragma tg_funcdef(vec_all_ne,__vec_all_ne,int,vector signed int,vector signed int)
#pragma tg_funcdef(vec_all_ne,__vec_all_ne,int,vector signed int,vector bool int)
#pragma tg_funcdef(vec_all_ne,__vec_all_ne,int,vector bool int,vector unsigned int)
#pragma tg_funcdef(vec_all_ne,__vec_all_ne,int,vector bool int,vector signed int)
#pragma tg_funcdef(vec_all_ne,__vec_all_ne,int,vector bool int,vector bool int)
#pragma tg_funcdef(vec_all_ne,__vec_all_ne,int,vector float,vector float)
#define vec_all_ne(a,b)  __tg_builtin("vec_all_ne",a,b)

/* vec_any_ne */
#pragma tg_funcdef(vec_any_ne,__vec_any_ne,int,vector unsigned char,vector unsigned char)
#pragma tg_funcdef(vec_any_ne,__vec_any_ne,int,vector unsigned char,vector bool char)
#pragma tg_funcdef(vec_any_ne,__vec_any_ne,int,vector signed char,vector signed char)
#pragma tg_funcdef(vec_any_ne,__vec_any_ne,int,vector signed char,vector bool char)
#pragma tg_funcdef(vec_any_ne,__vec_any_ne,int,vector bool char,vector unsigned char)
#pragma tg_funcdef(vec_any_ne,__vec_any_ne,int,vector bool char,vector signed char)
#pragma tg_funcdef(vec_any_ne,__vec_any_ne,int,vector bool char,vector bool char)
#pragma tg_funcdef(vec_any_ne,__vec_any_ne,int,vector unsigned short,vector unsigned short)
#pragma tg_funcdef(vec_any_ne,__vec_any_ne,int,vector unsigned short,vector bool short)
#pragma tg_funcdef(vec_any_ne,__vec_any_ne,int,vector signed short,vector signed short)
#pragma tg_funcdef(vec_any_ne,__vec_any_ne,int,vector signed short,vector bool short)
#pragma tg_funcdef(vec_any_ne,__vec_any_ne,int,vector bool short,vector unsigned short)
#pragma tg_funcdef(vec_any_ne,__vec_any_ne,int,vector bool short,vector signed short)
#pragma tg_funcdef(vec_any_ne,__vec_any_ne,int,vector bool short,vector bool short)
#pragma tg_funcdef(vec_any_ne,__vec_any_ne,int,vector pixel,vector pixel)
#pragma tg_funcdef(vec_any_ne,__vec_any_ne,int,vector unsigned int,vector unsigned int)
#pragma tg_funcdef(vec_any_ne,__vec_any_ne,int,vector unsigned int,vector bool int)
#pragma tg_funcdef(vec_any_ne,__vec_any_ne,int,vector signed int,vector signed int)
#pragma tg_funcdef(vec_any_ne,__vec_any_ne,int,vector signed int,vector bool int)
#pragma tg_funcdef(vec_any_ne,__vec_any_ne,int,vector bool int,vector unsigned int)
#pragma tg_funcdef(vec_any_ne,__vec_any_ne,int,vector bool int,vector signed int)
#pragma tg_funcdef(vec_any_ne,__vec_any_ne,int,vector bool int,vector bool int)
#pragma tg_funcdef(vec_any_ne,__vec_any_ne,int,vector float,vector float)
#define vec_any_ne(a,b)  __tg_builtin("vec_any_ne",a,b)

/* vec_all_in */
#define vec_all_in(a,b) __vec_all_in(a,b)

/* vec_all_nan */
#define vec_all_nan(a) __vec_all_nan(a)

/* vec_any_nan */
#define vec_any_nan(a) __vec_any_nan(a)

/* vec_all_nge */
#define vec_all_nge(a,b) __vec_all_nge(a,b)

/* vec_any_nge */
#define vec_any_nge(a,b) __vec_any_nge(a,b)

/* vec_all_ngt */
#define vec_all_ngt(a,b) __vec_all_ngt(a,b)

/* vec_any_ngt */
#define vec_any_ngt(a,b) __vec_any_ngt(a,b)

/* vec_all_nle */
#define vec_all_nle(a,b) __vec_all_nle(a,b)

/* vec_any_nle */
#define vec_any_nle(a,b) __vec_any_nle(a,b)

/* vec_all_nlt */
#define vec_all_nlt(a,b) __vec_all_nlt(a,b)

/* vec_any_nlt */
#define vec_any_nlt(a,b) __vec_any_nlt(a,b)

/* vec_all_numeric */
#define vec_all_numeric(a) __vec_all_numeric(a)

/* vec_any_numeric */
#define vec_any_numeric(a) __vec_any_numeric(a)

/* vec_any_out */
#define vec_any_out(a,b) __vec_any_out(a,b)

#endif /* __IBM_VACPP_internal__xlc_altivec_h */
