#!/usr/bin/perl

#*******************************************************************************
#*
#* Licensed Materials - Property of IBM
#* _PID_
#* Copyright IBM Corp. _COPY_YEARS_.   All Rights Reserved.
#* IBM is a registered trademark of IBM Corp. in the U.S., other
#* countries or both.
#* US Government Users Restricted Rights - Use, duplication or disclosure
#* restricted by GSA ADP Schedule Contract with IBM Corp.
#*
#* 1/21/11 1.6 
#*******************************************************************************

if (($#ARGV + 1) != 2) {
  die "Usage: $0 <input file> <output file>\n";
}

my $infile = $ARGV[0];
my $outfile = $ARGV[1];
my $inserted = 0;
my $overlay_token = "  /*__XL_OVERLAY_TOKEN__*/  ";

if ( !((-e $infile) && (-r $infile)) ) {
  die "Warning: Unable to read $infile\n";
}

if (-e $outfile) { 
  die "Warning: $outline already exists\n"; 
}

open(IN, $infile) or die "Error: Unable to open input \"$infile\".\n$!\n";
open(OUT, ">$outfile") or die "Error: Unable to open output \"$outfile\".\n$!\n";


while (<IN>) { 
  my $line = $_;

  if ($line =~ /\.text\s.*:/) {
     $inserted = 1;
     print OUT "$overlay_token\n";
     print OUT $line;
  } else {
     print OUT $line;
  }
}

close (IN);
close (OUT);

if ($inserted == 0) {
  die "Error: Unable to insert tokens into $infile\n"
} 
