/**********************************************************************/
/*                                                                    */
/*   Licensed Materials - Property of IBM.                            */
/*   IBM XL C for OpenCL, V0.3 (technology preview)                   */
/*   Copyright IBM Corp. 2007.                                        */
/*   All Rights Reserved.                                             */
/*   US Government Users Restricted Rights -                          */
/*   Use, duplication or disclosure restricted by                     */
/*   GSA ADP Schedule Contract with IBM Corp.                         */
/*                                                                    */
/**********************************************************************/

#ifndef __IBM_VACPP_vec_types_h
#define __IBM_VACPP_vec_types_h 1

/* Single Token Vector Data Types */

#if __SPU__

#include <spu_intrinsics.h>

#define vec_bchar16          vector unsigned char          
#define vec_bshort8          vector unsigned short        
#define vec_bint4            vector unsigned int           
#define vec_pixel8           vector unsigned short              

#else

#define vec_uchar16          vector unsigned char      
#define vec_char16           vector signed char        
#define vec_ushort8          vector unsigned short     
#define vec_short8           vector signed short       
#define vec_uint4            vector unsigned int       
#define vec_int4             vector signed int         
#define vec_float4           vector float              
#define vec_bchar16          vector bool char          
#define vec_bshort8          vector bool short         
#define vec_bint4            vector bool int           
#define vec_ullong2          vector bool char
#define vec_llong2           vector bool short
#define vec_double2          vector bool int
#define vec_pixel8           vector pixel              
#define qword                vector unsigned char

#endif

#endif /* __IBM_VACPP_vec_types_h */
