/**********************************************************************/
/*                                                                    */
/*   Licensed Materials - Property of IBM.                            */
/*   IBM XL C for OpenCL, V0.3 (technology preview)                   */
/*   Copyright IBM Corp. 2007.                                        */
/*   All Rights Reserved.                                             */
/*   US Government Users Restricted Rights -                          */
/*   Use, duplication or disclosure restricted by                     */
/*   GSA ADP Schedule Contract with IBM Corp.                         */
/*                                                                    */
/**********************************************************************/

#if defined (__need_ptrdiff_t) || \
    defined (__need_size_t)    || \
    defined (__need_wchar_t)   || \
    defined (__need_NULL)      || \
    defined (__need_wint_t)
#define __need_individual_only
#endif

#if !defined (__IBM_VACPP_stddef_h) || defined (__need_individual_only)

#if !defined (offsetof) && !defined (__need_individual_only)
#define offsetof(__s_name, __s_member) __builtin_offsetof(__s_name, __s_member)
#endif

#if !defined (__IBM_VACPP_stddef_h) && !defined (__need_individual_only)
#define __IBM_VACPP_stddef_h 
#endif

#ifdef __cplusplus
extern "C" {
#endif


/*
 *
 *      The ANSI standard requires that certain values be in stddef.h.
 *      It also requires that if _ANSI_C_SOURCE is defined then ONLY these
 *      values are present. This header includes all the ANSI required entries.
 *
 */

#if defined (__need_ptrdiff_t) || defined (__IBM_VACPP_stddef_h)
#ifndef _PTRDIFF_T
#define _PTRDIFF_T
#ifndef __PTRDIFF_TYPE__
#define __PTRDIFF_TYPE__ long int
#endif
typedef __PTRDIFF_TYPE__ ptrdiff_t;
#endif
#undef __need_ptrdiff_t
#endif

#if defined (__need_size_t) || defined (__IBM_VACPP_stddef_h)
#ifndef _SIZE_T
#ifndef __size_t
#define _SIZE_T
#define __size_t
typedef	__SIZE_TYPE__	size_t;
#endif
#endif
#undef __need_size_t
#endif

#if defined (__need_wchar_t) || defined (__IBM_VACPP_stddef_h)
#ifndef _WCHAR_T
#define _WCHAR_T
#ifndef __cplusplus
typedef __WCHAR_TYPE__	wchar_t;
#endif
#endif
#undef __need_wchar_t
#endif

#if defined (__need_NULL) || defined (__IBM_VACPP_stddef_h)
#ifndef NULL
#define	NULL	0
#endif
#undef __need_NULL
#endif

#if defined (__need_wint_t) || defined (__IBM_VACPP_stddef_h)
#ifndef _WINT_T
#define _WINT_T
typedef unsigned int	wint_t;
#endif
#undef __need_wint_t
#endif

#ifdef __cplusplus
}
#endif

#undef __need_individual_only

#endif /* !defined(__IBM_VACPP_stddef_h) || __need_individual_only */
