/**********************************************************************/
/*                                                                    */
/*   Licensed Materials - Property of IBM.                            */
/*   IBM XL C for OpenCL, V0.3 (technology preview)                   */
/*   Copyright IBM Corp. 2007.                                        */
/*   All Rights Reserved.                                             */
/*   US Government Users Restricted Rights -                          */
/*   Use, duplication or disclosure restricted by                     */
/*   GSA ADP Schedule Contract with IBM Corp.                         */
/*                                                                    */
/**********************************************************************/

#ifndef __IBM_XLC_spu_cache_h
#define __IBM_XLC_spu_cache_h 1

#ifdef __SPU__

/* Soft-Cache Application Programmer Interface */

/* __cache_fetch                                                  */
/* Return a pointer to the copy of the byte addressed by EA in    */ 
/* the cache.                                                     */
void *__cache_fetch (__ea void *ea);

/* __cache_fetch_dirty                                            */
/* Same as __cache_fetch, and in addition mark N_DIRTY_BYTES      */ 
/* bytes starting with the byte addressed by EA as dirty.         */
void *__cache_fetch_dirty (__ea void *ea, int n_dirty_bytes);

/* __cache_touch                                                      */
/* Prefetch the 128-byte line for EA.  (Can be implemented as no-op.) */
void __cache_touch (__ea void *ea);

/* __cache_evict                                                  */
/* Evict the cache line for EA.  Write back dirty bytes (if any). */
void __cache_evict (__ea void *ea);

/* __cache_flush                                            */
/* Evict all cache lines.  Write back dirty bytes (if any). */
void __cache_flush (void);

#define cache_fetch(__a) __cache_fetch(__a)
#define cache_fetch_dirty(__a, __b) __cache_fetch_dirty(__a, __b)
#define cache_touch(__a) __cache_touch(__a)
#define cache_evict(__a) __cache_evict(__a)
#define cache_flush() __cache_flush()

#endif /* __SPU__ */

#endif /* __IBM_XLC_spu_mcfio_h */
