/**********************************************************************/
/*                                                                    */
/*   Licensed Materials - Property of IBM.                            */
/*   IBM XL C for OpenCL, V0.3 (technology preview)                   */
/*   Copyright IBM Corp. 2007.                                        */
/*   All Rights Reserved.                                             */
/*   US Government Users Restricted Rights -                          */
/*   Use, duplication or disclosure restricted by                     */
/*   GSA ADP Schedule Contract with IBM Corp.                         */
/*                                                                    */
/**********************************************************************/

#ifndef __IBM_VACPP_limits_h
#define __IBM_VACPP_limits_h

#ifndef __SPU__
#define _GCC_LIMITS_H_
#define _GCC_NEXT_LIMITS_H
#include_next <limits.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*  C LANGUAGE LIMITS */
#undef  CHAR_BIT
#define	CHAR_BIT	__CHAR_BIT__

#undef  CHAR_MAX
#undef  CHAR_MIN

#if !defined(_CHAR_UNSIGNED)
#define CHAR_MAX	SCHAR_MAX
#define CHAR_MIN	SCHAR_MIN
#else
#define CHAR_MAX	UCHAR_MAX
#define CHAR_MIN	(0)
#endif /* !_CHAR_UNSIGNED */

#undef  INT_MAX
#define INT_MAX		__INT_MAX__
#undef 	INT_MIN
#define	INT_MIN		(-INT_MAX - 1)
#undef  LONG_MAX
#define LONG_MAX        __LONG_MAX__
#undef  LONG_MIN
#define LONG_MIN        (-LONG_MAX - 1L)
#undef  ULONG_MAX
#define ULONG_MAX       (LONG_MAX * 2UL + 1UL)

#if (__STDC_VERSION__ >= 199901L)
#undef  LLONG_MAX
#define LLONG_MAX	__LONG_LONG_MAX__
#undef  LLONG_MIN
#define LLONG_MIN	(-LLONG_MAX - 1LL)
#undef  ULLONG_MAX
#define ULLONG_MAX	(LLONG_MAX * 2ULL + 1ULL)
#endif /* __STDC_VERSION__ >= 199901L */

#undef  SCHAR_MAX
#define SCHAR_MAX	__SCHAR_MAX__
#undef  SCHAR_MIN
#define SCHAR_MIN	(-SCHAR_MAX - 1)
#undef  SHRT_MAX
#define SHRT_MAX	__SHRT_MAX__
#undef  SHRT_MIN
#define SHRT_MIN	(-SHRT_MAX - 1)
#undef  UCHAR_MAX
#define UCHAR_MAX	(SCHAR_MAX * 2 + 1)
#undef  UINT_MAX
#define UINT_MAX	(INT_MAX * 2U + 1U)
#undef  USHRT_MAX
#define USHRT_MAX	(SHRT_MAX * 2 + 1)

#undef 	MB_LEN_MAX
#define	MB_LEN_MAX	4 		/* maximum bytes in multibyte char */

#if !defined(__SPU__) ? (defined(_GNU_SOURCE) || defined (__USE_GNU)) : !defined (__STRICT_ANSI__)
#undef  LONG_LONG_MAX
#define LONG_LONG_MAX   __LONG_LONG_MAX__

#undef  LONG_LONG_MIN
#define LONG_LONG_MIN   (-LONG_LONG_MAX - 1LL)

#undef  ULONG_LONG_MAX
#define ULONG_LONG_MAX  (LONG_LONG_MAX * 2ULL + 1ULL)
#endif

#ifdef __cplusplus
}
#endif

#endif /* __IBM_VACPP_limits_h */
