/**********************************************************************/
/*                                                                    */
/*   Licensed Materials - Property of IBM.                            */
/*   IBM XL C for OpenCL, V0.3 (technology preview)                   */
/*   Copyright IBM Corp. 2007.                                        */
/*   All Rights Reserved.                                             */
/*   US Government Users Restricted Rights -                          */
/*   Use, duplication or disclosure restricted by                     */
/*   GSA ADP Schedule Contract with IBM Corp.                         */
/*                                                                    */
/**********************************************************************/

#ifndef __IBM_VACPP_iso646_h
#define __IBM_VACPP_iso646_h

#ifndef __cplusplus

/*************************************************************************
	Notes:	The C standard has always required that the following
		trigraphs be supported in translation phase 1:
			??= mapped to #
			??( mapped to [
			??/ mapped to \
			??) mapped to ]
			??' mapped to ^
			??< mapped to {
			??! mapped to |
			??> mapped to }
			??- mapped to ~

		The forthcoming normative addendum to the C standard that
		requires conforming implementations to provide <iso646.h>
		also requires support in translation phases 3..4 for the
		following preprocessing tokens:
			%: alternate spelling for #
			%:%: alternate spelling for ##
		It also requires support in translation phases 3..7 for the
		following preprocessing tokens:
			<% alternate spelling for {
			%> alternate spelling for }
			<: alternate spelling for [
			:> alternate spelling for ]

		The C standard also requires that the "difficult" characters
		be somehow provided in both the basic source and execution
		character sets, regardless of the provision of trigraph,
		digraph, and macro alternatives for these characters.

		It is suggested that all C programmers avoid use of the
		following identifiers in their programs, in case somebody
		later needs to use <iso646.h> in maintaining the programs.
 **************************************************************************/

#define or	||
#define bitor	|
#define or_eq	|=
#define xor	^
#define xor_eq	^=
#define compl	~
#define and	&&
#define bitand	&
#define and_eq	&=
#define not	!
#define not_eq	!=

#endif

#endif /* __IBM_VACPP_iso646_h */
