/**********************************************************************/
/*                                                                    */
/*   Licensed Materials - Property of IBM.                            */
/*   IBM XL C for OpenCL, V0.3 (technology preview)                   */
/*   Copyright IBM Corp. 2007.                                        */
/*   All Rights Reserved.                                             */
/*   US Government Users Restricted Rights -                          */
/*   Use, duplication or disclosure restricted by                     */
/*   GSA ADP Schedule Contract with IBM Corp.                         */
/*                                                                    */
/**********************************************************************/

#ifndef __IBM_VACPP_float_h
#define __IBM_VACPP_float_h

/*
 *  ANSI required:
 *
 *      FLT_ROUNDS      Macro that returns current rounding mode value
 *      FLT_RADIX       Exponent radix
 *
 *               Values for "float" numbers
 *
 *      FLT_MANT_DIG    Number of bits in the significand
 *      FLT_EPSILON     1ulp when exponent = 0
 *      FLT_DIG         Number of decimal digits of precision
 *      FLT_MIN_EXP     Exponent of smallest NORMALIZED float number
 *      FLT_MIN         Smallest NORMALIZED float number
 *      FLT_MIN_10_EXP  Minimum base 10 exponent of NORMALIZED float
 *      FLT_MAX_EXP     Exponent of largest NORMALIZED float number
 *      FLT_MAX         Largest NORMALIZED float number
 *      FLT_MAX_10_EXP  Largest base 10 exponent of NORMALIZED float
 *
 *               Values for "double" numbers
 *
 *      DBL_MANT_DIG    Number of bits in the significand
 *      DBL_EPSILON     1ulp when exponent = 0
 *      DBL_DIG         Number of decimal digits of precision
 *      DBL_MIN_EXP     Exponent of smallest NORMALIZED double number
 *      DBL_MIN         Smallest NORMALIZED double number
 *      DBL_MIN_10_EXP  Minimum base 10 exponent of NORMALIZED double
 *      DBL_MAX_EXP     Exponent of largest NORMALIZED double number
 *      DBL_MAX         Largest NORMALIZED double number
 *      DBL_MAX_10_EXP  Largest base 10 exponent of NORMALIZED double
 *
 *                Values for "long double" numbers
 *
 *      LDBL_MANT_DIG   Number of bits in the significand
 *      LDBL_EPSILON    1ulp when unbiased exponent = 0
 *      LDBL_DIG        Number of decimal digits of precision
 *      LDBL_MIN_EXP    Exponent of smallest NORMALIZED long double number
 *      LDBL_MIN        Smallest NORMALIZED long double number
 *      LDBL_MIN_10_EX  Minimum base 10 exponent of NORMALIZED long double
 *      LDBL_MAX_EXP    Exponent of largest NORMALIZED long double number
 *      LDBL_MAX        Largest NORMALIZED long double number
 *      LDBL_MAX_10_EXP Largest base 10 exponent of NORMALIZED long double
 *
 */

#undef  FLT_MAX
#define FLT_MAX	    __FLT_MAX__   /* max decimal value of a float */

#undef  FLT_MIN
#define FLT_MIN	    __FLT_MIN__   /* min decimal value of a float */

#undef  FLT_DIG
#define FLT_DIG     __FLT_DIG__

#undef  DBL_MAX
#define DBL_MAX	    __DBL_MAX__   /* max decimal value of a double */

#undef  DBL_MIN
#define DBL_MIN	    __DBL_MIN__   /* min decimal value of a double */

#undef  DBL_DIG
#define DBL_DIG     __DBL_DIG__

#undef  LDBL_MAX
#define LDBL_MAX    __LDBL_MAX__  /* max decimal value of a long double */

#undef  LDBL_MIN
#define LDBL_MIN    __LDBL_MIN__  /* min decimal value of a long double */

#undef  LDBL_DIG
#define LDBL_DIG    __LDBL_DIG__

/*
 *      General definitions
 */

#undef  FLT_ROUNDS
#define FLT_ROUNDS         1

#undef  FLT_RADIX
#define FLT_RADIX          __FLT_RADIX__

#if (__STDC_VERSION__ >= 199901L)
#undef  FLT_EVAL_METHOD
#define FLT_EVAL_METHOD    __FLT_EVAL_METHOD__
#endif

/*
 *      Float definitions
 */

#undef  FLT_MANT_DIG
#define FLT_MANT_DIG       __FLT_MANT_DIG__

#undef  FLT_EPSILON
#define FLT_EPSILON	   __FLT_EPSILON__

#undef  FLT_MIN_EXP
#define FLT_MIN_EXP        __FLT_MIN_EXP__

#undef  FLT_MIN_10_EXP
#define FLT_MIN_10_EXP     __FLT_MIN_10_EXP__

#undef  FLT_MAX_EXP
#define FLT_MAX_EXP        __FLT_MAX_EXP__

#undef  FLT_MAX_10_EXP
#define FLT_MAX_10_EXP     __FLT_MAX_10_EXP__

/*
 *      Double definitions
 */

#undef  DBL_MANT_DIG
#define DBL_MANT_DIG       __DBL_MANT_DIG__

#undef  DBL_EPSILON
#define DBL_EPSILON	   __DBL_EPSILON__

#undef  DBL_MIN_EXP
#define DBL_MIN_EXP        __DBL_MIN_EXP__

#undef  DBL_MIN_10_EXP
#define DBL_MIN_10_EXP     __DBL_MIN_10_EXP__

#undef  DBL_MAX_EXP
#define DBL_MAX_EXP        __DBL_MAX_EXP__

#undef  DBL_MAX_10_EXP
#define DBL_MAX_10_EXP     __DBL_MAX_10_EXP__

/*
 *      Long Double definitions
 */

#undef  LDBL_MANT_DIG
#define LDBL_MANT_DIG      __LDBL_MANT_DIG__

#undef  LDBL_EPSILON
#define LDBL_EPSILON	   __LDBL_EPSILON__

#undef  LDBL_MIN_EXP
#define LDBL_MIN_EXP       __LDBL_MIN_EXP__

#undef  LDBL_MIN_10_EXP
#define LDBL_MIN_10_EXP    __LDBL_MIN_10_EXP__

#undef  LDBL_MAX_EXP
#define LDBL_MAX_EXP       __LDBL_MAX_EXP__

#undef  LDBL_MAX_10_EXP
#define LDBL_MAX_10_EXP    __LDBL_MAX_10_EXP__

#if (__STDC_VERSION__ >= 199901L)
#undef  DECIMAL_DIG
#define DECIMAL_DIG        __DECIMAL_DIG__
#endif

/******************************************************************************
 *  This section is for Decimal Floating Point (DFP) items.
 *  DFP support is only present if __STDC_WANT_DEC_FP__ is defined.
 *****************************************************************************/
#ifdef __STDC_WANT_DEC_FP__

/*
 *  For the values defined here:
 *  A prefix of DEC32_ indicates a type of _Decimal32.
 *  A prefix of DEC64_ indicates a type of _Decimal64.
 *  A prefix of DEC128_ indicates a type of _Decimal128.
 
 *  MANT_DIG  specifies the number of digits in the coefficient
 *  MIN_EXP   specifies the minimum exponent value
 *  MAX_EXP   specifies the maximum exponent value
 *  MAX       specifies the maximum finite value that can be represented
 *  EPSILON   specifies the epsilon, the least value greater than 1
 *            that can be represented
 *  MIN       specifies the minimum normalized positive value
 *  DEN       specifies the minimum denormalized positive value
 */

/* Constant values relevant to the _Decimal32 floating point data type */
#define DEC32_MANT_DIG	__DEC32_MANT_DIG__
#define DEC32_MIN_EXP	__DEC32_MIN_EXP__
#define DEC32_MAX_EXP	__DEC32_MAX_EXP__
#define DEC32_MAX	__DEC32_MAX__
#define DEC32_EPSILON	__DEC32_EPSILON__
#define DEC32_MIN	__DEC32_MIN__
#define DEC32_DEN	__DEC32_DEN__

/* Constant values relevant to the _Decimal64 floating point data type */
#define DEC64_MANT_DIG	__DEC64_MANT_DIG__
#define DEC64_MIN_EXP	__DEC64_MIN_EXP__
#define DEC64_MAX_EXP	__DEC64_MAX_EXP__
#define DEC64_MAX	__DEC64_MAX__
#define DEC64_EPSILON	__DEC64_EPSILON__
#define DEC64_MIN	__DEC64_MIN__
#define DEC64_DEN	__DEC64_DEN__

/* Constant values relevant to the _Decimal128 floating point data type */
#define DEC128_MANT_DIG	__DEC128_MANT_DIG__
#define DEC128_MIN_EXP	__DEC128_MIN_EXP__
#define DEC128_MAX_EXP	__DEC128_MAX_EXP__
#define DEC128_MAX	__DEC128_MAX__
#define DEC128_EPSILON	__DEC128_EPSILON__
#define DEC128_MIN	__DEC128_MIN__
#define DEC128_DEN	__DEC128_DEN__

#ifdef __DEC_EVAL_METHOD__
#define DEC_EVAL_METHOD __DEC_EVAL_METHOD__
#else
#define DEC_EVAL_METHOD -1
#endif

#endif /* __STDC_WANT_DEC_FP__ */

#endif /* __IBM_VACPP_float_h */

