#!/usr/bin/tclsh
# --------------------------------------------------------------- 
# Licensed Materials - Property of IBM                            
# 5724-S84                                                        
# (C) Copyright IBM Corp. 2006,2007, All Rights Reserved          
# US Government Users Restricted Rights - Use, duplication or     
# disclosure restricted by GSA ADP Schedule Contract with         
# IBM Corp.                                                       
# --------------------------------------------------------------- 
# PROLOG END TAG zYx                                              
#------------------------------------------------------------------------
#
#   IBM Software
#   Licensed Material - Property of IBM
#   (C) Copyright International Business Machines Corp. 2004, 2007
#   All Rights Reserved.
#
#   U.S. Government Users Restricted Rights - Use, duplication or
#   disclosure restricted by GSA ADP Schedule Contract with
#   IBM Corp.
#
#------------------------------------------------------------------------
#  install_rpms.tcl
#
#  This installs RPMs into the simulator.
#  Run this script from the command line as follows:
#      copy the rpms you want installed into the sysroot to /tmp/cellsdk/rpms
#      mount -o loop /opt/ibm/systemsim-cell/images/cell/sysroot_disk /mnt/cell-sdk-sysroot
#      cp /tmp/cellsdk/rpms/* /mnt/cell-sdk-sysroot/tmp/cellsdk/rpms
#      export PATH=PATH=/opt/ibm/systemsim-cell/bin:$PATH 
#      cd /opt/cell (you must be in the same directory as the install_rpms.tcl script)
#      systemsim -cell -n -q -f ${cellTop}/install_rpms.tcl 
#         -n disable opening XTerms for the console
#         -q quiet mode
#         -f name of initial TCL file (replacing the default .systemsim.tcl)
#         -cell machine option passed to the simulator 
#------------------------------------------------------------------------

# Start the simulator using our version of the standard initialization script,
# which we created in cellsdk_sync_simular.  Our version mounts the simulator
# in rw mode
source $env(LIB_DIR)/cell/installrpms.tcl

# Run long enough to boot the kernel
fast_wait_for_linux_prompt

# enable fast mode
mysim fast on

# Change to the test directory and install the rpms
mysim console create UART0 in string "
cd /tmp/cellsdk/rpms\n
ls\n
./install_rpms.sh\n
sync; sync"

# copy the results file from the simulator to the host
mysim console create UART0 in string "
callthru sink /tmp/cellsdk/rpms/install_rpms.out < /tmp/cellsdk/rpms/install_rpms.out"

# finally, we'll return control to the simulation Tcl command script.
mysim console create UART0 in string "
callthru exit"

# Run the simulator
mysim go

# Test is complete. Exit the simulator.
exit
