//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//!	 \file		CvEnums.h
//!  \brief     Public header common Civ5 enumerations
//!
//!		This header includes all enumerations shared by both exe and dll.
//!
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
#pragma once 
#ifndef CVENUMS_H
#define CVENUMS_H

// Mem Allocation Tags
enum eCiv5GameCoreMPoolType
{
	c_eCiv5GameplayDLL = c_eMPoolTypeUserStart + 0x100,		// Adding 0x100 because we don't want to collide with the app's IDs
};

//! An enumeration for indexing units within a CvBattleDefinition
enum BattleUnitTypes
{
	BATTLE_UNIT_ATTACKER,		//!< Index referencing the attacking unit
	BATTLE_UNIT_DEFENDER,		//!< Index referencing the defending unit
	BATTLE_UNIT_INTERCEPTOR,	//!< Index referencing the defending unit
	BATTLE_UNIT_COUNT			//!< The number of unit index references
};

enum DiploStatementTypes
{
	NO_DIPLO_STATEMENT_TYPE = -1,

	DIPLO_STATEMENT_REQUEST_PEACE,

	DIPLO_STATEMENT_AGGRESSIVE_MILITARY_WARNING,
	DIPLO_STATEMENT_KILLED_PROTECTED_CITY_STATE,
	DIPLO_STATEMENT_ATTACKED_PROTECTED_CITY_STATE,
	DIPLO_STATEMENT_BULLIED_PROTECTED_CITY_STATE,
	DIPLO_STATEMENT_EXPANSION_SERIOUS_WARNING,
	DIPLO_STATEMENT_EXPANSION_WARNING,
	DIPLO_STATEMENT_EXPANSION_BROKEN_PROMISE,
	DIPLO_STATEMENT_PLOT_BUYING_SERIOUS_WARNING,
	DIPLO_STATEMENT_PLOT_BUYING_WARNING,
	DIPLO_STATEMENT_PLOT_BUYING_BROKEN_PROMISE,
	DIPLO_STATEMENT_WE_ATTACKED_YOUR_MINOR,
	DIPLO_STATEMENT_WE_BULLIED_YOUR_MINOR,
	DIPLO_STATEMENT_WORK_WITH_US,
	DIPLO_STATEMENT_WORK_WITH_US_RANDFAILED,
	DIPLO_STATEMENT_END_WORK_WITH_US,
	DIPLO_STATEMENT_DENOUNCE,
	DIPLO_STATEMENT_DENOUNCE_RANDFAILED,
	DIPLO_STATEMENT_END_WORK_AGAINST_SOMEONE,
	DIPLO_STATEMENT_COOP_WAR_REQUEST,
	DIPLO_STATEMENT_COOP_WAR_TIME,
	DIPLO_STATEMENT_NOW_UNFORGIVABLE,
	DIPLO_STATEMENT_NOW_ENEMY,

	DIPLO_STATEMENT_CAUGHT_YOUR_SPY,
	DIPLO_STATEMENT_KILLED_YOUR_SPY,
	DIPLO_STATEMENT_KILLED_MY_SPY,
	DIPLO_STATEMENT_SHARE_INTRIGUE,

	DIPLO_STATEMENT_STOP_CONVERSIONS,

	DIPLO_STATEMENT_DEMAND,

	DIPLO_STATEMENT_REQUEST,
	DIPLO_STATEMENT_REQUEST_RANDFAILED,

	DIPLO_STATEMENT_GIFT,
	DIPLO_STATEMENT_GIFT_RANDFAILED,

	DIPLO_STATEMENT_LUXURY_TRADE,
	DIPLO_STATEMENT_EMBASSY_EXCHANGE,
	DIPLO_STATEMENT_EMBASSY_OFFER,
	DIPLO_STATEMENT_OPEN_BORDERS_EXCHANGE,
	DIPLO_STATEMENT_OPEN_BORDERS_OFFER,
	DIPLO_STATEMENT_PLAN_RESEARCH_AGREEMENT,
	DIPLO_STATEMENT_RESEARCH_AGREEMENT_OFFER,
	DIPLO_STATEMENT_RENEW_DEAL,

	DIPLO_STATEMENT_INSULT,
	DIPLO_STATEMENT_COMPLIMENT,
	DIPLO_STATEMENT_BOOT_KISSING,
	DIPLO_STATEMENT_WARMONGER,
	DIPLO_STATEMENT_MINOR_CIV_COMPETITION,

	DIPLO_STATEMENT_DENOUNCE_FRIEND,
	DIPLO_STATEMENT_REQUEST_FRIEND_DENOUNCE,
	DIPLO_STATEMENT_REQUEST_FRIEND_DENOUNCE_RANDFAILED,
	DIPLO_STATEMENT_REQUEST_FRIEND_WAR,

	DIPLO_STATEMENT_ANGRY_BEFRIEND_ENEMY,
	DIPLO_STATEMENT_ANGRY_BEFRIEND_ENEMY_RANDFAILED,
	DIPLO_STATEMENT_ANGRY_DENOUNCED_FRIEND,
	DIPLO_STATEMENT_ANGRY_DENOUNCED_FRIEND_RANDFAILED,
	DIPLO_STATEMENT_HAPPY_DENOUNCED_ENEMY,
	DIPLO_STATEMENT_HAPPY_DENOUNCED_ENEMY_RANDFAILED,
	DIPLO_STATEMENT_HAPPY_BEFRIENDED_FRIEND,
	DIPLO_STATEMENT_HAPPY_BEFRIENDED_FRIEND_RANDFAILED,
	DIPLO_STATEMENT_FYI_BEFRIEND_HUMAN_ENEMY,
	DIPLO_STATEMENT_FYI_BEFRIEND_HUMAN_ENEMY_RANDFAILED,
	DIPLO_STATEMENT_FYI_DENOUNCED_HUMAN_FRIEND,
	DIPLO_STATEMENT_FYI_DENOUNCED_HUMAN_FRIEND_RANDFAILED,
	DIPLO_STATEMENT_FYI_DENOUNCED_HUMAN_ENEMY,
	DIPLO_STATEMENT_FYI_DENOUNCED_HUMAN_ENEMY_RANDFAILED,
	DIPLO_STATEMENT_FYI_BEFRIEND_HUMAN_FRIEND,
	DIPLO_STATEMENT_FYI_BEFRIEND_HUMAN_FRIEND_RANDFAILED,

    DIPLO_STATEMENT_SAME_POLICIES_FREEDOM,
    DIPLO_STATEMENT_SAME_POLICIES_ORDER,
    DIPLO_STATEMENT_SAME_POLICIES_AUTOCRACY,

	DIPLO_STATEMENT_STOP_DIGGING,

	// League statements
	DIPLO_STATEMENT_WE_LIKED_THEIR_PROPOSAL,
	DIPLO_STATEMENT_WE_DISLIKED_THEIR_PROPOSAL,
	DIPLO_STATEMENT_THEY_SUPPORTED_OUR_PROPOSAL,
	DIPLO_STATEMENT_THEY_FOILED_OUR_PROPOSAL,
	DIPLO_STATEMENT_THEY_SUPPORTED_OUR_HOSTING,

	// Ideological statements
	DIPLO_STATEMENT_YOUR_IDEOLOGY_CAUSING_CIVIL_UNREST_FREEDOM,
	DIPLO_STATEMENT_YOUR_IDEOLOGY_CAUSING_CIVIL_UNREST_ORDER,
	DIPLO_STATEMENT_YOUR_IDEOLOGY_CAUSING_CIVIL_UNREST_AUTOCRACY,
	DIPLO_STATEMENT_OUR_IDEOLOGY_CAUSING_CIVIL_UNREST_FREEDOM,
	DIPLO_STATEMENT_OUR_IDEOLOGY_CAUSING_CIVIL_UNREST_ORDER,
	DIPLO_STATEMENT_OUR_IDEOLOGY_CAUSING_CIVIL_UNREST_AUTOCRACY,
	DIPLO_STATEMENT_SWITCH_OUR_IDEOLOGY_FREEDOM,
	DIPLO_STATEMENT_SWITCH_OUR_IDEOLOGY_ORDER,
	DIPLO_STATEMENT_SWITCH_OUR_IDEOLOGY_AUTOCRACY,
	DIPLO_STATEMENT_YOUR_CULTURE_INFLUENTIAL,
	DIPLO_STATEMENT_OUR_CULTURE_INFLUENTIAL,

	NUM_DIPLO_LOG_STATEMENT_TYPES,
};

enum DiploMessageTypes
{
	NO_DIPLO_MESSAGE_TYPE = -1,

	// AI greeting messages
	DIPLO_MESSAGE_INTRO,
	DIPLO_MESSAGE_DEFEATED,
	DIPLO_MESSAGE_GREETING_REPEAT_TOO_MUCH,
	DIPLO_MESSAGE_GREETING_REPEAT,
	DIPLO_MESSAGE_GREETING_HOSTILE_REPEAT,
	DIPLO_MESSAGE_GREETING_FRIENDLY_HELLO,
	DIPLO_MESSAGE_GREETING_NEUTRAL_HELLO,
	DIPLO_MESSAGE_GREETING_HOSTILE_HELLO,

	DIPLO_MESSAGE_GREETING_DESTRUCTION_LOOMS,
	DIPLO_MESSAGE_GREETING_AT_WAR_WANTS_PEACE,
	DIPLO_MESSAGE_GREETING_AT_WAR_HOSTILE,
	DIPLO_MESSAGE_GREETING_WILL_ACCEPT_SURRENDER,

	DIPLO_MESSAGE_GREETING_RESEARCH_AGREEMENT,
	DIPLO_MESSAGE_GREETING_BROKEN_MILITARY_PROMISE,
	DIPLO_MESSAGE_GREETING_WORKING_WITH,
	DIPLO_MESSAGE_GREETING_WORKING_AGAINST,
	DIPLO_MESSAGE_GREETING_COOP_WAR,
	DIPLO_MESSAGE_GREETING_HOSTILE_HUMAN_AT_WAR,
	DIPLO_MESSAGE_GREETING_HUMAN_AT_WAR,
	DIPLO_MESSAGE_GREETING_HOSTILE_AGGRESSIVE_MILITARY,
	DIPLO_MESSAGE_GREETING_AGGRESSIVE_MILITARY,
	DIPLO_MESSAGE_GREETING_HOSTILE_AGGRESSIVE_EXPANSION,
	DIPLO_MESSAGE_GREETING_AGGRESSIVE_EXPANSION,
	DIPLO_MESSAGE_GREETING_HOSTILE_AGGRESSIVE_PLOT_BUYING,
	DIPLO_MESSAGE_GREETING_AGGRESSIVE_PLOT_BUYING,
	DIPLO_MESSAGE_GREETING_FRIENDLY_STRONG_MILITARY,
	DIPLO_MESSAGE_GREETING_FRIENDLY_STRONG_ECONOMY,
	DIPLO_MESSAGE_GREETING_HOSTILE_HUMAN_FEW_CITIES,
	DIPLO_MESSAGE_GREETING_HOSTILE_HUMAN_SMALL_ARMY,
	DIPLO_MESSAGE_GREETING_HOSTILE_HUMAN_IS_WARMONGER,

	// AI has a trade offer for the human
	DIPLO_MESSAGE_DOT_DOT_DOT,
	DIPLO_MESSAGE_LETS_HEAR_IT,
	DIPLO_MESSAGE_PEACE_OFFER,
	DIPLO_MESSAGE_DEMAND,
	DIPLO_MESSAGE_REQUEST,
	DIPLO_MESSAGE_LUXURY_TRADE,
	DIPLO_MESSAGE_EMBASSY_EXCHANGE,
	DIPLO_MESSAGE_EMBASSY_OFFER,
	DIPLO_MESSAGE_OPEN_BORDERS_EXCHANGE,
	DIPLO_MESSAGE_OPEN_BORDERS_OFFER,
	DIPLO_MESSAGE_PLAN_RESEARCH_AGREEMENT,
	DIPLO_MESSAGE_RESEARCH_AGREEMENT_OFFER,
	DIPLO_MESSAGE_RENEW_DEAL,
	DIPLO_MESSAGE_WANT_MORE_RENEW_DEAL,

	// Generic AI messages to another player; some friendship, some warnings, etc.
	DIPLO_MESSAGE_HOSTILE_AGGRESSIVE_MILITARY_WARNING,
	DIPLO_MESSAGE_AGGRESSIVE_MILITARY_WARNING,
	DIPLO_MESSAGE_EXPANSION_SERIOUS_WARNING,
	DIPLO_MESSAGE_EXPANSION_WARNING,
	DIPLO_MESSAGE_EXPANSION_BROKEN_PROMISE,
	DIPLO_MESSAGE_PLOT_BUYING_SERIOUS_WARNING,
	DIPLO_MESSAGE_PLOT_BUYING_WARNING,
	DIPLO_MESSAGE_PLOT_BUYING_BROKEN_PROMISE,
	DIPLO_MESSAGE_HOSTILE_WE_ATTACKED_YOUR_MINOR,
	DIPLO_MESSAGE_WE_ATTACKED_YOUR_MINOR,
	DIPLO_MESSAGE_HOSTILE_WE_BULLIED_YOUR_MINOR,
	DIPLO_MESSAGE_WE_BULLIED_YOUR_MINOR,
	DIPLO_MESSAGE_WORK_WITH_US,
	DIPLO_MESSAGE_END_WORK_WITH_US,
	DIPLO_MESSAGE_WORK_AGAINST_SOMEONE,
	DIPLO_MESSAGE_END_WORK_AGAINST_SOMEONE,
	DIPLO_MESSAGE_COOP_WAR_REQUEST,
	DIPLO_MESSAGE_COOP_WAR_TIME,
	DIPLO_MESSAGE_NOW_UNFORGIVABLE,
	DIPLO_MESSAGE_NOW_ENEMY,
	DIPLO_MESSAGE_COMPLIMENT,
	DIPLO_MESSAGE_BOOT_KISSING,
	DIPLO_MESSAGE_WARMONGER,
	DIPLO_MESSAGE_MINOR_CIV_COMPETITION,
	DIPLO_MESSAGE_PLEASED,
	DIPLO_MESSAGE_THANKFUL,
	DIPLO_MESSAGE_DISAPPOINTED,
	DIPLO_MESSAGE_SO_BE_IT,
	DIPLO_MESSAGE_RETURNED_CIVILIAN,
	DIPLO_MESSAGE_CULTURE_BOMBED,

	// Insults
	DIPLO_MESSAGE_INSULT_ROOT,
	DIPLO_MESSAGE_INSULT_GENERIC,
	DIPLO_MESSAGE_INSULT_MILITARY,
	DIPLO_MESSAGE_INSULT_BULLY,
	DIPLO_MESSAGE_INSULT_UNHAPPINESS,
	DIPLO_MESSAGE_INSULT_CITIES,
	DIPLO_MESSAGE_INSULT_POPULATION,
	DIPLO_MESSAGE_INSULT_CULTURE,

	// AI has a public declaration to make to the world
	DIPLO_MESSAGE_DECLARATION_PROTECT_CITY_STATE,
	DIPLO_MESSAGE_DECLARATION_ABANDON_CITY_STATE,

	// Human is asking the AI for something
	DIPLO_MESSAGE_REPEAT_NO,
	DIPLO_MESSAGE_DONT_SETTLE_YES,
	DIPLO_MESSAGE_DONT_SETTLE_NO,
	DIPLO_MESSAGE_WORK_WITH_US_YES,
	DIPLO_MESSAGE_WORK_WITH_US_NO,
	DIPLO_MESSAGE_WORK_AGAINST_SOMEONE_YES,
	DIPLO_MESSAGE_WORK_AGAINST_SOMEONE_NO,
	DIPLO_MESSAGE_COOP_WAR_YES,
	DIPLO_MESSAGE_COOP_WAR_NO,
	DIPLO_MESSAGE_COOP_WAR_SOON,
	DIPLO_MESSAGE_HUMAN_DEMAND_YES,
	DIPLO_MESSAGE_HUMAN_DEMAND_REFUSE_WEAK,
	DIPLO_MESSAGE_HUMAN_DEMAND_REFUSE_HOSTILE,
	DIPLO_MESSAGE_HUMAN_DEMAND_REFUSE_TOO_MUCH,
	DIPLO_MESSAGE_HUMAN_DEMAND_REFUSE_TOO_SOON,

	// AI popped up to tell the human something, human responded and now we're responding back
	DIPLO_MESSAGE_HUMAN_HOSTILE_AGGRESSIVE_MILITARY_WARNING_BAD,
	DIPLO_MESSAGE_HUMAN_HOSTILE_AGGRESSIVE_MILITARY_WARNING_GOOD,
	DIPLO_MESSAGE_HUMAN_AGGRESSIVE_MILITARY_WARNING_BAD,
	DIPLO_MESSAGE_HUMAN_AGGRESSIVE_MILITARY_WARNING_GOOD,

	DIPLO_MESSAGE_HUMAN_HOSTILE_WE_ATTACKED_MINOR_BAD,
	DIPLO_MESSAGE_HUMAN_HOSTILE_WE_ATTACKED_MINOR_GOOD,
	DIPLO_MESSAGE_HUMAN_WE_ATTACKED_MINOR_BAD,
	DIPLO_MESSAGE_HUMAN_WE_ATTACKED_MINOR_GOOD,
	DIPLO_MESSAGE_HUMAN_HOSTILE_WE_BULLIED_MINOR_BAD,
	DIPLO_MESSAGE_HUMAN_HOSTILE_WE_BULLIED_MINOR_GOOD,
	DIPLO_MESSAGE_HUMAN_WE_BULLIED_MINOR_BAD,
	DIPLO_MESSAGE_HUMAN_WE_BULLIED_MINOR_GOOD,

	DIPLO_MESSAGE_HUMAN_ATTACKED_PROTECTED_CITY_STATE,
	DIPLO_MESSAGE_HUMAN_ATTACKED_MINOR_BAD,
	DIPLO_MESSAGE_HUMAN_ATTACKED_MINOR_GOOD,
	DIPLO_MESSAGE_HUMAN_KILLED_PROTECTED_CITY_STATE,
	DIPLO_MESSAGE_HUMAN_KILLED_MINOR_BAD,
	DIPLO_MESSAGE_HUMAN_KILLED_MINOR_GOOD,
	DIPLO_MESSAGE_HUMAN_BULLIED_PROTECTED_CITY_STATE,
	DIPLO_MESSAGE_HUMAN_BULLIED_MINOR_BAD,
	DIPLO_MESSAGE_HUMAN_BULLIED_MINOR_GOOD,

	DIPLO_MESSAGE_HUMAN_SERIOUS_EXPANSION_WARNING_BAD,
	DIPLO_MESSAGE_HUMAN_SERIOUS_EXPANSION_WARNING_GOOD,
	DIPLO_MESSAGE_HUMAN_EXPANSION_WARNING_BAD,
	DIPLO_MESSAGE_HUMAN_EXPANSION_WARNING_GOOD,

	DIPLO_MESSAGE_HUMAN_SERIOUS_PLOT_BUYING_WARNING_BAD,
	DIPLO_MESSAGE_HUMAN_SERIOUS_PLOT_BUYING_WARNING_GOOD,
	DIPLO_MESSAGE_HUMAN_PLOT_BUYING_WARNING_BAD,
	DIPLO_MESSAGE_HUMAN_PLOT_BUYING_WARNING_GOOD,

	// Peace messages
	DIPLO_MESSAGE_PEACE_WHAT_WILL_HUMAN_OFFER,
	DIPLO_MESSAGE_PEACE_MADE_BY_HUMAN_GRACIOUS,
	DIPLO_MESSAGE_NO_PEACE,
	DIPLO_MESSAGE_TOO_SOON_NO_PEACE,

	// Trade responses
	DIPLO_MESSAGE_REPEAT_TRADE_TOO_MUCH,
	DIPLO_MESSAGE_REPEAT_TRADE,
	DIPLO_MESSAGE_TRADE_ACCEPT_GENEROUS,
	DIPLO_MESSAGE_TRADE_ACCEPT_ACCEPTABLE,
	DIPLO_MESSAGE_TRADE_ACCEPT_AI_DEMAND,
	DIPLO_MESSAGE_TRADE_ACCEPT_HUMAN_CONCESSIONS,
	DIPLO_MESSAGE_TRADE_REJECT_UNACCEPTABLE,
	DIPLO_MESSAGE_TRADE_REJECT_INSULTING,
	DIPLO_MESSAGE_TRADE_DEAL_UNCHANGED,
	DIPLO_MESSAGE_TRADE_AI_MAKES_OFFER,
	DIPLO_MESSAGE_TRADE_NO_DEAL_POSSIBLE,
	DIPLO_MESSAGE_TRADE_CANT_MATCH_OFFER,

	// Human declared war on AI, what is the AI's response?
	DIPLO_MESSAGE_ATTACKED_ROOT,
	DIPLO_MESSAGE_ATTACKED_HOSTILE,
	DIPLO_MESSAGE_ATTACKED_WEAK_HOSTILE,
	DIPLO_MESSAGE_ATTACKED_STRONG_HOSTILE,
	DIPLO_MESSAGE_ATTACKED_EXCITED,
	DIPLO_MESSAGE_ATTACKED_WEAK_EXCITED,
	DIPLO_MESSAGE_ATTACKED_STRONG_EXCITED,
	DIPLO_MESSAGE_ATTACKED_SAD,
	DIPLO_MESSAGE_ATTACKED_BETRAYED,
	DIPLO_MESSAGE_ATTACKED_MILITARY_PROMISE_BROKEN,

	// AI is declaring war on human, what does he say?
	DIPLO_MESSAGE_DOW_ROOT,
	DIPLO_MESSAGE_DOW_GENERIC,
	DIPLO_MESSAGE_DOW_LAND,
	DIPLO_MESSAGE_DOW_WORLD_CONQUEST,
	DIPLO_MESSAGE_DOW_OPPORTUNITY,
	DIPLO_MESSAGE_DOW_DESPERATE,
	DIPLO_MESSAGE_DOW_BETRAYAL,
	DIPLO_MESSAGE_DOW_WEAK_BETRAYAL,
	DIPLO_MESSAGE_DOW_REGRET,
	DIPLO_MESSAGE_WAR_DEMAND_REFUSED,

	// Messages added post-Civ5 Gold
	DIPLO_MESSAGE_DOF_AI_DENOUNCE_REQUEST,
	DIPLO_MESSAGE_DOF_AI_WAR_REQUEST,
	DIPLO_MESSAGE_DOF_NOT_HONORED,
	DIPLO_MESSAGE_AI_DOF_BACKSTAB,
	DIPLO_MESSAGE_RESPONSE_TO_BEING_DENOUNCED,
	DIPLO_MESSAGE_HUMAN_DOFED_FRIEND,
	DIPLO_MESSAGE_HUMAN_DOFED_ENEMY,
	DIPLO_MESSAGE_HUMAN_DENOUNCED_FRIEND,
	DIPLO_MESSAGE_HUMAN_DENOUNCED_ENEMY,
	DIPLO_MESSAGE_HUMAN_DENOUNCE_SO_AI_DOF,
	DIPLO_MESSAGE_HUMAN_DOF_SO_AI_DENOUNCE,
	DIPLO_MESSAGE_HUMAN_DENOUNCE_SO_AI_DENOUNCE,
	DIPLO_MESSAGE_HUMAN_DOF_SO_AI_DOF,
	DIPLO_MESSAGE_GREETING_DENOUNCED_BY_AI,
	DIPLO_MESSAGE_GREETING_DENOUNCED_AI,
	DIPLO_MESSAGE_GREETING_OUR_DOF_WITH_AI_ENEMY,
	DIPLO_MESSAGE_GREETING_OUR_DOF_WITH_AI_FRIEND,
	DIPLO_MESSAGE_GREETING_DENOUNCED_AI_FRIEND,
	DIPLO_MESSAGE_GREETING_DENOUNCED_AI_ENEMY,
	DIPLO_MESSAGE_TOO_SOON_FOR_DOF,
	DIPLO_MESSAGE_INSULT_NUKE,
	DIPLO_MESSAGE_SAME_POLICIES_FREEDOM,
	DIPLO_MESSAGE_SAME_POLICIES_ORDER,
	DIPLO_MESSAGE_SAME_POLICIES_AUTOCRACY,

	// Espionage messages
	DIPLO_MESSAGE_CAUGHT_YOUR_SPY,
	DIPLO_MESSAGE_KILLED_YOUR_SPY,
	DIPLO_MESSAGE_KILLED_MY_SPY,
	DIPLO_MESSAGE_CONFRONT_YOU_KILLED_MY_SPY,

	// Espionage responses
	DIPLO_MESSAGE_HUMAN_CAUGHT_YOUR_SPY_GOOD,
	DIPLO_MESSAGE_HUMAN_CAUGHT_YOUR_SPY_BAD,

	DIPLO_MESSAGE_STOP_SPYING_YES,
	DIPLO_MESSAGE_STOP_SPYING_NO,

	DIPLO_MESSAGE_WARNED_ABOUT_INTRIGUE, // player shares intrigue with AI
	DIPLO_MESSAGE_SHARE_INTRIGUE, // AI shares intrigue to player
	DIPLO_MESSAGE_SHARE_INTRIGUE_ARMY_SNEAK_ATTACK_KNOWN_CITY,
	DIPLO_MESSAGE_SHARE_INTRIGUE_ARMY_SNEAK_ATTACK_UNKNOWN_CITY,
	DIPLO_MESSAGE_SHARE_INTRIGUE_AMPHIBIOUS_SNEAK_ATTACK_KNOWN_CITY,
	DIPLO_MESSAGE_SHARE_INTRIGUE_AMPHIBIOUS_SNEAK_ATTACK_UNKNOWN_CITY,

	DIPLO_MESSAGE_HUMAN_KILLED_MY_SPY_UNFORGIVEN,
	DIPLO_MESSAGE_HUMAN_KILLED_MY_SPY_FORGIVEN,

	// Religion messages
	DIPLO_MESSAGE_STOP_CONVERSIONS,
	DIPLO_MESSAGE_HUMAN_STOP_CONVERSIONS_GOOD,
	DIPLO_MESSAGE_HUMAN_STOP_CONVERSIONS_BAD,
	DIPLO_MESSAGE_STOP_CONVERSIONS_AGREE, // the AI's response when the player asks to stop spreading religion through missionaries and prophets
	DIPLO_MESSAGE_STOP_CONVERSIONS_DISAGREE, // the AI's response when the player asks to stop spreading religion through missionaries and prophets

	// Archeology messages
	DIPLO_MESSAGE_STOP_DIGGING,
	DIPLO_MESSAGE_HUMAN_STOP_DIGGING_GOOD,
	DIPLO_MESSAGE_HUMAN_STOP_DIGGING_BAD,
	DIPLO_MESSAGE_STOP_DIGGING_AGREE, // the AI's response when the player asks to stop looting his stuff
	DIPLO_MESSAGE_STOP_DIGGING_DISAGREE, // the AI's response when the player asks to stop looting his stuff

	// League messages
	DIPLO_MESSAGE_WE_LIKED_THEIR_PROPOSAL,
	DIPLO_MESSAGE_WE_DISLIKED_THEIR_PROPOSAL,
	DIPLO_MESSAGE_THEY_SUPPORTED_OUR_PROPOSAL,
	DIPLO_MESSAGE_THEY_FOILED_OUR_PROPOSAL,
	DIPLO_MESSAGE_THEY_SUPPORTED_OUR_HOSTING,

	// Ideological messages
	DIPLO_MESSAGE_YOUR_IDEOLOGY_CAUSING_CIVIL_UNREST_FREEDOM,
	DIPLO_MESSAGE_YOUR_IDEOLOGY_CAUSING_CIVIL_UNREST_ORDER,
	DIPLO_MESSAGE_YOUR_IDEOLOGY_CAUSING_CIVIL_UNREST_AUTOCRACY,
	DIPLO_MESSAGE_OUR_IDEOLOGY_CAUSING_CIVIL_UNREST_FREEDOM,
	DIPLO_MESSAGE_OUR_IDEOLOGY_CAUSING_CIVIL_UNREST_ORDER,
	DIPLO_MESSAGE_OUR_IDEOLOGY_CAUSING_CIVIL_UNREST_AUTOCRACY,
	DIPLO_MESSAGE_SWITCH_OUR_IDEOLOGY_FREEDOM,
	DIPLO_MESSAGE_SWITCH_OUR_IDEOLOGY_ORDER,
	DIPLO_MESSAGE_SWITCH_OUR_IDEOLOGY_AUTOCRACY,
	DIPLO_MESSAGE_YOUR_CULTURE_INFLUENTIAL,
	DIPLO_MESSAGE_OUR_CULTURE_INFLUENTIAL,

	NUM_DIPLO_MESSAGE_TYPES,
};

enum GameStateTypes					
{
	GAMESTATE_ON,
	GAMESTATE_OVER,
	GAMESTATE_EXTENDED,
};

enum CameraLookAtTypes			
{
	CAMERALOOKAT_NORMAL,
	CAMERALOOKAT_CITY_ZOOM_IN,
	CAMERALOOKAT_CITY_ZOOM_OUT,
	CAMERALOOKAT_BATTLE,
	CAMERALOOKAT_BATTLE_ZOOM_IN,
	CAMERALOOKAT_SHRINE_ZOOM_IN,
	CAMERALOOKAT_IMMEDIATE,
	CAMERALOOKAT_HOTSEAT,
};

enum DirectionTypes					
{
	NO_DIRECTION = -1,

	DIRECTION_NORTHEAST,
	DIRECTION_EAST,
	DIRECTION_SOUTHEAST,
	DIRECTION_SOUTHWEST,
	DIRECTION_WEST,
	DIRECTION_NORTHWEST,

	NUM_DIRECTION_TYPES,

	DIRECTION_NORTH = DIRECTION_NORTHEAST, // deprecated
	DIRECTION_SOUTH = DIRECTION_SOUTHWEST, // deprecated

	DIRECTION_NORTH_MASK = 1 << 0,							// DIRECTION_NORTH,
	DIRECTION_NORTHEAST_MASK = 1 << 1,						// DIRECTION_NORTHEAST,
	DIRECTION_EAST_MASK = 1 << 2,							// DIRECTION_EAST,
	DIRECTION_SOUTHEAST_MASK = 1 << 3,						// DIRECTION_SOUTHEAST,
	DIRECTION_SOUTH_MASK = 1 << 4,							// DIRECTION_SOUTH, 
	DIRECTION_SOUTHWEST_MASK = 1 << 5,						// DIRECTION_SOUTHWEST,
	DIRECTION_WEST_MASK = 1 << 6,							// DIRECTION_WEST,
	DIRECTION_NORTHWEST_MASK = 1 << 7,						// DIRECTION_NORTHWEST,
};

enum FlowDirectionTypes					
{
	NO_FLOWDIRECTION = -1,

	FLOWDIRECTION_NORTH,
	FLOWDIRECTION_NORTHEAST,
	FLOWDIRECTION_SOUTHEAST,
	FLOWDIRECTION_SOUTH,
	FLOWDIRECTION_SOUTHWEST,
	FLOWDIRECTION_NORTHWEST,

	NUM_FLOWDIRECTION_TYPES,

	FLOWDIRECTION_NORTH_MASK = 1 << 0,							// FLOWDIRECTION_NORTH,
	FLOWDIRECTION_SOUTH_MASK = 1 << 1,							// FLOWDIRECTION_SOUTH, 
	FLOWDIRECTION_SOUTHEAST_MASK = 1 << 2,						// FLOWDIRECTION_SOUTHEAST,
	FLOWDIRECTION_NORTHWEST_MASK = 1 << 3,						// FLOWDIRECTION_NORTHWEST,
	FLOWDIRECTION_SOUTHWEST_MASK = 1 << 4,						// FLOWDIRECTION_SOUTHWEST,
	FLOWDIRECTION_NORTHEAST_MASK = 1 << 5,						// FLOWDIRECTION_NORTHEAST,
};



enum RotationTypes
{
	ROTATE_NONE = 0,
	ROTATE_90CW,
	ROTATE_180CW,
	ROTATE_270CW,
	NUM_ROTATION_TYPES,

	ROTATE_NONE_MASK	= 1 << ROTATE_NONE,
	ROTATE_90CW_MASK	= 1 << ROTATE_90CW,
	ROTATE_180CW_MASK	= 1 << ROTATE_180CW,
	ROTATE_270CW_MASK	= 1 << ROTATE_270CW,
};

// camera wrap helper
enum WrapDirection
{
	WRAP_SAVE,
	WRAP_NONE = WRAP_SAVE,
	WRAP_RESTORE,
	WRAP_LEFT,
	WRAP_RIGHT,
	WRAP_UP,
	WRAP_DOWN,

	NUM_WRAP_DIRECTIONS,

	WRAP_LEFT_MASK = 1 << WRAP_LEFT,
	WRAP_RIGHT_MASK = 1 << WRAP_RIGHT,
	WRAP_UP_MASK = 1 << WRAP_UP,
	WRAP_DOWN_MASK = 1 << WRAP_DOWN,
};

enum ColorTypes						
{
	NO_COLOR = -1,
};

enum PlayerColorTypes			
{
	NO_PLAYERCOLOR = -1,
};

enum InterfaceModeTypes			
{
	NO_INTERFACEMODE = -1,

	INTERFACEMODE_DEBUG,
	INTERFACEMODE_SELECTION,
	INTERFACEMODE_PING,
	INTERFACEMODE_MOVE_TO,
	INTERFACEMODE_MOVE_TO_TYPE,
	INTERFACEMODE_MOVE_TO_ALL,
	INTERFACEMODE_ROUTE_TO,
	INTERFACEMODE_AIRLIFT,
	INTERFACEMODE_NUKE,
	INTERFACEMODE_PARADROP,
	INTERFACEMODE_ATTACK,
	INTERFACEMODE_RANGE_ATTACK,
	INTERFACEMODE_AIRSTRIKE,
	INTERFACEMODE_AIR_SWEEP,
	INTERFACEMODE_REBASE,
	INTERFACEMODE_PLACE_UNIT,
	INTERFACEMODE_EMBARK,
	INTERFACEMODE_DISEMBARK,
	INTERFACEMODE_GIFT_UNIT,
	INTERFACEMODE_CITY_PLOT_SELECTION,
	INTERFACEMODE_PURCHASE_PLOT,
	INTERFACEMODE_CITY_RANGE_ATTACK,
	INTERFACEMODE_GIFT_TILE_IMPROVEMENT,
	INTERFACEMODE_ESTABLISH_TRADE_ROUTE,

	NUM_INTERFACEMODE_TYPES
};

enum InterfaceMessageTypes	
{
	NO_MESSAGE_TYPE = -1,

	MESSAGE_TYPE_INFO,
	MESSAGE_TYPE_DISPLAY_ONLY,
	MESSAGE_TYPE_MAJOR_EVENT,
	MESSAGE_TYPE_MINOR_EVENT,
	MESSAGE_TYPE_CHAT,
	MESSAGE_TYPE_COMBAT_MESSAGE,
	MESSAGE_TYPE_QUEST,

	NUM_INTERFACE_MESSAGE_TYPES
};


//  !!!!!!!!!!!!!!!!!!!!!!! 
//  IMPORTANT - NotificationTypes enum contains hash values, not an index!
//  It is not required to add a new enum for a new notification, you can just use the hash (FString::Hash) of the name
//	as defined in the Notifications.xml or equivalent.  The enum is just a helper so that the has generation is done
//	at compile time.  e.g.  the enum NOTIFICATION_TECH is equivalent to FString::Hash("NOTIFICATION_TECH")
//
//  MODDERS:
//		If you add a new notification, you do NOT have to add it to this helper list, you can just make a define
//		with the desired hash ID on the DLL side and just cast the value to a NotificationTypes value when passing it
//		to the notification system.

//	When adding Notifications, please remember to add an entry in the sound notifications file using the same name.
//  !!!!!!!!!!!!!!!!!!!!!!! 

enum NotificationTypes	
{
	NO_NOTIFICATION_TYPE = -1,

	NOTIFICATION_GENERIC								= 0xBE9725C6,
	NOTIFICATION_TECH									= 0x5ACFA6F7,
	NOTIFICATION_FREE_TECH								= 0x489B80B6,
	NOTIFICATION_POLICY									= 0x252BFE28,
	NOTIFICATION_PRODUCTION								= 0x77014C62,
	NOTIFICATION_MET_MINOR								= 0x3A8582E9,
	NOTIFICATION_MINOR									= 0xC659D71E,
	NOTIFICATION_MINOR_QUEST							= 0xAE971DE0,
	NOTIFICATION_ENEMY_IN_TERRITORY						= 0x9E9F2BE6,

	NOTIFICATION_CITY_RANGE_ATTACK						= 0xB9985C59,
	NOTIFICATION_BARBARIAN								= 0x70CB3D66,
	NOTIFICATION_GOODY									= 0xDC66FA17,
	NOTIFICATION_BUY_TILE								= 0xCD412906,
	NOTIFICATION_CITY_GROWTH							= 0xCD6F572E,
	NOTIFICATION_CITY_TILE								= 0x66532408,
	NOTIFICATION_DEMAND_RESOURCE						= 0x250F2E27, 
	NOTIFICATION_UNIT_PROMOTION							= 0x5ED9C509,
	//	NOTIFICATION_WONDER_STARTED,

	NOTIFICATION_WONDER_COMPLETED_ACTIVE_PLAYER			= 0x9B741B7F,
	NOTIFICATION_WONDER_COMPLETED						= 0x7CACC6FF,
	NOTIFICATION_WONDER_BEATEN							= 0x5FCF949D,
	NOTIFICATION_GOLDEN_AGE_BEGUN_ACTIVE_PLAYER			= 0x3B74383C,
	//	NOTIFICATION_GOLDEN_AGE_BEGUN,
	NOTIFICATION_GOLDEN_AGE_ENDED_ACTIVE_PLAYER			= 0x5E2FD815,
	//	NOTIFICATION_GOLDEN_AGE_ENDED,
	NOTIFICATION_GREAT_PERSON_ACTIVE_PLAYER				= 0x83CD0016,
	//	NOTIFICATION_GREAT_PERSON,
	NOTIFICATION_STARVING								= 0xBA039C65,
	NOTIFICATION_WAR_ACTIVE_PLAYER						= 0xF4A99B85,
	NOTIFICATION_WAR									= 0xC6E3B719,
	NOTIFICATION_PEACE_ACTIVE_PLAYER					= 0x871DF8E9,
	NOTIFICATION_PEACE									= 0x30C5B663,

	NOTIFICATION_VICTORY								= 0x5863844F,
	NOTIFICATION_UNIT_DIED								= 0xFF07247A,
	NOTIFICATION_CITY_LOST								= 0x509909A6,
	NOTIFICATION_CAPITAL_LOST_ACTIVE_PLAYER				= 0x4171D8C8,
	NOTIFICATION_CAPITAL_LOST							= 0xF62E7EAB,
	NOTIFICATION_CAPITAL_RECOVERED						= 0x8F31E937,
	NOTIFICATION_PLAYER_KILLED							= 0xF6FFC169,
	NOTIFICATION_DISCOVERED_LUXURY_RESOURCE				= 0xB6EB90D6,
	NOTIFICATION_DISCOVERED_STRATEGIC_RESOURCE			= 0x7CD306AC,
	NOTIFICATION_DISCOVERED_BONUS_RESOURCE				= 0x7E312F61,
	//	NOTIFICATION_POLICY_ADOPTION,
	NOTIFICATION_DIPLO_VOTE								= 0x769821E9,
	NOTIFICATION_RELIGION_RACE							= 0xA9E7CC17,

	NOTIFICATION_EXPLORATION_RACE						= 0x97818EEE, 
	NOTIFICATION_DIPLOMACY_DECLARATION					= 0x4EA00B5D,
	NOTIFICATION_DEAL_EXPIRED_GPT						= 0xF1FC86ED,
	NOTIFICATION_DEAL_EXPIRED_RESOURCE					= 0x211D6F50,
	NOTIFICATION_DEAL_EXPIRED_OPEN_BORDERS				= 0x008A2ABC,
	NOTIFICATION_DEAL_EXPIRED_DEFENSIVE_PACT			= 0x8366A830,
	NOTIFICATION_DEAL_EXPIRED_RESEARCH_AGREEMENT		= 0xA38ED029,
	NOTIFICATION_DEAL_EXPIRED_TRADE_AGREEMENT			= 0x8F01D6C4,
	NOTIFICATION_TECH_AWARD								= 0xFE00B7C9,
	NOTIFICATION_PLAYER_DEAL							= 0x6A5B7F95,
	NOTIFICATION_PLAYER_DEAL_RECEIVED					= 0xBA59E179,
	NOTIFICATION_PLAYER_DEAL_RESOLVED					= 0xC4E10B71,
	NOTIFICATION_PROJECT_COMPLETED						= 0x5F186E9D,

	NOTIFICATION_REBELS									= 0xACDB3C04,
	NOTIFICATION_FREE_POLICY							= 0x1E4417C5,
	NOTIFICATION_FREE_GREAT_PERSON						= 0xAB4C3BB3,
	NOTIFICATION_DENUNCIATION_EXPIRED					= 0xADA4A172,
	NOTIFICATION_FRIENDSHIP_EXPIRED						= 0xE4EDF657,
	NOTIFICATION_RELIGION_FOUNDED_ACTIVE_PLAYER			= 0x0CE337A4,
	NOTIFICATION_RELIGION_FOUNDED						= 0x5A5E7D9E,
	NOTIFICATION_PANTHEON_FOUNDED_ACTIVE_PLAYER			= 0xE940EB52,
	NOTIFICATION_PANTHEON_FOUNDED						= 0x3D493221,
	NOTIFICATION_FOUND_PANTHEON							= 0x4C4B3599,
	NOTIFICATION_FOUND_RELIGION							= 0x7EE00DFD,
	NOTIFICATION_ENHANCE_RELIGION						= 0xE9C73F3F,
	NOTIFICATION_RELIGION_ENHANCED_ACTIVE_PLAYER		= 0xE7ED7441,
	NOTIFICATION_RELIGION_ENHANCED						= 0x019742E3,
	NOTIFICATION_SPY_CREATED_ACTIVE_PLAYER				= 0xE626E70A,
	NOTIFICATION_SPY_STOLE_TECH							= 0x963AC73A,
	NOTIFICATION_SPY_CANT_STEAL_TECH					= 0x0E58C1D5,
	NOTIFICATION_CAN_BUILD_MISSIONARY					= 0xA754D3D8,
	NOTIFICATION_OTHER_PLAYER_NEW_ERA					= 0xFC07F784,
	NOTIFICATION_SPY_EVICTED							= 0x81E90DE0,
	NOTIFICATION_RELIGION_SPREAD						= 0x71FB054A,
	NOTIFICATION_TECH_STOLEN_SPY_DETECTED				= 0x03691C24,
	NOTIFICATION_TECH_STOLEN_SPY_IDENTIFIED				= 0xD50B2758,
	NOTIFICATION_SPY_WAS_KILLED							= 0x149E6E49, 
	NOTIFICATION_SPY_KILLED_A_SPY						= 0xFCC63818,
	NOTIFICATION_SPY_REPLACEMENT						= 0x9ABF6534,
	NOTIFICATION_MAYA_LONG_COUNT						= 0x054C8467,
	NOTIFICATION_FAITH_GREAT_PERSON						= 0x520420C2,
	NOTIFICATION_SPY_PROMOTION							= 0x0AC06951,
	NOTIFICATION_INTRIGUE_DECEPTION						= 0x1E3E4861,
	NOTIFICATION_SPY_RIG_ELECTION_SUCCESS				= 0xA6713B03,
	NOTIFICATION_SPY_RIG_ELECTION_FAILURE				= 0xE8EAE770,
	NOTIFICATION_SPY_RIG_ELECTION_ALERT					= 0xB1B7C601,
	NOTIFICATION_SPY_YOU_STAGE_COUP_SUCCESS				= 0xCB18D8D7,
	NOTIFICATION_SPY_YOU_STAGE_COUP_FAILURE				= 0x858304A4,
	NOTIFICATION_SPY_STAGE_COUP_SUCCESS					= 0xFECE1A13,
	NOTIFICATION_SPY_STAGE_COUP_FAILURE					= 0xB055C660,

	NOTIFICATION_INTRIGUE_BUILDING_SNEAK_ATTACK_ARMY					= 0x17FEEFBE,
	NOTIFICATION_INTRIGUE_BUILDING_SNEAK_ATTACK_AMPHIBIOUS				= 0x02EAECD2,
	NOTIFICATION_INTRIGUE_SNEAK_ATTACK_ARMY_AGAINST_KNOWN_CITY_UNKNOWN	= 0xB0D00659,
	NOTIFICATION_INTRIGUE_SNEAK_ATTACK_ARMY_AGAINST_KNOWN_CITY_KNOWN	= 0xAAA52CE6,
	NOTIFICATION_INTRIGUE_SNEAK_ATTACK_ARMY_AGAINST_YOU_CITY_UNKNOWN	= 0x7F41A9F3,
	NOTIFICATION_INTRIGUE_SNEAK_ATTACK_ARMY_AGAINST_YOU_CITY_KNOWN		= 0x24CC885C,
	NOTIFICATION_INTRIGUE_SNEAK_ATTACK_ARMY_AGAINST_UNKNOWN				= 0xF0330403,
	NOTIFICATION_INTRIGUE_SNEAK_ATTACK_AMPHIB_AGAINST_KNOWN_CITY_UNKNOWN= 0xF9511AC5,
	NOTIFICATION_INTRIGUE_SNEAK_ATTACK_AMPHIB_AGAINST_KNOWN_CITY_KNOWN	= 0x49A0F9A1,
	NOTIFICATION_INTRIGUE_SNEAK_ATTACK_AMPHIB_AGAINST_YOU_CITY_UNKNOWN	= 0x9C447CB4,
	NOTIFICATION_INTRIGUE_SNEAK_ATTACK_AMPHIB_AGAINST_YOU_CITY_KNOWN	= 0xFCA2CA86,
	NOTIFICATION_INTRIGUE_SNEAK_ATTACK_AMPHIB_AGAINST_UNKNOWN			= 0x2E10BE53,

	NOTIFICATION_RELIGION_ERROR							= 0x7178C0FD,
	NOTIFICATION_AUTOMATIC_FAITH_PURCHASE_STOPPED		= 0x850D1593,

	NOTIFICATION_EXPANSION_PROMISE_EXPIRED				= 0x0DE0AD70,
	NOTIFICATION_BORDER_PROMISE_EXPIRED					= 0x79F0F150,

	NOTIFICATION_TRADE_ROUTE							= 0xC51B3418,
	NOTIFICATION_TRADE_ROUTE_BROKEN						= 0xEB757CBA,

	NOTIFICATION_RELIGION_SPREAD_NATURAL				= 0xC5C4F81A,

	NOTIFICATION_INTRIGUE_CONSTRUCTING_WONDER			= 0x5B0BE213,

	NOTIFICATION_MINOR_BUYOUT							= 0x5F0813CF,

	NOTIFICATION_REQUEST_RESOURCE						= 0x2B7BDAB6, // for when cities request luxury resources for WLTK days

	NOTIFICATION_LIBERATED_MAJOR_CITY					= 0x4E8A36A4,
	NOTIFICATION_RESURRECTED_MAJOR_CIV					= 0x7500CA03,

	// XP2
	NOTIFICATION_ADD_REFORMATION_BELIEF					= 0x050B6287,
	NOTIFICATION_LEAGUE_CALL_FOR_PROPOSALS				= 0x2D0E554C,
	NOTIFICATION_CHOOSE_ARCHAEOLOGY						= 0x84B7E406,
	NOTIFICATION_LEAGUE_CALL_FOR_VOTES					= 0x97DEEB2F,
	NOTIFICATION_CHOOSE_IDEOLOGY						= 0x1192A3F3,
	NOTIFICATION_IDEOLOGY_CHOSEN						= 0x9074BDEE,
	NOTIFICATION_DIPLOMAT_EJECTED						= 0x850E0773,

	// Trade notifications
	NOTIFICATION_INTERNATIONAL_TRADE_UNIT_PLUNDERED_TRADER	= 0xF1F3E098,
	NOTIFICATION_INTERNATIONAL_TRADE_UNIT_PLUNDERED_TRADEE	= 0x7220655F,

	NOTIFICATION_REFORMATION_BELIEF_ADDED_ACTIVE_PLAYER		= 0xFA9BEA56,
	NOTIFICATION_REFORMATION_BELIEF_ADDED					= 0x60356BC1,

	NOTIFICATION_GREAT_WORK_COMPLETED_ACTIVE_PLAYER			= 0xEFB187CF,

	NOTIFICATION_LEAGUE_VOTING_DONE						= 0xFD3EEF59,
	NOTIFICATION_LEAGUE_VOTING_SOON						= 0xBE3968B6,

	NOTIFICATION_CULTURE_VICTORY_SOMEONE_INFLUENTIAL	= 0x1567EBD1,
	NOTIFICATION_CULTURE_VICTORY_WITHIN_TWO				= 0x11F69BFF,
	NOTIFICATION_CULTURE_VICTORY_WITHIN_TWO_ACTIVE_PLAYER= 0x98DE2522,
	NOTIFICATION_CULTURE_VICTORY_WITHIN_ONE				= 0x7A509768,
	NOTIFICATION_CULTURE_VICTORY_WITHIN_ONE_ACTIVE_PLAYER= 0x6656E513,
	NOTIFICATION_CULTURE_VICTORY_NO_LONGER_INFLUENTIAL	= 0xFE331E2B,

	NOTIFICATION_PLAYER_RECONNECTED						= 0x1538D3A8,	//network player connecting to the game.
	NOTIFICATION_PLAYER_DISCONNECTED					= 0x6110AC7A,	//network player disconnecting from the game.
	NOTIFICATION_TURN_MODE_SEQUENTIAL					= 0x2A32BEE8,	//Active player transitioned to sequential turn mode.
	NOTIFICATION_TURN_MODE_SIMULTANEOUS					= 0x08A6293E,	//Active player transitioned to simultaneous turn mode.
	NOTIFICATION_HOST_MIGRATION							= 0xB6299D35,
	NOTIFICATION_PLAYER_CONNECTING						= 0xAB88859D,

	NOTIFICATION_CITY_REVOLT_POSSIBLE					= 0xD1BC1A84,
	NOTIFICATION_CITY_REVOLT							= 0xE58AA15F
};

enum NotificationAggregateTypes
{
	NO_NOTIFICATION_AGGREGATE_TYPE = -1,

	NOTIFICATION_AGGREGATE_VERY_BAD,
	NOTIFICATION_AGGREGATE_BAD,
	NOTIFICATION_AGGREGATE_NEUTRAL,
	NOTIFICATION_AGGREGATE_GOOD,
	NOTIFICATION_AGGREGATE_VERY_GOOD,

	NUM_NOTIFICATION_AGGREGATE_TYPES
};

enum MinimapModeTypes		
{
	NO_MINIMAPMODE = -1,

	MINIMAPMODE_TERRITORY,
	MINIMAPMODE_TERRAIN,
	MINIMAPMODE_REPLAY,
	MINIMAPMODE_MILITARY,

	NUM_MINIMAPMODE_TYPES
};

enum InterfaceDirtyBits 
{
	SelectionCamera_DIRTY_BIT,
	Fog_DIRTY_BIT,
	Waypoints_DIRTY_BIT,
	PercentButtons_DIRTY_BIT,
	MiscButtons_DIRTY_BIT,
	PlotListButtons_DIRTY_BIT,
	SelectionButtons_DIRTY_BIT,
	CitizenButtons_DIRTY_BIT,
	ResearchButtons_DIRTY_BIT,
	Event_DIRTY_BIT,
	Center_DIRTY_BIT,
	GameData_DIRTY_BIT,
	Score_DIRTY_BIT,
	TurnTimer_DIRTY_BIT,
	Help_DIRTY_BIT,
	MinimapSection_DIRTY_BIT,
	SelectionSound_DIRTY_BIT,
	Cursor_DIRTY_BIT,
	CityInfo_DIRTY_BIT,
	UnitInfo_DIRTY_BIT,
	Popup_DIRTY_BIT,
	CityScreen_DIRTY_BIT,
	InfoPane_DIRTY_BIT,
	HighlightPlot_DIRTY_BIT,
	ColoredPlots_DIRTY_BIT,
	BlockadedPlots_DIRTY_BIT,
	Financial_Screen_DIRTY_BIT,
	Foreign_Screen_DIRTY_BIT,
	Soundtrack_DIRTY_BIT,
	Domestic_Advisor_DIRTY_BIT,
	Advanced_Start_DIRTY_BIT,
	NationalBorders_DIRTY_BIT,
	Policies_DIRTY_BIT,
	PlotData_DIRTY_BIT,
	EspionageScreen_DIRTY_BIT,
	LeagueScreen_DIRTY_BIT,
	GreatWorksScreen_DIRTY_BIT,

	NUM_INTERFACE_DIRTY_BITS
};

// These are the different types of things that can be updated in the Interface for a City
enum CityUpdateTypes
{
	NO_CITY_UPDATE_TYPE = -1,

	CITY_UPDATE_TYPE_BANNER,
	CITY_UPDATE_TYPE_SPECIALISTS,
	CITY_UPDATE_TYPE_PRODUCTION,
	CITY_UPDATE_TYPE_ENEMY_IN_RANGE,
	CITY_UPDATE_TYPE_GARRISON,

	NUM_CITY_UPDATE_TYPES
};

//////////////////////////////////////////
//    /\   | |    |  ____|  __ \__   __| |
//   /  \  | |    | |__  | |__) | | |  | |
//  / /\ \ | |    |  __| |  _  /  | |  | |
// / ____ \| |____| |____| | \ \  | |  |_|
///_/    \_\______|______|_|  \_\ |_|  (_)
//////////////////////////////////////////


// If you want the game to work correctly, be careful when you modify ButtonPopupTypes.
// They are directly tied into playing sounds, so if you add, remove, or (God forbid) replace one of these,
// please make sure if you want a sound to play, modify Assets\\Sounds\\ButtonPopupSounds.xml.  You also need to
// modify cvAudioSimMainGame::BuildButtonPopupSoundTable to register the link between the enum and the sound ID (the text hash of the enum name).

enum ButtonPopupTypes			
{
	BUTTONPOPUP_TEXT,
	BUTTONPOPUP_MAIN_MENU,
	BUTTONPOPUP_CONFIRM_MENU,
	BUTTONPOPUP_DECLAREWARMOVE,
	BUTTONPOPUP_DECLAREWARRANGESTRIKE,
	BUTTONPOPUP_CONFIRMCOMMAND,
	BUTTONPOPUP_CONFIRM_CITY_TASK,
	BUTTONPOPUP_CONFIRM_IMPROVEMENT_REBUILD,
	BUTTONPOPUP_GREAT_PERSON,
	BUTTONPOPUP_LOADUNIT,
	BUTTONPOPUP_LEADUNIT,
	BUTTONPOPUP_CHOOSETECH,
	BUTTONPOPUP_CITY_CAPTURED,
	BUTTONPOPUP_ANNEX_CITY,
	BUTTONPOPUP_LIBERATE_MINOR,  // DON'T BE AN IDIOT!!!
	BUTTONPOPUP_DISBANDCITY,
	BUTTONPOPUP_CHOOSEPRODUCTION,
	BUTTONPOPUP_CHOOSEPOLICY,
	BUTTONPOPUP_CHOOSECITYPURCHASE,
	BUTTONPOPUP_CHOOSEELECTION,
	BUTTONPOPUP_DIPLOVOTE,
	BUTTONPOPUP_ALARM,
	BUTTONPOPUP_DEAL_CANCELED,
	BUTTONPOPUP_PYTHON,
	BUTTONPOPUP_PYTHON_SCREEN,
	BUTTONPOPUP_DETAILS,
	BUTTONPOPUP_ADMIN,
	BUTTONPOPUP_ADMIN_PASSWORD,
	BUTTONPOPUP_EXTENDED_GAME,
	BUTTONPOPUP_DIPLOMACY,
	BUTTONPOPUP_ADDBUDDY,		// BE SMART, NOT DUMB! DON'T MESS WITH THIS!
	BUTTONPOPUP_FORCED_DISCONNECT,
	BUTTONPOPUP_PITBOSS_DISCONNECT,
	BUTTONPOPUP_KICKED,
	BUTTONPOPUP_FREE_COLONY,
	BUTTONPOPUP_LAUNCH,
	BUTTONPOPUP_MINOR_GOLD,
	BUTTONPOPUP_MINOR_CIV_QUEST,
	BUTTONPOPUP_MINOR_CIV_QUEST_COMPLETED,
	BUTTONPOPUP_MINOR_CIV_INTRUSION,
	BUTTONPOPUP_MINOR_CIV_GREETING_AND_WAR,
	BUTTONPOPUP_BARBARIAN_RANSOM,
	BUTTONPOPUP_MINOR_CIV_ENTER_TERRITORY,
	BUTTONPOPUP_TEMP_SPECIALISTS,
	BUTTONPOPUP_NOTIFICATION_LOG,	// DANGER DANGER DANGER!!!!!
	BUTTONPOPUP_ECONOMIC_OVERVIEW,	// DANGER DANGER DANGER!!!!!
	BUTTONPOPUP_MILITARY_OVERVIEW,	// DANGER DANGER DANGER!!!!!
	BUTTONPOPUP_DIPLOMATIC_OVERVIEW,	// DANGER DANGER DANGER!!!!!
	BUTTONPOPUP_DEMOGRAPHICS,	// DANGER DANGER DANGER!!!!!
	BUTTONPOPUP_VICTORY_INFO,	// DANGER DANGER DANGER!!!!!
	BUTTONPOPUP_MINOR_CIVS_LIST,
	BUTTONPOPUP_GIFT_CONFIRM,
	BUTTONPOPUP_RETURN_CIVILIAN,
	BUTTONPOPUP_CONFIRM_POLICY_BRANCH_SWITCH,
	BUTTONPOPUP_WHOS_WINNING,
	BUTTONPOPUP_NEW_ERA,
	BUTTONPOPUP_NATURAL_WONDER_REWARD,
	BUTTONPOPUP_GOODY_HUT_REWARD,
	BUTTONPOPUP_BARBARIAN_CAMP_REWARD,
	BUTTONPOPUP_GOLDEN_AGE_REWARD,
	BUTTONPOPUP_GREAT_PERSON_REWARD,
	BUTTONPOPUP_CITY_STATE_GREETING,
	BUTTONPOPUP_CITY_STATE_MESSAGE,
	BUTTONPOPUP_CITY_STATE_DIPLO,
	BUTTONPOPUP_CITY_PLOT_MANAGEMENT,
	BUTTONPOPUP_DIPLO_VOTE,
	BUTTONPOPUP_VOTE_RESULTS,
	BUTTONPOPUP_TECH_TREE,		// FOR THE LOVE OF GOD AND ALL THAT IS HOLY, BE CAREFUL WHEN MODIFYING THIS ENUM
	BUTTONPOPUP_TECH_AWARD,
	BUTTONPOPUP_WONDER_COMPLETED_ACTIVE_PLAYER,
	BUTTONPOPUP_ADVISOR_INFO,
	BUTTONPOPUP_ADVISOR_COUNSEL,
	BUTTONPOPUP_ADVISOR_MODAL,
	BUTTONPOPUP_RENAME_CITY,
	BUTTONPOPUP_RENAME_UNIT,
	BUTTONPOPUP_CHOOSE_FREE_GREAT_PERSON,
	BUTTONPOPUP_FOUND_PANTHEON,
	BUTTONPOPUP_FOUND_RELIGION,
	BUTTONPOPUP_ESPIONAGE_OVERVIEW,
	BUTTONPOPUP_RELIGION_OVERVIEW,
	BUTTONPOPUP_CHOOSE_TECH_TO_STEAL,
	BUTTONPOPUP_CHOOSE_MAYA_BONUS,
	BUTTONPOPUP_CHOOSE_FAITH_GREAT_PERSON,	// Do not add any more sequential enums!  Use hash values!

	// Do not add any more sequential enums!  Use hash values!

	BUTTONPOPUP_MODDER_0,
	BUTTONPOPUP_MODDER_1,
	BUTTONPOPUP_MODDER_2,
	BUTTONPOPUP_MODDER_3,
	BUTTONPOPUP_MODDER_4,
	BUTTONPOPUP_MODDER_5,
	BUTTONPOPUP_MODDER_6,
	BUTTONPOPUP_MODDER_7,
	BUTTONPOPUP_MODDER_8,
	BUTTONPOPUP_MODDER_9,
	BUTTONPOPUP_MODDER_10,
	BUTTONPOPUP_MODDER_11,

	NUM_FIXED_BUTTONPOPUP_TYPES,		// Do not add any more sequential enums!  Use hash values!
};

//////////////////////////////////////////
//    /\   | |    |  ____|  __ \__   __| |
//   /  \  | |    | |__  | |__) | | |  | |
//  / /\ \ | |    |  __| |  _  /  | |  | |
// / ____ \| |____| |____| | \ \  | |  |_|
///_/    \_\______|______|_|  \_\ |_|  (_)
//////////////////////////////////////////

// you can stop freaking out now. It's ok.
enum ClimateTypes					
{
	NO_CLIMATE = -1,
};

enum SeaLevelTypes				
{
	NO_SEALEVEL = -1,
};

enum WorldSizeTypes				
{
	NO_WORLDSIZE = -1,

	WORLDSIZE_DUEL,
	WORLDSIZE_TINY,
	WORLDSIZE_SMALL,
	WORLDSIZE_STANDARD,
	WORLDSIZE_LARGE,
	WORLDSIZE_HUGE,
	WORLDSIZE_DEBUG,

	NUM_WORLDSIZE_TYPES
};

// This is our current relationship with each 
// one of our connected network peers
enum InitStates
{
	INIT_INACTIVE,
	INIT_CONNECTED,
	INIT_SENT_READY,
	INIT_READY,
	INIT_ASSIGNED_ID,
	INIT_SENT_ID,
	INIT_PEER,
	INIT_FILE_TRANSFER,
	INIT_TRANSFER_COMPLETE,
	INIT_AUTHORIZED,
	INIT_MAP_CONFIRMED,
	INIT_GAME_STARTED,
};


enum TerrainTypes					
{
	NO_TERRAIN = -1,

	TERRAIN_GRASS,
	TERRAIN_PLAINS,
	TERRAIN_DESERT,
	TERRAIN_TUNDRA,
	TERRAIN_SNOW,
	TERRAIN_COAST,
	TERRAIN_OCEAN,
	TERRAIN_MOUNTAIN,
	TERRAIN_HILL,

	NUM_TERRAIN_TYPES
};

enum PlotTypes							
{
	NO_PLOT = -1,

	PLOT_MOUNTAIN,
	PLOT_HILLS,
	PLOT_LAND,
	PLOT_OCEAN,

	NUM_PLOT_TYPES
};

enum FlavorTypes						
{
	NO_FLAVOR = -1
};

enum EmphasizeTypes					
{
	NO_EMPHASIZE = -1,
};

enum GameOptionTypes				
{
	NO_GAMEOPTION = -1,

	// WARNING: Do not use these enums to index into the GameOptionInfo table, they will not line up!
	//          Nor should use use the index of a GameOptionInfo entry as a GameOptionTypes enum for use with SetGameOptions!
	GAMEOPTION_NO_CITY_RAZING,
	GAMEOPTION_NO_BARBARIANS,
	GAMEOPTION_RAGING_BARBARIANS,
	GAMEOPTION_ALWAYS_WAR,
	GAMEOPTION_ALWAYS_PEACE,
	GAMEOPTION_ONE_CITY_CHALLENGE,
	GAMEOPTION_NO_CHANGING_WAR_PEACE,
	GAMEOPTION_NEW_RANDOM_SEED,
	GAMEOPTION_LOCK_MODS,
	GAMEOPTION_COMPLETE_KILLS,
	GAMEOPTION_NO_GOODY_HUTS,
	GAMEOPTION_RANDOM_PERSONALITIES,
	GAMEOPTION_POLICY_SAVING,
	GAMEOPTION_PROMOTION_SAVING,
	GAMEOPTION_END_TURN_TIMER_ENABLED,
	GAMEOPTION_QUICK_COMBAT,
	GAMEOPTION_DISABLE_START_BIAS,
	GAMEOPTION_NO_SCIENCE,
	GAMEOPTION_NO_POLICIES,
	GAMEOPTION_NO_HAPPINESS,
	GAMEOPTION_NO_TUTORIAL,
	GAMEOPTION_NO_RELIGION,

	// KWG: Please do add anymore enums.  Use the CvPreGame::GetGameOption which uses a text key.
	//      These enums are shared between DLLs and would diverge if each added their own.
	NUM_GAMEOPTION_TYPES
};

#define GAMEOPTION_QUICK_COMBAT_KEY		"GAMEOPTION_QUICK_COMBAT"
#define GAMEOPTION_QUICK_MOVEMENT_KEY	"GAMEOPTION_QUICK_MOVEMENT"
#define GAMEOPTION_NO_ESPIONAGE			"GAMEOPTION_NO_ESPIONAGE"
#define GAMEOPTION_NO_EXTENDED_PLAY		"GAMEOPTION_NO_EXTENDED_PLAY"
#define GAMEOPTION_SIMULTANEOUS_TURNS	"GAMEOPTION_SIMULTANEOUS_TURNS"
#define GAMEOPTION_DYNAMIC_TURNS		"GAMEOPTION_DYNAMIC_TURNS"
#define GAMEOPTION_PITBOSS				"GAMEOPTION_PITBOSS"
#define GAMEOPTION_NO_LEAGUES			"GAMEOPTION_NO_LEAGUES"

enum MultiplayerOptionTypes		
{
	NO_MPOPTION = -1,

	MPOPTION_SIMULTANEOUS_TURNS,
	MPOPTION_TAKEOVER_AI,
	MPOPTION_SHUFFLE_TEAMS,
	MPOPTION_ANONYMOUS,

	NUM_MPOPTION_TYPES
};

enum SpecialOptionTypes			
{
	NO_SPECIALOPTION = -1,

	SPECIALOPTION_REPORT_STATS,

	NUM_SPECIALOPTION_TYPES
};

enum PlayerOptionTypes			
{
	NO_PLAYEROPTION = -1,

	PLAYEROPTION_WAIT_END_TURN,
	PLAYEROPTION_SHOW_FRIENDLY_MOVES,
	PLAYEROPTION_SHOW_ENEMY_MOVES,
	PLAYEROPTION_QUICK_MOVES,
	PLAYEROPTION_START_AUTOMATED,
	PLAYEROPTION_SAFE_AUTOMATION,
	PLAYEROPTION_NO_UNIT_CYCLING,
	PLAYEROPTION_LEAVE_FORESTS,
	PLAYEROPTION_MODDER_1,
	PLAYEROPTION_MODDER_2,
	PLAYEROPTION_MODDER_3,

	NUM_PLAYEROPTION_TYPES,		// Do not add anymore sequential enums!

	PLAYEROPTION_WAIT_END_TURN_HASH		= 0xF1493CD2,
	PLAYEROPTION_SHOW_FRIENDLY_MOVES_HASH= 0xBF6E16AA,
	PLAYEROPTION_SHOW_ENEMY_MOVES_HASH	= 0xB14DF37D,
	PLAYEROPTION_QUICK_MOVES_HASH		= 0xA87F3A6F,
	PLAYEROPTION_START_AUTOMATED_HASH	= 0xA9139942,
	PLAYEROPTION_SAFE_AUTOMATION_HASH	= 0xEDD3FEB0,
	PLAYEROPTION_NO_UNIT_CYCLING_HASH	= 0x475DDB5B,
	PLAYEROPTION_LEAVE_FORESTS_HASH		= 0xB3EE37A2,
	PLAYEROPTION_MODDER_1_HASH			= 0xD4214447,
	PLAYEROPTION_MODDER_2_HASH			= 0x4D2815FD,
	PLAYEROPTION_MODDER_3_HASH			= 0x3A2F256B,

	PLAYEROPTION_QUICK_SELECTION_ADVANCE = 0xDFA69818
};

enum VictoryTypes					
{
	NO_VICTORY = -1,
};

enum SmallAwardTypes					
{
	NO_SMALLAWARD = -1,
};

enum FeatureTypes					
{
	NO_FEATURE = -1,

	FEATURE_ICE,
	FEATURE_JUNGLE,
	FEATURE_MARSH,
	FEATURE_OASIS,
	FEATURE_FLOOD_PLAINS,
	FEATURE_FOREST,
	FEATURE_FALLOUT,
	FEATURE_NATURAL_WONDER,

	NUM_FEATURE_TYPES
};

enum ResourceTypes						
{
	NO_RESOURCE = -1,
};

enum ResourceClassTypes			
{
	NO_RESOURCECLASS = -1,
};

enum ResourceUsageTypes
{
	RESOURCEUSAGE_BONUS,
	RESOURCEUSAGE_STRATEGIC,
	RESOURCEUSAGE_LUXURY,

	NUM_RESOURCEUSAGE_TYPES
};

enum ImprovementTypes			
{
	NO_IMPROVEMENT = -1,
};

enum ImprovementUsageTypes
{
    IMPROVEMENTUSAGE_BASIC,
    IMPROVEMENTUSAGE_LANDMARK,

    NUM_IMPROVEMENTUSAGE_TYPES
};

enum RouteTypes						
{
	NO_ROUTE = -1,

	ROUTE_ROAD,
	ROUTE_RAILROAD,

	NUM_ROUTE_TYPES
};

enum GoodyTypes						
{
	NO_GOODY = -1,
};

enum BuildTypes						
{
	NO_BUILD = -1,
};

enum HandicapTypes				
{
	NO_HANDICAP = -1,
};

enum GameSpeedTypes				
{
	NO_GAMESPEED = -1,
};

enum TurnTimerTypes				
{
	NO_TURNTIMER = -1,
};

enum EraTypes							
{
	NO_ERA = -1,
};

enum CivilizationTypes		
{
	NO_CIVILIZATION = -1,
};

enum MinorCivTypes
{
	NO_MINORCIV = -1,
};

enum LeaderHeadTypes			
{
	NO_LEADER = -1,
};

// Used for managing Art Differences based on nationality
enum ArtStyleTypes				
{
	NO_ARTSTYLE = -1,
};

enum CitySizeTypes				
{
	NO_CITYSIZE = -1,

	CITYSIZE_SMALL,
	CITYSIZE_MEDIUM,
	CITYSIZE_LARGE,

	NUM_CITYSIZE_TYPES
};

enum FootstepAudioTypes		
{
	NO_FOOTSTEPAUDIO = -1,
};

enum FootstepAudioTags		
{
	NO_FOOTSTEPAUDIO_TAG = -1,
};

enum ChatTargetTypes			
{
	NO_CHATTARGET = -1,
	CHATTARGET_ALL = -2,
	CHATTARGET_TEAM = -3,
	CHATTARGET_PLAYER = -4,
};

enum TeamTypes					
{
	NO_TEAM = -1,
};

enum PlayerTypes				
{
	NO_PLAYER = -1,
};

enum TraitTypes					
{
	NO_TRAIT = -1,
};

enum ReligionTypes					
{
	NO_RELIGION = -1,
	RELIGION_PANTHEON = 0,
};

enum BeliefTypes					
{
	NO_BELIEF = -1,
};

enum LeagueTypes
{
	NO_LEAGUE = -1,
};

enum LeagueSpecialSessionTypes
{
	NO_LEAGUE_SPECIAL_SESSION = -1,
};

enum LeagueNameTypes
{
	NO_LEAGUE_NAME = -1,
};

enum LeagueProjectTypes
{
	NO_LEAGUE_PROJECT = -1,
};

enum LeagueProjectRewardTypes
{
	NO_LEAGUE_PROJECT_REWARD = -1,
};

enum ResolutionTypes
{
	NO_RESOLUTION = -1,
};

enum ResolutionDecisionTypes
{
	RESOLUTION_DECISION_NONE,
	RESOLUTION_DECISION_YES_OR_NO,
	RESOLUTION_DECISION_ANY_MEMBER,
	RESOLUTION_DECISION_CITY,
	RESOLUTION_DECISION_ANY_LUXURY_RESOURCE,
	RESOLUTION_DECISION_REPEAL,
	RESOLUTION_DECISION_MAJOR_CIV_MEMBER,
	RESOLUTION_DECISION_OTHER_MAJOR_CIV_MEMBER,
	RESOLUTION_DECISION_RELIGION,
	RESOLUTION_DECISION_IDEOLOGY,

	NUM_RESOLUTION_DECISIONS
};

enum ArchaeologyChoiceType
{
	NO_ARCHAEOLOGY_CHOICE = -1,
	ARCHAEOLOGY_DO_NOTHING,
	ARCHAEOLOGY_LANDMARK,
	ARCHAEOLOGY_ARTIFACT_PLAYER1,
	ARCHAEOLOGY_ARTIFACT_PLAYER2,
	ARCHAEOLOGY_CULTURE_BOOST,
	ARCHAEOLOGY_ARTIFACT_WRITING,
};

enum OrderTypes					
{
	NO_ORDER = -1,

	ORDER_TRAIN,
	ORDER_CONSTRUCT,
	ORDER_CREATE,
	ORDER_PREPARE,
	ORDER_MAINTAIN,

	NUM_ORDER_TYPES
};

enum TaskTypes				
{
	TASK_RAZE,
	TASK_UNRAZE,
	TASK_DISBAND,
	TASK_GIFT,
	TASK_SET_AUTOMATED_CITIZENS,
	TASK_SET_AUTOMATED_PRODUCTION,
	TASK_SET_EMPHASIZE,
	TASK_NO_AUTO_ASSIGN_SPECIALISTS,
	TASK_ADD_SPECIALIST,
	TASK_REMOVE_SPECIALIST,
	TASK_CHANGE_WORKING_PLOT,
	TASK_REMOVE_SLACKER,
	TASK_CLEAR_WORKING_OVERRIDE,
	TASK_HURRY,
	TASK_CONSCRIPT,
	TASK_CLEAR_ORDERS,
	TASK_RALLY_PLOT,
	TASK_CLEAR_RALLY_PLOT,
	TASK_RANGED_ATTACK,
	TASK_CREATE_PUPPET,
	TASK_ANNEX_PUPPET,

	NUM_TASK_TYPES
};

// Results from requesting a city task
enum CityTaskResult
{
	TASK_ABORTED	= 0,			// The task operation was aborted
	TASK_COMPLETED	= 1,			// The task operation is complete
	TASK_QUEUED		= 2				// The task operation cannot be done immediately and is queued
};

enum BuildingClassTypes				 
{
	NO_BUILDINGCLASS = -1,
};

enum BuildingTypes						
{
	NO_BUILDING = -1,
};

enum ProjectTypes				
{
	NO_PROJECT = -1,
};

enum ProcessTypes				
{
	NO_PROCESS = -1,
};

enum VoteTypes					
{
	NO_VOTE = -1,
};

enum PlayerVoteTypes			
{
	PLAYER_VOTE_NEVER = -5,
	PLAYER_VOTE_ABSTAIN = -4,
	PLAYER_VOTE_NO = -3,
	PLAYER_VOTE_YES = -2,
	NO_PLAYER_VOTE = -1
};

enum CalendarTypes			
{
	NO_CALENDAR = -1, 

	CALENDAR_DEFAULT,
	CALENDAR_BI_YEARLY,
	CALENDAR_YEARS,
	CALENDAR_TURNS,
	CALENDAR_SEASONS,
	CALENDAR_MONTHS,
	CALENDAR_WEEKS,
};

enum DomainTypes			
{
	NO_DOMAIN = -1,

	DOMAIN_SEA,
	DOMAIN_AIR,
	DOMAIN_LAND,
	DOMAIN_IMMOBILE,
	DOMAIN_HOVER,

	NUM_DOMAIN_TYPES
};

enum UnitClassTypes		
{
	NO_UNITCLASS = -1,
};

enum UnitTypes				
{
	NO_UNIT = -1,
};

enum SpecialUnitTypes	
{
	NO_SPECIALUNIT = -1,
};

enum UnitCombatTypes	
{
	NO_UNITCOMBAT = -1,
};

enum UnitAITypes			
{
	NO_UNITAI = -1,

	UNITAI_UNKNOWN,					// we don't know what to do with these units
	UNITAI_SETTLE,					// these are Settlers
	UNITAI_WORKER,					// these are Builders
	UNITAI_ATTACK,					// use these to attack other units
	UNITAI_CITY_BOMBARD,			// use these to attack cities
	UNITAI_FAST_ATTACK,				// use these to pillage enemy improvements and attack barbarians
	UNITAI_DEFENSE,					// these are units that are mainly in the floating defense force
	UNITAI_COUNTER,					// these are counter-units to specific other units - these will likely need more logic in building and using
	UNITAI_RANGED,					// units with ranged attacks
	UNITAI_CITY_SPECIAL,			// more AA???
	UNITAI_EXPLORE,					// scouts, etc.
	UNITAI_ARTIST,					// great person
	UNITAI_SCIENTIST,				// great person
	UNITAI_GENERAL,					// great person
	UNITAI_MERCHANT,				// great person
	UNITAI_ENGINEER,				// great person
	UNITAI_ICBM,					// nuke
	UNITAI_WORKER_SEA,				// work boats
	UNITAI_ATTACK_SEA,				// naval melee units
	UNITAI_RESERVE_SEA,				// naval units used defensively
	UNITAI_ESCORT_SEA,				// naval units tasked to defend embarked units
	UNITAI_EXPLORE_SEA,				// naval units used for scouting
	UNITAI_ASSAULT_SEA,				// naval ranged units
	UNITAI_SETTLER_SEA,				// UNUSED in Civ 5
	UNITAI_CARRIER_SEA,				// aircraft carrier
	UNITAI_MISSILE_CARRIER_SEA,		// missile carrier
	UNITAI_PIRATE_SEA,				// avast, ye
	UNITAI_ATTACK_AIR,				// bombers
	UNITAI_DEFENSE_AIR,				// fighters
	UNITAI_CARRIER_AIR,				// planes on boats
	UNITAI_MISSILE_AIR,				// cruise missiles
	UNITAI_PARADROP,				// paratrooper
	UNITAI_SPACESHIP_PART,			// spaceship part that needs to be taken to capital
	UNITAI_TREASURE,				// treasure to return to your capital
	UNITAI_PROPHET,					// great person
	UNITAI_MISSIONARY,				// missionary
	UNITAI_INQUISITOR,				// inquisitor
	UNITAI_ADMIRAL,					// admiral
	UNITAI_TRADE_UNIT,				// international trade unit
	UNITAI_ARCHAEOLOGIST,			// archaeologist
	UNITAI_WRITER,					// great person
	UNITAI_MUSICIAN,				// great person

	NUM_UNITAI_TYPES
};

enum InvisibleTypes			
{
	NO_INVISIBLE = -1,
};

enum VoteSourceTypes			
{
	NO_VOTESOURCE = -1,
};

enum ActivityTypes			
{
	NO_ACTIVITY = -1,

	ACTIVITY_AWAKE,
	ACTIVITY_HOLD,
	ACTIVITY_SLEEP,
	ACTIVITY_HEAL,
	ACTIVITY_SENTRY,
	ACTIVITY_INTERCEPT,
	ACTIVITY_MISSION,

	NUM_ACTIVITY_TYPES
};

enum AutomateTypes
{
	NO_AUTOMATE = -1,

	AUTOMATE_BUILD		= 0,
	AUTOMATE_EXPLORE	= 1,

	// Do not add any more sequential enums, add explicit key values (hash of text key)

	AUTOMATE_TRADE		= 0x4bdc68d8,	// FString::Hash("AUTOMATE_TRADE");

};

// any additions need to be reflected in GlobalTypes.xml
enum MissionTypes				
{
	NO_MISSION = -1,
};

enum MissionAITypes		
{
	NO_MISSIONAI = -1,

	MISSIONAI_SHADOW,
	MISSIONAI_GROUP,
	MISSIONAI_LOAD_ASSAULT,
	MISSIONAI_LOAD_SETTLER,
	MISSIONAI_LOAD_SPECIAL,
	MISSIONAI_GUARD_CITY,
	MISSIONAI_GUARD_RESOURCE,
	MISSIONAI_GUARD_TRADE_NET,
	MISSIONAI_GUARD_SPY,
	MISSIONAI_ATTACK_SPY,
	MISSIONAI_SPREAD,
	MISSIONAI_CONSTRUCT,
	MISSIONAI_HURRY,
	MISSIONAI_GREAT_WORK,
	MISSIONAI_EXPLORE,
	MISSIONAI_BLOCKADE,
	MISSIONAI_PILLAGE,
	MISSIONAI_FOUND,
	MISSIONAI_BUILD,
	MISSIONAI_ASSAULT,
	MISSIONAI_CARRIER,
	MISSIONAI_PICKUP,

	NUM_MISSIONAI_TYPES
};

// any additions need to be reflected in GlobalTypes.xml
enum CommandTypes					
{
	NO_COMMAND = -1,

	COMMAND_PROMOTION,
	COMMAND_UPGRADE,
	COMMAND_AUTOMATE,
	COMMAND_WAKE,
	COMMAND_CANCEL,
	COMMAND_CANCEL_ALL,
	COMMAND_STOP_AUTOMATION,
	COMMAND_DELETE,
	COMMAND_GIFT,
	COMMAND_HOTKEY,

	NUM_COMMAND_TYPES
};

enum ControlTypes					
{
	NO_CONTROL = -1,

	CONTROL_CENTERONSELECTION,
	CONTROL_SELECTYUNITTYPE,
	CONTROL_SELECTYUNITALL,
	CONTROL_SELECTCITY,
	CONTROL_SELECTCAPITAL,
	CONTROL_NEXTCITY,
	CONTROL_PREVCITY,
	CONTROL_NEXTUNIT,
	CONTROL_PREVUNIT,
	CONTROL_CYCLEUNIT,
	CONTROL_CYCLEUNIT_ALT,
	CONTROL_CYCLEWORKER,
	CONTROL_LASTUNIT,
	CONTROL_ENDTURN,
	CONTROL_ENDTURN_ALT,
	CONTROL_FORCEENDTURN,
	CONTROL_AUTOMOVES,
	CONTROL_PING,
	CONTROL_YIELDS,
	CONTROL_RESOURCE_ALL,
	CONTROL_UNIT_ICONS,
	CONTROL_SCORES,
	CONTROL_LOAD_GAME,
	CONTROL_OPTIONS_SCREEN,
	CONTROL_RETIRE,
	CONTROL_SAVE_GROUP,
	CONTROL_SAVE_NORMAL,
	CONTROL_QUICK_SAVE,
	CONTROL_QUICK_LOAD,
	CONTROL_CIVILOPEDIA,
	CONTROL_POLICIES_SCREEN,
	CONTROL_FOREIGN_SCREEN,
	CONTROL_MILITARY_SCREEN,
	CONTROL_TECH_CHOOSER,
	CONTROL_TURN_LOG,
	CONTROL_DOMESTIC_SCREEN,
	CONTROL_VICTORY_SCREEN,
	CONTROL_INFO,
	CONTROL_SELECT_HEALTHY,
	CONTROL_TOGGLE_STRATEGIC_VIEW,
	CONTROL_ADVISOR_COUNSEL,
	CONTROL_ESPIONAGE_OVERVIEW,
	CONTROL_RELIGION_OVERVIEW,
	CONTROL_RESTART_GAME,

	NUM_CONTROL_TYPES
};

enum PromotionTypes				
{
	NO_PROMOTION = -1,
};

enum TechTypes						
{
	NO_TECH = -1,
};

enum SpecialistTypes			
{
	NO_SPECIALIST = -1,
};

enum HurryTypes						
{
	NO_HURRY = -1,
};

enum CultureLevelTypes		
{
	NO_CULTURELEVEL = -1,
};

enum CultureTypes
{
	NULL_CULTURE = -1, 

	CULTURE_AMERICA,
	CULTURE_ASIA,
	CULTURE_AFRICA,
	CULTURE_EUROPE,
	CULTURE_MED,
	CULTURE_POLY,

	CULTURE_NONE,

	CULTURE_MAX,
};

enum PolicyTypes						
{
	NO_POLICY = -1,
};

enum PolicyBranchTypes
{
	NO_POLICY_BRANCH_TYPE = -1,
};

enum FogOfWarModeTypes		
{
	FOGOFWARMODE_OFF,
	FOGOFWARMODE_UNEXPLORED,
	FOGOFWARMODE_NOVIS,

	NUM_FOGOFWARMODE_TYPES
};

enum EntityEventTypes		
{
	ENTITY_EVENT_NONE = -1,			//!< Invalid event
};

enum AnimationPathTypes	
{
	ANIMATIONPATH_NONE = -1,

	// Default animation paths
	ANIMATIONPATH_IDLE,
	ANIMATIONPATH_MOVE,
	ANIMATIONPATH_DAMAGE,				//!< Updates the damage state for the unit

	// Combat related animation paths
	ANIMATIONPATH_RANDOMIZE_ANIMATION_SET,
	ANIMATIONPATH_NUKE_STRIKE,
	ANIMATIONPATH_MELEE_STRIKE,
	ANIMATIONPATH_MELEE_HURT,
	ANIMATIONPATH_MELEE_DIE,
	ANIMATIONPATH_MELEE_FORTIFIED,
	ANIMATIONPATH_MELEE_DIE_FADE,		//!< Used only in combat. The collateral damage die should have a fade integrated.
	ANIMATIONPATH_MELEE_FLEE,			//!< Used only by settler children, so they don't die in combat

	// Ranged combat related animation paths
	ANIMATIONPATH_RANGED_STRIKE,
	ANIMATIONPATH_RANGED_DIE,
	ANIMATIONPATH_RANGED_FORTIFIED,
	ANIMATIONPATH_RANGED_RUNHIT,
	ANIMATIONPATH_RANGED_RUNDIE,
	ANIMATIONPATH_RANGED_DIE_FADE,		//!< Used only in combat. The collateral damage die should have a fade integrated.
	ANIMATIONPATH_LEADER_COMMAND,

	// Air Units animation paths
	ANIMATIONPATH_AIRFADEIN,
	ANIMATIONPATH_AIRFADEOUT,
	ANIMATIONPATH_AIRSTRIKE,
	ANIMATIONPATH_AIRBOMB,

	//mission related animation paths
	ANIMATIONPATH_HEAL,
	ANIMATIONPATH_SLEEP,
	ANIMATIONPATH_FORTIFY,
	ANIMATIONPATH_MELEE_FORTIFY,
	ANIMATIONPATH_PILLAGE,
	ANIMATIONPATH_SENTRY,
	ANIMATIONPATH_FOUND,
	ANIMATIONPATH_IRRIGATE,
	ANIMATIONPATH_BUILD,
	ANIMATIONPATH_MINE,
	ANIMATIONPATH_CHOP,
	ANIMATIONPATH_SHOVEL,
	ANIMATIONPATH_RAILROAD,
	ANIMATIONPATH_GREAT_EVENT,
	ANIMATIONPATH_SURRENDER,
	ANIMATIONPATH_AIRPATROL,
};

enum WonderCommandType 
{
	WONDER_NO_OP,
	WONDER_CREATED,
	WONDER_EDITED,
	WONDER_REMOVED,
};

enum CursorTypes							
{
	NO_CURSOR = -1,
};

enum DiploCommentTypes				 
{
	NO_DIPLOCOMMENT = -1
};

enum NetContactTypes					 
{
	NO_NETCONTACT = -1,
	NETCONTACT_INITIAL,
	NETCONTACT_RESPONSE,
	NETCONTACT_ESTABLISHED,
	NETCONTACT_BUSY,

	NUM_NETCONTACT_TYPES
};

enum SaveGameTypes			
{
	SAVEGAME_NONE = -1,

	SAVEGAME_AUTO,
	SAVEGAME_RECOVERY,
	SAVEGAME_QUICK,
	SAVEGAME_NORMAL,
	SAVEGAME_GROUP,
	SAVEGAME_DROP_QUIT,
	SAVEGAME_DROP_CONTINUE,
	SAVEGAME_PBEM,
	SAVEGAME_REPLAY,

	NUM_SAVEGAME_TYPES
};

// The mutually exclusive game types
enum GameTypes
{
	GAME_TYPE_NONE	 = -1,
	GAME_SINGLE_PLAYER,			// Single human on local machine
	GAME_NETWORK_MULTIPLAYER,	// Single human on local machine, other human players connected over LAN/Internet
	GAME_HOTSEAT_MULTIPLAYER,	// Multiple humans on local machine.
	GAME_EMAIL_MULTIPLAYER,		// Single human on local machine, other humans connected though email messages.
};

enum GameStartTypes
{
	GAME_NEW,					// The game was created from seed parameters
	GAME_LOADED,				// The game was loaded from a save
};

enum GameMapTypes
{
	GAME_USER_PARAMETERS,		// The game was created from user parameters
	GAME_SCENARIO,				// The game was created from a scenario definition
};


enum GameMode				
{
	NO_GAMEMODE = -1,

	GAMEMODE_NORMAL,
	GAMEMODE_PITBOSS,

	NUM_GAMEMODES
};

enum SlotClaim
{
	SLOTCLAIM_UNASSIGNED,
	SLOTCLAIM_RESERVED,			//Reserved status occurs during load game initialization 
													//and in the multiplayer staging room when the host indicates that a slot must be occupied by a human 
													//before the game can start. 
	SLOTCLAIM_ASSIGNED,

	NUM_SLOTCLAIMS
};

enum SlotStatus
{
	SS_OPEN,
	SS_COMPUTER,
	SS_CLOSED,
	SS_TAKEN,
	SS_OBSERVER,

	SS_MAX_SLOT_STATUS,
};

// Different types of load
enum LoadType										
{
	LOAD_NORMAL,
	LOAD_INIT,
	LOAD_SETUP,
	LOAD_GAMETYPE,
	LOAD_REPLAY,
	LOAD_NORMAL_AND_GAMETYPE,
};

enum CivLoginStates
{
	NO_CIV_LOGIN = -1,

	LOGIN_CIV_OK,
	LOGIN_CIV_BAD_PWD,
	LOGIN_CIV_TAKEN,
	LOGIN_CIV_HAS_ID,
};
   
/*------------------------------------------------------------------------------------
Enum:		EAudioTag
  Purpose:	To enumerate all of the tag strings loaded from the csv or xml files
------------------------------------------------------------------------------------*/
enum AudioTag							
{
	AUDIOTAG_NONE = -1,
	AUDIOTAG_SOUNDID,
	AUDIOTAG_CONTEXTID,
	AUDIOTAG_SOUNDTYPE,
	AUDIOTAG_2DSCRIPT,
	AUDIOTAG_3DSCRIPT,
	AUDIOTAG_SOUNDSCAPE,
	AUDIOTAG_POSITION,
	AUDIOTAG_SCRIPTTYPE,
	AUDIOTAG_LOADTYPE,
	AUDIOTAG_COUNT,
};

enum VersionTypes
{
	NO_VERSIONTYPE = -1,

	VERSIONTYPE_EXE,
	VERSIONTYPE_DLL,
	VERSIONTYPE_SHADERS,
	VERSIONTYPE_PYTHON,
	VERSIONTYPE_XML,
};

enum ReplayMessageTypes		
{
	NO_REPLAY_MESSAGE = -1,

	REPLAY_MESSAGE_MAJOR_EVENT,
	REPLAY_MESSAGE_CITY_FOUNDED,
	REPLAY_MESSAGE_PLOT_OWNER_CHANGE,
	REPLAY_MESSAGE_CITY_CAPTURED,
	REPLAY_MESSAGE_CITY_DESTROYED,
	REPLAY_MESSAGE_RELIGION_FOUNDED,
	REPLAY_MESSAGE_PANTHEON_FOUNDED,

	NUM_REPLAY_MESSAGE_TYPES
};

enum ActionSubTypes					
{
	NO_ACTIONSUBTYPE = -1,

	ACTIONSUBTYPE_INTERFACEMODE,
	ACTIONSUBTYPE_COMMAND,
	ACTIONSUBTYPE_BUILD,
	ACTIONSUBTYPE_PROMOTION,
	ACTIONSUBTYPE_SPECIALIST,
	ACTIONSUBTYPE_CONTROL,
	ACTIONSUBTYPE_AUTOMATE,
	ACTIONSUBTYPE_MISSION,

	NUM_ACTIONSUBTYPES
};

enum GameMessageTypes				
{
	GAMEMESSAGE_NETWORK_READY,
	GAMEMESSAGE_VERIFY_VERSION,
	GAMEMESSAGE_VERSION_NACK,
	GAMEMESSAGE_VERSION_WARNING,
	GAMEMESSAGE_GAME_TYPE,
	GAMEMESSAGE_ID_ASSIGNMENT,
	GAMEMESSAGE_FILE_INFO,
	GAMEMESSAGE_PICK_YOUR_CIV,
	GAMEMESSAGE_CIV_CHOICE,
	GAMEMESSAGE_CONFIRM_CIV_CLAIM, 
	GAMEMESSAGE_CLAIM_INFO,
	GAMEMESSAGE_CIV_CHOICE_ACK,
	GAMEMESSAGE_CIV_CHOICE_NACK,
	GAMEMESSAGE_CIV_CHOSEN,
	GAMEMESSAGE_INTERIM_NOTICE,
	GAMEMESSAGE_INIT_INFO,
	GAMEMESSAGE_MAPSCRIPT_CHECK,
	GAMEMESSAGE_MAPSCRIPT_ACK,
	GAMEMESSAGE_LOAD_GAME,
	GAMEMESSAGE_PLAYER_ID,
	GAMEMESSAGE_SLOT_REASSIGNMENT,
	GAMEMESSAGE_PLAYER_INFO,
	GAMEMESSAGE_GAME_INFO,
	GAMEMESSAGE_REASSIGN_PLAYER,
	GAMEMESSAGE_PITBOSS_INFO,
	GAMEMESSAGE_LAUNCHING_INFO,
	GAMEMESSAGE_INIT_GAME,
	GAMEMESSAGE_INIT_PLAYERS,
	GAMEMESSAGE_AUTH_REQUEST,
	GAMEMESSAGE_AUTH_RESPONSE,
	GAMEMESSAGE_SYNCH_START,
	GAMEMESSAGE_PLAYER_OPTION,
	GAMEMESSAGE_EXTENDED_GAME,
	GAMEMESSAGE_AUTO_MOVES,
	GAMEMESSAGE_TURN_COMPLETE,
	GAMEMESSAGE_PUSH_MISSION,
	GAMEMESSAGE_AUTO_MISSION,
	GAMEMESSAGE_DO_COMMAND,
	GAMEMESSAGE_PUSH_ORDER,
	GAMEMESSAGE_POP_ORDER,
	GAMEMESSAGE_PURCHASE,
	GAMEMESSAGE_DO_TASK,
	GAMEMESSAGE_RESEARCH,
	GAMEMESSAGE_CONVERT,
	GAMEMESSAGE_CHAT,
	GAMEMESSAGE_PING,
	GAMEMESSAGE_SIGN,
	GAMEMESSAGE_LINE_ENTITY,
	GAMEMESSAGE_SIGN_DELETE,
	GAMEMESSAGE_LINE_ENTITY_DELETE,
	GAMEMESSAGE_LINE_GROUP_DELETE,
	GAMEMESSAGE_PAUSE,
	GAMEMESSAGE_MP_KICK,
	GAMEMESSAGE_MP_RETIRE,
	GAMEMESSAGE_CLOSE_CONNECTION,
	GAMEMESSAGE_NEVER_JOINED,
	GAMEMESSAGE_MP_DROP_INIT,
	GAMEMESSAGE_MP_DROP_VOTE,
	GAMEMESSAGE_MP_DROP_UPDATE,
	GAMEMESSAGE_MP_DROP_RESULT,
	GAMEMESSAGE_MP_DROP_SAVE,
	GAMEMESSAGE_TOGGLE_TRADE,
	GAMEMESSAGE_IMPLEMENT_OFFER,
	GAMEMESSAGE_CHANGE_WAR,
	GAMEMESSAGE_IGNORE_WARNING,
	GAMEMESSAGE_PLEDGE_MINOR_PROTECTION,
	GAMEMESSAGE_MINOR_NO_UNIT_SPAWNING,
	GAMEMESSAGE_LIBERATE_PLAYER,
	GAMEMESSAGE_CHOOSE_ELECTION,
	GAMEMESSAGE_DIPLO_VOTE,
	GAMEMESSAGE_APPLY_EVENT,
	GAMEMESSAGE_CONTACT_CIV,
	GAMEMESSAGE_DIPLO_CHAT,
	GAMEMESSAGE_SEND_OFFER,
	GAMEMESSAGE_RENEGOTIATE,
	GAMEMESSAGE_RENEGOTIATE_ITEM,
	GAMEMESSAGE_EXIT_TRADE,
	GAMEMESSAGE_KILL_DEAL,
	GAMEMESSAGE_UPDATE_POLICIES,
	GAMEMESSAGE_CLEAR_TABLE,
	GAMEMESSAGE_POPUP_PROCESSED,
	GAMEMESSAGE_DIPLOMACY_FROM_UI,
	GAMEMESSAGE_HOT_DROP_NOTICE,
	GAMEMESSAGE_POPUP,
	GAMEMESSAGE_EVENT_TRIGGERED,
	GAMEMESSAGE_LAUNCH_SPACESHIP,
	GAMEMESSAGE_ADVANCED_START_ACTION,
	GAMEMESSAGE_MINOR_CIV_QUEST_NO_INTEREST,
	GAMEMESSAGE_MINOR_CIV_QUEST_COMPLETED,
	GAMEMESSAGE_MINOR_CIV_INTRUSION,
	GAMEMESSAGE_MINOR_CIV_ENTER_TERRITORY,
	GAMEMESSAGE_BARBARIAN_RANSOM,
	GAMEMESSAGE_GIFT_UNIT,
	GAMEMESSAGE_RETURN_CIVILIAN,
	GAMEMESSAGE_UPDATE_CITY_CITIZENS,
	GAMEMESSAGE_SELL_BUILDING,
	GAMEMESSAGE_PLAYER_HURRY,
	GAMEMESSAGE_MOD_NET_MESSAGE,
	GAMEMESSAGE_SWAP_UNITS,
	GAMEMESSAGE_CITY_BUY_PLOT,
	GAMEMESSAGE_MINOR_CIV_GIFT_GOLD,
	GAMEMESSAGE_MINOR_CIV_GIFT_TILE_IMPROVEMENT,
	GAMEMESSAGE_MINOR_CIV_BULLY_GOLD,
	GAMEMESSAGE_MINOR_CIV_BULLY_UNIT,
	GAMEMESSAGE_MINOR_CIV_BUYOUT,
	GAMEMESSAGE_GREAT_PERSON_CHOICE,
	GAMEMESSAGE_SET_CITY_AI_FOCUS,
	GAMEMESSAGE_CITY_SYNC_CHECK,
	GAMEMESSAGE_UNIT_SYNC_CHECK,
	GAMEMESSAGE_PLOT_SYNC_CHECK,
	GAMEMESSAGE_PLAYER_SYNC_CHECK,
	GAMEMESSAGE_RANDOM_NUMBER_GENERATOR_SYNC_CHECK,
	GAMEMESSAGE_LOOP_BARRIER,
	GAMEMESSAGE_LOOP_BARRIER_COMPLETE,
	GAMEMESSAGE_PLAYER_READY,
	GAMEMESSAGE_TURN_SLICE,
	GAMEMESSAGE_TURN_SLICE_ADJUST,
	GAMEMESSAGE_ACCEPT_DEAL,
	GAMEMESSAGE_ACCEPT_DEMAND,
	GAMEMESSAGE_PLAYER_FINALIZED_DEAL,
	GAMEMESSAGE_PLAYER_PROPOSE_DEAL,
	GAMEMESSAGE_FORCE_RESYNC,
	GAMEMESSAGE_FLUSH_MESSAGES,
	GAMEMESSAGE_FLUSH_MESSAGES_REPLY,
	GAMEMESSAGE_SWAP_ORDER,
	GAMEMESSAGE_CHANGE_PLAYER_ID,
	GAMEMESSAGE_START_LAUNCH,
	GAMEMESSAGE_AVOID_GROWTH,
	GAMEMESSAGE_GAME_DO_TURN_PROCESSED,
	GAMEMESSAGE_DESTROY_UNIT,
	GAMEMESSAGE_HOTJOIN_START,
	GAMEMESSAGE_HOTJOIN_COMPLETED,
	GAMEMESSAGE_GAME_PLAYER_INITIAL_AI_PROCESSED,
	GAMEMESSAGE_RENAME_CITY,
	GAMEMESSAGE_RENAME_UNIT,
	GAMEMESSAGE_TURN_ALL_COMPLETE,
	GAMEMESSAGE_TURN_UNREADY,
	GAMEMESSAGE_FOUND_PANTHEON,
	GAMEMESSAGE_FOUND_RELIGION,
	GAMEMESSAGE_ENHANCE_RELIGION,
	GAMEMESSAGE_MOVE_SPY,
	GAMEMESSAGE_MAYA_BONUS,
	GAMEMESSAGE_FAITH_GREAT_PERSON,
	GAMEMESSAGE_STAGE_COUP,
	GAMEMESSAGE_FAITH_PURCHASE,
	GAMEMESSAGE_LEAGUE_PROPOSE_ENACT,
	GAMEMESSAGE_LEAGUE_PROPOSE_REPEAL,
	GAMEMESSAGE_ARCHAEOLOGY,
	GAMEMESSAGE_LEAGUE_VOTE_ENACT,
	GAMEMESSAGE_LEAGUE_VOTE_REPEAL,
	GAMEMESSAGE_GAME_OPTIONS,
	GAMEMESSAGE_IDEOLOGY,
	GAMEMESSAGE_GOODY_CHOICE,
	GAMEMESSAGE_LEAGUE_EDIT_NAME,
	GAMEMESSAGE_INITIAL_INFO_COMPLETE,
	GAMEMESSAGE_PLAYER_REGISTER_COMPLETE,
	GAMEMESSAGE_SET_SWAPPABLE_GREAT_WORK,
	GAMEMESSAGE_SWAP_GREAT_WORKS,
	GAMEMESSAGE_MOVE_GREAT_WORKS,
	GAMEMESSAGE_CHANGE_IDEOLOGY,
	GAMEMESSAGE_TURN_TIMER_SYNC,
	GAMEMESSAGE_LEAGUE_VOTE_ABSTAIN,
	GAMEMESSAGE_SET_PLAYER_DESIRED_SLOT,
};

enum AdvancedStartActionTypes				
{
	NO_ADVANCEDSTARTACTION = -1,

	ADVANCEDSTARTACTION_EXIT,
	ADVANCEDSTARTACTION_UNIT,
	ADVANCEDSTARTACTION_CITY,
	ADVANCEDSTARTACTION_POP,
	ADVANCEDSTARTACTION_CULTURE,
	ADVANCEDSTARTACTION_BUILDING,
	ADVANCEDSTARTACTION_IMPROVEMENT,
	ADVANCEDSTARTACTION_ROUTE,
	ADVANCEDSTARTACTION_TECH,
	ADVANCEDSTARTACTION_VISIBILITY,
	ADVANCEDSTARTACTION_AUTOMATE,

	NUM_ADVANCEDSTARTACTIONS
};

enum BandwidthType
{
	BANDWIDTH_MODEM,
	BANDWIDTH_BROADBAND,

	NO_BANDWIDTH
};

// Make sure that this is in synch with both CIV5MultiunitFormationTypeInfo.xml and CIV5MultiunitFormationInfo.xml
enum MultiunitFormationTypes	
{
	NO_MUFORMATION = -1,

	MUFORMATION_BASIC_CITY_ATTACK_FORCE,
	MUFORMATION_CITY_STATE_ATTACK_FORCE,
	MUFORMATION_FAST_PILLAGERS,
	MUFORMATION_ANTI_BARBARIAN_TEAM,
	MUFORMATION_RAPID_RESPONSE_FORCE,
	MUFORMATION_CLOSE_CITY_DEFENSE,
	MUFORMATION_SETTLER_ESCORT,
	MUFORMATION_SMALL_CITY_ATTACK_FORCE,
	MUFORMATION_MERCHANT_ESCORT,
	MUFORMATION_NAVAL_SQUADRON,
	MUFORMATION_COLONIZATION_PARTY,
	MUFORMATION_QUICK_COLONY_SETTLER,
	MUFORMATION_NAVAL_INVASION,
	MUFORMATION_CITY_STATE_INVASION,
	MUFORMATION_NUKE_ATTACK,
	MUFORMATION_EARLY_RUSH,
	MUFORMATION_NAVAL_BOMBARDMENT,
	MUFORMATION_PURE_NAVAL_CITY_ATTACK,
	MUFORMATION_BIGGER_CITY_ATTACK_FORCE,
	MUFORMATION_CONCERT_TOUR,

	NUM_MULTIUNITFORMATIONS
};

enum MultiunitPositionTypes
{
	NO_MUPOSITION = -1,
};

enum EconomicAIStrategyTypes
{
	NO_ECONOMICAISTRATEGY = -1,
};

enum CitySpecializationTypes
{
	NO_CITY_SPECIALIZATION = -1,
};

enum MilitaryAIStrategyTypes
{
	NO_MILITARYAISTRATEGY = -1,
};

enum AIStrategyTypes						
{
	NO_AISTRATEGY = -1,
};

enum AIGrandStrategyTypes						
{
	NO_AIGRANDSTRATEGY = -1,
};

enum AICityStrategyTypes						
{
	NO_AICITYSTRATEGY = -1,
};

enum TacticalMoveZoneType
{
	AI_TACTICAL_MOVE_ZONE_FRIENDLY_WINNING,
	AI_TACTICAL_MOVE_ZONE_FRIENDLY_EVEN,
	AI_TACTICAL_MOVE_ZONE_FRIENDLY_LOSING,
	AI_TACTICAL_MOVE_ZONE_ENEMY_WINNING,
	AI_TACTICAL_MOVE_ZONE_ENEMY_EVEN,
	AI_TACTICAL_MOVE_ZONE_ENEMY_LOSING,
	AI_TACTICAL_MOVE_ZONE_UNOWNED,

	NUM_AI_TACTICAL_MOVE_ZONES
};

enum TacticalAIMoveTypes					
{
	NO_TACTICAL_MOVE = -1,

	// Types are now loaded from TacticalMoves XML file
};

enum AIBarbarianTacticalMove
{
	AI_TACTICAL_BARBARIAN_CAPTURE_CITY,
	AI_TACTICAL_BARBARIAN_DAMAGE_CITY,
	AI_TACTICAL_BARBARIAN_DESTROY_HIGH_PRIORITY_UNIT,
	AI_TACTICAL_BARBARIAN_DESTROY_MEDIUM_PRIORITY_UNIT,
	AI_TACTICAL_BARBARIAN_DESTROY_LOW_PRIORITY_UNIT,
	AI_TACTICAL_BARBARIAN_MOVE_TO_SAFETY,
	AI_TACTICAL_BARBARIAN_ATTRIT_HIGH_PRIORITY_UNIT,
	AI_TACTICAL_BARBARIAN_ATTRIT_MEDIUM_PRIORITY_UNIT,
	AI_TACTICAL_BARBARIAN_ATTRIT_LOW_PRIORITY_UNIT,
	AI_TACTICAL_BARBARIAN_PILLAGE,
	AI_TACTICAL_BARBARIAN_PRIORITY_BLOCKADE_RESOURCE,
	AI_TACTICAL_BARBARIAN_CIVILIAN_ATTACK,
	AI_TACTICAL_BARBARIAN_AGGRESSIVE_MOVE,
	AI_TACTICAL_BARBARIAN_PASSIVE_MOVE,
	AI_TACTICAL_BARBARIAN_CAMP_DEFENSE,
	AI_TACTICAL_BARBARIAN_DESPERATE_ATTACK,
	AI_TACTICAL_BARBARIAN_ESCORT_CIVILIAN,
	AI_TACTICAL_BARBARIAN_PLUNDER_TRADE_UNIT,
	AI_TACTICAL_BARBARIAN_PILLAGE_CITADEL,
	AI_TACTICAL_BARBARIAN_PILLAGE_NEXT_TURN,
	NUM_AI_BARBARIAN_MOVES,
};

enum AIHomelandMove
{
	AI_HOMELAND_MOVE_NONE = -1,
	AI_HOMELAND_MOVE_UNASSIGNED,
	AI_HOMELAND_MOVE_EXPLORE,
	AI_HOMELAND_MOVE_EXPLORE_SEA,
	AI_HOMELAND_MOVE_SETTLE,
	AI_HOMELAND_MOVE_GARRISON,
	AI_HOMELAND_MOVE_HEAL,
	AI_HOMELAND_MOVE_TO_SAFETY,
	AI_HOMELAND_MOVE_MOBILE_RESERVE,
	AI_HOMELAND_MOVE_SENTRY,
	AI_HOMELAND_MOVE_WORKER,
	AI_HOMELAND_MOVE_WORKER_SEA,
	AI_HOMELAND_MOVE_PATROL,
	AI_HOMELAND_MOVE_UPGRADE,
	AI_HOMELAND_MOVE_ANCIENT_RUINS,
	AI_HOMELAND_MOVE_GARRISON_CITY_STATE,
	AI_HOMELAND_MOVE_WRITER,
	AI_HOMELAND_MOVE_ARTIST_GOLDEN_AGE,
	AI_HOMELAND_MOVE_MUSICIAN,
	AI_HOMELAND_MOVE_SCIENTIST_FREE_TECH,
	AI_HOMELAND_MOVE_MERCHANT_TRADE,
	AI_HOMELAND_MOVE_ENGINEER_HURRY,
	AI_HOMELAND_MOVE_GENERAL_GARRISON,
	AI_HOMELAND_MOVE_ADMIRAL_GARRISON,
	AI_HOMELAND_MOVE_SPACESHIP_PART,
	AI_HOMELAND_MOVE_AIRCRAFT_TO_THE_FRONT,
	AI_HOMELAND_MOVE_TREASURE,
	AI_HOMELAND_MOVE_PROPHET_RELIGION,
	AI_HOMELAND_MOVE_MISSIONARY,
	AI_HOMELAND_MOVE_INQUISITOR,
	AI_HOMELAND_MOVE_TRADE_UNIT,
	AI_HOMELAND_MOVE_ARCHAEOLOGIST,
	AI_HOMELAND_MOVE_ADD_SPACESHIP_PART,
	AI_HOMELAND_MOVE_AIRLIFT,
	NUM_AI_HOMELAND_MOVES,
};

enum PlayerProximityTypes
{
	NO_PLAYER_PROXIMITY = -1,

	// WARNING: the order of these values is very important, do not change unless you know what you're doing!
	PLAYER_PROXIMITY_DISTANT,
	PLAYER_PROXIMITY_FAR,
	PLAYER_PROXIMITY_CLOSE,
	PLAYER_PROXIMITY_NEIGHBORS,
	// WARNING: the order of these values is very important, do not change unless you know what you're doing!

	NUM_PLAYER_PROXIMITIES,
};

enum DOWType
{
	NO_DOW = -1,
	DOW_DIPLOMATIC,
	DOW_MOVE_INTO_TERRITORY,
	DOW_MOVE_ONTO_CITY,
	DOW_MOVE_ONTO_UNIT,
	DOW_PLUNDER_TRADE_UNIT,
};

enum DiploUIStateTypes
{
	NO_DIPLO_UI_STATE = -1,

	DIPLO_UI_STATE_DEFAULT_ROOT,
	DIPLO_UI_STATE_WAR_DECLARED_BY_HUMAN,
	DIPLO_UI_STATE_PEACE_MADE_BY_HUMAN,

	DIPLO_UI_STATE_TRADE,
	DIPLO_UI_STATE_TRADE_AI_MAKES_OFFER,
	DIPLO_UI_STATE_TRADE_AI_ACCEPTS_OFFER,
	DIPLO_UI_STATE_TRADE_AI_REJECTS_OFFER,
	DIPLO_UI_STATE_TRADE_AI_MAKES_DEMAND,
	DIPLO_UI_STATE_TRADE_AI_MAKES_REQUEST,
	DIPLO_UI_STATE_TRADE_HUMAN_OFFERS_CONCESSIONS,

	DIPLO_UI_STATE_HUMAN_DEMAND,

	DIPLO_UI_STATE_BLANK_DISCUSSION_RETURN_TO_ROOT,
	DIPLO_UI_STATE_BLANK_DISCUSSION,
	DIPLO_UI_STATE_BLANK_DISCUSSION_MEAN_HUMAN,
	DIPLO_UI_STATE_BLANK_DISCUSSION_MEAN_AI,
	DIPLO_UI_STATE_AI_DECLARED_WAR,

	DIPLO_UI_STATE_DISCUSS_HUMAN_INVOKED,

	DIPLO_UI_STATE_DISCUSS_AGGRESSIVE_MILITARY_WARNING,
	DIPLO_UI_STATE_DISCUSS_I_ATTACKED_YOUR_MINOR_CIV,
	DIPLO_UI_STATE_DISCUSS_I_BULLIED_YOUR_MINOR_CIV,
	DIPLO_UI_STATE_DISCUSS_YOU_ATTACKED_MINOR_CIV,
	DIPLO_UI_STATE_DISCUSS_YOU_KILLED_MINOR_CIV,
	DIPLO_UI_STATE_DISCUSS_YOU_BULLIED_MINOR_CIV,
	DIPLO_UI_STATE_DISCUSS_PROTECT_MINOR_CIV,
	DIPLO_UI_STATE_DISCUSS_YOU_EXPANSION_SERIOUS_WARNING,
	DIPLO_UI_STATE_DISCUSS_YOU_EXPANSION_WARNING,
	DIPLO_UI_STATE_DISCUSS_YOU_PLOT_BUYING_SERIOUS_WARNING,
	DIPLO_UI_STATE_DISCUSS_YOU_PLOT_BUYING_WARNING,

	DIPLO_UI_STATE_DISCUSS_WORK_WITH_US,
	DIPLO_UI_STATE_DISCUSS_WORK_AGAINST_SOMEONE,
	DIPLO_UI_STATE_DISCUSS_COOP_WAR,
	DIPLO_UI_STATE_DISCUSS_COOP_WAR_TIME,

	DIPLO_UI_STATE_DISCUSS_PLAN_RESEARCH_AGREEMENT,

	// Post Civ 5 release stuff
	DIPLO_UI_STATE_DISCUSS_AI_REQUEST_DENOUNCE,

	// Espionage
	DIPLO_UI_STATE_CAUGHT_YOUR_SPY,
	DIPLO_UI_STATE_KILLED_YOUR_SPY,
	DIPLO_UI_STATE_KILLED_MY_SPY,
	DIPLO_UI_STATE_CONFRONT_YOU_KILLED_MY_SPY,

	DIPLO_UI_STATE_STOP_CONVERSIONS,

	DIPLO_UI_STATE_STOP_DIGGING,

	NUM_DIPLO_UI_STATES,
};

enum FromUIDiploEventTypes
{
	NO_FROM_UI_DIPLO_EVENT = -1,

	FROM_UI_DIPLO_EVENT_HUMAN_DECLARES_WAR,
	FROM_UI_DIPLO_EVENT_HUMAN_NEGOTIATE_PEACE,

	FROM_UI_DIPLO_EVENT_HUMAN_WANTS_DISCUSSION,
	FROM_UI_DIPLO_EVENT_HUMAN_DISCUSSION_DONT_SETTLE,
	FROM_UI_DIPLO_EVENT_HUMAN_DISCUSSION_WORK_WITH_US,
	FROM_UI_DIPLO_EVENT_HUMAN_DISCUSSION_END_WORK_WITH_US,

	FROM_UI_DIPLO_EVENT_DEMAND_HUMAN_REFUSAL,
	FROM_UI_DIPLO_EVENT_REQUEST_HUMAN_REFUSAL,

	FROM_UI_DIPLO_EVENT_AGGRESSIVE_MILITARY_WARNING_RESPONSE,

	FROM_UI_DIPLO_EVENT_I_ATTACKED_YOUR_MINOR_CIV_RESPONSE,
	FROM_UI_DIPLO_EVENT_I_BULLIED_YOUR_MINOR_CIV_RESPONSE,

	FROM_UI_DIPLO_EVENT_ATTACKED_MINOR_RESPONSE,
	FROM_UI_DIPLO_EVENT_KILLED_MINOR_RESPONSE,
	FROM_UI_DIPLO_EVENT_BULLIED_MINOR_RESPONSE,

	FROM_UI_DIPLO_EVENT_EXPANSION_SERIOUS_WARNING_RESPONSE,
	FROM_UI_DIPLO_EVENT_EXPANSION_WARNING_RESPONSE,

	FROM_UI_DIPLO_EVENT_PLOT_BUYING_SERIOUS_WARNING_RESPONSE,
	FROM_UI_DIPLO_EVENT_PLOT_BUYING_WARNING_RESPONSE,

	FROM_UI_DIPLO_EVENT_WORK_WITH_US_RESPONSE,
	FROM_UI_DIPLO_EVENT_WORK_AGAINST_SOMEONE_RESPONSE,
	FROM_UI_DIPLO_EVENT_DENOUNCE,
	FROM_UI_DIPLO_EVENT_COOP_WAR_OFFER,
	FROM_UI_DIPLO_EVENT_COOP_WAR_RESPONSE,
	FROM_UI_DIPLO_EVENT_COOP_WAR_NOW_RESPONSE,

	FROM_UI_DIPLO_EVENT_HUMAN_DEMAND,

	FROM_UI_DIPLO_EVENT_PLAN_RA_RESPONSE,

	// Post Civ 5 release
	FROM_UI_DIPLO_EVENT_AI_REQUEST_DENOUNCE_RESPONSE,
	FROM_UI_DIPLO_EVENT_CAUGHT_YOUR_SPY_RESPONSE,
	FROM_UI_DIPLO_EVENT_KILLED_MY_SPY_RESPONSE, // We killed one of their spies and they're apologizing
	FROM_UI_DIPLO_EVENT_HUMAN_DISCUSSION_STOP_SPYING,
	FROM_UI_DIPLO_EVENT_HUMAN_DISCUSSION_SHARE_INTRIGUE,
	FROM_UI_DIPLO_EVENT_HUMAN_DISCUSSION_STOP_SPREADING_RELIGION,

	FROM_UI_DIPLO_EVENT_STOP_CONVERSIONS,

	FROM_UI_DIPLO_EVENT_HUMAN_DISCUSSION_STOP_DIGGING,
	FROM_UI_DIPLO_EVENT_STOP_DIGGING,

	NUM_FROM_UI_DIPLO_EVENTS,
};

enum LeaderheadAnimationTypes
{
	NO_LEADERHEAD_ANIM = -1,

    // The numeric values of these enums correspond to magic numbers embedded in the leaderhead assets
    // Changing them will lead to discord and confusion

    LEADERHEAD_ANIM_INTRO           =   1,    
    LEADERHEAD_ANIM_NEUTRAL_HELLO   =   2,    
    LEADERHEAD_ANIM_PEACEFUL        =   3,
    LEADERHEAD_ANIM_OPENING_GLOAT   =   4,  // gloats, then transitions to neutral
    LEADERHEAD_ANIM_DECLARE_WAR     =   5,
    LEADERHEAD_ANIM_ATTACKED        =   6,
    LEADERHEAD_ANIM_HATE_HELLO      =   7,
    LEADERHEAD_ANIM_DEFEATED        =   8,
    LEADERHEAD_ANIM_REQUEST         =   9,
    LEADERHEAD_ANIM_DEMAND          =   10,
    LEADERHEAD_ANIM_NEUTRAL_IDLE    =   11,
    LEADERHEAD_ANIM_HATE_IDLE       =   12,

    LEADERHEAD_ANIM_LETS_HEAR_IT     = 15,
    LEADERHEAD_ANIM_YES              = 16,
    LEADERHEAD_ANIM_NO               = 17,
    LEADERHEAD_ANIM_POSITIVE         = 30,
    LEADERHEAD_ANIM_NEGATIVE         = 31,

    LEADERHEAD_ANIM_HATE_POSITIVE = 40,
    LEADERHEAD_ANIM_HATE_NEGATIVE = 41
};

enum EndTurnBlockingTypes
{
	NO_ENDTURN_BLOCKING_TYPE = -1,

	ENDTURN_BLOCKING_POLICY,
	ENDTURN_BLOCKING_RESEARCH,
	ENDTURN_BLOCKING_PRODUCTION,
	ENDTURN_BLOCKING_UNITS,
	ENDTURN_BLOCKING_DIPLO_VOTE,
	ENDTURN_BLOCKING_MINOR_QUEST,
	ENDTURN_BLOCKING_FREE_TECH,
	ENDTURN_BLOCKING_STACKED_UNITS,
	ENDTURN_BLOCKING_UNIT_NEEDS_ORDERS,
	ENDTURN_BLOCKING_UNIT_PROMOTION,
	ENDTURN_BLOCKING_CITY_RANGE_ATTACK,
	ENDTURN_BLOCKING_FREE_POLICY,
	ENDTURN_BLOCKING_FREE_ITEMS,
	ENDTURN_BLOCKING_FOUND_PANTHEON,
	ENDTURN_BLOCKING_FOUND_RELIGION,
	ENDTURN_BLOCKING_ENHANCE_RELIGION,
	ENDTURN_BLOCKING_STEAL_TECH,
	ENDTURN_BLOCKING_MAYA_LONG_COUNT,
	ENDTURN_BLOCKING_FAITH_GREAT_PERSON,
	
	// XP2
	ENDTURN_BLOCKING_ADD_REFORMATION_BELIEF,
	ENDTURN_BLOCKING_LEAGUE_CALL_FOR_PROPOSALS,
	ENDTURN_BLOCKING_CHOOSE_ARCHAEOLOGY,
	ENDTURN_BLOCKING_LEAGUE_CALL_FOR_VOTES,
	ENDTURN_BLOCKING_CHOOSE_IDEOLOGY,

	NUM_ENDTURN_BLOCKING_TYPES
};

enum MinorCivTraitTypes
{
	NO_MINOR_CIV_TRAIT_TYPE = -1,

	MINOR_CIV_TRAIT_CULTURED,
	MINOR_CIV_TRAIT_MILITARISTIC,
	MINOR_CIV_TRAIT_MARITIME,
	MINOR_CIV_TRAIT_MERCANTILE,
	MINOR_CIV_TRAIT_RELIGIOUS,

	NUM_MINOR_CIV_TRAIT_TYPES
};

enum CityAIFocusTypes
{
	NO_CITY_AI_FOCUS_TYPE = -1,

	CITY_AI_FOCUS_TYPE_FOOD,
	CITY_AI_FOCUS_TYPE_PRODUCTION,
	CITY_AI_FOCUS_TYPE_GOLD,
	CITY_AI_FOCUS_TYPE_GREAT_PEOPLE,
	CITY_AI_FOCUS_TYPE_SCIENCE,
	CITY_AI_FOCUS_TYPE_CULTURE,
	CITY_AI_FOCUS_TYPE_PROD_GROWTH,
	CITY_AI_FOCUS_TYPE_GOLD_GROWTH,
	CITY_AI_FOCUS_TYPE_FAITH,

	NUM_CITY_AI_FOCUS_TYPES
};

enum EAchievement
{
	ACHIEVEMENT_WIN_WASHINGTON,
	ACHIEVEMENT_WIN_ELIZABETH,
	ACHIEVEMENT_WIN_NAPOLEON,
	ACHIEVEMENT_WIN_BISMARCK,
	ACHIEVEMENT_WIN_CATHERINE,
	ACHIEVEMENT_WIN_CAESAR,
	ACHIEVEMENT_WIN_ALEXANDER,
	ACHIEVEMENT_WIN_RAMESSES,
	ACHIEVEMENT_WIN_ASKIA,
	ACHIEVEMENT_WIN_HARUN,
	ACHIEVEMENT_WIN_DARIUS,
	ACHIEVEMENT_WIN_GANDHI,
	ACHIEVEMENT_WIN_RAMKHAMHAENG,
	ACHIEVEMENT_WIN_WU,
	ACHIEVEMENT_WIN_ODA,
	ACHIEVEMENT_WIN_HIAWATHA,
	ACHIEVEMENT_WIN_MONTEZUMA,
	ACHIEVEMENT_WIN_SULEIMAN,
	ACHIEVEMENT_WIN_ALLBASELEADERS,

	ACHIEVEMENT_DIFLEVEL_SETTLER,
	ACHIEVEMENT_DIFLEVEL_CHIEFTAIN,
	ACHIEVEMENT_DIFLEVEL_WARLORD,
	ACHIEVEMENT_DIFLEVEL_PRINCE,
	ACHIEVEMENT_DIFLEVEL_KING,
	ACHIEVEMENT_DIFLEVEL_EMPEROR,
	ACHIEVEMENT_DIFLEVEL_IMMORTAL,
	ACHIEVEMENT_DIFLEVEL_DEITY,

	ACHIEVEMENT_MAPSIZE_DUEL,
	ACHIEVEMENT_MAPSIZE_TINY,
	ACHIEVEMENT_MAPSIZE_SMALL,
	ACHIEVEMENT_MAPSIZE_STANDARD,
	ACHIEVEMENT_MAPSIZE_LARGE,
	ACHIEVEMENT_MAPSIZE_HUGE,

	ACHIEVEMENT_MAPTYPE_CONTINENTS,
	ACHIEVEMENT_MAPTYPE_PANGAEA,
	ACHIEVEMENT_MAPTYPE_ARCHIPELAGO,
	ACHIEVEMENT_MAPTYPE_EARTH,

	ACHIEVEMENT_MAPS_ALL,

	ACHIEVEMENT_WIN_MULTIPLAYER,
	ACHIEVEMENT_HUNDRED_WAR,
	ACHIEVEMENT_CATFIGHT,
	ACHIEVEMENT_MANIFEST_DESTINY,
	ACHIEVEMENT_CITYSTATE_ALLY,
	ACHIEVEMENT_CITYSTATE_ANNEX,
	ACHIEVEMENT_BUILD_WONDER,
	ACHIEVEMENT_UNIT_UPGRADE,
	ACHIEVEMENT_UNIT_PROMOTE,
	ACHIEVEMENT_DESTROY_CIV,
	ACHIEVEMENT_SECOND_CITY,
	ACHIEVEMENT_ANCIENT_RUIN,
	ACHIEVEMENT_UNIT_20BATTLES,
	ACHIEVEMENT_ALL_TECHS,
	ACHIEVEMENT_ALL_WONDERS,
	ACHIEVEMENT_ALL_SOCIAL_POLICIES,
	ACHIEVEMENT_ALL_UNITS,
	ACHIEVEMENT_GOLDEN_AGE,
	ACHIEVEMENT_CITY_100CULTURE,
	ACHIEVEMENT_CITY_100SCIENCE,
	ACHIEVEMENT_CITY_100GOLD,
	ACHIEVEMENT_PURCHASE_1000TILES,
	ACHIEVEMENT_ONEHITKILL,
	ACHIEVEMENT_ALL_WAR,
	ACHIEVEMENT_UNIT_EMBARK,
	ACHIEVEMENT_100CAMPS,
	ACHIEVEMENT_PEACEFULPLAY,
	ACHIEVEMENT_SUCK_AT_WONDERS,
	ACHIEVEMENT_ONECITY,
	ACHIEVEMENT_VICTORY_SPACE,
	ACHIEVEMENT_VICTORY_CULTURE,
	ACHIEVEMENT_VICTORY_DIPLO,
	ACHIEVEMENT_VICTORY_DOMINATION,
	ACHIEVEMENT_VICTORY_ALL,
	ACHIEVEMENT_DROP_NUKE,
	ACHIEVEMENT_LOSE_MULTIPLAYER,
	ACHIEVEMENT_SIX_DEGREES,
	ACHIEVEMENT_EXPERIMENTER,
	ACHIEVEMENT_EXPANSIONIST,
	ACHIEVEMENT_CONNOISSEUR,
	ACHIEVEMENT_POLICY_LIBERTY,
	ACHIEVEMENT_POLICY_PIETY,
	ACHIEVEMENT_POLICY_AUTOCRACY,
	ACHIEVEMENT_POLICY_ORDER,
	ACHIEVEMENT_POLICY_TRADITION,
	ACHIEVEMENT_POLICY_HONOR,
	ACHIEVEMENT_POLICY_PATRONAGE,
	ACHIEVEMENT_POLICY_COMMERCE,
	ACHIEVEMENT_POLICY_RATIONALISM,
	ACHIEVEMENT_POLICY_FREEDOM,
	ACHIEVEMENT_ALL_NATURALWONDER,
	ACHIEVEMENT_DEFPACT,
	ACHIEVEMENT_RESEARCHPACT,
	ACHIEVEMENT_1000ROADS,
	ACHIEVEMENT_1000MINES,
	ACHIEVEMENT_100RESOURCES,
	ACHIEVEMENT_1000TILES,
	ACHIEVEMENT_ROUND_WORLD,
	ACHIEVEMENT_1000FOREST,
	ACHIEVEMENT_1000TEMPLES,

	ACHIEVEMENT_SPECIAL_B17,
	ACHIEVEMENT_SPECIAL_TRADER,
	ACHIEVEMENT_SPECIAL_GARDENS,
	ACHIEVEMENT_SPECIAL_SPHINX,
	ACHIEVEMENT_SPECIAL_MUSKETEERS,
	ACHIEVEMENT_SPECIAL_LONGHOUSE,
	ACHIEVEMENT_SPECIAL_BOLLYWOOD,
	ACHIEVEMENT_SPECIAL_KAMIKAZE,
	ACHIEVEMENT_SPECIAL_ARCHAEMENNID,
	ACHIEVEMENT_SPECIAL_ROMANROADS,
	ACHIEVEMENT_SPECIAL_ELEPHANTBATTLE,
	ACHIEVEMENT_SPECIAL_SUNTZU,
	ACHIEVEMENT_SPECIAL_BARBARIANWARLORD,
	ACHIEVEMENT_SPECIAL_BARBARYPIRATE,
	ACHIEVEMENT_SPECIAL_TOMBRAIDER,
	ACHIEVEMENT_SPECIAL_WARCANOE,
	ACHIEVEMENT_SPECIAL_PONY,
	ACHIEVEMENT_SPECIAL_ARMADA,
	ACHIEVEMENT_SPECIAL_CONQUEST_WORLD,

	ACHIEVEMENT_CIVILOPEDIA,
	ACHIEVEMENT_REALLY_SUCK,
	ACHIEVEMENT_PSG,

	//DLC_DELUXE
	ACHIEVEMENT_WIN_NEBUCHADNEZZAR,
	
	//DLC_01
	ACHIEVEMENT_WIN_GENGHIS,
	ACHIEVEMENT_WIN_SCENARIO_01_PRINCE_OR_BELOW,
	ACHIEVEMENT_WIN_SCENARIO_01_KING,
	ACHIEVEMENT_WIN_SCENARIO_01_EMPEROR,
	ACHIEVEMENT_WIN_SCENARIO_01_IMMORTAL,
	ACHIEVEMENT_WIN_SCENARIO_01_DEITY,
	ACHIEVEMENT_LOSE_SCENARIO_01,

	//DLC_02
	ACHIEVEMENT_WIN_ISABELLA,
	ACHIEVEMENT_WIN_PACHACUTI,
	ACHIEVEMENT_SCENARIO_02_WIN_SPAIN,
	ACHIEVEMENT_SCENARIO_02_WIN_FRANCE,
	ACHIEVEMENT_SCENARIO_02_WIN_ENGLAND,
	ACHIEVEMENT_SCENARIO_02_WIN_INCA,
	ACHIEVEMENT_SCENARIO_02_WIN_AZTECS,
	ACHIEVEMENT_SCENARIO_02_WIN_IROQUOIS,
	ACHIEVEMENT_SCENARIO_02_ROUTE_TO_ORIENT,
	ACHIEVEMENT_SCENARIO_02_DISCOVER_FOUNTAIN,
	ACHIEVEMENT_SCENARIO_02_DISCOVER_EL_DORADO,
	ACHIEVEMENT_SCENARIO_02_RETURN_TREASURE,
	
	//DLC_03
	ACHIEVEMENT_WIN_KAMEHAMEHA,
	ACHIEVEMENT_SCENARIO_03_WIN_HIVA,
	ACHIEVEMENT_SCENARIO_03_WIN_TAHITI,
	ACHIEVEMENT_SCENARIO_03_WIN_SAMOA,
	ACHIEVEMENT_SCENARIO_03_WIN_TONGA,
	ACHIEVEMENT_SCENARIO_03_FIND_HAWAII,
	ACHIEVEMENT_SCENARIO_03_FIND_EASTER_ISLAND,
	ACHIEVEMENT_SCENARIO_03_FIND_CAPTAIN_COOK,
	ACHIEVEMENT_SCENARIO_03_FIND_AUSTRALIA,
	ACHIEVEMENT_SCENARIO_03_FIND_NEW_ZEALAND,

	//DLC_04
	ACHIEVEMENT_WIN_BLUETOOTH,
	ACHIEVEMENT_SCENARIO_04_BIATHLON,
	ACHIEVEMENT_SCENARIO_04_PILLAGE,
	ACHIEVEMENT_SCENARIO_04_NORMANDY,
	ACHIEVEMENT_SCENARIO_04_WIN_DENMARK,
	ACHIEVEMENT_SCENARIO_04_WIN_NORWAY,
	ACHIEVEMENT_SCENARIO_04_WIN_ENGLAND,
	ACHIEVEMENT_SCENARIO_04_BUILD_MOTTE,
	ACHIEVEMENT_SCENARIO_04_WIN_EMPEROR,
	ACHIEVEMENT_SCENARIO_04_WIN_IMMORTAL,
	ACHIEVEMENT_SCENARIO_04_WIN_DEITY,

	//DLC_05
	ACHIEVEMENT_WIN_SEJONG,
	ACHIEVEMENT_SPECIAL_IRONCLAD_TURTLE,
	ACHIEVEMENT_SPECIAL_HWATCH_OUT,
	ACHIEVEMENT_SCENARIO_05_WIN_JAPAN,
	ACHIEVEMENT_SCENARIO_05_WIN_KOREA,
	ACHIEVEMENT_SCENARIO_05_WIN_CHINA,
	ACHIEVEMENT_SCENARIO_05_WIN_MANCHU,
	ACHIEVEMENT_SCENARIO_05_LOSE_KOREA,
	ACHIEVEMENT_SCENARIO_05_WIN_EMPEROR,
	ACHIEVEMENT_SCENARIO_05_WIN_IMMORTAL,
	ACHIEVEMENT_SCENARIO_05_WIN_DEITY,
	ACHIEVEMENT_SCENARIO_05_WIN_100TURNS,
	ACHIEVEMENT_SCENARIO_05_QING_TAKES_MING,

	//DLC_06
	ACHIEVEMENT_SPECIAL_ROME_GETS_ZEUS,
	ACHIEVEMENT_SPECIAL_ZEUS_AND_ARTEMIS,
	ACHIEVEMENT_SPECIAL_HALICARNASSUS_GOLD,
	ACHIEVEMENT_SPECIAL_ANCIENT_WONDERS,
	ACHIEVEMENT_SCENARIO_06_WIN_HITTITES,
	ACHIEVEMENT_SCENARIO_06_WIN_GREECE,
	ACHIEVEMENT_SCENARIO_06_WIN_SUMER,
	ACHIEVEMENT_SCENARIO_06_WIN_EGYPT,
	ACHIEVEMENT_SCENARIO_06_WIN_PERSIA,
	ACHIEVEMENT_SCENARIO_06_WIN_PRINCE,
	ACHIEVEMENT_SCENARIO_06_WIN_KING,
	ACHIEVEMENT_SCENARIO_06_WIN_EMPEROR,
	ACHIEVEMENT_SCENARIO_06_WIN_IMMORTAL,
	ACHIEVEMENT_SCENARIO_06_WIN_DEITY,
	ACHIEVEMENT_SCENARIO_06_WONDER_CITY,
	ACHIEVEMENT_SCENARIO_06_WONDER_CONQUEST,
	ACHIEVEMENT_SCENARIO_06_ORACLE_CONSULT,

	//Expansion 1
	ACHIEVEMENT_XP1_01,
	ACHIEVEMENT_XP1_02,
	ACHIEVEMENT_XP1_03,
	ACHIEVEMENT_XP1_04,
	ACHIEVEMENT_XP1_05,
	ACHIEVEMENT_XP1_06,
	ACHIEVEMENT_XP1_07,
	ACHIEVEMENT_XP1_08,
	ACHIEVEMENT_XP1_09,
	ACHIEVEMENT_XP1_10,
	ACHIEVEMENT_XP1_11,
	ACHIEVEMENT_XP1_12,
	ACHIEVEMENT_XP1_13,
	ACHIEVEMENT_XP1_14,
	ACHIEVEMENT_XP1_15,
	ACHIEVEMENT_XP1_16,
	ACHIEVEMENT_XP1_17,
	ACHIEVEMENT_XP1_18,
	ACHIEVEMENT_XP1_19,
	ACHIEVEMENT_XP1_20,
	ACHIEVEMENT_XP1_21,
	ACHIEVEMENT_XP1_22,
	ACHIEVEMENT_XP1_23,
	ACHIEVEMENT_XP1_24,
	ACHIEVEMENT_XP1_25,
	ACHIEVEMENT_XP1_26,
	ACHIEVEMENT_XP1_27,
	ACHIEVEMENT_XP1_28,
	ACHIEVEMENT_XP1_29,
	ACHIEVEMENT_XP1_30,
	ACHIEVEMENT_XP1_31,
	ACHIEVEMENT_XP1_32,
	ACHIEVEMENT_XP1_33,
	ACHIEVEMENT_XP1_34,
	ACHIEVEMENT_XP1_35,
	ACHIEVEMENT_XP1_36,
	ACHIEVEMENT_XP1_37,
	ACHIEVEMENT_XP1_38,
	ACHIEVEMENT_XP1_39,
	ACHIEVEMENT_XP1_40,
	ACHIEVEMENT_XP1_41,
	ACHIEVEMENT_XP1_42,
	ACHIEVEMENT_XP1_43,
	ACHIEVEMENT_XP1_44,
	ACHIEVEMENT_XP1_45,
	ACHIEVEMENT_XP1_46,
	ACHIEVEMENT_XP1_47,
	ACHIEVEMENT_XP1_48,
	ACHIEVEMENT_XP1_49,
	ACHIEVEMENT_XP1_50,
	ACHIEVEMENT_XP1_51,
	ACHIEVEMENT_XP1_52,

	//Expansion 2
	ACHIEVEMENT_XP2_01,
	ACHIEVEMENT_XP2_02,
	ACHIEVEMENT_XP2_03,
	ACHIEVEMENT_XP2_04,
	ACHIEVEMENT_XP2_05,
	ACHIEVEMENT_XP2_06,
	ACHIEVEMENT_XP2_07,
	ACHIEVEMENT_XP2_08,
	ACHIEVEMENT_XP2_09,
	ACHIEVEMENT_XP2_10,
	ACHIEVEMENT_XP2_11,
	ACHIEVEMENT_XP2_12,
	ACHIEVEMENT_XP2_13,
	ACHIEVEMENT_XP2_14,
	ACHIEVEMENT_XP2_15,
	ACHIEVEMENT_XP2_16,
	ACHIEVEMENT_XP2_17,
	ACHIEVEMENT_XP2_18,
	ACHIEVEMENT_XP2_19,
	ACHIEVEMENT_XP2_20,
	ACHIEVEMENT_XP2_21,
	ACHIEVEMENT_XP2_22,
	ACHIEVEMENT_XP2_23,
	ACHIEVEMENT_XP2_24,
	ACHIEVEMENT_XP2_25,
	ACHIEVEMENT_XP2_26,
	ACHIEVEMENT_XP2_27,
	ACHIEVEMENT_XP2_28,
	ACHIEVEMENT_XP2_29,
	ACHIEVEMENT_XP2_30,
	ACHIEVEMENT_XP2_31,
	ACHIEVEMENT_XP2_32,
	ACHIEVEMENT_XP2_33,
	ACHIEVEMENT_XP2_34,
	ACHIEVEMENT_XP2_35,
	ACHIEVEMENT_XP2_36,
	ACHIEVEMENT_XP2_37,
	ACHIEVEMENT_XP2_38,
	ACHIEVEMENT_XP2_39,
	ACHIEVEMENT_XP2_40,
	ACHIEVEMENT_XP2_41,
	ACHIEVEMENT_XP2_42,
	ACHIEVEMENT_XP2_43,
	ACHIEVEMENT_XP2_44,
	ACHIEVEMENT_XP2_45,
	ACHIEVEMENT_XP2_46,
	ACHIEVEMENT_XP2_47,
	ACHIEVEMENT_XP2_48,
	ACHIEVEMENT_XP2_49,
	ACHIEVEMENT_XP2_50,
	ACHIEVEMENT_XP2_51,
	ACHIEVEMENT_XP2_52,
	ACHIEVEMENT_XP2_53,
	ACHIEVEMENT_XP2_54,
	ACHIEVEMENT_XP2_55,
	ACHIEVEMENT_XP2_56,
	ACHIEVEMENT_XP2_57,
	ACHIEVEMENT_XP2_58,
	ACHIEVEMENT_XP2_59,
	ACHIEVEMENT_XP2_60,



	NUM_ACHIEVEMENTS
};

enum ESteamStat
{
	ESTEAMSTAT_TOTAL_WINS,

	ESTEAMSTAT_ARCHER,
	ESTEAMSTAT_CHARIOTARCHER,
	ESTEAMSTAT_HOPLITE,
	ESTEAMSTAT_IMMORTAL,
	ESTEAMSTAT_JAGUAR,
	ESTEAMSTAT_SCOUT,
	ESTEAMSTAT_SETTLER,
	ESTEAMSTAT_SPEARMAN,
	ESTEAMSTAT_TRIREME,
	ESTEAMSTAT_WARCHARIOT,
	ESTEAMSTAT_WARELEPHANT,
	ESTEAMSTAT_WARRIOR,
	ESTEAMSTAT_WORKBOAT,
	ESTEAMSTAT_WORKER,
	ESTEAMSTAT_BALLISTA,
	ESTEAMSTAT_CATAPULT,
	ESTEAMSTAT_COMPANIONCAVALRY,
	ESTEAMSTAT_HORSEMAN,
	ESTEAMSTAT_LEGION,
	ESTEAMSTAT_MOHAWKWARRIOR,
	ESTEAMSTAT_SWORDSMAN,
	ESTEAMSTAT_CAMELARCHER,
	ESTEAMSTAT_CHUKONU,
	ESTEAMSTAT_CROSSBOWMAN,
	ESTEAMSTAT_KNIGHT,
	ESTEAMSTAT_LANDSKNECHT,
	ESTEAMSTAT_LONGBOWMAN,
	ESTEAMSTAT_LONGSWORDSMAN,
	ESTEAMSTAT_MANDEKALUCAVALRY,
	ESTEAMSTAT_PIKEMAN,
	ESTEAMSTAT_NARESUANSELEPHANT,
	ESTEAMSTAT_SAMURAI,
	ESTEAMSTAT_TREBUCHET,
	ESTEAMSTAT_CANNON,
	ESTEAMSTAT_CARAVEL,
	ESTEAMSTAT_COSSACK,
	ESTEAMSTAT_FRIGATE,
	ESTEAMSTAT_JANISSARY,
	ESTEAMSTAT_LANCER,
	ESTEAMSTAT_MINUTEMAN,
	ESTEAMSTAT_MUSKETEER,
	ESTEAMSTAT_MUSKETMAN,
	ESTEAMSTAT_RIFLEMAN,
	ESTEAMSTAT_SHIPOFTHELINE,
	ESTEAMSTAT_SIPAHI,
	ESTEAMSTAT_ANTIAIRCRAFTGUN,
	ESTEAMSTAT_ANTITANKGUN,
	ESTEAMSTAT_ARTILLERY,
	ESTEAMSTAT_BATTLESHIP,
	ESTEAMSTAT_CARRIER,
	ESTEAMSTAT_DESTROYER,
	ESTEAMSTAT_FIGHTER,
	ESTEAMSTAT_FOREIGNLEGION,
	ESTEAMSTAT_INFANTRY,
	ESTEAMSTAT_IRONCLAD,
	ESTEAMSTAT_PANZER,
	ESTEAMSTAT_SUBMARINE,
	ESTEAMSTAT_TANK,
	ESTEAMSTAT_ZERO,
	ESTEAMSTAT_ATOMICBOMB,
	ESTEAMSTAT_B17,
	ESTEAMSTAT_BOMBER,
	ESTEAMSTAT_GUIDEDMISSILE,
	ESTEAMSTAT_HELICOPTERGUNSHIP,
	ESTEAMSTAT_JETFIGHTER,
	ESTEAMSTAT_MECHANIZEDINFANTRY,
	ESTEAMSTAT_MISSILECRUISER,
	ESTEAMSTAT_MOBILESAM,
	ESTEAMSTAT_MODERNARMOR,
	ESTEAMSTAT_NUCLEARMISSILE,
	ESTEAMSTAT_NUCLEARSUBMARINE,
	ESTEAMSTAT_PARATROOPER,
	ESTEAMSTAT_ROCKETARTILLERY,
	ESTEAMSTAT_SSBOOSTER,
	ESTEAMSTAT_SSCOCKPIT,
	ESTEAMSTAT_STEALTHBOMBER,
	ESTEAMSTAT_GIANTDEATHROBOT,
	ESTEAMSTAT_SSENGINE,
	ESTEAMSTAT_SSSTASISCHAMBER,

	ESTEAMSTAT_ANGKORWAT,
	ESTEAMSTAT_BIGBEN,
	ESTEAMSTAT_BRANDENBURGGATE,
	ESTEAMSTAT_CHICHENITZA,
	ESTEAMSTAT_CRISTOREDENTOR,
	ESTEAMSTAT_EIFFELTOWER,
	ESTEAMSTAT_HIMEJICASTLE,
	ESTEAMSTAT_MACHUPICCHU,
	ESTEAMSTAT_NOTREDAME,
	ESTEAMSTAT_PENTAGON,
	ESTEAMSTAT_SISTINECHAPEL,
	ESTEAMSTAT_STATUEOFLIBERTY,
	ESTEAMSTAT_STONEHENGE,
	ESTEAMSTAT_SYDNEYOPERAHOUSE,
	ESTEAMSTAT_TAJMAHAL,
	ESTEAMSTAT_COLOSSUS,
	ESTEAMSTAT_FORBIDDENPALACE,
	ESTEAMSTAT_GREATLIBRARY,
	ESTEAMSTAT_GREATLIGHTHOUSE,
	ESTEAMSTAT_GREATWALL,
	ESTEAMSTAT_HAGIASOPHIA,
	ESTEAMSTAT_HANGINGGARDENS,
	ESTEAMSTAT_KREMLIN,
	ESTEAMSTAT_LOUVRE,
	ESTEAMSTAT_ORACLE,
	ESTEAMSTAT_PORCELAINTOWER,
	ESTEAMSTAT_PYRAMIDS,
	ESTEAMSTAT_UNITEDNATION,
	ESTEAMSTAT_HERMITAGE,
	ESTEAMSTAT_HEROICEPIC,
	ESTEAMSTAT_IRONWORKS,
	ESTEAMSTAT_NATIONALCOLLEGE,
	ESTEAMSTAT_NATIONALEPIC,
	ESTEAMSTAT_OXFORDUNIVERSITY,

	ESTEAMSTAT_BARBARIANCAMPS,
	ESTEAMSTAT_BEATWONDERS,
	ESTEAMSTAT_NATURALWONDERS,
	ESTEAMSTAT_ROADS,
	ESTEAMSTAT_MINES,
	ESTEAMSTAT_RESOURCESTRADED,
	ESTEAMSTAT_FORESTS,
	ESTEAMSTAT_TEMPLES,
	ESTEAMSTAT_PEDIA,
	ESTEAMSTAT_GREATGENERALS,
	ESTEAMSTAT_STANDINGARMY,

	ESTEAMSTAT_CAVALRY,

	ESTEAMSTAT_TILESPURCHASED,
	ESTEAMSTAT_TILESDISCOVERED,
	ESTEAMSTAT_BARBSCONVERTED,
	ESTEAMSTAT_BRITISHNAVY,
	ESTEAMSTAT_BARBSNAVALCONVERTED,

	//DLC_05
	ESTEAMSTAT_HWACHAKILLS,
	
	//DLC_06
	ESTEAMSTAT_STATUEOFZEUS,
	ESTEAMSTAT_TEMPLEOFARTEMIS,
	ESTEAMSTAT_MAUSOLEUMOFHALICARNASSUS,
	ESTEAMSTAT_HALICARNASSUSGOLDEARNED,

	//Expansion 1
	ESTEAMSTAT_BULLIEDGOLD,

	NUM_STEAM_STATS
};

enum AdvisorTypes
{
	NO_ADVISOR_TYPE = -1,

	ADVISOR_MILITARY,
	ADVISOR_ECONOMIC,
	ADVISOR_FOREIGN,
	ADVISOR_SCIENCE,
	NUM_ADVISOR_TYPES
};

enum GenericWorldAnchorTypes
{
	NO_WORLD_ANCHOR = -1,

	WORLD_ANCHOR_NATURAL_WONDER,
	WORLD_ANCHOR_SETTLER,
	WORLD_ANCHOR_WORKER,
	
	NUM_WORLD_ANCHORS
};

enum GreatPeopleDirectiveTypes
{
	NO_GREAT_PEOPLE_DIRECTIVE_TYPE = -1,

	GREAT_PEOPLE_DIRECTIVE_GOLDEN_AGE,
	GREAT_PEOPLE_DIRECTIVE_USE_POWER,
	GREAT_PEOPLE_DIRECTIVE_CONSTRUCT_IMPROVEMENT,
	GREAT_PEOPLE_DIRECTIVE_SPREAD_RELIGION,
	GREAT_PEOPLE_DIRECTIVE_CULTURE_BLAST,
	GREAT_PEOPLE_DIRECTIVE_TOURISM_BLAST,

	NUM_GREAT_PEOPLE_DIRECTIVES
};

enum CombatPredictionTypes
{
	NO_COMBAT_PREDICTION = -1,
	COMBAT_PREDICTION_RANGED,
	COMBAT_PREDICTION_STALEMATE,
	COMBAT_PREDICTION_TOTAL_DEFEAT,
	COMBAT_PREDICTION_TOTAL_VICTORY,
	COMBAT_PREDICTION_MAJOR_VICTORY,
	COMBAT_PREDICTION_SMALL_VICTORY,
	COMBAT_PREDICTION_MAJOR_DEFEAT,
	COMBAT_PREDICTION_SMALL_DEFEAT,
	NUM_COMBAT_PREDICTIONS
};

enum CivilianAttackPriorityTypes			
{
	NO_CIVILIAN_ATTACK_PRIORITY = -1,

	CIVILIAN_ATTACK_PRIORITY_HIGH,
	CIVILIAN_ATTACK_PRIORITY_HIGH_EARLY_GAME_ONLY,
	CIVILIAN_ATTACK_PRIORITY_LOW,

	NUM_CIVILIAN_ATTACK_PRIORITY_TYPES
};

enum GameExecutableTypes
{
	CIV5_CORE_RELEASE,
	CIV5_EXPANSION_1,
	CIV5_EXPANSION_2,
	CIV5_EXPANSION_3,
};

enum RandLoggingFlags
{
	RAND_LOGGING_ON = (1 << 0),
	RAND_LOGGING_CALLSTACK_FLAG = (1 << 1),
	RAND_LOGGING_PREGAME_FLAG = (1 << 2),
	RAND_LOGGING_ASYNCHRONOUS_FLAG = (1 << 3)
};

enum StorageLocation
{
	STORAGE_LOCAL,
	STORAGE_STEAM_CLOUD,
	STORAGE_MEMORY
};

enum FaithPurchaseTypes
{
	NO_AUTOMATIC_FAITH_PURCHASE,
	FAITH_PURCHASE_SAVE_PROPHET,
	FAITH_PURCHASE_BUILDING,
	FAITH_PURCHASE_UNIT
};

enum PlotVisibilityChangeResult
{
	VISIBILTY_CHANGE_NONE = 0,
	VISIBILITY_CHANGE_TO_INVISIBLE,
	VISIBILITY_CHANGE_TO_VISIBLE
};

enum TradeConnectionType
{
	TRADE_CONNECTION_INTERNATIONAL,
	TRADE_CONNECTION_FOOD,
	TRADE_CONNECTION_PRODUCTION,
	NUM_TRADE_CONNECTION_TYPES
};

enum GreatWorkArtifactClass
{
	NO_GREAT_WORK_ARTIFACT_CLASS = 0,
};

enum GreatWorkType
{
	NO_GREAT_WORK = -1,
};

enum GreatWorkClass
{
	NO_GREAT_WORK_CLASS = -1,
};

enum GreatWorkSlotType
{
	NO_GREAT_WORK_SLOT = -1,
};

#endif //CVENUMS_H
